/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.translog.BaseTranslogReader;
import org.elasticsearch.index.translog.ChannelFactory;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogHeader;

public class TranslogReader
extends BaseTranslogReader
implements Closeable {
    protected final long length;
    private final int totalOperations;
    private final Checkpoint checkpoint;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    TranslogReader(Checkpoint checkpoint, FileChannel channel, Path path, TranslogHeader header) {
        super(checkpoint.generation, channel, path, header);
        this.length = checkpoint.offset;
        this.totalOperations = checkpoint.numOps;
        this.checkpoint = checkpoint;
    }

    public static TranslogReader open(FileChannel channel, Path path, Checkpoint checkpoint, String translogUUID) throws IOException {
        TranslogHeader header = TranslogHeader.read(translogUUID, path, channel);
        return new TranslogReader(checkpoint, channel, path, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TranslogReader closeIntoTrimmedReader(long aboveSeqNo, ChannelFactory channelFactory) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            FileChannel toCloseOnFailure = this.channel;
            try {
                TranslogReader newReader;
                if (aboveSeqNo < this.checkpoint.trimmedAboveSeqNo || aboveSeqNo < this.checkpoint.maxSeqNo && this.checkpoint.trimmedAboveSeqNo == -2L) {
                    Path checkpointFile = this.path.getParent().resolve(Translog.getCommitCheckpointFileName(this.checkpoint.generation));
                    Checkpoint newCheckpoint = new Checkpoint(this.checkpoint.offset, this.checkpoint.numOps, this.checkpoint.generation, this.checkpoint.minSeqNo, this.checkpoint.maxSeqNo, this.checkpoint.globalCheckpoint, this.checkpoint.minTranslogGeneration, aboveSeqNo);
                    Checkpoint.write(channelFactory, checkpointFile, newCheckpoint, StandardOpenOption.WRITE);
                    IOUtils.fsync(checkpointFile, false);
                    IOUtils.fsync(checkpointFile.getParent(), true);
                    newReader = new TranslogReader(newCheckpoint, this.channel, this.path, this.header);
                } else {
                    newReader = new TranslogReader(this.checkpoint, this.channel, this.path, this.header);
                }
                toCloseOnFailure = null;
                TranslogReader translogReader = newReader;
                return translogReader;
            }
            finally {
                IOUtils.close((Closeable)toCloseOnFailure);
            }
        }
        throw new AlreadyClosedException(this.toString() + " is already closed");
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    final Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        if (position >= this.length) {
            throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "]");
        }
        if (position < this.getFirstOperationOffset()) {
            throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.getFirstOperationOffset() + "]");
        }
        Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.close();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException(this.toString() + " is already closed");
        }
    }
}

