/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class IndexShardSnapshotStatus {
    private final AtomicReference<Stage> stage;
    private final AtomicReference<String> generation;
    private long startTime;
    private long totalTime;
    private int incrementalFileCount;
    private int totalFileCount;
    private int processedFileCount;
    private long totalSize;
    private long incrementalSize;
    private long processedSize;
    private long indexVersion;
    private String failure;

    private IndexShardSnapshotStatus(Stage stage, long startTime, long totalTime, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize, String failure, String generation) {
        this.stage = new AtomicReference<Stage>(Objects.requireNonNull(stage));
        this.generation = new AtomicReference<String>(generation);
        this.startTime = startTime;
        this.totalTime = totalTime;
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.processedFileCount = processedFileCount;
        this.totalSize = totalSize;
        this.processedSize = processedSize;
        this.incrementalSize = incrementalSize;
        this.failure = failure;
    }

    public synchronized Copy moveToStarted(long startTime, int incrementalFileCount, int totalFileCount, long incrementalSize, long totalSize) {
        if (!this.stage.compareAndSet(Stage.INIT, Stage.STARTED)) {
            throw new IllegalStateException("Unable to move the shard snapshot status to [STARTED]: expecting [INIT] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.startTime = startTime;
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.incrementalSize = incrementalSize;
        this.totalSize = totalSize;
        return this.asCopy();
    }

    public synchronized Copy moveToFinalize(long indexVersion) {
        if (!this.stage.compareAndSet(Stage.STARTED, Stage.FINALIZE)) {
            throw new IllegalStateException("Unable to move the shard snapshot status to [FINALIZE]: expecting [STARTED] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.indexVersion = indexVersion;
        return this.asCopy();
    }

    public synchronized void moveToDone(long endTime, String newGeneration) {
        assert (newGeneration != null);
        if (!this.stage.compareAndSet(Stage.FINALIZE, Stage.DONE)) {
            throw new IllegalStateException("Unable to move the shard snapshot status to [DONE]: expecting [FINALIZE] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.totalTime = Math.max(0L, endTime - this.startTime);
        this.generation.set(newGeneration);
    }

    public synchronized void abortIfNotCompleted(String failure) {
        if (this.stage.compareAndSet(Stage.INIT, Stage.ABORTED) || this.stage.compareAndSet(Stage.STARTED, Stage.ABORTED)) {
            this.failure = failure;
        }
    }

    public synchronized void moveToFailed(long endTime, String failure) {
        if (this.stage.getAndSet(Stage.FAILURE) != Stage.FAILURE) {
            this.totalTime = Math.max(0L, endTime - this.startTime);
            this.failure = failure;
        }
    }

    public String generation() {
        return this.generation.get();
    }

    public boolean isAborted() {
        return this.stage.get() == Stage.ABORTED;
    }

    public synchronized void addProcessedFile(long size) {
        ++this.processedFileCount;
        this.processedSize += size;
    }

    public synchronized Copy asCopy() {
        return new Copy(this.stage.get(), this.startTime, this.totalTime, this.incrementalFileCount, this.totalFileCount, this.processedFileCount, this.incrementalSize, this.totalSize, this.processedSize, this.indexVersion, this.failure);
    }

    public static IndexShardSnapshotStatus newInitializing(String generation) {
        return new IndexShardSnapshotStatus(Stage.INIT, 0L, 0L, 0, 0, 0, 0L, 0L, 0L, null, generation);
    }

    public static IndexShardSnapshotStatus newFailed(String failure) {
        assert (failure != null) : "expecting non null failure for a failed IndexShardSnapshotStatus";
        if (failure == null) {
            throw new IllegalArgumentException("A failure description is required for a failed IndexShardSnapshotStatus");
        }
        return new IndexShardSnapshotStatus(Stage.FAILURE, 0L, 0L, 0, 0, 0, 0L, 0L, 0L, failure, null);
    }

    public static IndexShardSnapshotStatus newDone(long startTime, long totalTime, int incrementalFileCount, int fileCount, long incrementalSize, long size, String generation) {
        return new IndexShardSnapshotStatus(Stage.DONE, startTime, totalTime, incrementalFileCount, fileCount, incrementalFileCount, incrementalSize, size, incrementalSize, null, generation);
    }

    public static class Copy {
        private final Stage stage;
        private final long startTime;
        private final long totalTime;
        private final int incrementalFileCount;
        private final int totalFileCount;
        private final int processedFileCount;
        private final long totalSize;
        private final long processedSize;
        private final long incrementalSize;
        private final long indexVersion;
        private final String failure;

        public Copy(Stage stage, long startTime, long totalTime, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize, long indexVersion, String failure) {
            this.stage = stage;
            this.startTime = startTime;
            this.totalTime = totalTime;
            this.incrementalFileCount = incrementalFileCount;
            this.totalFileCount = totalFileCount;
            this.processedFileCount = processedFileCount;
            this.totalSize = totalSize;
            this.processedSize = processedSize;
            this.incrementalSize = incrementalSize;
            this.indexVersion = indexVersion;
            this.failure = failure;
        }

        public Stage getStage() {
            return this.stage;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public int getIncrementalFileCount() {
            return this.incrementalFileCount;
        }

        public int getTotalFileCount() {
            return this.totalFileCount;
        }

        public int getProcessedFileCount() {
            return this.processedFileCount;
        }

        public long getIncrementalSize() {
            return this.incrementalSize;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getProcessedSize() {
            return this.processedSize;
        }

        public long getIndexVersion() {
            return this.indexVersion;
        }

        public String getFailure() {
            return this.failure;
        }

        public String toString() {
            return "index shard snapshot status (stage=" + (Object)((Object)this.stage) + ", startTime=" + this.startTime + ", totalTime=" + this.totalTime + ", incrementalFileCount=" + this.incrementalFileCount + ", totalFileCount=" + this.totalFileCount + ", processedFileCount=" + this.processedFileCount + ", incrementalSize=" + this.incrementalSize + ", totalSize=" + this.totalSize + ", processedSize=" + this.processedSize + ", indexVersion=" + this.indexVersion + ", failure='" + this.failure + '\'' + ')';
        }
    }

    public static enum Stage {
        INIT,
        STARTED,
        FINALIZE,
        DONE,
        FAILURE,
        ABORTED;

    }
}

