/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.componentreport;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.api.componentreport.ComponentReport;
import org.sonatype.ossindex.service.api.componentreport.ComponentReportRequest;

@Path(value="/api/v3/component-report")
@Api(value="Component vulnerability reports", authorizations={@Authorization(value="basicAuth"), @Authorization(value="apiToken")})
public interface ComponentReportEndpoint {
    @GET
    @Path(value="{coordinates:.*}")
    @Produces(value={"application/vnd.ossindex.component-report.v1+json", "application/json"})
    @ApiOperation(value="Request vulnerability report for component", hidden=true)
    @ApiResponses(value={@ApiResponse(code=200, message="Vulnerability report for component"), @ApiResponse(code=404, message="Component not found"), @ApiResponse(code=400, message="Missing coordinates version"), @ApiResponse(code=429, message="Too many requests")})
    public ComponentReport get(@Encoded @PathParam(value="coordinates") @ApiParam(value="Coordinates as package-url") PackageUrl var1);

    @POST
    @Consumes(value={"application/vnd.ossindex.component-report-request.v1+json", "application/json"})
    @Produces(value={"application/vnd.ossindex.component-report.v1+json", "application/json"})
    @ApiOperation(value="Request vulnerability reports for components")
    @ApiResponses(value={@ApiResponse(code=200, message="Vulnerability report for components"), @ApiResponse(code=400, message="Request for too many components"), @ApiResponse(code=400, message="One or more coordinates required"), @ApiResponse(code=400, message="Missing coordinates version"), @ApiResponse(code=429, message="Too many requests")})
    public List<ComponentReport> post(ComponentReportRequest var1);
}

