/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.marshal;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.client.marshal.Marshaller;

public class GsonMarshaller
implements Marshaller {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(PackageUrl.class, (Object)new PackageUrlAdapter()).create();

    @Override
    public String marshal(Object value) throws IOException {
        Preconditions.checkNotNull((Object)value);
        try {
            return this.gson.toJson(value);
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void marshal(Object value, Writer writer) throws IOException {
        Preconditions.checkNotNull((Object)value);
        try {
            this.gson.toJson(value, (Appendable)writer);
            writer.flush();
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T unmarshal(String value, Class<T> type) throws IOException {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(type);
        try {
            return (T)this.gson.fromJson(value, type);
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T unmarshal(String value, TypeToken<T> type) throws IOException {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(type);
        try {
            return (T)this.gson.fromJson(value, type.getType());
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T unmarshal(Reader reader, Class<T> type) throws IOException {
        Preconditions.checkNotNull((Object)reader);
        Preconditions.checkNotNull(type);
        try {
            return (T)this.gson.fromJson(reader, type);
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T unmarshal(Reader reader, TypeToken<T> type) throws IOException {
        Preconditions.checkNotNull((Object)reader);
        Preconditions.checkNotNull(type);
        try {
            return (T)this.gson.fromJson(reader, type.getType());
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    private static class PackageUrlAdapter
    implements JsonDeserializer<PackageUrl>,
    JsonSerializer<PackageUrl> {
        private PackageUrlAdapter() {
        }

        public PackageUrl deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return PackageUrl.parse((String)element.getAsString());
        }

        public JsonElement serialize(PackageUrl value, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(value.toString());
        }
    }
}

