/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.BrowserHandler;
import com.cookiecadger.CaptureHandler;
import com.cookiecadger.EnhancedJList;
import com.cookiecadger.EnhancedJListItem;
import com.cookiecadger.EnhancedJTextField;
import com.cookiecadger.EnhancedListModel;
import com.cookiecadger.ReplayDialog;
import com.cookiecadger.SettingsDialog;
import com.cookiecadger.SortedListModel;
import com.cookiecadger.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CookieCadgerFrame
extends JFrame {
    private JPanel contentPane;
    private JPanel requestsPanel;
    private JPanel sessionsPanel;
    public EnhancedListModel clientsListModel;
    public EnhancedListModel domainsListModel;
    public EnhancedListModel requestsListModel;
    public EnhancedListModel sessionsListModel;
    private DefaultComboBoxModel<String> interfacesListModel;
    public EnhancedJList clientsList;
    public EnhancedJList domainsList;
    public EnhancedJList requestsList;
    public EnhancedJList sessionsList;
    public EnhancedJTextField txtClientSearch;
    public EnhancedJTextField txtDomainSearch;
    public EnhancedJTextField txtRequestSearch;
    private JTextArea txtConsole;
    public JScrollPane consoleScrollPane;
    private JTabbedPane tabbedPane;
    public JProgressBar loadingRequestProgressBar;
    private HashMap<String, Component> componentMap;
    private JPopupMenu clientsPopup;
    private JPopupMenu domainsPopup;
    private JPopupMenu requestsPopup;
    private JPopupMenu sessionsPopup;
    private CaptureHandler captureHandler;

    public void addConsoleText(String text) {
        if (this.txtConsole.getText().isEmpty()) {
            this.txtConsole.setText(text);
        } else {
            this.txtConsole.append("\n" + text);
        }
        this.txtConsole.setCaretPosition(this.txtConsole.getDocument().getLength());
    }

    private void clearGUI() {
        this.requestsListModel.clear();
        this.domainsListModel.clear();
        this.clientsListModel.clear();
        this.sessionsListModel.clear();
        this.txtClientSearch.setText("");
        this.txtDomainSearch.setText("");
        this.txtRequestSearch.setText("");
    }

    private boolean resetData() {
        int saveDatasetResult;
        if (Utils.dbEngine.equals("sqlite")) {
            saveDatasetResult = JOptionPane.showConfirmDialog(this.contentPane, "Would you like to save the current dataset?", "Save?", 1);
            if (saveDatasetResult == 2) {
                return false;
            }
            if (saveDatasetResult == 0) {
                Utils.dbInstance.saveDatabase();
            }
        } else {
            saveDatasetResult = JOptionPane.showConfirmDialog(this.contentPane, "Would you like to clear all data from the external database?\nTHIS CANNOT BE UNDONE!", "Clear all data?", 0);
            if (saveDatasetResult == 1) {
                return false;
            }
        }
        try {
            Utils.dbInstance.clearTables();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void stopCapture(int ethDevNumber) {
        this.interfacesListModel.removeElementAt(ethDevNumber);
        this.interfacesListModel.insertElementAt(String.valueOf(this.captureHandler.deviceName.get(ethDevNumber)) + " [" + this.captureHandler.deviceDescription.get(ethDevNumber) + "]", ethDevNumber);
        ((JComboBox)this.getComponentByName("interfaceListComboBox")).setSelectedIndex(ethDevNumber);
        if (this.captureHandler.deviceCaptureProcess.get(ethDevNumber) != null) {
            this.captureHandler.deviceCaptureProcess.get(ethDevNumber).destroy();
        }
        this.captureHandler.bCapturing.set(ethDevNumber, false);
        this.setCaptureButtonText();
    }

    private void prepCapture(int ethDevNumber) {
        this.interfacesListModel.removeElementAt(ethDevNumber);
        this.interfacesListModel.insertElementAt(String.valueOf(this.captureHandler.deviceName.get(ethDevNumber)) + " [" + this.captureHandler.deviceDescription.get(ethDevNumber) + "] (CURRENTLY CAPTURING)", ethDevNumber);
        ((JComboBox)this.getComponentByName("interfaceListComboBox")).setSelectedIndex(ethDevNumber);
        this.captureHandler.bCapturing.set(ethDevNumber, true);
        this.setCaptureButtonText();
    }

    private void setCaptureButtonText() {
        int selection = ((JComboBox)this.getComponentByName("interfaceListComboBox")).getSelectedIndex();
        if (selection == -1) {
            ((JButton)this.getComponentByName("btnMonitorOnSelected")).setEnabled(false);
            ((JButton)this.getComponentByName("btnMonitorOnSelected")).setText("Select An Interface");
        } else {
            ((JButton)this.getComponentByName("btnMonitorOnSelected")).setEnabled(true);
            if (this.captureHandler.bCapturing.get(selection).booleanValue()) {
                ((JButton)this.getComponentByName("btnMonitorOnSelected")).setText("Stop Capture on " + this.captureHandler.deviceName.get(selection));
            } else {
                ((JButton)this.getComponentByName("btnMonitorOnSelected")).setText("Start Capture on " + this.captureHandler.deviceName.get(selection));
            }
        }
    }

    private void changeClientsList(boolean bClearFirst) {
        int clients = 0;
        try {
            clients = Utils.dbInstance.getClientCount();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        final int clientCount = clients;
        final boolean bClearListFirst = bClearFirst;
        this.consoleScrollPane.setVisible(false);
        this.loadingRequestProgressBar.setString("Loading client list, please wait... [0 / " + clientCount + "]");
        this.loadingRequestProgressBar.setVisible(true);
        Thread changeClientsListThread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean bPreviousSelection = false;
                String previousSelection = null;
                int recordCount = 0;
                if (!CookieCadgerFrame.this.clientsList.isSelectionEmpty()) {
                    bPreviousSelection = true;
                    previousSelection = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                }
                if (bClearListFirst) {
                    CookieCadgerFrame.this.clientsListModel.clear();
                }
                try {
                    String[] macAddresses;
                    String[] stringArray = macAddresses = Utils.dbInstance.getMacs(((EnhancedJTextField)CookieCadgerFrame.this.getComponentByName("txtClientSearch")).getText());
                    int n = macAddresses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (recordCount % 10 == 0) {
                            final int currentRecord = recordCount;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    (this).CookieCadgerFrame.this.loadingRequestProgressBar.setString("Loading client list, please wait... (" + currentRecord + " / " + clientCount + ")");
                                }
                            });
                        }
                        ++recordCount;
                        if (!CookieCadgerFrame.this.clientsListModel.contains(s)) {
                            int clientID = Utils.dbInstance.getIntegerValue("clients", "id", "mac_address", s);
                            CookieCadgerFrame.this.clientsListModel.addElement(new EnhancedJListItem(clientID, s, null));
                        }
                        CookieCadgerFrame.this.updateDescriptionForMac(s);
                        ++n2;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (bClearListFirst && bPreviousSelection && CookieCadgerFrame.this.clientsListModel.contains(previousSelection)) {
                    int index = CookieCadgerFrame.this.clientsListModel.indexOf(previousSelection);
                    CookieCadgerFrame.this.clientsList.setSelectedValue(CookieCadgerFrame.this.clientsListModel.getElementAt(index), true);
                }
                CookieCadgerFrame.this.loadingRequestProgressBar.setVisible(false);
                CookieCadgerFrame.this.consoleScrollPane.setVisible(true);
            }
        });
        changeClientsListThread.start();
    }

    private void changeDomainsList(String macAddress) {
        boolean bPreviousSelection = false;
        String previousSelection = null;
        if (!this.domainsList.isSelectionEmpty() && ((EnhancedJListItem)this.domainsList.getSelectedValue()).getID() != -1) {
            bPreviousSelection = true;
            previousSelection = ((EnhancedJListItem)this.domainsList.getSelectedValue()).toString();
        }
        this.domainsListModel.clear();
        this.requestsListModel.clear();
        this.domainsListModel.addElement(new EnhancedJListItem(-1, "[ All Domains ]", null));
        try {
            String[] stringArray = Utils.dbInstance.getDomains(macAddress, ((EnhancedJTextField)this.getComponentByName("txtDomainSearch")).getText());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int domainID = Utils.dbInstance.getIntegerValue("domains", "id", "name", s);
                this.domainsListModel.addElement(new EnhancedJListItem(domainID, s, null));
                ++n2;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (bPreviousSelection && this.domainsListModel.contains(previousSelection)) {
            int index = this.domainsListModel.indexOf(previousSelection);
            this.domainsList.setSelectedValue(this.domainsListModel.getElementAt(index), true);
        }
    }

    private void changeRequestsList(String macAddress, String uriHost) {
        boolean bPreviousSelection = false;
        String previousSelection = null;
        if (!this.requestsList.isSelectionEmpty()) {
            bPreviousSelection = true;
            previousSelection = ((EnhancedJListItem)this.requestsList.getSelectedValue()).toString();
        }
        boolean bShowAllDomains = false;
        this.requestsListModel.clear();
        if (uriHost.equals("[ All Domains ]")) {
            bShowAllDomains = true;
            uriHost = "%";
        }
        try {
            ArrayList<ArrayList> requests = Utils.dbInstance.getRequests(macAddress, uriHost, ((EnhancedJTextField)this.getComponentByName("txtRequestSearch")).getText());
            ArrayList ids = requests.get(0);
            ArrayList timerecordeds = requests.get(1);
            ArrayList uris = requests.get(2);
            ArrayList descriptions = requests.get(3);
            int i = 0;
            while (i < ids.size()) {
                long timeStamp = new Long((String)timerecordeds.get(i));
                Date then = new Date(timeStamp * 1000L);
                Date now = new Date();
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
                boolean sameDay = fmt.format(then).equals(fmt.format(now));
                String dateString = sameDay ? DateFormat.getTimeInstance(2).format(then) : DateFormat.getDateTimeInstance(3, 2).format(then);
                int requestID = new Integer((String)ids.get(i));
                String uri = (String)uris.get(i);
                String description = (String)descriptions.get(i);
                if (bShowAllDomains) {
                    int domainID = Utils.dbInstance.getIntegerValue("requests", "domain_id", "id", Integer.toString(requestID));
                    String domain = Utils.dbInstance.getStringValue("domains", "name", "id", Integer.toString(domainID));
                    uri = String.valueOf(domain) + uri;
                }
                EnhancedJListItem requestItem = new EnhancedJListItem(requestID, String.valueOf(dateString) + ": " + uri, description);
                this.requestsListModel.addElement(requestItem);
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (bPreviousSelection && this.requestsListModel.contains(previousSelection)) {
            int index = this.requestsListModel.indexOf(previousSelection);
            this.requestsList.setSelectedValue(this.requestsListModel.getElementAt(index), true);
        }
    }

    public void changeSessionsList(boolean bClearFirst) {
        final boolean bClearListFirst = bClearFirst;
        Thread changeSessionsListThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedImage photo = null;
                if (bClearListFirst) {
                    CookieCadgerFrame.this.sessionsListModel.clear();
                }
                try {
                    EnhancedJListItem[] sessions;
                    EnhancedJListItem[] enhancedJListItemArray = sessions = Utils.dbInstance.getSessions();
                    int n = sessions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EnhancedJListItem item = enhancedJListItemArray[n2];
                        if (!CookieCadgerFrame.this.sessionsListModel.contains(item.getID())) {
                            String profilePhotoUrl = item.getProfileImageUrl();
                            boolean bHaveImage = false;
                            if (profilePhotoUrl != null && !profilePhotoUrl.isEmpty()) {
                                try {
                                    URL url = new URL(profilePhotoUrl);
                                    photo = ImageIO.read(url);
                                    bHaveImage = true;
                                }
                                catch (Exception e) {
                                    bHaveImage = false;
                                }
                            } else {
                                try {
                                    int sessionID = item.getID();
                                    int requestID = Utils.dbInstance.getIntegerValue("sessions", "request_id", "id", Integer.toString(sessionID));
                                    int domainID = Utils.dbInstance.getIntegerValue("requests", "domain_id", "id", Integer.toString(requestID));
                                    String domain = Utils.dbInstance.getStringValue("domains", "name", "id", Integer.toString(domainID));
                                    URL url = new URL("https://www.google.com/s2/favicons?domain=" + domain);
                                    photo = ImageIO.read(url);
                                    photo = Utils.createResizedCopy(photo, 48, 48, true);
                                    bHaveImage = true;
                                }
                                catch (Exception e) {
                                    bHaveImage = false;
                                }
                            }
                            if (bHaveImage) {
                                item.setThumbnail(photo);
                            }
                            CookieCadgerFrame.this.sessionsListModel.addElement(item);
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        changeSessionsListThread.start();
    }

    public void updateDescriptionForMac(String macAddress) {
        if (this.clientsListModel.contains(macAddress)) {
            int location = this.clientsListModel.indexOf(macAddress);
            ((EnhancedJListItem)this.clientsListModel.getElementAt(location)).setDescription(this.generateDescriptionForClient(macAddress, true));
        }
    }

    private String generateDescriptionForClient(String macAddress, boolean bUseHTML) {
        String htmlOpen = "";
        String boldOpen = "";
        String fontOpen = "";
        String fontClose = "";
        String boldClose = "";
        String htmlClose = "";
        String newLine = "\r\n";
        if (bUseHTML) {
            htmlOpen = "<html>";
            boldOpen = "<b>";
            fontOpen = "<font size=4>";
            fontClose = "</font>";
            boldClose = "</b>";
            htmlClose = "</html>";
            newLine = "<br>";
        }
        try {
            String[] fields = new String[]{"netbios_hostname", "mdns_hostname", "ipv4_address", "ipv6_address"};
            HashMap<String, String> resultMap = Utils.dbInstance.getStringValue("clients", fields, "mac_address", macAddress);
            String notesTxt = String.valueOf(htmlOpen) + fontOpen + boldOpen + "MAC Address: " + boldClose + macAddress;
            if (!resultMap.get("ipv4_address").isEmpty()) {
                notesTxt = String.valueOf(notesTxt) + newLine + boldOpen + "IPv4 Address: " + boldClose + resultMap.get("ipv4_address");
            }
            if (!resultMap.get("ipv6_address").isEmpty()) {
                notesTxt = String.valueOf(notesTxt) + newLine + boldOpen + "IPv6 Address: " + boldClose + resultMap.get("ipv6_address");
            }
            if (!resultMap.get("netbios_hostname").isEmpty()) {
                notesTxt = String.valueOf(notesTxt) + newLine + boldOpen + "Host Name (NetBIOS): " + boldClose + resultMap.get("netbios_hostname");
            }
            if (!resultMap.get("mdns_hostname").isEmpty()) {
                notesTxt = String.valueOf(notesTxt) + newLine + boldOpen + "Host Name (mDNS/Bonjour): " + boldClose + resultMap.get("mdns_hostname");
            }
            String[] userAgents = Utils.dbInstance.getUserAgents(macAddress);
            ArrayList<String> displayUserAgents = new ArrayList<String>();
            String[] stringArray = userAgents;
            int n = userAgents.length;
            int n2 = 0;
            while (n2 < n) {
                String userAgent = stringArray[n2];
                if (userAgent.trim().length() > 0) {
                    displayUserAgents.add(userAgent.trim());
                }
                ++n2;
            }
            if (displayUserAgents.size() > 0) {
                notesTxt = String.valueOf(notesTxt) + newLine + boldOpen + "Detected User-Agents: " + boldClose;
                for (String userAgent : displayUserAgents) {
                    notesTxt = String.valueOf(notesTxt) + newLine + "  - " + userAgent;
                }
            }
            notesTxt = String.valueOf(notesTxt) + fontClose + htmlClose;
            return notesTxt;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void prepareToCloseApplication() {
        if (Utils.dbEngine.equals("sqlite")) {
            try {
                boolean bResetCommit = this.resetData();
                if (!bResetCommit) {
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        BrowserHandler.closeConnections();
        try {
            for (Process p : this.captureHandler.deviceCaptureProcess) {
                if (p == null) continue;
                p.destroy();
            }
            if (Utils.dbInstance != null) {
                Utils.dbInstance.closeDatabase();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dispose();
        System.exit(0);
    }

    public CookieCadgerFrame() throws Exception {
        Utils.cookieCadgerFrame = this;
        Utils.initializeDatabase();
        this.captureHandler = new CaptureHandler();
        this.createGUI();
    }

    public void createGUI() throws Exception {
        String[] interfaceNames;
        int sessionDetection;
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                CookieCadgerFrame.this.prepareToCloseApplication();
            }
        });
        this.setTitle("Cookie Cadger");
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 950, 680);
        URL url = this.getClass().getResource("/resource/cookiecadger.png");
        BufferedImage img = ImageIO.read(url);
        this.setIconImage(img);
        if ((Integer)Utils.programSettings.get("bSessionDetection") == -1 && (sessionDetection = JOptionPane.showConfirmDialog(this.contentPane, "Session detection replays web requests in the background and analyzes\nthem for evidence that a user is logged in. Enabling session detection\nwill cause Cookie Cadger to utilize a larger amount of available\nsystem resources.\n\nBy enabling this feature you also understand that:\n\n1) Cookie Cadger will (potentially) automatically impersonate any\nnetwork user without their explicit permission or interaction on your part.\n\n2) The legality of doing so varies between jurisdictions. It is your\nresponsibility to understand and comply with any applicable laws.\n\nWould you like to enable session detection?\n ", "Enable Session Detection?", 0)) == 0) {
            Utils.programSettings.put("bSessionDetection", 1);
        }
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmStartNewSession = new JMenuItem("Start New Dataset");
        mnFile.add(mntmStartNewSession);
        JMenuItem mntmSettings = new JMenuItem("Program Settings");
        mnFile.add(mntmSettings);
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmSaveSession = null;
        JMenuItem mntmLoadSession = null;
        if (!Utils.bUsingExternalDatabase) {
            mntmSaveSession = new JMenuItem("Save Dataset");
            mnFile.add(mntmSaveSession);
            mntmLoadSession = new JMenuItem("Load Dataset");
            mnFile.add(mntmLoadSession);
            mnFile.add(new JSeparator());
        }
        JMenuItem mntmOpenACapture = new JMenuItem("Open a Capture File (*.pcap)");
        mnFile.add(mntmOpenACapture);
        JMenuItem mntmExit = new JMenuItem("Exit");
        mnFile.add(mntmExit);
        JMenu mnEdit = new JMenu("Edit");
        menuBar.add(mnEdit);
        JMenuItem mntmCopySelectedRequest = new JMenuItem("Copy Selected Request to Clipboard");
        mnEdit.add(mntmCopySelectedRequest);
        JMenuItem mntmCopyAllRequests = new JMenuItem("Copy All Requests to Clipboard");
        mnEdit.add(mntmCopyAllRequests);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        JMenuItem mntmAbout = new JMenuItem("About Cookie Cadger");
        mnHelp.add(mntmAbout);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.clientsListModel = new EnhancedListModel();
        this.domainsListModel = new EnhancedListModel();
        this.requestsListModel = new EnhancedListModel();
        this.sessionsListModel = new EnhancedListModel();
        this.interfacesListModel = new DefaultComboBoxModel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBounds(28, 48, 894, 416);
        this.requestsPanel = new JPanel();
        this.requestsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.requestsPanel.setLayout(null);
        this.tabbedPane.addTab("Requests", null, this.requestsPanel, null);
        if ((Integer)Utils.programSettings.get("bSessionDetection") == 1) {
            this.sessionsPanel = new JPanel();
            this.sessionsPanel.setLayout(null);
            this.tabbedPane.addTab("Recognized Sessions", null, this.sessionsPanel, null);
            JScrollPane sessionsScrollPane = new JScrollPane();
            sessionsScrollPane.setBounds(2, 2, 886, 320);
            this.sessionsPanel.add(sessionsScrollPane);
            this.sessionsList = new EnhancedJList();
            this.sessionsList.setLayoutOrientation(2);
            this.sessionsList.setSelectionMode(1);
            this.sessionsList.setVisibleRowCount(-1);
            this.sessionsList.setModel(this.sessionsListModel);
            sessionsScrollPane.setViewportView(this.sessionsList);
            JCheckBox chckbxAutomaticallyLoadSessions = new JCheckBox("Automatically Load Sessions Into Browser (Demo Mode)");
            chckbxAutomaticallyLoadSessions.setBounds(12, 332, 420, 25);
            chckbxAutomaticallyLoadSessions.setName("chckbxAutomaticallyLoadSessions");
            chckbxAutomaticallyLoadSessions.setSelected((Boolean)Utils.programSettings.get("bUseDemoMode"));
            this.sessionsPanel.add(chckbxAutomaticallyLoadSessions);
            JButton btnLoadSelectedSession = new JButton("Load Selected Session");
            btnLoadSelectedSession.setBounds(657, 332, 220, 25);
            this.sessionsPanel.add(btnLoadSelectedSession);
            btnLoadSelectedSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingWorker<Object, Object> loadSessionWorker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            EnhancedJListItem listItem = (EnhancedJListItem)(this).CookieCadgerFrame.this.sessionsList.getSelectedValue();
                            int sessionID = listItem.getID();
                            try {
                                int requestID = Utils.dbInstance.getIntegerValue("sessions", "request_id", "id", Integer.toString(sessionID));
                                int domainID = Utils.dbInstance.getIntegerValue("requests", "domain_id", "id", Integer.toString(requestID));
                                String sessionUri = Utils.dbInstance.getStringValue("sessions", "session_uri", "id", Integer.toString(sessionID));
                                String domain = Utils.dbInstance.getStringValue("domains", "name", "id", Integer.toString(domainID));
                                String[] fields = new String[]{"useragent", "referer", "authorization", "cookies", "uri"};
                                HashMap<String, String> resultMap = Utils.dbInstance.getStringValue("requests", fields, "id", Integer.toString(requestID));
                                String useragent = resultMap.get("useragent");
                                String referer = resultMap.get("referer");
                                String authorization = resultMap.get("authorization");
                                String cookies = resultMap.get("cookies");
                                String uri = sessionUri != null && !sessionUri.isEmpty() ? sessionUri : resultMap.get("uri");
                                BrowserHandler.loadRequestIntoBrowser(domain, uri, useragent, referer, cookies, authorization);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    };
                    loadSessionWorker.execute();
                }
            });
            this.sessionsPopup = new JPopupMenu();
            JMenuItem sessionsMenuItem = new JMenuItem("View Associated Request");
            sessionsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!CookieCadgerFrame.this.sessionsList.isSelectionEmpty()) {
                        int sessionID = ((EnhancedJListItem)CookieCadgerFrame.this.sessionsList.getSelectedValue()).getID();
                        try {
                            final int requestID = Utils.dbInstance.getIntegerValue("sessions", "request_id", "id", Integer.toString(sessionID));
                            final int domainID = Utils.dbInstance.getIntegerValue("requests", "domain_id", "id", Integer.toString(requestID));
                            final int clientID = Utils.dbInstance.getIntegerValue("requests", "client_id", "id", Integer.toString(requestID));
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CookieCadgerFrame.this.tabbedPane.setSelectedIndex(0);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (((this).this).CookieCadgerFrame.this.clientsListModel.contains(clientID)) {
                                                ((this).this).CookieCadgerFrame.this.clientsList.setSelectedValue(((this).this).CookieCadgerFrame.this.clientsListModel.getElementById(clientID), true);
                                                SwingUtilities.invokeLater(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        if ((((this).this).this).CookieCadgerFrame.this.domainsListModel.contains(domainID)) {
                                                            (((this).this).this).CookieCadgerFrame.this.domainsList.setSelectedValue((((this).this).this).CookieCadgerFrame.this.domainsListModel.getElementById(domainID), true);
                                                            SwingUtilities.invokeLater(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    if (((((this).this).this).this).CookieCadgerFrame.this.requestsListModel.contains(requestID)) {
                                                                        ((((this).this).this).this).CookieCadgerFrame.this.requestsList.setSelectedValue(((((this).this).this).this).CookieCadgerFrame.this.requestsListModel.getElementById(requestID), true);
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.sessionsPopup.add(sessionsMenuItem);
            this.sessionsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (SwingUtilities.isRightMouseButton(me)) {
                        Point mousePosition = me.getPoint();
                        int index = CookieCadgerFrame.this.sessionsList.locationToIndex(me.getPoint());
                        Rectangle cellRect = CookieCadgerFrame.this.sessionsList.getCellBounds(index, index);
                        if ((double)mousePosition.x >= cellRect.getMinX() && (double)mousePosition.x < cellRect.getMaxX() && (double)mousePosition.y >= cellRect.getMinY() && (double)mousePosition.y < cellRect.getMaxY()) {
                            if (index != CookieCadgerFrame.this.sessionsList.getSelectedIndex()) {
                                CookieCadgerFrame.this.sessionsList.setSelectedIndex(index);
                            }
                            CookieCadgerFrame.this.sessionsPopup.show(CookieCadgerFrame.this.sessionsList, me.getX(), me.getY());
                        }
                    }
                }
            });
        }
        this.contentPane.add(this.tabbedPane);
        this.txtConsole = new JTextArea();
        this.txtConsole.setBackground(UIManager.getColor("Panel.background"));
        this.txtConsole.setFont(new Font("Verdana", 1, 12));
        this.txtConsole.setEditable(false);
        this.consoleScrollPane = new JScrollPane();
        this.consoleScrollPane.setBounds(28, 475, 895, 130);
        this.contentPane.add(this.consoleScrollPane);
        this.consoleScrollPane.setViewportView(this.txtConsole);
        this.loadingRequestProgressBar = new JProgressBar(0);
        this.loadingRequestProgressBar.setStringPainted(true);
        this.loadingRequestProgressBar.setFont(new Font("Verdana", 1, 22));
        this.loadingRequestProgressBar.setIndeterminate(true);
        this.loadingRequestProgressBar.setVisible(false);
        this.loadingRequestProgressBar.setBounds(this.consoleScrollPane.getBounds());
        this.contentPane.add(this.loadingRequestProgressBar);
        JButton btnMonitorOnSelected = new JButton("Select An Interface");
        btnMonitorOnSelected.setEnabled(false);
        btnMonitorOnSelected.setName("btnMonitorOnSelected");
        btnMonitorOnSelected.setBounds(681, 14, 240, 25);
        this.contentPane.add(btnMonitorOnSelected);
        JComboBox<String> interfaceListComboBox = new JComboBox<String>();
        interfaceListComboBox.setName("interfaceListComboBox");
        interfaceListComboBox.setBounds(28, 14, 626, 24);
        this.contentPane.add(interfaceListComboBox);
        interfaceListComboBox.setModel(this.interfacesListModel);
        JScrollPane clientsListScrollPanel = new JScrollPane();
        clientsListScrollPanel.setBounds(22, 32, 152, 336);
        this.requestsPanel.add(clientsListScrollPanel);
        this.clientsList = new EnhancedJList();
        this.clientsList.setSelectionMode(0);
        this.clientsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !CookieCadgerFrame.this.clientsList.isSelectionEmpty()) {
                    JList list = (JList)e.getSource();
                    String item = ((EnhancedJListItem)list.getSelectedValue()).toString();
                    CookieCadgerFrame.this.changeDomainsList(item);
                }
            }
        });
        clientsListScrollPanel.setViewportView(this.clientsList);
        SortedListModel clientsListModelSorted = new SortedListModel(this.clientsListModel);
        clientsListModelSorted.setSortOrder(SortedListModel.SortOrder.ASCENDING);
        this.clientsList.setModel(clientsListModelSorted);
        JScrollPane domainListScrollPane = new JScrollPane();
        domainListScrollPane.setBounds(180, 32, 200, 336);
        this.requestsPanel.add(domainListScrollPane);
        this.domainsList = new EnhancedJList();
        this.domainsList.setSelectionMode(0);
        this.domainsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!(e.getValueIsAdjusting() || CookieCadgerFrame.this.clientsList.isSelectionEmpty() || CookieCadgerFrame.this.domainsList.isSelectionEmpty())) {
                    JList list = (JList)e.getSource();
                    String item = ((EnhancedJListItem)list.getSelectedValue()).toString();
                    String macAddress = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                    CookieCadgerFrame.this.changeRequestsList(macAddress, item);
                }
            }
        });
        this.domainsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    Point mousePosition = me.getPoint();
                    int index = CookieCadgerFrame.this.domainsList.locationToIndex(me.getPoint());
                    Rectangle cellRect = CookieCadgerFrame.this.domainsList.getCellBounds(index, index);
                    if ((double)mousePosition.x >= cellRect.getMinX() && (double)mousePosition.x < cellRect.getMaxX() && (double)mousePosition.y >= cellRect.getMinY() && (double)mousePosition.y < cellRect.getMaxY()) {
                        if (index != CookieCadgerFrame.this.domainsList.getSelectedIndex()) {
                            CookieCadgerFrame.this.domainsList.setSelectedIndex(index);
                        }
                        CookieCadgerFrame.this.domainsPopup.show(CookieCadgerFrame.this.domainsList, me.getX(), me.getY());
                    }
                }
            }
        });
        domainListScrollPane.setViewportView(this.domainsList);
        SortedListModel domainListModelSorted = new SortedListModel(this.domainsListModel);
        domainListModelSorted.setSortOrder(SortedListModel.SortOrder.ASCENDING);
        this.domainsList.setModel(domainListModelSorted);
        this.domainsPopup = new JPopupMenu();
        JMenuItem copyDomainInfoMenuItem = new JMenuItem("Copy Domain Information");
        copyDomainInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CookieCadgerFrame.this.domainsList.isSelectionEmpty()) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    String domain = ((EnhancedJListItem)CookieCadgerFrame.this.domainsList.getSelectedValue()).toString();
                    StringSelection strSel = new StringSelection(domain);
                    clipboard.setContents(strSel, null);
                }
            }
        });
        this.domainsPopup.add(copyDomainInfoMenuItem);
        JScrollPane requestListScrollPanel = new JScrollPane();
        requestListScrollPanel.setBounds(386, 32, 482, 306);
        this.requestsPanel.add(requestListScrollPanel);
        this.requestsList = new EnhancedJList();
        Font fontMonospace = new Font("Monospaced", 1, 12);
        this.requestsList.setFont(fontMonospace);
        this.requestsList.setSelectionMode(0);
        this.requestsList.setModel(this.requestsListModel);
        requestListScrollPanel.setViewportView(this.requestsList);
        this.clientsPopup = new JPopupMenu();
        JMenuItem copyHostInfoMenuItem = new JMenuItem("Copy Host Information");
        copyHostInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CookieCadgerFrame.this.clientsList.isSelectionEmpty()) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    String macAddress = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                    StringSelection strSel = new StringSelection(CookieCadgerFrame.this.generateDescriptionForClient(macAddress, false));
                    clipboard.setContents(strSel, null);
                }
            }
        });
        this.clientsPopup.add(copyHostInfoMenuItem);
        JMenuItem copyMacAddressMenuItem = new JMenuItem("Copy MAC Address");
        copyMacAddressMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CookieCadgerFrame.this.clientsList.isSelectionEmpty()) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    String macAddress = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                    StringSelection strSel = new StringSelection(macAddress);
                    clipboard.setContents(strSel, null);
                }
            }
        });
        this.clientsPopup.add(copyMacAddressMenuItem);
        this.clientsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            try {
                                ToolTipManager.sharedInstance().setEnabled(false);
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            return null;
                        }

                        @Override
                        public void done() {
                            ToolTipManager.sharedInstance().setEnabled(true);
                        }
                    };
                    worker.execute();
                    Point mousePosition = me.getPoint();
                    int index = CookieCadgerFrame.this.clientsList.locationToIndex(me.getPoint());
                    Rectangle cellRect = CookieCadgerFrame.this.clientsList.getCellBounds(index, index);
                    if ((double)mousePosition.x >= cellRect.getMinX() && (double)mousePosition.x < cellRect.getMaxX() && (double)mousePosition.y >= cellRect.getMinY() && (double)mousePosition.y < cellRect.getMaxY()) {
                        if (index != CookieCadgerFrame.this.clientsList.getSelectedIndex()) {
                            CookieCadgerFrame.this.clientsList.setSelectedIndex(index);
                        }
                        CookieCadgerFrame.this.clientsPopup.show(CookieCadgerFrame.this.clientsList, me.getX(), me.getY());
                    }
                }
            }
        });
        this.requestsPopup = new JPopupMenu();
        JMenuItem requestMenuItem = new JMenuItem("Copy Request Information");
        requestMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CookieCadgerFrame.this.requestsList.isSelectionEmpty()) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    int request = ((EnhancedJListItem)CookieCadgerFrame.this.requestsList.getSelectedValue()).getID();
                    StringSelection strSel = new StringSelection(Utils.generateDescriptionForRequest(request, false, false));
                    clipboard.setContents(strSel, null);
                }
            }
        });
        this.requestsPopup.add(requestMenuItem);
        this.requestsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            try {
                                ToolTipManager.sharedInstance().setEnabled(false);
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            return null;
                        }

                        @Override
                        public void done() {
                            ToolTipManager.sharedInstance().setEnabled(true);
                        }
                    };
                    worker.execute();
                    Point mousePosition = me.getPoint();
                    int index = CookieCadgerFrame.this.requestsList.locationToIndex(me.getPoint());
                    Rectangle cellRect = CookieCadgerFrame.this.requestsList.getCellBounds(index, index);
                    if ((double)mousePosition.x >= cellRect.getMinX() && (double)mousePosition.x < cellRect.getMaxX() && (double)mousePosition.y >= cellRect.getMinY() && (double)mousePosition.y < cellRect.getMaxY()) {
                        if (index != CookieCadgerFrame.this.requestsList.getSelectedIndex()) {
                            CookieCadgerFrame.this.requestsList.setSelectedIndex(index);
                        }
                        CookieCadgerFrame.this.requestsPopup.show(CookieCadgerFrame.this.requestsList, me.getX(), me.getY());
                    }
                }
            }
        });
        JButton btnLoadDomainCookies = new JButton("Load Domain Cookies");
        btnLoadDomainCookies.setFont(new Font("Dialog", 1, 10));
        btnLoadDomainCookies.setBounds(386, 342, 155, 25);
        this.requestsPanel.add(btnLoadDomainCookies);
        JButton btnReplayRequest = new JButton("Replay Request");
        btnReplayRequest.setFont(new Font("Dialog", 1, 10));
        btnReplayRequest.setBounds(553, 342, 126, 25);
        this.requestsPanel.add(btnReplayRequest);
        JButton btnModifyReplay = new JButton("Modify & Replay Request");
        btnModifyReplay.setFont(new Font("Dialog", 1, 10));
        btnModifyReplay.setBounds(691, 342, 176, 25);
        this.requestsPanel.add(btnModifyReplay);
        this.txtClientSearch = new EnhancedJTextField();
        this.txtClientSearch.setName("txtClientSearch");
        this.txtClientSearch.setPlaceholder("Filter MACs", new Font("SansSerif", 1, 10));
        this.txtClientSearch.setBounds(22, 8, 152, 19);
        this.requestsPanel.add(this.txtClientSearch);
        this.txtClientSearch.setColumns(10);
        this.txtDomainSearch = new EnhancedJTextField();
        this.txtDomainSearch.setName("txtDomainSearch");
        this.txtDomainSearch.setPlaceholder("Filter Domains", new Font("SansSerif", 1, 10));
        this.txtDomainSearch.setBounds(179, 8, 201, 19);
        this.requestsPanel.add(this.txtDomainSearch);
        this.txtDomainSearch.setColumns(10);
        this.txtRequestSearch = new EnhancedJTextField();
        this.txtRequestSearch.setName("txtRequestSearch");
        this.txtRequestSearch.setPlaceholder("Filter Requests", new Font("SansSerif", 1, 10));
        this.txtRequestSearch.setBounds(386, 8, 482, 19);
        this.requestsPanel.add(this.txtRequestSearch);
        this.txtRequestSearch.setColumns(10);
        JLabel lblSoftwareUpdateAvailable = new JLabel("");
        lblSoftwareUpdateAvailable.setName("lblSoftwareUpdateAvailable");
        lblSoftwareUpdateAvailable.setBounds(28, 606, 895, 15);
        this.contentPane.add(lblSoftwareUpdateAvailable);
        mntmStartNewSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean resetCommit = CookieCadgerFrame.this.resetData();
                if (resetCommit) {
                    CookieCadgerFrame.this.clearGUI();
                    try {
                        Utils.dbInstance.initTables();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        mntmSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog settingsInterface = new SettingsDialog();
                settingsInterface.setVisible(true);
            }
        });
        mntmOpenACapture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter pcapFilter = new FileNameExtensionFilter("*.pcap | *.cap | *.pcapdump", "pcap", "cap", "pcapdump");
                fc.addChoosableFileFilter(pcapFilter);
                fc.setFileFilter(pcapFilter);
                int returnVal = fc.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    final String pcapFile = file.getAbsolutePath();
                    JOptionPane.showMessageDialog(null, "This process could take some time, please be patient.");
                    SwingWorker<Object, Object> openCaptureWorker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            try {
                                (this).CookieCadgerFrame.this.consoleScrollPane.setVisible(false);
                                (this).CookieCadgerFrame.this.loadingRequestProgressBar.setString("Processing capture file, please wait...");
                                (this).CookieCadgerFrame.this.loadingRequestProgressBar.setVisible(true);
                                CookieCadgerFrame.this.captureHandler.startCapture(-1, pcapFile);
                                (this).CookieCadgerFrame.this.loadingRequestProgressBar.setVisible(false);
                                (this).CookieCadgerFrame.this.consoleScrollPane.setVisible(true);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    };
                    openCaptureWorker.execute();
                }
            }
        });
        if (!Utils.bUsingExternalDatabase) {
            mntmSaveSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Utils.dbInstance.saveDatabase();
                }
            });
            mntmLoadSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean resetCommit = CookieCadgerFrame.this.resetData();
                    if (resetCommit) {
                        CookieCadgerFrame.this.clearGUI();
                        try {
                            Utils.dbInstance.initTables();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        Utils.dbInstance.openDatabase();
                        CookieCadgerFrame.this.changeClientsList(true);
                        if ((Integer)Utils.programSettings.get("bSessionDetection") == 1) {
                            CookieCadgerFrame.this.changeSessionsList(true);
                        }
                    }
                }
            });
        }
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CookieCadgerFrame.this.prepareToCloseApplication();
            }
        });
        mntmCopySelectedRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CookieCadgerFrame.this.requestsList.isSelectionEmpty()) {
                    JOptionPane.showMessageDialog(null, "You must first select a request.");
                } else {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    int request = ((EnhancedJListItem)CookieCadgerFrame.this.requestsList.getSelectedValue()).getID();
                    StringSelection strSel = new StringSelection(Utils.generateDescriptionForRequest(request, false, false));
                    clipboard.setContents(strSel, null);
                }
            }
        });
        mntmCopyAllRequests.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String allRequests = "";
                int i = 0;
                while (i < CookieCadgerFrame.this.requestsListModel.getSize()) {
                    int request = ((EnhancedJListItem)CookieCadgerFrame.this.requestsListModel.getElementAt(i)).getID();
                    allRequests = String.valueOf(allRequests) + Utils.generateDescriptionForRequest(request, false, false);
                    if (i < CookieCadgerFrame.this.requestsListModel.getSize() - 1) {
                        allRequests = String.valueOf(allRequests) + "\r\n\r\n---\r\n\r\n";
                    }
                    ++i;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                StringSelection strSel = new StringSelection(allRequests);
                clipboard.setContents(strSel, null);
            }
        });
        mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.displayAboutWindow();
            }
        });
        this.txtClientSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CookieCadgerFrame.this.changeClientsList(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CookieCadgerFrame.this.changeClientsList(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CookieCadgerFrame.this.changeClientsList(true);
            }
        });
        this.txtDomainSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.ChangeDomains();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.ChangeDomains();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.ChangeDomains();
            }

            private void ChangeDomains() {
                if (!CookieCadgerFrame.this.clientsList.getValueIsAdjusting() && !CookieCadgerFrame.this.clientsList.isSelectionEmpty()) {
                    String item = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                    CookieCadgerFrame.this.changeDomainsList(item);
                }
            }
        });
        this.txtRequestSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.ChangeRequests();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.ChangeRequests();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.ChangeRequests();
            }

            private void ChangeRequests() {
                if (!(CookieCadgerFrame.this.clientsList.getValueIsAdjusting() || CookieCadgerFrame.this.clientsList.isSelectionEmpty() || CookieCadgerFrame.this.domainsList.getValueIsAdjusting() || CookieCadgerFrame.this.domainsList.isSelectionEmpty())) {
                    String client = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                    String domain = ((EnhancedJListItem)CookieCadgerFrame.this.domainsList.getSelectedValue()).toString();
                    CookieCadgerFrame.this.changeRequestsList(client, domain);
                }
            }
        });
        btnLoadDomainCookies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((EnhancedJListItem)CookieCadgerFrame.this.domainsList.getSelectedValue()).getID() == -1) {
                    JOptionPane.showMessageDialog(null, "This option is not available when \"[ All Domains ]\" is selected.");
                } else if (!CookieCadgerFrame.this.domainsList.isSelectionEmpty()) {
                    SwingWorker<Object, Object> loadRequestWorker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            try {
                                int clientID = Utils.dbInstance.getIntegerValue("clients", "id", "mac_address", ((EnhancedJListItem)(this).CookieCadgerFrame.this.clientsList.getSelectedValue()).toString());
                                int domainID = Utils.dbInstance.getIntegerValue("domains", "id", "name", ((EnhancedJListItem)(this).CookieCadgerFrame.this.domainsList.getSelectedValue()).toString());
                                int requestID = Utils.dbInstance.getNewestRequestID(clientID, domainID);
                                String domain = ((EnhancedJListItem)(this).CookieCadgerFrame.this.domainsList.getSelectedValue()).toString();
                                String uri = "/";
                                String[] fields = new String[]{"useragent", "referer", "authorization", "cookies"};
                                HashMap<String, String> resultMap = Utils.dbInstance.getStringValue("requests", fields, "id", Integer.toString(requestID));
                                String useragent = resultMap.get("useragent");
                                String referer = resultMap.get("referer");
                                String authorization = resultMap.get("authorization");
                                String cookies = resultMap.get("cookies");
                                BrowserHandler.loadRequestIntoBrowser(domain, uri, useragent, referer, cookies, authorization);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    };
                    loadRequestWorker.execute();
                }
            }
        });
        btnReplayRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!CookieCadgerFrame.this.requestsList.isSelectionEmpty()) {
                    SwingWorker<Object, Object> loadRequestWorker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            EnhancedJListItem listItem = (EnhancedJListItem)(this).CookieCadgerFrame.this.requestsList.getSelectedValue();
                            int requestID = listItem.getID();
                            try {
                                int domainID = Utils.dbInstance.getIntegerValue("requests", "domain_id", "id", Integer.toString(requestID));
                                String domain = Utils.dbInstance.getStringValue("domains", "name", "id", Integer.toString(domainID));
                                String[] fields = new String[]{"uri", "useragent", "referer", "authorization", "cookies"};
                                HashMap<String, String> resultMap = Utils.dbInstance.getStringValue("requests", fields, "id", Integer.toString(requestID));
                                String uri = resultMap.get("uri");
                                String useragent = resultMap.get("useragent");
                                String referer = resultMap.get("referer");
                                String authorization = resultMap.get("authorization");
                                String cookies = resultMap.get("cookies");
                                BrowserHandler.loadRequestIntoBrowser(domain, uri, useragent, referer, cookies, authorization);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    };
                    loadRequestWorker.execute();
                }
            }
        });
        btnModifyReplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!CookieCadgerFrame.this.requestsList.isSelectionEmpty()) {
                    SwingWorker<Object, Object> loadRequestWorker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            EnhancedJListItem listItem = (EnhancedJListItem)(this).CookieCadgerFrame.this.requestsList.getSelectedValue();
                            int requestID = listItem.getID();
                            try {
                                int domainID = Utils.dbInstance.getIntegerValue("requests", "domain_id", "id", Integer.toString(requestID));
                                String domain = Utils.dbInstance.getStringValue("domains", "name", "id", Integer.toString(domainID));
                                String[] fields = new String[]{"uri", "useragent", "referer", "authorization", "cookies"};
                                HashMap<String, String> resultMap = Utils.dbInstance.getStringValue("requests", fields, "id", Integer.toString(requestID));
                                String uri = resultMap.get("uri");
                                String useragent = resultMap.get("useragent");
                                String referer = resultMap.get("referer");
                                String authorization = resultMap.get("authorization");
                                String cookies = resultMap.get("cookies");
                                ReplayDialog replayInterface = new ReplayDialog(domain, uri, useragent, referer, cookies, authorization);
                                replayInterface.setVisible(true);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    };
                    loadRequestWorker.execute();
                }
            }
        });
        interfaceListComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieCadgerFrame.this.setCaptureButtonText();
            }
        });
        btnMonitorOnSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedInterface = ((JComboBox)CookieCadgerFrame.this.getComponentByName("interfaceListComboBox")).getSelectedIndex();
                if (selectedInterface == -1) {
                    return;
                }
                boolean bInterfaceIsCapturing = ((CookieCadgerFrame)CookieCadgerFrame.this).captureHandler.bCapturing.get(selectedInterface);
                if (bInterfaceIsCapturing) {
                    CookieCadgerFrame.this.stopCapture(selectedInterface);
                } else {
                    CookieCadgerFrame.this.prepCapture(selectedInterface);
                    SwingWorker<Object, Object> captureWorker = new SwingWorker<Object, Object>(){

                        @Override
                        public Object doInBackground() {
                            try {
                                int selectedInterface = ((JComboBox)CookieCadgerFrame.this.getComponentByName("interfaceListComboBox")).getSelectedIndex();
                                CookieCadgerFrame.this.captureHandler.startCapture(selectedInterface, null);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    };
                    captureWorker.execute();
                }
            }
        });
        this.componentMap = this.createComponentMap(this.contentPane);
        this.captureHandler.initializeDeviceList();
        Utils.consoleMessage("\n\nCookie Cadger (v1.08, https://cookiecadger.com)\nCreated by Matthew Sullivan - mattslifebytes.com\nThis software is freely distributed under the terms of the FreeBSD license.\n");
        int i = 0;
        while (i < this.captureHandler.deviceName.size()) {
            String interfaceText = String.valueOf(this.captureHandler.deviceName.get(i)) + " [" + this.captureHandler.deviceDescription.get(i) + "]";
            this.interfacesListModel.addElement(interfaceText);
            ++i;
        }
        int itemToSelect = -1;
        boolean bFinished = false;
        String[] stringArray = interfaceNames = new String[]{"mon", "wlan", "en", "eth"};
        int n = interfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            int i2 = 0;
            while (i2 < this.captureHandler.deviceName.size()) {
                if (this.captureHandler.deviceName.get(i2).contains(interfaceName)) {
                    itemToSelect = i2;
                    bFinished = true;
                    break;
                }
                ++i2;
            }
            if (bFinished) break;
            ++n2;
        }
        interfaceListComboBox.setSelectedIndex(itemToSelect);
        if (((Boolean)Utils.programSettings.get("bCheckForUpdates")).booleanValue()) {
            SwingWorker<Object, Object> updateWorker = new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    try {
                        String macAddressHashString;
                        JLabel lblSoftwareUpdateAvailable = (JLabel)CookieCadgerFrame.this.getComponentByName("lblSoftwareUpdateAvailable");
                        try {
                            InetAddress ip = InetAddress.getLocalHost();
                            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                            byte[] mac = network.getHardwareAddress();
                            MessageDigest shaOfMacAddress = MessageDigest.getInstance("SHA-512");
                            byte[] macAddressHash = shaOfMacAddress.digest(mac);
                            StringBuffer macAddressHashStringBuilder = new StringBuffer();
                            int i = 0;
                            while (i < macAddressHash.length) {
                                macAddressHashStringBuilder.append(Integer.toString((macAddressHash[i] & 0xFF) + 256, 16).substring(1));
                                ++i;
                            }
                            macAddressHashString = macAddressHashStringBuilder.toString();
                        }
                        catch (Exception ex) {
                            macAddressHashString = "";
                        }
                        String releasedVersion = Utils.readUrl("https://www.cookiecadger.com/update/?update=1.08; " + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "; " + macAddressHashString, "Cookie Cadger, 1.08", "text/html", null);
                        if (releasedVersion.length() > 0 && releasedVersion.contains("Cookie Cadger")) {
                            lblSoftwareUpdateAvailable.setText(releasedVersion);
                            lblSoftwareUpdateAvailable.setForeground(Color.BLUE);
                            lblSoftwareUpdateAvailable.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    try {
                                        Desktop.getDesktop().browse(new URI("http://www.cookiecadger.com/update/"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            updateWorker.execute();
        }
        if (!Utils.dbEngine.equals("sqlite")) {
            try {
                this.changeClientsList(false);
                if ((Integer)Utils.programSettings.get("bSessionDetection") == 1) {
                    this.changeSessionsList(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Timer timer = new Timer(1000 * (Integer)Utils.programSettings.get("databaseRefreshRate"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        boolean bPreviousSelection = false;
                        String previousSelection = null;
                        if (!CookieCadgerFrame.this.clientsList.isSelectionEmpty() && CookieCadgerFrame.this.requestsList.getSelectedValue() != null) {
                            bPreviousSelection = true;
                            previousSelection = ((EnhancedJListItem)CookieCadgerFrame.this.requestsList.getSelectedValue()).toString();
                        }
                        CookieCadgerFrame.this.changeClientsList(false);
                        if (!CookieCadgerFrame.this.clientsList.isSelectionEmpty()) {
                            String selectedClient = ((EnhancedJListItem)CookieCadgerFrame.this.clientsList.getSelectedValue()).toString();
                            CookieCadgerFrame.this.changeDomainsList(selectedClient);
                        }
                        if ((Integer)Utils.programSettings.get("bSessionDetection") == 1) {
                            CookieCadgerFrame.this.changeSessionsList(false);
                        }
                        if (bPreviousSelection && CookieCadgerFrame.this.requestsListModel.contains(previousSelection)) {
                            int index = CookieCadgerFrame.this.requestsListModel.indexOf(previousSelection);
                            CookieCadgerFrame.this.requestsList.setSelectedValue(CookieCadgerFrame.this.requestsListModel.getElementAt(index), true);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            timer.setRepeats(true);
            timer.start();
        }
    }

    private HashMap<String, Component> createComponentMap(JPanel panel) {
        HashMap<String, Component> componentMap = new HashMap<String, Component>();
        Component[] components = panel.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JTabbedPane) {
                Component[] componentArray = ((JTabbedPane)components[i]).getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component cmp = componentArray[n2];
                    if (cmp instanceof JPanel) {
                        Component[] componentArray2 = ((JPanel)cmp).getComponents();
                        int n3 = componentArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Component x = componentArray2[n4];
                            componentMap.put(x.getName(), x);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            componentMap.put(components[i].getName(), components[i]);
            ++i;
        }
        return componentMap;
    }

    public Component getComponentByName(String name) {
        if (this.componentMap.containsKey(name)) {
            return this.componentMap.get(name);
        }
        return null;
    }
}

