/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.RequestInterceptor;
import com.cookiecadger.Utils;
import org.apache.http.HttpRequestInterceptor;
import org.browsermob.proxy.ProxyServer;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserHandler {
    private static RequestInterceptor requestIntercept;
    private static WebDriver driver;
    private static ProxyServer server;
    private static Proxy proxy;

    static {
        driver = null;
        server = null;
        proxy = null;
    }

    public static void loadRequestIntoBrowser(String domain, String uri, String userAgent, String referer, String cookies, String authorization) {
        Utils.cookieCadgerFrame.consoleScrollPane.setVisible(false);
        Utils.cookieCadgerFrame.loadingRequestProgressBar.setString("Loading request into browser, please wait...");
        Utils.cookieCadgerFrame.loadingRequestProgressBar.setVisible(true);
        if (server == null) {
            server = new ProxyServer(7878);
            requestIntercept = new RequestInterceptor();
            requestIntercept.setRandomization(Integer.toString(Utils.getLocalRandomization()));
            try {
                server.start();
                server.addRequestInterceptor((HttpRequestInterceptor)requestIntercept);
                proxy = new Proxy();
                proxy.setHttpProxy("127.0.0.1:7878");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            driver.getTitle();
        }
        catch (Exception e) {
            driver = null;
        }
        if (driver == null) {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setCapability("proxy", (Object)proxy);
            driver = new FirefoxDriver((Capabilities)capabilities);
        } else {
            requestIntercept.clear();
        }
        if (!cookies.isEmpty()) {
            requestIntercept.setCookies(cookies);
        }
        if (!authorization.isEmpty()) {
            requestIntercept.setAuthorization(authorization);
        }
        if (userAgent.isEmpty()) {
            userAgent = (String)((JavascriptExecutor)driver).executeScript("return navigator.userAgent;", new Object[0]);
        }
        requestIntercept.setUserAgent(userAgent);
        if (!referer.isEmpty()) {
            requestIntercept.setReferer(referer);
        }
        try {
            driver.get("http://" + domain + uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Utils.cookieCadgerFrame.loadingRequestProgressBar.setVisible(false);
        Utils.cookieCadgerFrame.consoleScrollPane.setVisible(true);
    }

    public static void closeConnections() {
        try {
            try {
                driver.close();
            }
            catch (Exception exception) {
                driver = null;
            }
        }
        finally {
            driver = null;
        }
    }
}

