import { Service } from "../operationsInterfaces/index.js";
import { StorageClient } from "../storageClient.js";
import { FileServiceProperties, ServiceSetPropertiesOptionalParams, ServiceSetPropertiesResponse, ServiceGetPropertiesOptionalParams, ServiceGetPropertiesResponse, ServiceListSharesSegmentOptionalParams, ServiceListSharesSegmentResponse } from "../models/index.js";
/** Class containing Service operations. */
export declare class ServiceImpl implements Service {
    private readonly client;
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client: StorageClient);
    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage
     * Analytics metrics and CORS (Cross-Origin Resource Sharing) rules.
     * @param properties The StorageService properties.
     * @param options The options parameters.
     */
    setProperties(properties: FileServiceProperties, options?: ServiceSetPropertiesOptionalParams): Promise<ServiceSetPropertiesResponse>;
    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics
     * metrics and CORS (Cross-Origin Resource Sharing) rules.
     * @param options The options parameters.
     */
    getProperties(options?: ServiceGetPropertiesOptionalParams): Promise<ServiceGetPropertiesResponse>;
    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the
     * specified account.
     * @param options The options parameters.
     */
    listSharesSegment(options?: ServiceListSharesSegmentOptionalParams): Promise<ServiceListSharesSegmentResponse>;
}
//# sourceMappingURL=service.d.ts.map