"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.logger = exports.RestError = exports.BaseRequestPolicy = exports.StorageOAuthScopes = exports.newPipeline = exports.isPipelineLike = exports.Pipeline = exports.getBlobServiceAccountAudience = exports.StorageBlobAudience = exports.PremiumPageBlobTier = exports.BlockBlobTier = exports.generateBlobSASQueryParameters = exports.generateAccountSASQueryParameters = void 0;
const tslib_1 = require("tslib");
const core_rest_pipeline_1 = require("@azure/core-rest-pipeline");
Object.defineProperty(exports, "RestError", { enumerable: true, get: function () { return core_rest_pipeline_1.RestError; } });
tslib_1.__exportStar(require("./BlobServiceClient.js"), exports);
tslib_1.__exportStar(require("./Clients.js"), exports);
tslib_1.__exportStar(require("./ContainerClient.js"), exports);
tslib_1.__exportStar(require("./BlobLeaseClient.js"), exports);
tslib_1.__exportStar(require("./sas/AccountSASPermissions.js"), exports);
tslib_1.__exportStar(require("./sas/AccountSASResourceTypes.js"), exports);
tslib_1.__exportStar(require("./sas/AccountSASServices.js"), exports);
var AccountSASSignatureValues_js_1 = require("./sas/AccountSASSignatureValues.js");
Object.defineProperty(exports, "generateAccountSASQueryParameters", { enumerable: true, get: function () { return AccountSASSignatureValues_js_1.generateAccountSASQueryParameters; } });
tslib_1.__exportStar(require("./BlobBatch.js"), exports);
tslib_1.__exportStar(require("./BlobBatchClient.js"), exports);
tslib_1.__exportStar(require("./BatchResponse.js"), exports);
tslib_1.__exportStar(require("./sas/BlobSASPermissions.js"), exports);
var BlobSASSignatureValues_js_1 = require("./sas/BlobSASSignatureValues.js");
Object.defineProperty(exports, "generateBlobSASQueryParameters", { enumerable: true, get: function () { return BlobSASSignatureValues_js_1.generateBlobSASQueryParameters; } });
tslib_1.__exportStar(require("./StorageBrowserPolicyFactory.js"), exports);
tslib_1.__exportStar(require("./sas/ContainerSASPermissions.js"), exports);
tslib_1.__exportStar(require("./credentials/AnonymousCredential.js"), exports);
tslib_1.__exportStar(require("./credentials/Credential.js"), exports);
tslib_1.__exportStar(require("./credentials/StorageSharedKeyCredential.js"), exports);
var models_js_1 = require("./models.js");
Object.defineProperty(exports, "BlockBlobTier", { enumerable: true, get: function () { return models_js_1.BlockBlobTier; } });
Object.defineProperty(exports, "PremiumPageBlobTier", { enumerable: true, get: function () { return models_js_1.PremiumPageBlobTier; } });
Object.defineProperty(exports, "StorageBlobAudience", { enumerable: true, get: function () { return models_js_1.StorageBlobAudience; } });
Object.defineProperty(exports, "getBlobServiceAccountAudience", { enumerable: true, get: function () { return models_js_1.getBlobServiceAccountAudience; } });
var Pipeline_js_1 = require("./Pipeline.js");
Object.defineProperty(exports, "Pipeline", { enumerable: true, get: function () { return Pipeline_js_1.Pipeline; } });
Object.defineProperty(exports, "isPipelineLike", { enumerable: true, get: function () { return Pipeline_js_1.isPipelineLike; } });
Object.defineProperty(exports, "newPipeline", { enumerable: true, get: function () { return Pipeline_js_1.newPipeline; } });
Object.defineProperty(exports, "StorageOAuthScopes", { enumerable: true, get: function () { return Pipeline_js_1.StorageOAuthScopes; } });
tslib_1.__exportStar(require("./StorageRetryPolicyFactory.js"), exports);
var RequestPolicy_js_1 = require("./policies/RequestPolicy.js");
Object.defineProperty(exports, "BaseRequestPolicy", { enumerable: true, get: function () { return RequestPolicy_js_1.BaseRequestPolicy; } });
tslib_1.__exportStar(require("./policies/AnonymousCredentialPolicy.js"), exports);
tslib_1.__exportStar(require("./policies/CredentialPolicy.js"), exports);
tslib_1.__exportStar(require("./StorageRetryPolicyFactory.js"), exports);
tslib_1.__exportStar(require("./policies/StorageSharedKeyCredentialPolicy.js"), exports);
tslib_1.__exportStar(require("./sas/SASQueryParameters.js"), exports);
tslib_1.__exportStar(require("./generatedModels.js"), exports);
var log_js_1 = require("./log.js");
Object.defineProperty(exports, "logger", { enumerable: true, get: function () { return log_js_1.logger; } });
//# sourceMappingURL=index.js.map