// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
export function handleTableAlreadyExists(error, options = {}) {
    const responseError = getErrorResponse(error);
    if (responseError &&
        responseError.status === 409 &&
        responseError.parsedBody.odataError?.code === "TableAlreadyExists") {
        options.logger?.info(`Table ${options.tableName} already Exists`);
        if (options.onResponse) {
            options.onResponse(responseError, {});
        }
    }
    else {
        throw error;
    }
}
function getErrorResponse(error) {
    if (!isRestError(error)) {
        return undefined;
    }
    const errorResponse = error.response;
    if (!errorResponse || !isTableServiceErrorResponse(errorResponse.parsedBody)) {
        return undefined;
    }
    return errorResponse;
}
function isRestError(error) {
    return error.name === "RestError";
}
function isTableServiceErrorResponse(errorResponseBody) {
    return Boolean(errorResponseBody?.odataError);
}
//# sourceMappingURL=errorHelpers.js.map