"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceImpl = void 0;
const tslib_1 = require("tslib");
const coreClient = tslib_1.__importStar(require("@azure/core-client"));
const Mappers = tslib_1.__importStar(require("../models/mappers.js"));
const Parameters = tslib_1.__importStar(require("../models/parameters.js"));
/** Class containing Service operations. */
class ServiceImpl {
    client;
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Sets properties for an account's Table service endpoint, including properties for Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * @param tableServiceProperties The Table Service properties.
     * @param options The options parameters.
     */
    setProperties(tableServiceProperties, options) {
        return this.client.sendOperationRequest({ tableServiceProperties, options }, setPropertiesOperationSpec);
    }
    /**
     * Gets the properties of an account's Table service, including properties for Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * @param options The options parameters.
     */
    getProperties(options) {
        return this.client.sendOperationRequest({ options }, getPropertiesOperationSpec);
    }
    /**
     * Retrieves statistics related to replication for the Table service. It is only available on the
     * secondary location endpoint when read-access geo-redundant replication is enabled for the account.
     * @param options The options parameters.
     */
    getStatistics(options) {
        return this.client.sendOperationRequest({ options }, getStatisticsOperationSpec);
    }
}
exports.ServiceImpl = ServiceImpl;
// Operation Specifications
const xmlSerializer = coreClient.createSerializer(Mappers, /* isXml */ true);
const setPropertiesOperationSpec = {
    path: "/",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: Mappers.ServiceSetPropertiesHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.ServiceSetPropertiesExceptionHeaders
        }
    },
    requestBody: Parameters.tableServiceProperties,
    queryParameters: [Parameters.timeout, Parameters.restype, Parameters.comp1],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.contentType2,
        Parameters.accept3
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer
};
const getPropertiesOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.TableServiceProperties,
            headersMapper: Mappers.ServiceGetPropertiesHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.ServiceGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [Parameters.timeout, Parameters.restype, Parameters.comp1],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept2
    ],
    isXML: true,
    serializer: xmlSerializer
};
const getStatisticsOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.TableServiceStats,
            headersMapper: Mappers.ServiceGetStatisticsHeaders
        },
        default: {
            bodyMapper: Mappers.TableServiceError,
            headersMapper: Mappers.ServiceGetStatisticsExceptionHeaders
        }
    },
    queryParameters: [Parameters.timeout, Parameters.restype, Parameters.comp2],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept2
    ],
    isXML: true,
    serializer: xmlSerializer
};
//# sourceMappingURL=service.js.map