/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.BluetoothConnectionAccess;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXAuthentication;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;
import javax.obex.Authenticator;
import javax.obex.HeaderSet;
import javax.obex.ServerRequestHandler;

abstract class OBEXSessionBase
implements Connection,
BluetoothConnectionAccess {
    protected boolean isConnected;
    private StreamConnection conn;
    private InputStream is;
    private OutputStream os;
    protected long connectionID;
    protected int mtu = 1024;
    protected Authenticator authenticator;
    protected final OBEXConnectionParams obexConnectionParams;
    protected int packetsCountWrite;
    protected int packetsCountRead;
    private Vector authChallengesSent;
    protected boolean requestSent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBEXSessionBase(StreamConnection conn, OBEXConnectionParams obexConnectionParams) throws IOException {
        if (obexConnectionParams == null) {
            throw new NullPointerException("obexConnectionParams is null");
        }
        this.isConnected = false;
        this.conn = conn;
        this.obexConnectionParams = obexConnectionParams;
        this.mtu = obexConnectionParams.mtu;
        this.connectionID = -1L;
        this.packetsCountWrite = 0;
        this.packetsCountRead = 0;
        boolean initOK = false;
        try {
            this.os = conn.openOutputStream();
            this.is = conn.openInputStream();
            initOK = true;
        }
        finally {
            if (!initOK) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    DebugLog.error("close error", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StreamConnection c = this.conn;
        this.conn = null;
        try {
            try {
                if (this.is != null) {
                    this.is.close();
                    this.is = null;
                }
            }
            finally {
                if (this.os != null) {
                    this.os.close();
                    this.os = null;
                }
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    static OBEXHeaderSetImpl createOBEXHeaderSetImpl() {
        return new OBEXHeaderSetImpl();
    }

    public static HeaderSet createOBEXHeaderSet() {
        return OBEXSessionBase.createOBEXHeaderSetImpl();
    }

    static void validateCreatedHeaderSet(HeaderSet headers) {
        OBEXHeaderSetImpl.validateCreatedHeaderSet(headers);
    }

    protected void writePacket(int commId, OBEXHeaderSetImpl headers) throws IOException {
        this.writePacketWithFlags(commId, null, headers);
    }

    protected synchronized void writePacketWithFlags(int commId, byte[] headerFlagsData, OBEXHeaderSetImpl headers) throws IOException {
        if (this.requestSent) {
            throw new IOException("Write packet out of order");
        }
        this.requestSent = true;
        int len = 3;
        if (this.connectionID != -1L) {
            len += 5;
        }
        if (headerFlagsData != null) {
            len += headerFlagsData.length;
        }
        byte[] data = null;
        if (headers != null) {
            data = OBEXHeaderSetImpl.toByteArray(headers);
            len += data.length;
        }
        if (len > this.mtu) {
            throw new IOException("Can't sent more data than in MTU, len=" + len + ", mtu=" + this.mtu);
        }
        ++this.packetsCountWrite;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OBEXHeaderSetImpl.writeObexLen(buf, commId, len);
        if (headerFlagsData != null) {
            buf.write(headerFlagsData);
        }
        if (this.connectionID != -1L) {
            OBEXHeaderSetImpl.writeObexInt(buf, 203, this.connectionID);
        }
        if (data != null) {
            buf.write(data);
        }
        DebugLog.debug0x("obex send (" + this.packetsCountWrite + ")", OBEXUtils.toStringObexResponseCodes(commId), commId);
        this.os.write(buf.toByteArray());
        this.os.flush();
        DebugLog.debug("obex sent (" + this.packetsCountWrite + ") len", len);
        if (headers != null && headers.hasAuthenticationChallenge()) {
            if (this.authChallengesSent == null) {
                this.authChallengesSent = new Vector();
            }
            Enumeration iter = headers.getAuthenticationChallenges();
            while (iter.hasMoreElements()) {
                byte[] authChallenge = (byte[])iter.nextElement();
                OBEXAuthentication.Challenge challenge = new OBEXAuthentication.Challenge(authChallenge);
                this.authChallengesSent.addElement(challenge);
            }
        }
    }

    protected synchronized byte[] readPacket() throws IOException {
        if (!this.requestSent) {
            throw new IOException("Read packet out of order");
        }
        this.requestSent = false;
        byte[] header = new byte[3];
        OBEXUtils.readFully(this.is, this.obexConnectionParams, header);
        ++this.packetsCountRead;
        DebugLog.debug0x("obex received (" + this.packetsCountRead + ")", OBEXUtils.toStringObexResponseCodes(header[0]), header[0] & 0xFF);
        int lenght = OBEXUtils.bytesToShort(header[1], header[2]);
        if (lenght == 3) {
            return header;
        }
        if (lenght < 3 || lenght > 65535) {
            throw new IOException("Invalid packet length " + lenght);
        }
        byte[] data = new byte[lenght];
        System.arraycopy(header, 0, data, 0, header.length);
        OBEXUtils.readFully(this.is, this.obexConnectionParams, data, header.length, lenght - header.length);
        if (this.is.available() > 0) {
            DebugLog.debug("has more data after read", this.is.available());
        }
        return data;
    }

    private void validateBluetoothConnection() {
        if (this.conn != null && !(this.conn instanceof BluetoothConnectionAccess)) {
            throw new IllegalArgumentException("Not a Bluetooth connection " + this.conn.getClass().getName());
        }
    }

    void validateAuthenticationResponse(OBEXHeaderSetImpl requestHeaders, OBEXHeaderSetImpl incomingHeaders) throws IOException {
        if (requestHeaders != null && requestHeaders.hasAuthenticationChallenge() && !incomingHeaders.hasAuthenticationResponses()) {
            throw new IOException("Authentication response is missing");
        }
        this.handleAuthenticationResponse(incomingHeaders, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleAuthenticationResponse(OBEXHeaderSetImpl incomingHeaders, ServerRequestHandler serverHandler) throws IOException {
        if (incomingHeaders.hasAuthenticationResponses()) {
            if (this.authenticator == null) {
                throw new IOException("Authenticator required for authentication");
            }
            if (this.authChallengesSent == null && this.authChallengesSent.size() == 0) {
                throw new IOException("Authentication challenges had not been sent");
            }
            boolean authenticated = false;
            try {
                authenticated = OBEXAuthentication.handleAuthenticationResponse(incomingHeaders, this.authenticator, serverHandler, this.authChallengesSent);
            }
            finally {
                if (authenticated && this.authChallengesSent != null) {
                    this.authChallengesSent.removeAllElements();
                }
            }
            return authenticated;
        }
        if (this.authChallengesSent != null && this.authChallengesSent.size() > 0) {
            throw new IOException("Authentication response is missing");
        }
        return true;
    }

    void handleAuthenticationChallenge(OBEXHeaderSetImpl incomingHeaders, OBEXHeaderSetImpl replyHeaders) throws IOException {
        if (incomingHeaders.hasAuthenticationChallenge()) {
            if (this.authenticator == null) {
                throw new IOException("Authenticator required for authentication");
            }
            OBEXAuthentication.handleAuthenticationChallenge(incomingHeaders, replyHeaders, this.authenticator);
        }
    }

    public long getRemoteAddress() throws IOException {
        this.validateBluetoothConnection();
        if (this.conn == null) {
            throw new IOException("Connection closed");
        }
        return ((BluetoothConnectionAccess)((Object)this.conn)).getRemoteAddress();
    }

    public RemoteDevice getRemoteDevice() {
        this.validateBluetoothConnection();
        if (this.conn == null) {
            return null;
        }
        return ((BluetoothConnectionAccess)((Object)this.conn)).getRemoteDevice();
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        if (this.conn instanceof BluetoothConnectionAccess) {
            return ((BluetoothConnectionAccess)((Object)this.conn)).isClosed();
        }
        return false;
    }

    public void shutdown() throws IOException {
        if (this.conn instanceof BluetoothConnectionAccess) {
            ((BluetoothConnectionAccess)((Object)this.conn)).shutdown();
        }
    }

    public void markAuthenticated() {
        this.validateBluetoothConnection();
        if (this.conn != null) {
            ((BluetoothConnectionAccess)((Object)this.conn)).markAuthenticated();
        }
    }

    public int getSecurityOpt() {
        this.validateBluetoothConnection();
        if (this.conn == null) {
            return 0;
        }
        return ((BluetoothConnectionAccess)((Object)this.conn)).getSecurityOpt();
    }

    public boolean encrypt(long address, boolean on) throws IOException {
        this.validateBluetoothConnection();
        if (this.conn == null) {
            throw new IOException("Connection closed");
        }
        return ((BluetoothConnectionAccess)((Object)this.conn)).encrypt(address, on);
    }

    public void setRemoteDevice(RemoteDevice remoteDevice) {
        this.validateBluetoothConnection();
        if (this.conn != null) {
            ((BluetoothConnectionAccess)((Object)this.conn)).setRemoteDevice(remoteDevice);
        }
    }

    public BluetoothStack getBluetoothStack() {
        this.validateBluetoothConnection();
        if (this.conn == null) {
            return null;
        }
        return ((BluetoothConnectionAccess)((Object)this.conn)).getBluetoothStack();
    }

    int getPacketsCountWrite() {
        return this.packetsCountWrite;
    }

    int getPacketsCountRead() {
        return this.packetsCountRead;
    }

    int getPacketSize() {
        if (this.isConnected) {
            return this.mtu;
        }
        return this.obexConnectionParams.mtu;
    }

    void setPacketSize(int mtu) throws IOException {
        if (this.isConnected) {
            throw new IOException("Session already connected");
        }
        this.obexConnectionParams.mtu = mtu;
    }
}

