/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierBase;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.BluetoothL2CAPServerConnection;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;

class BluetoothL2CAPConnectionNotifier
extends BluetoothConnectionNotifierBase
implements L2CAPConnectionNotifier {
    private int transmitMTU;
    private int psm = -1;

    public BluetoothL2CAPConnectionNotifier(BluetoothStack bluetoothStack, BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU) throws IOException {
        super(bluetoothStack, params);
        this.handle = bluetoothStack.l2ServerOpen(params, receiveMTU, transmitMTU, this.serviceRecord);
        this.psm = this.serviceRecord.getChannel(BluetoothConsts.L2CAP_PROTOCOL_UUID);
        this.transmitMTU = transmitMTU;
        this.serviceRecord.attributeUpdated = false;
        this.securityOpt = Utils.securityOpt(params.authenticate, params.encrypt);
        this.connectionCreated();
    }

    public L2CAPConnection acceptAndOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Notifier is closed");
        }
        this.updateServiceRecord(true);
        try {
            long clientHandle = this.bluetoothStack.l2ServerAcceptAndOpenServerConnection(this.handle);
            int clientSecurityOpt = this.bluetoothStack.l2GetSecurityOpt(clientHandle, this.securityOpt);
            return new BluetoothL2CAPServerConnection(this.bluetoothStack, clientHandle, this.transmitMTU, clientSecurityOpt);
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            if (this.closed) {
                throw new InterruptedIOException("Notifier has been closed; " + e.getMessage());
            }
            throw e;
        }
    }

    protected void stackServerClose(long handle) throws IOException {
        this.bluetoothStack.l2ServerClose(handle, this.serviceRecord);
    }

    protected void validateServiceRecord(ServiceRecord srvRecord) {
        if (this.psm != this.serviceRecord.getChannel(BluetoothConsts.L2CAP_PROTOCOL_UUID)) {
            throw new IllegalArgumentException("Must not change the PSM");
        }
        super.validateServiceRecord(srvRecord);
    }

    protected void updateStackServiceRecord(ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.bluetoothStack.l2ServerUpdateServiceRecord(this.handle, serviceRecord, acceptAndOpen);
    }
}

