-- Standard awesome library
local gears = require("gears")
local awful = require("awful")
awful.rules = require("awful.rules")
require("awful.autofocus")
-- Widget and layout library
local wibox = require("wibox")
-- Theme handling library
local beautiful = require("beautiful")
-- Notification library
local naughty = require("naughty")
local menubar = require("menubar")

-- {{{ Error handling
-- Check if awesome encountered an error during startup and fell back to
-- another config (This code will only ever execute for the fallback config)
if awesome.startup_errors then
    naughty.notify({ preset = naughty.config.presets.critical,
                     title = "Oops, there were errors during startup!",
                     text = awesome.startup_errors })
end

-- Handle runtime errors after startup
do
    local in_error = false
    awesome.connect_signal("debug::error", function (err)
        -- Make sure we don't go into an endless error loop
        if in_error then return end
        in_error = true

        naughty.notify({ preset = naughty.config.presets.critical,
                         title = "Oops, an error happened!",
                         text = err })
        in_error = false
    end)
end
-- }}}

-- {{{ Variable definitions
-- Themes define colours, icons, and wallpapers
beautiful.init("/usr/share/awesome/themes/blackarch/theme.lua")

-- This is used later as the default terminal and editor to run.
terminal = "urxvt"
editor = os.getenv("EDITOR") or "nano"
editor_cmd = terminal .. " -e " .. editor

-- Default modkey.
-- Usually, Mod4 is the key with a logo between Control and Alt.
-- If you do not like this or do not have such a key,
-- I suggest you to remap Mod4 to another key using xmodmap or other tools.
-- However, you can use another modifier like Mod1, but it may interact with others.
modkey = "Mod4"

-- Table of layouts to cover with awful.layout.inc, order matters.
local layouts =
{
    awful.layout.suit.floating,
    awful.layout.suit.tile,
    awful.layout.suit.tile.left,
    awful.layout.suit.tile.bottom,
    awful.layout.suit.tile.top,
    awful.layout.suit.fair,
    awful.layout.suit.fair.horizontal,
    awful.layout.suit.spiral,
    awful.layout.suit.spiral.dwindle,
    awful.layout.suit.max,
    awful.layout.suit.max.fullscreen,
    awful.layout.suit.magnifier
}
-- }}}

-- {{{ Wallpaper
if beautiful.wallpaper then
    for s = 1, screen.count() do
        gears.wallpaper.maximized(beautiful.wallpaper, s, true)
    end
end
-- }}}

-- {{{ Tags
-- Define a tag table which hold all screen tags.
tags = {}
for s = 1, screen.count() do
    -- Each screen has its own tag table.
    tags[s] = awful.tag({ 1, 2, 3, 4, 5, 6, 7, 8, 9 }, s, layouts[1])
end
-- }}}

-- {{{ Menu
-- Create a laucher widget and a main menu
myawesomemenu = {
    { "manual", terminal .. " -e man awesome" },
    { "edit config", editor_cmd .. " " .. awesome.conffile },
    { "restart", awesome.restart },
    { "quit", awesome.quit }
}

termmenu = {
    { "term (grey)", "urxvt -bg black -fg grey" },
    { "term (red)", "urxvt -bg black -fg red" },
    { "term (green)", "urxvt -bg black -fg green" },
    { "term (yellow)", "urxvt -bg black -fg yellow" },
    { "term (white)", "urxvt -bg black -fg white" }
}

browsermenu = {
    { "firefox", "firefox" },
    { "chromium", "chromium --no-sandbox" }
}

networkmenu = {
    { "wifi-radar", "wifi-radar" },
    { "wifi-radar-polkit", "wifi-radar-polkit" }
}

antiforensicmenu = {
  { "ropeadope", "urxvt -e sh -c 'ropeadope ; bash'" },
  { "saruman", "urxvt -e sh -c 'saruman ; bash'" },
  { "sdel", "urxvt -e sh -c 'sdel -h ; bash'" },
  { "sfill", "urxvt -e sh -c 'sfill -h ; bash'" },
  { "smem-secure-delete", "urxvt -e sh -c 'smem-secure-delete -h ; bash'" },
  { "srm", "urxvt -e sh -c 'srm -h ; bash'" },
  { "sswap", "urxvt -e sh -c 'sswap -h ; bash'" },
  { "steghide", "urxvt -e sh -c 'steghide --help ; bash'" },
}

automationmenu = {
  { "airgeddon", "urxvt -e sh -c 'airgeddon ; bash'" },
  { "apt2", "urxvt -e sh -c 'apt2 -h ; bash'" },
  { "armitage", "urxvt -e sh -c 'armitage -h ; bash'" },
  { "teamserver", "urxvt -e sh -c 'teamserver ; bash'" },
  { "armscgen", "urxvt -e sh -c 'armscgen -h ; bash'" },
  { "atscan", "urxvt -e sh -c 'atscan ; bash'" },
  { "automato", "urxvt -e sh -c 'automato ; bash'" },
  { "autonessus", "urxvt -e sh -c 'autonessus -h ; bash'" },
  { "autonse", "urxvt -e sh -c 'autonse ; bash'" },
  { "autopwn", "urxvt -e sh -c 'autopwn -h ; bash'" },
  { "autopwn-cli", "urxvt -e sh -c 'autopwn-cli ; bash'" },
  { "autorecon", "urxvt -e sh -c 'autorecon -h ; bash'" },
  { "autovpn", "urxvt -e sh -c 'autovpn ; bash'" },
  { "avet", "urxvt -e sh -c 'avet ; bash'" },
  { "awsbucketdump", "urxvt -e sh -c 'awsbucketdump -h ; bash'" },
  { "backdoorme", "urxvt -e sh -c 'backdoorme ; bash'" },
  { "barq", "urxvt -e sh -c 'barq -h ; bash'" },
  { "binex", "urxvt -e sh -c 'binex -h ; bash'" },
  { "blueranger", "urxvt -e sh -c 'blueranger ; bash'" },
  { "brutespray", "urxvt -e sh -c 'brutespray -h ; bash'" },
  { "brutex", "urxvt -e sh -c 'brutex ; bash'" },
  { "brutex-masscan", "urxvt -e sh -c 'brutex-masscan ; bash'" },
  { "byepass", "urxvt -e sh -c 'byepass -h ; bash'" },
  { "passtime", "urxvt -e sh -c 'passtime -h ; bash'" },
  { "cewl", "urxvt -e sh -c 'cewl -h ; bash'" },
  { "cewl-fab", "urxvt -e sh -c 'cewl-fab ; bash'" },
  { "checksec", "urxvt -e sh -c 'checksec --help ; bash'" },
  { "cisco-snmp-enumeration", "urxvt -e sh -c 'cisco-snmp-enumeration ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "zuul-es5.yml", "urxvt -e sh -c 'zuul-es5.yml ; bash'" },
  { "zuul-es6.yml", "urxvt -e sh -c 'zuul-es6.yml ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "_mocha", "urxvt -e sh -c '_mocha ; bash'" },
  { "mocha", "urxvt -e sh -c 'mocha ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "clusterd", "urxvt -e sh -c 'clusterd -h ; bash'" },
  { "cmsmap", "urxvt -e sh -c 'cmsmap -h ; bash'" },
  { "codeql", "urxvt -e sh -c 'codeql ; bash'" },
  { "java", "urxvt -e sh -c 'java ; bash'" },
  { "javac", "urxvt -e sh -c 'javac ; bash'" },
  { "keytool", "urxvt -e sh -c 'keytool ; bash'" },
  { "rmid", "urxvt -e sh -c 'rmid ; bash'" },
  { "rmiregistry", "urxvt -e sh -c 'rmiregistry ; bash'" },
  { "serialver", "urxvt -e sh -c 'serialver ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "java", "urxvt -e sh -c 'java ; bash'" },
  { "javac", "urxvt -e sh -c 'javac ; bash'" },
  { "keytool", "urxvt -e sh -c 'keytool ; bash'" },
  { "rmid", "urxvt -e sh -c 'rmid ; bash'" },
  { "rmiregistry", "urxvt -e sh -c 'rmiregistry ; bash'" },
  { "serialver", "urxvt -e sh -c 'serialver ; bash'" },
  { "commix", "urxvt -e sh -c 'commix ; bash'" },
  { "commonspeak", "urxvt -e sh -c 'commonspeak -h ; bash'" },
  { "cook", "urxvt -e sh -c 'cook -h ; bash'" },
  { "crunch", "urxvt -e sh -c 'crunch -h ; bash'" },
  { "darkspiritz", "urxvt -e sh -c 'darkspiritz -h ; bash'" },
  { "deathstar", "urxvt -e sh -c 'deathstar -h ; bash'" },
  { "domained", "urxvt -e sh -c 'domained -h ; bash'" },
  { "dorknet", "urxvt -e sh -c 'dorknet -h ; bash'" },
  { "dracnmap", "urxvt -e sh -c 'dracnmap ; bash'" },
  { "dracnmap-drac0s", "urxvt -e sh -c 'dracnmap-drac0s ; bash'" },
  { "dumb0", "urxvt -e sh -c 'dumb0 -h ; bash'" },
  { "easy-creds", "urxvt -e sh -c 'easy-creds ; bash'" },
  { "easyda", "urxvt -e sh -c 'easyda ; bash'" },
  { "empire", "urxvt -e sh -c 'empire -h ; bash'" },
  { "faraday-manage", "urxvt -e sh -c 'faraday-manage ; bash'" },
  { "faraday-searcher", "urxvt -e sh -c 'faraday-searcher ; bash'" },
  { "faraday-server", "urxvt -e sh -c 'faraday-server ; bash'" },
  { "firstorder", "urxvt -e sh -c 'firstorder -h ; bash'" },
  { "fstealer", "urxvt -e sh -c 'fstealer -h ; bash'" },
  { "gitdump", "urxvt -e sh -c 'gitdump ; bash'" },
  { "githubcloner", "urxvt -e sh -c 'githubcloner -h ; bash'" },
  { "glue", "urxvt -e sh -c 'glue -h ; bash'" },
  { "goohak", "urxvt -e sh -c 'goohak ; bash'" },
  { "gooscan", "urxvt -e sh -c 'gooscan -h ; bash'" },
  { "harpoon", "urxvt -e sh -c 'harpoon -h ; bash'" },
  { "hate-crack", "urxvt -e sh -c 'hate-crack ; bash'" },
  { "iloscan", "urxvt -e sh -c 'iloscan ; bash'" },
  { "intersect-create", "urxvt -e sh -c 'intersect-create ; bash'" },
  { "inurlbr", "urxvt -e sh -c 'inurlbr -h ; bash'" },
  { "ipmipwn", "urxvt -e sh -c 'ipmipwn ; bash'" },
  { "jaidam", "urxvt -e sh -c 'jaidam ; bash'" },
  { "unix-jboss-autopwn", "urxvt -e sh -c 'unix-jboss-autopwn ; bash'" },
  { "win-jboss-autopwn", "urxvt -e sh -c 'win-jboss-autopwn ; bash'" },
  { "kernelpop", "urxvt -e sh -c 'kernelpop -h ; bash'" },
  { "killcast", "urxvt -e sh -c 'killcast -h ; bash'" },
  { "koadic", "urxvt -e sh -c 'koadic ; bash'" },
  { "dynwrapx.manifest", "urxvt -e sh -c 'dynwrapx.manifest ; bash'" },
  { "lazydroid", "urxvt -e sh -c 'lazydroid ; bash'" },
  { "ldapaddgroup", "urxvt -e sh -c 'ldapaddgroup -h ; bash'" },
  { "ldapaddmachine", "urxvt -e sh -c 'ldapaddmachine -h ; bash'" },
  { "ldapadduser", "urxvt -e sh -c 'ldapadduser -h ; bash'" },
  { "ldapaddusertogroup", "urxvt -e sh -c 'ldapaddusertogroup -h ; bash'" },
  { "ldapdeletegroup", "urxvt -e sh -c 'ldapdeletegroup -h ; bash'" },
  { "ldapdeletemachine", "urxvt -e sh -c 'ldapdeletemachine -h ; bash'" },
  { "ldapdeleteuser", "urxvt -e sh -c 'ldapdeleteuser -h ; bash'" },
  { "ldapdeleteuserfromgroup", "urxvt -e sh -c 'ldapdeleteuserfromgroup -h ; bash'" },
  { "ldapfinger", "urxvt -e sh -c 'ldapfinger -h ; bash'" },
  { "ldapgid", "urxvt -e sh -c 'ldapgid -h ; bash'" },
  { "ldapid", "urxvt -e sh -c 'ldapid -h ; bash'" },
  { "ldapinit", "urxvt -e sh -c 'ldapinit -h ; bash'" },
  { "ldapmodifygroup", "urxvt -e sh -c 'ldapmodifygroup -h ; bash'" },
  { "ldapmodifymachine", "urxvt -e sh -c 'ldapmodifymachine -h ; bash'" },
  { "ldapmodifyuser", "urxvt -e sh -c 'ldapmodifyuser -h ; bash'" },
  { "ldaprenamegroup", "urxvt -e sh -c 'ldaprenamegroup -h ; bash'" },
  { "ldaprenamemachine", "urxvt -e sh -c 'ldaprenamemachine -h ; bash'" },
  { "ldaprenameuser", "urxvt -e sh -c 'ldaprenameuser -h ; bash'" },
  { "lsldap", "urxvt -e sh -c 'lsldap -h ; bash'" },
  { "legion", "urxvt -e sh -c 'legion -h ; bash'" },
  { "linikatz", "urxvt -e sh -c 'linikatz ; bash'" },
  { "linset", "urxvt -e sh -c 'linset ; bash'" },
  { "lyricpass", "urxvt -e sh -c 'lyricpass -h ; bash'" },
  { "maskprocessor", "urxvt -e sh -c 'maskprocessor -h ; bash'" },
  { "massbleed", "urxvt -e sh -c 'massbleed ; bash'" },
  { "masscan-automation", "urxvt -e sh -c 'masscan-automation -h ; bash'" },
  { "massexpconsole", "urxvt -e sh -c 'massexpconsole ; bash'" },
  { "mentalist", "urxvt -e sh -c 'mentalist ; bash'" },
  { "merlin-server", "urxvt -e sh -c 'merlin-server -h ; bash'" },
  { "mitmap-old", "urxvt -e sh -c 'mitmap-old -h ; bash'" },
  { "morpheus", "urxvt -e sh -c 'morpheus ; bash'" },
  { "etter.dns", "urxvt -e sh -c 'etter.dns ; bash'" },
  { "http.lua", "urxvt -e sh -c 'http.lua ; bash'" },
  { "warn.ogg", "urxvt -e sh -c 'warn.ogg ; bash'" },
  { "msf-mpc", "urxvt -e sh -c 'msf-mpc -h ; bash'" },
  { "msfenum", "urxvt -e sh -c 'msfenum -h ; bash'" },
  { "multiscanner", "urxvt -e sh -c 'multiscanner -h ; bash'" },
  { "multiscanner-api", "urxvt -e sh -c 'multiscanner-api ; bash'" },
  { "multiscanner-web", "urxvt -e sh -c 'multiscanner-web ; bash'" },
  { "mutator", "urxvt -e sh -c 'mutator -h ; bash'" },
  { "nettacker", "urxvt -e sh -c 'nettacker -h ; bash'" },
  { "nosqlattack", "urxvt -e sh -c 'nosqlattack ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "autotailor", "urxvt -e sh -c 'autotailor ; bash'" },
  { "oscap", "urxvt -e sh -c 'oscap -h ; bash'" },
  { "oscap-chroot", "urxvt -e sh -c 'oscap-chroot -h ; bash'" },
  { "oscap-docker", "urxvt -e sh -c 'oscap-docker -h ; bash'" },
  { "oscap-podman", "urxvt -e sh -c 'oscap-podman -h ; bash'" },
  { "oscap-run-sce-script", "urxvt -e sh -c 'oscap-run-sce-script ; bash'" },
  { "oscap-vm", "urxvt -e sh -c 'oscap-vm -h ; bash'" },
  { "scap-as-rpm", "urxvt -e sh -c 'scap-as-rpm -h ; bash'" },
  { "osslsigncode", "urxvt -e sh -c 'osslsigncode -h ; bash'" },
  { "owtf", "urxvt -e sh -c 'owtf ; bash'" },
  { "panoptic", "urxvt -e sh -c 'panoptic -h ; bash'" },
  { "pastejacker", "urxvt -e sh -c 'pastejacker ; bash'" },
  { "pasv-agrsv", "urxvt -e sh -c 'pasv-agrsv -h ; bash'" },
  { "penbox", "urxvt -e sh -c 'penbox ; bash'" },
  { "pentestly", "urxvt -e sh -c 'pentestly -h ; bash'" },
  { "pentmenu", "urxvt -e sh -c 'pentmenu ; bash'" },
  { "phemail", "urxvt -e sh -c 'phemail -h ; bash'" },
  { "pin", "urxvt -e sh -c 'pin ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "pindb.sig", "urxvt -e sh -c 'pindb.sig ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "pindb.sig", "urxvt -e sh -c 'pindb.sig ; bash'" },
  { "pmcma", "urxvt -e sh -c 'pmcma ; bash'" },
  { "portia", "urxvt -e sh -c 'portia ; bash'" },
  { "ptf", "urxvt -e sh -c 'ptf ; bash'" },
  { "pureblood", "urxvt -e sh -c 'pureblood ; bash'" },
  { "pwndrop", "urxvt -e sh -c 'pwndrop -h ; bash'" },
  { "pyfuscation", "urxvt -e sh -c 'pyfuscation -h ; bash'" },
  { "arsenic-check-ie11", "urxvt -e sh -c 'arsenic-check-ie11 ; bash'" },
  { "shodan", "urxvt -e sh -c 'shodan ; bash'" },
  { "shodan2", "urxvt -e sh -c 'shodan2 ; bash'" },
  { "recomposer", "urxvt -e sh -c 'recomposer -h ; bash'" },
  { "rhodiola", "urxvt -e sh -c 'rhodiola -h ; bash'" },
  { "rsmangler", "urxvt -e sh -c 'rsmangler -h ; bash'" },
  { "sakis3g", "urxvt -e sh -c 'sakis3g --help ; bash'" },
  { "sandmap", "urxvt -e sh -c 'sandmap --help ; bash'" },
  { "sc-make", "urxvt -e sh -c 'sc-make ; bash'" },
  { "scap-workbench", "urxvt -e sh -c 'scap-workbench ; bash'" },
  { "search1337", "urxvt -e sh -c 'search1337 ; bash'" },
  { "sharesniffer", "urxvt -e sh -c 'sharesniffer -h ; bash'" },
  { "shellerator", "urxvt -e sh -c 'shellerator -h ; bash'" },
  { "shellme", "urxvt -e sh -c 'shellme -h ; bash'" },
  { "shellpop", "urxvt -e sh -c 'shellpop -h ; bash'" },
  { "sign", "urxvt -e sh -c 'sign ; bash'" },
  { "sipvicious-svcrack", "urxvt -e sh -c 'sipvicious-svcrack -h ; bash'" },
  { "sipvicious-svmap", "urxvt -e sh -c 'sipvicious-svmap -h ; bash'" },
  { "sipvicious-svreport", "urxvt -e sh -c 'sipvicious-svreport -h ; bash'" },
  { "sipvicious-svwar", "urxvt -e sh -c 'sipvicious-svwar -h ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "sn1per", "urxvt -e sh -c 'sn1per ; bash'" },
  { "http-default-accounts-fingerprints-nndefaccts.lua", "urxvt -e sh -c 'http-default-accounts-fingerprints-nndefaccts.lua ; bash'" },
  { "inurlbr.php", "urxvt -e sh -c 'inurlbr.php ; bash'" },
  { "nmap-bootstrap.xsl", "urxvt -e sh -c 'nmap-bootstrap.xsl ; bash'" },
  { "spookflare", "urxvt -e sh -c 'spookflare ; bash'" },
  { "ssl-phuck3r", "urxvt -e sh -c 'ssl-phuck3r -h ; bash'" },
  { "statsprocessor", "urxvt -e sh -c 'statsprocessor --help ; bash'" },
  { "thefatrat", "urxvt -e sh -c 'thefatrat cd /usr/share/thefatrat ; ls ; bash'" },
  { "tiger", "urxvt -e sh -c 'tiger -h ; bash'" },
  { "tlssled", "urxvt -e sh -c 'tlssled -h ; bash'" },
  { "torctl", "urxvt -e sh -c 'torctl ; bash'" },
  { "traxss", "urxvt -e sh -c 'traxss -h ; bash'" },
  { "ttpassgen", "urxvt -e sh -c 'ttpassgen -h ; bash'" },
  { "unix-privsc-check", "urxvt -e sh -c 'unix-privsc-check ; bash'" },
  { "username-anarchy", "urxvt -e sh -c 'username-anarchy -h ; bash'" },
  { "usernamer", "urxvt -e sh -c 'usernamer -h ; bash'" },
  { "valhalla-cli", "urxvt -e sh -c 'valhalla-cli -h ; bash'" },
  { "vbsmin", "urxvt -e sh -c 'vbsmin -h ; bash'" },
  { "veil", "urxvt -e sh -c 'veil ; bash'" },
  { "vlan-hopping", "urxvt -e sh -c 'vlan-hopping ; bash'" },
  { "voiphopper", "urxvt -e sh -c 'voiphopper -h ; bash'" },
  { "wifi-autopwner", "urxvt -e sh -c 'wifi-autopwner -h ; bash'" },
  { "wikigen", "urxvt -e sh -c 'wikigen ; bash'" },
  { "wnmap", "urxvt -e sh -c 'wnmap -h ; bash'" },
  { "xcat", "urxvt -e sh -c 'xcat ; bash'" },
  { "yinjector", "urxvt -e sh -c 'yinjector -h ; bash'" },
  { "zeratool", "urxvt -e sh -c 'zeratool -h ; bash'" },
  { "zirikatu", "urxvt -e sh -c 'zirikatu ; bash'" },
}

automobilemenu = {
  { "asc2log", "urxvt -e sh -c 'asc2log ; bash'" },
  { "bcmserver", "urxvt -e sh -c 'bcmserver ; bash'" },
  { "can-calc-bit-timing", "urxvt -e sh -c 'can-calc-bit-timing ; bash'" },
  { "canbusload", "urxvt -e sh -c 'canbusload ; bash'" },
  { "candump", "urxvt -e sh -c 'candump ; bash'" },
  { "canfdtest", "urxvt -e sh -c 'canfdtest ; bash'" },
  { "cangen", "urxvt -e sh -c 'cangen ; bash'" },
  { "cangw", "urxvt -e sh -c 'cangw ; bash'" },
  { "canlogserver", "urxvt -e sh -c 'canlogserver ; bash'" },
  { "cansend", "urxvt -e sh -c 'cansend ; bash'" },
  { "cansequence", "urxvt -e sh -c 'cansequence ; bash'" },
  { "cansniffer", "urxvt -e sh -c 'cansniffer ; bash'" },
  { "isotpdump", "urxvt -e sh -c 'isotpdump ; bash'" },
  { "isotpperf", "urxvt -e sh -c 'isotpperf ; bash'" },
  { "isotprecv", "urxvt -e sh -c 'isotprecv ; bash'" },
  { "isotptun", "urxvt -e sh -c 'isotptun ; bash'" },
  { "j1939acd", "urxvt -e sh -c 'j1939acd ; bash'" },
  { "j1939cat", "urxvt -e sh -c 'j1939cat ; bash'" },
  { "j1939sr", "urxvt -e sh -c 'j1939sr ; bash'" },
  { "log2asc", "urxvt -e sh -c 'log2asc ; bash'" },
  { "log2long", "urxvt -e sh -c 'log2long ; bash'" },
  { "mcp251xfd-dump", "urxvt -e sh -c 'mcp251xfd-dump ; bash'" },
  { "slcan_attach", "urxvt -e sh -c 'slcan_attach ; bash'" },
  { "slcand", "urxvt -e sh -c 'slcand ; bash'" },
  { "slcanpty", "urxvt -e sh -c 'slcanpty ; bash'" },
  { "testj1939", "urxvt -e sh -c 'testj1939 ; bash'" },
  { "canalyzat0r", "urxvt -e sh -c 'canalyzat0r ; bash'" },
  { "cantoolz", "urxvt -e sh -c 'cantoolz -h ; bash'" },
  { "udsim", "urxvt -e sh -c 'udsim -h ; bash'" },
}

backdoormenu = {
  { "arcane", "urxvt -e sh -c 'arcane -h ; bash'" },
  { "avet", "urxvt -e sh -c 'avet ; bash'" },
  { "backcookie", "urxvt -e sh -c 'backcookie -h ; bash'" },
  { "backdoor-factory", "urxvt -e sh -c 'backdoor-factory -h ; bash'" },
  { "backdoorme", "urxvt -e sh -c 'backdoorme ; bash'" },
  { "backdoorppt", "urxvt -e sh -c 'backdoorppt ; bash'" },
  { "barq", "urxvt -e sh -c 'barq -h ; bash'" },
  { "cymothoa-udp_server", "urxvt -e sh -c 'cymothoa-udp_server ; bash'" },
  { "demiguise", "urxvt -e sh -c 'demiguise -h ; bash'" },
  { "donut", "urxvt -e sh -c 'donut -h ; bash'" },
  { "dr0p1t", "urxvt -e sh -c 'dr0p1t -h ; bash'" },
  { "evil-winrm", "urxvt -e sh -c 'evil-winrm -h ; bash'" },
  { "evilpdf", "urxvt -e sh -c 'evilpdf -h ; bash'" },
  { "exe2image", "urxvt -e sh -c 'exe2image ; bash'" },
  { "gobd", "urxvt -e sh -c 'gobd -h ; bash'" },
  { "harness", "urxvt -e sh -c 'harness ; bash'" },
  { "hercules-payload", "urxvt -e sh -c 'hercules-payload ; bash'" },
  { "hotpatcher", "urxvt -e sh -c 'hotpatcher -h ; bash'" },
  { "iloscan", "urxvt -e sh -c 'iloscan ; bash'" },
  { "k55", "urxvt -e sh -c 'k55 -h ; bash'" },
  { "kimi", "urxvt -e sh -c 'kimi -h ; bash'" },
  { "kwetza", "urxvt -e sh -c 'kwetza --help ; bash'" },
  { "interpatch", "urxvt -e sh -c 'interpatch -h ; bash'" },
  { "lfi-image-helper", "urxvt -e sh -c 'lfi-image-helper ; bash'" },
  { "linux-inject", "urxvt -e sh -c 'linux-inject -h ; bash'" },
  { "linux-inject-32", "urxvt -e sh -c 'linux-inject-32 -h ; bash'" },
  { "ms-sys", "urxvt -e sh -c 'ms-sys -h ; bash'" },
  { "msf-mpc", "urxvt -e sh -c 'msf-mpc -h ; bash'" },
  { "msvpwn", "urxvt -e sh -c 'msvpwn -h ; bash'" },
  { "nxcrypt", "urxvt -e sh -c 'nxcrypt -h ; bash'" },
  { "patchkit", "urxvt -e sh -c 'patchkit -h ; bash'" },
  { "pivotsuite", "urxvt -e sh -c 'pivotsuite -h ; bash'" },
  { "pixload-bmp", "urxvt -e sh -c 'pixload-bmp ; bash'" },
  { "pixload-gif", "urxvt -e sh -c 'pixload-gif ; bash'" },
  { "pixload-jpg", "urxvt -e sh -c 'pixload-jpg ; bash'" },
  { "powerstager", "urxvt -e sh -c 'powerstager -h ; bash'" },
  { "pwncat", "urxvt -e sh -c 'pwncat cd /usr/share/windows/pwncat ; ls ; bash'" },
  { "pyrasite", "urxvt -e sh -c 'pyrasite -h ; bash'" },
  { "pyrasite-memory-viewer", "urxvt -e sh -c 'pyrasite-memory-viewer ; bash'" },
  { "remot3d", "urxvt -e sh -c 'remot3d ; bash'" },
  { "rrs", "urxvt -e sh -c 'rrs -h ; bash'" },
  { "rspet-client", "urxvt -e sh -c 'rspet-client ; bash'" },
  { "rspet-server", "urxvt -e sh -c 'rspet-server ; bash'" },
  { "saruman", "urxvt -e sh -c 'saruman ; bash'" },
  { "sb0x", "urxvt -e sh -c 'sb0x -h ; bash'" },
  { "shellinaboxd", "urxvt -e sh -c 'shellinaboxd -h ; bash'" },
  { "shellter", "urxvt -e sh -c 'shellter ; bash'" },
  { "sherlocked", "urxvt -e sh -c 'sherlocked ; bash'" },
  { "stripx", "urxvt -e sh -c 'stripx ; bash'" },
  { "stub", "urxvt -e sh -c 'stub ; bash'" },
  { "shootback-master", "urxvt -e sh -c 'shootback-master -h ; bash'" },
  { "shootback-slaver", "urxvt -e sh -c 'shootback-slaver -h ; bash'" },
  { "silenttrinity", "urxvt -e sh -c 'silenttrinity -h ; bash'" },
  { "silenttrinity-teamserver", "urxvt -e sh -c 'silenttrinity-teamserver -h ; bash'" },
  { "trixd00r", "urxvt -e sh -c 'trixd00r -H ; bash'" },
  { "u3-pwn", "urxvt -e sh -c 'u3-pwn ; bash'" },
  { "webacoo", "urxvt -e sh -c 'webacoo -h ; bash'" },
  { "webspa", "urxvt -e sh -c 'webspa -help ; bash'" },
  { "weevely", "urxvt -e sh -c 'weevely -h ; bash'" },
}

binarymenu = {
  { "amber", "urxvt -e sh -c 'amber ; bash'" },
  { "amoco", "urxvt -e sh -c 'amoco ; bash'" },
  { "androarsc", "urxvt -e sh -c 'androarsc ; bash'" },
  { "androcg", "urxvt -e sh -c 'androcg ; bash'" },
  { "androdd", "urxvt -e sh -c 'androdd ; bash'" },
  { "androdis", "urxvt -e sh -c 'androdis ; bash'" },
  { "androguard", "urxvt -e sh -c 'androguard -h ; bash'" },
  { "androgui", "urxvt -e sh -c 'androgui ; bash'" },
  { "androlyze", "urxvt -e sh -c 'androlyze ; bash'" },
  { "androsign", "urxvt -e sh -c 'androsign ; bash'" },
  { "angr-management", "urxvt -e sh -c 'angr-management ; bash'" },
  { "avet", "urxvt -e sh -c 'avet ; bash'" },
  { "backdoor-factory", "urxvt -e sh -c 'backdoor-factory -h ; bash'" },
  { "bagbak", "urxvt -e sh -c 'bagbak -h ; bash'" },
  { "BARFcfg", "urxvt -e sh -c 'BARFcfg -h ; bash'" },
  { "BARFcg", "urxvt -e sh -c 'BARFcg -h ; bash'" },
  { "BARFgadgets", "urxvt -e sh -c 'BARFgadgets -h ; bash'" },
  { "bdfproxy", "urxvt -e sh -c 'bdfproxy -h ; bash'" },
  { "bgrep", "urxvt -e sh -c 'bgrep ; bash'" },
  { "binaryninja-demo", "urxvt -e sh -c 'binaryninja-demo ; bash'" },
  { "bindead", "urxvt -e sh -c 'bindead ; bash'" },
  { "bindiff", "urxvt -e sh -c 'bindiff ; bash'" },
  { "binexport2dump", "urxvt -e sh -c 'binexport2dump ; bash'" },
  { "binflow", "urxvt -e sh -c 'binflow ; bash'" },
  { "binnavi", "urxvt -e sh -c 'binnavi ; bash'" },
  { "binwalk", "urxvt -e sh -c 'binwalk ; bash'" },
  { "binwally", "urxvt -e sh -c 'binwally -h ; bash'" },
  { "bsdiff", "urxvt -e sh -c 'bsdiff ; bash'" },
  { "bspatch", "urxvt -e sh -c 'bspatch ; bash'" },
  { "bsdiff", "urxvt -e sh -c 'bsdiff ; bash'" },
  { "bspatch", "urxvt -e sh -c 'bspatch ; bash'" },
  { "bmore", "urxvt -e sh -c 'bmore ; bash'" },
  { "bvedit", "urxvt -e sh -c 'bvedit -h ; bash'" },
  { "bvi", "urxvt -e sh -c 'bvi -h ; bash'" },
  { "bview", "urxvt -e sh -c 'bview -h ; bash'" },
  { "bytecode-viewer", "urxvt -e sh -c 'bytecode-viewer ; bash'" },
  { "cminer", "urxvt -e sh -c 'cminer ; bash'" },
  { "damm", "urxvt -e sh -c 'damm -h ; bash'" },
  { "die", "urxvt -e sh -c 'die ; bash'" },
  { "diec", "urxvt -e sh -c 'diec ; bash'" },
  { "dexpatcher", "urxvt -e sh -c 'dexpatcher -h ; bash'" },
  { "dissector", "urxvt -e sh -c 'dissector -h ; bash'" },
  { "dutas", "urxvt -e sh -c 'dutas -h ; bash'" },
  { "dwarf", "urxvt -e sh -c 'dwarf --help ; bash'" },
  { "drinject", "urxvt -e sh -c 'drinject ; bash'" },
  { "drloader", "urxvt -e sh -c 'drloader ; bash'" },
  { "drrun", "urxvt -e sh -c 'drrun ; bash'" },
  { "nudgeunix", "urxvt -e sh -c 'nudgeunix ; bash'" },
  { "drltrace", "urxvt -e sh -c 'drltrace ; bash'" },
  { "drmemory", "urxvt -e sh -c 'drmemory ; bash'" },
  { "symquery", "urxvt -e sh -c 'symquery ; bash'" },
  { "ecfs", "urxvt -e sh -c 'ecfs ; bash'" },
  { "ecfs-handler", "urxvt -e sh -c 'ecfs-handler ; bash'" },
  { "et-flip", "urxvt -e sh -c 'et-flip ; bash'" },
  { "readecfs", "urxvt -e sh -c 'readecfs ; bash'" },
  { "ebfc", "urxvt -e sh -c 'ebfc -h ; bash'" },
  { "elfls", "urxvt -e sh -c 'elfls ; bash'" },
  { "elftoc", "urxvt -e sh -c 'elftoc --help ; bash'" },
  { "infect", "urxvt -e sh -c 'infect ; bash'" },
  { "objres", "urxvt -e sh -c 'objres --help ; bash'" },
  { "sstrip", "urxvt -e sh -c 'sstrip ; bash'" },
  { "ebfc", "urxvt -e sh -c 'ebfc -h ; bash'" },
  { "elfls", "urxvt -e sh -c 'elfls ; bash'" },
  { "elftoc", "urxvt -e sh -c 'elftoc --help ; bash'" },
  { "infect", "urxvt -e sh -c 'infect ; bash'" },
  { "objres", "urxvt -e sh -c 'objres --help ; bash'" },
  { "sstrip", "urxvt -e sh -c 'sstrip ; bash'" },
  { "elfparser-cli", "urxvt -e sh -c 'elfparser-cli --help ; bash'" },
  { "eu-addr2line", "urxvt -e sh -c 'eu-addr2line --help ; bash'" },
  { "eu-ar", "urxvt -e sh -c 'eu-ar --help ; bash'" },
  { "eu-elfcmp", "urxvt -e sh -c 'eu-elfcmp --help ; bash'" },
  { "eu-elfcompress", "urxvt -e sh -c 'eu-elfcompress --help ; bash'" },
  { "eu-elflint", "urxvt -e sh -c 'eu-elflint --help ; bash'" },
  { "eu-findtextrel", "urxvt -e sh -c 'eu-findtextrel --help ; bash'" },
  { "eu-make-debug-archive", "urxvt -e sh -c 'eu-make-debug-archive --help ; bash'" },
  { "eu-nm", "urxvt -e sh -c 'eu-nm --help ; bash'" },
  { "eu-objdump", "urxvt -e sh -c 'eu-objdump --help ; bash'" },
  { "eu-ranlib", "urxvt -e sh -c 'eu-ranlib --help ; bash'" },
  { "eu-readelf", "urxvt -e sh -c 'eu-readelf --help ; bash'" },
  { "eu-size", "urxvt -e sh -c 'eu-size --help ; bash'" },
  { "eu-stack", "urxvt -e sh -c 'eu-stack --help ; bash'" },
  { "eu-strings", "urxvt -e sh -c 'eu-strings --help ; bash'" },
  { "eu-strip", "urxvt -e sh -c 'eu-strip --help ; bash'" },
  { "eu-unstrip", "urxvt -e sh -c 'eu-unstrip --help ; bash'" },
  { "eu-addr2line", "urxvt -e sh -c 'eu-addr2line --help ; bash'" },
  { "eu-ar", "urxvt -e sh -c 'eu-ar --help ; bash'" },
  { "eu-elfcmp", "urxvt -e sh -c 'eu-elfcmp --help ; bash'" },
  { "eu-elfcompress", "urxvt -e sh -c 'eu-elfcompress --help ; bash'" },
  { "eu-elflint", "urxvt -e sh -c 'eu-elflint --help ; bash'" },
  { "eu-findtextrel", "urxvt -e sh -c 'eu-findtextrel --help ; bash'" },
  { "eu-make-debug-archive", "urxvt -e sh -c 'eu-make-debug-archive --help ; bash'" },
  { "eu-nm", "urxvt -e sh -c 'eu-nm --help ; bash'" },
  { "eu-objdump", "urxvt -e sh -c 'eu-objdump --help ; bash'" },
  { "eu-ranlib", "urxvt -e sh -c 'eu-ranlib --help ; bash'" },
  { "eu-readelf", "urxvt -e sh -c 'eu-readelf --help ; bash'" },
  { "eu-size", "urxvt -e sh -c 'eu-size --help ; bash'" },
  { "eu-stack", "urxvt -e sh -c 'eu-stack --help ; bash'" },
  { "eu-strings", "urxvt -e sh -c 'eu-strings --help ; bash'" },
  { "eu-strip", "urxvt -e sh -c 'eu-strip --help ; bash'" },
  { "eu-unstrip", "urxvt -e sh -c 'eu-unstrip --help ; bash'" },
  { "e2dbg32", "urxvt -e sh -c 'e2dbg32 ; bash'" },
  { "e2dbg64", "urxvt -e sh -c 'e2dbg64 ; bash'" },
  { "etrace32", "urxvt -e sh -c 'etrace32 ; bash'" },
  { "etrace64", "urxvt -e sh -c 'etrace64 ; bash'" },
  { "evarista32", "urxvt -e sh -c 'evarista32 ; bash'" },
  { "evarista64", "urxvt -e sh -c 'evarista64 ; bash'" },
  { "kedbg32", "urxvt -e sh -c 'kedbg32 ; bash'" },
  { "kedbg64", "urxvt -e sh -c 'kedbg64 ; bash'" },
  { "evilize", "urxvt -e sh -c 'evilize -h ; bash'" },
  { "exe2image", "urxvt -e sh -c 'exe2image ; bash'" },
  { "exescan", "urxvt -e sh -c 'exescan ; bash'" },
  { "expimp-lookup", "urxvt -e sh -c 'expimp-lookup ; bash'" },
  { "expose", "urxvt -e sh -c 'expose ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "compress", "urxvt -e sh -c 'compress ; bash'" },
  { "lint", "urxvt -e sh -c 'lint ; bash'" },
  { "release", "urxvt -e sh -c 'release ; bash'" },
  { "source-highlight", "urxvt -e sh -c 'source-highlight ; bash'" },
  { ".coverrc", "urxvt -e sh -c '.coverrc ; bash'" },
  { "cover", "urxvt -e sh -c 'cover ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "compress", "urxvt -e sh -c 'compress ; bash'" },
  { "lint", "urxvt -e sh -c 'lint ; bash'" },
  { "release", "urxvt -e sh -c 'release ; bash'" },
  { "source-highlight", "urxvt -e sh -c 'source-highlight ; bash'" },
  { ".coverrc", "urxvt -e sh -c '.coverrc ; bash'" },
  { "cover", "urxvt -e sh -c 'cover ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "frida-ios-dump", "urxvt -e sh -c 'frida-ios-dump -h ; bash'" },
  { "gadgetinspector", "urxvt -e sh -c 'gadgetinspector ; bash'" },
  { "gdbgui", "urxvt -e sh -c 'gdbgui -h ; bash'" },
  { "haystack-find-heap", "urxvt -e sh -c 'haystack-find-heap ; bash'" },
  { "haystack-live-dump", "urxvt -e sh -c 'haystack-live-dump ; bash'" },
  { "haystack-live-watch", "urxvt -e sh -c 'haystack-live-watch ; bash'" },
  { "haystack-rekall-dump", "urxvt -e sh -c 'haystack-rekall-dump ; bash'" },
  { "haystack-search", "urxvt -e sh -c 'haystack-search ; bash'" },
  { "haystack-volatility-dump", "urxvt -e sh -c 'haystack-volatility-dump ; bash'" },
  { "hercules-payload", "urxvt -e sh -c 'hercules-payload ; bash'" },
  { "hopper", "urxvt -e sh -c 'hopper ; bash'" },
  { "jpegdump", "urxvt -e sh -c 'jpegdump -h ; bash'" },
  { "jwscan", "urxvt -e sh -c 'jwscan -h ; bash'" },
  { "gen-bout", "urxvt -e sh -c 'gen-bout ; bash'" },
  { "gen-random-bout", "urxvt -e sh -c 'gen-random-bout ; bash'" },
  { "kleaver", "urxvt -e sh -c 'kleaver -h ; bash'" },
  { "klee", "urxvt -e sh -c 'klee -h ; bash'" },
  { "klee-stats", "urxvt -e sh -c 'klee-stats -h ; bash'" },
  { "ktest-tool", "urxvt -e sh -c 'ktest-tool -h ; bash'" },
  { "lazydroid", "urxvt -e sh -c 'lazydroid ; bash'" },
  { "interpatch", "urxvt -e sh -c 'interpatch -h ; bash'" },
  { "leena", "urxvt -e sh -c 'leena ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "cake", "urxvt -e sh -c 'cake ; bash'" },
  { "coffee", "urxvt -e sh -c 'coffee ; bash'" },
  { "grunt", "urxvt -e sh -c 'grunt ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "client", "urxvt -e sh -c 'client ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "without_eval", "urxvt -e sh -c 'without_eval ; bash'" },
  { "linux-inject", "urxvt -e sh -c 'linux-inject -h ; bash'" },
  { "linux-inject-32", "urxvt -e sh -c 'linux-inject-32 -h ; bash'" },
  { "mpclient", "urxvt -e sh -c 'mpclient ; bash'" },
  { "ltrace", "urxvt -e sh -c 'ltrace ; bash'" },
  { "malscan", "urxvt -e sh -c 'malscan ; bash'" },
  { "manticore", "urxvt -e sh -c 'manticore -h ; bash'" },
  { "manticore-verifier", "urxvt -e sh -c 'manticore-verifier ; bash'" },
  { "manul", "urxvt -e sh -c 'manul -h ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "melkor", "urxvt -e sh -c 'melkor -h ; bash'" },
  { "metame", "urxvt -e sh -c 'metame -h ; bash'" },
  { "createnpk", "urxvt -e sh -c 'createnpk ; bash'" },
  { "dumpnpk", "urxvt -e sh -c 'dumpnpk ; bash'" },
  { "unpacknpk", "urxvt -e sh -c 'unpacknpk ; bash'" },
  { "ms-sys", "urxvt -e sh -c 'ms-sys -h ; bash'" },
  { "msvpwn", "urxvt -e sh -c 'msvpwn -h ; bash'" },
  { "objection", "urxvt -e sh -c 'objection --help ; bash'" },
  { "oledump", "urxvt -e sh -c 'oledump -h ; bash'" },
  { "osslsigncode", "urxvt -e sh -c 'osslsigncode -h ; bash'" },
  { "packer", "urxvt -e sh -c 'packer ; bash'" },
  { "packerid", "urxvt -e sh -c 'packerid -h ; bash'" },
  { "patchkit", "urxvt -e sh -c 'patchkit -h ; bash'" },
  { "peframe", "urxvt -e sh -c 'peframe ; bash'" },
  { "pepper", "urxvt -e sh -c 'pepper -h ; bash'" },
  { "pin", "urxvt -e sh -c 'pin ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "pindb.sig", "urxvt -e sh -c 'pindb.sig ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "pindb.sig", "urxvt -e sh -c 'pindb.sig ; bash'" },
  { "pintool", "urxvt -e sh -c 'pintool -h ; bash'" },
  { "pintool2", "urxvt -e sh -c 'pintool2 -h ; bash'" },
  { "pixd", "urxvt -e sh -c 'pixd -h ; bash'" },
  { "plasma-disasm", "urxvt -e sh -c 'plasma-disasm -h ; bash'" },
  { "powerstager", "urxvt -e sh -c 'powerstager -h ; bash'" },
  { "procdump", "urxvt -e sh -c 'procdump ; bash'" },
  { "proctal", "urxvt -e sh -c 'proctal -h ; bash'" },
  { "frida", "urxvt -e sh -c 'frida -h ; bash'" },
  { "frida-create", "urxvt -e sh -c 'frida-create ; bash'" },
  { "frida-discover", "urxvt -e sh -c 'frida-discover -h ; bash'" },
  { "frida-join", "urxvt -e sh -c 'frida-join ; bash'" },
  { "frida-kill", "urxvt -e sh -c 'frida-kill -h ; bash'" },
  { "frida-ls-devices", "urxvt -e sh -c 'frida-ls-devices -h ; bash'" },
  { "frida-trace", "urxvt -e sh -c 'frida-trace -h ; bash'" },
  { "ezhexviewer", "urxvt -e sh -c 'ezhexviewer ; bash'" },
  { "ftguess", "urxvt -e sh -c 'ftguess ; bash'" },
  { "mraptor", "urxvt -e sh -c 'mraptor ; bash'" },
  { "msodde", "urxvt -e sh -c 'msodde ; bash'" },
  { "olebrowse", "urxvt -e sh -c 'olebrowse ; bash'" },
  { "oledir", "urxvt -e sh -c 'oledir ; bash'" },
  { "olefile", "urxvt -e sh -c 'olefile ; bash'" },
  { "oleid", "urxvt -e sh -c 'oleid -h ; bash'" },
  { "olemap", "urxvt -e sh -c 'olemap ; bash'" },
  { "olemeta", "urxvt -e sh -c 'olemeta -h ; bash'" },
  { "oleobj", "urxvt -e sh -c 'oleobj ; bash'" },
  { "oletimes", "urxvt -e sh -c 'oletimes ; bash'" },
  { "olevba", "urxvt -e sh -c 'olevba ; bash'" },
  { "pyxswf", "urxvt -e sh -c 'pyxswf ; bash'" },
  { "rtfobj", "urxvt -e sh -c 'rtfobj ; bash'" },
  { "frida-create2", "urxvt -e sh -c 'frida-create2 ; bash'" },
  { "frida-discover2", "urxvt -e sh -c 'frida-discover2 ; bash'" },
  { "frida-join2", "urxvt -e sh -c 'frida-join2 ; bash'" },
  { "frida-kill2", "urxvt -e sh -c 'frida-kill2 ; bash'" },
  { "frida-ls-devices2", "urxvt -e sh -c 'frida-ls-devices2 ; bash'" },
  { "frida-trace2", "urxvt -e sh -c 'frida-trace2 ; bash'" },
  { "frida2", "urxvt -e sh -c 'frida2 ; bash'" },
  { "ezhexviewer2", "urxvt -e sh -c 'ezhexviewer2 ; bash'" },
  { "ftguess2", "urxvt -e sh -c 'ftguess2 ; bash'" },
  { "mraptor2", "urxvt -e sh -c 'mraptor2 ; bash'" },
  { "msodde2", "urxvt -e sh -c 'msodde2 ; bash'" },
  { "olebrowse2", "urxvt -e sh -c 'olebrowse2 ; bash'" },
  { "oledir2", "urxvt -e sh -c 'oledir2 ; bash'" },
  { "olefile2", "urxvt -e sh -c 'olefile2 ; bash'" },
  { "oleid2", "urxvt -e sh -c 'oleid2 ; bash'" },
  { "olemap2", "urxvt -e sh -c 'olemap2 ; bash'" },
  { "olemeta2", "urxvt -e sh -c 'olemeta2 ; bash'" },
  { "oleobj2", "urxvt -e sh -c 'oleobj2 ; bash'" },
  { "oletimes2", "urxvt -e sh -c 'oletimes2 ; bash'" },
  { "olevba2", "urxvt -e sh -c 'olevba2 ; bash'" },
  { "pyxswf2", "urxvt -e sh -c 'pyxswf2 ; bash'" },
  { "rtfobj2", "urxvt -e sh -c 'rtfobj2 ; bash'" },
  { "quickscope", "urxvt -e sh -c 'quickscope -h ; bash'" },
  { "rbasefind", "urxvt -e sh -c 'rbasefind -h ; bash'" },
  { "recomposer", "urxvt -e sh -c 'recomposer -h ; bash'" },
  { "redress", "urxvt -e sh -c 'redress -h ; bash'" },
  { "ropper", "urxvt -e sh -c 'ropper ; bash'" },
  { "rp-lin-x64", "urxvt -e sh -c 'rp-lin-x64 -h ; bash'" },
  { "saruman", "urxvt -e sh -c 'saruman ; bash'" },
  { "sea", "urxvt -e sh -c 'sea -h ; bash'" },
  { "sgn", "urxvt -e sh -c 'sgn ; bash'" },
  { "sherlocked", "urxvt -e sh -c 'sherlocked ; bash'" },
  { "stripx", "urxvt -e sh -c 'stripx ; bash'" },
  { "stub", "urxvt -e sh -c 'stub ; bash'" },
  { "smap", "urxvt -e sh -c 'smap -h ; bash'" },
  { "soot", "urxvt -e sh -c 'soot -h ; bash'" },
  { "strace", "urxvt -e sh -c 'strace ; bash'" },
  { "strace-log-merge", "urxvt -e sh -c 'strace-log-merge ; bash'" },
  { "strace", "urxvt -e sh -c 'strace ; bash'" },
  { "strace-log-merge", "urxvt -e sh -c 'strace-log-merge ; bash'" },
  { "flarestrings", "urxvt -e sh -c 'flarestrings -h ; bash'" },
  { "rank_strings", "urxvt -e sh -c 'rank_strings -h ; bash'" },
  { "as3compile", "urxvt -e sh -c 'as3compile ; bash'" },
  { "font2swf", "urxvt -e sh -c 'font2swf ; bash'" },
  { "gif2swf", "urxvt -e sh -c 'gif2swf ; bash'" },
  { "jpeg2swf", "urxvt -e sh -c 'jpeg2swf ; bash'" },
  { "pdf2swf", "urxvt -e sh -c 'pdf2swf ; bash'" },
  { "png2swf", "urxvt -e sh -c 'png2swf ; bash'" },
  { "swfbbox", "urxvt -e sh -c 'swfbbox ; bash'" },
  { "swfc", "urxvt -e sh -c 'swfc ; bash'" },
  { "swfdump", "urxvt -e sh -c 'swfdump ; bash'" },
  { "swfextract", "urxvt -e sh -c 'swfextract ; bash'" },
  { "swfrender", "urxvt -e sh -c 'swfrender ; bash'" },
  { "swfstrings", "urxvt -e sh -c 'swfstrings ; bash'" },
  { "wav2swf", "urxvt -e sh -c 'wav2swf ; bash'" },
  { "trid", "urxvt -e sh -c 'trid -h ; bash'" },
  { "truegaze", "urxvt -e sh -c 'truegaze -h ; bash'" },
  { "unifuzzer", "urxvt -e sh -c 'unifuzzer ; bash'" },
  { "unstrip", "urxvt -e sh -c 'unstrip ; bash'" },
  { "upx", "urxvt -e sh -c 'upx -h ; bash'" },
  { "callgrind_annotate", "urxvt -e sh -c 'callgrind_annotate ; bash'" },
  { "callgrind_control", "urxvt -e sh -c 'callgrind_control ; bash'" },
  { "cg_annotate", "urxvt -e sh -c 'cg_annotate ; bash'" },
  { "cg_diff", "urxvt -e sh -c 'cg_diff ; bash'" },
  { "cg_merge", "urxvt -e sh -c 'cg_merge ; bash'" },
  { "ms_print", "urxvt -e sh -c 'ms_print ; bash'" },
  { "valgrind", "urxvt -e sh -c 'valgrind ; bash'" },
  { "valgrind-di-server", "urxvt -e sh -c 'valgrind-di-server ; bash'" },
  { "valgrind-listener", "urxvt -e sh -c 'valgrind-listener ; bash'" },
  { "vgdb", "urxvt -e sh -c 'vgdb ; bash'" },
  { "callgrind_annotate", "urxvt -e sh -c 'callgrind_annotate ; bash'" },
  { "callgrind_control", "urxvt -e sh -c 'callgrind_control ; bash'" },
  { "cg_annotate", "urxvt -e sh -c 'cg_annotate ; bash'" },
  { "cg_diff", "urxvt -e sh -c 'cg_diff ; bash'" },
  { "cg_merge", "urxvt -e sh -c 'cg_merge ; bash'" },
  { "ms_print", "urxvt -e sh -c 'ms_print ; bash'" },
  { "valgrind", "urxvt -e sh -c 'valgrind ; bash'" },
  { "valgrind-di-server", "urxvt -e sh -c 'valgrind-di-server ; bash'" },
  { "valgrind-listener", "urxvt -e sh -c 'valgrind-listener ; bash'" },
  { "vgdb", "urxvt -e sh -c 'vgdb ; bash'" },
  { "veles", "urxvt -e sh -c 'veles ; bash'" },
  { "viper", "urxvt -e sh -c 'viper -h ; bash'" },
  { "volafox", "urxvt -e sh -c 'volafox -h ; bash'" },
  { "wcc", "urxvt -e sh -c 'wcc -h ; bash'" },
  { "wcch", "urxvt -e sh -c 'wcch -h ; bash'" },
  { "wld", "urxvt -e sh -c 'wld -h ; bash'" },
  { "wldd", "urxvt -e sh -c 'wldd -h ; bash'" },
  { "wxHexEditor", "urxvt -e sh -c 'wxHexEditor ; bash'" },
  { "zelos", "urxvt -e sh -c 'zelos -h ; bash'" },
}

bluetoothmenu = {
  { "bleah", "urxvt -e sh -c 'bleah -h ; bash'" },
  { "blue-hydra", "urxvt -e sh -c 'blue-hydra -h ; bash'" },
  { "blue_hydra", "urxvt -e sh -c 'blue_hydra ; bash'" },
  { "rfkill-reset", "urxvt -e sh -c 'rfkill-reset ; bash'" },
  { "test-discovery", "urxvt -e sh -c 'test-discovery ; bash'" },
  { "bluebugger", "urxvt -e sh -c 'bluebugger -h ; bash'" },
  { "attest", "urxvt -e sh -c 'attest ; bash'" },
  { "bluediving-bdaddr", "urxvt -e sh -c 'bluediving-bdaddr ; bash'" },
  { "btftp", "urxvt -e sh -c 'btftp ; bash'" },
  { "btobex", "urxvt -e sh -c 'btobex ; bash'" },
  { "hstest", "urxvt -e sh -c 'hstest ; bash'" },
  { "l2cap-packet", "urxvt -e sh -c 'l2cap-packet ; bash'" },
  { "bluefog", "urxvt -e sh -c 'bluefog ; bash'" },
  { "bluelog", "urxvt -e sh -c 'bluelog -h ; bash'" },
  { "bluepot", "urxvt -e sh -c 'bluepot ; bash'" },
  { "blueprint", "urxvt -e sh -c 'blueprint -h ; bash'" },
  { "blueranger", "urxvt -e sh -c 'blueranger ; bash'" },
  { "bluescan", "urxvt -e sh -c 'bluescan ; bash'" },
  { "bluesnarfer", "urxvt -e sh -c 'bluesnarfer -h ; bash'" },
  { "braces", "urxvt -e sh -c 'braces -h ; bash'" },
  { "bss", "urxvt -e sh -c 'bss -h ; bash'" },
  { "psm_scan", "urxvt -e sh -c 'psm_scan -h ; bash'" },
  { "rfcomm_scan", "urxvt -e sh -c 'rfcomm_scan -h ; bash'" },
  { "btlejack", "urxvt -e sh -c 'btlejack ; bash'" },
  { "btproxy-mitm", "urxvt -e sh -c 'btproxy-mitm -h ; bash'" },
  { "btscanner", "urxvt -e sh -c 'btscanner --help ; bash'" },
  { "carwhisperer", "urxvt -e sh -c 'carwhisperer -h ; bash'" },
  { "crackle", "urxvt -e sh -c 'crackle ; bash'" },
  { "fl0p", "urxvt -e sh -c 'fl0p -h ; bash'" },
  { "ghettotooth", "urxvt -e sh -c 'ghettotooth ; bash'" },
  { "hidattack", "urxvt -e sh -c 'hidattack -h ; bash'" },
  { "obexstress", "urxvt -e sh -c 'obexstress -h ; bash'" },
  { "redfang", "urxvt -e sh -c 'redfang --help ; bash'" },
  { "spooftooph", "urxvt -e sh -c 'spooftooph -h ; bash'" },
  { "tanya", "urxvt -e sh -c 'tanya ; bash'" },
  { "tbear", "urxvt -e sh -c 'tbear -h ; bash'" },
  { "tbsearch", "urxvt -e sh -c 'tbsearch ; bash'" },
  { "ubertooth-afh", "urxvt -e sh -c 'ubertooth-afh ; bash'" },
  { "ubertooth-btbr", "urxvt -e sh -c 'ubertooth-btbr ; bash'" },
  { "ubertooth-btle", "urxvt -e sh -c 'ubertooth-btle -h ; bash'" },
  { "ubertooth-debug", "urxvt -e sh -c 'ubertooth-debug ; bash'" },
  { "ubertooth-dfu", "urxvt -e sh -c 'ubertooth-dfu ; bash'" },
  { "ubertooth-ducky", "urxvt -e sh -c 'ubertooth-ducky ; bash'" },
  { "ubertooth-dump", "urxvt -e sh -c 'ubertooth-dump -h ; bash'" },
  { "ubertooth-ego", "urxvt -e sh -c 'ubertooth-ego ; bash'" },
  { "ubertooth-follow", "urxvt -e sh -c 'ubertooth-follow -h ; bash'" },
  { "ubertooth-rx", "urxvt -e sh -c 'ubertooth-rx ; bash'" },
  { "ubertooth-scan", "urxvt -e sh -c 'ubertooth-scan ; bash'" },
  { "ubertooth-specan", "urxvt -e sh -c 'ubertooth-specan -h ; bash'" },
  { "ubertooth-specan-ui", "urxvt -e sh -c 'ubertooth-specan-ui ; bash'" },
  { "ubertooth-tx", "urxvt -e sh -c 'ubertooth-tx ; bash'" },
  { "ubertooth-util", "urxvt -e sh -c 'ubertooth-util -h ; bash'" },
}

codeauditmenu = {
  { "androwarn", "urxvt -e sh -c 'androwarn -h ; bash'" },
  { "bof-detector", "urxvt -e sh -c 'bof-detector -h ; bash'" },
  { "brakeman", "urxvt -e sh -c 'brakeman ; bash'" },
  { "cflow", "urxvt -e sh -c 'cflow -h ; bash'" },
  { "codeql", "urxvt -e sh -c 'codeql ; bash'" },
  { "java", "urxvt -e sh -c 'java ; bash'" },
  { "javac", "urxvt -e sh -c 'javac ; bash'" },
  { "keytool", "urxvt -e sh -c 'keytool ; bash'" },
  { "rmid", "urxvt -e sh -c 'rmid ; bash'" },
  { "rmiregistry", "urxvt -e sh -c 'rmiregistry ; bash'" },
  { "serialver", "urxvt -e sh -c 'serialver ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "java", "urxvt -e sh -c 'java ; bash'" },
  { "javac", "urxvt -e sh -c 'javac ; bash'" },
  { "keytool", "urxvt -e sh -c 'keytool ; bash'" },
  { "rmid", "urxvt -e sh -c 'rmid ; bash'" },
  { "rmiregistry", "urxvt -e sh -c 'rmiregistry ; bash'" },
  { "serialver", "urxvt -e sh -c 'serialver ; bash'" },
  { "cppcheck", "urxvt -e sh -c 'cppcheck -h ; bash'" },
  { "cppcheck-gui", "urxvt -e sh -c 'cppcheck-gui ; bash'" },
  { "cppcheck-htmlreport", "urxvt -e sh -c 'cppcheck-htmlreport -h ; bash'" },
  { "cppcheck", "urxvt -e sh -c 'cppcheck -h ; bash'" },
  { "cppcheck-gui", "urxvt -e sh -c 'cppcheck-gui ; bash'" },
  { "cppcheck-htmlreport", "urxvt -e sh -c 'cppcheck-htmlreport -h ; bash'" },
  { "detect-secrets", "urxvt -e sh -c 'detect-secrets -h ; bash'" },
  { "detect-secrets-hook", "urxvt -e sh -c 'detect-secrets-hook -h ; bash'" },
  { "devaudit", "urxvt -e sh -c 'devaudit -h ; bash'" },
  { "dscanner", "urxvt -e sh -c 'dscanner -h ; bash'" },
  { "expose", "urxvt -e sh -c 'expose ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "compress", "urxvt -e sh -c 'compress ; bash'" },
  { "lint", "urxvt -e sh -c 'lint ; bash'" },
  { "release", "urxvt -e sh -c 'release ; bash'" },
  { "source-highlight", "urxvt -e sh -c 'source-highlight ; bash'" },
  { ".coverrc", "urxvt -e sh -c '.coverrc ; bash'" },
  { "cover", "urxvt -e sh -c 'cover ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "compress", "urxvt -e sh -c 'compress ; bash'" },
  { "lint", "urxvt -e sh -c 'lint ; bash'" },
  { "release", "urxvt -e sh -c 'release ; bash'" },
  { "source-highlight", "urxvt -e sh -c 'source-highlight ; bash'" },
  { ".coverrc", "urxvt -e sh -c '.coverrc ; bash'" },
  { "cover", "urxvt -e sh -c 'cover ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "flawfinder", "urxvt -e sh -c 'flawfinder -h ; bash'" },
  { "git-dump", "urxvt -e sh -c 'git-dump ; bash'" },
  { "graudit", "urxvt -e sh -c 'graudit -h ; bash'" },
  { "leena", "urxvt -e sh -c 'leena ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "cake", "urxvt -e sh -c 'cake ; bash'" },
  { "coffee", "urxvt -e sh -c 'coffee ; bash'" },
  { "grunt", "urxvt -e sh -c 'grunt ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "client", "urxvt -e sh -c 'client ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "without_eval", "urxvt -e sh -c 'without_eval ; bash'" },
  { "mosca", "urxvt -e sh -c 'mosca ; bash'" },
  { "peach-fuzz", "urxvt -e sh -c 'peach-fuzz -h ; bash'" },
  { "codequery", "urxvt -e sh -c 'codequery ; bash'" },
  { "codeslicer", "urxvt -e sh -c 'codeslicer ; bash'" },
  { "pfff", "urxvt -e sh -c 'pfff ; bash'" },
  { "pfff_db", "urxvt -e sh -c 'pfff_db ; bash'" },
  { "pfff_test", "urxvt -e sh -c 'pfff_test ; bash'" },
  { "scheck", "urxvt -e sh -c 'scheck ; bash'" },
  { "sgrep", "urxvt -e sh -c 'sgrep ; bash'" },
  { "spatch", "urxvt -e sh -c 'spatch ; bash'" },
  { "stags", "urxvt -e sh -c 'stags ; bash'" },
  { "console", "urxvt -e sh -c 'console ; bash'" },
  { "procyon", "urxvt -e sh -c 'procyon ; bash'" },
  { "pscan", "urxvt -e sh -c 'pscan -h ; bash'" },
  { "rats", "urxvt -e sh -c 'rats -h ; bash'" },
  { "retire", "urxvt -e sh -c 'retire -h ; bash'" },
  { "shellcheck", "urxvt -e sh -c 'shellcheck ; bash'" },
  { "slither", "urxvt -e sh -c 'slither -h ; bash'" },
  { "slither-check-erc", "urxvt -e sh -c 'slither-check-erc ; bash'" },
  { "slither-check-kspec", "urxvt -e sh -c 'slither-check-kspec ; bash'" },
  { "slither-check-upgradeability", "urxvt -e sh -c 'slither-check-upgradeability ; bash'" },
  { "slither-find-paths", "urxvt -e sh -c 'slither-find-paths ; bash'" },
  { "slither-flat", "urxvt -e sh -c 'slither-flat ; bash'" },
  { "slither-format", "urxvt -e sh -c 'slither-format ; bash'" },
  { "slither-mutate", "urxvt -e sh -c 'slither-mutate ; bash'" },
  { "slither-simil", "urxvt -e sh -c 'slither-simil ; bash'" },
  { "smalisca", "urxvt -e sh -c 'smalisca --help ; bash'" },
  { "snyk", "urxvt -e sh -c 'snyk -h ; bash'" },
  { "spaf", "urxvt -e sh -c 'spaf -h ; bash'" },
  { "genflagcodes", "urxvt -e sh -c 'genflagcodes ; bash'" },
  { "spotbugs", "urxvt -e sh -c 'spotbugs -h ; bash'" },
  { "addMessages", "urxvt -e sh -c 'addMessages ; bash'" },
  { "computeBugHistory", "urxvt -e sh -c 'computeBugHistory ; bash'" },
  { "convertXmlToText", "urxvt -e sh -c 'convertXmlToText ; bash'" },
  { "defectDensity", "urxvt -e sh -c 'defectDensity ; bash'" },
  { "fb", "urxvt -e sh -c 'fb ; bash'" },
  { "fbwrap", "urxvt -e sh -c 'fbwrap ; bash'" },
  { "filterBugs", "urxvt -e sh -c 'filterBugs ; bash'" },
  { "findbugs-msv", "urxvt -e sh -c 'findbugs-msv ; bash'" },
  { "listBugDatabaseInfo", "urxvt -e sh -c 'listBugDatabaseInfo ; bash'" },
  { "mineBugHistory", "urxvt -e sh -c 'mineBugHistory ; bash'" },
  { "printAppVersion", "urxvt -e sh -c 'printAppVersion ; bash'" },
  { "printClass", "urxvt -e sh -c 'printClass ; bash'" },
  { "setBugDatabaseInfo", "urxvt -e sh -c 'setBugDatabaseInfo ; bash'" },
  { "spotbugs", "urxvt -e sh -c 'spotbugs -h ; bash'" },
  { "spotbugs.ico", "urxvt -e sh -c 'spotbugs.ico ; bash'" },
  { "spotbugs2", "urxvt -e sh -c 'spotbugs2 ; bash'" },
  { "unionBugs", "urxvt -e sh -c 'unionBugs ; bash'" },
  { "xpathFind", "urxvt -e sh -c 'xpathFind ; bash'" },
  { "stacoan", "urxvt -e sh -c 'stacoan -h ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "stoq", "urxvt -e sh -c 'stoq -h ; bash'" },
  { "tell-me-your-secrets", "urxvt -e sh -c 'tell-me-your-secrets -h ; bash'" },
  { "trufflehog", "urxvt -e sh -c 'trufflehog -h ; bash'" },
  { "callgrind_annotate", "urxvt -e sh -c 'callgrind_annotate ; bash'" },
  { "callgrind_control", "urxvt -e sh -c 'callgrind_control ; bash'" },
  { "cg_annotate", "urxvt -e sh -c 'cg_annotate ; bash'" },
  { "cg_diff", "urxvt -e sh -c 'cg_diff ; bash'" },
  { "cg_merge", "urxvt -e sh -c 'cg_merge ; bash'" },
  { "ms_print", "urxvt -e sh -c 'ms_print ; bash'" },
  { "valgrind", "urxvt -e sh -c 'valgrind ; bash'" },
  { "valgrind-di-server", "urxvt -e sh -c 'valgrind-di-server ; bash'" },
  { "valgrind-listener", "urxvt -e sh -c 'valgrind-listener ; bash'" },
  { "vgdb", "urxvt -e sh -c 'vgdb ; bash'" },
  { "callgrind_annotate", "urxvt -e sh -c 'callgrind_annotate ; bash'" },
  { "callgrind_control", "urxvt -e sh -c 'callgrind_control ; bash'" },
  { "cg_annotate", "urxvt -e sh -c 'cg_annotate ; bash'" },
  { "cg_diff", "urxvt -e sh -c 'cg_diff ; bash'" },
  { "cg_merge", "urxvt -e sh -c 'cg_merge ; bash'" },
  { "ms_print", "urxvt -e sh -c 'ms_print ; bash'" },
  { "valgrind", "urxvt -e sh -c 'valgrind ; bash'" },
  { "valgrind-di-server", "urxvt -e sh -c 'valgrind-di-server ; bash'" },
  { "valgrind-listener", "urxvt -e sh -c 'valgrind-listener ; bash'" },
  { "vgdb", "urxvt -e sh -c 'vgdb ; bash'" },
  { "whispers", "urxvt -e sh -c 'whispers -h ; bash'" },
  { "wpbullet", "urxvt -e sh -c 'wpbullet -h ; bash'" },
  { "wscript", "urxvt -e sh -c 'wscript ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "_mocha", "urxvt -e sh -c '_mocha ; bash'" },
  { "mocha", "urxvt -e sh -c 'mocha ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "yasca", "urxvt -e sh -c 'yasca ; bash'" },
}

configmenu = {
  { "bactl", "urxvt -e sh -c 'bactl ; bash'" },
}

crackermenu = {
  { "acccheck", "urxvt -e sh -c 'acccheck -h ; bash'" },
  { "aesfix", "urxvt -e sh -c 'aesfix ; bash'" },
  { "against", "urxvt -e sh -c 'against ; bash'" },
  { "androidpincrack", "urxvt -e sh -c 'androidpincrack -h ; bash'" },
  { "asleap", "urxvt -e sh -c 'asleap -h ; bash'" },
  { "auto-eap", "urxvt -e sh -c 'auto-eap -h ; bash'" },
  { "balbuzard", "urxvt -e sh -c 'balbuzard ; bash'" },
  { "bbcrack", "urxvt -e sh -c 'bbcrack ; bash'" },
  { "bbharvest", "urxvt -e sh -c 'bbharvest ; bash'" },
  { "bbtrans", "urxvt -e sh -c 'bbtrans ; bash'" },
  { "beleth", "urxvt -e sh -c 'beleth -h ; bash'" },
  { "pxedump", "urxvt -e sh -c 'pxedump -h ; bash'" },
  { "usbdump", "urxvt -e sh -c 'usbdump -h ; bash'" },
  { "bkcrack", "urxvt -e sh -c 'bkcrack -h ; bash'" },
  { "bkhive", "urxvt -e sh -c 'bkhive -h ; bash'" },
  { "blackbox-scanner", "urxvt -e sh -c 'blackbox-scanner -h ; bash'" },
  { "bob_admin-sse2", "urxvt -e sh -c 'bob_admin-sse2 -h ; bash'" },
  { "bob_client-sse2", "urxvt -e sh -c 'bob_client-sse2 -h ; bash'" },
  { "bob_server-sse2", "urxvt -e sh -c 'bob_server-sse2 -h ; bash'" },
  { "brut3k1t", "urxvt -e sh -c 'brut3k1t -h ; bash'" },
  { "brute-force", "urxvt -e sh -c 'brute-force -h ; bash'" },
  { "bruteforce-luks", "urxvt -e sh -c 'bruteforce-luks -h ; bash'" },
  { "bruteforce-salted-openssl", "urxvt -e sh -c 'bruteforce-salted-openssl -h ; bash'" },
  { "bruteforce-wallet", "urxvt -e sh -c 'bruteforce-wallet ; bash'" },
  { "brutemap", "urxvt -e sh -c 'brutemap -h ; bash'" },
  { "brutespray", "urxvt -e sh -c 'brutespray -h ; bash'" },
  { "brutex", "urxvt -e sh -c 'brutex ; bash'" },
  { "brutex-masscan", "urxvt -e sh -c 'brutex-masscan ; bash'" },
  { "bully", "urxvt -e sh -c 'bully -h ; bash'" },
  { "byepass", "urxvt -e sh -c 'byepass -h ; bash'" },
  { "passtime", "urxvt -e sh -c 'passtime -h ; bash'" },
  { "cewl", "urxvt -e sh -c 'cewl -h ; bash'" },
  { "cewl-fab", "urxvt -e sh -c 'cewl-fab ; bash'" },
  { "chapcrack", "urxvt -e sh -c 'chapcrack -h ; bash'" },
  { "checkpwd", "urxvt -e sh -c 'checkpwd -h ; bash'" },
  { "checkpwd_nopw", "urxvt -e sh -c 'checkpwd_nopw ; bash'" },
  { "chntpw", "urxvt -e sh -c 'chntpw ; bash'" },
  { "cpnt", "urxvt -e sh -c 'cpnt ; bash'" },
  { "reged", "urxvt -e sh -c 'reged ; bash'" },
  { "chntpw", "urxvt -e sh -c 'chntpw ; bash'" },
  { "cpnt", "urxvt -e sh -c 'cpnt ; bash'" },
  { "reged", "urxvt -e sh -c 'reged ; bash'" },
  { "cintruder", "urxvt -e sh -c 'cintruder -h ; bash'" },
  { "CAT", "urxvt -e sh -c 'CAT ; bash'" },
  { "cisco-auditing-tool", "urxvt -e sh -c 'cisco-auditing-tool ; bash'" },
  { "cisco-ocs", "urxvt -e sh -c 'cisco-ocs ; bash'" },
  { "cisco-scanner", "urxvt -e sh -c 'cisco-scanner -h ; bash'" },
  { "cisco-snmp-enumeration", "urxvt -e sh -c 'cisco-snmp-enumeration ; bash'" },
  { "c5c", "urxvt -e sh -c 'c5c --help ; bash'" },
  { "cisco7crack", "urxvt -e sh -c 'cisco7crack -h ; bash'" },
  { "cmospwd", "urxvt -e sh -c 'cmospwd -h ; bash'" },
  { "compp", "urxvt -e sh -c 'compp -h ; bash'" },
  { "cowpatty", "urxvt -e sh -c 'cowpatty -h ; bash'" },
  { "genpmk", "urxvt -e sh -c 'genpmk -h ; bash'" },
  { "cowpatty", "urxvt -e sh -c 'cowpatty -h ; bash'" },
  { "genpmk", "urxvt -e sh -c 'genpmk -h ; bash'" },
  { "crackhor", "urxvt -e sh -c 'crackhor -h ; bash'" },
  { "crackle", "urxvt -e sh -c 'crackle ; bash'" },
  { "crackqcli", "urxvt -e sh -c 'crackqcli ; bash'" },
  { "crack-standalone", "urxvt -e sh -c 'crack-standalone -h ; bash'" },
  { "crackclient", "urxvt -e sh -c 'crackclient -h ; bash'" },
  { "crackserver", "urxvt -e sh -c 'crackserver -h ; bash'" },
  { "cachedump", "urxvt -e sh -c 'cachedump cd /usr/share/windows/cachedump ; ls ; bash'" },
  { "lsadump", "urxvt -e sh -c 'lsadump ; bash'" },
  { "pwdump", "urxvt -e sh -c 'pwdump cd /usr/share/windows/pwdump ; ls ; bash'" },
  { "crowbar", "urxvt -e sh -c 'crowbar --help ; bash'" },
  { "cryptohazemultiforcer", "urxvt -e sh -c 'cryptohazemultiforcer ; bash'" },
  { "cupp", "urxvt -e sh -c 'cupp ; bash'" },
  { "dbpwaudit", "urxvt -e sh -c 'dbpwaudit -h ; bash'" },
  { "delldrac", "urxvt -e sh -c 'delldrac -h ; bash'" },
  { "depant", "urxvt -e sh -c 'depant ; bash'" },
  { "device-pharmer", "urxvt -e sh -c 'device-pharmer -h ; bash'" },
  { "domi-owned", "urxvt -e sh -c 'domi-owned -h ; bash'" },
  { "doozer", "urxvt -e sh -c 'doozer ; bash'" },
  { "doozer-monitor", "urxvt -e sh -c 'doozer-monitor ; bash'" },
  { "doozestop", "urxvt -e sh -c 'doozestop ; bash'" },
  { "dpeparser", "urxvt -e sh -c 'dpeparser -h ; bash'" },
  { "enabler", "urxvt -e sh -c 'enabler ; bash'" },
  { "bin-seeds", "urxvt -e sh -c 'bin-seeds ; bash'" },
  { "bruteforce-erldp", "urxvt -e sh -c 'bruteforce-erldp ; bash'" },
  { "crack-prng", "urxvt -e sh -c 'crack-prng ; bash'" },
  { "dictionary-erldp", "urxvt -e sh -c 'dictionary-erldp -h ; bash'" },
  { "erldp-proxy", "urxvt -e sh -c 'erldp-proxy -h ; bash'" },
  { "shell-erldp", "urxvt -e sh -c 'shell-erldp -h ; bash'" },
  { "sweep-default-cookie", "urxvt -e sh -c 'sweep-default-cookie -h ; bash'" },
  { "evilize", "urxvt -e sh -c 'evilize -h ; bash'" },
  { "f-scrack", "urxvt -e sh -c 'f-scrack ; bash'" },
  { "facebrute", "urxvt -e sh -c 'facebrute -h ; bash'" },
  { "fang", "urxvt -e sh -c 'fang -h ; bash'" },
  { "fern-wifi-cracker", "urxvt -e sh -c 'fern-wifi-cracker ; bash'" },
  { "ftp-scanner", "urxvt -e sh -c 'ftp-scanner -h ; bash'" },
  { "ftp-spider", "urxvt -e sh -c 'ftp-spider -h ; bash'" },
  { "gpocrack", "urxvt -e sh -c 'gpocrack -h ; bash'" },
  { "habu.arp.ping", "urxvt -e sh -c 'habu.arp.ping ; bash'" },
  { "habu.arp.poison", "urxvt -e sh -c 'habu.arp.poison ; bash'" },
  { "habu.arp.sniff", "urxvt -e sh -c 'habu.arp.sniff ; bash'" },
  { "habu.asydns", "urxvt -e sh -c 'habu.asydns ; bash'" },
  { "habu.b64", "urxvt -e sh -c 'habu.b64 ; bash'" },
  { "habu.cert.clone", "urxvt -e sh -c 'habu.cert.clone ; bash'" },
  { "habu.cert.names", "urxvt -e sh -c 'habu.cert.names ; bash'" },
  { "habu.crack.luhn", "urxvt -e sh -c 'habu.crack.luhn ; bash'" },
  { "habu.crack.snmp", "urxvt -e sh -c 'habu.crack.snmp ; bash'" },
  { "habu.crypto.fernet", "urxvt -e sh -c 'habu.crypto.fernet ; bash'" },
  { "habu.crypto.gppref", "urxvt -e sh -c 'habu.crypto.gppref ; bash'" },
  { "habu.crypto.xor", "urxvt -e sh -c 'habu.crypto.xor ; bash'" },
  { "habu.data.enrich", "urxvt -e sh -c 'habu.data.enrich ; bash'" },
  { "habu.data.extract.domain", "urxvt -e sh -c 'habu.data.extract.domain ; bash'" },
  { "habu.data.extract.email", "urxvt -e sh -c 'habu.data.extract.email ; bash'" },
  { "habu.data.extract.fqdn", "urxvt -e sh -c 'habu.data.extract.fqdn ; bash'" },
  { "habu.data.extract.ipv4", "urxvt -e sh -c 'habu.data.extract.ipv4 ; bash'" },
  { "habu.data.filter", "urxvt -e sh -c 'habu.data.filter ; bash'" },
  { "habu.data.select", "urxvt -e sh -c 'habu.data.select ; bash'" },
  { "habu.dhcp.discover", "urxvt -e sh -c 'habu.dhcp.discover ; bash'" },
  { "habu.dhcp.starvation", "urxvt -e sh -c 'habu.dhcp.starvation ; bash'" },
  { "habu.dns.lookup.forward", "urxvt -e sh -c 'habu.dns.lookup.forward ; bash'" },
  { "habu.dns.lookup.reverse", "urxvt -e sh -c 'habu.dns.lookup.reverse ; bash'" },
  { "habu.eicar", "urxvt -e sh -c 'habu.eicar ; bash'" },
  { "habu.forkbomb", "urxvt -e sh -c 'habu.forkbomb ; bash'" },
  { "habu.fqdn.finder", "urxvt -e sh -c 'habu.fqdn.finder ; bash'" },
  { "habu.gateway.find", "urxvt -e sh -c 'habu.gateway.find ; bash'" },
  { "habu.host", "urxvt -e sh -c 'habu.host ; bash'" },
  { "habu.http.headers", "urxvt -e sh -c 'habu.http.headers ; bash'" },
  { "habu.http.options", "urxvt -e sh -c 'habu.http.options ; bash'" },
  { "habu.http.tech", "urxvt -e sh -c 'habu.http.tech ; bash'" },
  { "habu.icmp.ping", "urxvt -e sh -c 'habu.icmp.ping ; bash'" },
  { "habu.ip.asn", "urxvt -e sh -c 'habu.ip.asn ; bash'" },
  { "habu.ip.geolocation", "urxvt -e sh -c 'habu.ip.geolocation ; bash'" },
  { "habu.ip.internal", "urxvt -e sh -c 'habu.ip.internal ; bash'" },
  { "habu.ip.public", "urxvt -e sh -c 'habu.ip.public ; bash'" },
  { "habu.karma", "urxvt -e sh -c 'habu.karma ; bash'" },
  { "habu.karma.bulk", "urxvt -e sh -c 'habu.karma.bulk ; bash'" },
  { "habu.land", "urxvt -e sh -c 'habu.land ; bash'" },
  { "habu.nc", "urxvt -e sh -c 'habu.nc ; bash'" },
  { "habu.net.contest", "urxvt -e sh -c 'habu.net.contest ; bash'" },
  { "habu.net.interfaces", "urxvt -e sh -c 'habu.net.interfaces ; bash'" },
  { "habu.nmap.excluded", "urxvt -e sh -c 'habu.nmap.excluded ; bash'" },
  { "habu.nmap.open", "urxvt -e sh -c 'habu.nmap.open ; bash'" },
  { "habu.nmap.ports", "urxvt -e sh -c 'habu.nmap.ports ; bash'" },
  { "habu.protoscan", "urxvt -e sh -c 'habu.protoscan ; bash'" },
  { "habu.server.ftp", "urxvt -e sh -c 'habu.server.ftp ; bash'" },
  { "habu.tcp.flags", "urxvt -e sh -c 'habu.tcp.flags ; bash'" },
  { "habu.tcp.isn", "urxvt -e sh -c 'habu.tcp.isn ; bash'" },
  { "habu.tcp.scan", "urxvt -e sh -c 'habu.tcp.scan ; bash'" },
  { "habu.tcp.synflood", "urxvt -e sh -c 'habu.tcp.synflood ; bash'" },
  { "habu.traceroute", "urxvt -e sh -c 'habu.traceroute ; bash'" },
  { "habu.upgrade", "urxvt -e sh -c 'habu.upgrade ; bash'" },
  { "habu.usercheck", "urxvt -e sh -c 'habu.usercheck ; bash'" },
  { "habu.version", "urxvt -e sh -c 'habu.version ; bash'" },
  { "habu.vhosts", "urxvt -e sh -c 'habu.vhosts ; bash'" },
  { "habu.virustotal", "urxvt -e sh -c 'habu.virustotal ; bash'" },
  { "habu.web.report", "urxvt -e sh -c 'habu.web.report ; bash'" },
  { "habu.whois.domain", "urxvt -e sh -c 'habu.whois.domain ; bash'" },
  { "habu.whois.ip", "urxvt -e sh -c 'habu.whois.ip ; bash'" },
  { "hate-crack", "urxvt -e sh -c 'hate-crack ; bash'" },
  { "hdmi-sniff", "urxvt -e sh -c 'hdmi-sniff -h ; bash'" },
  { "htpwdscan", "urxvt -e sh -c 'htpwdscan -h ; bash'" },
  { "hydra", "urxvt -e sh -c 'hydra -h ; bash'" },
  { "pw-inspector", "urxvt -e sh -c 'pw-inspector -h ; bash'" },
  { "hydra", "urxvt -e sh -c 'hydra -h ; bash'" },
  { "pw-inspector", "urxvt -e sh -c 'pw-inspector -h ; bash'" },
  { "iax-scan-hosts", "urxvt -e sh -c 'iax-scan-hosts -h ; bash'" },
  { "iax-scan-users", "urxvt -e sh -c 'iax-scan-users -h ; bash'" },
  { "ibrute", "urxvt -e sh -c 'ibrute -h ; bash'" },
  { "icloudbrutter", "urxvt -e sh -c 'icloudbrutter ; bash'" },
  { "iheartxor", "urxvt -e sh -c 'iheartxor ; bash'" },
  { "iisbf", "urxvt -e sh -c 'iisbf ; bash'" },
  { "ikecrack-snarf", "urxvt -e sh -c 'ikecrack-snarf ; bash'" },
  { "ikeforce", "urxvt -e sh -c 'ikeforce -h ; bash'" },
  { "inguma", "urxvt -e sh -c 'inguma -h ; bash'" },
  { "ingumagui", "urxvt -e sh -c 'ingumagui ; bash'" },
  { "interrogate", "urxvt -e sh -c 'interrogate -h ; bash'" },
  { "ipmipwn", "urxvt -e sh -c 'ipmipwn ; bash'" },
  { "iptv-cli", "urxvt -e sh -c 'iptv-cli ; bash'" },
  { "iptv-gui", "urxvt -e sh -c 'iptv-gui ; bash'" },
  { "jbrute", "urxvt -e sh -c 'jbrute --help ; bash'" },
  { "1password2john", "urxvt -e sh -c '1password2john ; bash'" },
  { "7z2john", "urxvt -e sh -c '7z2john ; bash'" },
  { "DPAPImk2john", "urxvt -e sh -c 'DPAPImk2john ; bash'" },
  { "SIPdump", "urxvt -e sh -c 'SIPdump ; bash'" },
  { "adxcsouf2john", "urxvt -e sh -c 'adxcsouf2john ; bash'" },
  { "aem2john", "urxvt -e sh -c 'aem2john ; bash'" },
  { "aix2john", "urxvt -e sh -c 'aix2john ; bash'" },
  { "andotp2john", "urxvt -e sh -c 'andotp2john ; bash'" },
  { "androidbackup2john", "urxvt -e sh -c 'androidbackup2john ; bash'" },
  { "androidfde2john", "urxvt -e sh -c 'androidfde2john ; bash'" },
  { "ansible2john", "urxvt -e sh -c 'ansible2john ; bash'" },
  { "apex2john", "urxvt -e sh -c 'apex2john ; bash'" },
  { "aruba2john", "urxvt -e sh -c 'aruba2john ; bash'" },
  { "axcrypt2john", "urxvt -e sh -c 'axcrypt2john ; bash'" },
  { "base64conv", "urxvt -e sh -c 'base64conv ; bash'" },
  { "bestcrypt2john", "urxvt -e sh -c 'bestcrypt2john ; bash'" },
  { "bitcoin2john", "urxvt -e sh -c 'bitcoin2john ; bash'" },
  { "bitlocker2john", "urxvt -e sh -c 'bitlocker2john ; bash'" },
  { "bitwarden2john", "urxvt -e sh -c 'bitwarden2john ; bash'" },
  { "bks2john", "urxvt -e sh -c 'bks2john ; bash'" },
  { "blockchain2john", "urxvt -e sh -c 'blockchain2john ; bash'" },
  { "calc_stat", "urxvt -e sh -c 'calc_stat ; bash'" },
  { "cisco2john", "urxvt -e sh -c 'cisco2john ; bash'" },
  { "codepage", "urxvt -e sh -c 'codepage ; bash'" },
  { "cprepair", "urxvt -e sh -c 'cprepair ; bash'" },
  { "cracf2john", "urxvt -e sh -c 'cracf2john ; bash'" },
  { "diskcryptor2john", "urxvt -e sh -c 'diskcryptor2john ; bash'" },
  { "dmg2john", "urxvt -e sh -c 'dmg2john ; bash'" },
  { "ecryptfs2john", "urxvt -e sh -c 'ecryptfs2john ; bash'" },
  { "ejabberd2john", "urxvt -e sh -c 'ejabberd2john ; bash'" },
  { "electrum2john", "urxvt -e sh -c 'electrum2john ; bash'" },
  { "encfs2john", "urxvt -e sh -c 'encfs2john ; bash'" },
  { "enpass2john", "urxvt -e sh -c 'enpass2john ; bash'" },
  { "ethereum2john", "urxvt -e sh -c 'ethereum2john ; bash'" },
  { "filezilla2john", "urxvt -e sh -c 'filezilla2john ; bash'" },
  { "fuzz_option", "urxvt -e sh -c 'fuzz_option ; bash'" },
  { "geli2john", "urxvt -e sh -c 'geli2john ; bash'" },
  { "genincstats", "urxvt -e sh -c 'genincstats ; bash'" },
  { "genmkvpwd", "urxvt -e sh -c 'genmkvpwd ; bash'" },
  { "gpg2john", "urxvt -e sh -c 'gpg2john ; bash'" },
  { "hccap2john", "urxvt -e sh -c 'hccap2john ; bash'" },
  { "hccapx2john", "urxvt -e sh -c 'hccapx2john ; bash'" },
  { "hextoraw", "urxvt -e sh -c 'hextoraw ; bash'" },
  { "htdigest2john", "urxvt -e sh -c 'htdigest2john ; bash'" },
  { "ibmiscanner2john", "urxvt -e sh -c 'ibmiscanner2john ; bash'" },
  { "ikescan2john", "urxvt -e sh -c 'ikescan2john ; bash'" },
  { "ios7tojohn", "urxvt -e sh -c 'ios7tojohn ; bash'" },
  { "itunes_backup2john", "urxvt -e sh -c 'itunes_backup2john ; bash'" },
  { "iwork2john", "urxvt -e sh -c 'iwork2john ; bash'" },
  { "john", "urxvt -e sh -c 'john ; bash'" },
  { "kdcdump2john", "urxvt -e sh -c 'kdcdump2john ; bash'" },
  { "keepass2john", "urxvt -e sh -c 'keepass2john ; bash'" },
  { "keychain2john", "urxvt -e sh -c 'keychain2john ; bash'" },
  { "keyring2john", "urxvt -e sh -c 'keyring2john ; bash'" },
  { "keystore2john", "urxvt -e sh -c 'keystore2john ; bash'" },
  { "known_hosts2john", "urxvt -e sh -c 'known_hosts2john ; bash'" },
  { "kwallet2john", "urxvt -e sh -c 'kwallet2john ; bash'" },
  { "lastpass2john", "urxvt -e sh -c 'lastpass2john ; bash'" },
  { "ldif2john", "urxvt -e sh -c 'ldif2john ; bash'" },
  { "leet", "urxvt -e sh -c 'leet ; bash'" },
  { "libreoffice2john", "urxvt -e sh -c 'libreoffice2john ; bash'" },
  { "lion2john", "urxvt -e sh -c 'lion2john ; bash'" },
  { "lion2john-alt", "urxvt -e sh -c 'lion2john-alt ; bash'" },
  { "lotus2john", "urxvt -e sh -c 'lotus2john ; bash'" },
  { "luks2john", "urxvt -e sh -c 'luks2john ; bash'" },
  { "mac2john", "urxvt -e sh -c 'mac2john ; bash'" },
  { "mac2john-alt", "urxvt -e sh -c 'mac2john-alt ; bash'" },
  { "mcafee_epo2john", "urxvt -e sh -c 'mcafee_epo2john ; bash'" },
  { "mkvcalcproba", "urxvt -e sh -c 'mkvcalcproba ; bash'" },
  { "monero2john", "urxvt -e sh -c 'monero2john ; bash'" },
  { "money2john", "urxvt -e sh -c 'money2john ; bash'" },
  { "mozilla2john", "urxvt -e sh -c 'mozilla2john ; bash'" },
  { "multibit2john", "urxvt -e sh -c 'multibit2john ; bash'" },
  { "neo2john", "urxvt -e sh -c 'neo2john ; bash'" },
  { "netntlm", "urxvt -e sh -c 'netntlm ; bash'" },
  { "netscreen", "urxvt -e sh -c 'netscreen ; bash'" },
  { "network2john", "urxvt -e sh -c 'network2john ; bash'" },
  { "office2john", "urxvt -e sh -c 'office2john ; bash'" },
  { "openbsd_softraid2john", "urxvt -e sh -c 'openbsd_softraid2john ; bash'" },
  { "openssl2john", "urxvt -e sh -c 'openssl2john ; bash'" },
  { "padlock2john", "urxvt -e sh -c 'padlock2john ; bash'" },
  { "pass_gen", "urxvt -e sh -c 'pass_gen ; bash'" },
  { "pcap2john", "urxvt -e sh -c 'pcap2john ; bash'" },
  { "pdf2john", "urxvt -e sh -c 'pdf2john ; bash'" },
  { "pem2john", "urxvt -e sh -c 'pem2john ; bash'" },
  { "pfx2john", "urxvt -e sh -c 'pfx2john ; bash'" },
  { "pgpdisk2john", "urxvt -e sh -c 'pgpdisk2john ; bash'" },
  { "pgpwde2john", "urxvt -e sh -c 'pgpwde2john ; bash'" },
  { "potcheck", "urxvt -e sh -c 'potcheck ; bash'" },
  { "prosody2john", "urxvt -e sh -c 'prosody2john ; bash'" },
  { "ps_token2john", "urxvt -e sh -c 'ps_token2john ; bash'" },
  { "pse2john", "urxvt -e sh -c 'pse2john ; bash'" },
  { "putty2john", "urxvt -e sh -c 'putty2john ; bash'" },
  { "pwsafe2john", "urxvt -e sh -c 'pwsafe2john ; bash'" },
  { "racf2john", "urxvt -e sh -c 'racf2john ; bash'" },
  { "radius2john", "urxvt -e sh -c 'radius2john ; bash'" },
  { "rar2john", "urxvt -e sh -c 'rar2john ; bash'" },
  { "raw2dyna", "urxvt -e sh -c 'raw2dyna ; bash'" },
  { "rexgen2rules", "urxvt -e sh -c 'rexgen2rules ; bash'" },
  { "rulestack", "urxvt -e sh -c 'rulestack ; bash'" },
  { "sap2john", "urxvt -e sh -c 'sap2john ; bash'" },
  { "sha-dump", "urxvt -e sh -c 'sha-dump ; bash'" },
  { "sha-test", "urxvt -e sh -c 'sha-test ; bash'" },
  { "signal2john", "urxvt -e sh -c 'signal2john ; bash'" },
  { "sipdump2john", "urxvt -e sh -c 'sipdump2john ; bash'" },
  { "sspr2john", "urxvt -e sh -c 'sspr2john ; bash'" },
  { "staroffice2john", "urxvt -e sh -c 'staroffice2john ; bash'" },
  { "strip2john", "urxvt -e sh -c 'strip2john ; bash'" },
  { "telegram2john", "urxvt -e sh -c 'telegram2john ; bash'" },
  { "tezos2john", "urxvt -e sh -c 'tezos2john ; bash'" },
  { "truecrypt2john", "urxvt -e sh -c 'truecrypt2john ; bash'" },
  { "uaf2john", "urxvt -e sh -c 'uaf2john ; bash'" },
  { "unafs", "urxvt -e sh -c 'unafs ; bash'" },
  { "undrop", "urxvt -e sh -c 'undrop ; bash'" },
  { "unique", "urxvt -e sh -c 'unique ; bash'" },
  { "unrule", "urxvt -e sh -c 'unrule ; bash'" },
  { "vdi2john", "urxvt -e sh -c 'vdi2john ; bash'" },
  { "vmx2john", "urxvt -e sh -c 'vmx2john ; bash'" },
  { "vncpcap2john", "urxvt -e sh -c 'vncpcap2john ; bash'" },
  { "wpapcap2john", "urxvt -e sh -c 'wpapcap2john ; bash'" },
  { "zip2john", "urxvt -e sh -c 'zip2john ; bash'" },
  { "1password2john", "urxvt -e sh -c '1password2john ; bash'" },
  { "7z2john", "urxvt -e sh -c '7z2john ; bash'" },
  { "DPAPImk2john", "urxvt -e sh -c 'DPAPImk2john ; bash'" },
  { "SIPdump", "urxvt -e sh -c 'SIPdump ; bash'" },
  { "adxcsouf2john", "urxvt -e sh -c 'adxcsouf2john ; bash'" },
  { "aem2john", "urxvt -e sh -c 'aem2john ; bash'" },
  { "aix2john", "urxvt -e sh -c 'aix2john ; bash'" },
  { "andotp2john", "urxvt -e sh -c 'andotp2john ; bash'" },
  { "androidbackup2john", "urxvt -e sh -c 'androidbackup2john ; bash'" },
  { "androidfde2john", "urxvt -e sh -c 'androidfde2john ; bash'" },
  { "ansible2john", "urxvt -e sh -c 'ansible2john ; bash'" },
  { "apex2john", "urxvt -e sh -c 'apex2john ; bash'" },
  { "aruba2john", "urxvt -e sh -c 'aruba2john ; bash'" },
  { "axcrypt2john", "urxvt -e sh -c 'axcrypt2john ; bash'" },
  { "base64conv", "urxvt -e sh -c 'base64conv ; bash'" },
  { "bestcrypt2john", "urxvt -e sh -c 'bestcrypt2john ; bash'" },
  { "bitcoin2john", "urxvt -e sh -c 'bitcoin2john ; bash'" },
  { "bitlocker2john", "urxvt -e sh -c 'bitlocker2john ; bash'" },
  { "bitwarden2john", "urxvt -e sh -c 'bitwarden2john ; bash'" },
  { "bks2john", "urxvt -e sh -c 'bks2john ; bash'" },
  { "blockchain2john", "urxvt -e sh -c 'blockchain2john ; bash'" },
  { "calc_stat", "urxvt -e sh -c 'calc_stat ; bash'" },
  { "cisco2john", "urxvt -e sh -c 'cisco2john ; bash'" },
  { "codepage", "urxvt -e sh -c 'codepage ; bash'" },
  { "cprepair", "urxvt -e sh -c 'cprepair ; bash'" },
  { "cracf2john", "urxvt -e sh -c 'cracf2john ; bash'" },
  { "diskcryptor2john", "urxvt -e sh -c 'diskcryptor2john ; bash'" },
  { "dmg2john", "urxvt -e sh -c 'dmg2john ; bash'" },
  { "ecryptfs2john", "urxvt -e sh -c 'ecryptfs2john ; bash'" },
  { "ejabberd2john", "urxvt -e sh -c 'ejabberd2john ; bash'" },
  { "electrum2john", "urxvt -e sh -c 'electrum2john ; bash'" },
  { "encfs2john", "urxvt -e sh -c 'encfs2john ; bash'" },
  { "enpass2john", "urxvt -e sh -c 'enpass2john ; bash'" },
  { "ethereum2john", "urxvt -e sh -c 'ethereum2john ; bash'" },
  { "filezilla2john", "urxvt -e sh -c 'filezilla2john ; bash'" },
  { "fuzz_option", "urxvt -e sh -c 'fuzz_option ; bash'" },
  { "geli2john", "urxvt -e sh -c 'geli2john ; bash'" },
  { "genincstats", "urxvt -e sh -c 'genincstats ; bash'" },
  { "genmkvpwd", "urxvt -e sh -c 'genmkvpwd ; bash'" },
  { "gpg2john", "urxvt -e sh -c 'gpg2john ; bash'" },
  { "hccap2john", "urxvt -e sh -c 'hccap2john ; bash'" },
  { "hccapx2john", "urxvt -e sh -c 'hccapx2john ; bash'" },
  { "hextoraw", "urxvt -e sh -c 'hextoraw ; bash'" },
  { "htdigest2john", "urxvt -e sh -c 'htdigest2john ; bash'" },
  { "ibmiscanner2john", "urxvt -e sh -c 'ibmiscanner2john ; bash'" },
  { "ikescan2john", "urxvt -e sh -c 'ikescan2john ; bash'" },
  { "ios7tojohn", "urxvt -e sh -c 'ios7tojohn ; bash'" },
  { "itunes_backup2john", "urxvt -e sh -c 'itunes_backup2john ; bash'" },
  { "iwork2john", "urxvt -e sh -c 'iwork2john ; bash'" },
  { "john", "urxvt -e sh -c 'john ; bash'" },
  { "kdcdump2john", "urxvt -e sh -c 'kdcdump2john ; bash'" },
  { "keepass2john", "urxvt -e sh -c 'keepass2john ; bash'" },
  { "keychain2john", "urxvt -e sh -c 'keychain2john ; bash'" },
  { "keyring2john", "urxvt -e sh -c 'keyring2john ; bash'" },
  { "keystore2john", "urxvt -e sh -c 'keystore2john ; bash'" },
  { "known_hosts2john", "urxvt -e sh -c 'known_hosts2john ; bash'" },
  { "kwallet2john", "urxvt -e sh -c 'kwallet2john ; bash'" },
  { "lastpass2john", "urxvt -e sh -c 'lastpass2john ; bash'" },
  { "ldif2john", "urxvt -e sh -c 'ldif2john ; bash'" },
  { "leet", "urxvt -e sh -c 'leet ; bash'" },
  { "libreoffice2john", "urxvt -e sh -c 'libreoffice2john ; bash'" },
  { "lion2john", "urxvt -e sh -c 'lion2john ; bash'" },
  { "lion2john-alt", "urxvt -e sh -c 'lion2john-alt ; bash'" },
  { "lotus2john", "urxvt -e sh -c 'lotus2john ; bash'" },
  { "luks2john", "urxvt -e sh -c 'luks2john ; bash'" },
  { "mac2john", "urxvt -e sh -c 'mac2john ; bash'" },
  { "mac2john-alt", "urxvt -e sh -c 'mac2john-alt ; bash'" },
  { "mcafee_epo2john", "urxvt -e sh -c 'mcafee_epo2john ; bash'" },
  { "mkvcalcproba", "urxvt -e sh -c 'mkvcalcproba ; bash'" },
  { "monero2john", "urxvt -e sh -c 'monero2john ; bash'" },
  { "money2john", "urxvt -e sh -c 'money2john ; bash'" },
  { "mozilla2john", "urxvt -e sh -c 'mozilla2john ; bash'" },
  { "multibit2john", "urxvt -e sh -c 'multibit2john ; bash'" },
  { "neo2john", "urxvt -e sh -c 'neo2john ; bash'" },
  { "netntlm", "urxvt -e sh -c 'netntlm ; bash'" },
  { "netscreen", "urxvt -e sh -c 'netscreen ; bash'" },
  { "network2john", "urxvt -e sh -c 'network2john ; bash'" },
  { "office2john", "urxvt -e sh -c 'office2john ; bash'" },
  { "openbsd_softraid2john", "urxvt -e sh -c 'openbsd_softraid2john ; bash'" },
  { "openssl2john", "urxvt -e sh -c 'openssl2john ; bash'" },
  { "padlock2john", "urxvt -e sh -c 'padlock2john ; bash'" },
  { "pass_gen", "urxvt -e sh -c 'pass_gen ; bash'" },
  { "pcap2john", "urxvt -e sh -c 'pcap2john ; bash'" },
  { "pdf2john", "urxvt -e sh -c 'pdf2john ; bash'" },
  { "pem2john", "urxvt -e sh -c 'pem2john ; bash'" },
  { "pfx2john", "urxvt -e sh -c 'pfx2john ; bash'" },
  { "pgpdisk2john", "urxvt -e sh -c 'pgpdisk2john ; bash'" },
  { "pgpwde2john", "urxvt -e sh -c 'pgpwde2john ; bash'" },
  { "potcheck", "urxvt -e sh -c 'potcheck ; bash'" },
  { "prosody2john", "urxvt -e sh -c 'prosody2john ; bash'" },
  { "ps_token2john", "urxvt -e sh -c 'ps_token2john ; bash'" },
  { "pse2john", "urxvt -e sh -c 'pse2john ; bash'" },
  { "putty2john", "urxvt -e sh -c 'putty2john ; bash'" },
  { "pwsafe2john", "urxvt -e sh -c 'pwsafe2john ; bash'" },
  { "racf2john", "urxvt -e sh -c 'racf2john ; bash'" },
  { "radius2john", "urxvt -e sh -c 'radius2john ; bash'" },
  { "rar2john", "urxvt -e sh -c 'rar2john ; bash'" },
  { "raw2dyna", "urxvt -e sh -c 'raw2dyna ; bash'" },
  { "rexgen2rules", "urxvt -e sh -c 'rexgen2rules ; bash'" },
  { "rulestack", "urxvt -e sh -c 'rulestack ; bash'" },
  { "sap2john", "urxvt -e sh -c 'sap2john ; bash'" },
  { "sha-dump", "urxvt -e sh -c 'sha-dump ; bash'" },
  { "sha-test", "urxvt -e sh -c 'sha-test ; bash'" },
  { "signal2john", "urxvt -e sh -c 'signal2john ; bash'" },
  { "sipdump2john", "urxvt -e sh -c 'sipdump2john ; bash'" },
  { "sspr2john", "urxvt -e sh -c 'sspr2john ; bash'" },
  { "staroffice2john", "urxvt -e sh -c 'staroffice2john ; bash'" },
  { "strip2john", "urxvt -e sh -c 'strip2john ; bash'" },
  { "telegram2john", "urxvt -e sh -c 'telegram2john ; bash'" },
  { "tezos2john", "urxvt -e sh -c 'tezos2john ; bash'" },
  { "truecrypt2john", "urxvt -e sh -c 'truecrypt2john ; bash'" },
  { "uaf2john", "urxvt -e sh -c 'uaf2john ; bash'" },
  { "unafs", "urxvt -e sh -c 'unafs ; bash'" },
  { "undrop", "urxvt -e sh -c 'undrop ; bash'" },
  { "unique", "urxvt -e sh -c 'unique ; bash'" },
  { "unrule", "urxvt -e sh -c 'unrule ; bash'" },
  { "vdi2john", "urxvt -e sh -c 'vdi2john ; bash'" },
  { "vmx2john", "urxvt -e sh -c 'vmx2john ; bash'" },
  { "vncpcap2john", "urxvt -e sh -c 'vncpcap2john ; bash'" },
  { "wpapcap2john", "urxvt -e sh -c 'wpapcap2john ; bash'" },
  { "zip2john", "urxvt -e sh -c 'zip2john ; bash'" },
  { "johnny", "urxvt -e sh -c 'johnny ; bash'" },
  { "jooforce", "urxvt -e sh -c 'jooforce ; bash'" },
  { "jwt-cracker", "urxvt -e sh -c 'jwt-cracker ; bash'" },
  { "jwt-tool", "urxvt -e sh -c 'jwt-tool -h ; bash'" },
  { "jwtcat", "urxvt -e sh -c 'jwtcat -h ; bash'" },
  { "katana-ktf.gui", "urxvt -e sh -c 'katana-ktf.gui ; bash'" },
  { "katana-ktfconsole", "urxvt -e sh -c 'katana-ktfconsole ; bash'" },
  { "katana-ktfktf", "urxvt -e sh -c 'katana-ktfktf ; bash'" },
  { "katana-ktflinker", "urxvt -e sh -c 'katana-ktflinker ; bash'" },
  { "katana-ktfrun", "urxvt -e sh -c 'katana-ktfrun ; bash'" },
  { "katana-ktfupdate", "urxvt -e sh -c 'katana-ktfupdate ; bash'" },
  { "keimpx", "urxvt -e sh -c 'keimpx -h ; bash'" },
  { "khc", "urxvt -e sh -c 'khc ; bash'" },
  { "ldap-brute", "urxvt -e sh -c 'ldap-brute -h ; bash'" },
  { "leviathan", "urxvt -e sh -c 'leviathan ; bash'" },
  { "levye", "urxvt -e sh -c 'levye -h ; bash'" },
  { "linset", "urxvt -e sh -c 'linset ; bash'" },
  { "lodowep", "urxvt -e sh -c 'lodowep -h ; bash'" },
  { "lyricpass", "urxvt -e sh -c 'lyricpass -h ; bash'" },
  { "mdcrack", "urxvt -e sh -c 'mdcrack ; bash'" },
  { "medusa", "urxvt -e sh -c 'medusa -h ; bash'" },
  { "mentalist", "urxvt -e sh -c 'mentalist ; bash'" },
  { "mfoc", "urxvt -e sh -c 'mfoc -h ; bash'" },
  { "mimipenguin", "urxvt -e sh -c 'mimipenguin ; bash'" },
  { "mkbrutus", "urxvt -e sh -c 'mkbrutus -h ; bash'" },
  { "morxbook", "urxvt -e sh -c 'morxbook ; bash'" },
  { "morxbrute", "urxvt -e sh -c 'morxbrute ; bash'" },
  { "morxbtcrack", "urxvt -e sh -c 'morxbtcrack ; bash'" },
  { "morxcoinpwn", "urxvt -e sh -c 'morxcoinpwn ; bash'" },
  { "morxcrack", "urxvt -e sh -c 'morxcrack -h ; bash'" },
  { "mybff", "urxvt -e sh -c 'mybff -h ; bash'" },
  { "myjwt", "urxvt -e sh -c 'myjwt -h ; bash'" },
  { "ncrack", "urxvt -e sh -c 'ncrack -h ; bash'" },
  { "o365spray", "urxvt -e sh -c 'o365spray -h ; bash'" },
  { "obevilion", "urxvt -e sh -c 'obevilion --help ; bash'" },
  { "ocs-cisco", "urxvt -e sh -c 'ocs-cisco ; bash'" },
  { "omen-alphabetcreator", "urxvt -e sh -c 'omen-alphabetcreator -h ; bash'" },
  { "omen-createng", "urxvt -e sh -c 'omen-createng -h ; bash'" },
  { "omen-enumng", "urxvt -e sh -c 'omen-enumng -h ; bash'" },
  { "omen-evalpw", "urxvt -e sh -c 'omen-evalpw -h ; bash'" },
  { "onesixtyone", "urxvt -e sh -c 'onesixtyone ; bash'" },
  { "ophcrack", "urxvt -e sh -c 'ophcrack -h ; bash'" },
  { "owabf", "urxvt -e sh -c 'owabf -h ; bash'" },
  { "maskgen", "urxvt -e sh -c 'maskgen -h ; bash'" },
  { "policygen", "urxvt -e sh -c 'policygen -h ; bash'" },
  { "rulegen", "urxvt -e sh -c 'rulegen -h ; bash'" },
  { "statsgen", "urxvt -e sh -c 'statsgen -h ; bash'" },
  { "passcracking", "urxvt -e sh -c 'passcracking ; bash'" },
  { "passe-partout", "urxvt -e sh -c 'passe-partout -h ; bash'" },
  { "patator", "urxvt -e sh -c 'patator --help ; bash'" },
  { "pdfcrack", "urxvt -e sh -c 'pdfcrack ; bash'" },
  { "pdgmail", "urxvt -e sh -c 'pdgmail -h ; bash'" },
  { "pemcrack", "urxvt -e sh -c 'pemcrack ; bash'" },
  { "pemcracker", "urxvt -e sh -c 'pemcracker ; bash'" },
  { "PHoss", "urxvt -e sh -c 'PHoss -h ; bash'" },
  { "php-mt-seed", "urxvt -e sh -c 'php-mt-seed ; bash'" },
  { "phrasendrescher", "urxvt -e sh -c 'phrasendrescher -h ; bash'" },
  { "pipal", "urxvt -e sh -c 'pipal ; bash'" },
  { "pipeline", "urxvt -e sh -c 'pipeline ; bash'" },
  { "pkcrack", "urxvt -e sh -c 'pkcrack ; bash'" },
  { "pkcrack-extract", "urxvt -e sh -c 'pkcrack-extract ; bash'" },
  { "pwcrack", "urxvt -e sh -c 'pwcrack -h ; bash'" },
  { "pybozocrack", "urxvt -e sh -c 'pybozocrack -h ; bash'" },
  { "pyrit", "urxvt -e sh -c 'pyrit -h ; bash'" },
  { "pythem", "urxvt -e sh -c 'pythem ; bash'" },
  { "rcrack", "urxvt -e sh -c 'rcrack ; bash'" },
  { "rt2rtc", "urxvt -e sh -c 'rt2rtc ; bash'" },
  { "rtc2rt", "urxvt -e sh -c 'rtc2rt ; bash'" },
  { "rtgen", "urxvt -e sh -c 'rtgen ; bash'" },
  { "rtmerge", "urxvt -e sh -c 'rtmerge ; bash'" },
  { "rtsort", "urxvt -e sh -c 'rtsort ; bash'" },
  { "rarcrack", "urxvt -e sh -c 'rarcrack --help ; bash'" },
  { "rcracki_mt", "urxvt -e sh -c 'rcracki_mt ; bash'" },
  { "rdesktop-brute", "urxvt -e sh -c 'rdesktop-brute -h ; bash'" },
  { "rdpassspray", "urxvt -e sh -c 'rdpassspray -h ; bash'" },
  { "reaver", "urxvt -e sh -c 'reaver ; bash'" },
  { "rhodiola", "urxvt -e sh -c 'rhodiola -h ; bash'" },
  { "ridenum", "urxvt -e sh -c 'ridenum -h ; bash'" },
  { "rlogin-scanner", "urxvt -e sh -c 'rlogin-scanner -h ; bash'" },
  { "rootbrute", "urxvt -e sh -c 'rootbrute -h ; bash'" },
  { "rpdscan", "urxvt -e sh -c 'rpdscan -h ; bash'" },
  { "rsactftool", "urxvt -e sh -c 'rsactftool -h ; bash'" },
  { "samydeluxe", "urxvt -e sh -c 'samydeluxe -h ; bash'" },
  { "sb0x", "urxvt -e sh -c 'sb0x -h ; bash'" },
  { "shreder", "urxvt -e sh -c 'shreder -h ; bash'" },
  { "sidguess", "urxvt -e sh -c 'sidguess ; bash'" },
  { "sipbrute", "urxvt -e sh -c 'sipbrute -h ; bash'" },
  { "sipcrack", "urxvt -e sh -c 'sipcrack -h ; bash'" },
  { "sipdump", "urxvt -e sh -c 'sipdump -h ; bash'" },
  { "skul", "urxvt -e sh -c 'skul ; bash'" },
  { "nbdecode", "urxvt -e sh -c 'nbdecode ; bash'" },
  { "smbbf", "urxvt -e sh -c 'smbbf -h ; bash'" },
  { "smbdumpusers", "urxvt -e sh -c 'smbdumpusers ; bash'" },
  { "smbgetserverinfo", "urxvt -e sh -c 'smbgetserverinfo ; bash'" },
  { "smtptester", "urxvt -e sh -c 'smtptester -h ; bash'" },
  { "sn1per", "urxvt -e sh -c 'sn1per ; bash'" },
  { "http-default-accounts-fingerprints-nndefaccts.lua", "urxvt -e sh -c 'http-default-accounts-fingerprints-nndefaccts.lua ; bash'" },
  { "inurlbr.php", "urxvt -e sh -c 'inurlbr.php ; bash'" },
  { "nmap-bootstrap.xsl", "urxvt -e sh -c 'nmap-bootstrap.xsl ; bash'" },
  { "snmpbrute", "urxvt -e sh -c 'snmpbrute ; bash'" },
  { "sparta", "urxvt -e sh -c 'sparta ; bash'" },
  { "speedport-arcadyan", "urxvt -e sh -c 'speedport-arcadyan ; bash'" },
  { "speedpwn", "urxvt -e sh -c 'speedpwn -h ; bash'" },
  { "sqlbf", "urxvt -e sh -c 'sqlbf ; bash'" },
  { "sslnuke", "urxvt -e sh -c 'sslnuke ; bash'" },
  { "sucrack", "urxvt -e sh -c 'sucrack ; bash'" },
  { "swarm", "urxvt -e sh -c 'swarm -h ; bash'" },
  { "tftpbrute", "urxvt -e sh -c 'tftpbrute ; bash'" },
  { "keyfinder", "urxvt -e sh -c 'keyfinder ; bash'" },
  { "thc-pptp-bruter", "urxvt -e sh -c 'thc-pptp-bruter ; bash'" },
  { "thc-smartbrute", "urxvt -e sh -c 'thc-smartbrute -h ; bash'" },
  { "ttpassgen", "urxvt -e sh -c 'ttpassgen -h ; bash'" },
  { "ufo-wardriving", "urxvt -e sh -c 'ufo-wardriving ; bash'" },
  { "vnc-bypauth", "urxvt -e sh -c 'vnc-bypauth ; bash'" },
  { "vncrack", "urxvt -e sh -c 'vncrack ; bash'" },
  { "wifibroot", "urxvt -e sh -c 'wifibroot -h ; bash'" },
  { "wifite", "urxvt -e sh -c 'wifite ; bash'" },
  { "wmat", "urxvt -e sh -c 'wmat ; bash'" },
  { "wordbrutepress", "urxvt -e sh -c 'wordbrutepress ; bash'" },
  { "wpbf", "urxvt -e sh -c 'wpbf -h ; bash'" },
  { "wpbrute-rpc", "urxvt -e sh -c 'wpbrute-rpc ; bash'" },
  { "wpforce", "urxvt -e sh -c 'wpforce -h ; bash'" },
  { "wpforce-yertle", "urxvt -e sh -c 'wpforce-yertle -h ; bash'" },
  { "wyd", "urxvt -e sh -c 'wyd ; bash'" },
  { "zackattack", "urxvt -e sh -c 'zackattack -h ; bash'" },
  { "zulu", "urxvt -e sh -c 'zulu ; bash'" },
}

cryptomenu = {
  { "aespipe", "urxvt -e sh -c 'aespipe -h ; bash'" },
  { "argon2", "urxvt -e sh -c 'argon2 -h ; bash'" },
  { "armor", "urxvt -e sh -c 'armor ; bash'" },
  { "athena-ssl-scanner", "urxvt -e sh -c 'athena-ssl-scanner -h ; bash'" },
  { "auto-xor-decryptor", "urxvt -e sh -c 'auto-xor-decryptor ; bash'" },
  { "bletchley-analyze", "urxvt -e sh -c 'bletchley-analyze ; bash'" },
  { "bletchley-clonecertchain", "urxvt -e sh -c 'bletchley-clonecertchain ; bash'" },
  { "bletchley-decode", "urxvt -e sh -c 'bletchley-decode ; bash'" },
  { "bletchley-encode", "urxvt -e sh -c 'bletchley-encode ; bash'" },
  { "bletchley-nextrand", "urxvt -e sh -c 'bletchley-nextrand ; bash'" },
  { "bruteforce-luks", "urxvt -e sh -c 'bruteforce-luks -h ; bash'" },
  { "bruteforce-salted-openssl", "urxvt -e sh -c 'bruteforce-salted-openssl -h ; bash'" },
  { "bruteforce-wallet", "urxvt -e sh -c 'bruteforce-wallet ; bash'" },
  { "cipherscan", "urxvt -e sh -c 'cipherscan ; bash'" },
  { "ciphertest", "urxvt -e sh -c 'ciphertest ; bash'" },
  { "ciphr", "urxvt -e sh -c 'ciphr -h ; bash'" },
  { "c5c", "urxvt -e sh -c 'c5c --help ; bash'" },
  { "cisco7crack", "urxvt -e sh -c 'cisco7crack -h ; bash'" },
  { "cloakify", "urxvt -e sh -c 'cloakify ; bash'" },
  { "decloakify", "urxvt -e sh -c 'decloakify ; bash'" },
  { "codetective", "urxvt -e sh -c 'codetective -h ; bash'" },
  { "cribdrag", "urxvt -e sh -c 'cribdrag -h ; bash'" },
  { "cribdrag-xorstrings", "urxvt -e sh -c 'cribdrag-xorstrings -h ; bash'" },
  { "cryptohazemultiforcer", "urxvt -e sh -c 'cryptohazemultiforcer ; bash'" },
  { "cnark", "urxvt -e sh -c 'cnark ; bash'" },
  { "dagon", "urxvt -e sh -c 'dagon -h ; bash'" },
  { "daredevil", "urxvt -e sh -c 'daredevil -h ; bash'" },
  { "decodify", "urxvt -e sh -c 'decodify -h ; bash'" },
  { "deen", "urxvt -e sh -c 'deen ; bash'" },
  { "demiguise", "urxvt -e sh -c 'demiguise -h ; bash'" },
  { "dislocker", "urxvt -e sh -c 'dislocker -h ; bash'" },
  { "dislocker-bek", "urxvt -e sh -c 'dislocker-bek ; bash'" },
  { "dislocker-file", "urxvt -e sh -c 'dislocker-file ; bash'" },
  { "dislocker-find", "urxvt -e sh -c 'dislocker-find ; bash'" },
  { "dislocker-fuse", "urxvt -e sh -c 'dislocker-fuse ; bash'" },
  { "dislocker-metadata", "urxvt -e sh -c 'dislocker-metadata ; bash'" },
  { "bunnyducky", "urxvt -e sh -c 'bunnyducky -h ; bash'" },
  { "ducktools", "urxvt -e sh -c 'ducktools -h ; bash'" },
  { "evilize", "urxvt -e sh -c 'evilize -h ; bash'" },
  { "factordb", "urxvt -e sh -c 'factordb -h ; bash'" },
  { "featherduster", "urxvt -e sh -c 'featherduster -h ; bash'" },
  { "foresee", "urxvt -e sh -c 'foresee -h ; bash'" },
  { "gcrypt", "urxvt -e sh -c 'gcrypt --help ; bash'" },
  { "haiti", "urxvt -e sh -c 'haiti -h ; bash'" },
  { "haiti_console", "urxvt -e sh -c 'haiti_console ; bash'" },
  { "md5deep", "urxvt -e sh -c 'md5deep -h ; bash'" },
  { "sha1deep", "urxvt -e sh -c 'sha1deep -h ; bash'" },
  { "sha256deep", "urxvt -e sh -c 'sha256deep -h ; bash'" },
  { "tigerdeep", "urxvt -e sh -c 'tigerdeep -h ; bash'" },
  { "whirlpooldeep", "urxvt -e sh -c 'whirlpooldeep -h ; bash'" },
  { "md5deep", "urxvt -e sh -c 'md5deep -h ; bash'" },
  { "sha1deep", "urxvt -e sh -c 'sha1deep -h ; bash'" },
  { "sha256deep", "urxvt -e sh -c 'sha256deep -h ; bash'" },
  { "tigerdeep", "urxvt -e sh -c 'tigerdeep -h ; bash'" },
  { "whirlpooldeep", "urxvt -e sh -c 'whirlpooldeep -h ; bash'" },
  { "wlangenpmk", "urxvt -e sh -c 'wlangenpmk -h ; bash'" },
  { "wlangenpmkocl", "urxvt -e sh -c 'wlangenpmkocl -h ; bash'" },
  { "wlangenpmk", "urxvt -e sh -c 'wlangenpmk -h ; bash'" },
  { "wlangenpmkocl", "urxvt -e sh -c 'wlangenpmkocl -h ; bash'" },
  { "ja3", "urxvt -e sh -c 'ja3 -h ; bash'" },
  { "kraken", "urxvt -e sh -c 'kraken -h ; bash'" },
  { "bdeinfo", "urxvt -e sh -c 'bdeinfo ; bash'" },
  { "bdemount", "urxvt -e sh -c 'bdemount ; bash'" },
  { "lbb.db", "urxvt -e sh -c 'lbb.db ; bash'" },
  { "littleblackbox", "urxvt -e sh -c 'littleblackbox -h ; bash'" },
  { "luksipc", "urxvt -e sh -c 'luksipc -h ; bash'" },
  { "morxcrack", "urxvt -e sh -c 'morxcrack -h ; bash'" },
  { "nomorexor", "urxvt -e sh -c 'nomorexor ; bash'" },
  { "omen-alphabetcreator", "urxvt -e sh -c 'omen-alphabetcreator -h ; bash'" },
  { "omen-createng", "urxvt -e sh -c 'omen-createng -h ; bash'" },
  { "omen-enumng", "urxvt -e sh -c 'omen-enumng -h ; bash'" },
  { "omen-evalpw", "urxvt -e sh -c 'omen-evalpw -h ; bash'" },
  { "openstego", "urxvt -e sh -c 'openstego -h ; bash'" },
  { "outguess", "urxvt -e sh -c 'outguess ; bash'" },
  { "pip3line", "urxvt -e sh -c 'pip3line ; bash'" },
  { "posttester", "urxvt -e sh -c 'posttester -h ; bash'" },
  { "pwdlyser", "urxvt -e sh -c 'pwdlyser -h ; bash'" },
  { "pybozocrack", "urxvt -e sh -c 'pybozocrack -h ; bash'" },
  { "pyssltest", "urxvt -e sh -c 'pyssltest -h ; bash'" },
  { "rdp-cipher-checker", "urxvt -e sh -c 'rdp-cipher-checker ; bash'" },
  { "rsactftool", "urxvt -e sh -c 'rsactftool -h ; bash'" },
  { "rsatool", "urxvt -e sh -c 'rsatool -h ; bash'" },
  { "rupture", "urxvt -e sh -c 'rupture -h ; bash'" },
  { "sandy", "urxvt -e sh -c 'sandy -h ; bash'" },
  { "sbd", "urxvt -e sh -c 'sbd -h ; bash'" },
  { "sha1dcsum", "urxvt -e sh -c 'sha1dcsum ; bash'" },
  { "sha1dcsum_partialcoll", "urxvt -e sh -c 'sha1dcsum_partialcoll ; bash'" },
  { "sherlocked", "urxvt -e sh -c 'sherlocked ; bash'" },
  { "stripx", "urxvt -e sh -c 'stripx ; bash'" },
  { "stub", "urxvt -e sh -c 'stub ; bash'" },
  { "skul", "urxvt -e sh -c 'skul ; bash'" },
  { "snapception", "urxvt -e sh -c 'snapception --help ; bash'" },
  { "snow", "urxvt -e sh -c 'snow -h ; bash'" },
  { "spipe", "urxvt -e sh -c 'spipe ; bash'" },
  { "spiped", "urxvt -e sh -c 'spiped ; bash'" },
  { "ssdeep", "urxvt -e sh -c 'ssdeep ; bash'" },
  { "sslcaudit", "urxvt -e sh -c 'sslcaudit -h ; bash'" },
  { "ssllabs-scan", "urxvt -e sh -c 'ssllabs-scan -h ; bash'" },
  { "sslmap", "urxvt -e sh -c 'sslmap -h ; bash'" },
  { "sslscan", "urxvt -e sh -c 'sslscan ; bash'" },
  { "sslyze", "urxvt -e sh -c 'sslyze -h ; bash'" },
  { "tchunt-ng", "urxvt -e sh -c 'tchunt-ng -h ; bash'" },
  { "testssl", "urxvt -e sh -c 'testssl ; bash'" },
  { "tls-attacker-Attacks", "urxvt -e sh -c 'tls-attacker-Attacks ; bash'" },
  { "tls-attacker-TLS-Client", "urxvt -e sh -c 'tls-attacker-TLS-Client ; bash'" },
  { "tls-attacker-TLS-Forensics", "urxvt -e sh -c 'tls-attacker-TLS-Forensics ; bash'" },
  { "tls-attacker-TLS-Mitm", "urxvt -e sh -c 'tls-attacker-TLS-Mitm ; bash'" },
  { "tls-attacker-TLS-Server", "urxvt -e sh -c 'tls-attacker-TLS-Server ; bash'" },
  { "tls-attacker-TraceTool", "urxvt -e sh -c 'tls-attacker-TraceTool ; bash'" },
  { "tls-map", "urxvt -e sh -c 'tls-map -h ; bash'" },
  { "tls-prober", "urxvt -e sh -c 'tls-prober -h ; bash'" },
  { "tlsenum", "urxvt -e sh -c 'tlsenum -h ; bash'" },
  { "tlspretense", "urxvt -e sh -c 'tlspretense ; bash'" },
  { "untwister", "urxvt -e sh -c 'untwister -h ; bash'" },
  { "veracrypt", "urxvt -e sh -c 'veracrypt ; bash'" },
  { "webfixy", "urxvt -e sh -c 'webfixy -h ; bash'" },
  { "x-rsa", "urxvt -e sh -c 'x-rsa -h ; bash'" },
  { "xorsearch", "urxvt -e sh -c 'xorsearch ; bash'" },
  { "xortool", "urxvt -e sh -c 'xortool -h ; bash'" },
  { "xortool-xor", "urxvt -e sh -c 'xortool-xor ; bash'" },
  { "xortool", "urxvt -e sh -c 'xortool -h ; bash'" },
  { "xortool-xor", "urxvt -e sh -c 'xortool-xor ; bash'" },
  { "zuluCrypt-cli", "urxvt -e sh -c 'zuluCrypt-cli -h ; bash'" },
  { "zuluCrypt-gui", "urxvt -e sh -c 'zuluCrypt-gui ; bash'" },
  { "zuluMount-cli", "urxvt -e sh -c 'zuluMount-cli -h ; bash'" },
  { "zuluMount-gui", "urxvt -e sh -c 'zuluMount-gui ; bash'" },
  { "zuluPolkit", "urxvt -e sh -c 'zuluPolkit -h ; bash'" },
  { "zuluSafe-cli", "urxvt -e sh -c 'zuluSafe-cli -h ; bash'" },
}

databasemenu = {
  { "sqlcheck", "urxvt -e sh -c 'sqlcheck -h ; bash'" },
  { "sqldata", "urxvt -e sh -c 'sqldata -h ; bash'" },
  { "getsids", "urxvt -e sh -c 'getsids ; bash'" },
  { "metacoretex", "urxvt -e sh -c 'metacoretex ; bash'" },
  { "mysql2sqlite", "urxvt -e sh -c 'mysql2sqlite -h ; bash'" },
  { "pgdbf", "urxvt -e sh -c 'pgdbf -h ; bash'" },
  { "unibrute", "urxvt -e sh -c 'unibrute ; bash'" },
}

debuggermenu = {
  { "bindead", "urxvt -e sh -c 'bindead ; bash'" },
  { "binflow", "urxvt -e sh -c 'binflow ; bash'" },
  { "dwarf", "urxvt -e sh -c 'dwarf --help ; bash'" },
  { "edb", "urxvt -e sh -c 'edb ; bash'" },
  { "electric-fence", "urxvt -e sh -c 'electric-fence ; bash'" },
  { "e2dbg32", "urxvt -e sh -c 'e2dbg32 ; bash'" },
  { "e2dbg64", "urxvt -e sh -c 'e2dbg64 ; bash'" },
  { "etrace32", "urxvt -e sh -c 'etrace32 ; bash'" },
  { "etrace64", "urxvt -e sh -c 'etrace64 ; bash'" },
  { "evarista32", "urxvt -e sh -c 'evarista32 ; bash'" },
  { "evarista64", "urxvt -e sh -c 'evarista64 ; bash'" },
  { "kedbg32", "urxvt -e sh -c 'kedbg32 ; bash'" },
  { "kedbg64", "urxvt -e sh -c 'kedbg64 ; bash'" },
  { "gcore", "urxvt -e sh -c 'gcore ; bash'" },
  { "gdb", "urxvt -e sh -c 'gdb -h ; bash'" },
  { "gdbserver", "urxvt -e sh -c 'gdbserver --help ; bash'" },
  { "gcore", "urxvt -e sh -c 'gcore ; bash'" },
  { "gdb", "urxvt -e sh -c 'gdb -h ; bash'" },
  { "gdbserver", "urxvt -e sh -c 'gdbserver --help ; bash'" },
  { "gdbgui", "urxvt -e sh -c 'gdbgui -h ; bash'" },
  { "ghidra", "urxvt -e sh -c 'ghidra ; bash'" },
  { "ghidra-analyzeHeadless", "urxvt -e sh -c 'ghidra-analyzeHeadless ; bash'" },
  { "ghidra", "urxvt -e sh -c 'ghidra ; bash'" },
  { "ghidra-analyzeHeadless", "urxvt -e sh -c 'ghidra-analyzeHeadless ; bash'" },
  { "iaito", "urxvt -e sh -c 'iaito ; bash'" },
  { "gen-bout", "urxvt -e sh -c 'gen-bout ; bash'" },
  { "gen-random-bout", "urxvt -e sh -c 'gen-random-bout ; bash'" },
  { "kleaver", "urxvt -e sh -c 'kleaver -h ; bash'" },
  { "klee", "urxvt -e sh -c 'klee -h ; bash'" },
  { "klee-stats", "urxvt -e sh -c 'klee-stats -h ; bash'" },
  { "ktest-tool", "urxvt -e sh -c 'ktest-tool -h ; bash'" },
  { "lldb", "urxvt -e sh -c 'lldb ; bash'" },
  { "lldb-argdumper", "urxvt -e sh -c 'lldb-argdumper ; bash'" },
  { "lldb-instr", "urxvt -e sh -c 'lldb-instr ; bash'" },
  { "lldb-server", "urxvt -e sh -c 'lldb-server ; bash'" },
  { "lldb-vscode", "urxvt -e sh -c 'lldb-vscode ; bash'" },
  { "lldb", "urxvt -e sh -c 'lldb ; bash'" },
  { "lldb-argdumper", "urxvt -e sh -c 'lldb-argdumper ; bash'" },
  { "lldb-instr", "urxvt -e sh -c 'lldb-instr ; bash'" },
  { "lldb-server", "urxvt -e sh -c 'lldb-server ; bash'" },
  { "lldb-vscode", "urxvt -e sh -c 'lldb-vscode ; bash'" },
  { "malwasm", "urxvt -e sh -c 'malwasm ; bash'" },
  { "ollydbg", "urxvt -e sh -c 'ollydbg ; bash'" },
  { "plasma-disasm", "urxvt -e sh -c 'plasma-disasm -h ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "rr", "urxvt -e sh -c 'rr -h ; bash'" },
  { "saleae-logic", "urxvt -e sh -c 'saleae-logic ; bash'" },
  { "cygdb", "urxvt -e sh -c 'cygdb ; bash'" },
  { "cython", "urxvt -e sh -c 'cython ; bash'" },
  { "cythonize", "urxvt -e sh -c 'cythonize ; bash'" },
  { "py.test", "urxvt -e sh -c 'py.test ; bash'" },
  { "pytest", "urxvt -e sh -c 'pytest ; bash'" },
  { "shellnoob", "urxvt -e sh -c 'shellnoob -h ; bash'" },
  { "voltron", "urxvt -e sh -c 'voltron -h ; bash'" },
}

decompilermenu = {
  { "beebug", "urxvt -e sh -c 'beebug -h ; bash'" },
  { "cafebabe", "urxvt -e sh -c 'cafebabe ; bash'" },
  { "cfr", "urxvt -e sh -c 'cfr --help ; bash'" },
  { "fernflower", "urxvt -e sh -c 'fernflower -h ; bash'" },
  { "flasm", "urxvt -e sh -c 'flasm -h ; bash'" },
  { "gadgetinspector", "urxvt -e sh -c 'gadgetinspector ; bash'" },
  { "hopper", "urxvt -e sh -c 'hopper ; bash'" },
  { "iaito", "urxvt -e sh -c 'iaito ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jd-cli", "urxvt -e sh -c 'jd-cli -h ; bash'" },
  { "jd-gui", "urxvt -e sh -c 'jd-gui ; bash'" },
  { "jpexs-decompiler", "urxvt -e sh -c 'jpexs-decompiler ; bash'" },
  { "luyten", "urxvt -e sh -c 'luyten ; bash'" },
  { "pcode2code", "urxvt -e sh -c 'pcode2code -h ; bash'" },
  { "procyon", "urxvt -e sh -c 'procyon ; bash'" },
  { "pydisassemble", "urxvt -e sh -c 'pydisassemble ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "recaf", "urxvt -e sh -c 'recaf ; bash'" },
  { "recstudio", "urxvt -e sh -c 'recstudio ; bash'" },
  { "retdec-ar-extractor", "urxvt -e sh -c 'retdec-ar-extractor -h ; bash'" },
  { "retdec-archive-decompiler", "urxvt -e sh -c 'retdec-archive-decompiler -h ; bash'" },
  { "retdec-color-c", "urxvt -e sh -c 'retdec-color-c -h ; bash'" },
  { "retdec-decompiler", "urxvt -e sh -c 'retdec-decompiler -h ; bash'" },
  { "retdec-fileinfo", "urxvt -e sh -c 'retdec-fileinfo -h ; bash'" },
  { "retdec-getsig", "urxvt -e sh -c 'retdec-getsig -h ; bash'" },
  { "retdec-idr2pat", "urxvt -e sh -c 'retdec-idr2pat -h ; bash'" },
  { "retdec-macho-extractor", "urxvt -e sh -c 'retdec-macho-extractor -h ; bash'" },
  { "retdec-pat2yara", "urxvt -e sh -c 'retdec-pat2yara -h ; bash'" },
  { "retdec-signature-from-library-creator", "urxvt -e sh -c 'retdec-signature-from-library-creator -h ; bash'" },
  { "retdec-stacofin", "urxvt -e sh -c 'retdec-stacofin -h ; bash'" },
  { "retdec-unpacker", "urxvt -e sh -c 'retdec-unpacker -h ; bash'" },
  { "retdec-utils", "urxvt -e sh -c 'retdec-utils -h ; bash'" },
  { "retdec-yarac", "urxvt -e sh -c 'retdec-yarac ; bash'" },
}

defensivemenu = {
  { "aiengine", "urxvt -e sh -c 'aiengine -h ; bash'" },
  { "argon2", "urxvt -e sh -c 'argon2 -h ; bash'" },
  { "argus-extip", "urxvt -e sh -c 'argus-extip ; bash'" },
  { "argus-lsof", "urxvt -e sh -c 'argus-lsof ; bash'" },
  { "argus-snmp", "urxvt -e sh -c 'argus-snmp ; bash'" },
  { "argus-vmstat", "urxvt -e sh -c 'argus-vmstat ; bash'" },
  { "argusbug", "urxvt -e sh -c 'argusbug ; bash'" },
  { "argusclientbug", "urxvt -e sh -c 'argusclientbug ; bash'" },
  { "ra", "urxvt -e sh -c 'ra -h ; bash'" },
  { "racluster", "urxvt -e sh -c 'racluster -h ; bash'" },
  { "raconvert", "urxvt -e sh -c 'raconvert -h ; bash'" },
  { "racount", "urxvt -e sh -c 'racount -h ; bash'" },
  { "radark", "urxvt -e sh -c 'radark -h ; bash'" },
  { "radecode", "urxvt -e sh -c 'radecode ; bash'" },
  { "radium", "urxvt -e sh -c 'radium -h ; bash'" },
  { "radump", "urxvt -e sh -c 'radump ; bash'" },
  { "raevent", "urxvt -e sh -c 'raevent -h ; bash'" },
  { "rafilteraddr", "urxvt -e sh -c 'rafilteraddr ; bash'" },
  { "ragraph", "urxvt -e sh -c 'ragraph ; bash'" },
  { "ragrep", "urxvt -e sh -c 'ragrep ; bash'" },
  { "rahisto", "urxvt -e sh -c 'rahisto ; bash'" },
  { "rahosts", "urxvt -e sh -c 'rahosts ; bash'" },
  { "ralabel", "urxvt -e sh -c 'ralabel ; bash'" },
  { "ranonymize", "urxvt -e sh -c 'ranonymize ; bash'" },
  { "rapath", "urxvt -e sh -c 'rapath ; bash'" },
  { "rapolicy", "urxvt -e sh -c 'rapolicy ; bash'" },
  { "raports", "urxvt -e sh -c 'raports ; bash'" },
  { "rarpwatch", "urxvt -e sh -c 'rarpwatch ; bash'" },
  { "raservices", "urxvt -e sh -c 'raservices ; bash'" },
  { "rasort", "urxvt -e sh -c 'rasort -h ; bash'" },
  { "rastream", "urxvt -e sh -c 'rastream -h ; bash'" },
  { "rastrip", "urxvt -e sh -c 'rastrip -h ; bash'" },
  { "ratimerange", "urxvt -e sh -c 'ratimerange ; bash'" },
  { "ratop", "urxvt -e sh -c 'ratop ; bash'" },
  { "rauserdata", "urxvt -e sh -c 'rauserdata ; bash'" },
  { "arpalert", "urxvt -e sh -c 'arpalert -h ; bash'" },
  { "arpon", "urxvt -e sh -c 'arpon -h ; bash'" },
  { "artillery", "urxvt -e sh -c 'artillery ; bash'" },
  { "artlas", "urxvt -e sh -c 'artlas ; bash'" },
  { "bamfbrute", "urxvt -e sh -c 'bamfbrute -h ; bash'" },
  { "bamfdetect", "urxvt -e sh -c 'bamfdetect -h ; bash'" },
  { "beholder", "urxvt -e sh -c 'beholder -h ; bash'" },
  { "camscan", "urxvt -e sh -c 'camscan -h ; bash'" },
  { "centry", "urxvt -e sh -c 'centry -h ; bash'" },
  { "chkrootkit", "urxvt -e sh -c 'chkrootkit -h ; bash'" },
  { "credmap", "urxvt -e sh -c 'credmap -h ; bash'" },
  { "dbpwaudit", "urxvt -e sh -c 'dbpwaudit -h ; bash'" },
  { "detect-sniffer", "urxvt -e sh -c 'detect-sniffer -h ; bash'" },
  { "exabgp", "urxvt -e sh -c 'exabgp ; bash'" },
  { "exabgp-cli", "urxvt -e sh -c 'exabgp-cli ; bash'" },
  { "exabgp-healthcheck", "urxvt -e sh -c 'exabgp-healthcheck ; bash'" },
  { "exabgpcli", "urxvt -e sh -c 'exabgpcli ; bash'" },
  { "fastnetmon", "urxvt -e sh -c 'fastnetmon --help ; bash'" },
  { "fastnetmon-client", "urxvt -e sh -c 'fastnetmon-client ; bash'" },
  { "fssb", "urxvt -e sh -c 'fssb -h ; bash'" },
  { "h2t", "urxvt -e sh -c 'h2t -h ; bash'" },
  { "honeycreds", "urxvt -e sh -c 'honeycreds -h ; bash'" },
  { "ifchk", "urxvt -e sh -c 'ifchk -h ; bash'" },
  { "inetsim", "urxvt -e sh -c 'inetsim --help ; bash'" },
  { "jeopardize", "urxvt -e sh -c 'jeopardize -h ; bash'" },
  { "jhead", "urxvt -e sh -c 'jhead -h ; bash'" },
  { "lorg", "urxvt -e sh -c 'lorg -h ; bash'" },
  { "lunar", "urxvt -e sh -c 'lunar -h ; bash'" },
  { "malcom", "urxvt -e sh -c 'malcom -h ; bash'" },
  { "malice", "urxvt -e sh -c 'malice ; bash'" },
  { "malmon", "urxvt -e sh -c 'malmon -h ; bash'" },
  { "malmon-scan", "urxvt -e sh -c 'malmon-scan ; bash'" },
  { "maltrail-sensor", "urxvt -e sh -c 'maltrail-sensor -h ; bash'" },
  { "maltrail-server", "urxvt -e sh -c 'maltrail-server -h ; bash'" },
  { "mat", "urxvt -e sh -c 'mat -h ; bash'" },
  { "mat-gui", "urxvt -e sh -c 'mat-gui ; bash'" },
  { "mat2", "urxvt -e sh -c 'mat2 -h ; bash'" },
  { "quantuminject", "urxvt -e sh -c 'quantuminject -h ; bash'" },
  { "munin", "urxvt -e sh -c 'munin -h ; bash'" },
  { "munin-host", "urxvt -e sh -c 'munin-host -h ; bash'" },
  { "nipe", "urxvt -e sh -c 'nipe help ; bash'" },
  { "nohidy", "urxvt -e sh -c 'nohidy ; bash'" },
  { "nsia", "urxvt -e sh -c 'nsia -h ; bash'" },
  { "nzyme", "urxvt -e sh -c 'nzyme ; bash'" },
  { "onionscan", "urxvt -e sh -c 'onionscan ; bash'" },
  { "autotailor", "urxvt -e sh -c 'autotailor ; bash'" },
  { "oscap", "urxvt -e sh -c 'oscap -h ; bash'" },
  { "oscap-chroot", "urxvt -e sh -c 'oscap-chroot -h ; bash'" },
  { "oscap-docker", "urxvt -e sh -c 'oscap-docker -h ; bash'" },
  { "oscap-podman", "urxvt -e sh -c 'oscap-podman -h ; bash'" },
  { "oscap-run-sce-script", "urxvt -e sh -c 'oscap-run-sce-script ; bash'" },
  { "oscap-vm", "urxvt -e sh -c 'oscap-vm -h ; bash'" },
  { "scap-as-rpm", "urxvt -e sh -c 'scap-as-rpm -h ; bash'" },
  { "orjail", "urxvt -e sh -c 'orjail -h ; bash'" },
  { "osfooler-ng", "urxvt -e sh -c 'osfooler-ng -h ; bash'" },
  { "pidense", "urxvt -e sh -c 'pidense -h ; bash'" },
  { "nfacctd", "urxvt -e sh -c 'nfacctd -h ; bash'" },
  { "pmacct", "urxvt -e sh -c 'pmacct -h ; bash'" },
  { "pmacctd", "urxvt -e sh -c 'pmacctd -h ; bash'" },
  { "pmbgpd", "urxvt -e sh -c 'pmbgpd -h ; bash'" },
  { "pmbmpd", "urxvt -e sh -c 'pmbmpd -h ; bash'" },
  { "pmtelemetryd", "urxvt -e sh -c 'pmtelemetryd -h ; bash'" },
  { "sfacctd", "urxvt -e sh -c 'sfacctd -h ; bash'" },
  { "png-fix-IDAT-windowsize", "urxvt -e sh -c 'png-fix-IDAT-windowsize -h ; bash'" },
  { "pngcheck", "urxvt -e sh -c 'pngcheck -h ; bash'" },
  { "polyswarm", "urxvt -e sh -c 'polyswarm -h ; bash'" },
  { "portspoof", "urxvt -e sh -c 'portspoof -h ; bash'" },
  { "prowler", "urxvt -e sh -c 'prowler -h ; bash'" },
  { "quicksand", "urxvt -e sh -c 'quicksand ; bash'" },
  { "rkhunter", "urxvt -e sh -c 'rkhunter -h ; bash'" },
  { "sagan", "urxvt -e sh -c 'sagan -h ; bash'" },
  { "scap-workbench", "urxvt -e sh -c 'scap-workbench ; bash'" },
  { "sdel", "urxvt -e sh -c 'sdel -h ; bash'" },
  { "sfill", "urxvt -e sh -c 'sfill -h ; bash'" },
  { "smem-secure-delete", "urxvt -e sh -c 'smem-secure-delete -h ; bash'" },
  { "srm", "urxvt -e sh -c 'srm -h ; bash'" },
  { "sswap", "urxvt -e sh -c 'sswap -h ; bash'" },
  { "merge_sigma", "urxvt -e sh -c 'merge_sigma -h ; bash'" },
  { "sigma2attack", "urxvt -e sh -c 'sigma2attack -h ; bash'" },
  { "sigma2misp", "urxvt -e sh -c 'sigma2misp -h ; bash'" },
  { "sigma_similarity", "urxvt -e sh -c 'sigma_similarity -h ; bash'" },
  { "sigma_uuid", "urxvt -e sh -c 'sigma_uuid -h ; bash'" },
  { "sigmac", "urxvt -e sh -c 'sigmac -h ; bash'" },
  { "sj-commit-results", "urxvt -e sh -c 'sj-commit-results -h ; bash'" },
  { "sj-iptcpopt-probe", "urxvt -e sh -c 'sj-iptcpopt-probe -h ; bash'" },
  { "sniffjoke", "urxvt -e sh -c 'sniffjoke -h ; bash'" },
  { "sniffjoke-autotest", "urxvt -e sh -c 'sniffjoke-autotest -h ; bash'" },
  { "sniffjokectl", "urxvt -e sh -c 'sniffjokectl -h ; bash'" },
  { "snort", "urxvt -e sh -c 'snort -h ; bash'" },
  { "u2boat", "urxvt -e sh -c 'u2boat ; bash'" },
  { "u2spewfoo", "urxvt -e sh -c 'u2spewfoo ; bash'" },
  { "u2streamer", "urxvt -e sh -c 'u2streamer ; bash'" },
  { "sooty", "urxvt -e sh -c 'sooty ; bash'" },
  { "stegbreak", "urxvt -e sh -c 'stegbreak --help ; bash'" },
  { "stegcompare", "urxvt -e sh -c 'stegcompare --help ; bash'" },
  { "stegdeimage", "urxvt -e sh -c 'stegdeimage --help ; bash'" },
  { "stegdetect", "urxvt -e sh -c 'stegdetect --help ; bash'" },
  { "suricata", "urxvt -e sh -c 'suricata ; bash'" },
  { "suricatactl", "urxvt -e sh -c 'suricatactl ; bash'" },
  { "suricatasc", "urxvt -e sh -c 'suricatasc ; bash'" },
  { "tabi", "urxvt -e sh -c 'tabi -h ; bash'" },
  { "tfsec", "urxvt -e sh -c 'tfsec -h ; bash'" },
  { "threatspec", "urxvt -e sh -c 'threatspec -h ; bash'" },
  { "tor-autocircuit", "urxvt -e sh -c 'tor-autocircuit ; bash'" },
  { "tor-browser-en", "urxvt -e sh -c 'tor-browser-en ; bash'" },
  { "tor-router", "urxvt -e sh -c 'tor-router ; bash'" },
  { "truecrypt", "urxvt -e sh -c 'truecrypt -t -h ; bash'" },
  { "usb-canary", "urxvt -e sh -c 'usb-canary -h ; bash'" },
  { "veracrypt", "urxvt -e sh -c 'veracrypt ; bash'" },
  { "wireless-ids", "urxvt -e sh -c 'wireless-ids -h ; bash'" },
  { "wordpot", "urxvt -e sh -c 'wordpot -h ; bash'" },
  { "yeti", "urxvt -e sh -c 'yeti -h ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "marked", "urxvt -e sh -c 'marked ; bash'" },
  { "bifcl", "urxvt -e sh -c 'bifcl ; bash'" },
  { "binpac", "urxvt -e sh -c 'binpac ; bash'" },
  { "bro", "urxvt -e sh -c 'bro -h ; bash'" },
  { "bro-cut", "urxvt -e sh -c 'bro-cut ; bash'" },
  { "broctl", "urxvt -e sh -c 'broctl ; bash'" },
  { "broker-benchmark", "urxvt -e sh -c 'broker-benchmark ; bash'" },
  { "broker-cluster-benchmark", "urxvt -e sh -c 'broker-cluster-benchmark ; bash'" },
  { "btest", "urxvt -e sh -c 'btest ; bash'" },
  { "btest-ask-update", "urxvt -e sh -c 'btest-ask-update ; bash'" },
  { "btest-bg-run", "urxvt -e sh -c 'btest-bg-run ; bash'" },
  { "btest-bg-run-helper", "urxvt -e sh -c 'btest-bg-run-helper ; bash'" },
  { "btest-bg-wait", "urxvt -e sh -c 'btest-bg-wait ; bash'" },
  { "btest-diff", "urxvt -e sh -c 'btest-diff ; bash'" },
  { "btest-diff-rst", "urxvt -e sh -c 'btest-diff-rst ; bash'" },
  { "btest-progress", "urxvt -e sh -c 'btest-progress ; bash'" },
  { "btest-rst-include", "urxvt -e sh -c 'btest-rst-include ; bash'" },
  { "btest-rst-pipe", "urxvt -e sh -c 'btest-rst-pipe ; bash'" },
  { "btest-setsid", "urxvt -e sh -c 'btest-setsid ; bash'" },
  { "paraglob-test", "urxvt -e sh -c 'paraglob-test ; bash'" },
  { "trace-summary", "urxvt -e sh -c 'trace-summary ; bash'" },
  { "zeek", "urxvt -e sh -c 'zeek ; bash'" },
  { "zeek-archiver", "urxvt -e sh -c 'zeek-archiver ; bash'" },
  { "zeek-cut", "urxvt -e sh -c 'zeek-cut ; bash'" },
  { "zeekctl", "urxvt -e sh -c 'zeekctl ; bash'" },
  { "zkg", "urxvt -e sh -c 'zkg ; bash'" },
  { "adtrace", "urxvt -e sh -c 'adtrace ; bash'" },
  { "rst", "urxvt -e sh -c 'rst ; bash'" },
  { "zeus", "urxvt -e sh -c 'zeus -h ; bash'" },
}

disassemblermenu = {
  { "abcdump", "urxvt -e sh -c 'abcdump -h ; bash'" },
  { "abcgraph", "urxvt -e sh -c 'abcgraph -h ; bash'" },
  { "androarsc", "urxvt -e sh -c 'androarsc ; bash'" },
  { "androcg", "urxvt -e sh -c 'androcg ; bash'" },
  { "androdd", "urxvt -e sh -c 'androdd ; bash'" },
  { "androdis", "urxvt -e sh -c 'androdis ; bash'" },
  { "androguard", "urxvt -e sh -c 'androguard -h ; bash'" },
  { "androgui", "urxvt -e sh -c 'androgui ; bash'" },
  { "androlyze", "urxvt -e sh -c 'androlyze ; bash'" },
  { "androsign", "urxvt -e sh -c 'androsign ; bash'" },
  { "apktool", "urxvt -e sh -c 'apktool ; bash'" },
  { "angr-management", "urxvt -e sh -c 'angr-management ; bash'" },
  { "beebug", "urxvt -e sh -c 'beebug -h ; bash'" },
  { "binnavi", "urxvt -e sh -c 'binnavi ; bash'" },
  { "binwalk", "urxvt -e sh -c 'binwalk ; bash'" },
  { "cstool", "urxvt -e sh -c 'cstool ; bash'" },
  { "dwarf", "urxvt -e sh -c 'dwarf --help ; bash'" },
  { "e2dbg32", "urxvt -e sh -c 'e2dbg32 ; bash'" },
  { "e2dbg64", "urxvt -e sh -c 'e2dbg64 ; bash'" },
  { "etrace32", "urxvt -e sh -c 'etrace32 ; bash'" },
  { "etrace64", "urxvt -e sh -c 'etrace64 ; bash'" },
  { "evarista32", "urxvt -e sh -c 'evarista32 ; bash'" },
  { "evarista64", "urxvt -e sh -c 'evarista64 ; bash'" },
  { "kedbg32", "urxvt -e sh -c 'kedbg32 ; bash'" },
  { "kedbg64", "urxvt -e sh -c 'kedbg64 ; bash'" },
  { "ghidra", "urxvt -e sh -c 'ghidra ; bash'" },
  { "ghidra-analyzeHeadless", "urxvt -e sh -c 'ghidra-analyzeHeadless ; bash'" },
  { "ghidra", "urxvt -e sh -c 'ghidra ; bash'" },
  { "ghidra-analyzeHeadless", "urxvt -e sh -c 'ghidra-analyzeHeadless ; bash'" },
  { "hopper", "urxvt -e sh -c 'hopper ; bash'" },
  { "iaito", "urxvt -e sh -c 'iaito ; bash'" },
  { "inguma", "urxvt -e sh -c 'inguma -h ; bash'" },
  { "ingumagui", "urxvt -e sh -c 'ingumagui ; bash'" },
  { "x86dis", "urxvt -e sh -c 'x86dis ; bash'" },
  { "elf-reader", "urxvt -e sh -c 'elf-reader ; bash'" },
  { "macho-reader", "urxvt -e sh -c 'macho-reader ; bash'" },
  { "pe-reader", "urxvt -e sh -c 'pe-reader ; bash'" },
  { "maltrieve", "urxvt -e sh -c 'maltrieve -h ; bash'" },
  { "maltrievecategorizer", "urxvt -e sh -c 'maltrievecategorizer ; bash'" },
  { "mara-framework", "urxvt -e sh -c 'mara-framework ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "fedora-dirk-ipv6.diff", "urxvt -e sh -c 'fedora-dirk-ipv6.diff ; bash'" },
  { "openssl.Darwin.x86_64", "urxvt -e sh -c 'openssl.Darwin.x86_64 ; bash'" },
  { "openssl.Linux.i686", "urxvt -e sh -c 'openssl.Linux.i686 ; bash'" },
  { "openssl.Linux.x86_64", "urxvt -e sh -c 'openssl.Linux.x86_64 ; bash'" },
  { "marc4dasm", "urxvt -e sh -c 'marc4dasm -h ; bash'" },
  { "plasma-disasm", "urxvt -e sh -c 'plasma-disasm -h ; bash'" },
  { "pwntools-asm", "urxvt -e sh -c 'pwntools-asm -h ; bash'" },
  { "pwntools-checksec", "urxvt -e sh -c 'pwntools-checksec -h ; bash'" },
  { "pwntools-common", "urxvt -e sh -c 'pwntools-common -h ; bash'" },
  { "pwntools-constgrep", "urxvt -e sh -c 'pwntools-constgrep -h ; bash'" },
  { "pwntools-cyclic", "urxvt -e sh -c 'pwntools-cyclic -h ; bash'" },
  { "pwntools-debug", "urxvt -e sh -c 'pwntools-debug ; bash'" },
  { "pwntools-disablenx", "urxvt -e sh -c 'pwntools-disablenx ; bash'" },
  { "pwntools-disasm", "urxvt -e sh -c 'pwntools-disasm -h ; bash'" },
  { "pwntools-elfdiff", "urxvt -e sh -c 'pwntools-elfdiff -h ; bash'" },
  { "pwntools-elfpatch", "urxvt -e sh -c 'pwntools-elfpatch -h ; bash'" },
  { "pwntools-errno", "urxvt -e sh -c 'pwntools-errno -h ; bash'" },
  { "pwntools-hex", "urxvt -e sh -c 'pwntools-hex -h ; bash'" },
  { "pwntools-main", "urxvt -e sh -c 'pwntools-main -h ; bash'" },
  { "pwntools-phd", "urxvt -e sh -c 'pwntools-phd -h ; bash'" },
  { "pwntools-pwn", "urxvt -e sh -c 'pwntools-pwn -h ; bash'" },
  { "pwntools-pwnstrip", "urxvt -e sh -c 'pwntools-pwnstrip -h ; bash'" },
  { "pwntools-scramble", "urxvt -e sh -c 'pwntools-scramble -h ; bash'" },
  { "pwntools-unhex", "urxvt -e sh -c 'pwntools-unhex -h ; bash'" },
  { "pwntools-update", "urxvt -e sh -c 'pwntools-update -h ; bash'" },
  { "version", "urxvt -e sh -c 'version ; bash'" },
  { "pcodedmp", "urxvt -e sh -c 'pcodedmp -h ; bash'" },
  { "pcodedmp2", "urxvt -e sh -c 'pcodedmp2 ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "redasm", "urxvt -e sh -c 'redasm ; bash'" },
  { "scratchabit", "urxvt -e sh -c 'scratchabit -h ; bash'" },
  { "baksmali", "urxvt -e sh -c 'baksmali -h ; bash'" },
  { "smali", "urxvt -e sh -c 'smali -h ; bash'" },
  { "baksmali", "urxvt -e sh -c 'baksmali -h ; bash'" },
  { "smali", "urxvt -e sh -c 'smali -h ; bash'" },
  { "unstrip", "urxvt -e sh -c 'unstrip ; bash'" },
  { "veles", "urxvt -e sh -c 'veles ; bash'" },
  { "viper", "urxvt -e sh -c 'viper -h ; bash'" },
}

dosmenu = {
  { "blacknurse", "urxvt -e sh -c 'blacknurse ; bash'" },
  { "bonesi", "urxvt -e sh -c 'bonesi ; bash'" },
  { "davoset", "urxvt -e sh -c 'davoset ; bash'" },
  { "dhcpig", "urxvt -e sh -c 'dhcpig -h ; bash'" },
  { "dnsdrdos", "urxvt -e sh -c 'dnsdrdos -H ; bash'" },
  { "fhttp", "urxvt -e sh -c 'fhttp -h ; bash'" },
  { "goldeneye", "urxvt -e sh -c 'goldeneye -h ; bash'" },
  { "habu.arp.ping", "urxvt -e sh -c 'habu.arp.ping ; bash'" },
  { "habu.arp.poison", "urxvt -e sh -c 'habu.arp.poison ; bash'" },
  { "habu.arp.sniff", "urxvt -e sh -c 'habu.arp.sniff ; bash'" },
  { "habu.asydns", "urxvt -e sh -c 'habu.asydns ; bash'" },
  { "habu.b64", "urxvt -e sh -c 'habu.b64 ; bash'" },
  { "habu.cert.clone", "urxvt -e sh -c 'habu.cert.clone ; bash'" },
  { "habu.cert.names", "urxvt -e sh -c 'habu.cert.names ; bash'" },
  { "habu.crack.luhn", "urxvt -e sh -c 'habu.crack.luhn ; bash'" },
  { "habu.crack.snmp", "urxvt -e sh -c 'habu.crack.snmp ; bash'" },
  { "habu.crypto.fernet", "urxvt -e sh -c 'habu.crypto.fernet ; bash'" },
  { "habu.crypto.gppref", "urxvt -e sh -c 'habu.crypto.gppref ; bash'" },
  { "habu.crypto.xor", "urxvt -e sh -c 'habu.crypto.xor ; bash'" },
  { "habu.data.enrich", "urxvt -e sh -c 'habu.data.enrich ; bash'" },
  { "habu.data.extract.domain", "urxvt -e sh -c 'habu.data.extract.domain ; bash'" },
  { "habu.data.extract.email", "urxvt -e sh -c 'habu.data.extract.email ; bash'" },
  { "habu.data.extract.fqdn", "urxvt -e sh -c 'habu.data.extract.fqdn ; bash'" },
  { "habu.data.extract.ipv4", "urxvt -e sh -c 'habu.data.extract.ipv4 ; bash'" },
  { "habu.data.filter", "urxvt -e sh -c 'habu.data.filter ; bash'" },
  { "habu.data.select", "urxvt -e sh -c 'habu.data.select ; bash'" },
  { "habu.dhcp.discover", "urxvt -e sh -c 'habu.dhcp.discover ; bash'" },
  { "habu.dhcp.starvation", "urxvt -e sh -c 'habu.dhcp.starvation ; bash'" },
  { "habu.dns.lookup.forward", "urxvt -e sh -c 'habu.dns.lookup.forward ; bash'" },
  { "habu.dns.lookup.reverse", "urxvt -e sh -c 'habu.dns.lookup.reverse ; bash'" },
  { "habu.eicar", "urxvt -e sh -c 'habu.eicar ; bash'" },
  { "habu.forkbomb", "urxvt -e sh -c 'habu.forkbomb ; bash'" },
  { "habu.fqdn.finder", "urxvt -e sh -c 'habu.fqdn.finder ; bash'" },
  { "habu.gateway.find", "urxvt -e sh -c 'habu.gateway.find ; bash'" },
  { "habu.host", "urxvt -e sh -c 'habu.host ; bash'" },
  { "habu.http.headers", "urxvt -e sh -c 'habu.http.headers ; bash'" },
  { "habu.http.options", "urxvt -e sh -c 'habu.http.options ; bash'" },
  { "habu.http.tech", "urxvt -e sh -c 'habu.http.tech ; bash'" },
  { "habu.icmp.ping", "urxvt -e sh -c 'habu.icmp.ping ; bash'" },
  { "habu.ip.asn", "urxvt -e sh -c 'habu.ip.asn ; bash'" },
  { "habu.ip.geolocation", "urxvt -e sh -c 'habu.ip.geolocation ; bash'" },
  { "habu.ip.internal", "urxvt -e sh -c 'habu.ip.internal ; bash'" },
  { "habu.ip.public", "urxvt -e sh -c 'habu.ip.public ; bash'" },
  { "habu.karma", "urxvt -e sh -c 'habu.karma ; bash'" },
  { "habu.karma.bulk", "urxvt -e sh -c 'habu.karma.bulk ; bash'" },
  { "habu.land", "urxvt -e sh -c 'habu.land ; bash'" },
  { "habu.nc", "urxvt -e sh -c 'habu.nc ; bash'" },
  { "habu.net.contest", "urxvt -e sh -c 'habu.net.contest ; bash'" },
  { "habu.net.interfaces", "urxvt -e sh -c 'habu.net.interfaces ; bash'" },
  { "habu.nmap.excluded", "urxvt -e sh -c 'habu.nmap.excluded ; bash'" },
  { "habu.nmap.open", "urxvt -e sh -c 'habu.nmap.open ; bash'" },
  { "habu.nmap.ports", "urxvt -e sh -c 'habu.nmap.ports ; bash'" },
  { "habu.protoscan", "urxvt -e sh -c 'habu.protoscan ; bash'" },
  { "habu.server.ftp", "urxvt -e sh -c 'habu.server.ftp ; bash'" },
  { "habu.tcp.flags", "urxvt -e sh -c 'habu.tcp.flags ; bash'" },
  { "habu.tcp.isn", "urxvt -e sh -c 'habu.tcp.isn ; bash'" },
  { "habu.tcp.scan", "urxvt -e sh -c 'habu.tcp.scan ; bash'" },
  { "habu.tcp.synflood", "urxvt -e sh -c 'habu.tcp.synflood ; bash'" },
  { "habu.traceroute", "urxvt -e sh -c 'habu.traceroute ; bash'" },
  { "habu.upgrade", "urxvt -e sh -c 'habu.upgrade ; bash'" },
  { "habu.usercheck", "urxvt -e sh -c 'habu.usercheck ; bash'" },
  { "habu.version", "urxvt -e sh -c 'habu.version ; bash'" },
  { "habu.vhosts", "urxvt -e sh -c 'habu.vhosts ; bash'" },
  { "habu.virustotal", "urxvt -e sh -c 'habu.virustotal ; bash'" },
  { "habu.web.report", "urxvt -e sh -c 'habu.web.report ; bash'" },
  { "habu.whois.domain", "urxvt -e sh -c 'habu.whois.domain ; bash'" },
  { "habu.whois.ip", "urxvt -e sh -c 'habu.whois.ip ; bash'" },
  { "hulk", "urxvt -e sh -c 'hulk -h ; bash'" },
  { "hawk", "urxvt -e sh -c 'hawk --help ; bash'" },
  { "hwk-eagle", "urxvt -e sh -c 'hwk-eagle --help ; bash'" },
  { "hyde", "urxvt -e sh -c 'hyde ; bash'" },
  { "iaxflood", "urxvt -e sh -c 'iaxflood ; bash'" },
  { "impulse", "urxvt -e sh -c 'impulse -h ; bash'" },
  { "inviteflood", "urxvt -e sh -c 'inviteflood -h ; bash'" },
  { "isip", "urxvt -e sh -c 'isip ; bash'" },
  { "katana-ktf.gui", "urxvt -e sh -c 'katana-ktf.gui ; bash'" },
  { "katana-ktfconsole", "urxvt -e sh -c 'katana-ktfconsole ; bash'" },
  { "katana-ktfktf", "urxvt -e sh -c 'katana-ktfktf ; bash'" },
  { "katana-ktflinker", "urxvt -e sh -c 'katana-ktflinker ; bash'" },
  { "katana-ktfrun", "urxvt -e sh -c 'katana-ktfrun ; bash'" },
  { "katana-ktfupdate", "urxvt -e sh -c 'katana-ktfupdate ; bash'" },
  { "mz", "urxvt -e sh -c 'mz -h ; bash'" },
  { "nkiller2", "urxvt -e sh -c 'nkiller2 -h ; bash'" },
  { "ntpdos", "urxvt -e sh -c 'ntpdos ; bash'" },
  { "pwnloris", "urxvt -e sh -c 'pwnloris -h ; bash'" },
  { "pyersinia", "urxvt -e sh -c 'pyersinia -h ; bash'" },
  { "rspet-client", "urxvt -e sh -c 'rspet-client ; bash'" },
  { "rspet-server", "urxvt -e sh -c 'rspet-server ; bash'" },
  { "shitflood", "urxvt -e sh -c 'shitflood ; bash'" },
  { "bombardment", "urxvt -e sh -c 'bombardment ; bash'" },
  { "siege", "urxvt -e sh -c 'siege -h ; bash'" },
  { "bombardment", "urxvt -e sh -c 'bombardment ; bash'" },
  { "siege", "urxvt -e sh -c 'siege -h ; bash'" },
  { "slowhttptest", "urxvt -e sh -c 'slowhttptest -h ; bash'" },
  { "slowloris", "urxvt -e sh -c 'slowloris ; bash'" },
  { "smod", "urxvt -e sh -c 'smod ; bash'" },
  { "synflood", "urxvt -e sh -c 'synflood -h ; bash'" },
  { "synner", "urxvt -e sh -c 'synner -h ; bash'" },
  { "t50", "urxvt -e sh -c 't50 --help ; bash'" },
  { "get_mem_dump", "urxvt -e sh -c 'get_mem_dump ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "thc-ssl-dos", "urxvt -e sh -c 'thc-ssl-dos -h ; bash'" },
  { "ufonet", "urxvt -e sh -c 'ufonet -h ; bash'" },
  { "captiveflask", "urxvt -e sh -c 'captiveflask ; bash'" },
  { "sslstrip3", "urxvt -e sh -c 'sslstrip3 ; bash'" },
  { "wifi-pumpkin", "urxvt -e sh -c 'wifi-pumpkin ; bash'" },
  { "wreckuests", "urxvt -e sh -c 'wreckuests -h ; bash'" },
  { "zizzania", "urxvt -e sh -c 'zizzania ; bash'" },
}

dronemenu = {
  { "crozono", "urxvt -e sh -c 'crozono -h ; bash'" },
  { "skyjack", "urxvt -e sh -c 'skyjack --help ; bash'" },
}

exploitationmenu = {
  { "aclpwn", "urxvt -e sh -c 'aclpwn -h ; bash'" },
  { "aggroargs", "urxvt -e sh -c 'aggroargs -h ; bash'" },
  { "armitage", "urxvt -e sh -c 'armitage -h ; bash'" },
  { "teamserver", "urxvt -e sh -c 'teamserver ; bash'" },
  { "armor", "urxvt -e sh -c 'armor ; bash'" },
  { "armscgen", "urxvt -e sh -c 'armscgen -h ; bash'" },
  { "arpoison", "urxvt -e sh -c 'arpoison -h ; bash'" },
  { "atscan", "urxvt -e sh -c 'atscan ; bash'" },
  { "backoori", "urxvt -e sh -c 'backoori -h ; bash'" },
  { "bad-pdf", "urxvt -e sh -c 'bad-pdf ; bash'" },
  { "barq", "urxvt -e sh -c 'barq -h ; bash'" },
  { "bbqsql", "urxvt -e sh -c 'bbqsql -h ; bash'" },
  { "bed", "urxvt -e sh -c 'bed -h ; bash'" },
  { "beef", "urxvt -e sh -c 'beef -h ; bash'" },
  { "bfbtester", "urxvt -e sh -c 'bfbtester -h ; bash'" },
  { "binex", "urxvt -e sh -c 'binex -h ; bash'" },
  { "bitdump", "urxvt -e sh -c 'bitdump -h ; bash'" },
  { "botb", "urxvt -e sh -c 'botb -h ; bash'" },
  { "connectbackserver", "urxvt -e sh -c 'connectbackserver ; bash'" },
  { "trojanserver", "urxvt -e sh -c 'trojanserver -h ; bash'" },
  { "brakeman", "urxvt -e sh -c 'brakeman ; bash'" },
  { "bros", "urxvt -e sh -c 'bros --help ; bash'" },
  { "bsqlinjector", "urxvt -e sh -c 'bsqlinjector -h ; bash'" },
  { "camover", "urxvt -e sh -c 'camover -h ; bash'" },
  { "chankro", "urxvt -e sh -c 'chankro -h ; bash'" },
  { "chiron-attacks", "urxvt -e sh -c 'chiron-attacks ; bash'" },
  { "chiron-local-link", "urxvt -e sh -c 'chiron-local-link ; bash'" },
  { "chiron-nd", "urxvt -e sh -c 'chiron-nd ; bash'" },
  { "chiron-proxy", "urxvt -e sh -c 'chiron-proxy ; bash'" },
  { "chiron-scanner", "urxvt -e sh -c 'chiron-scanner ; bash'" },
  { "cisco-snmp-enumeration", "urxvt -e sh -c 'cisco-snmp-enumeration ; bash'" },
  { "cisco-snmp-slap", "urxvt -e sh -c 'cisco-snmp-slap -h ; bash'" },
  { "cisco-torch", "urxvt -e sh -c 'cisco-torch -h ; bash'" },
  { "cmseek", "urxvt -e sh -c 'cmseek ; bash'" },
  { "cmsmap", "urxvt -e sh -c 'cmsmap -h ; bash'" },
  { "commix", "urxvt -e sh -c 'commix ; bash'" },
  { "crabstick", "urxvt -e sh -c 'crabstick -h ; bash'" },
  { "cme", "urxvt -e sh -c 'cme ; bash'" },
  { "cmedb", "urxvt -e sh -c 'cmedb ; bash'" },
  { "creak", "urxvt -e sh -c 'creak -h ; bash'" },
  { "cve-search-__init__", "urxvt -e sh -c 'cve-search-__init__ ; bash'" },
  { "cve-search-cve_doc", "urxvt -e sh -c 'cve-search-cve_doc -h ; bash'" },
  { "cve-search-cve_refs", "urxvt -e sh -c 'cve-search-cve_refs -h ; bash'" },
  { "cve-search-db_blacklist", "urxvt -e sh -c 'cve-search-db_blacklist -h ; bash'" },
  { "cve-search-db_cpe_browser", "urxvt -e sh -c 'cve-search-db_cpe_browser -h ; bash'" },
  { "cve-search-db_dump", "urxvt -e sh -c 'cve-search-db_dump -h ; bash'" },
  { "cve-search-db_fulltext", "urxvt -e sh -c 'cve-search-db_fulltext -h ; bash'" },
  { "cve-search-db_mgmt_admin", "urxvt -e sh -c 'cve-search-db_mgmt_admin -h ; bash'" },
  { "cve-search-db_mgmt_capec", "urxvt -e sh -c 'cve-search-db_mgmt_capec -h ; bash'" },
  { "cve-search-db_mgmt_cpe_dictionary", "urxvt -e sh -c 'cve-search-db_mgmt_cpe_dictionary -h ; bash'" },
  { "cve-search-db_mgmt_cpe_other_dictionary", "urxvt -e sh -c 'cve-search-db_mgmt_cpe_other_dictionary -h ; bash'" },
  { "cve-search-db_mgmt_cwe", "urxvt -e sh -c 'cve-search-db_mgmt_cwe -h ; bash'" },
  { "cve-search-db_mgmt_ref", "urxvt -e sh -c 'cve-search-db_mgmt_ref -h ; bash'" },
  { "cve-search-db_notification", "urxvt -e sh -c 'cve-search-db_notification -h ; bash'" },
  { "cve-search-db_ranking", "urxvt -e sh -c 'cve-search-db_ranking -h ; bash'" },
  { "cve-search-db_updater", "urxvt -e sh -c 'cve-search-db_updater -h ; bash'" },
  { "cve-search-db_whitelist", "urxvt -e sh -c 'cve-search-db_whitelist -h ; bash'" },
  { "cve-search-dump_last", "urxvt -e sh -c 'cve-search-dump_last -h ; bash'" },
  { "cve-search-search", "urxvt -e sh -c 'cve-search-search -h ; bash'" },
  { "cve-search-search_cpe", "urxvt -e sh -c 'cve-search-search_cpe -h ; bash'" },
  { "cve-search-search_fulltext", "urxvt -e sh -c 'cve-search-search_fulltext -h ; bash'" },
  { "cve-search-search_irc", "urxvt -e sh -c 'cve-search-search_irc -h ; bash'" },
  { "cve-search-search_xmpp", "urxvt -e sh -c 'cve-search-search_xmpp -h ; bash'" },
  { "darkd0rk3r", "urxvt -e sh -c 'darkd0rk3r ; rm -rf darkd0rk3r-*.txt ; bash'" },
  { "darkmysqli", "urxvt -e sh -c 'darkmysqli -h ; bash'" },
  { "darkspiritz", "urxvt -e sh -c 'darkspiritz -h ; bash'" },
  { "deathstar", "urxvt -e sh -c 'deathstar -h ; bash'" },
  { "deepce", "urxvt -e sh -c 'deepce -h ; bash'" },
  { "delorean", "urxvt -e sh -c 'delorean -h ; bash'" },
  { "dkmc", "urxvt -e sh -c 'dkmc ; bash'" },
  { "donut", "urxvt -e sh -c 'donut -h ; bash'" },
  { "doona", "urxvt -e sh -c 'doona -h ; bash'" },
  { "dotdotpwn", "urxvt -e sh -c 'dotdotpwn -h ; bash'" },
  { "drinkme", "urxvt -e sh -c 'drinkme -h ; bash'" },
  { "drupwn", "urxvt -e sh -c 'drupwn -h ; bash'" },
  { "bunnyducky", "urxvt -e sh -c 'bunnyducky -h ; bash'" },
  { "ducktools", "urxvt -e sh -c 'ducktools -h ; bash'" },
  { "dwarf", "urxvt -e sh -c 'dwarf --help ; bash'" },
  { "enteletaor", "urxvt -e sh -c 'enteletaor ; bash'" },
  { "bin-seeds", "urxvt -e sh -c 'bin-seeds ; bash'" },
  { "bruteforce-erldp", "urxvt -e sh -c 'bruteforce-erldp ; bash'" },
  { "crack-prng", "urxvt -e sh -c 'crack-prng ; bash'" },
  { "dictionary-erldp", "urxvt -e sh -c 'dictionary-erldp -h ; bash'" },
  { "erldp-proxy", "urxvt -e sh -c 'erldp-proxy -h ; bash'" },
  { "shell-erldp", "urxvt -e sh -c 'shell-erldp -h ; bash'" },
  { "sweep-default-cookie", "urxvt -e sh -c 'sweep-default-cookie -h ; bash'" },
  { "elog", "urxvt -e sh -c 'elog ; bash'" },
  { "escan", "urxvt -e sh -c 'escan -h ; bash'" },
  { "evil-winrm", "urxvt -e sh -c 'evil-winrm -h ; bash'" },
  { "eyepwn", "urxvt -e sh -c 'eyepwn ; bash'" },
  { "faraday-manage", "urxvt -e sh -c 'faraday-manage ; bash'" },
  { "faraday-searcher", "urxvt -e sh -c 'faraday-searcher ; bash'" },
  { "faraday-server", "urxvt -e sh -c 'faraday-server ; bash'" },
  { "ffm", "urxvt -e sh -c 'ffm -h ; bash'" },
  { "fimap", "urxvt -e sh -c 'fimap -h ; bash'" },
  { "firstorder", "urxvt -e sh -c 'firstorder -h ; bash'" },
  { "fs-nyarl", "urxvt -e sh -c 'fs-nyarl -h ; bash'" },
  { "chaosreader0.94", "urxvt -e sh -c 'chaosreader0.94 ; bash'" },
  { "fuzzbunch", "urxvt -e sh -c 'fuzzbunch -h ; bash'" },
  { "gcat", "urxvt -e sh -c 'gcat --help ; bash'" },
  { "ghostdelivery", "urxvt -e sh -c 'ghostdelivery ; bash'" },
  { "gloom", "urxvt -e sh -c 'gloom ; bash'" },
  { "gopherus", "urxvt -e sh -c 'gopherus ; bash'" },
  { "graphql-path-enum", "urxvt -e sh -c 'graphql-path-enum -h ; bash'" },
  { "graphqlmap", "urxvt -e sh -c 'graphqlmap -h ; bash'" },
  { "gsad", "urxvt -e sh -c 'gsad -h ; bash'" },
  { "database-statistics-sqlite", "urxvt -e sh -c 'database-statistics-sqlite ; bash'" },
  { "greenbone-certdata-sync", "urxvt -e sh -c 'greenbone-certdata-sync -h ; bash'" },
  { "greenbone-scapdata-sync", "urxvt -e sh -c 'greenbone-scapdata-sync -h ; bash'" },
  { "gvm-manage-certs", "urxvt -e sh -c 'gvm-manage-certs ; bash'" },
  { "gvm-migrate-to-postgres", "urxvt -e sh -c 'gvm-migrate-to-postgres ; bash'" },
  { "gvm-portnames-update", "urxvt -e sh -c 'gvm-portnames-update ; bash'" },
  { "hackredis", "urxvt -e sh -c 'hackredis -h ; bash'" },
  { "hakku", "urxvt -e sh -c 'hakku ; bash'" },
  { "ferret", "urxvt -e sh -c 'ferret ; bash'" },
  { "hamster-http", "urxvt -e sh -c 'hamster-http -h ; bash'" },
  { "hcraft", "urxvt -e sh -c 'hcraft ; bash'" },
  { "heartleech", "urxvt -e sh -c 'heartleech -h ; bash'" },
  { "homepwn", "urxvt -e sh -c 'homepwn -h ; bash'" },
  { "hqlmap", "urxvt -e sh -c 'hqlmap -h ; bash'" },
  { "incept", "urxvt -e sh -c 'incept ; bash'" },
  { "inguma", "urxvt -e sh -c 'inguma -h ; bash'" },
  { "ingumagui", "urxvt -e sh -c 'ingumagui ; bash'" },
  { "insanity", "urxvt -e sh -c 'insanity -h ; bash'" },
  { "irpas-ass", "urxvt -e sh -c 'irpas-ass ; bash'" },
  { "irpas-cdp", "urxvt -e sh -c 'irpas-cdp ; bash'" },
  { "irpas-dfkaa", "urxvt -e sh -c 'irpas-dfkaa ; bash'" },
  { "irpas-dhcpx", "urxvt -e sh -c 'irpas-dhcpx ; bash'" },
  { "irpas-file2cable", "urxvt -e sh -c 'irpas-file2cable ; bash'" },
  { "irpas-hsrp", "urxvt -e sh -c 'irpas-hsrp ; bash'" },
  { "irpas-icmp_redirect", "urxvt -e sh -c 'irpas-icmp_redirect ; bash'" },
  { "irpas-igrp", "urxvt -e sh -c 'irpas-igrp ; bash'" },
  { "irpas-irdp", "urxvt -e sh -c 'irpas-irdp ; bash'" },
  { "irpas-irdpresponder", "urxvt -e sh -c 'irpas-irdpresponder ; bash'" },
  { "irpas-itrace", "urxvt -e sh -c 'irpas-itrace ; bash'" },
  { "irpas-netenum", "urxvt -e sh -c 'irpas-netenum ; bash'" },
  { "irpas-netmask", "urxvt -e sh -c 'irpas-netmask ; bash'" },
  { "irpas-protos", "urxvt -e sh -c 'irpas-protos ; bash'" },
  { "irpas-tctrace", "urxvt -e sh -c 'irpas-tctrace ; bash'" },
  { "irpas-timestamp", "urxvt -e sh -c 'irpas-timestamp ; bash'" },
  { "isf", "urxvt -e sh -c 'isf -h ; bash'" },
  { "jaidam", "urxvt -e sh -c 'jaidam ; bash'" },
  { "unix-jboss-autopwn", "urxvt -e sh -c 'unix-jboss-autopwn ; bash'" },
  { "win-jboss-autopwn", "urxvt -e sh -c 'win-jboss-autopwn ; bash'" },
  { "jexboss", "urxvt -e sh -c 'jexboss -h ; bash'" },
  { "jsql-injection", "urxvt -e sh -c 'jsql-injection ; bash'" },
  { "k55", "urxvt -e sh -c 'k55 -h ; bash'" },
  { "kadimus", "urxvt -e sh -c 'kadimus -h ; bash'" },
  { "katana-ktf.gui", "urxvt -e sh -c 'katana-ktf.gui ; bash'" },
  { "katana-ktfconsole", "urxvt -e sh -c 'katana-ktfconsole ; bash'" },
  { "katana-ktfktf", "urxvt -e sh -c 'katana-ktfktf ; bash'" },
  { "katana-ktflinker", "urxvt -e sh -c 'katana-ktflinker ; bash'" },
  { "katana-ktfrun", "urxvt -e sh -c 'katana-ktfrun ; bash'" },
  { "katana-ktfupdate", "urxvt -e sh -c 'katana-ktfupdate ; bash'" },
  { "kernelpop", "urxvt -e sh -c 'kernelpop -h ; bash'" },
  { "killcast", "urxvt -e sh -c 'killcast -h ; bash'" },
  { "kbbootloader", "urxvt -e sh -c 'kbbootloader -h ; bash'" },
  { "zbassocflood", "urxvt -e sh -c 'zbassocflood -h ; bash'" },
  { "zbcat", "urxvt -e sh -c 'zbcat -h ; bash'" },
  { "zbconvert", "urxvt -e sh -c 'zbconvert -h ; bash'" },
  { "zbdsniff", "urxvt -e sh -c 'zbdsniff -h ; bash'" },
  { "zbdump", "urxvt -e sh -c 'zbdump -h ; bash'" },
  { "zbfakebeacon", "urxvt -e sh -c 'zbfakebeacon -h ; bash'" },
  { "zbgoodfind", "urxvt -e sh -c 'zbgoodfind -h ; bash'" },
  { "zbid", "urxvt -e sh -c 'zbid -h ; bash'" },
  { "zbjammer", "urxvt -e sh -c 'zbjammer -h ; bash'" },
  { "zbopenear", "urxvt -e sh -c 'zbopenear -h ; bash'" },
  { "zborphannotify", "urxvt -e sh -c 'zborphannotify -h ; bash'" },
  { "zbrealign", "urxvt -e sh -c 'zbrealign -h ; bash'" },
  { "zbstumbler", "urxvt -e sh -c 'zbstumbler -h ; bash'" },
  { "zbwardrive", "urxvt -e sh -c 'zbwardrive -h ; bash'" },
  { "klar", "urxvt -e sh -c 'klar -h ; bash'" },
  { "koadic", "urxvt -e sh -c 'koadic ; bash'" },
  { "dynwrapx.manifest", "urxvt -e sh -c 'dynwrapx.manifest ; bash'" },
  { "kwetza", "urxvt -e sh -c 'kwetza --help ; bash'" },
  { "l0l", "urxvt -e sh -c 'l0l ; bash'" },
  { "leroy-jenkins", "urxvt -e sh -c 'leroy-jenkins ; bash'" },
  { "lethalhta", "urxvt -e sh -c 'lethalhta -h ; bash'" },
  { "leviathan", "urxvt -e sh -c 'leviathan ; bash'" },
  { "lfi-autopwn", "urxvt -e sh -c 'lfi-autopwn ; bash'" },
  { "lfifreak", "urxvt -e sh -c 'lfifreak ; bash'" },
  { "lfisuite", "urxvt -e sh -c 'lfisuite ; bash'" },
  { "libc-add", "urxvt -e sh -c 'libc-add -h ; bash'" },
  { "libc-download", "urxvt -e sh -c 'libc-download -h ; bash'" },
  { "libc-dump", "urxvt -e sh -c 'libc-dump -h ; bash'" },
  { "libc-find", "urxvt -e sh -c 'libc-find -h ; bash'" },
  { "libc-get", "urxvt -e sh -c 'libc-get -h ; bash'" },
  { "libc-identify", "urxvt -e sh -c 'libc-identify -h ; bash'" },
  { "liffy", "urxvt -e sh -c 'liffy -h ; bash'" },
  { "limelighter", "urxvt -e sh -c 'limelighter -h ; bash'" },
  { "m3-gen", "urxvt -e sh -c 'm3-gen -h ; bash'" },
  { "maligno-clientgen", "urxvt -e sh -c 'maligno-clientgen ; bash'" },
  { "maligno-srv", "urxvt -e sh -c 'maligno-srv ; bash'" },
  { "mando.me", "urxvt -e sh -c 'mando.me -h ; bash'" },
  { "massexpconsole", "urxvt -e sh -c 'massexpconsole ; bash'" },
  { "mdk3", "urxvt -e sh -c 'mdk3 --help ; bash'" },
  { "mdk4", "urxvt -e sh -c 'mdk4 --help ; bash'" },
  { "merlin-server", "urxvt -e sh -c 'merlin-server -h ; bash'" },
  { "msf-ws.ru", "urxvt -e sh -c 'msf-ws.ru ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfdb", "urxvt -e sh -c 'msfdb ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfelfscan", "urxvt -e sh -c 'msfelfscan -h ; bash'" },
  { "msfmachscan", "urxvt -e sh -c 'msfmachscan -h ; bash'" },
  { "msfpescan", "urxvt -e sh -c 'msfpescan -h ; bash'" },
  { "msfrop", "urxvt -e sh -c 'msfrop -h ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfupdate", "urxvt -e sh -c 'msfupdate -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "expressInstall.swf", "urxvt -e sh -c 'expressInstall.swf ; bash'" },
  { "stty", "urxvt -e sh -c 'stty ; bash'" },
  { "minimysqlator", "urxvt -e sh -c 'minimysqlator ; bash'" },
  { "miranda", "urxvt -e sh -c 'miranda ; bash'" },
  { "mitmap-old", "urxvt -e sh -c 'mitmap-old -h ; bash'" },
  { "mitmf", "urxvt -e sh -c 'mitmf -h ; bash'" },
  { "mitmproxy", "urxvt -e sh -c 'mitmproxy -h ; bash'" },
  { "mitmweb", "urxvt -e sh -c 'mitmweb ; bash'" },
  { "mitmproxy", "urxvt -e sh -c 'mitmproxy -h ; bash'" },
  { "mitmweb", "urxvt -e sh -c 'mitmweb ; bash'" },
  { "mosquito", "urxvt -e sh -c 'mosquito ; bash'" },
  { "msfenum", "urxvt -e sh -c 'msfenum -h ; bash'" },
  { "myjwt", "urxvt -e sh -c 'myjwt -h ; bash'" },
  { "n1qlmap", "urxvt -e sh -c 'n1qlmap ; bash'" },
  { "nimbostratus", "urxvt -e sh -c 'nimbostratus -h ; bash'" },
  { "nosqli", "urxvt -e sh -c 'nosqli -h ; bash'" },
  { "nosqli-user-pass-enum", "urxvt -e sh -c 'nosqli-user-pass-enum -h ; bash'" },
  { "nosqlmap", "urxvt -e sh -c 'nosqlmap ; bash'" },
  { "ntlm-theft", "urxvt -e sh -c 'ntlm-theft -h ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "office-dde-payloads-excel", "urxvt -e sh -c 'office-dde-payloads-excel -h ; bash'" },
  { "office-dde-payloads-word", "urxvt -e sh -c 'office-dde-payloads-word -h ; bash'" },
  { "opensvp", "urxvt -e sh -c 'opensvp -h ; bash'" },
  { "greenbone-nvt-sync", "urxvt -e sh -c 'greenbone-nvt-sync -h ; bash'" },
  { "openvas-nasl", "urxvt -e sh -c 'openvas-nasl ; bash'" },
  { "openvas-nasl-lint", "urxvt -e sh -c 'openvas-nasl-lint ; bash'" },
  { "openvassd", "urxvt -e sh -c 'openvassd -h ; bash'" },
  { "osueta", "urxvt -e sh -c 'osueta -h ; bash'" },
  { "otori", "urxvt -e sh -c 'otori -h ; bash'" },
  { "owasp-zsc", "urxvt -e sh -c 'owasp-zsc ; bash'" },
  { "pacu", "urxvt -e sh -c 'pacu ; bash'" },
  { "padbuster", "urxvt -e sh -c 'padbuster -h ; bash'" },
  { "pastejacker", "urxvt -e sh -c 'pastejacker ; bash'" },
  { "pathzuzu", "urxvt -e sh -c 'pathzuzu ; bash'" },
  { "pblind", "urxvt -e sh -c 'pblind ; bash'" },
  { "phantom-evasion", "urxvt -e sh -c 'phantom-evasion -h ; bash'" },
  { "phpggc", "urxvt -e sh -c 'phpggc -h ; bash'" },
  { "pirana", "urxvt -e sh -c 'pirana -h ; bash'" },
  { "pmcma", "urxvt -e sh -c 'pmcma ; bash'" },
  { "pcs-attack", "urxvt -e sh -c 'pcs-attack ; bash'" },
  { "pcs-console", "urxvt -e sh -c 'pcs-console ; bash'" },
  { "pcs-verify", "urxvt -e sh -c 'pcs-verify ; bash'" },
  { "pocsuite", "urxvt -e sh -c 'pocsuite -h ; bash'" },
  { "postenum", "urxvt -e sh -c 'postenum -h ; bash'" },
  { "pret", "urxvt -e sh -c 'pret -h ; bash'" },
  { "ps1encode", "urxvt -e sh -c 'ps1encode -h ; bash'" },
  { "ptf", "urxvt -e sh -c 'ptf ; bash'" },
  { "punk", "urxvt -e sh -c 'punk -h ; bash'" },
  { "pwndrop", "urxvt -e sh -c 'pwndrop -h ; bash'" },
  { "pyersinia", "urxvt -e sh -c 'pyersinia -h ; bash'" },
  { "pykek", "urxvt -e sh -c 'pykek ; bash'" },
  { "ROPgadget2", "urxvt -e sh -c 'ROPgadget2 ; bash'" },
  { "qark", "urxvt -e sh -c 'qark ; bash'" },
  { "rapidscan", "urxvt -e sh -c 'rapidscan ; bash'" },
  { "remot3d", "urxvt -e sh -c 'remot3d ; bash'" },
  { "rext", "urxvt -e sh -c 'rext ; bash'" },
  { "rfcat", "urxvt -e sh -c 'rfcat -h ; bash'" },
  { "rfcat_bootloader", "urxvt -e sh -c 'rfcat_bootloader ; bash'" },
  { "rfcat_msfrelay", "urxvt -e sh -c 'rfcat_msfrelay ; bash'" },
  { "rfcat_server", "urxvt -e sh -c 'rfcat_server ; bash'" },
  { "rombuster", "urxvt -e sh -c 'rombuster -h ; bash'" },
  { "ROPgadget", "urxvt -e sh -c 'ROPgadget ; bash'" },
  { "ropper", "urxvt -e sh -c 'ropper ; bash'" },
  { "roputils", "urxvt -e sh -c 'roputils ; bash'" },
  { "rsf", "urxvt -e sh -c 'rsf ; bash'" },
  { "rp-lin-x64", "urxvt -e sh -c 'rp-lin-x64 -h ; bash'" },
  { "rspet-client", "urxvt -e sh -c 'rspet-client ; bash'" },
  { "rspet-server", "urxvt -e sh -c 'rspet-server ; bash'" },
  { "ruler", "urxvt -e sh -c 'ruler -h ; bash'" },
  { "rupture", "urxvt -e sh -c 'rupture -h ; bash'" },
  { "sc-make", "urxvt -e sh -c 'sc-make ; bash'" },
  { "search1337", "urxvt -e sh -c 'search1337 ; bash'" },
  { "sensepost-xrdp", "urxvt -e sh -c 'sensepost-xrdp -h ; bash'" },
  { "serialbrute", "urxvt -e sh -c 'serialbrute -h ; bash'" },
  { "setoolkit", "urxvt -e sh -c 'setoolkit ; bash'" },
  { "shad0w", "urxvt -e sh -c 'shad0w -h ; bash'" },
  { "donut.elf", "urxvt -e sh -c 'donut.elf ; bash'" },
  { "shellcode-compiler-x64", "urxvt -e sh -c 'shellcode-compiler-x64 -h ; bash'" },
  { "shellcode-compiler-x86", "urxvt -e sh -c 'shellcode-compiler-x86 -h ; bash'" },
  { "shellen", "urxvt -e sh -c 'shellen ; bash'" },
  { "shellme", "urxvt -e sh -c 'shellme -h ; bash'" },
  { "shellnoob", "urxvt -e sh -c 'shellnoob -h ; bash'" },
  { "shellter", "urxvt -e sh -c 'shellter ; bash'" },
  { "shocker", "urxvt -e sh -c 'shocker -h ; bash'" },
  { "sickle", "urxvt -e sh -c 'sickle -h ; bash'" },
  { "sigthief", "urxvt -e sh -c 'sigthief -h ; bash'" },
  { "sipvicious-svcrack", "urxvt -e sh -c 'sipvicious-svcrack -h ; bash'" },
  { "sipvicious-svmap", "urxvt -e sh -c 'sipvicious-svmap -h ; bash'" },
  { "sipvicious-svreport", "urxvt -e sh -c 'sipvicious-svreport -h ; bash'" },
  { "sipvicious-svwar", "urxvt -e sh -c 'sipvicious-svwar -h ; bash'" },
  { "sireprat", "urxvt -e sh -c 'sireprat -h ; bash'" },
  { "sjet", "urxvt -e sh -c 'sjet -h ; bash'" },
  { "slither", "urxvt -e sh -c 'slither -h ; bash'" },
  { "slither-check-erc", "urxvt -e sh -c 'slither-check-erc ; bash'" },
  { "slither-check-kspec", "urxvt -e sh -c 'slither-check-kspec ; bash'" },
  { "slither-check-upgradeability", "urxvt -e sh -c 'slither-check-upgradeability ; bash'" },
  { "slither-find-paths", "urxvt -e sh -c 'slither-find-paths ; bash'" },
  { "slither-flat", "urxvt -e sh -c 'slither-flat ; bash'" },
  { "slither-format", "urxvt -e sh -c 'slither-format ; bash'" },
  { "slither-mutate", "urxvt -e sh -c 'slither-mutate ; bash'" },
  { "slither-simil", "urxvt -e sh -c 'slither-simil ; bash'" },
  { "smap", "urxvt -e sh -c 'smap -h ; bash'" },
  { "smikims-cage", "urxvt -e sh -c 'smikims-cage ; bash'" },
  { "smikims-sweep", "urxvt -e sh -c 'smikims-sweep ; bash'" },
  { "smtptester", "urxvt -e sh -c 'smtptester -h ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "snarf-mitm", "urxvt -e sh -c 'snarf-mitm ; bash'" },
  { "express", "urxvt -e sh -c 'express ; bash'" },
  { "marked", "urxvt -e sh -c 'marked ; bash'" },
  { "spookflare", "urxvt -e sh -c 'spookflare ; bash'" },
  { "spraykatz", "urxvt -e sh -c 'spraykatz -h ; bash'" },
  { "sqlmap", "urxvt -e sh -c 'sqlmap -hh ; bash'" },
  { "sqlmapapi", "urxvt -e sh -c 'sqlmapapi ; bash'" },
  { "sqlmap", "urxvt -e sh -c 'sqlmap -hh ; bash'" },
  { "sqlmapapi", "urxvt -e sh -c 'sqlmapapi ; bash'" },
  { "sqlninja", "urxvt -e sh -c 'sqlninja -h ; bash'" },
  { "sqlsus", "urxvt -e sh -c 'sqlsus -h ; bash'" },
  { "sslstrip", "urxvt -e sh -c 'sslstrip -h ; bash'" },
  { "ssrfmap", "urxvt -e sh -c 'ssrfmap -h ; bash'" },
  { "stackflow", "urxvt -e sh -c 'stackflow -h ; bash'" },
  { "subterfuge", "urxvt -e sh -c 'subterfuge ; bash'" },
  { "suid3num", "urxvt -e sh -c 'suid3num -h ; bash'" },
  { "swarm", "urxvt -e sh -c 'swarm -h ; bash'" },
  { "easywin", "urxvt -e sh -c 'easywin -h ; bash'" },
  { "letmein", "urxvt -e sh -c 'letmein -h ; bash'" },
  { "netdork", "urxvt -e sh -c 'netdork -h ; bash'" },
  { "poriluk", "urxvt -e sh -c 'poriluk -h ; bash'" },
  { "seitan", "urxvt -e sh -c 'seitan -h ; bash'" },
  { "tcpjunk", "urxvt -e sh -c 'tcpjunk -h ; bash'" },
  { "thefatrat", "urxvt -e sh -c 'thefatrat cd /usr/share/thefatrat ; ls ; bash'" },
  { "unibrute", "urxvt -e sh -c 'unibrute ; bash'" },
  { "veil", "urxvt -e sh -c 'veil ; bash'" },
  { "venom-admin", "urxvt -e sh -c 'venom-admin ; bash'" },
  { "venom-agent", "urxvt -e sh -c 'venom-agent ; bash'" },
  { "vmap", "urxvt -e sh -c 'vmap ; bash'" },
  { "vnc-bypauth", "urxvt -e sh -c 'vnc-bypauth ; bash'" },
  { "wesng", "urxvt -e sh -c 'wesng -h ; bash'" },
  { "captiveflask", "urxvt -e sh -c 'captiveflask ; bash'" },
  { "sslstrip3", "urxvt -e sh -c 'sslstrip3 ; bash'" },
  { "wifi-pumpkin", "urxvt -e sh -c 'wifi-pumpkin ; bash'" },
  { "wildpwn", "urxvt -e sh -c 'wildpwn -h ; bash'" },
  { "witchxtool", "urxvt -e sh -c 'witchxtool -h ; bash'" },
  { "wpxf", "urxvt -e sh -c 'wpxf ; bash'" },
  { "wpforce", "urxvt -e sh -c 'wpforce -h ; bash'" },
  { "wpforce-yertle", "urxvt -e sh -c 'wpforce-yertle -h ; bash'" },
  { "wsuspect-proxy", "urxvt -e sh -c 'wsuspect-proxy ; bash'" },
  { "xcat", "urxvt -e sh -c 'xcat ; bash'" },
  { "xrop", "urxvt -e sh -c 'xrop ; bash'" },
  { "xsser", "urxvt -e sh -c 'xsser -h ; bash'" },
  { "xxeinjector", "urxvt -e sh -c 'xxeinjector -h ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "_mocha", "urxvt -e sh -c '_mocha ; bash'" },
  { "mocha", "urxvt -e sh -c 'mocha ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "yinjector", "urxvt -e sh -c 'yinjector -h ; bash'" },
  { "ysoserial", "urxvt -e sh -c 'ysoserial ; bash'" },
  { "zarp", "urxvt -e sh -c 'zarp -h ; bash'" },
  { "zeratool", "urxvt -e sh -c 'zeratool -h ; bash'" },
  { "zirikatu", "urxvt -e sh -c 'zirikatu ; bash'" },
}

fingerprintmenu = {
  { "arp-fingerprint", "urxvt -e sh -c 'arp-fingerprint -h ; bash'" },
  { "arp-scan", "urxvt -e sh -c 'arp-scan -h ; bash'" },
  { "get-iab", "urxvt -e sh -c 'get-iab -h ; bash'" },
  { "get-oui", "urxvt -e sh -c 'get-oui -h ; bash'" },
  { "arp-fingerprint", "urxvt -e sh -c 'arp-fingerprint -h ; bash'" },
  { "arp-scan", "urxvt -e sh -c 'arp-scan -h ; bash'" },
  { "get-iab", "urxvt -e sh -c 'get-iab -h ; bash'" },
  { "get-oui", "urxvt -e sh -c 'get-oui -h ; bash'" },
  { "asp-audit", "urxvt -e sh -c 'asp-audit ; bash'" },
  { "aztarna", "urxvt -e sh -c 'aztarna -h ; bash'" },
  { "badministration", "urxvt -e sh -c 'badministration --help ; bash'" },
  { "blindelephant", "urxvt -e sh -c 'blindelephant -h ; bash'" },
  { "cisco-torch", "urxvt -e sh -c 'cisco-torch -h ; bash'" },
  { "cmseek", "urxvt -e sh -c 'cmseek ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "cmsscanner", "urxvt -e sh -c 'cmsscanner -h ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "letdown", "urxvt -e sh -c 'letdown ; bash'" },
  { "reverseraider", "urxvt -e sh -c 'reverseraider ; bash'" },
  { "davscan", "urxvt -e sh -c 'davscan -h ; bash'" },
  { "detectem", "urxvt -e sh -c 'detectem --help ; bash'" },
  { "dhcpf", "urxvt -e sh -c 'dhcpf ; bash'" },
  { "dnsmap", "urxvt -e sh -c 'dnsmap ; bash'" },
  { "dnsmap-bulk", "urxvt -e sh -c 'dnsmap-bulk ; bash'" },
  { "domi-owned", "urxvt -e sh -c 'domi-owned -h ; bash'" },
  { "faraday-manage", "urxvt -e sh -c 'faraday-manage ; bash'" },
  { "faraday-searcher", "urxvt -e sh -c 'faraday-searcher ; bash'" },
  { "faraday-server", "urxvt -e sh -c 'faraday-server ; bash'" },
  { "favfreak", "urxvt -e sh -c 'favfreak -h ; bash'" },
  { "fhttp", "urxvt -e sh -c 'fhttp -h ; bash'" },
  { "fingerprinter", "urxvt -e sh -c 'fingerprinter -h ; bash'" },
  { "fl0p", "urxvt -e sh -c 'fl0p -h ; bash'" },
  { "fpdns", "urxvt -e sh -c 'fpdns ; bash'" },
  { "ftpmap", "urxvt -e sh -c 'ftpmap -h ; bash'" },
  { "hakku", "urxvt -e sh -c 'hakku ; bash'" },
  { "htrosbif", "urxvt -e sh -c 'htrosbif -h ; bash'" },
  { "httprint", "urxvt -e sh -c 'httprint -h ; bash'" },
  { "identywaf", "urxvt -e sh -c 'identywaf -h ; bash'" },
  { "kolkata", "urxvt -e sh -c 'kolkata ; bash'" },
  { "aprof", "urxvt -e sh -c 'aprof ; bash'" },
  { "lbmap", "urxvt -e sh -c 'lbmap -h ; bash'" },
  { "mwebfp", "urxvt -e sh -c 'mwebfp -h ; bash'" },
  { "neighbor-fingerprint", "urxvt -e sh -c 'neighbor-fingerprint --help ; bash'" },
  { "nimbostratus", "urxvt -e sh -c 'nimbostratus -h ; bash'" },
  { "ntp-fingerprint", "urxvt -e sh -c 'ntp-fingerprint ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "operative", "urxvt -e sh -c 'operative -h ; bash'" },
  { "p0f", "urxvt -e sh -c 'p0f -h ; bash'" },
  { "p0f-client", "urxvt -e sh -c 'p0f-client -h ; bash'" },
  { "p0f-sendsyn", "urxvt -e sh -c 'p0f-sendsyn -h ; bash'" },
  { "p0f-sendsyn6", "urxvt -e sh -c 'p0f-sendsyn6 ; bash'" },
  { "p0f", "urxvt -e sh -c 'p0f -h ; bash'" },
  { "p0f-client", "urxvt -e sh -c 'p0f-client -h ; bash'" },
  { "p0f-sendsyn", "urxvt -e sh -c 'p0f-sendsyn -h ; bash'" },
  { "p0f-sendsyn6", "urxvt -e sh -c 'p0f-sendsyn6 ; bash'" },
  { "plecost", "urxvt -e sh -c 'plecost -h ; bash'" },
  { "propecia", "urxvt -e sh -c 'propecia ; bash'" },
  { "webtech2", "urxvt -e sh -c 'webtech2 ; bash'" },
  { "rapidscan", "urxvt -e sh -c 'rapidscan ; bash'" },
  { "recsech", "urxvt -e sh -c 'recsech ; bash'" },
  { "scannerl", "urxvt -e sh -c 'scannerl ; bash'" },
  { "sinfp", "urxvt -e sh -c 'sinfp -h ; bash'" },
  { "sitediff", "urxvt -e sh -c 'sitediff -h ; bash'" },
  { "smtmap", "urxvt -e sh -c 'smtmap ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "sparta", "urxvt -e sh -c 'sparta ; bash'" },
  { "spartan", "urxvt -e sh -c 'spartan -h ; bash'" },
  { "thcrut", "urxvt -e sh -c 'thcrut -h ; bash'" },
  { "fingerprintls", "urxvt -e sh -c 'fingerprintls -h ; bash'" },
  { "fingerprintout", "urxvt -e sh -c 'fingerprintout -h ; bash'" },
  { "parselog", "urxvt -e sh -c 'parselog ; bash'" },
  { "tls-prober", "urxvt -e sh -c 'tls-prober -h ; bash'" },
  { "userrecon", "urxvt -e sh -c 'userrecon ; bash'" },
  { "vault-scanner", "urxvt -e sh -c 'vault-scanner ; bash'" },
  { "vulmap", "urxvt -e sh -c 'vulmap -h ; bash'" },
  { "vulnx", "urxvt -e sh -c 'vulnx -h ; bash'" },
  { "vulnx.desktop", "urxvt -e sh -c 'vulnx.desktop ; bash'" },
  { "wafp", "urxvt -e sh -c 'wafp -h ; bash'" },
  { "webanalyze", "urxvt -e sh -c 'webanalyze ; bash'" },
  { "webkiller", "urxvt -e sh -c 'webkiller -h ; bash'" },
  { "webtech", "urxvt -e sh -c 'webtech -h ; bash'" },
  { "wpintel", "urxvt -e sh -c 'wpintel ; bash'" },
  { "xprobe2", "urxvt -e sh -c 'xprobe2 -h ; bash'" },
  { "yasat", "urxvt -e sh -c 'yasat -h ; bash'" },
  { "zgrab2", "urxvt -e sh -c 'zgrab2 -h ; bash'" },
}

firmwaremenu = {
  { "binwalk", "urxvt -e sh -c 'binwalk ; bash'" },
  { "firmwalker", "urxvt -e sh -c 'firmwalker ; bash'" },
  { "meanalyzer", "urxvt -e sh -c 'meanalyzer ; bash'" },
  { "uefi-firmware-parser", "urxvt -e sh -c 'uefi-firmware-parser ; bash'" },
}

forensicmenu = {
  { "aesfix", "urxvt -e sh -c 'aesfix ; bash'" },
  { "affcat", "urxvt -e sh -c 'affcat ; bash'" },
  { "affcompare", "urxvt -e sh -c 'affcompare ; bash'" },
  { "affconvert", "urxvt -e sh -c 'affconvert ; bash'" },
  { "affcrypto", "urxvt -e sh -c 'affcrypto ; bash'" },
  { "affdiskprint", "urxvt -e sh -c 'affdiskprint ; bash'" },
  { "affinfo", "urxvt -e sh -c 'affinfo ; bash'" },
  { "affix", "urxvt -e sh -c 'affix ; bash'" },
  { "affrecover", "urxvt -e sh -c 'affrecover ; bash'" },
  { "affsegment", "urxvt -e sh -c 'affsegment ; bash'" },
  { "affsign", "urxvt -e sh -c 'affsign ; bash'" },
  { "affstats", "urxvt -e sh -c 'affstats ; bash'" },
  { "affuse", "urxvt -e sh -c 'affuse ; bash'" },
  { "affverify", "urxvt -e sh -c 'affverify ; bash'" },
  { "aimage", "urxvt -e sh -c 'aimage -h ; bash'" },
  { "air", "urxvt -e sh -c 'air ; bash'" },
  { "air-counter", "urxvt -e sh -c 'air-counter ; bash'" },
  { "tailer", "urxvt -e sh -c 'tailer --help ; bash'" },
  { "analyzemft", "urxvt -e sh -c 'analyzemft -h ; bash'" },
  { "androick", "urxvt -e sh -c 'androick ; bash'" },
  { "pxedump", "urxvt -e sh -c 'pxedump -h ; bash'" },
  { "usbdump", "urxvt -e sh -c 'usbdump -h ; bash'" },
  { "bmaptool", "urxvt -e sh -c 'bmaptool -h ; bash'" },
  { "bmc-tools", "urxvt -e sh -c 'bmc-tools -h ; bash'" },
  { "BEViewer", "urxvt -e sh -c 'BEViewer -h ; bash'" },
  { "bulk_extractor", "urxvt -e sh -c 'bulk_extractor ; bash'" },
  { "plugin_test", "urxvt -e sh -c 'plugin_test ; bash'" },
  { "canari", "urxvt -e sh -c 'canari -h ; bash'" },
  { "dispatcher", "urxvt -e sh -c 'dispatcher -h ; bash'" },
  { "pysudo", "urxvt -e sh -c 'pysudo -h ; bash'" },
  { "captipper", "urxvt -e sh -c 'captipper ; bash'" },
  { "casefile", "urxvt -e sh -c 'casefile --help ; bash'" },
  { "maltego", "urxvt -e sh -c 'maltego -h ; bash'" },
  { "maltego.ico", "urxvt -e sh -c 'maltego.ico ; bash'" },
  { "chaosmap", "urxvt -e sh -c 'chaosmap ; bash'" },
  { "chkrootkit", "urxvt -e sh -c 'chkrootkit -h ; bash'" },
  { "chntpw", "urxvt -e sh -c 'chntpw ; bash'" },
  { "cpnt", "urxvt -e sh -c 'cpnt ; bash'" },
  { "reged", "urxvt -e sh -c 'reged ; bash'" },
  { "chntpw", "urxvt -e sh -c 'chntpw ; bash'" },
  { "cpnt", "urxvt -e sh -c 'cpnt ; bash'" },
  { "reged", "urxvt -e sh -c 'reged ; bash'" },
  { "chromefreak", "urxvt -e sh -c 'chromefreak -h ; bash'" },
  { "dc3dd", "urxvt -e sh -c 'dc3dd --help ; bash'" },
  { "dcfldd", "urxvt -e sh -c 'dcfldd --help ; bash'" },
  { "ddrescue", "urxvt -e sh -c 'ddrescue --help ; bash'" },
  { "ddrescuelog", "urxvt -e sh -c 'ddrescuelog --help ; bash'" },
  { "ddrescue", "urxvt -e sh -c 'ddrescue --help ; bash'" },
  { "ddrescuelog", "urxvt -e sh -c 'ddrescuelog --help ; bash'" },
  { "ntfs-parser", "urxvt -e sh -c 'ntfs-parser -h ; bash'" },
  { "vsc-mount", "urxvt -e sh -c 'vsc-mount -h ; bash'" },
  { "dftimewolf", "urxvt -e sh -c 'dftimewolf -h ; bash'" },
  { "disitool", "urxvt -e sh -c 'disitool -h ; bash'" },
  { "dmg2img", "urxvt -e sh -c 'dmg2img ; bash'" },
  { "vfdecrypt", "urxvt -e sh -c 'vfdecrypt ; bash'" },
  { "dmg2img", "urxvt -e sh -c 'dmg2img ; bash'" },
  { "vfdecrypt", "urxvt -e sh -c 'vfdecrypt ; bash'" },
  { "dumpzilla", "urxvt -e sh -c 'dumpzilla -h ; bash'" },
  { "dbxparse", "urxvt -e sh -c 'dbxparse -h ; bash'" },
  { "emldump", "urxvt -e sh -c 'emldump -h ; bash'" },
  { "evtkit", "urxvt -e sh -c 'evtkit -h ; bash'" },
  { "extractusnjrnl", "urxvt -e sh -c 'extractusnjrnl -h ; bash'" },
  { "foremost", "urxvt -e sh -c 'foremost -h ; bash'" },
  { "fridump", "urxvt -e sh -c 'fridump -h ; bash'" },
  { "fs-nyarl", "urxvt -e sh -c 'fs-nyarl -h ; bash'" },
  { "chaosreader0.94", "urxvt -e sh -c 'chaosreader0.94 ; bash'" },
  { "galleta", "urxvt -e sh -c 'galleta ; bash'" },
  { "grokevt-addlog", "urxvt -e sh -c 'grokevt-addlog ; bash'" },
  { "grokevt-builddb", "urxvt -e sh -c 'grokevt-builddb ; bash'" },
  { "grokevt-dumpmsgs", "urxvt -e sh -c 'grokevt-dumpmsgs ; bash'" },
  { "grokevt-findlogs", "urxvt -e sh -c 'grokevt-findlogs ; bash'" },
  { "grokevt-parselog", "urxvt -e sh -c 'grokevt-parselog ; bash'" },
  { "guymager", "urxvt -e sh -c 'guymager ; bash'" },
  { "haystack-find-heap", "urxvt -e sh -c 'haystack-find-heap ; bash'" },
  { "haystack-live-dump", "urxvt -e sh -c 'haystack-live-dump ; bash'" },
  { "haystack-live-watch", "urxvt -e sh -c 'haystack-live-watch ; bash'" },
  { "haystack-rekall-dump", "urxvt -e sh -c 'haystack-rekall-dump ; bash'" },
  { "haystack-search", "urxvt -e sh -c 'haystack-search ; bash'" },
  { "haystack-volatility-dump", "urxvt -e sh -c 'haystack-volatility-dump ; bash'" },
  { "imount", "urxvt -e sh -c 'imount -h ; bash'" },
  { "indx2csv", "urxvt -e sh -c 'indx2csv -h ; bash'" },
  { "indxcarver", "urxvt -e sh -c 'indxcarver -h ; bash'" },
  { "interrogate", "urxvt -e sh -c 'interrogate -h ; bash'" },
  { "iosforensic", "urxvt -e sh -c 'iosforensic -h ; bash'" },
  { "ipba2", "urxvt -e sh -c 'ipba2 ; bash'" },
  { "iphoneanalyzer", "urxvt -e sh -c 'iphoneanalyzer -h ; bash'" },
  { "jpegdump", "urxvt -e sh -c 'jpegdump -h ; bash'" },
  { "lazagne", "urxvt -e sh -c 'lazagne -h ; bash'" },
  { "ldsview", "urxvt -e sh -c 'ldsview -h ; bash'" },
  { "lfle", "urxvt -e sh -c 'lfle -h ; bash'" },
  { "fvdeinfo", "urxvt -e sh -c 'fvdeinfo -h ; bash'" },
  { "fvdemount", "urxvt -e sh -c 'fvdemount -h ; bash'" },
  { "limeaide", "urxvt -e sh -c 'limeaide ; bash'" },
  { "log-file-parser", "urxvt -e sh -c 'log-file-parser -h ; bash'" },
  { "loki-scanner", "urxvt -e sh -c 'loki-scanner -h ; bash'" },
  { "mac-robber", "urxvt -e sh -c 'mac-robber -h ; bash'" },
  { "magicrescue", "urxvt -e sh -c 'magicrescue ; bash'" },
  { "magicsort", "urxvt -e sh -c 'magicsort ; bash'" },
  { "make-pdf", "urxvt -e sh -c 'make-pdf ; bash'" },
  { "malheur", "urxvt -e sh -c 'malheur -h ; bash'" },
  { "maltego", "urxvt -e sh -c 'maltego -h ; bash'" },
  { "maltego.ico", "urxvt -e sh -c 'maltego.ico ; bash'" },
  { "malwaredetect", "urxvt -e sh -c 'malwaredetect ; bash'" },
  { "mboxgrep", "urxvt -e sh -c 'mboxgrep ; bash'" },
  { "mdb-array", "urxvt -e sh -c 'mdb-array ; bash'" },
  { "mdb-count", "urxvt -e sh -c 'mdb-count ; bash'" },
  { "mdb-export", "urxvt -e sh -c 'mdb-export ; bash'" },
  { "mdb-header", "urxvt -e sh -c 'mdb-header ; bash'" },
  { "mdb-hexdump", "urxvt -e sh -c 'mdb-hexdump ; bash'" },
  { "mdb-parsecsv", "urxvt -e sh -c 'mdb-parsecsv ; bash'" },
  { "mdb-schema", "urxvt -e sh -c 'mdb-schema ; bash'" },
  { "mdb-sql", "urxvt -e sh -c 'mdb-sql ; bash'" },
  { "mdb-tables", "urxvt -e sh -c 'mdb-tables ; bash'" },
  { "mdb-ver", "urxvt -e sh -c 'mdb-ver ; bash'" },
  { "memfetch", "urxvt -e sh -c 'memfetch ; bash'" },
  { "mft2csv", "urxvt -e sh -c 'mft2csv -h ; bash'" },
  { "mftcarver", "urxvt -e sh -c 'mftcarver -h ; bash'" },
  { "mftrcrd", "urxvt -e sh -c 'mftrcrd -h ; bash'" },
  { "mftref2name", "urxvt -e sh -c 'mftref2name -h ; bash'" },
  { "mimipenguin", "urxvt -e sh -c 'mimipenguin ; bash'" },
  { "mobius", "urxvt -e sh -c 'mobius ; bash'" },
  { "mp3nema", "urxvt -e sh -c 'mp3nema -h ; bash'" },
  { "ms-sys", "urxvt -e sh -c 'ms-sys -h ; bash'" },
  { "munin", "urxvt -e sh -c 'munin -h ; bash'" },
  { "munin-host", "urxvt -e sh -c 'munin-host -h ; bash'" },
  { "mxtract", "urxvt -e sh -c 'mxtract -h ; bash'" },
  { "naft-gfe", "urxvt -e sh -c 'naft-gfe -h ; bash'" },
  { "naft-icd", "urxvt -e sh -c 'naft-icd -h ; bash'" },
  { "naft-ii", "urxvt -e sh -c 'naft-ii -h ; bash'" },
  { "networkminer", "urxvt -e sh -c 'networkminer ; bash'" },
  { "nfex", "urxvt -e sh -c 'nfex -h ; bash'" },
  { "dscomputers", "urxvt -e sh -c 'dscomputers -h ; bash'" },
  { "dsdeletedobjects", "urxvt -e sh -c 'dsdeletedobjects -h ; bash'" },
  { "dsfileinformation", "urxvt -e sh -c 'dsfileinformation -h ; bash'" },
  { "dstimeline", "urxvt -e sh -c 'dstimeline -h ; bash'" },
  { "dsusers", "urxvt -e sh -c 'dsusers -h ; bash'" },
  { "ntfs-file-extractor", "urxvt -e sh -c 'ntfs-file-extractor -h ; bash'" },
  { "ntfs-log-tracker", "urxvt -e sh -c 'ntfs-log-tracker -h ; bash'" },
  { "pdf2pdfa", "urxvt -e sh -c 'pdf2pdfa ; bash'" },
  { "pdf2ruby", "urxvt -e sh -c 'pdf2ruby ; bash'" },
  { "pdfcop", "urxvt -e sh -c 'pdfcop ; bash'" },
  { "pdfdecompress", "urxvt -e sh -c 'pdfdecompress ; bash'" },
  { "pdfdecrypt", "urxvt -e sh -c 'pdfdecrypt ; bash'" },
  { "pdfencrypt", "urxvt -e sh -c 'pdfencrypt ; bash'" },
  { "pdfextract", "urxvt -e sh -c 'pdfextract ; bash'" },
  { "pdfmetadata", "urxvt -e sh -c 'pdfmetadata ; bash'" },
  { "parse-evtx", "urxvt -e sh -c 'parse-evtx ; bash'" },
  { "pasco", "urxvt -e sh -c 'pasco ; bash'" },
  { "pcapfex", "urxvt -e sh -c 'pcapfex -h ; bash'" },
  { "pcapxray", "urxvt -e sh -c 'pcapxray ; bash'" },
  { "pdblaster", "urxvt -e sh -c 'pdblaster -h ; bash'" },
  { "pdf-parser", "urxvt -e sh -c 'pdf-parser ; bash'" },
  { "pdfbook-analyzer", "urxvt -e sh -c 'pdfbook-analyzer -h ; bash'" },
  { "pdfid", "urxvt -e sh -c 'pdfid ; bash'" },
  { "pdfresurrect", "urxvt -e sh -c 'pdfresurrect -h ; bash'" },
  { "peepdf", "urxvt -e sh -c 'peepdf -h ; bash'" },
  { "png-fix-IDAT-windowsize", "urxvt -e sh -c 'png-fix-IDAT-windowsize -h ; bash'" },
  { "pngcheck", "urxvt -e sh -c 'pngcheck -h ; bash'" },
  { "powermft", "urxvt -e sh -c 'powermft -h ; bash'" },
  { "ezhexviewer", "urxvt -e sh -c 'ezhexviewer ; bash'" },
  { "ftguess", "urxvt -e sh -c 'ftguess ; bash'" },
  { "mraptor", "urxvt -e sh -c 'mraptor ; bash'" },
  { "msodde", "urxvt -e sh -c 'msodde ; bash'" },
  { "olebrowse", "urxvt -e sh -c 'olebrowse ; bash'" },
  { "oledir", "urxvt -e sh -c 'oledir ; bash'" },
  { "olefile", "urxvt -e sh -c 'olefile ; bash'" },
  { "oleid", "urxvt -e sh -c 'oleid -h ; bash'" },
  { "olemap", "urxvt -e sh -c 'olemap ; bash'" },
  { "olemeta", "urxvt -e sh -c 'olemeta -h ; bash'" },
  { "oleobj", "urxvt -e sh -c 'oleobj ; bash'" },
  { "oletimes", "urxvt -e sh -c 'oletimes ; bash'" },
  { "olevba", "urxvt -e sh -c 'olevba ; bash'" },
  { "pyxswf", "urxvt -e sh -c 'pyxswf ; bash'" },
  { "rtfobj", "urxvt -e sh -c 'rtfobj ; bash'" },
  { "ezhexviewer2", "urxvt -e sh -c 'ezhexviewer2 ; bash'" },
  { "ftguess2", "urxvt -e sh -c 'ftguess2 ; bash'" },
  { "mraptor2", "urxvt -e sh -c 'mraptor2 ; bash'" },
  { "msodde2", "urxvt -e sh -c 'msodde2 ; bash'" },
  { "olebrowse2", "urxvt -e sh -c 'olebrowse2 ; bash'" },
  { "oledir2", "urxvt -e sh -c 'oledir2 ; bash'" },
  { "olefile2", "urxvt -e sh -c 'olefile2 ; bash'" },
  { "oleid2", "urxvt -e sh -c 'oleid2 ; bash'" },
  { "olemap2", "urxvt -e sh -c 'olemap2 ; bash'" },
  { "olemeta2", "urxvt -e sh -c 'olemeta2 ; bash'" },
  { "oleobj2", "urxvt -e sh -c 'oleobj2 ; bash'" },
  { "oletimes2", "urxvt -e sh -c 'oletimes2 ; bash'" },
  { "olevba2", "urxvt -e sh -c 'olevba2 ; bash'" },
  { "pyxswf2", "urxvt -e sh -c 'pyxswf2 ; bash'" },
  { "rtfobj2", "urxvt -e sh -c 'rtfobj2 ; bash'" },
  { "peepdf2", "urxvt -e sh -c 'peepdf2 ; bash'" },
  { "rcrdcarver", "urxvt -e sh -c 'rcrdcarver -h ; bash'" },
  { "recoverjpeg", "urxvt -e sh -c 'recoverjpeg ; bash'" },
  { "recovermov", "urxvt -e sh -c 'recovermov ; bash'" },
  { "sort-pictures", "urxvt -e sh -c 'sort-pictures ; bash'" },
  { "recuperabit", "urxvt -e sh -c 'recuperabit -h ; bash'" },
  { "registry-diff", "urxvt -e sh -c 'registry-diff --help ; bash'" },
  { "registry-dump", "urxvt -e sh -c 'registry-dump --help ; bash'" },
  { "registry-parse-header", "urxvt -e sh -c 'registry-parse-header --help ; bash'" },
  { "registry-transaction-logs", "urxvt -e sh -c 'registry-transaction-logs --help ; bash'" },
  { "reglookup", "urxvt -e sh -c 'reglookup ; bash'" },
  { "reglookup-recover", "urxvt -e sh -c 'reglookup-recover ; bash'" },
  { "reglookup-timeline", "urxvt -e sh -c 'reglookup-timeline ; bash'" },
  { "reg-compname", "urxvt -e sh -c 'reg-compname -h ; bash'" },
  { "reg-filedialogmru", "urxvt -e sh -c 'reg-filedialogmru -h ; bash'" },
  { "reg-lastloggedon", "urxvt -e sh -c 'reg-lastloggedon -h ; bash'" },
  { "reg-mndmru", "urxvt -e sh -c 'reg-mndmru -h ; bash'" },
  { "reg-portproxy", "urxvt -e sh -c 'reg-portproxy -h ; bash'" },
  { "reg-rdphint", "urxvt -e sh -c 'reg-rdphint -h ; bash'" },
  { "reg-recentdocs", "urxvt -e sh -c 'reg-recentdocs -h ; bash'" },
  { "reg-regtime", "urxvt -e sh -c 'reg-regtime -h ; bash'" },
  { "reg-run", "urxvt -e sh -c 'reg-run -h ; bash'" },
  { "reg-runmru", "urxvt -e sh -c 'reg-runmru -h ; bash'" },
  { "reg-services", "urxvt -e sh -c 'reg-services -h ; bash'" },
  { "reg-srum", "urxvt -e sh -c 'reg-srum -h ; bash'" },
  { "reg-sysinternals", "urxvt -e sh -c 'reg-sysinternals -h ; bash'" },
  { "reg-timezone", "urxvt -e sh -c 'reg-timezone -h ; bash'" },
  { "reg-typedurls", "urxvt -e sh -c 'reg-typedurls -h ; bash'" },
  { "reg-uninstall", "urxvt -e sh -c 'reg-uninstall -h ; bash'" },
  { "reg-userassist", "urxvt -e sh -c 'reg-userassist -h ; bash'" },
  { "reg-version", "urxvt -e sh -c 'reg-version -h ; bash'" },
  { "regrip", "urxvt -e sh -c 'regrip -h ; bash'" },
  { "rekal", "urxvt -e sh -c 'rekal -h ; bash'" },
  { "rekall", "urxvt -e sh -c 'rekall -h ; bash'" },
  { "rekall-agent-nanny", "urxvt -e sh -c 'rekall-agent-nanny ; bash'" },
  { "rifiuti", "urxvt -e sh -c 'rifiuti --help-all ; bash'" },
  { "rifiuti-vista", "urxvt -e sh -c 'rifiuti-vista -h ; bash'" },
  { "rkhunter", "urxvt -e sh -c 'rkhunter -h ; bash'" },
  { "scalpel", "urxvt -e sh -c 'scalpel ; bash'" },
  { "scrounge-ntfs", "urxvt -e sh -c 'scrounge-ntfs -h ; bash'" },
  { "secure2csv", "urxvt -e sh -c 'secure2csv -h ; bash'" },
  { "skypefreak", "urxvt -e sh -c 'skypefreak -h ; bash'" },
  { "blkcalc", "urxvt -e sh -c 'blkcalc ; bash'" },
  { "blkcat", "urxvt -e sh -c 'blkcat ; bash'" },
  { "blkls", "urxvt -e sh -c 'blkls ; bash'" },
  { "blkstat", "urxvt -e sh -c 'blkstat ; bash'" },
  { "fcat", "urxvt -e sh -c 'fcat ; bash'" },
  { "ffind", "urxvt -e sh -c 'ffind ; bash'" },
  { "fiwalk", "urxvt -e sh -c 'fiwalk ; bash'" },
  { "fls", "urxvt -e sh -c 'fls -h ; bash'" },
  { "fsstat", "urxvt -e sh -c 'fsstat ; bash'" },
  { "hfind", "urxvt -e sh -c 'hfind ; bash'" },
  { "icat", "urxvt -e sh -c 'icat ; bash'" },
  { "ifind", "urxvt -e sh -c 'ifind ; bash'" },
  { "ils", "urxvt -e sh -c 'ils ; bash'" },
  { "img_cat", "urxvt -e sh -c 'img_cat ; bash'" },
  { "img_stat", "urxvt -e sh -c 'img_stat -h ; bash'" },
  { "istat", "urxvt -e sh -c 'istat ; bash'" },
  { "jcat", "urxvt -e sh -c 'jcat ; bash'" },
  { "jls", "urxvt -e sh -c 'jls ; bash'" },
  { "jpeg_extract", "urxvt -e sh -c 'jpeg_extract ; bash'" },
  { "mactime", "urxvt -e sh -c 'mactime ; bash'" },
  { "mmcat", "urxvt -e sh -c 'mmcat -h ; bash'" },
  { "mmls", "urxvt -e sh -c 'mmls ; bash'" },
  { "mmstat", "urxvt -e sh -c 'mmstat ; bash'" },
  { "pstat", "urxvt -e sh -c 'pstat ; bash'" },
  { "sigfind", "urxvt -e sh -c 'sigfind ; bash'" },
  { "sorter", "urxvt -e sh -c 'sorter ; bash'" },
  { "srch_strings", "urxvt -e sh -c 'srch_strings ; bash'" },
  { "tsk_comparedir", "urxvt -e sh -c 'tsk_comparedir ; bash'" },
  { "tsk_gettimes", "urxvt -e sh -c 'tsk_gettimes ; bash'" },
  { "tsk_loaddb", "urxvt -e sh -c 'tsk_loaddb ; bash'" },
  { "tsk_recover", "urxvt -e sh -c 'tsk_recover ; bash'" },
  { "usnjls", "urxvt -e sh -c 'usnjls ; bash'" },
  { "blkcalc", "urxvt -e sh -c 'blkcalc ; bash'" },
  { "blkcat", "urxvt -e sh -c 'blkcat ; bash'" },
  { "blkls", "urxvt -e sh -c 'blkls ; bash'" },
  { "blkstat", "urxvt -e sh -c 'blkstat ; bash'" },
  { "fcat", "urxvt -e sh -c 'fcat ; bash'" },
  { "ffind", "urxvt -e sh -c 'ffind ; bash'" },
  { "fiwalk", "urxvt -e sh -c 'fiwalk ; bash'" },
  { "fls", "urxvt -e sh -c 'fls -h ; bash'" },
  { "fsstat", "urxvt -e sh -c 'fsstat ; bash'" },
  { "hfind", "urxvt -e sh -c 'hfind ; bash'" },
  { "icat", "urxvt -e sh -c 'icat ; bash'" },
  { "ifind", "urxvt -e sh -c 'ifind ; bash'" },
  { "ils", "urxvt -e sh -c 'ils ; bash'" },
  { "img_cat", "urxvt -e sh -c 'img_cat ; bash'" },
  { "img_stat", "urxvt -e sh -c 'img_stat -h ; bash'" },
  { "istat", "urxvt -e sh -c 'istat ; bash'" },
  { "jcat", "urxvt -e sh -c 'jcat ; bash'" },
  { "jls", "urxvt -e sh -c 'jls ; bash'" },
  { "jpeg_extract", "urxvt -e sh -c 'jpeg_extract ; bash'" },
  { "mactime", "urxvt -e sh -c 'mactime ; bash'" },
  { "mmcat", "urxvt -e sh -c 'mmcat -h ; bash'" },
  { "mmls", "urxvt -e sh -c 'mmls ; bash'" },
  { "mmstat", "urxvt -e sh -c 'mmstat ; bash'" },
  { "pstat", "urxvt -e sh -c 'pstat ; bash'" },
  { "sigfind", "urxvt -e sh -c 'sigfind ; bash'" },
  { "sorter", "urxvt -e sh -c 'sorter ; bash'" },
  { "srch_strings", "urxvt -e sh -c 'srch_strings ; bash'" },
  { "tsk_comparedir", "urxvt -e sh -c 'tsk_comparedir ; bash'" },
  { "tsk_gettimes", "urxvt -e sh -c 'tsk_gettimes ; bash'" },
  { "tsk_loaddb", "urxvt -e sh -c 'tsk_loaddb ; bash'" },
  { "tsk_recover", "urxvt -e sh -c 'tsk_recover ; bash'" },
  { "usnjls", "urxvt -e sh -c 'usnjls ; bash'" },
  { "snort", "urxvt -e sh -c 'snort -h ; bash'" },
  { "u2boat", "urxvt -e sh -c 'u2boat ; bash'" },
  { "u2spewfoo", "urxvt -e sh -c 'u2spewfoo ; bash'" },
  { "u2streamer", "urxvt -e sh -c 'u2streamer ; bash'" },
  { "stegbreak", "urxvt -e sh -c 'stegbreak --help ; bash'" },
  { "stegcompare", "urxvt -e sh -c 'stegcompare --help ; bash'" },
  { "stegdeimage", "urxvt -e sh -c 'stegdeimage --help ; bash'" },
  { "stegdetect", "urxvt -e sh -c 'stegdetect --help ; bash'" },
  { "stenographer", "urxvt -e sh -c 'stenographer -h ; bash'" },
  { "flarestrings", "urxvt -e sh -c 'flarestrings -h ; bash'" },
  { "rank_strings", "urxvt -e sh -c 'rank_strings -h ; bash'" },
  { "swap-digger", "urxvt -e sh -c 'swap-digger -h ; bash'" },
  { "syft", "urxvt -e sh -c 'syft -h ; bash'" },
  { "tchunt-ng", "urxvt -e sh -c 'tchunt-ng -h ; bash'" },
  { "automater", "urxvt -e sh -c 'automater -h ; bash'" },
  { "tell-me-your-secrets", "urxvt -e sh -c 'tell-me-your-secrets -h ; bash'" },
  { "fidentify", "urxvt -e sh -c 'fidentify ; bash'" },
  { "photorec", "urxvt -e sh -c 'photorec ; bash'" },
  { "testdisk", "urxvt -e sh -c 'testdisk ; bash'" },
  { "fidentify", "urxvt -e sh -c 'fidentify ; bash'" },
  { "photorec", "urxvt -e sh -c 'photorec ; bash'" },
  { "testdisk", "urxvt -e sh -c 'testdisk ; bash'" },
  { "trid", "urxvt -e sh -c 'trid -h ; bash'" },
  { "truehunter", "urxvt -e sh -c 'truehunter -h ; bash'" },
  { "unhide", "urxvt -e sh -c 'unhide -h ; bash'" },
  { "unhide-linux", "urxvt -e sh -c 'unhide-linux ; bash'" },
  { "unhide-posix", "urxvt -e sh -c 'unhide-posix ; bash'" },
  { "unhide-tcp", "urxvt -e sh -c 'unhide-tcp ; bash'" },
  { "unhide", "urxvt -e sh -c 'unhide -h ; bash'" },
  { "unhide-linux", "urxvt -e sh -c 'unhide-linux ; bash'" },
  { "unhide-posix", "urxvt -e sh -c 'unhide-posix ; bash'" },
  { "unhide-tcp", "urxvt -e sh -c 'unhide-tcp ; bash'" },
  { "usbrip", "urxvt -e sh -c 'usbrip -h ; bash'" },
  { "usnjrnl2csv", "urxvt -e sh -c 'usnjrnl2csv -h ; bash'" },
  { "usn", "urxvt -e sh -c 'usn ; bash'" },
  { "vinetto", "urxvt -e sh -c 'vinetto -h ; bash'" },
  { "volafox", "urxvt -e sh -c 'volafox -h ; bash'" },
  { "volatility-extra", "urxvt -e sh -c 'volatility-extra -h ; bash'" },
  { "vol", "urxvt -e sh -c 'vol ; bash'" },
  { "prefetch", "urxvt -e sh -c 'prefetch -h ; bash'" },
  { "CCM_RUA_Finder", "urxvt -e sh -c 'CCM_RUA_Finder ; bash'" },
  { "PyWMIPersistenceFinder", "urxvt -e sh -c 'PyWMIPersistenceFinder ; bash'" },
  { "wyd", "urxvt -e sh -c 'wyd ; bash'" },
  { "dema", "urxvt -e sh -c 'dema ; bash'" },
  { "mfbc", "urxvt -e sh -c 'mfbc ; bash'" },
  { "mfile", "urxvt -e sh -c 'mfile ; bash'" },
  { "mpaltalk", "urxvt -e sh -c 'mpaltalk ; bash'" },
  { "msite", "urxvt -e sh -c 'msite ; bash'" },
  { "mwebymsg", "urxvt -e sh -c 'mwebymsg ; bash'" },
  { "mwmail", "urxvt -e sh -c 'mwmail ; bash'" },
  { "trigcap", "urxvt -e sh -c 'trigcap ; bash'" },
  { "zipdump", "urxvt -e sh -c 'zipdump ; bash'" },
}

fuzzermenu = {
  { "0d1n", "urxvt -e sh -c '0d1n ; bash'" },
  { "0d1n_view", "urxvt -e sh -c '0d1n_view ; bash'" },
  { "abuse-ssl-bypass-waf", "urxvt -e sh -c 'abuse-ssl-bypass-waf -h ; bash'" },
  { "afl-analyze", "urxvt -e sh -c 'afl-analyze -h ; bash'" },
  { "afl-c++", "urxvt -e sh -c 'afl-c++ -h ; bash'" },
  { "afl-cc", "urxvt -e sh -c 'afl-cc -h ; bash'" },
  { "afl-clang", "urxvt -e sh -c 'afl-clang -h ; bash'" },
  { "afl-clang++", "urxvt -e sh -c 'afl-clang++ -h ; bash'" },
  { "afl-clang-fast", "urxvt -e sh -c 'afl-clang-fast -h ; bash'" },
  { "afl-clang-fast++", "urxvt -e sh -c 'afl-clang-fast++ -h ; bash'" },
  { "afl-cmin", "urxvt -e sh -c 'afl-cmin -h ; bash'" },
  { "afl-fuzz", "urxvt -e sh -c 'afl-fuzz -h ; bash'" },
  { "afl-g++", "urxvt -e sh -c 'afl-g++ -h ; bash'" },
  { "afl-g++-fast", "urxvt -e sh -c 'afl-g++-fast -h ; bash'" },
  { "afl-gcc", "urxvt -e sh -c 'afl-gcc -h ; bash'" },
  { "afl-gcc-fast", "urxvt -e sh -c 'afl-gcc-fast -h ; bash'" },
  { "afl-gotcpu", "urxvt -e sh -c 'afl-gotcpu -h ; bash'" },
  { "afl-tmin", "urxvt -e sh -c 'afl-tmin -h ; bash'" },
  { "afl-whatsup", "urxvt -e sh -c 'afl-whatsup -h ; bash'" },
  { "aggroargs", "urxvt -e sh -c 'aggroargs -h ; bash'" },
  { "ajpfuzzer", "urxvt -e sh -c 'ajpfuzzer ; bash'" },
  { "astra", "urxvt -e sh -c 'astra ; bash'" },
  { "atlas", "urxvt -e sh -c 'atlas -h ; bash'" },
  { "atscan", "urxvt -e sh -c 'atscan ; bash'" },
  { "backfuzz", "urxvt -e sh -c 'backfuzz -h ; bash'" },
  { "bbscan", "urxvt -e sh -c 'bbscan -h ; bash'" },
  { "bfuzz", "urxvt -e sh -c 'bfuzz ; bash'" },
  { "bfuzz-gen", "urxvt -e sh -c 'bfuzz-gen ; bash'" },
  { "bing-lfi-rfi", "urxvt -e sh -c 'bing-lfi-rfi -h ; bash'" },
  { "birp", "urxvt -e sh -c 'birp -h ; bash'" },
  { "bluebox-ng", "urxvt -e sh -c 'bluebox-ng -h ; bash'" },
  { "bf3", "urxvt -e sh -c 'bf3 ; bash'" },
  { "brutexss", "urxvt -e sh -c 'brutexss ; bash'" },
  { "bss", "urxvt -e sh -c 'bss -h ; bash'" },
  { "psm_scan", "urxvt -e sh -c 'psm_scan -h ; bash'" },
  { "rfcomm_scan", "urxvt -e sh -c 'rfcomm_scan -h ; bash'" },
  { "bunny-flow", "urxvt -e sh -c 'bunny-flow ; bash'" },
  { "bunny-gcc", "urxvt -e sh -c 'bunny-gcc ; bash'" },
  { "bunny-main", "urxvt -e sh -c 'bunny-main ; bash'" },
  { "bunny-trace", "urxvt -e sh -c 'bunny-trace ; bash'" },
  { "cantoolz", "urxvt -e sh -c 'cantoolz -h ; bash'" },
  { "capfuzz", "urxvt -e sh -c 'capfuzz -h ; bash'" },
  { "cecster", "urxvt -e sh -c 'cecster -h ; bash'" },
  { "choronzon", "urxvt -e sh -c 'choronzon -h ; bash'" },
  { "cirt-fuzzer", "urxvt -e sh -c 'cirt-fuzzer -help ; bash'" },
  { "CAT", "urxvt -e sh -c 'CAT ; bash'" },
  { "cisco-auditing-tool", "urxvt -e sh -c 'cisco-auditing-tool ; bash'" },
  { "cmsfuzz", "urxvt -e sh -c 'cmsfuzz ; bash'" },
  { "conscan", "urxvt -e sh -c 'conscan -h ; bash'" },
  { "cookie-cadger", "urxvt -e sh -c 'cookie-cadger ; bash'" },
  { "crlf-injector", "urxvt -e sh -c 'crlf-injector ; bash'" },
  { "dalfox", "urxvt -e sh -c 'dalfox -h ; bash'" },
  { "dharma", "urxvt -e sh -c 'dharma -h ; bash'" },
  { "dhcpig", "urxvt -e sh -c 'dhcpig -h ; bash'" },
  { "dizzy", "urxvt -e sh -c 'dizzy -h ; bash'" },
  { "domato-generator", "urxvt -e sh -c 'domato-generator ; bash'" },
  { "doona", "urxvt -e sh -c 'doona -h ; bash'" },
  { "dotdotpwn", "urxvt -e sh -c 'dotdotpwn -h ; bash'" },
  { "drozer", "urxvt -e sh -c 'drozer ; bash'" },
  { "drozer-repository", "urxvt -e sh -c 'drozer-repository ; bash'" },
  { "easyfuzzer", "urxvt -e sh -c 'easyfuzzer ; bash'" },
  { "easyfuzzer-proxy", "urxvt -e sh -c 'easyfuzzer-proxy ; bash'" },
  { "prepare4easyfuzzer", "urxvt -e sh -c 'prepare4easyfuzzer ; bash'" },
  { "wsdl2request", "urxvt -e sh -c 'wsdl2request ; bash'" },
  { "faraday-manage", "urxvt -e sh -c 'faraday-manage ; bash'" },
  { "faraday-searcher", "urxvt -e sh -c 'faraday-searcher ; bash'" },
  { "faraday-server", "urxvt -e sh -c 'faraday-server ; bash'" },
  { "feroxbuster", "urxvt -e sh -c 'feroxbuster -h ; bash'" },
  { "ffuf", "urxvt -e sh -c 'ffuf ; bash'" },
  { "fhttp", "urxvt -e sh -c 'fhttp -h ; bash'" },
  { "filebuster", "urxvt -e sh -c 'filebuster --help ; bash'" },
  { "fimap", "urxvt -e sh -c 'fimap -h ; bash'" },
  { "firewalk", "urxvt -e sh -c 'firewalk -h ; bash'" },
  { "flyr", "urxvt -e sh -c 'flyr ; bash'" },
  { "frisbeelite", "urxvt -e sh -c 'frisbeelite -h ; bash'" },
  { "freport", "urxvt -e sh -c 'freport ; bash'" },
  { "ftest", "urxvt -e sh -c 'ftest ; bash'" },
  { "ftestd", "urxvt -e sh -c 'ftestd ; bash'" },
  { "ftp-fuzz", "urxvt -e sh -c 'ftp-fuzz -h ; bash'" },
  { "fuddly", "urxvt -e sh -c 'fuddly ; bash'" },
  { "fusil-clamav", "urxvt -e sh -c 'fusil-clamav ; bash'" },
  { "fusil-firefox", "urxvt -e sh -c 'fusil-firefox ; bash'" },
  { "fusil-gettext", "urxvt -e sh -c 'fusil-gettext ; bash'" },
  { "fusil-gimp", "urxvt -e sh -c 'fusil-gimp ; bash'" },
  { "fusil-gstreamer", "urxvt -e sh -c 'fusil-gstreamer ; bash'" },
  { "fusil-imagemagick", "urxvt -e sh -c 'fusil-imagemagick ; bash'" },
  { "fusil-libc-printf", "urxvt -e sh -c 'fusil-libc-printf ; bash'" },
  { "fusil-ogg123", "urxvt -e sh -c 'fusil-ogg123 ; bash'" },
  { "fusil-php", "urxvt -e sh -c 'fusil-php ; bash'" },
  { "fusil-vlc", "urxvt -e sh -c 'fusil-vlc ; bash'" },
  { "fusil-wizzard", "urxvt -e sh -c 'fusil-wizzard ; bash'" },
  { "fusil-zzuf", "urxvt -e sh -c 'fusil-zzuf ; bash'" },
  { "fuzzball2", "urxvt -e sh -c 'fuzzball2 -h ; bash'" },
  { "fuzzdiff", "urxvt -e sh -c 'fuzzdiff ; bash'" },
  { "fuzzowski", "urxvt -e sh -c 'fuzzowski -h ; bash'" },
  { "gloom", "urxvt -e sh -c 'gloom ; bash'" },
  { "grammarinator-generate", "urxvt -e sh -c 'grammarinator-generate -h ; bash'" },
  { "grammarinator-parse", "urxvt -e sh -c 'grammarinator-parse -h ; bash'" },
  { "grammarinator-process", "urxvt -e sh -c 'grammarinator-process -h ; bash'" },
  { "graphql-path-enum", "urxvt -e sh -c 'graphql-path-enum -h ; bash'" },
  { "graphqlmap", "urxvt -e sh -c 'graphqlmap -h ; bash'" },
  { "gsad", "urxvt -e sh -c 'gsad -h ; bash'" },
  { "grrcov", "urxvt -e sh -c 'grrcov --help ; bash'" },
  { "database-statistics-sqlite", "urxvt -e sh -c 'database-statistics-sqlite ; bash'" },
  { "greenbone-certdata-sync", "urxvt -e sh -c 'greenbone-certdata-sync -h ; bash'" },
  { "greenbone-scapdata-sync", "urxvt -e sh -c 'greenbone-scapdata-sync -h ; bash'" },
  { "gvm-manage-certs", "urxvt -e sh -c 'gvm-manage-certs ; bash'" },
  { "gvm-migrate-to-postgres", "urxvt -e sh -c 'gvm-migrate-to-postgres ; bash'" },
  { "gvm-portnames-update", "urxvt -e sh -c 'gvm-portnames-update ; bash'" },
  { "hodor", "urxvt -e sh -c 'hodor -h ; bash'" },
  { "homepwn", "urxvt -e sh -c 'homepwn -h ; bash'" },
  { "honggfuzz", "urxvt -e sh -c 'honggfuzz -h ; bash'" },
  { "http-fuzz", "urxvt -e sh -c 'http-fuzz ; bash'" },
  { "httpextract", "urxvt -e sh -c 'httpextract -h ; bash'" },
  { "httpforge", "urxvt -e sh -c 'httpforge -h ; bash'" },
  { "hawk", "urxvt -e sh -c 'hawk --help ; bash'" },
  { "hwk-eagle", "urxvt -e sh -c 'hwk-eagle --help ; bash'" },
  { "ifuzz", "urxvt -e sh -c 'ifuzz ; bash'" },
  { "ikeprober", "urxvt -e sh -c 'ikeprober ; bash'" },
  { "inguma", "urxvt -e sh -c 'inguma -h ; bash'" },
  { "ingumagui", "urxvt -e sh -c 'ingumagui ; bash'" },
  { "injectus", "urxvt -e sh -c 'injectus ; bash'" },
  { "isip", "urxvt -e sh -c 'isip ; bash'" },
  { "jbrofuzz", "urxvt -e sh -c 'jbrofuzz ; bash'" },
  { "jok3r", "urxvt -e sh -c 'jok3r -h ; bash'" },
  { "joomlavs", "urxvt -e sh -c 'joomlavs ; bash'" },
  { "jsql-injection", "urxvt -e sh -c 'jsql-injection ; bash'" },
  { "kitty-tool", "urxvt -e sh -c 'kitty-tool -h ; bash'" },
  { "kitty-web-client", "urxvt -e sh -c 'kitty-web-client -h ; bash'" },
  { "leviathan", "urxvt -e sh -c 'leviathan ; bash'" },
  { "lfi-autopwn", "urxvt -e sh -c 'lfi-autopwn ; bash'" },
  { "lfi-scanner", "urxvt -e sh -c 'lfi-scanner -h ; bash'" },
  { "lfimap", "urxvt -e sh -c 'lfimap -h ; bash'" },
  { "liffy", "urxvt -e sh -c 'liffy -h ; bash'" },
  { "lbb.db", "urxvt -e sh -c 'lbb.db ; bash'" },
  { "littleblackbox", "urxvt -e sh -c 'littleblackbox -h ; bash'" },
  { "maligno-clientgen", "urxvt -e sh -c 'maligno-clientgen ; bash'" },
  { "maligno-srv", "urxvt -e sh -c 'maligno-srv ; bash'" },
  { "malybuzz", "urxvt -e sh -c 'malybuzz -h ; bash'" },
  { "manul", "urxvt -e sh -c 'manul -h ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "mdk3", "urxvt -e sh -c 'mdk3 --help ; bash'" },
  { "mdk4", "urxvt -e sh -c 'mdk4 --help ; bash'" },
  { "melkor", "urxvt -e sh -c 'melkor -h ; bash'" },
  { "msf-ws.ru", "urxvt -e sh -c 'msf-ws.ru ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfdb", "urxvt -e sh -c 'msfdb ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfelfscan", "urxvt -e sh -c 'msfelfscan -h ; bash'" },
  { "msfmachscan", "urxvt -e sh -c 'msfmachscan -h ; bash'" },
  { "msfpescan", "urxvt -e sh -c 'msfpescan -h ; bash'" },
  { "msfrop", "urxvt -e sh -c 'msfrop -h ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfupdate", "urxvt -e sh -c 'msfupdate -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "expressInstall.swf", "urxvt -e sh -c 'expressInstall.swf ; bash'" },
  { "stty", "urxvt -e sh -c 'stty ; bash'" },
  { "mitm6", "urxvt -e sh -c 'mitm6 -h ; bash'" },
  { "mongoaudit", "urxvt -e sh -c 'mongoaudit -h ; bash'" },
  { "netzob", "urxvt -e sh -c 'netzob -h ; bash'" },
  { "nikto", "urxvt -e sh -c 'nikto -H ; bash'" },
  { "nili", "urxvt -e sh -c 'nili ; bash'" },
  { "nimbostratus", "urxvt -e sh -c 'nimbostratus -h ; bash'" },
  { "notspikefile", "urxvt -e sh -c 'notspikefile ; bash'" },
  { "nsoq", "urxvt -e sh -c 'nsoq ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "ohrwurm", "urxvt -e sh -c 'ohrwurm -h ; bash'" },
  { "greenbone-nvt-sync", "urxvt -e sh -c 'greenbone-nvt-sync -h ; bash'" },
  { "openvas-nasl", "urxvt -e sh -c 'openvas-nasl ; bash'" },
  { "openvas-nasl-lint", "urxvt -e sh -c 'openvas-nasl-lint ; bash'" },
  { "openvassd", "urxvt -e sh -c 'openvassd -h ; bash'" },
  { "oscanner", "urxvt -e sh -c 'oscanner -h ; bash'" },
  { "reportviewer", "urxvt -e sh -c 'reportviewer -h ; bash'" },
  { "owtf", "urxvt -e sh -c 'owtf ; bash'" },
  { "parampampam", "urxvt -e sh -c 'parampampam -h ; bash'" },
  { "peach", "urxvt -e sh -c 'peach -h ; bash'" },
  { "xed", "urxvt -e sh -c 'xed ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "peach-fuzz", "urxvt -e sh -c 'peach-fuzz -h ; bash'" },
  { "pentbox", "urxvt -e sh -c 'pentbox ; bash'" },
  { "pmcma", "urxvt -e sh -c 'pmcma ; bash'" },
  { "portmanteau", "urxvt -e sh -c 'portmanteau ; bash'" },
  { "powerfuzzer", "urxvt -e sh -c 'powerfuzzer ; bash'" },
  { "pret", "urxvt -e sh -c 'pret -h ; bash'" },
  { "profuzz", "urxvt -e sh -c 'profuzz -h ; bash'" },
  { "pulsar", "urxvt -e sh -c 'pulsar -h ; bash'" },
  { "pureblood", "urxvt -e sh -c 'pureblood ; bash'" },
  { "pyersinia", "urxvt -e sh -c 'pyersinia -h ; bash'" },
  { "pyjfuzz", "urxvt -e sh -c 'pyjfuzz -h ; bash'" },
  { "pytbull", "urxvt -e sh -c 'pytbull -h ; bash'" },
  { "qark", "urxvt -e sh -c 'qark ; bash'" },
  { "radamsa", "urxvt -e sh -c 'radamsa -h ; bash'" },
  { "rapidscan", "urxvt -e sh -c 'rapidscan ; bash'" },
  { "ratproxy", "urxvt -e sh -c 'ratproxy -h ; bash'" },
  { "responder", "urxvt -e sh -c 'responder -h ; bash'" },
  { "responder-dhcp", "urxvt -e sh -c 'responder-dhcp ; bash'" },
  { "responder-dhcp-auto", "urxvt -e sh -c 'responder-dhcp-auto ; bash'" },
  { "responder-findsqlsrv", "urxvt -e sh -c 'responder-findsqlsrv ; bash'" },
  { "responder-icmp-redirect", "urxvt -e sh -c 'responder-icmp-redirect ; bash'" },
  { "responder-multirelay", "urxvt -e sh -c 'responder-multirelay ; bash'" },
  { "responder-report", "urxvt -e sh -c 'responder-report ; bash'" },
  { "responder-runfinger", "urxvt -e sh -c 'responder-runfinger ; bash'" },
  { "responder-secretsdump", "urxvt -e sh -c 'responder-secretsdump ; bash'" },
  { "Runas.c", "urxvt -e sh -c 'Runas.c ; bash'" },
  { "Syssvc.c", "urxvt -e sh -c 'Syssvc.c ; bash'" },
  { "restler-fuzzer", "urxvt -e sh -c 'restler-fuzzer -h ; bash'" },
  { "s3-fuzzer", "urxvt -e sh -c 's3-fuzzer --help ; bash'" },
  { "samesame", "urxvt -e sh -c 'samesame -h ; bash'" },
  { "sifter", "urxvt -e sh -c 'sifter -h ; bash'" },
  { "summarize", "urxvt -e sh -c 'summarize ; bash'" },
  { "sb0x", "urxvt -e sh -c 'sb0x -h ; bash'" },
  { "scout2", "urxvt -e sh -c 'scout2 -h ; bash'" },
  { "sfo", "urxvt -e sh -c 'sfo ; bash'" },
  { "sfuzz", "urxvt -e sh -c 'sfuzz -h ; bash'" },
  { "shortfuzzy", "urxvt -e sh -c 'shortfuzzy -h ; bash'" },
  { "sfscandiff", "urxvt -e sh -c 'sfscandiff -h ; bash'" },
  { "sloth", "urxvt -e sh -c 'sloth ; bash'" },
  { "smartphone-pentest-framework", "urxvt -e sh -c 'smartphone-pentest-framework -h ; bash'" },
  { "ar", "urxvt -e sh -c 'ar ; bash'" },
  { "as", "urxvt -e sh -c 'as --help ; bash'" },
  { "c++", "urxvt -e sh -c 'c++ ; bash'" },
  { "g++", "urxvt -e sh -c 'g++ ; bash'" },
  { "gcc", "urxvt -e sh -c 'gcc ; bash'" },
  { "ld", "urxvt -e sh -c 'ld ; bash'" },
  { "nm", "urxvt -e sh -c 'nm -h ; bash'" },
  { "objdump", "urxvt -e sh -c 'objdump ; bash'" },
  { "ranlib", "urxvt -e sh -c 'ranlib ; bash'" },
  { "strip", "urxvt -e sh -c 'strip ; bash'" },
  { "arm-linux-androideabi-addr2line", "urxvt -e sh -c 'arm-linux-androideabi-addr2line ; bash'" },
  { "arm-linux-androideabi-ar", "urxvt -e sh -c 'arm-linux-androideabi-ar ; bash'" },
  { "arm-linux-androideabi-as", "urxvt -e sh -c 'arm-linux-androideabi-as ; bash'" },
  { "arm-linux-androideabi-c++", "urxvt -e sh -c 'arm-linux-androideabi-c++ ; bash'" },
  { "arm-linux-androideabi-c++filt", "urxvt -e sh -c 'arm-linux-androideabi-c++filt ; bash'" },
  { "arm-linux-androideabi-cpp", "urxvt -e sh -c 'arm-linux-androideabi-cpp ; bash'" },
  { "arm-linux-androideabi-elfedit", "urxvt -e sh -c 'arm-linux-androideabi-elfedit ; bash'" },
  { "arm-linux-androideabi-g++", "urxvt -e sh -c 'arm-linux-androideabi-g++ ; bash'" },
  { "arm-linux-androideabi-gcc", "urxvt -e sh -c 'arm-linux-androideabi-gcc ; bash'" },
  { "arm-linux-androideabi-gcc-4.6", "urxvt -e sh -c 'arm-linux-androideabi-gcc-4.6 ; bash'" },
  { "arm-linux-androideabi-gcov", "urxvt -e sh -c 'arm-linux-androideabi-gcov ; bash'" },
  { "arm-linux-androideabi-gdb", "urxvt -e sh -c 'arm-linux-androideabi-gdb ; bash'" },
  { "arm-linux-androideabi-gdbtui", "urxvt -e sh -c 'arm-linux-androideabi-gdbtui ; bash'" },
  { "arm-linux-androideabi-gprof", "urxvt -e sh -c 'arm-linux-androideabi-gprof ; bash'" },
  { "arm-linux-androideabi-ld", "urxvt -e sh -c 'arm-linux-androideabi-ld ; bash'" },
  { "arm-linux-androideabi-nm", "urxvt -e sh -c 'arm-linux-androideabi-nm ; bash'" },
  { "arm-linux-androideabi-objdump", "urxvt -e sh -c 'arm-linux-androideabi-objdump ; bash'" },
  { "arm-linux-androideabi-ranlib", "urxvt -e sh -c 'arm-linux-androideabi-ranlib ; bash'" },
  { "arm-linux-androideabi-readelf", "urxvt -e sh -c 'arm-linux-androideabi-readelf ; bash'" },
  { "arm-linux-androideabi-run", "urxvt -e sh -c 'arm-linux-androideabi-run ; bash'" },
  { "arm-linux-androideabi-size", "urxvt -e sh -c 'arm-linux-androideabi-size ; bash'" },
  { "arm-linux-androideabi-strings", "urxvt -e sh -c 'arm-linux-androideabi-strings ; bash'" },
  { "arm-linux-androideabi-strip", "urxvt -e sh -c 'arm-linux-androideabi-strip ; bash'" },
  { "smod", "urxvt -e sh -c 'smod ; bash'" },
  { "smtp-fuzz", "urxvt -e sh -c 'smtp-fuzz ; bash'" },
  { "smtptx", "urxvt -e sh -c 'smtptx -h ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "snmp-fuzzer", "urxvt -e sh -c 'snmp-fuzzer ; bash'" },
  { "soapui", "urxvt -e sh -c 'soapui ; bash'" },
  { "soapui-errors.log", "urxvt -e sh -c 'soapui-errors.log ; bash'" },
  { "soapui.log", "urxvt -e sh -c 'soapui.log ; bash'" },
  { "starter-page.html", "urxvt -e sh -c 'starter-page.html ; bash'" },
  { "socketfuzz", "urxvt -e sh -c 'socketfuzz -h ; bash'" },
  { "spaf", "urxvt -e sh -c 'spaf -h ; bash'" },
  { "spartan", "urxvt -e sh -c 'spartan -h ; bash'" },
  { "spiderpig-pdffuzzer", "urxvt -e sh -c 'spiderpig-pdffuzzer ; bash'" },
  { "spike-fuzzer-citrix", "urxvt -e sh -c 'spike-fuzzer-citrix ; bash'" },
  { "spike-fuzzer-closed-source_web_server_fuzz", "urxvt -e sh -c 'spike-fuzzer-closed-source_web_server_fuzz ; bash'" },
  { "spike-fuzzer-dceoversmb", "urxvt -e sh -c 'spike-fuzzer-dceoversmb ; bash'" },
  { "spike-fuzzer-dltest", "urxvt -e sh -c 'spike-fuzzer-dltest ; bash'" },
  { "spike-fuzzer-do-post", "urxvt -e sh -c 'spike-fuzzer-do-post ; bash'" },
  { "spike-fuzzer-generic-chunked", "urxvt -e sh -c 'spike-fuzzer-generic-chunked ; bash'" },
  { "spike-fuzzer-generic-listen_tcp", "urxvt -e sh -c 'spike-fuzzer-generic-listen_tcp ; bash'" },
  { "spike-fuzzer-generic-send_tcp", "urxvt -e sh -c 'spike-fuzzer-generic-send_tcp ; bash'" },
  { "spike-fuzzer-generic-send_udp", "urxvt -e sh -c 'spike-fuzzer-generic-send_udp ; bash'" },
  { "spike-fuzzer-generic-web_server_fuzz", "urxvt -e sh -c 'spike-fuzzer-generic-web_server_fuzz ; bash'" },
  { "spike-fuzzer-generic-web_server_fuzz2", "urxvt -e sh -c 'spike-fuzzer-generic-web_server_fuzz2 ; bash'" },
  { "spike-fuzzer-gopherd", "urxvt -e sh -c 'spike-fuzzer-gopherd ; bash'" },
  { "spike-fuzzer-halflife", "urxvt -e sh -c 'spike-fuzzer-halflife ; bash'" },
  { "spike-fuzzer-line-send_tcp", "urxvt -e sh -c 'spike-fuzzer-line-send_tcp ; bash'" },
  { "spike-fuzzer-msrpcfuzz", "urxvt -e sh -c 'spike-fuzzer-msrpcfuzz ; bash'" },
  { "spike-fuzzer-msrpcfuzz-udp", "urxvt -e sh -c 'spike-fuzzer-msrpcfuzz-udp ; bash'" },
  { "spike-fuzzer-ntlm-brute", "urxvt -e sh -c 'spike-fuzzer-ntlm-brute ; bash'" },
  { "spike-fuzzer-ntlm2", "urxvt -e sh -c 'spike-fuzzer-ntlm2 ; bash'" },
  { "spike-fuzzer-pmspike", "urxvt -e sh -c 'spike-fuzzer-pmspike ; bash'" },
  { "spike-fuzzer-post-fuzz", "urxvt -e sh -c 'spike-fuzzer-post-fuzz ; bash'" },
  { "spike-fuzzer-post-spike", "urxvt -e sh -c 'spike-fuzzer-post-spike ; bash'" },
  { "spike-fuzzer-quake", "urxvt -e sh -c 'spike-fuzzer-quake ; bash'" },
  { "spike-fuzzer-quakeserver", "urxvt -e sh -c 'spike-fuzzer-quakeserver ; bash'" },
  { "spike-fuzzer-sendmsrpc", "urxvt -e sh -c 'spike-fuzzer-sendmsrpc ; bash'" },
  { "spike-fuzzer-ss-spike", "urxvt -e sh -c 'spike-fuzzer-ss-spike ; bash'" },
  { "spike-fuzzer-statd-spike", "urxvt -e sh -c 'spike-fuzzer-statd-spike ; bash'" },
  { "spike-fuzzer-sunrpcfuzz", "urxvt -e sh -c 'spike-fuzzer-sunrpcfuzz ; bash'" },
  { "spike-fuzzer-webfuzz", "urxvt -e sh -c 'spike-fuzzer-webfuzz ; bash'" },
  { "spike-fuzzer-x11-spike", "urxvt -e sh -c 'spike-fuzzer-x11-spike ; bash'" },
  { "qtmsfconsole", "urxvt -e sh -c 'qtmsfconsole ; bash'" },
  { "sqlbrute", "urxvt -e sh -c 'sqlbrute -h ; bash'" },
  { "sqlmap", "urxvt -e sh -c 'sqlmap -hh ; bash'" },
  { "sqlmapapi", "urxvt -e sh -c 'sqlmapapi ; bash'" },
  { "sqlmap", "urxvt -e sh -c 'sqlmap -hh ; bash'" },
  { "sqlmapapi", "urxvt -e sh -c 'sqlmapapi ; bash'" },
  { "sqlninja", "urxvt -e sh -c 'sqlninja -h ; bash'" },
  { "ssrfmap", "urxvt -e sh -c 'ssrfmap -h ; bash'" },
  { "taof", "urxvt -e sh -c 'taof ; bash'" },
  { "tcpcontrol-fuzzer", "urxvt -e sh -c 'tcpcontrol-fuzzer ; bash'" },
  { "tcpjunk", "urxvt -e sh -c 'tcpjunk -h ; bash'" },
  { "termineter", "urxvt -e sh -c 'termineter -h ; bash'" },
  { "tftp-fuzz", "urxvt -e sh -c 'tftp-fuzz -h ; bash'" },
  { "thefuzz", "urxvt -e sh -c 'thefuzz -h ; bash'" },
  { "trinity", "urxvt -e sh -c 'trinity -h ; bash'" },
  { "udsim", "urxvt -e sh -c 'udsim -h ; bash'" },
  { "umap", "urxvt -e sh -c 'umap -h ; bash'" },
  { "unifuzzer", "urxvt -e sh -c 'unifuzzer ; bash'" },
  { "uniofuzz", "urxvt -e sh -c 'uniofuzz -h ; bash'" },
  { "uniscan", "urxvt -e sh -c 'uniscan --help ; bash'" },
  { "uppwn", "urxvt -e sh -c 'uppwn -h ; bash'" },
  { "vane", "urxvt -e sh -c 'vane -h ; bash'" },
  { "vbscan", "urxvt -e sh -c 'vbscan ; bash'" },
  { "vsaudit", "urxvt -e sh -c 'vsaudit ; bash'" },
  { "w13scan", "urxvt -e sh -c 'w13scan -h ; bash'" },
  { "w3af", "urxvt -e sh -c 'w3af -h ; bash'" },
  { "w3af-gui", "urxvt -e sh -c 'w3af-gui ; bash'" },
  { "wafninja", "urxvt -e sh -c 'wafninja -h ; bash'" },
  { "wafpass", "urxvt -e sh -c 'wafpass -h ; bash'" },
  { "wapiti", "urxvt -e sh -c 'wapiti -h ; bash'" },
  { "wapiti-getcookie", "urxvt -e sh -c 'wapiti-getcookie -h ; bash'" },
  { "webscarab", "urxvt -e sh -c 'webscarab ; bash'" },
  { "weirdaal", "urxvt -e sh -c 'weirdaal -h ; bash'" },
  { "wfencode", "urxvt -e sh -c 'wfencode ; bash'" },
  { "wfpayload", "urxvt -e sh -c 'wfpayload ; bash'" },
  { "wfuzz", "urxvt -e sh -c 'wfuzz ; bash'" },
  { "wxfuzz", "urxvt -e sh -c 'wxfuzz ; bash'" },
  { "witchxtool", "urxvt -e sh -c 'witchxtool -h ; bash'" },
  { "wsfuzzer", "urxvt -e sh -c 'wsfuzzer ; bash'" },
  { "xspear", "urxvt -e sh -c 'xspear -h ; bash'" },
  { "console", "urxvt -e sh -c 'console ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "xss-freak", "urxvt -e sh -c 'xss-freak -h ; bash'" },
  { "xsser", "urxvt -e sh -c 'xsser -h ; bash'" },
  { "xsss", "urxvt -e sh -c 'xsss ; bash'" },
  { "xssscan", "urxvt -e sh -c 'xssscan -h ; bash'" },
  { "xsssniper", "urxvt -e sh -c 'xsssniper -h ; bash'" },
  { "yawast", "urxvt -e sh -c 'yawast -h ; bash'" },
  { "zaproxy", "urxvt -e sh -c 'zaproxy ; bash'" },
  { "zzat", "urxvt -e sh -c 'zzat ; bash'" },
  { "zzuf", "urxvt -e sh -c 'zzuf -h ; bash'" },
  { "zzat", "urxvt -e sh -c 'zzat ; bash'" },
  { "zzuf", "urxvt -e sh -c 'zzuf -h ; bash'" },
}

gpumenu = {
}

hardwaremenu = {
  { "arduino", "urxvt -e sh -c 'arduino ; bash'" },
  { "chamlog", "urxvt -e sh -c 'chamlog -h ; bash'" },
  { "chamtool", "urxvt -e sh -c 'chamtool -h ; bash'" },
  { "d2j-asm-verify", "urxvt -e sh -c 'd2j-asm-verify ; bash'" },
  { "d2j-baksmali", "urxvt -e sh -c 'd2j-baksmali ; bash'" },
  { "d2j-decrypt-string", "urxvt -e sh -c 'd2j-decrypt-string ; bash'" },
  { "d2j-smali", "urxvt -e sh -c 'd2j-smali ; bash'" },
  { "hdmi-sniff", "urxvt -e sh -c 'hdmi-sniff -h ; bash'" },
  { "honggfuzz", "urxvt -e sh -c 'honggfuzz -h ; bash'" },
  { "incept", "urxvt -e sh -c 'incept ; bash'" },
  { "kautilya", "urxvt -e sh -c 'kautilya ; bash'" },
  { "kraken", "urxvt -e sh -c 'kraken -h ; bash'" },
  { "marc4dasm", "urxvt -e sh -c 'marc4dasm -h ; bash'" },
  { "pcileech", "urxvt -e sh -c 'pcileech ; bash'" },
  { "rtlamr", "urxvt -e sh -c 'rtlamr -h ; bash'" },
  { "sifter", "urxvt -e sh -c 'sifter -h ; bash'" },
  { "summarize", "urxvt -e sh -c 'summarize ; bash'" },
  { "baksmali", "urxvt -e sh -c 'baksmali -h ; bash'" },
  { "smali", "urxvt -e sh -c 'smali -h ; bash'" },
  { "baksmali", "urxvt -e sh -c 'baksmali -h ; bash'" },
  { "smali", "urxvt -e sh -c 'smali -h ; bash'" },
}

honeypotmenu = {
  { "artillery", "urxvt -e sh -c 'artillery ; bash'" },
  { "beeswarm", "urxvt -e sh -c 'beeswarm ; bash'" },
  { "bluepot", "urxvt -e sh -c 'bluepot ; bash'" },
  { "conpot", "urxvt -e sh -c 'conpot --help ; bash'" },
  { "fakeap", "urxvt -e sh -c 'fakeap ; bash'" },
  { "fakenetbiosdgm", "urxvt -e sh -c 'fakenetbiosdgm -h ; bash'" },
  { "fakenetbiosns", "urxvt -e sh -c 'fakenetbiosns -h ; bash'" },
  { "fiked", "urxvt -e sh -c 'fiked ; bash'" },
  { "heartbleed-honeypot", "urxvt -e sh -c 'heartbleed-honeypot -h ; bash'" },
  { "honeyd", "urxvt -e sh -c 'honeyd -h ; bash'" },
  { "honeydctl", "urxvt -e sh -c 'honeydctl -h ; bash'" },
  { "honeydstats", "urxvt -e sh -c 'honeydstats -h ; bash'" },
  { "hsniff", "urxvt -e sh -c 'hsniff -h ; bash'" },
  { "hpfeeds", "urxvt -e sh -c 'hpfeeds -h ; bash'" },
  { "hpfeeds-broker", "urxvt -e sh -c 'hpfeeds-broker ; bash'" },
  { "inetsim", "urxvt -e sh -c 'inetsim --help ; bash'" },
  { "df", "urxvt -e sh -c 'df ; bash'" },
  { "dmesg", "urxvt -e sh -c 'dmesg ; bash'" },
  { "mount", "urxvt -e sh -c 'mount ; bash'" },
  { "ulimit", "urxvt -e sh -c 'ulimit ; bash'" },
  { "emacs", "urxvt -e sh -c 'emacs ; bash'" },
  { "free", "urxvt -e sh -c 'free ; bash'" },
  { "killall", "urxvt -e sh -c 'killall ; bash'" },
  { "locate", "urxvt -e sh -c 'locate ; bash'" },
  { "nano", "urxvt -e sh -c 'nano ; bash'" },
  { "nohup", "urxvt -e sh -c 'nohup ; bash'" },
  { "pico", "urxvt -e sh -c 'pico ; bash'" },
  { "top", "urxvt -e sh -c 'top ; bash'" },
  { "vi", "urxvt -e sh -c 'vi ; bash'" },
  { "vim", "urxvt -e sh -c 'vim ; bash'" },
  { "vipw", "urxvt -e sh -c 'vipw ; bash'" },
  { "clone", "urxvt -e sh -c 'clone ; bash'" },
  { "snare", "urxvt -e sh -c 'snare -h ; bash'" },
  { "wifi-honey", "urxvt -e sh -c 'wifi-honey -h ; bash'" },
  { "wordpot", "urxvt -e sh -c 'wordpot -h ; bash'" },
}

idsmenu = {
  { "sagan", "urxvt -e sh -c 'sagan -h ; bash'" },
  { "snort", "urxvt -e sh -c 'snort -h ; bash'" },
  { "u2boat", "urxvt -e sh -c 'u2boat ; bash'" },
  { "u2spewfoo", "urxvt -e sh -c 'u2spewfoo ; bash'" },
  { "u2streamer", "urxvt -e sh -c 'u2streamer ; bash'" },
  { "suricata", "urxvt -e sh -c 'suricata ; bash'" },
  { "suricatactl", "urxvt -e sh -c 'suricatactl ; bash'" },
  { "suricatasc", "urxvt -e sh -c 'suricatasc ; bash'" },
  { "suricata-verify", "urxvt -e sh -c 'suricata-verify ; bash'" },
}

keyloggermenu = {
  { "llk", "urxvt -e sh -c 'llk ; bash'" },
  { "llkk", "urxvt -e sh -c 'llkk ; bash'" },
}

malwaremenu = {
  { "androarsc", "urxvt -e sh -c 'androarsc ; bash'" },
  { "androcg", "urxvt -e sh -c 'androcg ; bash'" },
  { "androdd", "urxvt -e sh -c 'androdd ; bash'" },
  { "androdis", "urxvt -e sh -c 'androdis ; bash'" },
  { "androguard", "urxvt -e sh -c 'androguard -h ; bash'" },
  { "androgui", "urxvt -e sh -c 'androgui ; bash'" },
  { "androlyze", "urxvt -e sh -c 'androlyze ; bash'" },
  { "androsign", "urxvt -e sh -c 'androsign ; bash'" },
  { "attk-cli", "urxvt -e sh -c 'attk-cli -h ; bash'" },
  { "attk-tui", "urxvt -e sh -c 'attk-tui -h ; bash'" },
  { "balbuzard", "urxvt -e sh -c 'balbuzard ; bash'" },
  { "bbcrack", "urxvt -e sh -c 'bbcrack ; bash'" },
  { "bbharvest", "urxvt -e sh -c 'bbharvest ; bash'" },
  { "bbtrans", "urxvt -e sh -c 'bbtrans ; bash'" },
  { "bamfbrute", "urxvt -e sh -c 'bamfbrute -h ; bash'" },
  { "bamfdetect", "urxvt -e sh -c 'bamfdetect -h ; bash'" },
  { "bdlogparser", "urxvt -e sh -c 'bdlogparser ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "vm2", "urxvt -e sh -c 'vm2 ; bash'" },
  { "captipper", "urxvt -e sh -c 'captipper ; bash'" },
  { "clamscanlogparser", "urxvt -e sh -c 'clamscanlogparser ; bash'" },
  { "cuckoo", "urxvt -e sh -c 'cuckoo ; bash'" },
  { "damm", "urxvt -e sh -c 'damm -h ; bash'" },
  { "darkarmour", "urxvt -e sh -c 'darkarmour ; bash'" },
  { "depdep", "urxvt -e sh -c 'depdep -h ; bash'" },
  { "fakenet", "urxvt -e sh -c 'fakenet -h ; bash'" },
  { "fileintel", "urxvt -e sh -c 'fileintel -h ; bash'" },
  { "floss", "urxvt -e sh -c 'floss -h ; bash'" },
  { "fprotlogparser", "urxvt -e sh -c 'fprotlogparser ; bash'" },
  { "gcat", "urxvt -e sh -c 'gcat --help ; bash'" },
  { "malboxes", "urxvt -e sh -c 'malboxes -h ; bash'" },
  { "malcom", "urxvt -e sh -c 'malcom -h ; bash'" },
  { "malheur", "urxvt -e sh -c 'malheur -h ; bash'" },
  { "malmon", "urxvt -e sh -c 'malmon -h ; bash'" },
  { "malmon-scan", "urxvt -e sh -c 'malmon-scan ; bash'" },
  { "malscan", "urxvt -e sh -c 'malscan ; bash'" },
  { "maltrieve", "urxvt -e sh -c 'maltrieve -h ; bash'" },
  { "maltrievecategorizer", "urxvt -e sh -c 'maltrievecategorizer ; bash'" },
  { "malware-check", "urxvt -e sh -c 'malware-check ; bash'" },
  { "malwaredetect", "urxvt -e sh -c 'malwaredetect ; bash'" },
  { "msf-mpc", "urxvt -e sh -c 'msf-mpc -h ; bash'" },
  { "noriben", "urxvt -e sh -c 'noriben -h ; bash'" },
  { "noriben-sandbox", "urxvt -e sh -c 'noriben-sandbox -h ; bash'" },
  { "oledump", "urxvt -e sh -c 'oledump -h ; bash'" },
  { "pdf2pdfa", "urxvt -e sh -c 'pdf2pdfa ; bash'" },
  { "pdf2ruby", "urxvt -e sh -c 'pdf2ruby ; bash'" },
  { "pdfcop", "urxvt -e sh -c 'pdfcop ; bash'" },
  { "pdfdecompress", "urxvt -e sh -c 'pdfdecompress ; bash'" },
  { "pdfdecrypt", "urxvt -e sh -c 'pdfdecrypt ; bash'" },
  { "pdfencrypt", "urxvt -e sh -c 'pdfencrypt ; bash'" },
  { "pdfextract", "urxvt -e sh -c 'pdfextract ; bash'" },
  { "pdfmetadata", "urxvt -e sh -c 'pdfmetadata ; bash'" },
  { "pdblaster", "urxvt -e sh -c 'pdblaster -h ; bash'" },
  { "peepdf", "urxvt -e sh -c 'peepdf -h ; bash'" },
  { "peframe", "urxvt -e sh -c 'peframe ; bash'" },
  { "pepper", "urxvt -e sh -c 'pepper -h ; bash'" },
  { "pftriage", "urxvt -e sh -c 'pftriage -h ; bash'" },
  { "polyswarm", "urxvt -e sh -c 'polyswarm -h ; bash'" },
  { "pyew", "urxvt -e sh -c 'pyew -h ; bash'" },
  { "mmbot", "urxvt -e sh -c 'mmbot -h ; bash'" },
  { "peepdf2", "urxvt -e sh -c 'peepdf2 ; bash'" },
  { "quark", "urxvt -e sh -c 'quark --help ; bash'" },
  { "sea", "urxvt -e sh -c 'sea -h ; bash'" },
  { "ssma", "urxvt -e sh -c 'ssma -h ; bash'" },
  { "thezoo", "urxvt -e sh -c 'thezoo -h ; bash'" },
  { "vba2graph", "urxvt -e sh -c 'vba2graph -h ; bash'" },
  { "viper", "urxvt -e sh -c 'viper -h ; bash'" },
  { "virustotal", "urxvt -e sh -c 'virustotal ; bash'" },
  { "vmcloak", "urxvt -e sh -c 'vmcloak -h ; bash'" },
  { "vmcloak-iptables", "urxvt -e sh -c 'vmcloak-iptables -h ; bash'" },
  { "vmcloak-killvbox", "urxvt -e sh -c 'vmcloak-killvbox -h ; bash'" },
  { "vmcloak-removevms", "urxvt -e sh -c 'vmcloak-removevms -h ; bash'" },
  { "vmcloak-vboxnet0", "urxvt -e sh -c 'vmcloak-vboxnet0 -h ; bash'" },
  { "yara", "urxvt -e sh -c 'yara -h ; bash'" },
  { "yarac", "urxvt -e sh -c 'yarac -h ; bash'" },
  { "yara", "urxvt -e sh -c 'yara -h ; bash'" },
  { "yarac", "urxvt -e sh -c 'yarac -h ; bash'" },
}

miscmenu = {
  { "afp_client", "urxvt -e sh -c 'afp_client ; bash'" },
  { "afpfs", "urxvt -e sh -c 'afpfs ; bash'" },
  { "afpfsd", "urxvt -e sh -c 'afpfsd -h ; bash'" },
  { "afpgetstatus", "urxvt -e sh -c 'afpgetstatus ; bash'" },
  { "mount_afp", "urxvt -e sh -c 'mount_afp ; bash'" },
  { "afp_client", "urxvt -e sh -c 'afp_client ; bash'" },
  { "afpfs", "urxvt -e sh -c 'afpfs ; bash'" },
  { "afpfsd", "urxvt -e sh -c 'afpfsd -h ; bash'" },
  { "afpgetstatus", "urxvt -e sh -c 'afpgetstatus ; bash'" },
  { "mount_afp", "urxvt -e sh -c 'mount_afp ; bash'" },
  { "apkleaks", "urxvt -e sh -c 'apkleaks -h ; bash'" },
  { "archivebox", "urxvt -e sh -c 'archivebox -h ; bash'" },
  { "archive", "urxvt -e sh -c 'archive ; bash'" },
  { "iarybo", "urxvt -e sh -c 'iarybo ; bash'" },
  { "avml", "urxvt -e sh -c 'avml -h ; bash'" },
  { "base64dump", "urxvt -e sh -c 'base64dump -h ; bash'" },
  { "bless", "urxvt -e sh -c 'bless ; bash'" },
  { "BEViewer", "urxvt -e sh -c 'BEViewer -h ; bash'" },
  { "bulk_extractor", "urxvt -e sh -c 'bulk_extractor ; bash'" },
  { "plugin_test", "urxvt -e sh -c 'plugin_test ; bash'" },
  { "bmore", "urxvt -e sh -c 'bmore ; bash'" },
  { "bvedit", "urxvt -e sh -c 'bvedit -h ; bash'" },
  { "bvi", "urxvt -e sh -c 'bvi -h ; bash'" },
  { "bview", "urxvt -e sh -c 'bview -h ; bash'" },
  { "centry", "urxvt -e sh -c 'centry -h ; bash'" },
  { "checkiban", "urxvt -e sh -c 'checkiban -h ; bash'" },
  { "cloakify", "urxvt -e sh -c 'cloakify ; bash'" },
  { "decloakify", "urxvt -e sh -c 'decloakify ; bash'" },
  { "credmap", "urxvt -e sh -c 'credmap -h ; bash'" },
  { "ct-ng", "urxvt -e sh -c 'ct-ng -h ; bash'" },
  { "ctf-party", "urxvt -e sh -c 'ctf-party ; bash'" },
  { "ctf_party_console", "urxvt -e sh -c 'ctf_party_console ; bash'" },
  { "cve-api", "urxvt -e sh -c 'cve-api -h ; bash'" },
  { "dbd", "urxvt -e sh -c 'dbd -h ; bash'" },
  { "decodify", "urxvt -e sh -c 'decodify -h ; bash'" },
  { "deen", "urxvt -e sh -c 'deen ; bash'" },
  { "densityscout", "urxvt -e sh -c 'densityscout -h ; bash'" },
  { "depix", "urxvt -e sh -c 'depix -h ; bash'" },
  { "det", "urxvt -e sh -c 'det -h ; bash'" },
  { "dhcdrop", "urxvt -e sh -c 'dhcdrop -h ; bash'" },
  { "dmg2img", "urxvt -e sh -c 'dmg2img ; bash'" },
  { "vfdecrypt", "urxvt -e sh -c 'vfdecrypt ; bash'" },
  { "dmg2img", "urxvt -e sh -c 'dmg2img ; bash'" },
  { "vfdecrypt", "urxvt -e sh -c 'vfdecrypt ; bash'" },
  { "dnsfilexfer-recv", "urxvt -e sh -c 'dnsfilexfer-recv -h ; bash'" },
  { "dnsfilexfer-send", "urxvt -e sh -c 'dnsfilexfer-send -h ; bash'" },
  { "dnsvalidator", "urxvt -e sh -c 'dnsvalidator -h ; bash'" },
  { "domlink", "urxvt -e sh -c 'domlink ; bash'" },
  { "dradis-ce", "urxvt -e sh -c 'dradis-ce ; bash'" },
  { "rails", "urxvt -e sh -c 'rails ; bash'" },
  { "rake", "urxvt -e sh -c 'rake ; bash'" },
  { "rspec", "urxvt -e sh -c 'rspec ; bash'" },
  { "rubocop-ci", "urxvt -e sh -c 'rubocop-ci ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "spring", "urxvt -e sh -c 'spring ; bash'" },
  { "yarn", "urxvt -e sh -c 'yarn ; bash'" },
  { "dsd", "urxvt -e sh -c 'dsd -h ; bash'" },
  { "dump1090", "urxvt -e sh -c 'dump1090 -h ; bash'" },
  { "elettra", "urxvt -e sh -c 'elettra ; bash'" },
  { "elettra-gui", "urxvt -e sh -c 'elettra-gui ; bash'" },
  { "ent", "urxvt -e sh -c 'ent ; bash'" },
  { "evilgrade", "urxvt -e sh -c 'evilgrade ; bash'" },
  { "evillimiter", "urxvt -e sh -c 'evillimiter -h ; bash'" },
  { "exrex", "urxvt -e sh -c 'exrex -h ; bash'" },
  { "eh", "urxvt -e sh -c 'eh -h ; bash'" },
  { "eyeballer", "urxvt -e sh -c 'eyeballer -h ; bash'" },
  { "eyewitness", "urxvt -e sh -c 'eyewitness -h ; bash'" },
  { "dismissauth.xpi", "urxvt -e sh -c 'dismissauth.xpi ; bash'" },
  { "fakemail", "urxvt -e sh -c 'fakemail -h ; bash'" },
  { "faraday-manage", "urxvt -e sh -c 'faraday-manage ; bash'" },
  { "faraday-searcher", "urxvt -e sh -c 'faraday-searcher ; bash'" },
  { "faraday-server", "urxvt -e sh -c 'faraday-server ; bash'" },
  { "firefox-security-toolkit", "urxvt -e sh -c 'firefox-security-toolkit ; bash'" },
  { "flare", "urxvt -e sh -c 'flare -h ; bash'" },
  { "fstealer", "urxvt -e sh -c 'fstealer -h ; bash'" },
  { "genlist", "urxvt -e sh -c 'genlist ; bash'" },
  { "geoipgen", "urxvt -e sh -c 'geoipgen -h ; bash'" },
  { "gerix-wifi-cracker", "urxvt -e sh -c 'gerix-wifi-cracker ; bash'" },
  { "gg-images", "urxvt -e sh -c 'gg-images ; bash'" },
  { "githubcloner", "urxvt -e sh -c 'githubcloner -h ; bash'" },
  { "graffiti", "urxvt -e sh -c 'graffiti -h ; bash'" },
  { "grammarinator-generate", "urxvt -e sh -c 'grammarinator-generate -h ; bash'" },
  { "grammarinator-parse", "urxvt -e sh -c 'grammarinator-parse -h ; bash'" },
  { "grammarinator-process", "urxvt -e sh -c 'grammarinator-process -h ; bash'" },
  { "gtfo", "urxvt -e sh -c 'gtfo -h ; bash'" },
  { "gtfoblookup", "urxvt -e sh -c 'gtfoblookup -h ; bash'" },
  { "h2spec", "urxvt -e sh -c 'h2spec --help ; bash'" },
  { "halcyon-ide", "urxvt -e sh -c 'halcyon-ide ; bash'" },
  { "cap2hccapx", "urxvt -e sh -c 'cap2hccapx ; bash'" },
  { "cleanup-rules", "urxvt -e sh -c 'cleanup-rules ; bash'" },
  { "combipow", "urxvt -e sh -c 'combipow ; bash'" },
  { "ct3_to_ntlm", "urxvt -e sh -c 'ct3_to_ntlm ; bash'" },
  { "cutb", "urxvt -e sh -c 'cutb ; bash'" },
  { "expander", "urxvt -e sh -c 'expander ; bash'" },
  { "gate", "urxvt -e sh -c 'gate ; bash'" },
  { "generate-rules", "urxvt -e sh -c 'generate-rules ; bash'" },
  { "hcstat2gen", "urxvt -e sh -c 'hcstat2gen ; bash'" },
  { "hcstatgen", "urxvt -e sh -c 'hcstatgen ; bash'" },
  { "keyspace", "urxvt -e sh -c 'keyspace ; bash'" },
  { "len", "urxvt -e sh -c 'len ; bash'" },
  { "mli2", "urxvt -e sh -c 'mli2 ; bash'" },
  { "morph", "urxvt -e sh -c 'morph ; bash'" },
  { "permute", "urxvt -e sh -c 'permute ; bash'" },
  { "permute_exist", "urxvt -e sh -c 'permute_exist ; bash'" },
  { "prepare", "urxvt -e sh -c 'prepare ; bash'" },
  { "remaining", "urxvt -e sh -c 'remaining ; bash'" },
  { "req-exclude", "urxvt -e sh -c 'req-exclude ; bash'" },
  { "req-include", "urxvt -e sh -c 'req-include ; bash'" },
  { "rli", "urxvt -e sh -c 'rli ; bash'" },
  { "rli2", "urxvt -e sh -c 'rli2 ; bash'" },
  { "rules_optimize", "urxvt -e sh -c 'rules_optimize ; bash'" },
  { "seprule", "urxvt -e sh -c 'seprule ; bash'" },
  { "strip-bsn", "urxvt -e sh -c 'strip-bsn ; bash'" },
  { "strip-bsr", "urxvt -e sh -c 'strip-bsr ; bash'" },
  { "tmesis", "urxvt -e sh -c 'tmesis ; bash'" },
  { "tmesis-dynamic", "urxvt -e sh -c 'tmesis-dynamic ; bash'" },
  { "topmorph", "urxvt -e sh -c 'topmorph ; bash'" },
  { "cap2hccapx", "urxvt -e sh -c 'cap2hccapx ; bash'" },
  { "cleanup-rules", "urxvt -e sh -c 'cleanup-rules ; bash'" },
  { "combipow", "urxvt -e sh -c 'combipow ; bash'" },
  { "ct3_to_ntlm", "urxvt -e sh -c 'ct3_to_ntlm ; bash'" },
  { "cutb", "urxvt -e sh -c 'cutb ; bash'" },
  { "expander", "urxvt -e sh -c 'expander ; bash'" },
  { "gate", "urxvt -e sh -c 'gate ; bash'" },
  { "generate-rules", "urxvt -e sh -c 'generate-rules ; bash'" },
  { "hcstat2gen", "urxvt -e sh -c 'hcstat2gen ; bash'" },
  { "hcstatgen", "urxvt -e sh -c 'hcstatgen ; bash'" },
  { "keyspace", "urxvt -e sh -c 'keyspace ; bash'" },
  { "len", "urxvt -e sh -c 'len ; bash'" },
  { "mli2", "urxvt -e sh -c 'mli2 ; bash'" },
  { "morph", "urxvt -e sh -c 'morph ; bash'" },
  { "permute", "urxvt -e sh -c 'permute ; bash'" },
  { "permute_exist", "urxvt -e sh -c 'permute_exist ; bash'" },
  { "prepare", "urxvt -e sh -c 'prepare ; bash'" },
  { "remaining", "urxvt -e sh -c 'remaining ; bash'" },
  { "req-exclude", "urxvt -e sh -c 'req-exclude ; bash'" },
  { "req-include", "urxvt -e sh -c 'req-include ; bash'" },
  { "rli", "urxvt -e sh -c 'rli ; bash'" },
  { "rli2", "urxvt -e sh -c 'rli2 ; bash'" },
  { "rules_optimize", "urxvt -e sh -c 'rules_optimize ; bash'" },
  { "seprule", "urxvt -e sh -c 'seprule ; bash'" },
  { "strip-bsn", "urxvt -e sh -c 'strip-bsn ; bash'" },
  { "strip-bsr", "urxvt -e sh -c 'strip-bsr ; bash'" },
  { "tmesis", "urxvt -e sh -c 'tmesis ; bash'" },
  { "tmesis-dynamic", "urxvt -e sh -c 'tmesis-dynamic ; bash'" },
  { "topmorph", "urxvt -e sh -c 'topmorph ; bash'" },
  { "hexyl", "urxvt -e sh -c 'hexyl -h ; bash'" },
  { "http-put", "urxvt -e sh -c 'http-put -h ; bash'" },
  { "htsserver", "urxvt -e sh -c 'htsserver ; bash'" },
  { "httrack", "urxvt -e sh -c 'httrack -h ; bash'" },
  { "proxytrack", "urxvt -e sh -c 'proxytrack ; bash'" },
  { "webhttrack", "urxvt -e sh -c 'webhttrack ; bash'" },
  { "htsserver", "urxvt -e sh -c 'htsserver ; bash'" },
  { "httrack", "urxvt -e sh -c 'httrack -h ; bash'" },
  { "proxytrack", "urxvt -e sh -c 'proxytrack ; bash'" },
  { "webhttrack", "urxvt -e sh -c 'webhttrack ; bash'" },
  { "hurl", "urxvt -e sh -c 'hurl ; bash'" },
  { "hxd", "urxvt -e sh -c 'hxd -h ; bash'" },
  { "imagegrep", "urxvt -e sh -c 'imagegrep ; bash'" },
  { "imount", "urxvt -e sh -c 'imount -h ; bash'" },
  { "imhex", "urxvt -e sh -c 'imhex -h ; bash'" },
  { "infip", "urxvt -e sh -c 'infip -h ; bash'" },
  { "intelmq.bots.collectors.alienvault_otx.collector", "urxvt -e sh -c 'intelmq.bots.collectors.alienvault_otx.collector ; bash'" },
  { "intelmq.bots.collectors.amqp.collector_amqp", "urxvt -e sh -c 'intelmq.bots.collectors.amqp.collector_amqp ; bash'" },
  { "intelmq.bots.collectors.api.collector_api", "urxvt -e sh -c 'intelmq.bots.collectors.api.collector_api ; bash'" },
  { "intelmq.bots.collectors.blueliv.collector_crimeserver", "urxvt -e sh -c 'intelmq.bots.collectors.blueliv.collector_crimeserver ; bash'" },
  { "intelmq.bots.collectors.calidog.collector_certstream", "urxvt -e sh -c 'intelmq.bots.collectors.calidog.collector_certstream ; bash'" },
  { "intelmq.bots.collectors.eset.collector", "urxvt -e sh -c 'intelmq.bots.collectors.eset.collector ; bash'" },
  { "intelmq.bots.collectors.file.collector_file", "urxvt -e sh -c 'intelmq.bots.collectors.file.collector_file ; bash'" },
  { "intelmq.bots.collectors.fireeye.collector_mas", "urxvt -e sh -c 'intelmq.bots.collectors.fireeye.collector_mas ; bash'" },
  { "intelmq.bots.collectors.github_api.collector_github_contents_api", "urxvt -e sh -c 'intelmq.bots.collectors.github_api.collector_github_contents_api ; bash'" },
  { "intelmq.bots.collectors.http.collector_http", "urxvt -e sh -c 'intelmq.bots.collectors.http.collector_http ; bash'" },
  { "intelmq.bots.collectors.http.collector_http_stream", "urxvt -e sh -c 'intelmq.bots.collectors.http.collector_http_stream ; bash'" },
  { "intelmq.bots.collectors.kafka.collector", "urxvt -e sh -c 'intelmq.bots.collectors.kafka.collector ; bash'" },
  { "intelmq.bots.collectors.mail.collector_mail_attach", "urxvt -e sh -c 'intelmq.bots.collectors.mail.collector_mail_attach ; bash'" },
  { "intelmq.bots.collectors.mail.collector_mail_body", "urxvt -e sh -c 'intelmq.bots.collectors.mail.collector_mail_body ; bash'" },
  { "intelmq.bots.collectors.mail.collector_mail_url", "urxvt -e sh -c 'intelmq.bots.collectors.mail.collector_mail_url ; bash'" },
  { "intelmq.bots.collectors.microsoft.collector_azure", "urxvt -e sh -c 'intelmq.bots.collectors.microsoft.collector_azure ; bash'" },
  { "intelmq.bots.collectors.microsoft.collector_interflow", "urxvt -e sh -c 'intelmq.bots.collectors.microsoft.collector_interflow ; bash'" },
  { "intelmq.bots.collectors.misp.collector", "urxvt -e sh -c 'intelmq.bots.collectors.misp.collector ; bash'" },
  { "intelmq.bots.collectors.opendxl.collector", "urxvt -e sh -c 'intelmq.bots.collectors.opendxl.collector ; bash'" },
  { "intelmq.bots.collectors.rsync.collector_rsync", "urxvt -e sh -c 'intelmq.bots.collectors.rsync.collector_rsync ; bash'" },
  { "intelmq.bots.collectors.rt.collector_rt", "urxvt -e sh -c 'intelmq.bots.collectors.rt.collector_rt ; bash'" },
  { "intelmq.bots.collectors.stomp.collector", "urxvt -e sh -c 'intelmq.bots.collectors.stomp.collector ; bash'" },
  { "intelmq.bots.collectors.tcp.collector", "urxvt -e sh -c 'intelmq.bots.collectors.tcp.collector ; bash'" },
  { "intelmq.bots.collectors.twitter.collector_twitter", "urxvt -e sh -c 'intelmq.bots.collectors.twitter.collector_twitter ; bash'" },
  { "intelmq.bots.experts.abusix.expert", "urxvt -e sh -c 'intelmq.bots.experts.abusix.expert ; bash'" },
  { "intelmq.bots.experts.aggregate.expert", "urxvt -e sh -c 'intelmq.bots.experts.aggregate.expert ; bash'" },
  { "intelmq.bots.experts.asn_lookup.expert", "urxvt -e sh -c 'intelmq.bots.experts.asn_lookup.expert ; bash'" },
  { "intelmq.bots.experts.csv_converter.expert", "urxvt -e sh -c 'intelmq.bots.experts.csv_converter.expert ; bash'" },
  { "intelmq.bots.experts.cymru_whois.expert", "urxvt -e sh -c 'intelmq.bots.experts.cymru_whois.expert ; bash'" },
  { "intelmq.bots.experts.do_portal.expert", "urxvt -e sh -c 'intelmq.bots.experts.do_portal.expert ; bash'" },
  { "intelmq.bots.experts.domain_suffix.expert", "urxvt -e sh -c 'intelmq.bots.experts.domain_suffix.expert ; bash'" },
  { "intelmq.bots.experts.field_reducer.expert", "urxvt -e sh -c 'intelmq.bots.experts.field_reducer.expert ; bash'" },
  { "intelmq.bots.experts.filter.expert", "urxvt -e sh -c 'intelmq.bots.experts.filter.expert ; bash'" },
  { "intelmq.bots.experts.format_field.expert", "urxvt -e sh -c 'intelmq.bots.experts.format_field.expert ; bash'" },
  { "intelmq.bots.experts.generic_db_lookup.expert", "urxvt -e sh -c 'intelmq.bots.experts.generic_db_lookup.expert ; bash'" },
  { "intelmq.bots.experts.gethostbyname.expert", "urxvt -e sh -c 'intelmq.bots.experts.gethostbyname.expert ; bash'" },
  { "intelmq.bots.experts.http.expert_content", "urxvt -e sh -c 'intelmq.bots.experts.http.expert_content ; bash'" },
  { "intelmq.bots.experts.http.expert_status", "urxvt -e sh -c 'intelmq.bots.experts.http.expert_status ; bash'" },
  { "intelmq.bots.experts.idea.expert", "urxvt -e sh -c 'intelmq.bots.experts.idea.expert ; bash'" },
  { "intelmq.bots.experts.lookyloo.expert", "urxvt -e sh -c 'intelmq.bots.experts.lookyloo.expert ; bash'" },
  { "intelmq.bots.experts.maxmind_geoip.expert", "urxvt -e sh -c 'intelmq.bots.experts.maxmind_geoip.expert ; bash'" },
  { "intelmq.bots.experts.mcafee.expert_mar", "urxvt -e sh -c 'intelmq.bots.experts.mcafee.expert_mar ; bash'" },
  { "intelmq.bots.experts.misp.expert", "urxvt -e sh -c 'intelmq.bots.experts.misp.expert ; bash'" },
  { "intelmq.bots.experts.modify.expert", "urxvt -e sh -c 'intelmq.bots.experts.modify.expert ; bash'" },
  { "intelmq.bots.experts.national_cert_contact_certat.expert", "urxvt -e sh -c 'intelmq.bots.experts.national_cert_contact_certat.expert ; bash'" },
  { "intelmq.bots.experts.rdap.expert", "urxvt -e sh -c 'intelmq.bots.experts.rdap.expert ; bash'" },
  { "intelmq.bots.experts.recordedfuture_iprisk.expert", "urxvt -e sh -c 'intelmq.bots.experts.recordedfuture_iprisk.expert ; bash'" },
  { "intelmq.bots.experts.reverse_dns.expert", "urxvt -e sh -c 'intelmq.bots.experts.reverse_dns.expert ; bash'" },
  { "intelmq.bots.experts.rfc1918.expert", "urxvt -e sh -c 'intelmq.bots.experts.rfc1918.expert ; bash'" },
  { "intelmq.bots.experts.ripe.expert", "urxvt -e sh -c 'intelmq.bots.experts.ripe.expert ; bash'" },
  { "intelmq.bots.experts.sieve.expert", "urxvt -e sh -c 'intelmq.bots.experts.sieve.expert ; bash'" },
  { "intelmq.bots.experts.sieve.validator", "urxvt -e sh -c 'intelmq.bots.experts.sieve.validator ; bash'" },
  { "intelmq.bots.experts.taxonomy.expert", "urxvt -e sh -c 'intelmq.bots.experts.taxonomy.expert ; bash'" },
  { "intelmq.bots.experts.tor_nodes.expert", "urxvt -e sh -c 'intelmq.bots.experts.tor_nodes.expert ; bash'" },
  { "intelmq.bots.experts.truncate_by_delimiter.expert", "urxvt -e sh -c 'intelmq.bots.experts.truncate_by_delimiter.expert ; bash'" },
  { "intelmq.bots.experts.trusted_introducer_lookup.expert", "urxvt -e sh -c 'intelmq.bots.experts.trusted_introducer_lookup.expert ; bash'" },
  { "intelmq.bots.experts.tuency.expert", "urxvt -e sh -c 'intelmq.bots.experts.tuency.expert ; bash'" },
  { "intelmq.bots.experts.url2fqdn.expert", "urxvt -e sh -c 'intelmq.bots.experts.url2fqdn.expert ; bash'" },
  { "intelmq.bots.experts.uwhoisd.expert", "urxvt -e sh -c 'intelmq.bots.experts.uwhoisd.expert ; bash'" },
  { "intelmq.bots.experts.wait.expert", "urxvt -e sh -c 'intelmq.bots.experts.wait.expert ; bash'" },
  { "intelmq.bots.outputs.amqptopic.output", "urxvt -e sh -c 'intelmq.bots.outputs.amqptopic.output ; bash'" },
  { "intelmq.bots.outputs.blackhole.output", "urxvt -e sh -c 'intelmq.bots.outputs.blackhole.output ; bash'" },
  { "intelmq.bots.outputs.elasticsearch.output", "urxvt -e sh -c 'intelmq.bots.outputs.elasticsearch.output ; bash'" },
  { "intelmq.bots.outputs.file.output", "urxvt -e sh -c 'intelmq.bots.outputs.file.output ; bash'" },
  { "intelmq.bots.outputs.files.output", "urxvt -e sh -c 'intelmq.bots.outputs.files.output ; bash'" },
  { "intelmq.bots.outputs.mcafee.output_esm_ip", "urxvt -e sh -c 'intelmq.bots.outputs.mcafee.output_esm_ip ; bash'" },
  { "intelmq.bots.outputs.misp.output_api", "urxvt -e sh -c 'intelmq.bots.outputs.misp.output_api ; bash'" },
  { "intelmq.bots.outputs.misp.output_feed", "urxvt -e sh -c 'intelmq.bots.outputs.misp.output_feed ; bash'" },
  { "intelmq.bots.outputs.mongodb.output", "urxvt -e sh -c 'intelmq.bots.outputs.mongodb.output ; bash'" },
  { "intelmq.bots.outputs.postgresql.output", "urxvt -e sh -c 'intelmq.bots.outputs.postgresql.output ; bash'" },
  { "intelmq.bots.outputs.redis.output", "urxvt -e sh -c 'intelmq.bots.outputs.redis.output ; bash'" },
  { "intelmq.bots.outputs.restapi.output", "urxvt -e sh -c 'intelmq.bots.outputs.restapi.output ; bash'" },
  { "intelmq.bots.outputs.rt.output", "urxvt -e sh -c 'intelmq.bots.outputs.rt.output ; bash'" },
  { "intelmq.bots.outputs.smtp.output", "urxvt -e sh -c 'intelmq.bots.outputs.smtp.output ; bash'" },
  { "intelmq.bots.outputs.sql.output", "urxvt -e sh -c 'intelmq.bots.outputs.sql.output ; bash'" },
  { "intelmq.bots.outputs.stomp.output", "urxvt -e sh -c 'intelmq.bots.outputs.stomp.output ; bash'" },
  { "intelmq.bots.outputs.tcp.output", "urxvt -e sh -c 'intelmq.bots.outputs.tcp.output ; bash'" },
  { "intelmq.bots.outputs.touch.output", "urxvt -e sh -c 'intelmq.bots.outputs.touch.output ; bash'" },
  { "intelmq.bots.outputs.udp.output", "urxvt -e sh -c 'intelmq.bots.outputs.udp.output ; bash'" },
  { "intelmq.bots.parsers.abusech.parser_domain", "urxvt -e sh -c 'intelmq.bots.parsers.abusech.parser_domain ; bash'" },
  { "intelmq.bots.parsers.abusech.parser_ip", "urxvt -e sh -c 'intelmq.bots.parsers.abusech.parser_ip ; bash'" },
  { "intelmq.bots.parsers.alienvault.parser", "urxvt -e sh -c 'intelmq.bots.parsers.alienvault.parser ; bash'" },
  { "intelmq.bots.parsers.alienvault.parser_otx", "urxvt -e sh -c 'intelmq.bots.parsers.alienvault.parser_otx ; bash'" },
  { "intelmq.bots.parsers.anubisnetworks.parser", "urxvt -e sh -c 'intelmq.bots.parsers.anubisnetworks.parser ; bash'" },
  { "intelmq.bots.parsers.bambenek.parser", "urxvt -e sh -c 'intelmq.bots.parsers.bambenek.parser ; bash'" },
  { "intelmq.bots.parsers.blocklistde.parser", "urxvt -e sh -c 'intelmq.bots.parsers.blocklistde.parser ; bash'" },
  { "intelmq.bots.parsers.blueliv.parser_crimeserver", "urxvt -e sh -c 'intelmq.bots.parsers.blueliv.parser_crimeserver ; bash'" },
  { "intelmq.bots.parsers.calidog.parser_certstream", "urxvt -e sh -c 'intelmq.bots.parsers.calidog.parser_certstream ; bash'" },
  { "intelmq.bots.parsers.cert_eu.parser_csv", "urxvt -e sh -c 'intelmq.bots.parsers.cert_eu.parser_csv ; bash'" },
  { "intelmq.bots.parsers.ci_army.parser", "urxvt -e sh -c 'intelmq.bots.parsers.ci_army.parser ; bash'" },
  { "intelmq.bots.parsers.cleanmx.parser", "urxvt -e sh -c 'intelmq.bots.parsers.cleanmx.parser ; bash'" },
  { "intelmq.bots.parsers.cymru.parser_full_bogons", "urxvt -e sh -c 'intelmq.bots.parsers.cymru.parser_full_bogons ; bash'" },
  { "intelmq.bots.parsers.cznic.parser_haas", "urxvt -e sh -c 'intelmq.bots.parsers.cznic.parser_haas ; bash'" },
  { "intelmq.bots.parsers.cznic.parser_proki", "urxvt -e sh -c 'intelmq.bots.parsers.cznic.parser_proki ; bash'" },
  { "intelmq.bots.parsers.danger_rulez.parser", "urxvt -e sh -c 'intelmq.bots.parsers.danger_rulez.parser ; bash'" },
  { "intelmq.bots.parsers.dyn.parser", "urxvt -e sh -c 'intelmq.bots.parsers.dyn.parser ; bash'" },
  { "intelmq.bots.parsers.eset.parser", "urxvt -e sh -c 'intelmq.bots.parsers.eset.parser ; bash'" },
  { "intelmq.bots.parsers.fireeye.parser", "urxvt -e sh -c 'intelmq.bots.parsers.fireeye.parser ; bash'" },
  { "intelmq.bots.parsers.fraunhofer.parser_dga", "urxvt -e sh -c 'intelmq.bots.parsers.fraunhofer.parser_dga ; bash'" },
  { "intelmq.bots.parsers.generic.parser_csv", "urxvt -e sh -c 'intelmq.bots.parsers.generic.parser_csv ; bash'" },
  { "intelmq.bots.parsers.github_feed.parser", "urxvt -e sh -c 'intelmq.bots.parsers.github_feed.parser ; bash'" },
  { "intelmq.bots.parsers.hibp.parser_callback", "urxvt -e sh -c 'intelmq.bots.parsers.hibp.parser_callback ; bash'" },
  { "intelmq.bots.parsers.html_table.parser", "urxvt -e sh -c 'intelmq.bots.parsers.html_table.parser ; bash'" },
  { "intelmq.bots.parsers.malc0de.parser", "urxvt -e sh -c 'intelmq.bots.parsers.malc0de.parser ; bash'" },
  { "intelmq.bots.parsers.malwaredomains.parser", "urxvt -e sh -c 'intelmq.bots.parsers.malwaredomains.parser ; bash'" },
  { "intelmq.bots.parsers.malwarepatrol.parser_dansguardian", "urxvt -e sh -c 'intelmq.bots.parsers.malwarepatrol.parser_dansguardian ; bash'" },
  { "intelmq.bots.parsers.malwareurl.parser", "urxvt -e sh -c 'intelmq.bots.parsers.malwareurl.parser ; bash'" },
  { "intelmq.bots.parsers.mcafee.parser_atd", "urxvt -e sh -c 'intelmq.bots.parsers.mcafee.parser_atd ; bash'" },
  { "intelmq.bots.parsers.microsoft.parser_ctip", "urxvt -e sh -c 'intelmq.bots.parsers.microsoft.parser_ctip ; bash'" },
  { "intelmq.bots.parsers.misp.parser", "urxvt -e sh -c 'intelmq.bots.parsers.misp.parser ; bash'" },
  { "intelmq.bots.parsers.n6.parser_n6stomp", "urxvt -e sh -c 'intelmq.bots.parsers.n6.parser_n6stomp ; bash'" },
  { "intelmq.bots.parsers.netlab_360.parser", "urxvt -e sh -c 'intelmq.bots.parsers.netlab_360.parser ; bash'" },
  { "intelmq.bots.parsers.spamhaus.parser_cert", "urxvt -e sh -c 'intelmq.bots.parsers.spamhaus.parser_cert ; bash'" },
  { "intelmq.bots.parsers.spamhaus.parser_drop", "urxvt -e sh -c 'intelmq.bots.parsers.spamhaus.parser_drop ; bash'" },
  { "intelmq.bots.parsers.sucuri.parser", "urxvt -e sh -c 'intelmq.bots.parsers.sucuri.parser ; bash'" },
  { "intelmq.bots.parsers.taichung.parser", "urxvt -e sh -c 'intelmq.bots.parsers.taichung.parser ; bash'" },
  { "intelmq.bots.parsers.threatminer.parser", "urxvt -e sh -c 'intelmq.bots.parsers.threatminer.parser ; bash'" },
  { "intelmq.bots.parsers.turris.parser", "urxvt -e sh -c 'intelmq.bots.parsers.turris.parser ; bash'" },
  { "intelmq.bots.parsers.twitter.parser", "urxvt -e sh -c 'intelmq.bots.parsers.twitter.parser ; bash'" },
  { "intelmq.bots.parsers.vxvault.parser", "urxvt -e sh -c 'intelmq.bots.parsers.vxvault.parser ; bash'" },
  { "intelmq.bots.parsers.zoneh.parser", "urxvt -e sh -c 'intelmq.bots.parsers.zoneh.parser ; bash'" },
  { "intelmqctl", "urxvt -e sh -c 'intelmqctl ; bash'" },
  { "intelmqdump", "urxvt -e sh -c 'intelmqdump ; bash'" },
  { "intelmqsetup", "urxvt -e sh -c 'intelmqsetup ; bash'" },
  { "intensio-obfuscator", "urxvt -e sh -c 'intensio-obfuscator -h ; bash'" },
  { "inundator", "urxvt -e sh -c 'inundator ; bash'" },
  { "ipcountry", "urxvt -e sh -c 'ipcountry -H ; bash'" },
  { "ipobfuscator", "urxvt -e sh -c 'ipobfuscator ; bash'" },
  { "ja3", "urxvt -e sh -c 'ja3 -h ; bash'" },
  { "jast", "urxvt -e sh -c 'jast -h ; bash'" },
  { "jsfuck", "urxvt -e sh -c 'jsfuck ; bash'" },
  { "klar", "urxvt -e sh -c 'klar -h ; bash'" },
  { "latcp", "urxvt -e sh -c 'latcp ; bash'" },
  { "latd", "urxvt -e sh -c 'latd -h ; bash'" },
  { "llogin", "urxvt -e sh -c 'llogin -h ; bash'" },
  { "moprc", "urxvt -e sh -c 'moprc ; bash'" },
  { "ldapaddgroup", "urxvt -e sh -c 'ldapaddgroup -h ; bash'" },
  { "ldapaddmachine", "urxvt -e sh -c 'ldapaddmachine -h ; bash'" },
  { "ldapadduser", "urxvt -e sh -c 'ldapadduser -h ; bash'" },
  { "ldapaddusertogroup", "urxvt -e sh -c 'ldapaddusertogroup -h ; bash'" },
  { "ldapdeletegroup", "urxvt -e sh -c 'ldapdeletegroup -h ; bash'" },
  { "ldapdeletemachine", "urxvt -e sh -c 'ldapdeletemachine -h ; bash'" },
  { "ldapdeleteuser", "urxvt -e sh -c 'ldapdeleteuser -h ; bash'" },
  { "ldapdeleteuserfromgroup", "urxvt -e sh -c 'ldapdeleteuserfromgroup -h ; bash'" },
  { "ldapfinger", "urxvt -e sh -c 'ldapfinger -h ; bash'" },
  { "ldapgid", "urxvt -e sh -c 'ldapgid -h ; bash'" },
  { "ldapid", "urxvt -e sh -c 'ldapid -h ; bash'" },
  { "ldapinit", "urxvt -e sh -c 'ldapinit -h ; bash'" },
  { "ldapmodifygroup", "urxvt -e sh -c 'ldapmodifygroup -h ; bash'" },
  { "ldapmodifymachine", "urxvt -e sh -c 'ldapmodifymachine -h ; bash'" },
  { "ldapmodifyuser", "urxvt -e sh -c 'ldapmodifyuser -h ; bash'" },
  { "ldaprenamegroup", "urxvt -e sh -c 'ldaprenamegroup -h ; bash'" },
  { "ldaprenamemachine", "urxvt -e sh -c 'ldaprenamemachine -h ; bash'" },
  { "ldaprenameuser", "urxvt -e sh -c 'ldaprenameuser -h ; bash'" },
  { "lsldap", "urxvt -e sh -c 'lsldap -h ; bash'" },
  { "leo", "urxvt -e sh -c 'leo -h ; bash'" },
  { "nick2ldif", "urxvt -e sh -c 'nick2ldif ; bash'" },
  { "pst2ldif", "urxvt -e sh -c 'pst2ldif ; bash'" },
  { "nick2ldif", "urxvt -e sh -c 'nick2ldif ; bash'" },
  { "pst2ldif", "urxvt -e sh -c 'pst2ldif ; bash'" },
  { "linkedin2username", "urxvt -e sh -c 'linkedin2username -h ; bash'" },
  { "luyten", "urxvt -e sh -c 'luyten ; bash'" },
  { "macchanger", "urxvt -e sh -c 'macchanger --help ; bash'" },
  { "magictree", "urxvt -e sh -c 'magictree ; bash'" },
  { "malice", "urxvt -e sh -c 'malice ; bash'" },
  { "maskprocessor", "urxvt -e sh -c 'maskprocessor -h ; bash'" },
  { "mat", "urxvt -e sh -c 'mat -h ; bash'" },
  { "mat-gui", "urxvt -e sh -c 'mat-gui ; bash'" },
  { "mat2", "urxvt -e sh -c 'mat2 -h ; bash'" },
  { "mibblebrowser", "urxvt -e sh -c 'mibblebrowser ; bash'" },
  { "mibbleprinter", "urxvt -e sh -c 'mibbleprinter ; bash'" },
  { "mibblevalidator", "urxvt -e sh -c 'mibblevalidator ; bash'" },
  { "minimodem", "urxvt -e sh -c 'minimodem ; bash'" },
  { "mkyara", "urxvt -e sh -c 'mkyara -h ; bash'" },
  { "msfdb-blackarch", "urxvt -e sh -c 'msfdb-blackarch ; bash'" },
  { "mutator", "urxvt -e sh -c 'mutator -h ; bash'" },
  { "mysql2sqlite", "urxvt -e sh -c 'mysql2sqlite -h ; bash'" },
  { "netactview", "urxvt -e sh -c 'netactview ; bash'" },
  { "netactview_polkit", "urxvt -e sh -c 'netactview_polkit ; bash'" },
  { "networkmap", "urxvt -e sh -c 'networkmap -h ; bash'" },
  { "nmap-parse-output", "urxvt -e sh -c 'nmap-parse-output ; bash'" },
  { "nsearch", "urxvt -e sh -c 'nsearch ; bash'" },
  { "one-lin3r", "urxvt -e sh -c 'one-lin3r -h ; bash'" },
  { "iscsi-gen-initiatorname", "urxvt -e sh -c 'iscsi-gen-initiatorname ; bash'" },
  { "iscsi-iname", "urxvt -e sh -c 'iscsi-iname ; bash'" },
  { "iscsi_discovery", "urxvt -e sh -c 'iscsi_discovery ; bash'" },
  { "iscsi_fw_login", "urxvt -e sh -c 'iscsi_fw_login ; bash'" },
  { "iscsi_offload", "urxvt -e sh -c 'iscsi_offload ; bash'" },
  { "iscsiadm", "urxvt -e sh -c 'iscsiadm ; bash'" },
  { "iscsid", "urxvt -e sh -c 'iscsid ; bash'" },
  { "iscsistart", "urxvt -e sh -c 'iscsistart ; bash'" },
  { "iscsiuio", "urxvt -e sh -c 'iscsiuio ; bash'" },
  { "iscsi-gen-initiatorname", "urxvt -e sh -c 'iscsi-gen-initiatorname ; bash'" },
  { "iscsi-iname", "urxvt -e sh -c 'iscsi-iname ; bash'" },
  { "iscsi_discovery", "urxvt -e sh -c 'iscsi_discovery ; bash'" },
  { "iscsi_fw_login", "urxvt -e sh -c 'iscsi_fw_login ; bash'" },
  { "iscsi_offload", "urxvt -e sh -c 'iscsi_offload ; bash'" },
  { "iscsiadm", "urxvt -e sh -c 'iscsiadm ; bash'" },
  { "iscsid", "urxvt -e sh -c 'iscsid ; bash'" },
  { "iscsistart", "urxvt -e sh -c 'iscsistart ; bash'" },
  { "iscsiuio", "urxvt -e sh -c 'iscsiuio ; bash'" },
  { "outguess", "urxvt -e sh -c 'outguess ; bash'" },
  { "packetq", "urxvt -e sh -c 'packetq -h ; bash'" },
  { "pass-station", "urxvt -e sh -c 'pass-station -h ; bash'" },
  { "pass-station_console", "urxvt -e sh -c 'pass-station_console ; bash'" },
  { "pcapfix", "urxvt -e sh -c 'pcapfix ; bash'" },
  { "pdfwalker", "urxvt -e sh -c 'pdfwalker ; bash'" },
  { "pencode", "urxvt -e sh -c 'pencode -h ; bash'" },
  { "pixd", "urxvt -e sh -c 'pixd -h ; bash'" },
  { "plumber", "urxvt -e sh -c 'plumber ; bash'" },
  { "plutil", "urxvt -e sh -c 'plutil ; bash'" },
  { "princeprocessor", "urxvt -e sh -c 'princeprocessor -h ; bash'" },
  { "procdump", "urxvt -e sh -c 'procdump ; bash'" },
  { "proctal", "urxvt -e sh -c 'proctal -h ; bash'" },
  { "pulledpork", "urxvt -e sh -c 'pulledpork ; bash'" },
  { "pwdlogy", "urxvt -e sh -c 'pwdlogy ; bash'" },
  { "pwdlyser", "urxvt -e sh -c 'pwdlyser -h ; bash'" },
  { "pwnedpasswords", "urxvt -e sh -c 'pwnedpasswords -h ; bash'" },
  { "apkinfo", "urxvt -e sh -c 'apkinfo --help ; bash'" },
  { "pydictor", "urxvt -e sh -c 'pydictor -h ; bash'" },
  { "pyinstaller", "urxvt -e sh -c 'pyinstaller ; bash'" },
  { "google-streetview", "urxvt -e sh -c 'google-streetview ; bash'" },
  { "mmbot", "urxvt -e sh -c 'mmbot -h ; bash'" },
  { "exrex2", "urxvt -e sh -c 'exrex2 ; bash'" },
  { "google-streetview2", "urxvt -e sh -c 'google-streetview2 ; bash'" },
  { "qrgen", "urxvt -e sh -c 'qrgen -h ; bash'" },
  { "rabid", "urxvt -e sh -c 'rabid -h ; bash'" },
  { "rabid_console", "urxvt -e sh -c 'rabid_console ; bash'" },
  { "rawsec-cli", "urxvt -e sh -c 'rawsec-cli --help ; bash'" },
  { "rogue-mysql-server", "urxvt -e sh -c 'rogue-mysql-server ; bash'" },
  { "rr", "urxvt -e sh -c 'rr -h ; bash'" },
  { "rtfm", "urxvt -e sh -c 'rtfm -h ; bash'" },
  { "rulesfinder", "urxvt -e sh -c 'rulesfinder -h ; bash'" },
  { "sakis3g", "urxvt -e sh -c 'sakis3g --help ; bash'" },
  { "fasm", "urxvt -e sh -c 'fasm ; bash'" },
  { "listing", "urxvt -e sh -c 'listing ; bash'" },
  { "sasm", "urxvt -e sh -c 'sasm ; bash'" },
  { "sh00t", "urxvt -e sh -c 'sh00t ; bash'" },
  { "shelling", "urxvt -e sh -c 'shelling ; bash'" },
  { "sipi", "urxvt -e sh -c 'sipi -h ; bash'" },
  { "sleuthql", "urxvt -e sh -c 'sleuthql -h ; bash'" },
  { "smali-cfgs-flow", "urxvt -e sh -c 'smali-cfgs-flow -h ; bash'" },
  { "smali-cfgs-xref", "urxvt -e sh -c 'smali-cfgs-xref -h ; bash'" },
  { "snow", "urxvt -e sh -c 'snow -h ; bash'" },
  { "sslcat", "urxvt -e sh -c 'sslcat ; bash'" },
  { "suricata-verify", "urxvt -e sh -c 'suricata-verify ; bash'" },
  { "tcpxtract", "urxvt -e sh -c 'tcpxtract -h ; bash'" },
  { "tempomail", "urxvt -e sh -c 'tempomail -h ; bash'" },
  { "threatspec", "urxvt -e sh -c 'threatspec -h ; bash'" },
  { "tls-map", "urxvt -e sh -c 'tls-map -h ; bash'" },
  { "token-reverser", "urxvt -e sh -c 'token-reverser -h ; bash'" },
  { "tpcat", "urxvt -e sh -c 'tpcat ; bash'" },
  { "ua-tester", "urxvt -e sh -c 'ua-tester ; bash'" },
  { "uberfile", "urxvt -e sh -c 'uberfile -h ; bash'" },
  { "unfurl", "urxvt -e sh -c 'unfurl -h ; bash'" },
  { "upx", "urxvt -e sh -c 'upx -h ; bash'" },
  { "urlview", "urxvt -e sh -c 'urlview ; bash'" },
  { "usernamer", "urxvt -e sh -c 'usernamer -h ; bash'" },
  { "valhalla-cli", "urxvt -e sh -c 'valhalla-cli -h ; bash'" },
  { "vba2graph", "urxvt -e sh -c 'vba2graph -h ; bash'" },
  { "vDesigner", "urxvt -e sh -c 'vDesigner ; bash'" },
  { "verinice", "urxvt -e sh -c 'verinice ; bash'" },
  { "vfeed", "urxvt -e sh -c 'vfeed ; bash'" },
  { "plotprocmoncsv", "urxvt -e sh -c 'plotprocmoncsv -h ; bash'" },
  { "wcc", "urxvt -e sh -c 'wcc -h ; bash'" },
  { "wcch", "urxvt -e sh -c 'wcch -h ; bash'" },
  { "wld", "urxvt -e sh -c 'wld -h ; bash'" },
  { "wldd", "urxvt -e sh -c 'wldd -h ; bash'" },
  { "web2ldap", "urxvt -e sh -c 'web2ldap ; bash'" },
  { "web2ldap.wsgi", "urxvt -e sh -c 'web2ldap.wsgi ; bash'" },
  { "whapa", "urxvt -e sh -c 'whapa -h ; bash'" },
  { "whatportis", "urxvt -e sh -c 'whatportis --help ; bash'" },
  { "wikigen", "urxvt -e sh -c 'wikigen ; bash'" },
  { "fsck.winregfs", "urxvt -e sh -c 'fsck.winregfs ; bash'" },
  { "mount.winregfs", "urxvt -e sh -c 'mount.winregfs ; bash'" },
  { "wol-e", "urxvt -e sh -c 'wol-e -h ; bash'" },
  { "wordlistctl", "urxvt -e sh -c 'wordlistctl -h ; bash'" },
  { "wordlister", "urxvt -e sh -c 'wordlister -h ; bash'" },
  { "wuzz", "urxvt -e sh -c 'wuzz -h ; bash'" },
  { "wxHexEditor", "urxvt -e sh -c 'wxHexEditor ; bash'" },
  { "yay", "urxvt -e sh -c 'yay ; bash'" },
  { "ztelnet", "urxvt -e sh -c 'ztelnet ; bash'" },
}

mobilemenu = {
  { "androbugs", "urxvt -e sh -c 'androbugs -h ; bash'" },
  { "androick", "urxvt -e sh -c 'androick ; bash'" },
  { "androidpincrack", "urxvt -e sh -c 'androidpincrack -h ; bash'" },
  { "androidsniffer", "urxvt -e sh -c 'androidsniffer -h ; bash'" },
  { "androwarn", "urxvt -e sh -c 'androwarn -h ; bash'" },
  { "apkid", "urxvt -e sh -c 'apkid -h ; bash'" },
  { "apkleaks", "urxvt -e sh -c 'apkleaks -h ; bash'" },
  { "apkstat", "urxvt -e sh -c 'apkstat -h ; bash'" },
  { "apkstudio", "urxvt -e sh -c 'apkstudio ; bash'" },
  { "appmon", "urxvt -e sh -c 'appmon ; bash'" },
  { "arcane", "urxvt -e sh -c 'arcane -h ; bash'" },
  { "backhack", "urxvt -e sh -c 'backhack ; bash'" },
  { "bagbak", "urxvt -e sh -c 'bagbak -h ; bash'" },
  { "cnamulator", "urxvt -e sh -c 'cnamulator -h ; bash'" },
  { "dexpatcher", "urxvt -e sh -c 'dexpatcher -h ; bash'" },
  { "drozer", "urxvt -e sh -c 'drozer ; bash'" },
  { "drozer-repository", "urxvt -e sh -c 'drozer-repository ; bash'" },
  { "dwarf", "urxvt -e sh -c 'dwarf --help ; bash'" },
  { "findmyiphone", "urxvt -e sh -c 'findmyiphone ; bash'" },
  { "frida-ios-dump", "urxvt -e sh -c 'frida-ios-dump -h ; bash'" },
  { "gtp-scan", "urxvt -e sh -c 'gtp-scan -h ; bash'" },
  { "ibrute", "urxvt -e sh -c 'ibrute -h ; bash'" },
  { "iosforensic", "urxvt -e sh -c 'iosforensic -h ; bash'" },
  { "iphoneanalyzer", "urxvt -e sh -c 'iphoneanalyzer -h ; bash'" },
  { "jeb-android", "urxvt -e sh -c 'jeb-android ; bash'" },
  { "kal", "urxvt -e sh -c 'kal -h ; bash'" },
  { "kraken", "urxvt -e sh -c 'kraken -h ; bash'" },
  { "lazydroid", "urxvt -e sh -c 'lazydroid ; bash'" },
  { "lte-cell-scanner", "urxvt -e sh -c 'lte-cell-scanner --help ; bash'" },
  { "mara-framework", "urxvt -e sh -c 'mara-framework ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "fedora-dirk-ipv6.diff", "urxvt -e sh -c 'fedora-dirk-ipv6.diff ; bash'" },
  { "openssl.Darwin.x86_64", "urxvt -e sh -c 'openssl.Darwin.x86_64 ; bash'" },
  { "openssl.Linux.i686", "urxvt -e sh -c 'openssl.Linux.i686 ; bash'" },
  { "openssl.Linux.x86_64", "urxvt -e sh -c 'openssl.Linux.x86_64 ; bash'" },
  { "mobsf", "urxvt -e sh -c 'mobsf ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "needle", "urxvt -e sh -c 'needle -h ; bash'" },
  { "objection", "urxvt -e sh -c 'objection --help ; bash'" },
  { "phoneinfoga", "urxvt -e sh -c 'phoneinfoga -h ; bash'" },
  { "apkinfo", "urxvt -e sh -c 'apkinfo --help ; bash'" },
  { "frida", "urxvt -e sh -c 'frida -h ; bash'" },
  { "frida-create", "urxvt -e sh -c 'frida-create ; bash'" },
  { "frida-discover", "urxvt -e sh -c 'frida-discover -h ; bash'" },
  { "frida-join", "urxvt -e sh -c 'frida-join ; bash'" },
  { "frida-kill", "urxvt -e sh -c 'frida-kill -h ; bash'" },
  { "frida-ls-devices", "urxvt -e sh -c 'frida-ls-devices -h ; bash'" },
  { "frida-trace", "urxvt -e sh -c 'frida-trace -h ; bash'" },
  { "frida-create2", "urxvt -e sh -c 'frida-create2 ; bash'" },
  { "frida-discover2", "urxvt -e sh -c 'frida-discover2 ; bash'" },
  { "frida-join2", "urxvt -e sh -c 'frida-join2 ; bash'" },
  { "frida-kill2", "urxvt -e sh -c 'frida-kill2 ; bash'" },
  { "frida-ls-devices2", "urxvt -e sh -c 'frida-ls-devices2 ; bash'" },
  { "frida-trace2", "urxvt -e sh -c 'frida-trace2 ; bash'" },
  { "frida2", "urxvt -e sh -c 'frida2 ; bash'" },
  { "qark", "urxvt -e sh -c 'qark ; bash'" },
  { "quark", "urxvt -e sh -c 'quark --help ; bash'" },
  { "rvi-capture", "urxvt -e sh -c 'rvi-capture -h ; bash'" },
  { "sandy", "urxvt -e sh -c 'sandy -h ; bash'" },
  { "sign", "urxvt -e sh -c 'sign ; bash'" },
  { "smali-cfgs-flow", "urxvt -e sh -c 'smali-cfgs-flow -h ; bash'" },
  { "smali-cfgs-xref", "urxvt -e sh -c 'smali-cfgs-xref -h ; bash'" },
  { "smalisca", "urxvt -e sh -c 'smalisca --help ; bash'" },
  { "smartphone-pentest-framework", "urxvt -e sh -c 'smartphone-pentest-framework -h ; bash'" },
  { "ar", "urxvt -e sh -c 'ar ; bash'" },
  { "as", "urxvt -e sh -c 'as --help ; bash'" },
  { "c++", "urxvt -e sh -c 'c++ ; bash'" },
  { "g++", "urxvt -e sh -c 'g++ ; bash'" },
  { "gcc", "urxvt -e sh -c 'gcc ; bash'" },
  { "ld", "urxvt -e sh -c 'ld ; bash'" },
  { "nm", "urxvt -e sh -c 'nm -h ; bash'" },
  { "objdump", "urxvt -e sh -c 'objdump ; bash'" },
  { "ranlib", "urxvt -e sh -c 'ranlib ; bash'" },
  { "strip", "urxvt -e sh -c 'strip ; bash'" },
  { "arm-linux-androideabi-addr2line", "urxvt -e sh -c 'arm-linux-androideabi-addr2line ; bash'" },
  { "arm-linux-androideabi-ar", "urxvt -e sh -c 'arm-linux-androideabi-ar ; bash'" },
  { "arm-linux-androideabi-as", "urxvt -e sh -c 'arm-linux-androideabi-as ; bash'" },
  { "arm-linux-androideabi-c++", "urxvt -e sh -c 'arm-linux-androideabi-c++ ; bash'" },
  { "arm-linux-androideabi-c++filt", "urxvt -e sh -c 'arm-linux-androideabi-c++filt ; bash'" },
  { "arm-linux-androideabi-cpp", "urxvt -e sh -c 'arm-linux-androideabi-cpp ; bash'" },
  { "arm-linux-androideabi-elfedit", "urxvt -e sh -c 'arm-linux-androideabi-elfedit ; bash'" },
  { "arm-linux-androideabi-g++", "urxvt -e sh -c 'arm-linux-androideabi-g++ ; bash'" },
  { "arm-linux-androideabi-gcc", "urxvt -e sh -c 'arm-linux-androideabi-gcc ; bash'" },
  { "arm-linux-androideabi-gcc-4.6", "urxvt -e sh -c 'arm-linux-androideabi-gcc-4.6 ; bash'" },
  { "arm-linux-androideabi-gcov", "urxvt -e sh -c 'arm-linux-androideabi-gcov ; bash'" },
  { "arm-linux-androideabi-gdb", "urxvt -e sh -c 'arm-linux-androideabi-gdb ; bash'" },
  { "arm-linux-androideabi-gdbtui", "urxvt -e sh -c 'arm-linux-androideabi-gdbtui ; bash'" },
  { "arm-linux-androideabi-gprof", "urxvt -e sh -c 'arm-linux-androideabi-gprof ; bash'" },
  { "arm-linux-androideabi-ld", "urxvt -e sh -c 'arm-linux-androideabi-ld ; bash'" },
  { "arm-linux-androideabi-nm", "urxvt -e sh -c 'arm-linux-androideabi-nm ; bash'" },
  { "arm-linux-androideabi-objdump", "urxvt -e sh -c 'arm-linux-androideabi-objdump ; bash'" },
  { "arm-linux-androideabi-ranlib", "urxvt -e sh -c 'arm-linux-androideabi-ranlib ; bash'" },
  { "arm-linux-androideabi-readelf", "urxvt -e sh -c 'arm-linux-androideabi-readelf ; bash'" },
  { "arm-linux-androideabi-run", "urxvt -e sh -c 'arm-linux-androideabi-run ; bash'" },
  { "arm-linux-androideabi-size", "urxvt -e sh -c 'arm-linux-androideabi-size ; bash'" },
  { "arm-linux-androideabi-strings", "urxvt -e sh -c 'arm-linux-androideabi-strings ; bash'" },
  { "arm-linux-androideabi-strip", "urxvt -e sh -c 'arm-linux-androideabi-strip ; bash'" },
  { "stacoan", "urxvt -e sh -c 'stacoan -h ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "truegaze", "urxvt -e sh -c 'truegaze -h ; bash'" },
}

networkingmenu = {
  { "afp_client", "urxvt -e sh -c 'afp_client ; bash'" },
  { "afpfs", "urxvt -e sh -c 'afpfs ; bash'" },
  { "afpfsd", "urxvt -e sh -c 'afpfsd -h ; bash'" },
  { "afpgetstatus", "urxvt -e sh -c 'afpgetstatus ; bash'" },
  { "mount_afp", "urxvt -e sh -c 'mount_afp ; bash'" },
  { "afp_client", "urxvt -e sh -c 'afp_client ; bash'" },
  { "afpfs", "urxvt -e sh -c 'afpfs ; bash'" },
  { "afpfsd", "urxvt -e sh -c 'afpfsd -h ; bash'" },
  { "afpgetstatus", "urxvt -e sh -c 'afpgetstatus ; bash'" },
  { "mount_afp", "urxvt -e sh -c 'mount_afp ; bash'" },
  { "aiengine", "urxvt -e sh -c 'aiengine -h ; bash'" },
  { "apacket", "urxvt -e sh -c 'apacket ; bash'" },
  { "sapacket", "urxvt -e sh -c 'sapacket ; bash'" },
  { "argus-extip", "urxvt -e sh -c 'argus-extip ; bash'" },
  { "argus-lsof", "urxvt -e sh -c 'argus-lsof ; bash'" },
  { "argus-snmp", "urxvt -e sh -c 'argus-snmp ; bash'" },
  { "argus-vmstat", "urxvt -e sh -c 'argus-vmstat ; bash'" },
  { "argusbug", "urxvt -e sh -c 'argusbug ; bash'" },
  { "argusclientbug", "urxvt -e sh -c 'argusclientbug ; bash'" },
  { "ra", "urxvt -e sh -c 'ra -h ; bash'" },
  { "racluster", "urxvt -e sh -c 'racluster -h ; bash'" },
  { "raconvert", "urxvt -e sh -c 'raconvert -h ; bash'" },
  { "racount", "urxvt -e sh -c 'racount -h ; bash'" },
  { "radark", "urxvt -e sh -c 'radark -h ; bash'" },
  { "radecode", "urxvt -e sh -c 'radecode ; bash'" },
  { "radium", "urxvt -e sh -c 'radium -h ; bash'" },
  { "radump", "urxvt -e sh -c 'radump ; bash'" },
  { "raevent", "urxvt -e sh -c 'raevent -h ; bash'" },
  { "rafilteraddr", "urxvt -e sh -c 'rafilteraddr ; bash'" },
  { "ragraph", "urxvt -e sh -c 'ragraph ; bash'" },
  { "ragrep", "urxvt -e sh -c 'ragrep ; bash'" },
  { "rahisto", "urxvt -e sh -c 'rahisto ; bash'" },
  { "rahosts", "urxvt -e sh -c 'rahosts ; bash'" },
  { "ralabel", "urxvt -e sh -c 'ralabel ; bash'" },
  { "ranonymize", "urxvt -e sh -c 'ranonymize ; bash'" },
  { "rapath", "urxvt -e sh -c 'rapath ; bash'" },
  { "rapolicy", "urxvt -e sh -c 'rapolicy ; bash'" },
  { "raports", "urxvt -e sh -c 'raports ; bash'" },
  { "rarpwatch", "urxvt -e sh -c 'rarpwatch ; bash'" },
  { "raservices", "urxvt -e sh -c 'raservices ; bash'" },
  { "rasort", "urxvt -e sh -c 'rasort -h ; bash'" },
  { "rastream", "urxvt -e sh -c 'rastream -h ; bash'" },
  { "rastrip", "urxvt -e sh -c 'rastrip -h ; bash'" },
  { "ratimerange", "urxvt -e sh -c 'ratimerange ; bash'" },
  { "ratop", "urxvt -e sh -c 'ratop ; bash'" },
  { "rauserdata", "urxvt -e sh -c 'rauserdata ; bash'" },
  { "arp-fingerprint", "urxvt -e sh -c 'arp-fingerprint -h ; bash'" },
  { "arp-scan", "urxvt -e sh -c 'arp-scan -h ; bash'" },
  { "get-iab", "urxvt -e sh -c 'get-iab -h ; bash'" },
  { "get-oui", "urxvt -e sh -c 'get-oui -h ; bash'" },
  { "arp-fingerprint", "urxvt -e sh -c 'arp-fingerprint -h ; bash'" },
  { "arp-scan", "urxvt -e sh -c 'arp-scan -h ; bash'" },
  { "get-iab", "urxvt -e sh -c 'get-iab -h ; bash'" },
  { "get-oui", "urxvt -e sh -c 'get-oui -h ; bash'" },
  { "arpalert", "urxvt -e sh -c 'arpalert -h ; bash'" },
  { "arptools", "urxvt -e sh -c 'arptools ; bash'" },
  { "arpwner", "urxvt -e sh -c 'arpwner -h ; bash'" },
  { "atftp", "urxvt -e sh -c 'atftp ; bash'" },
  { "atftpd", "urxvt -e sh -c 'atftpd ; bash'" },
  { "atftp", "urxvt -e sh -c 'atftp ; bash'" },
  { "atftpd", "urxvt -e sh -c 'atftpd ; bash'" },
  { "autovpn", "urxvt -e sh -c 'autovpn ; bash'" },
  { "backfuzz", "urxvt -e sh -c 'backfuzz -h ; bash'" },
  { "badkarma", "urxvt -e sh -c 'badkarma ; bash'" },
  { "bettercap", "urxvt -e sh -c 'bettercap -h ; bash'" },
  { "arpaname", "urxvt -e sh -c 'arpaname ; bash'" },
  { "delv", "urxvt -e sh -c 'delv ; bash'" },
  { "dig", "urxvt -e sh -c 'dig -h ; bash'" },
  { "dnssec-cds", "urxvt -e sh -c 'dnssec-cds ; bash'" },
  { "dnssec-checkds", "urxvt -e sh -c 'dnssec-checkds ; bash'" },
  { "dnssec-coverage", "urxvt -e sh -c 'dnssec-coverage ; bash'" },
  { "dnssec-revoke", "urxvt -e sh -c 'dnssec-revoke ; bash'" },
  { "dnssec-settime", "urxvt -e sh -c 'dnssec-settime ; bash'" },
  { "dnssec-signzone", "urxvt -e sh -c 'dnssec-signzone ; bash'" },
  { "dnssec-verify", "urxvt -e sh -c 'dnssec-verify ; bash'" },
  { "host", "urxvt -e sh -c 'host ; bash'" },
  { "mdig", "urxvt -e sh -c 'mdig ; bash'" },
  { "named", "urxvt -e sh -c 'named ; bash'" },
  { "named-checkzone", "urxvt -e sh -c 'named-checkzone ; bash'" },
  { "named-compilezone", "urxvt -e sh -c 'named-compilezone ; bash'" },
  { "named-journalprint", "urxvt -e sh -c 'named-journalprint ; bash'" },
  { "named-nzd2nzf", "urxvt -e sh -c 'named-nzd2nzf ; bash'" },
  { "named-rrchecker", "urxvt -e sh -c 'named-rrchecker ; bash'" },
  { "nslookup", "urxvt -e sh -c 'nslookup ; bash'" },
  { "nsupdate", "urxvt -e sh -c 'nsupdate ; bash'" },
  { "rndc", "urxvt -e sh -c 'rndc ; bash'" },
  { "arpaname", "urxvt -e sh -c 'arpaname ; bash'" },
  { "delv", "urxvt -e sh -c 'delv ; bash'" },
  { "dig", "urxvt -e sh -c 'dig -h ; bash'" },
  { "dnssec-cds", "urxvt -e sh -c 'dnssec-cds ; bash'" },
  { "dnssec-checkds", "urxvt -e sh -c 'dnssec-checkds ; bash'" },
  { "dnssec-coverage", "urxvt -e sh -c 'dnssec-coverage ; bash'" },
  { "dnssec-revoke", "urxvt -e sh -c 'dnssec-revoke ; bash'" },
  { "dnssec-settime", "urxvt -e sh -c 'dnssec-settime ; bash'" },
  { "dnssec-signzone", "urxvt -e sh -c 'dnssec-signzone ; bash'" },
  { "dnssec-verify", "urxvt -e sh -c 'dnssec-verify ; bash'" },
  { "host", "urxvt -e sh -c 'host ; bash'" },
  { "mdig", "urxvt -e sh -c 'mdig ; bash'" },
  { "named", "urxvt -e sh -c 'named ; bash'" },
  { "named-checkzone", "urxvt -e sh -c 'named-checkzone ; bash'" },
  { "named-compilezone", "urxvt -e sh -c 'named-compilezone ; bash'" },
  { "named-journalprint", "urxvt -e sh -c 'named-journalprint ; bash'" },
  { "named-nzd2nzf", "urxvt -e sh -c 'named-nzd2nzf ; bash'" },
  { "named-rrchecker", "urxvt -e sh -c 'named-rrchecker ; bash'" },
  { "nslookup", "urxvt -e sh -c 'nslookup ; bash'" },
  { "nsupdate", "urxvt -e sh -c 'nsupdate ; bash'" },
  { "rndc", "urxvt -e sh -c 'rndc ; bash'" },
  { "binproxy", "urxvt -e sh -c 'binproxy --help ; bash'" },
  { "bittwist", "urxvt -e sh -c 'bittwist -h ; bash'" },
  { "bittwiste", "urxvt -e sh -c 'bittwiste -h ; bash'" },
  { "buttinsky", "urxvt -e sh -c 'buttinsky -h ; bash'" },
  { "cli", "urxvt -e sh -c 'cli ; bash'" },
  { "netzobparse", "urxvt -e sh -c 'netzobparse ; bash'" },
  { "spawner", "urxvt -e sh -c 'spawner ; bash'" },
  { "stack", "urxvt -e sh -c 'stack ; bash'" },
  { "bypass-firewall-dns-history", "urxvt -e sh -c 'bypass-firewall-dns-history -h ; bash'" },
  { "cadaver", "urxvt -e sh -c 'cadaver -h ; bash'" },
  { "camscan", "urxvt -e sh -c 'camscan -h ; bash'" },
  { "chameleon", "urxvt -e sh -c 'chameleon -h ; bash'" },
  { "chaosreader", "urxvt -e sh -c 'chaosreader -h ; bash'" },
  { "chiron-attacks", "urxvt -e sh -c 'chiron-attacks ; bash'" },
  { "chiron-local-link", "urxvt -e sh -c 'chiron-local-link ; bash'" },
  { "chiron-nd", "urxvt -e sh -c 'chiron-nd ; bash'" },
  { "chiron-proxy", "urxvt -e sh -c 'chiron-proxy ; bash'" },
  { "chiron-scanner", "urxvt -e sh -c 'chiron-scanner ; bash'" },
  { "suture", "urxvt -e sh -c 'suture ; bash'" },
  { "cidr2range", "urxvt -e sh -c 'cidr2range -h ; bash'" },
  { "cisco-snmp-enumeration", "urxvt -e sh -c 'cisco-snmp-enumeration ; bash'" },
  { "cisco-snmp-slap", "urxvt -e sh -c 'cisco-snmp-slap -h ; bash'" },
  { "corkscrew", "urxvt -e sh -c 'corkscrew ; bash'" },
  { "creak", "urxvt -e sh -c 'creak -h ; bash'" },
  { "cyberscan", "urxvt -e sh -c 'cyberscan -h ; bash'" },
  { "darkstat", "urxvt -e sh -c 'darkstat -h ; bash'" },
  { "datajackproxy", "urxvt -e sh -c 'datajackproxy -h ; bash'" },
  { "depdep", "urxvt -e sh -c 'depdep -h ; bash'" },
  { "det", "urxvt -e sh -c 'det -h ; bash'" },
  { "detect-sniffer", "urxvt -e sh -c 'detect-sniffer -h ; bash'" },
  { "dhcpoptinj", "urxvt -e sh -c 'dhcpoptinj -h ; bash'" },
  { "dinouml", "urxvt -e sh -c 'dinouml -h ; bash'" },
  { "dizzy", "urxvt -e sh -c 'dizzy -h ; bash'" },
  { "dkmc", "urxvt -e sh -c 'dkmc ; bash'" },
  { "dns-reverse-proxy", "urxvt -e sh -c 'dns-reverse-proxy -h ; bash'" },
  { "dnseval", "urxvt -e sh -c 'dnseval ; bash'" },
  { "dnsping", "urxvt -e sh -c 'dnsping ; bash'" },
  { "dnstraceroute", "urxvt -e sh -c 'dnstraceroute ; bash'" },
  { "dnsfilexfer-recv", "urxvt -e sh -c 'dnsfilexfer-recv -h ; bash'" },
  { "dnsfilexfer-send", "urxvt -e sh -c 'dnsfilexfer-send -h ; bash'" },
  { "dnsteal", "urxvt -e sh -c 'dnsteal ; bash'" },
  { "dnsvalidator", "urxvt -e sh -c 'dnsvalidator -h ; bash'" },
  { "dnsspoof", "urxvt -e sh -c 'dnsspoof -h ; bash'" },
  { "dsniff", "urxvt -e sh -c 'dsniff -h ; bash'" },
  { "filesnarf", "urxvt -e sh -c 'filesnarf -h ; bash'" },
  { "macof", "urxvt -e sh -c 'macof -h ; bash'" },
  { "mailsnarf", "urxvt -e sh -c 'mailsnarf -h ; bash'" },
  { "msgsnarf", "urxvt -e sh -c 'msgsnarf -h ; bash'" },
  { "tcpkill", "urxvt -e sh -c 'tcpkill -h ; bash'" },
  { "tcpnice", "urxvt -e sh -c 'tcpnice -h ; bash'" },
  { "urlsnarf", "urxvt -e sh -c 'urlsnarf -h ; bash'" },
  { "webmitm", "urxvt -e sh -c 'webmitm -h ; bash'" },
  { "dnsspoof", "urxvt -e sh -c 'dnsspoof -h ; bash'" },
  { "dsniff", "urxvt -e sh -c 'dsniff -h ; bash'" },
  { "filesnarf", "urxvt -e sh -c 'filesnarf -h ; bash'" },
  { "macof", "urxvt -e sh -c 'macof -h ; bash'" },
  { "mailsnarf", "urxvt -e sh -c 'mailsnarf -h ; bash'" },
  { "msgsnarf", "urxvt -e sh -c 'msgsnarf -h ; bash'" },
  { "tcpkill", "urxvt -e sh -c 'tcpkill -h ; bash'" },
  { "tcpnice", "urxvt -e sh -c 'tcpnice -h ; bash'" },
  { "urlsnarf", "urxvt -e sh -c 'urlsnarf -h ; bash'" },
  { "webmitm", "urxvt -e sh -c 'webmitm -h ; bash'" },
  { "dtp-spoof", "urxvt -e sh -c 'dtp-spoof -h ; bash'" },
  { "dublin-traceroute", "urxvt -e sh -c 'dublin-traceroute --help ; bash'" },
  { "dump1090", "urxvt -e sh -c 'dump1090 -h ; bash'" },
  { "easy-creds", "urxvt -e sh -c 'easy-creds ; bash'" },
  { "eigrp", "urxvt -e sh -c 'eigrp -h ; bash'" },
  { "espionage", "urxvt -e sh -c 'espionage -h ; bash'" },
  { "etherape", "urxvt -e sh -c 'etherape ; bash'" },
  { "ettercap", "urxvt -e sh -c 'ettercap -h ; bash'" },
  { "etterfilter", "urxvt -e sh -c 'etterfilter -h ; bash'" },
  { "etterlog", "urxvt -e sh -c 'etterlog -h ; bash'" },
  { "ettercap", "urxvt -e sh -c 'ettercap -h ; bash'" },
  { "etterfilter", "urxvt -e sh -c 'etterfilter -h ; bash'" },
  { "etterlog", "urxvt -e sh -c 'etterlog -h ; bash'" },
  { "evillimiter", "urxvt -e sh -c 'evillimiter -h ; bash'" },
  { "exabgp", "urxvt -e sh -c 'exabgp ; bash'" },
  { "exabgp-cli", "urxvt -e sh -c 'exabgp-cli ; bash'" },
  { "exabgp-healthcheck", "urxvt -e sh -c 'exabgp-healthcheck ; bash'" },
  { "exabgpcli", "urxvt -e sh -c 'exabgpcli ; bash'" },
  { "fakenet", "urxvt -e sh -c 'fakenet -h ; bash'" },
  { "fakenetbiosdgm", "urxvt -e sh -c 'fakenetbiosdgm -h ; bash'" },
  { "fakenetbiosns", "urxvt -e sh -c 'fakenetbiosns -h ; bash'" },
  { "filibuster", "urxvt -e sh -c 'filibuster -h ; bash'" },
  { "firecat", "urxvt -e sh -c 'firecat ; bash'" },
  { "flowinspect", "urxvt -e sh -c 'flowinspect -h ; bash'" },
  { "fping", "urxvt -e sh -c 'fping -h ; bash'" },
  { "fraud-bridge", "urxvt -e sh -c 'fraud-bridge -h ; bash'" },
  { "bmc-device", "urxvt -e sh -c 'bmc-device ; bash'" },
  { "bmc-info", "urxvt -e sh -c 'bmc-info ; bash'" },
  { "bmc-watchdog", "urxvt -e sh -c 'bmc-watchdog ; bash'" },
  { "ipmi-chassis", "urxvt -e sh -c 'ipmi-chassis ; bash'" },
  { "ipmi-console", "urxvt -e sh -c 'ipmi-console ; bash'" },
  { "ipmi-dcmi", "urxvt -e sh -c 'ipmi-dcmi ; bash'" },
  { "ipmi-detect", "urxvt -e sh -c 'ipmi-detect ; bash'" },
  { "ipmi-fru", "urxvt -e sh -c 'ipmi-fru ; bash'" },
  { "ipmi-locate", "urxvt -e sh -c 'ipmi-locate ; bash'" },
  { "ipmi-oem", "urxvt -e sh -c 'ipmi-oem ; bash'" },
  { "ipmi-pet", "urxvt -e sh -c 'ipmi-pet ; bash'" },
  { "ipmi-ping", "urxvt -e sh -c 'ipmi-ping ; bash'" },
  { "ipmi-power", "urxvt -e sh -c 'ipmi-power ; bash'" },
  { "ipmi-raw", "urxvt -e sh -c 'ipmi-raw ; bash'" },
  { "ipmi-sel", "urxvt -e sh -c 'ipmi-sel ; bash'" },
  { "ipmi-sensors", "urxvt -e sh -c 'ipmi-sensors ; bash'" },
  { "ipmiconsole", "urxvt -e sh -c 'ipmiconsole ; bash'" },
  { "ipmidetect", "urxvt -e sh -c 'ipmidetect ; bash'" },
  { "ipmidetectd", "urxvt -e sh -c 'ipmidetectd ; bash'" },
  { "ipmimonitoring", "urxvt -e sh -c 'ipmimonitoring ; bash'" },
  { "ipmiping", "urxvt -e sh -c 'ipmiping ; bash'" },
  { "ipmipower", "urxvt -e sh -c 'ipmipower ; bash'" },
  { "ipmiseld", "urxvt -e sh -c 'ipmiseld ; bash'" },
  { "rmcp-ping", "urxvt -e sh -c 'rmcp-ping ; bash'" },
  { "rmcpping", "urxvt -e sh -c 'rmcpping ; bash'" },
  { "bmc-device", "urxvt -e sh -c 'bmc-device ; bash'" },
  { "bmc-info", "urxvt -e sh -c 'bmc-info ; bash'" },
  { "bmc-watchdog", "urxvt -e sh -c 'bmc-watchdog ; bash'" },
  { "ipmi-chassis", "urxvt -e sh -c 'ipmi-chassis ; bash'" },
  { "ipmi-console", "urxvt -e sh -c 'ipmi-console ; bash'" },
  { "ipmi-dcmi", "urxvt -e sh -c 'ipmi-dcmi ; bash'" },
  { "ipmi-detect", "urxvt -e sh -c 'ipmi-detect ; bash'" },
  { "ipmi-fru", "urxvt -e sh -c 'ipmi-fru ; bash'" },
  { "ipmi-locate", "urxvt -e sh -c 'ipmi-locate ; bash'" },
  { "ipmi-oem", "urxvt -e sh -c 'ipmi-oem ; bash'" },
  { "ipmi-pet", "urxvt -e sh -c 'ipmi-pet ; bash'" },
  { "ipmi-ping", "urxvt -e sh -c 'ipmi-ping ; bash'" },
  { "ipmi-power", "urxvt -e sh -c 'ipmi-power ; bash'" },
  { "ipmi-raw", "urxvt -e sh -c 'ipmi-raw ; bash'" },
  { "ipmi-sel", "urxvt -e sh -c 'ipmi-sel ; bash'" },
  { "ipmi-sensors", "urxvt -e sh -c 'ipmi-sensors ; bash'" },
  { "ipmiconsole", "urxvt -e sh -c 'ipmiconsole ; bash'" },
  { "ipmidetect", "urxvt -e sh -c 'ipmidetect ; bash'" },
  { "ipmidetectd", "urxvt -e sh -c 'ipmidetectd ; bash'" },
  { "ipmimonitoring", "urxvt -e sh -c 'ipmimonitoring ; bash'" },
  { "ipmiping", "urxvt -e sh -c 'ipmiping ; bash'" },
  { "ipmipower", "urxvt -e sh -c 'ipmipower ; bash'" },
  { "ipmiseld", "urxvt -e sh -c 'ipmiseld ; bash'" },
  { "rmcp-ping", "urxvt -e sh -c 'rmcp-ping ; bash'" },
  { "rmcpping", "urxvt -e sh -c 'rmcpping ; bash'" },
  { "fs-nyarl", "urxvt -e sh -c 'fs-nyarl -h ; bash'" },
  { "chaosreader0.94", "urxvt -e sh -c 'chaosreader0.94 ; bash'" },
  { "fuzzowski", "urxvt -e sh -c 'fuzzowski -h ; bash'" },
  { "blitz", "urxvt -e sh -c 'blitz -h ; bash'" },
  { "gs-mount", "urxvt -e sh -c 'gs-mount -h ; bash'" },
  { "gs-netcat", "urxvt -e sh -c 'gs-netcat -h ; bash'" },
  { "gs-sftp", "urxvt -e sh -c 'gs-sftp -h ; bash'" },
  { "gsocket", "urxvt -e sh -c 'gsocket ; bash'" },
  { "gspoof", "urxvt -e sh -c 'gspoof -h ; bash'" },
  { "gtp-scan", "urxvt -e sh -c 'gtp-scan -h ; bash'" },
  { "gwcheck", "urxvt -e sh -c 'gwcheck -h ; bash'" },
  { "haka", "urxvt -e sh -c 'haka -h ; bash'" },
  { "hakabench", "urxvt -e sh -c 'hakabench -h ; bash'" },
  { "hakactl", "urxvt -e sh -c 'hakactl -h ; bash'" },
  { "hakapcap", "urxvt -e sh -c 'hakapcap -h ; bash'" },
  { "hharp", "urxvt -e sh -c 'hharp -h ; bash'" },
  { "hpfeeds", "urxvt -e sh -c 'hpfeeds -h ; bash'" },
  { "hpfeeds-broker", "urxvt -e sh -c 'hpfeeds-broker ; bash'" },
  { "hping", "urxvt -e sh -c 'hping --help ; bash'" },
  { "hping2", "urxvt -e sh -c 'hping2 --help ; bash'" },
  { "hping3", "urxvt -e sh -c 'hping3 --help ; bash'" },
  { "hping", "urxvt -e sh -c 'hping --help ; bash'" },
  { "hping2", "urxvt -e sh -c 'hping2 --help ; bash'" },
  { "hping3", "urxvt -e sh -c 'hping3 --help ; bash'" },
  { "http-traceroute", "urxvt -e sh -c 'http-traceroute -h ; bash'" },
  { "httping", "urxvt -e sh -c 'httping --help ; bash'" },
  { "hyde", "urxvt -e sh -c 'hyde ; bash'" },
  { "hyenae", "urxvt -e sh -c 'hyenae --help ; bash'" },
  { "hyenaed", "urxvt -e sh -c 'hyenaed --help ; bash'" },
  { "hyperfox", "urxvt -e sh -c 'hyperfox -h ; bash'" },
  { "i2pd", "urxvt -e sh -c 'i2pd --help ; bash'" },
  { "icmptx", "urxvt -e sh -c 'icmptx ; bash'" },
  { "idswakeup", "urxvt -e sh -c 'idswakeup -h ; bash'" },
  { "ifchk", "urxvt -e sh -c 'ifchk -h ; bash'" },
  { "interlace", "urxvt -e sh -c 'interlace -h ; bash'" },
  { "ipaudit", "urxvt -e sh -c 'ipaudit ; bash'" },
  { "ipaudit-stamp-h1", "urxvt -e sh -c 'ipaudit-stamp-h1 ; bash'" },
  { "ipaudit-total", "urxvt -e sh -c 'ipaudit-total ; bash'" },
  { "ipdecap", "urxvt -e sh -c 'ipdecap -h ; bash'" },
  { "ipmievd", "urxvt -e sh -c 'ipmievd -h ; bash'" },
  { "ipmitool", "urxvt -e sh -c 'ipmitool -h ; bash'" },
  { "ipmievd", "urxvt -e sh -c 'ipmievd -h ; bash'" },
  { "ipmitool", "urxvt -e sh -c 'ipmitool -h ; bash'" },
  { "arping", "urxvt -e sh -c 'arping -h ; bash'" },
  { "clockdiff", "urxvt -e sh -c 'clockdiff ; bash'" },
  { "ninfod", "urxvt -e sh -c 'ninfod ; bash'" },
  { "ping", "urxvt -e sh -c 'ping ; bash'" },
  { "rarpd", "urxvt -e sh -c 'rarpd ; bash'" },
  { "rdisc", "urxvt -e sh -c 'rdisc ; bash'" },
  { "tftpd", "urxvt -e sh -c 'tftpd ; bash'" },
  { "tracepath", "urxvt -e sh -c 'tracepath -h ; bash'" },
  { "arping", "urxvt -e sh -c 'arping -h ; bash'" },
  { "clockdiff", "urxvt -e sh -c 'clockdiff ; bash'" },
  { "ninfod", "urxvt -e sh -c 'ninfod ; bash'" },
  { "ping", "urxvt -e sh -c 'ping ; bash'" },
  { "rarpd", "urxvt -e sh -c 'rarpd ; bash'" },
  { "rdisc", "urxvt -e sh -c 'rdisc ; bash'" },
  { "tftpd", "urxvt -e sh -c 'tftpd ; bash'" },
  { "tracepath", "urxvt -e sh -c 'tracepath -h ; bash'" },
  { "ipv4bypass", "urxvt -e sh -c 'ipv4bypass -h ; bash'" },
  { "ipv666", "urxvt -e sh -c 'ipv666 -h ; bash'" },
  { "addr6", "urxvt -e sh -c 'addr6 ; bash'" },
  { "blackhole6", "urxvt -e sh -c 'blackhole6 ; bash'" },
  { "flow6", "urxvt -e sh -c 'flow6 ; bash'" },
  { "frag6", "urxvt -e sh -c 'frag6 ; bash'" },
  { "icmp6", "urxvt -e sh -c 'icmp6 ; bash'" },
  { "jumbo6", "urxvt -e sh -c 'jumbo6 ; bash'" },
  { "messi", "urxvt -e sh -c 'messi ; bash'" },
  { "mldq6", "urxvt -e sh -c 'mldq6 ; bash'" },
  { "na6", "urxvt -e sh -c 'na6 ; bash'" },
  { "ni6", "urxvt -e sh -c 'ni6 ; bash'" },
  { "ns6", "urxvt -e sh -c 'ns6 ; bash'" },
  { "path6", "urxvt -e sh -c 'path6 -h ; bash'" },
  { "ra6", "urxvt -e sh -c 'ra6 ; bash'" },
  { "rd6", "urxvt -e sh -c 'rd6 ; bash'" },
  { "rs6", "urxvt -e sh -c 'rs6 ; bash'" },
  { "scan6", "urxvt -e sh -c 'scan6 ; bash'" },
  { "script6", "urxvt -e sh -c 'script6 ; bash'" },
  { "tcp6", "urxvt -e sh -c 'tcp6 ; bash'" },
  { "udp6", "urxvt -e sh -c 'udp6 ; bash'" },
  { "isip", "urxvt -e sh -c 'isip ; bash'" },
  { "ivre", "urxvt -e sh -c 'ivre ; bash'" },
  { "jnetmap", "urxvt -e sh -c 'jnetmap ; bash'" },
  { "jok3r", "urxvt -e sh -c 'jok3r -h ; bash'" },
  { "jondo", "urxvt -e sh -c 'jondo ; bash'" },
  { "juncli", "urxvt -e sh -c 'juncli ; bash'" },
  { "junkie", "urxvt -e sh -c 'junkie -h ; bash'" },
  { "kickthemout", "urxvt -e sh -c 'kickthemout -h ; bash'" },
  { "lans", "urxvt -e sh -c 'lans -h ; bash'" },
  { "latcp", "urxvt -e sh -c 'latcp ; bash'" },
  { "latd", "urxvt -e sh -c 'latd -h ; bash'" },
  { "llogin", "urxvt -e sh -c 'llogin -h ; bash'" },
  { "moprc", "urxvt -e sh -c 'moprc ; bash'" },
  { "ldapdomaindump", "urxvt -e sh -c 'ldapdomaindump -h ; bash'" },
  { "ldd2bloodhound", "urxvt -e sh -c 'ldd2bloodhound -h ; bash'" },
  { "ldd2pretty", "urxvt -e sh -c 'ldd2pretty ; bash'" },
  { "lft", "urxvt -e sh -c 'lft ; bash'" },
  { "whob", "urxvt -e sh -c 'whob ; bash'" },
  { "paris-ping", "urxvt -e sh -c 'paris-ping -h ; bash'" },
  { "paris-traceroute", "urxvt -e sh -c 'paris-traceroute -h ; bash'" },
  { "macchanger", "urxvt -e sh -c 'macchanger --help ; bash'" },
  { "maclookup", "urxvt -e sh -c 'maclookup -h ; bash'" },
  { "maketh", "urxvt -e sh -c 'maketh -h ; bash'" },
  { "malcom", "urxvt -e sh -c 'malcom -h ; bash'" },
  { "mallory", "urxvt -e sh -c 'mallory -h ; bash'" },
  { "maltrail-sensor", "urxvt -e sh -c 'maltrail-sensor -h ; bash'" },
  { "maltrail-server", "urxvt -e sh -c 'maltrail-server -h ; bash'" },
  { "massdns", "urxvt -e sh -c 'massdns ; bash'" },
  { "mz", "urxvt -e sh -c 'mz -h ; bash'" },
  { "msf-ws.ru", "urxvt -e sh -c 'msf-ws.ru ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfdb", "urxvt -e sh -c 'msfdb ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfelfscan", "urxvt -e sh -c 'msfelfscan -h ; bash'" },
  { "msfmachscan", "urxvt -e sh -c 'msfmachscan -h ; bash'" },
  { "msfpescan", "urxvt -e sh -c 'msfpescan -h ; bash'" },
  { "msfrop", "urxvt -e sh -c 'msfrop -h ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfupdate", "urxvt -e sh -c 'msfupdate -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "expressInstall.swf", "urxvt -e sh -c 'expressInstall.swf ; bash'" },
  { "stty", "urxvt -e sh -c 'stty ; bash'" },
  { "middler", "urxvt -e sh -c 'middler -h ; bash'" },
  { "createnpk", "urxvt -e sh -c 'createnpk ; bash'" },
  { "dumpnpk", "urxvt -e sh -c 'dumpnpk ; bash'" },
  { "unpacknpk", "urxvt -e sh -c 'unpacknpk ; bash'" },
  { "mitm", "urxvt -e sh -c 'mitm -h ; bash'" },
  { "mitm6", "urxvt -e sh -c 'mitm6 -h ; bash'" },
  { "mitmer", "urxvt -e sh -c 'mitmer -h ; bash'" },
  { "mitmf", "urxvt -e sh -c 'mitmf -h ; bash'" },
  { "moloch-capture", "urxvt -e sh -c 'moloch-capture -h ; bash'" },
  { "monocle", "urxvt -e sh -c 'monocle -h ; bash'" },
  { "morxtunel", "urxvt -e sh -c 'morxtunel ; bash'" },
  { "quantuminject", "urxvt -e sh -c 'quantuminject -h ; bash'" },
  { "motsa-dnsdetect", "urxvt -e sh -c 'motsa-dnsdetect -h ; bash'" },
  { "motsa-dnsinject", "urxvt -e sh -c 'motsa-dnsinject -h ; bash'" },
  { "mptcp", "urxvt -e sh -c 'mptcp -h ; bash'" },
  { "mptcp-fragmenter", "urxvt -e sh -c 'mptcp-fragmenter ; bash'" },
  { "mptcp-scanner", "urxvt -e sh -c 'mptcp-scanner ; bash'" },
  { "mtr", "urxvt -e sh -c 'mtr -h ; bash'" },
  { "mtr-packet", "urxvt -e sh -c 'mtr-packet ; bash'" },
  { "mtr", "urxvt -e sh -c 'mtr -h ; bash'" },
  { "mtr-packet", "urxvt -e sh -c 'mtr-packet ; bash'" },
  { "mylg", "urxvt -e sh -c 'mylg help ; bash'" },
  { "nacker", "urxvt -e sh -c 'nacker -h ; bash'" },
  { "dnscat", "urxvt -e sh -c 'dnscat -h ; bash'" },
  { "dnslogger", "urxvt -e sh -c 'dnslogger -h ; bash'" },
  { "dnstest", "urxvt -e sh -c 'dnstest -h ; bash'" },
  { "dnsxss", "urxvt -e sh -c 'dnsxss -h ; bash'" },
  { "nbquery", "urxvt -e sh -c 'nbquery -h ; bash'" },
  { "nbsniff", "urxvt -e sh -c 'nbsniff -h ; bash'" },
  { "ipx_interface", "urxvt -e sh -c 'ipx_interface ; bash'" },
  { "ipx_internal_net", "urxvt -e sh -c 'ipx_internal_net ; bash'" },
  { "ipx_route", "urxvt -e sh -c 'ipx_route ; bash'" },
  { "ncpmap", "urxvt -e sh -c 'ncpmap -h ; bash'" },
  { "ncpmount", "urxvt -e sh -c 'ncpmount -h ; bash'" },
  { "ncpumount", "urxvt -e sh -c 'ncpumount -h ; bash'" },
  { "nprint", "urxvt -e sh -c 'nprint -h ; bash'" },
  { "nsend", "urxvt -e sh -c 'nsend ; bash'" },
  { "nwauth", "urxvt -e sh -c 'nwauth -h ; bash'" },
  { "nwbocreate", "urxvt -e sh -c 'nwbocreate -h ; bash'" },
  { "nwbols", "urxvt -e sh -c 'nwbols -h ; bash'" },
  { "nwborm", "urxvt -e sh -c 'nwborm -h ; bash'" },
  { "nwbpadd", "urxvt -e sh -c 'nwbpadd -h ; bash'" },
  { "nwbpcreate", "urxvt -e sh -c 'nwbpcreate ; bash'" },
  { "nwbprm", "urxvt -e sh -c 'nwbprm -h ; bash'" },
  { "nwbpvalues", "urxvt -e sh -c 'nwbpvalues -h ; bash'" },
  { "nwdir", "urxvt -e sh -c 'nwdir -h ; bash'" },
  { "nwdpvalues", "urxvt -e sh -c 'nwdpvalues -h ; bash'" },
  { "nwfsctrl", "urxvt -e sh -c 'nwfsctrl -h ; bash'" },
  { "nwfsinfo", "urxvt -e sh -c 'nwfsinfo -h ; bash'" },
  { "nwfstime", "urxvt -e sh -c 'nwfstime -h ; bash'" },
  { "nwgrant", "urxvt -e sh -c 'nwgrant ; bash'" },
  { "nwmsg", "urxvt -e sh -c 'nwmsg -h ; bash'" },
  { "nwpasswd", "urxvt -e sh -c 'nwpasswd -h ; bash'" },
  { "nwpjmv", "urxvt -e sh -c 'nwpjmv -h ; bash'" },
  { "nwpqjob", "urxvt -e sh -c 'nwpqjob -h ; bash'" },
  { "nwpurge", "urxvt -e sh -c 'nwpurge -h ; bash'" },
  { "nwrevoke", "urxvt -e sh -c 'nwrevoke -h ; bash'" },
  { "nwrights", "urxvt -e sh -c 'nwrights -h ; bash'" },
  { "nwsfind", "urxvt -e sh -c 'nwsfind -h ; bash'" },
  { "nwtrustee", "urxvt -e sh -c 'nwtrustee -h ; bash'" },
  { "nwtrustee2", "urxvt -e sh -c 'nwtrustee2 -h ; bash'" },
  { "nwuserlist", "urxvt -e sh -c 'nwuserlist -h ; bash'" },
  { "nwvolinfo", "urxvt -e sh -c 'nwvolinfo -h ; bash'" },
  { "pqlist", "urxvt -e sh -c 'pqlist ; bash'" },
  { "pqrm", "urxvt -e sh -c 'pqrm ; bash'" },
  { "pqstat", "urxvt -e sh -c 'pqstat ; bash'" },
  { "pserver", "urxvt -e sh -c 'pserver -h ; bash'" },
  { "slist", "urxvt -e sh -c 'slist ; bash'" },
  { "neighbor-fingerprint", "urxvt -e sh -c 'neighbor-fingerprint --help ; bash'" },
  { "nemesis", "urxvt -e sh -c 'nemesis -h ; bash'" },
  { "netactview", "urxvt -e sh -c 'netactview ; bash'" },
  { "netactview_polkit", "urxvt -e sh -c 'netactview_polkit ; bash'" },
  { "netcommander", "urxvt -e sh -c 'netcommander ; bash'" },
  { "netcon", "urxvt -e sh -c 'netcon -H ; bash'" },
  { "makelist", "urxvt -e sh -c 'makelist -h ; bash'" },
  { "netmap", "urxvt -e sh -c 'netmap -h ; bash'" },
  { "netreconn", "urxvt -e sh -c 'netreconn -h ; bash'" },
  { "netscan", "urxvt -e sh -c 'netscan -h ; bash'" },
  { "netsed", "urxvt -e sh -c 'netsed -h ; bash'" },
  { "networkmap", "urxvt -e sh -c 'networkmap -h ; bash'" },
  { "netzob", "urxvt -e sh -c 'netzob -h ; bash'" },
  { "nextnet", "urxvt -e sh -c 'nextnet -h ; bash'" },
  { "nfanon", "urxvt -e sh -c 'nfanon -h ; bash'" },
  { "nfcapd", "urxvt -e sh -c 'nfcapd -h ; bash'" },
  { "nfdump", "urxvt -e sh -c 'nfdump -h ; bash'" },
  { "nfexpire", "urxvt -e sh -c 'nfexpire -h ; bash'" },
  { "nfex", "urxvt -e sh -c 'nfex -h ; bash'" },
  { "ngrep", "urxvt -e sh -c 'ngrep -h ; bash'" },
  { "ngrok", "urxvt -e sh -c 'ngrok ; bash'" },
  { "nield", "urxvt -e sh -c 'nield -h ; bash'" },
  { "nipe", "urxvt -e sh -c 'nipe help ; bash'" },
  { "nipper", "urxvt -e sh -c 'nipper --help ; bash'" },
  { "nkiller2", "urxvt -e sh -c 'nkiller2 -h ; bash'" },
  { "nohidy", "urxvt -e sh -c 'nohidy ; bash'" },
  { "nsdtool", "urxvt -e sh -c 'nsdtool ; bash'" },
  { "nsoq", "urxvt -e sh -c 'nsoq ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "obfs4proxy", "urxvt -e sh -c 'obfs4proxy ; bash'" },
  { "opensvp", "urxvt -e sh -c 'opensvp -h ; bash'" },
  { "drone", "urxvt -e sh -c 'drone ; bash'" },
  { "ostinato", "urxvt -e sh -c 'ostinato -h ; bash'" },
  { "packet-o-matic", "urxvt -e sh -c 'packet-o-matic -h ; bash'" },
  { "packETH", "urxvt -e sh -c 'packETH ; bash'" },
  { "packetq", "urxvt -e sh -c 'packetq -h ; bash'" },
  { "packetsender", "urxvt -e sh -c 'packetsender ; bash'" },
  { "packit", "urxvt -e sh -c 'packit ; bash'" },
  { "pcapfex", "urxvt -e sh -c 'pcapfex -h ; bash'" },
  { "pcapfix", "urxvt -e sh -c 'pcapfix ; bash'" },
  { "pcapteller", "urxvt -e sh -c 'pcapteller ; bash'" },
  { "pcapxray", "urxvt -e sh -c 'pcapxray ; bash'" },
  { "phantap-learn", "urxvt -e sh -c 'phantap-learn -h ; bash'" },
  { "pivotsuite", "urxvt -e sh -c 'pivotsuite -h ; bash'" },
  { "pkt2flow", "urxvt -e sh -c 'pkt2flow -h ; bash'" },
  { "plcscan", "urxvt -e sh -c 'plcscan -h ; bash'" },
  { "nfacctd", "urxvt -e sh -c 'nfacctd -h ; bash'" },
  { "pmacct", "urxvt -e sh -c 'pmacct -h ; bash'" },
  { "pmacctd", "urxvt -e sh -c 'pmacctd -h ; bash'" },
  { "pmbgpd", "urxvt -e sh -c 'pmbgpd -h ; bash'" },
  { "pmbmpd", "urxvt -e sh -c 'pmbmpd -h ; bash'" },
  { "pmtelemetryd", "urxvt -e sh -c 'pmtelemetryd -h ; bash'" },
  { "sfacctd", "urxvt -e sh -c 'sfacctd -h ; bash'" },
  { "pr0cks", "urxvt -e sh -c 'pr0cks -h ; bash'" },
  { "prads", "urxvt -e sh -c 'prads -h ; bash'" },
  { "prads-asset-report", "urxvt -e sh -c 'prads-asset-report ; bash'" },
  { "prads2snort", "urxvt -e sh -c 'prads2snort ; bash'" },
  { "prometheus-firewall", "urxvt -e sh -c 'prometheus-firewall ; bash'" },
  { "pth-net", "urxvt -e sh -c 'pth-net -h ; bash'" },
  { "pth-rpcclient", "urxvt -e sh -c 'pth-rpcclient -h ; bash'" },
  { "pth-smbclient", "urxvt -e sh -c 'pth-smbclient -h ; bash'" },
  { "pth-smbget", "urxvt -e sh -c 'pth-smbget -h ; bash'" },
  { "pth-wmic", "urxvt -e sh -c 'pth-wmic -h ; bash'" },
  { "pth-wmis", "urxvt -e sh -c 'pth-wmis -h ; bash'" },
  { "net", "urxvt -e sh -c 'net ; bash'" },
  { "rpcclient", "urxvt -e sh -c 'rpcclient ; bash'" },
  { "smbclient", "urxvt -e sh -c 'smbclient ; bash'" },
  { "smbget", "urxvt -e sh -c 'smbget ; bash'" },
  { "wmic", "urxvt -e sh -c 'wmic ; bash'" },
  { "wmis", "urxvt -e sh -c 'wmis ; bash'" },
  { "ptunnel", "urxvt -e sh -c 'ptunnel -h ; bash'" },
  { "pwnat", "urxvt -e sh -c 'pwnat -h ; bash'" },
  { "pwncat", "urxvt -e sh -c 'pwncat cd /usr/share/windows/pwncat ; ls ; bash'" },
  { "pyersinia", "urxvt -e sh -c 'pyersinia -h ; bash'" },
  { "pyminifakedns", "urxvt -e sh -c 'pyminifakedns ; bash'" },
  { "pyrdp-clonecert", "urxvt -e sh -c 'pyrdp-clonecert -h ; bash'" },
  { "pyrdp-convert", "urxvt -e sh -c 'pyrdp-convert ; bash'" },
  { "pyrdp-mitm", "urxvt -e sh -c 'pyrdp-mitm -h ; bash'" },
  { "cymruwhois", "urxvt -e sh -c 'cymruwhois ; bash'" },
  { "cymruwhois2", "urxvt -e sh -c 'cymruwhois2 ; bash'" },
  { "ldapdomaindump2", "urxvt -e sh -c 'ldapdomaindump2 -h ; bash'" },
  { "ldd2bloodhound2", "urxvt -e sh -c 'ldd2bloodhound2 -h ; bash'" },
  { "ldd2pretty2", "urxvt -e sh -c 'ldd2pretty2 ; bash'" },
  { "rdp-sec-check", "urxvt -e sh -c 'rdp-sec-check -h ; bash'" },
  { "redsocks", "urxvt -e sh -c 'redsocks -h ; bash'" },
  { "responder", "urxvt -e sh -c 'responder -h ; bash'" },
  { "responder-dhcp", "urxvt -e sh -c 'responder-dhcp ; bash'" },
  { "responder-dhcp-auto", "urxvt -e sh -c 'responder-dhcp-auto ; bash'" },
  { "responder-findsqlsrv", "urxvt -e sh -c 'responder-findsqlsrv ; bash'" },
  { "responder-icmp-redirect", "urxvt -e sh -c 'responder-icmp-redirect ; bash'" },
  { "responder-multirelay", "urxvt -e sh -c 'responder-multirelay ; bash'" },
  { "responder-report", "urxvt -e sh -c 'responder-report ; bash'" },
  { "responder-runfinger", "urxvt -e sh -c 'responder-runfinger ; bash'" },
  { "responder-secretsdump", "urxvt -e sh -c 'responder-secretsdump ; bash'" },
  { "Runas.c", "urxvt -e sh -c 'Runas.c ; bash'" },
  { "Syssvc.c", "urxvt -e sh -c 'Syssvc.c ; bash'" },
  { "ridrelay", "urxvt -e sh -c 'ridrelay -h ; bash'" },
  { "rinetd", "urxvt -e sh -c 'rinetd -h ; bash'" },
  { "routerhunter", "urxvt -e sh -c 'routerhunter -h ; bash'" },
  { "rtpbreak", "urxvt -e sh -c 'rtpbreak -h ; bash'" },
  { "sbd", "urxvt -e sh -c 'sbd -h ; bash'" },
  { "sc_ally", "urxvt -e sh -c 'sc_ally -h ; bash'" },
  { "sc_analysis_dump", "urxvt -e sh -c 'sc_analysis_dump -h ; bash'" },
  { "sc_attach", "urxvt -e sh -c 'sc_attach -h ; bash'" },
  { "sc_bdrmap", "urxvt -e sh -c 'sc_bdrmap ; bash'" },
  { "sc_erosprober", "urxvt -e sh -c 'sc_erosprober ; bash'" },
  { "sc_filterpolicy", "urxvt -e sh -c 'sc_filterpolicy -h ; bash'" },
  { "sc_ipiddump", "urxvt -e sh -c 'sc_ipiddump -h ; bash'" },
  { "sc_pinger", "urxvt -e sh -c 'sc_pinger ; bash'" },
  { "sc_prefixscan", "urxvt -e sh -c 'sc_prefixscan ; bash'" },
  { "sc_radargun", "urxvt -e sh -c 'sc_radargun ; bash'" },
  { "sc_remoted", "urxvt -e sh -c 'sc_remoted ; bash'" },
  { "sc_speedtrap", "urxvt -e sh -c 'sc_speedtrap -h ; bash'" },
  { "sc_tbitblind", "urxvt -e sh -c 'sc_tbitblind -h ; bash'" },
  { "sc_tbitpmtud", "urxvt -e sh -c 'sc_tbitpmtud ; bash'" },
  { "sc_tracediff", "urxvt -e sh -c 'sc_tracediff -h ; bash'" },
  { "sc_ttlexp", "urxvt -e sh -c 'sc_ttlexp ; bash'" },
  { "sc_warts2csv", "urxvt -e sh -c 'sc_warts2csv -h ; bash'" },
  { "sc_warts2pcap", "urxvt -e sh -c 'sc_warts2pcap -h ; bash'" },
  { "sc_warts2text", "urxvt -e sh -c 'sc_warts2text -h ; bash'" },
  { "sc_wartscat", "urxvt -e sh -c 'sc_wartscat -h ; bash'" },
  { "sc_wartsdump", "urxvt -e sh -c 'sc_wartsdump -h ; bash'" },
  { "sc_wartsfilter", "urxvt -e sh -c 'sc_wartsfilter ; bash'" },
  { "sc_wartsfix", "urxvt -e sh -c 'sc_wartsfix -h ; bash'" },
  { "scamper", "urxvt -e sh -c 'scamper -h ; bash'" },
  { "of-access", "urxvt -e sh -c 'of-access -h ; bash'" },
  { "of-check", "urxvt -e sh -c 'of-check -h ; bash'" },
  { "of-enum", "urxvt -e sh -c 'of-enum -h ; bash'" },
  { "of-flood", "urxvt -e sh -c 'of-flood -h ; bash'" },
  { "of-map", "urxvt -e sh -c 'of-map -h ; bash'" },
  { "of-scan", "urxvt -e sh -c 'of-scan ; bash'" },
  { "of-switch", "urxvt -e sh -c 'of-switch -h ; bash'" },
  { "sdnpwn", "urxvt -e sh -c 'sdnpwn ; bash'" },
  { "sessionlist", "urxvt -e sh -c 'sessionlist ; bash'" },
  { "seth", "urxvt -e sh -c 'seth -h ; bash'" },
  { "seth-clone-cert", "urxvt -e sh -c 'seth-clone-cert ; bash'" },
  { "flowcap", "urxvt -e sh -c 'flowcap ; bash'" },
  { "num2dot", "urxvt -e sh -c 'num2dot ; bash'" },
  { "rwaddrcount", "urxvt -e sh -c 'rwaddrcount ; bash'" },
  { "rwaggbag", "urxvt -e sh -c 'rwaggbag ; bash'" },
  { "rwaggbagbuild", "urxvt -e sh -c 'rwaggbagbuild ; bash'" },
  { "rwaggbagcat", "urxvt -e sh -c 'rwaggbagcat ; bash'" },
  { "rwaggbagtool", "urxvt -e sh -c 'rwaggbagtool ; bash'" },
  { "rwallformats", "urxvt -e sh -c 'rwallformats ; bash'" },
  { "rwbag", "urxvt -e sh -c 'rwbag ; bash'" },
  { "rwbagbuild", "urxvt -e sh -c 'rwbagbuild ; bash'" },
  { "rwbagcat", "urxvt -e sh -c 'rwbagcat ; bash'" },
  { "rwbagtool", "urxvt -e sh -c 'rwbagtool ; bash'" },
  { "rwcat", "urxvt -e sh -c 'rwcat ; bash'" },
  { "rwcompare", "urxvt -e sh -c 'rwcompare ; bash'" },
  { "rwcount", "urxvt -e sh -c 'rwcount ; bash'" },
  { "rwcut", "urxvt -e sh -c 'rwcut ; bash'" },
  { "rwdedupe", "urxvt -e sh -c 'rwdedupe ; bash'" },
  { "rwfglob", "urxvt -e sh -c 'rwfglob ; bash'" },
  { "rwfileinfo", "urxvt -e sh -c 'rwfileinfo ; bash'" },
  { "rwfilter", "urxvt -e sh -c 'rwfilter ; bash'" },
  { "rwflowpack", "urxvt -e sh -c 'rwflowpack ; bash'" },
  { "rwgeoip2ccmap", "urxvt -e sh -c 'rwgeoip2ccmap ; bash'" },
  { "rwgroup", "urxvt -e sh -c 'rwgroup ; bash'" },
  { "rwguess", "urxvt -e sh -c 'rwguess ; bash'" },
  { "rwidsquery", "urxvt -e sh -c 'rwidsquery ; bash'" },
  { "rwip2cc", "urxvt -e sh -c 'rwip2cc ; bash'" },
  { "rwipfix2silk", "urxvt -e sh -c 'rwipfix2silk ; bash'" },
  { "rwmatch", "urxvt -e sh -c 'rwmatch ; bash'" },
  { "rwnetmask", "urxvt -e sh -c 'rwnetmask ; bash'" },
  { "rwp2yaf2silk", "urxvt -e sh -c 'rwp2yaf2silk ; bash'" },
  { "rwpackchecker", "urxvt -e sh -c 'rwpackchecker ; bash'" },
  { "rwpcut", "urxvt -e sh -c 'rwpcut ; bash'" },
  { "rwpdedupe", "urxvt -e sh -c 'rwpdedupe ; bash'" },
  { "rwpdu2silk", "urxvt -e sh -c 'rwpdu2silk ; bash'" },
  { "rwpmapbuild", "urxvt -e sh -c 'rwpmapbuild ; bash'" },
  { "rwpmapcat", "urxvt -e sh -c 'rwpmapcat ; bash'" },
  { "rwpmatch", "urxvt -e sh -c 'rwpmatch ; bash'" },
  { "rwptoflow", "urxvt -e sh -c 'rwptoflow ; bash'" },
  { "rwrandomizeip", "urxvt -e sh -c 'rwrandomizeip ; bash'" },
  { "rwreceiver", "urxvt -e sh -c 'rwreceiver ; bash'" },
  { "rwrecgenerator", "urxvt -e sh -c 'rwrecgenerator ; bash'" },
  { "rwresolve", "urxvt -e sh -c 'rwresolve ; bash'" },
  { "rwscan", "urxvt -e sh -c 'rwscan ; bash'" },
  { "rwsender", "urxvt -e sh -c 'rwsender ; bash'" },
  { "rwset", "urxvt -e sh -c 'rwset ; bash'" },
  { "rwsetbuild", "urxvt -e sh -c 'rwsetbuild ; bash'" },
  { "rwsetcat", "urxvt -e sh -c 'rwsetcat ; bash'" },
  { "rwsetmember", "urxvt -e sh -c 'rwsetmember ; bash'" },
  { "rwsettool", "urxvt -e sh -c 'rwsettool ; bash'" },
  { "rwsilk2ipfix", "urxvt -e sh -c 'rwsilk2ipfix ; bash'" },
  { "rwsiteinfo", "urxvt -e sh -c 'rwsiteinfo ; bash'" },
  { "rwsort", "urxvt -e sh -c 'rwsort ; bash'" },
  { "rwstats", "urxvt -e sh -c 'rwstats ; bash'" },
  { "rwswapbytes", "urxvt -e sh -c 'rwswapbytes ; bash'" },
  { "rwtotal", "urxvt -e sh -c 'rwtotal ; bash'" },
  { "rwtuc", "urxvt -e sh -c 'rwtuc ; bash'" },
  { "rwuniq", "urxvt -e sh -c 'rwuniq ; bash'" },
  { "smikims-cage", "urxvt -e sh -c 'smikims-cage ; bash'" },
  { "smikims-sweep", "urxvt -e sh -c 'smikims-sweep ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "cookie-parser", "urxvt -e sh -c 'cookie-parser ; bash'" },
  { "email-parser", "urxvt -e sh -c 'email-parser ; bash'" },
  { "packet-parser", "urxvt -e sh -c 'packet-parser ; bash'" },
  { "tcp-parser", "urxvt -e sh -c 'tcp-parser ; bash'" },
  { "sj-commit-results", "urxvt -e sh -c 'sj-commit-results -h ; bash'" },
  { "sj-iptcpopt-probe", "urxvt -e sh -c 'sj-iptcpopt-probe -h ; bash'" },
  { "sniffjoke", "urxvt -e sh -c 'sniffjoke -h ; bash'" },
  { "sniffjoke-autotest", "urxvt -e sh -c 'sniffjoke-autotest -h ; bash'" },
  { "sniffjokectl", "urxvt -e sh -c 'sniffjokectl -h ; bash'" },
  { "regexgen", "urxvt -e sh -c 'regexgen ; bash'" },
  { "sniffles", "urxvt -e sh -c 'sniffles --help ; bash'" },
  { "sniffles-rulegen", "urxvt -e sh -c 'sniffles-rulegen ; bash'" },
  { "snmpbrute", "urxvt -e sh -c 'snmpbrute ; bash'" },
  { "snmp-fuzzer", "urxvt -e sh -c 'snmp-fuzzer ; bash'" },
  { "snmpattack", "urxvt -e sh -c 'snmpattack -h ; bash'" },
  { "snmpcheck-nothink", "urxvt -e sh -c 'snmpcheck-nothink -h ; bash'" },
  { "snort", "urxvt -e sh -c 'snort -h ; bash'" },
  { "u2boat", "urxvt -e sh -c 'u2boat ; bash'" },
  { "u2spewfoo", "urxvt -e sh -c 'u2spewfoo ; bash'" },
  { "u2streamer", "urxvt -e sh -c 'u2streamer ; bash'" },
  { "filan", "urxvt -e sh -c 'filan -h ; bash'" },
  { "procan", "urxvt -e sh -c 'procan -h ; bash'" },
  { "socat", "urxvt -e sh -c 'socat -h ; bash'" },
  { "filan", "urxvt -e sh -c 'filan -h ; bash'" },
  { "procan", "urxvt -e sh -c 'procan -h ; bash'" },
  { "socat", "urxvt -e sh -c 'socat -h ; bash'" },
  { "sockstat", "urxvt -e sh -c 'sockstat -h ; bash'" },
  { "sparta", "urxvt -e sh -c 'sparta ; bash'" },
  { "spipe", "urxvt -e sh -c 'spipe ; bash'" },
  { "spiped", "urxvt -e sh -c 'spiped ; bash'" },
  { "ssdp-scanner", "urxvt -e sh -c 'ssdp-scanner ; bash'" },
  { "sudoers-add", "urxvt -e sh -c 'sudoers-add ; bash'" },
  { "ssl-phuck3r", "urxvt -e sh -c 'ssl-phuck3r -h ; bash'" },
  { "sslh", "urxvt -e sh -c 'sslh -h ; bash'" },
  { "sslh-fork", "urxvt -e sh -c 'sslh-fork -h ; bash'" },
  { "sslh-select", "urxvt -e sh -c 'sslh-select -h ; bash'" },
  { "sslh", "urxvt -e sh -c 'sslh -h ; bash'" },
  { "sslh-fork", "urxvt -e sh -c 'sslh-fork -h ; bash'" },
  { "sslh-select", "urxvt -e sh -c 'sslh-select -h ; bash'" },
  { "sslstrip", "urxvt -e sh -c 'sslstrip -h ; bash'" },
  { "mitm_listener", "urxvt -e sh -c 'mitm_listener ; bash'" },
  { "stegosip", "urxvt -e sh -c 'stegosip ; bash'" },
  { "stenographer", "urxvt -e sh -c 'stenographer -h ; bash'" },
  { "stunnel", "urxvt -e sh -c 'stunnel ; bash'" },
  { "stunnel3", "urxvt -e sh -c 'stunnel3 ; bash'" },
  { "stunnel", "urxvt -e sh -c 'stunnel ; bash'" },
  { "stunnel3", "urxvt -e sh -c 'stunnel3 ; bash'" },
  { "swaks", "urxvt -e sh -c 'swaks --help ; bash'" },
  { "sylkie", "urxvt -e sh -c 'sylkie -h ; bash'" },
  { "t50", "urxvt -e sh -c 't50 --help ; bash'" },
  { "tabi", "urxvt -e sh -c 'tabi -h ; bash'" },
  { "tcpcontrol-fuzzer", "urxvt -e sh -c 'tcpcontrol-fuzzer ; bash'" },
  { "tcpdstat", "urxvt -e sh -c 'tcpdstat -h ; bash'" },
  { "tcpdump", "urxvt -e sh -c 'tcpdump -h ; bash'" },
  { "tcpextract", "urxvt -e sh -c 'tcpextract -h ; bash'" },
  { "tcpflow", "urxvt -e sh -c 'tcpflow -h ; bash'" },
  { "tcpbridge", "urxvt -e sh -c 'tcpbridge -h ; bash'" },
  { "tcpcapinfo", "urxvt -e sh -c 'tcpcapinfo ; bash'" },
  { "tcpprep", "urxvt -e sh -c 'tcpprep -h ; bash'" },
  { "tcprewrite", "urxvt -e sh -c 'tcprewrite -h ; bash'" },
  { "tcpbridge", "urxvt -e sh -c 'tcpbridge -h ; bash'" },
  { "tcpcapinfo", "urxvt -e sh -c 'tcpcapinfo ; bash'" },
  { "tcpprep", "urxvt -e sh -c 'tcpprep -h ; bash'" },
  { "tcprewrite", "urxvt -e sh -c 'tcprewrite -h ; bash'" },
  { "tcptrace", "urxvt -e sh -c 'tcptrace ; bash'" },
  { "tcptraceroute", "urxvt -e sh -c 'tcptraceroute ; bash'" },
  { "tcpwatch", "urxvt -e sh -c 'tcpwatch ; bash'" },
  { "tftp-proxy", "urxvt -e sh -c 'tftp-proxy -h ; bash'" },
  { "tgcd", "urxvt -e sh -c 'tgcd -h ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "tincd", "urxvt -e sh -c 'tincd ; bash'" },
  { "topera", "urxvt -e sh -c 'topera -h ; bash'" },
  { "tor", "urxvt -e sh -c 'tor -h ; bash'" },
  { "tor-gencert", "urxvt -e sh -c 'tor-gencert ; bash'" },
  { "tor-print-ed-signing-cert", "urxvt -e sh -c 'tor-print-ed-signing-cert ; bash'" },
  { "tor-resolve", "urxvt -e sh -c 'tor-resolve ; bash'" },
  { "torify", "urxvt -e sh -c 'torify -h ; bash'" },
  { "tor", "urxvt -e sh -c 'tor -h ; bash'" },
  { "tor-gencert", "urxvt -e sh -c 'tor-gencert ; bash'" },
  { "tor-print-ed-signing-cert", "urxvt -e sh -c 'tor-print-ed-signing-cert ; bash'" },
  { "tor-resolve", "urxvt -e sh -c 'tor-resolve ; bash'" },
  { "torify", "urxvt -e sh -c 'torify -h ; bash'" },
  { "tunna-proxy", "urxvt -e sh -c 'tunna-proxy ; bash'" },
  { "tunna-webserver", "urxvt -e sh -c 'tunna-webserver ; bash'" },
  { "udp2raw", "urxvt -e sh -c 'udp2raw ; bash'" },
  { "udpastcp", "urxvt -e sh -c 'udpastcp ; bash'" },
  { "udptunnel", "urxvt -e sh -c 'udptunnel -h ; bash'" },
  { "umit", "urxvt -e sh -c 'umit -h ; bash'" },
  { "vault-scanner", "urxvt -e sh -c 'vault-scanner ; bash'" },
  { "vlan-hopping", "urxvt -e sh -c 'vlan-hopping ; bash'" },
  { "pivotc", "urxvt -e sh -c 'pivotc -h ; bash'" },
  { "pivots", "urxvt -e sh -c 'pivots -h ; bash'" },
  { "webfixy", "urxvt -e sh -c 'webfixy -h ; bash'" },
  { "websockify", "urxvt -e sh -c 'websockify -h ; bash'" },
  { "capinfos", "urxvt -e sh -c 'capinfos -h ; bash'" },
  { "captype", "urxvt -e sh -c 'captype ; bash'" },
  { "dumpcap", "urxvt -e sh -c 'dumpcap ; bash'" },
  { "editcap", "urxvt -e sh -c 'editcap ; bash'" },
  { "idl2wrs", "urxvt -e sh -c 'idl2wrs ; bash'" },
  { "mergecap", "urxvt -e sh -c 'mergecap -h ; bash'" },
  { "randpkt", "urxvt -e sh -c 'randpkt ; bash'" },
  { "reordercap", "urxvt -e sh -c 'reordercap ; bash'" },
  { "sharkd", "urxvt -e sh -c 'sharkd ; bash'" },
  { "text2pcap", "urxvt -e sh -c 'text2pcap ; bash'" },
  { "capinfos", "urxvt -e sh -c 'capinfos -h ; bash'" },
  { "captype", "urxvt -e sh -c 'captype ; bash'" },
  { "dumpcap", "urxvt -e sh -c 'dumpcap ; bash'" },
  { "editcap", "urxvt -e sh -c 'editcap ; bash'" },
  { "idl2wrs", "urxvt -e sh -c 'idl2wrs ; bash'" },
  { "mergecap", "urxvt -e sh -c 'mergecap -h ; bash'" },
  { "randpkt", "urxvt -e sh -c 'randpkt ; bash'" },
  { "reordercap", "urxvt -e sh -c 'reordercap ; bash'" },
  { "sharkd", "urxvt -e sh -c 'sharkd ; bash'" },
  { "text2pcap", "urxvt -e sh -c 'text2pcap ; bash'" },
  { "wol-e", "urxvt -e sh -c 'wol-e -h ; bash'" },
  { "xfltreat", "urxvt -e sh -c 'xfltreat -h ; bash'" },
  { "dema", "urxvt -e sh -c 'dema ; bash'" },
  { "mfbc", "urxvt -e sh -c 'mfbc ; bash'" },
  { "mfile", "urxvt -e sh -c 'mfile ; bash'" },
  { "mpaltalk", "urxvt -e sh -c 'mpaltalk ; bash'" },
  { "msite", "urxvt -e sh -c 'msite ; bash'" },
  { "mwebymsg", "urxvt -e sh -c 'mwebymsg ; bash'" },
  { "mwmail", "urxvt -e sh -c 'mwmail ; bash'" },
  { "trigcap", "urxvt -e sh -c 'trigcap ; bash'" },
  { "xxeserv", "urxvt -e sh -c 'xxeserv -h ; bash'" },
  { "airdaemon", "urxvt -e sh -c 'airdaemon ; bash'" },
  { "filedaemon", "urxvt -e sh -c 'filedaemon ; bash'" },
  { "yaf", "urxvt -e sh -c 'yaf --help ; bash'" },
  { "yafMeta2Pcap", "urxvt -e sh -c 'yafMeta2Pcap --help ; bash'" },
  { "yafcollect", "urxvt -e sh -c 'yafcollect -h ; bash'" },
  { "yafscii", "urxvt -e sh -c 'yafscii --help ; bash'" },
  { "yersinia", "urxvt -e sh -c 'yersinia --help ; bash'" },
  { "zackattack", "urxvt -e sh -c 'zackattack -h ; bash'" },
  { "zarp", "urxvt -e sh -c 'zarp -h ; bash'" },
  { "zdns", "urxvt -e sh -c 'zdns -h ; bash'" },
  { "bifcl", "urxvt -e sh -c 'bifcl ; bash'" },
  { "binpac", "urxvt -e sh -c 'binpac ; bash'" },
  { "bro", "urxvt -e sh -c 'bro -h ; bash'" },
  { "bro-cut", "urxvt -e sh -c 'bro-cut ; bash'" },
  { "broctl", "urxvt -e sh -c 'broctl ; bash'" },
  { "broker-benchmark", "urxvt -e sh -c 'broker-benchmark ; bash'" },
  { "broker-cluster-benchmark", "urxvt -e sh -c 'broker-cluster-benchmark ; bash'" },
  { "btest", "urxvt -e sh -c 'btest ; bash'" },
  { "btest-ask-update", "urxvt -e sh -c 'btest-ask-update ; bash'" },
  { "btest-bg-run", "urxvt -e sh -c 'btest-bg-run ; bash'" },
  { "btest-bg-run-helper", "urxvt -e sh -c 'btest-bg-run-helper ; bash'" },
  { "btest-bg-wait", "urxvt -e sh -c 'btest-bg-wait ; bash'" },
  { "btest-diff", "urxvt -e sh -c 'btest-diff ; bash'" },
  { "btest-diff-rst", "urxvt -e sh -c 'btest-diff-rst ; bash'" },
  { "btest-progress", "urxvt -e sh -c 'btest-progress ; bash'" },
  { "btest-rst-include", "urxvt -e sh -c 'btest-rst-include ; bash'" },
  { "btest-rst-pipe", "urxvt -e sh -c 'btest-rst-pipe ; bash'" },
  { "btest-setsid", "urxvt -e sh -c 'btest-setsid ; bash'" },
  { "paraglob-test", "urxvt -e sh -c 'paraglob-test ; bash'" },
  { "trace-summary", "urxvt -e sh -c 'trace-summary ; bash'" },
  { "zeek", "urxvt -e sh -c 'zeek ; bash'" },
  { "zeek-archiver", "urxvt -e sh -c 'zeek-archiver ; bash'" },
  { "zeek-cut", "urxvt -e sh -c 'zeek-cut ; bash'" },
  { "zeekctl", "urxvt -e sh -c 'zeekctl ; bash'" },
  { "zkg", "urxvt -e sh -c 'zkg ; bash'" },
  { "adtrace", "urxvt -e sh -c 'adtrace ; bash'" },
  { "rst", "urxvt -e sh -c 'rst ; bash'" },
  { "ztelnet", "urxvt -e sh -c 'ztelnet ; bash'" },
}

nfcmenu = {
  { "chamlog", "urxvt -e sh -c 'chamlog -h ; bash'" },
  { "chamtool", "urxvt -e sh -c 'chamtool -h ; bash'" },
  { "lsnfc", "urxvt -e sh -c 'lsnfc ; bash'" },
}

packermenu = {
  { "amber", "urxvt -e sh -c 'amber ; bash'" },
  { "createnpk", "urxvt -e sh -c 'createnpk ; bash'" },
  { "dumpnpk", "urxvt -e sh -c 'dumpnpk ; bash'" },
  { "unpacknpk", "urxvt -e sh -c 'unpacknpk ; bash'" },
  { "packerid", "urxvt -e sh -c 'packerid -h ; bash'" },
  { "sherlocked", "urxvt -e sh -c 'sherlocked ; bash'" },
  { "stripx", "urxvt -e sh -c 'stripx ; bash'" },
  { "stub", "urxvt -e sh -c 'stub ; bash'" },
  { "vbsmin", "urxvt -e sh -c 'vbsmin -h ; bash'" },
}

proxymenu = {
  { "3proxy", "urxvt -e sh -c '3proxy --help ; bash'" },
  { "ftppr", "urxvt -e sh -c 'ftppr --help ; bash'" },
  { "mycrypt", "urxvt -e sh -c 'mycrypt --help ; bash'" },
  { "pop3p", "urxvt -e sh -c 'pop3p --help ; bash'" },
  { "socks", "urxvt -e sh -c 'socks -h ; bash'" },
  { "tcppm", "urxvt -e sh -c 'tcppm --help ; bash'" },
  { "udppm", "urxvt -e sh -c 'udppm --help ; bash'" },
  { "bdfproxy", "urxvt -e sh -c 'bdfproxy -h ; bash'" },
  { "binproxy", "urxvt -e sh -c 'binproxy --help ; bash'" },
  { "chiron-attacks", "urxvt -e sh -c 'chiron-attacks ; bash'" },
  { "chiron-local-link", "urxvt -e sh -c 'chiron-local-link ; bash'" },
  { "chiron-nd", "urxvt -e sh -c 'chiron-nd ; bash'" },
  { "chiron-proxy", "urxvt -e sh -c 'chiron-proxy ; bash'" },
  { "chiron-scanner", "urxvt -e sh -c 'chiron-scanner ; bash'" },
  { "chisel", "urxvt -e sh -c 'chisel ; bash'" },
  { "cntlm", "urxvt -e sh -c 'cntlm -h ; bash'" },
  { "corkscrew", "urxvt -e sh -c 'corkscrew ; bash'" },
  { "datajackproxy", "urxvt -e sh -c 'datajackproxy -h ; bash'" },
  { "delorean", "urxvt -e sh -c 'delorean -h ; bash'" },
  { "dns-reverse-proxy", "urxvt -e sh -c 'dns-reverse-proxy -h ; bash'" },
  { "dnschef", "urxvt -e sh -c 'dnschef -h ; bash'" },
  { "elite-proxy-finder", "urxvt -e sh -c 'elite-proxy-finder -h ; bash'" },
  { "fakedns", "urxvt -e sh -c 'fakedns ; bash'" },
  { "fakenet", "urxvt -e sh -c 'fakenet -h ; bash'" },
  { "hetty", "urxvt -e sh -c 'hetty -h ; bash'" },
  { "hyperfox", "urxvt -e sh -c 'hyperfox -h ; bash'" },
  { "jondo", "urxvt -e sh -c 'jondo ; bash'" },
  { "mallory", "urxvt -e sh -c 'mallory -h ; bash'" },
  { "mitm", "urxvt -e sh -c 'mitm -h ; bash'" },
  { "mitm-relay", "urxvt -e sh -c 'mitm-relay -h ; bash'" },
  { "mitmf", "urxvt -e sh -c 'mitmf -h ; bash'" },
  { "mitmproxy", "urxvt -e sh -c 'mitmproxy -h ; bash'" },
  { "mitmweb", "urxvt -e sh -c 'mitmweb ; bash'" },
  { "mitmproxy", "urxvt -e sh -c 'mitmproxy -h ; bash'" },
  { "mitmweb", "urxvt -e sh -c 'mitmweb ; bash'" },
  { "mubeng", "urxvt -e sh -c 'mubeng -h ; bash'" },
  { "muraena", "urxvt -e sh -c 'muraena -h ; bash'" },
  { "neo-regeorg", "urxvt -e sh -c 'neo-regeorg ; bash'" },
  { "obfs4proxy", "urxvt -e sh -c 'obfs4proxy ; bash'" },
  { "pown", "urxvt -e sh -c 'pown ; bash'" },
  { "pr0cks", "urxvt -e sh -c 'pr0cks -h ; bash'" },
  { "proxenet", "urxvt -e sh -c 'proxenet -h ; bash'" },
  { "proxenet-control-cli", "urxvt -e sh -c 'proxenet-control-cli ; bash'" },
  { "proxenet-control-web", "urxvt -e sh -c 'proxenet-control-web ; bash'" },
  { "proxify", "urxvt -e sh -c 'proxify -h ; bash'" },
  { "proxychains", "urxvt -e sh -c 'proxychains ; bash'" },
  { "proxychains4", "urxvt -e sh -c 'proxychains4 ; bash'" },
  { "proxychains4-daemon", "urxvt -e sh -c 'proxychains4-daemon ; bash'" },
  { "proxychains", "urxvt -e sh -c 'proxychains ; bash'" },
  { "proxychains4", "urxvt -e sh -c 'proxychains4 ; bash'" },
  { "proxychains4-daemon", "urxvt -e sh -c 'proxychains4-daemon ; bash'" },
  { "proxycheck", "urxvt -e sh -c 'proxycheck -h ; bash'" },
  { "proxyp", "urxvt -e sh -c 'proxyp -h ; bash'" },
  { "proxytunnel", "urxvt -e sh -c 'proxytunnel -h ; bash'" },
  { "pwncat", "urxvt -e sh -c 'pwncat cd /usr/share/windows/pwncat ; ls ; bash'" },
  { "ratproxy", "urxvt -e sh -c 'ratproxy -h ; bash'" },
  { "redsocks", "urxvt -e sh -c 'redsocks -h ; bash'" },
  { "regeorg", "urxvt -e sh -c 'regeorg -h ; bash'" },
  { "rpivot-client", "urxvt -e sh -c 'rpivot-client -h ; bash'" },
  { "rpivot-server", "urxvt -e sh -c 'rpivot-server -h ; bash'" },
  { "sergio-proxy", "urxvt -e sh -c 'sergio-proxy -h ; bash'" },
  { "snarf-mitm", "urxvt -e sh -c 'snarf-mitm ; bash'" },
  { "express", "urxvt -e sh -c 'express ; bash'" },
  { "marked", "urxvt -e sh -c 'marked ; bash'" },
  { "soapui", "urxvt -e sh -c 'soapui ; bash'" },
  { "soapui-errors.log", "urxvt -e sh -c 'soapui-errors.log ; bash'" },
  { "soapui.log", "urxvt -e sh -c 'soapui.log ; bash'" },
  { "starter-page.html", "urxvt -e sh -c 'starter-page.html ; bash'" },
  { "sudoers-add", "urxvt -e sh -c 'sudoers-add ; bash'" },
  { "sslnuke", "urxvt -e sh -c 'sslnuke ; bash'" },
  { "sslstrip", "urxvt -e sh -c 'sslstrip -h ; bash'" },
  { "ssrf-proxy", "urxvt -e sh -c 'ssrf-proxy -h ; bash'" },
  { "console", "urxvt -e sh -c 'console ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "ssrf-proxy", "urxvt -e sh -c 'ssrf-proxy -h ; bash'" },
  { "mitm_listener", "urxvt -e sh -c 'mitm_listener ; bash'" },
  { "striptls", "urxvt -e sh -c 'striptls -h ; bash'" },
  { "tftp-proxy", "urxvt -e sh -c 'tftp-proxy -h ; bash'" },
  { "tinyproxy", "urxvt -e sh -c 'tinyproxy -h ; bash'" },
  { "tor", "urxvt -e sh -c 'tor -h ; bash'" },
  { "tor-gencert", "urxvt -e sh -c 'tor-gencert ; bash'" },
  { "tor-print-ed-signing-cert", "urxvt -e sh -c 'tor-print-ed-signing-cert ; bash'" },
  { "tor-resolve", "urxvt -e sh -c 'tor-resolve ; bash'" },
  { "torify", "urxvt -e sh -c 'torify -h ; bash'" },
  { "tor", "urxvt -e sh -c 'tor -h ; bash'" },
  { "tor-gencert", "urxvt -e sh -c 'tor-gencert ; bash'" },
  { "tor-print-ed-signing-cert", "urxvt -e sh -c 'tor-print-ed-signing-cert ; bash'" },
  { "tor-resolve", "urxvt -e sh -c 'tor-resolve ; bash'" },
  { "torify", "urxvt -e sh -c 'torify -h ; bash'" },
  { "torsocks", "urxvt -e sh -c 'torsocks -h ; bash'" },
  { "tunna-proxy", "urxvt -e sh -c 'tunna-proxy ; bash'" },
  { "tunna-webserver", "urxvt -e sh -c 'tunna-webserver ; bash'" },
  { "venom-admin", "urxvt -e sh -c 'venom-admin ; bash'" },
  { "venom-agent", "urxvt -e sh -c 'venom-agent ; bash'" },
  { "webfixy", "urxvt -e sh -c 'webfixy -h ; bash'" },
  { "webscarab", "urxvt -e sh -c 'webscarab ; bash'" },
  { "electron-1.7", "urxvt -e sh -c 'electron-1.7 ; bash'" },
  { "wssip", "urxvt -e sh -c 'wssip help ; bash'" },
  { "wsuspect-proxy", "urxvt -e sh -c 'wsuspect-proxy ; bash'" },
  { "ycrawler", "urxvt -e sh -c 'ycrawler -h ; bash'" },
  { "zaproxy", "urxvt -e sh -c 'zaproxy ; bash'" },
}

radiomenu = {
  { "gpredict", "urxvt -e sh -c 'gpredict -h ; bash'" },
  { "modes_rx", "urxvt -e sh -c 'modes_rx ; bash'" },
  { "grgsm_capture", "urxvt -e sh -c 'grgsm_capture ; bash'" },
  { "grgsm_channelize", "urxvt -e sh -c 'grgsm_channelize -h ; bash'" },
  { "grgsm_decode", "urxvt -e sh -c 'grgsm_decode -h ; bash'" },
  { "grgsm_livemon", "urxvt -e sh -c 'grgsm_livemon -h ; bash'" },
  { "grgsm_livemon_headless", "urxvt -e sh -c 'grgsm_livemon_headless -h ; bash'" },
  { "grgsm_scanner", "urxvt -e sh -c 'grgsm_scanner -h ; bash'" },
  { "grgsm_trx", "urxvt -e sh -c 'grgsm_trx -h ; bash'" },
  { "tgatoluma", "urxvt -e sh -c 'tgatoluma ; bash'" },
  { "hackrf_clock", "urxvt -e sh -c 'hackrf_clock ; bash'" },
  { "hackrf_debug", "urxvt -e sh -c 'hackrf_debug ; bash'" },
  { "hackrf_info", "urxvt -e sh -c 'hackrf_info ; bash'" },
  { "hackrf_operacake", "urxvt -e sh -c 'hackrf_operacake ; bash'" },
  { "hackrf_sweep", "urxvt -e sh -c 'hackrf_sweep ; bash'" },
  { "hackrf_transfer", "urxvt -e sh -c 'hackrf_transfer ; bash'" },
  { "hackrf_clock", "urxvt -e sh -c 'hackrf_clock ; bash'" },
  { "hackrf_debug", "urxvt -e sh -c 'hackrf_debug ; bash'" },
  { "hackrf_info", "urxvt -e sh -c 'hackrf_info ; bash'" },
  { "hackrf_operacake", "urxvt -e sh -c 'hackrf_operacake ; bash'" },
  { "hackrf_sweep", "urxvt -e sh -c 'hackrf_sweep ; bash'" },
  { "hackrf_transfer", "urxvt -e sh -c 'hackrf_transfer ; bash'" },
  { "osmo-arfcn", "urxvt -e sh -c 'osmo-arfcn ; bash'" },
  { "osmo-auc-gen", "urxvt -e sh -c 'osmo-auc-gen ; bash'" },
  { "multimon-ng", "urxvt -e sh -c 'multimon-ng ; bash'" },
  { "proxmark", "urxvt -e sh -c 'proxmark ; bash'" },
  { "proxmark-fpga-compress", "urxvt -e sh -c 'proxmark-fpga-compress ; bash'" },
  { "rtlamr", "urxvt -e sh -c 'rtlamr -h ; bash'" },
  { "rtlizer", "urxvt -e sh -c 'rtlizer -h ; bash'" },
  { "simtrace2-list", "urxvt -e sh -c 'simtrace2-list -h ; bash'" },
  { "simtrace2-remsim", "urxvt -e sh -c 'simtrace2-remsim -h ; bash'" },
  { "simtrace2-remsim-usb2udp", "urxvt -e sh -c 'simtrace2-remsim-usb2udp -h ; bash'" },
  { "simtrace2-sniff", "urxvt -e sh -c 'simtrace2-sniff -h ; bash'" },
  { "urh", "urxvt -e sh -c 'urh ; bash'" },
  { "urh_cli", "urxvt -e sh -c 'urh_cli ; bash'" },
  { "urh", "urxvt -e sh -c 'urh ; bash'" },
  { "urh_cli", "urxvt -e sh -c 'urh_cli ; bash'" },
}

reconmenu = {
  { "activedirectoryenum", "urxvt -e sh -c 'activedirectoryenum ; bash'" },
  { "ad-ldap-enum", "urxvt -e sh -c 'ad-ldap-enum -h ; bash'" },
  { "adfind", "urxvt -e sh -c 'adfind -h ; bash'" },
  { "aiodnsbrute", "urxvt -e sh -c 'aiodnsbrute --help ; bash'" },
  { "altdns", "urxvt -e sh -c 'altdns -h ; bash'" },
  { "amass", "urxvt -e sh -c 'amass -h ; bash'" },
  { "apkstat", "urxvt -e sh -c 'apkstat -h ; bash'" },
  { "aquatone", "urxvt -e sh -c 'aquatone ; bash'" },
  { "assetfinder", "urxvt -e sh -c 'assetfinder -h ; bash'" },
  { "atear", "urxvt -e sh -c 'atear -h ; bash'" },
  { "automato", "urxvt -e sh -c 'automato ; bash'" },
  { "autorecon", "urxvt -e sh -c 'autorecon -h ; bash'" },
  { "autosint", "urxvt -e sh -c 'autosint -h ; bash'" },
  { "aws-inventory", "urxvt -e sh -c 'aws-inventory -h ; bash'" },
  { "aztarna", "urxvt -e sh -c 'aztarna -h ; bash'" },
  { "badkarma", "urxvt -e sh -c 'badkarma ; bash'" },
  { "badministration", "urxvt -e sh -c 'badministration --help ; bash'" },
  { "barq", "urxvt -e sh -c 'barq -h ; bash'" },
  { "basedomainname", "urxvt -e sh -c 'basedomainname -h ; bash'" },
  { "belati", "urxvt -e sh -c 'belati -h ; bash'" },
  { "bfac", "urxvt -e sh -c 'bfac -h ; bash'" },
  { "billcipher", "urxvt -e sh -c 'billcipher ; bash'" },
  { "arpaname", "urxvt -e sh -c 'arpaname ; bash'" },
  { "delv", "urxvt -e sh -c 'delv ; bash'" },
  { "dig", "urxvt -e sh -c 'dig -h ; bash'" },
  { "dnssec-cds", "urxvt -e sh -c 'dnssec-cds ; bash'" },
  { "dnssec-checkds", "urxvt -e sh -c 'dnssec-checkds ; bash'" },
  { "dnssec-coverage", "urxvt -e sh -c 'dnssec-coverage ; bash'" },
  { "dnssec-revoke", "urxvt -e sh -c 'dnssec-revoke ; bash'" },
  { "dnssec-settime", "urxvt -e sh -c 'dnssec-settime ; bash'" },
  { "dnssec-signzone", "urxvt -e sh -c 'dnssec-signzone ; bash'" },
  { "dnssec-verify", "urxvt -e sh -c 'dnssec-verify ; bash'" },
  { "host", "urxvt -e sh -c 'host ; bash'" },
  { "mdig", "urxvt -e sh -c 'mdig ; bash'" },
  { "named", "urxvt -e sh -c 'named ; bash'" },
  { "named-checkzone", "urxvt -e sh -c 'named-checkzone ; bash'" },
  { "named-compilezone", "urxvt -e sh -c 'named-compilezone ; bash'" },
  { "named-journalprint", "urxvt -e sh -c 'named-journalprint ; bash'" },
  { "named-nzd2nzf", "urxvt -e sh -c 'named-nzd2nzf ; bash'" },
  { "named-rrchecker", "urxvt -e sh -c 'named-rrchecker ; bash'" },
  { "nslookup", "urxvt -e sh -c 'nslookup ; bash'" },
  { "nsupdate", "urxvt -e sh -c 'nsupdate ; bash'" },
  { "rndc", "urxvt -e sh -c 'rndc ; bash'" },
  { "arpaname", "urxvt -e sh -c 'arpaname ; bash'" },
  { "delv", "urxvt -e sh -c 'delv ; bash'" },
  { "dig", "urxvt -e sh -c 'dig -h ; bash'" },
  { "dnssec-cds", "urxvt -e sh -c 'dnssec-cds ; bash'" },
  { "dnssec-checkds", "urxvt -e sh -c 'dnssec-checkds ; bash'" },
  { "dnssec-coverage", "urxvt -e sh -c 'dnssec-coverage ; bash'" },
  { "dnssec-revoke", "urxvt -e sh -c 'dnssec-revoke ; bash'" },
  { "dnssec-settime", "urxvt -e sh -c 'dnssec-settime ; bash'" },
  { "dnssec-signzone", "urxvt -e sh -c 'dnssec-signzone ; bash'" },
  { "dnssec-verify", "urxvt -e sh -c 'dnssec-verify ; bash'" },
  { "host", "urxvt -e sh -c 'host ; bash'" },
  { "mdig", "urxvt -e sh -c 'mdig ; bash'" },
  { "named", "urxvt -e sh -c 'named ; bash'" },
  { "named-checkzone", "urxvt -e sh -c 'named-checkzone ; bash'" },
  { "named-compilezone", "urxvt -e sh -c 'named-compilezone ; bash'" },
  { "named-journalprint", "urxvt -e sh -c 'named-journalprint ; bash'" },
  { "named-nzd2nzf", "urxvt -e sh -c 'named-nzd2nzf ; bash'" },
  { "named-rrchecker", "urxvt -e sh -c 'named-rrchecker ; bash'" },
  { "nslookup", "urxvt -e sh -c 'nslookup ; bash'" },
  { "nsupdate", "urxvt -e sh -c 'nsupdate ; bash'" },
  { "rndc", "urxvt -e sh -c 'rndc ; bash'" },
  { "bing-ip2hosts", "urxvt -e sh -c 'bing-ip2hosts ; bash'" },
  { "birp", "urxvt -e sh -c 'birp -h ; bash'" },
  { "blackbox-scanner", "urxvt -e sh -c 'blackbox-scanner -h ; bash'" },
  { "bloodhound", "urxvt -e sh -c 'bloodhound -h ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "mustache", "urxvt -e sh -c 'mustache ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "bluto", "urxvt -e sh -c 'bluto ; bash'" },
  { "buster", "urxvt -e sh -c 'buster -h ; bash'" },
  { "c5scan", "urxvt -e sh -c 'c5scan -h ; bash'" },
  { "canari", "urxvt -e sh -c 'canari -h ; bash'" },
  { "dispatcher", "urxvt -e sh -c 'dispatcher -h ; bash'" },
  { "pysudo", "urxvt -e sh -c 'pysudo -h ; bash'" },
  { "cantoolz", "urxvt -e sh -c 'cantoolz -h ; bash'" },
  { "cardpwn", "urxvt -e sh -c 'cardpwn ; bash'" },
  { "casefile", "urxvt -e sh -c 'casefile --help ; bash'" },
  { "maltego", "urxvt -e sh -c 'maltego -h ; bash'" },
  { "maltego.ico", "urxvt -e sh -c 'maltego.ico ; bash'" },
  { "catnthecanary", "urxvt -e sh -c 'catnthecanary ; bash'" },
  { "ccrawldns", "urxvt -e sh -c 'ccrawldns -h ; bash'" },
  { "certgraph", "urxvt -e sh -c 'certgraph -h ; bash'" },
  { "chaos-client", "urxvt -e sh -c 'chaos-client -h ; bash'" },
  { "chaosmap", "urxvt -e sh -c 'chaosmap ; bash'" },
  { "citadel", "urxvt -e sh -c 'citadel -h ; bash'" },
  { "cloud-buster", "urxvt -e sh -c 'cloud-buster -h ; bash'" },
  { "cloudfail", "urxvt -e sh -c 'cloudfail -h ; bash'" },
  { "cloudlist", "urxvt -e sh -c 'cloudlist -h ; bash'" },
  { "cloudmare", "urxvt -e sh -c 'cloudmare -h ; bash'" },
  { "cloudunflare", "urxvt -e sh -c 'cloudunflare ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "cmsscanner", "urxvt -e sh -c 'cmsscanner -h ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "cnamulator", "urxvt -e sh -c 'cnamulator -h ; bash'" },
  { "commonspeak", "urxvt -e sh -c 'commonspeak -h ; bash'" },
  { "cr3dov3r", "urxvt -e sh -c 'cr3dov3r -h ; bash'" },
  { "crawlic", "urxvt -e sh -c 'crawlic -h ; bash'" },
  { "crosslinked", "urxvt -e sh -c 'crosslinked -h ; bash'" },
  { "crosslinked-pwd-gen", "urxvt -e sh -c 'crosslinked-pwd-gen ; bash'" },
  { "crosslinked-user-gen", "urxvt -e sh -c 'crosslinked-user-gen -h ; bash'" },
  { "ct-exposer", "urxvt -e sh -c 'ct-exposer -h ; bash'" },
  { "CutyCapt", "urxvt -e sh -c 'CutyCapt ; bash'" },
  { "d-tect", "urxvt -e sh -c 'd-tect ; bash'" },
  { "darkscrape", "urxvt -e sh -c 'darkscrape ; bash'" },
  { "davscan", "urxvt -e sh -c 'davscan -h ; bash'" },
  { "detectem", "urxvt -e sh -c 'detectem --help ; bash'" },
  { "dga-detection", "urxvt -e sh -c 'dga-detection -h ; bash'" },
  { "dns-parallel-prober", "urxvt -e sh -c 'dns-parallel-prober -h ; bash'" },
  { "dns2geoip", "urxvt -e sh -c 'dns2geoip -h ; bash'" },
  { "dnsbrute", "urxvt -e sh -c 'dnsbrute -h ; bash'" },
  { "dnscobra", "urxvt -e sh -c 'dnscobra -h ; bash'" },
  { "dnsenum", "urxvt -e sh -c 'dnsenum ; bash'" },
  { "dnsgrep", "urxvt -e sh -c 'dnsgrep -h ; bash'" },
  { "dnsgrep-server", "urxvt -e sh -c 'dnsgrep-server -h ; bash'" },
  { "dnsprobe", "urxvt -e sh -c 'dnsprobe -h ; bash'" },
  { "dnsrecon", "urxvt -e sh -c 'dnsrecon -h ; bash'" },
  { "dnssearch", "urxvt -e sh -c 'dnssearch -h ; bash'" },
  { "dnsspider", "urxvt -e sh -c 'dnsspider -h ; bash'" },
  { "dnstracer", "urxvt -e sh -c 'dnstracer ; bash'" },
  { "dnstwist", "urxvt -e sh -c 'dnstwist -h ; bash'" },
  { "dnswalk", "urxvt -e sh -c 'dnswalk --help ; bash'" },
  { "dnsx", "urxvt -e sh -c 'dnsx -h ; bash'" },
  { "domain-analyzer", "urxvt -e sh -c 'domain-analyzer -h ; bash'" },
  { "domain-analyzer-crawler", "urxvt -e sh -c 'domain-analyzer-crawler -h ; bash'" },
  { "domain-stats", "urxvt -e sh -c 'domain-stats -h ; bash'" },
  { "domain-stats-settings", "urxvt -e sh -c 'domain-stats-settings ; bash'" },
  { "domain-stats-utils", "urxvt -e sh -c 'domain-stats-utils ; bash'" },
  { "domained", "urxvt -e sh -c 'domained -h ; bash'" },
  { "domainhunter", "urxvt -e sh -c 'domainhunter -h ; bash'" },
  { "doork", "urxvt -e sh -c 'doork -h ; bash'" },
  { "dradis-ce", "urxvt -e sh -c 'dradis-ce ; bash'" },
  { "rails", "urxvt -e sh -c 'rails ; bash'" },
  { "rake", "urxvt -e sh -c 'rake ; bash'" },
  { "rspec", "urxvt -e sh -c 'rspec ; bash'" },
  { "rubocop-ci", "urxvt -e sh -c 'rubocop-ci ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "spring", "urxvt -e sh -c 'spring ; bash'" },
  { "yarn", "urxvt -e sh -c 'yarn ; bash'" },
  { "dsstore-crawler", "urxvt -e sh -c 'dsstore-crawler -h ; bash'" },
  { "eapeak", "urxvt -e sh -c 'eapeak -h ; bash'" },
  { "easyda", "urxvt -e sh -c 'easyda ; bash'" },
  { "eigrp", "urxvt -e sh -c 'eigrp -h ; bash'" },
  { "elevate", "urxvt -e sh -c 'elevate -h ; bash'" },
  { "email2phonenumber", "urxvt -e sh -c 'email2phonenumber -h ; bash'" },
  { "enteletaor", "urxvt -e sh -c 'enteletaor ; bash'" },
  { "enum4linux", "urxvt -e sh -c 'enum4linux ; bash'" },
  { "enum4linux-ng", "urxvt -e sh -c 'enum4linux-ng -h ; bash'" },
  { "enumerate-iam", "urxvt -e sh -c 'enumerate-iam -h ; bash'" },
  { "enumerid", "urxvt -e sh -c 'enumerid -h ; bash'" },
  { "exitmap", "urxvt -e sh -c 'exitmap -h ; bash'" },
  { "expimp-lookup", "urxvt -e sh -c 'expimp-lookup ; bash'" },
  { "eyewitness", "urxvt -e sh -c 'eyewitness -h ; bash'" },
  { "dismissauth.xpi", "urxvt -e sh -c 'dismissauth.xpi ; bash'" },
  { "facebookosint", "urxvt -e sh -c 'facebookosint ; bash'" },
  { "facebot", "urxvt -e sh -c 'facebot -h ; bash'" },
  { "fav-up", "urxvt -e sh -c 'fav-up -h ; bash'" },
  { "favfreak", "urxvt -e sh -c 'favfreak -h ; bash'" },
  { "fbi", "urxvt -e sh -c 'fbi -h ; bash'" },
  { "fbid", "urxvt -e sh -c 'fbid ; bash'" },
  { "fernmelder", "urxvt -e sh -c 'fernmelder -h ; bash'" },
  { "fierce", "urxvt -e sh -c 'fierce ; bash'" },
  { "fileintel", "urxvt -e sh -c 'fileintel -h ; bash'" },
  { "finalrecon", "urxvt -e sh -c 'finalrecon -h ; bash'" },
  { "findmyiphone", "urxvt -e sh -c 'findmyiphone ; bash'" },
  { "findomain", "urxvt -e sh -c 'findomain ; bash'" },
  { "forager", "urxvt -e sh -c 'forager -h ; bash'" },
  { "fping", "urxvt -e sh -c 'fping -h ; bash'" },
  { "gasmask", "urxvt -e sh -c 'gasmask -h ; bash'" },
  { "gau", "urxvt -e sh -c 'gau -h ; bash'" },
  { "genisys-manager", "urxvt -e sh -c 'genisys-manager -h ; bash'" },
  { "genisys-scraper", "urxvt -e sh -c 'genisys-scraper -h ; bash'" },
  { "genisys-tsadder", "urxvt -e sh -c 'genisys-tsadder -h ; bash'" },
  { "geoedge", "urxvt -e sh -c 'geoedge ; bash'" },
  { "git-hound", "urxvt -e sh -c 'git-hound -h ; bash'" },
  { "gitdorker", "urxvt -e sh -c 'gitdorker -h ; bash'" },
  { "gitem", "urxvt -e sh -c 'gitem -h ; bash'" },
  { "gitgraber", "urxvt -e sh -c 'gitgraber ; bash'" },
  { "githack", "urxvt -e sh -c 'githack ; bash'" },
  { "github-dorks", "urxvt -e sh -c 'github-dorks -h ; bash'" },
  { "gitleaks", "urxvt -e sh -c 'gitleaks -h ; bash'" },
  { "gitmails", "urxvt -e sh -c 'gitmails -h ; bash'" },
  { "gitminer", "urxvt -e sh -c 'gitminer -h ; bash'" },
  { "gitrecon", "urxvt -e sh -c 'gitrecon -h ; bash'" },
  { "gloom", "urxvt -e sh -c 'gloom ; bash'" },
  { "goddi", "urxvt -e sh -c 'goddi -h ; bash'" },
  { "goodork", "urxvt -e sh -c 'goodork ; bash'" },
  { "goofile", "urxvt -e sh -c 'goofile ; bash'" },
  { "goog-mail", "urxvt -e sh -c 'goog-mail ; bash'" },
  { "googlesub", "urxvt -e sh -c 'googlesub --help ; bash'" },
  { "goohak", "urxvt -e sh -c 'goohak ; bash'" },
  { "goop", "urxvt -e sh -c 'goop ; bash'" },
  { "gosint", "urxvt -e sh -c 'gosint -h ; bash'" },
  { "gowitness", "urxvt -e sh -c 'gowitness -h ; bash'" },
  { "database-statistics-sqlite", "urxvt -e sh -c 'database-statistics-sqlite ; bash'" },
  { "greenbone-certdata-sync", "urxvt -e sh -c 'greenbone-certdata-sync -h ; bash'" },
  { "greenbone-scapdata-sync", "urxvt -e sh -c 'greenbone-scapdata-sync -h ; bash'" },
  { "gvm-manage-certs", "urxvt -e sh -c 'gvm-manage-certs ; bash'" },
  { "gvm-migrate-to-postgres", "urxvt -e sh -c 'gvm-migrate-to-postgres ; bash'" },
  { "gvm-portnames-update", "urxvt -e sh -c 'gvm-portnames-update ; bash'" },
  { "gwtenum", "urxvt -e sh -c 'gwtenum -h ; bash'" },
  { "gwtfuzzer", "urxvt -e sh -c 'gwtfuzzer -h ; bash'" },
  { "gwtparse", "urxvt -e sh -c 'gwtparse -h ; bash'" },
  { "h8mail", "urxvt -e sh -c 'h8mail -h ; bash'" },
  { "hakku", "urxvt -e sh -c 'hakku ; bash'" },
  { "hakrevdns", "urxvt -e sh -c 'hakrevdns -h ; bash'" },
  { "halcyon", "urxvt -e sh -c 'halcyon -h ; bash'" },
  { "harpoon", "urxvt -e sh -c 'harpoon -h ; bash'" },
  { "hasere", "urxvt -e sh -c 'hasere -h ; bash'" },
  { "hatcloud", "urxvt -e sh -c 'hatcloud -h ; bash'" },
  { "hellraiser", "urxvt -e sh -c 'hellraiser -h ; bash'" },
  { "bundle", "urxvt -e sh -c 'bundle ; bash'" },
  { "rails", "urxvt -e sh -c 'rails ; bash'" },
  { "rake", "urxvt -e sh -c 'rake ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "spring", "urxvt -e sh -c 'spring ; bash'" },
  { "homepwn", "urxvt -e sh -c 'homepwn -h ; bash'" },
  { "hoper", "urxvt -e sh -c 'hoper ; bash'" },
  { "console", "urxvt -e sh -c 'console ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "hosthunter", "urxvt -e sh -c 'hosthunter -h ; bash'" },
  { "htrosbif", "urxvt -e sh -c 'htrosbif -h ; bash'" },
  { "http-traceroute", "urxvt -e sh -c 'http-traceroute -h ; bash'" },
  { "httpextract", "urxvt -e sh -c 'httpextract -h ; bash'" },
  { "httpforge", "urxvt -e sh -c 'httpforge -h ; bash'" },
  { "httping", "urxvt -e sh -c 'httping --help ; bash'" },
  { "id-entify", "urxvt -e sh -c 'id-entify ; bash'" },
  { "idswakeup", "urxvt -e sh -c 'idswakeup -h ; bash'" },
  { "infoga", "urxvt -e sh -c 'infoga -h ; bash'" },
  { "inquisitor", "urxvt -e sh -c 'inquisitor -h ; bash'" },
  { "instagramosint", "urxvt -e sh -c 'instagramosint -h ; bash'" },
  { "intrace", "urxvt -e sh -c 'intrace ; bash'" },
  { "ip-tracer", "urxvt -e sh -c 'ip-tracer -h ; bash'" },
  { "ip2clue", "urxvt -e sh -c 'ip2clue ; bash'" },
  { "ip2clued", "urxvt -e sh -c 'ip2clued ; bash'" },
  { "iptodomain", "urxvt -e sh -c 'iptodomain -h ; bash'" },
  { "ipv666", "urxvt -e sh -c 'ipv666 -h ; bash'" },
  { "addr6", "urxvt -e sh -c 'addr6 ; bash'" },
  { "blackhole6", "urxvt -e sh -c 'blackhole6 ; bash'" },
  { "flow6", "urxvt -e sh -c 'flow6 ; bash'" },
  { "frag6", "urxvt -e sh -c 'frag6 ; bash'" },
  { "icmp6", "urxvt -e sh -c 'icmp6 ; bash'" },
  { "jumbo6", "urxvt -e sh -c 'jumbo6 ; bash'" },
  { "messi", "urxvt -e sh -c 'messi ; bash'" },
  { "mldq6", "urxvt -e sh -c 'mldq6 ; bash'" },
  { "na6", "urxvt -e sh -c 'na6 ; bash'" },
  { "ni6", "urxvt -e sh -c 'ni6 ; bash'" },
  { "ns6", "urxvt -e sh -c 'ns6 ; bash'" },
  { "path6", "urxvt -e sh -c 'path6 -h ; bash'" },
  { "ra6", "urxvt -e sh -c 'ra6 ; bash'" },
  { "rd6", "urxvt -e sh -c 'rd6 ; bash'" },
  { "rs6", "urxvt -e sh -c 'rs6 ; bash'" },
  { "scan6", "urxvt -e sh -c 'scan6 ; bash'" },
  { "script6", "urxvt -e sh -c 'script6 ; bash'" },
  { "tcp6", "urxvt -e sh -c 'tcp6 ; bash'" },
  { "udp6", "urxvt -e sh -c 'udp6 ; bash'" },
  { "isme", "urxvt -e sh -c 'isme ; bash'" },
  { "isr-form", "urxvt -e sh -c 'isr-form -h ; bash'" },
  { "ivre", "urxvt -e sh -c 'ivre ; bash'" },
  { "jackdaw", "urxvt -e sh -c 'jackdaw -h ; bash'" },
  { "jast", "urxvt -e sh -c 'jast -h ; bash'" },
  { "jsearch", "urxvt -e sh -c 'jsearch -h ; bash'" },
  { "kacak", "urxvt -e sh -c 'kacak -h ; bash'" },
  { "kamerka", "urxvt -e sh -c 'kamerka -h ; bash'" },
  { "katana-ktf.gui", "urxvt -e sh -c 'katana-ktf.gui ; bash'" },
  { "katana-ktfconsole", "urxvt -e sh -c 'katana-ktfconsole ; bash'" },
  { "katana-ktfktf", "urxvt -e sh -c 'katana-ktfktf ; bash'" },
  { "katana-ktflinker", "urxvt -e sh -c 'katana-ktflinker ; bash'" },
  { "katana-ktfrun", "urxvt -e sh -c 'katana-ktfrun ; bash'" },
  { "katana-ktfupdate", "urxvt -e sh -c 'katana-ktfupdate ; bash'" },
  { "keye", "urxvt -e sh -c 'keye -h ; bash'" },
  { "kiterunner", "urxvt -e sh -c 'kiterunner -h ; bash'" },
  { "knock", "urxvt -e sh -c 'knock ; bash'" },
  { "lanmap2-cap", "urxvt -e sh -c 'lanmap2-cap ; bash'" },
  { "lanmap2-graph", "urxvt -e sh -c 'lanmap2-graph ; bash'" },
  { "lbd", "urxvt -e sh -c 'lbd ; bash'" },
  { "ldapenum", "urxvt -e sh -c 'ldapenum ; bash'" },
  { "ldeep", "urxvt -e sh -c 'ldeep -h ; bash'" },
  { "legion", "urxvt -e sh -c 'legion -h ; bash'" },
  { "lft", "urxvt -e sh -c 'lft ; bash'" },
  { "whob", "urxvt -e sh -c 'whob ; bash'" },
  { "lhf", "urxvt -e sh -c 'lhf ; bash'" },
  { "linenum", "urxvt -e sh -c 'linenum -h ; bash'" },
  { "linkedin2username", "urxvt -e sh -c 'linkedin2username -h ; bash'" },
  { "linkfinder", "urxvt -e sh -c 'linkfinder -h ; bash'" },
  { "littlebrother", "urxvt -e sh -c 'littlebrother ; bash'" },
  { "loot", "urxvt -e sh -c 'loot ; bash'" },
  { "lte-cell-scanner", "urxvt -e sh -c 'lte-cell-scanner --help ; bash'" },
  { "lulzbuster", "urxvt -e sh -c 'lulzbuster -H ; bash'" },
  { "machinae", "urxvt -e sh -c 'machinae -h ; bash'" },
  { "mail-crawl", "urxvt -e sh -c 'mail-crawl -h ; bash'" },
  { "maltego", "urxvt -e sh -c 'maltego -h ; bash'" },
  { "maltego.ico", "urxvt -e sh -c 'maltego.ico ; bash'" },
  { "maryam", "urxvt -e sh -c 'maryam ; bash'" },
  { "massbleed", "urxvt -e sh -c 'massbleed ; bash'" },
  { "mdns-recon", "urxvt -e sh -c 'mdns-recon ; bash'" },
  { "metabigor", "urxvt -e sh -c 'metabigor -h ; bash'" },
  { "metagoofil", "urxvt -e sh -c 'metagoofil ; bash'" },
  { "msf-ws.ru", "urxvt -e sh -c 'msf-ws.ru ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfdb", "urxvt -e sh -c 'msfdb ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfelfscan", "urxvt -e sh -c 'msfelfscan -h ; bash'" },
  { "msfmachscan", "urxvt -e sh -c 'msfmachscan -h ; bash'" },
  { "msfpescan", "urxvt -e sh -c 'msfpescan -h ; bash'" },
  { "msfrop", "urxvt -e sh -c 'msfrop -h ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfupdate", "urxvt -e sh -c 'msfupdate -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "expressInstall.swf", "urxvt -e sh -c 'expressInstall.swf ; bash'" },
  { "stty", "urxvt -e sh -c 'stty ; bash'" },
  { "mildew", "urxvt -e sh -c 'mildew -h ; bash'" },
  { "missidentify", "urxvt -e sh -c 'missidentify -h ; bash'" },
  { "modscan", "urxvt -e sh -c 'modscan -h ; bash'" },
  { "monocle", "urxvt -e sh -c 'monocle -h ; bash'" },
  { "mptcp-fragmenter", "urxvt -e sh -c 'mptcp-fragmenter ; bash'" },
  { "mptcp-scanner", "urxvt -e sh -c 'mptcp-scanner ; bash'" },
  { "mqtt-pwn", "urxvt -e sh -c 'mqtt-pwn -h ; bash'" },
  { "mylg", "urxvt -e sh -c 'mylg help ; bash'" },
  { "nasnum", "urxvt -e sh -c 'nasnum ; bash'" },
  { "dnscat", "urxvt -e sh -c 'dnscat -h ; bash'" },
  { "dnslogger", "urxvt -e sh -c 'dnslogger -h ; bash'" },
  { "dnstest", "urxvt -e sh -c 'dnstest -h ; bash'" },
  { "dnsxss", "urxvt -e sh -c 'dnsxss -h ; bash'" },
  { "nbquery", "urxvt -e sh -c 'nbquery -h ; bash'" },
  { "nbsniff", "urxvt -e sh -c 'nbsniff -h ; bash'" },
  { "necromant", "urxvt -e sh -c 'necromant ; bash'" },
  { "neglected", "urxvt -e sh -c 'neglected ; bash'" },
  { "netdiscover", "urxvt -e sh -c 'netdiscover -h ; bash'" },
  { "finger", "urxvt -e sh -c 'finger ; bash'" },
  { "in.fingerd", "urxvt -e sh -c 'in.fingerd ; bash'" },
  { "rpc.rusersd", "urxvt -e sh -c 'rpc.rusersd ; bash'" },
  { "rup", "urxvt -e sh -c 'rup ; bash'" },
  { "rusers", "urxvt -e sh -c 'rusers ; bash'" },
  { "ruptime", "urxvt -e sh -c 'ruptime ; bash'" },
  { "rwho", "urxvt -e sh -c 'rwho ; bash'" },
  { "rwhod", "urxvt -e sh -c 'rwhod ; bash'" },
  { "netmask", "urxvt -e sh -c 'netmask --help ; bash'" },
  { "netreconn", "urxvt -e sh -c 'netreconn -h ; bash'" },
  { "nettacker", "urxvt -e sh -c 'nettacker -h ; bash'" },
  { "nexfil", "urxvt -e sh -c 'nexfil -h ; bash'" },
  { "nipper", "urxvt -e sh -c 'nipper --help ; bash'" },
  { "nohidy", "urxvt -e sh -c 'nohidy ; bash'" },
  { "n3map", "urxvt -e sh -c 'n3map -h ; bash'" },
  { "n3map-johnify", "urxvt -e sh -c 'n3map-johnify ; bash'" },
  { "n3map-nsec3-lookup", "urxvt -e sh -c 'n3map-nsec3-lookup ; bash'" },
  { "nsec3walker-collect", "urxvt -e sh -c 'nsec3walker-collect ; bash'" },
  { "nsec3walker-query", "urxvt -e sh -c 'nsec3walker-query ; bash'" },
  { "ntlmrecon", "urxvt -e sh -c 'ntlmrecon -h ; bash'" },
  { "ntp-ip-enum", "urxvt -e sh -c 'ntp-ip-enum ; bash'" },
  { "nullinux", "urxvt -e sh -c 'nullinux ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "o-saft", "urxvt -e sh -c 'o-saft -h ; bash'" },
  { "o365spray", "urxvt -e sh -c 'o365spray -h ; bash'" },
  { "omnibus", "urxvt -e sh -c 'omnibus ; bash'" },
  { "onioff", "urxvt -e sh -c 'onioff -h ; bash'" },
  { "greenbone-nvt-sync", "urxvt -e sh -c 'greenbone-nvt-sync -h ; bash'" },
  { "openvas-nasl", "urxvt -e sh -c 'openvas-nasl ; bash'" },
  { "openvas-nasl-lint", "urxvt -e sh -c 'openvas-nasl-lint ; bash'" },
  { "openvassd", "urxvt -e sh -c 'openvassd -h ; bash'" },
  { "osi.ig", "urxvt -e sh -c 'osi.ig -h ; bash'" },
  { "osinterator", "urxvt -e sh -c 'osinterator -h ; bash'" },
  { "osr-alias_generator", "urxvt -e sh -c 'osr-alias_generator -h ; bash'" },
  { "osr-checkfy", "urxvt -e sh -c 'osr-checkfy ; bash'" },
  { "osr-domainfy", "urxvt -e sh -c 'osr-domainfy -h ; bash'" },
  { "osr-mailfy", "urxvt -e sh -c 'osr-mailfy -h ; bash'" },
  { "osr-osrf", "urxvt -e sh -c 'osr-osrf ; bash'" },
  { "osr-osrframework-cli", "urxvt -e sh -c 'osr-osrframework-cli ; bash'" },
  { "osr-phonefy", "urxvt -e sh -c 'osr-phonefy -h ; bash'" },
  { "osr-searchfy", "urxvt -e sh -c 'osr-searchfy -h ; bash'" },
  { "osr-usufy", "urxvt -e sh -c 'osr-usufy -h ; bash'" },
  { "pagodo", "urxvt -e sh -c 'pagodo -h ; bash'" },
  { "parsero", "urxvt -e sh -c 'parsero -h ; bash'" },
  { "pass-station", "urxvt -e sh -c 'pass-station -h ; bash'" },
  { "pass-station_console", "urxvt -e sh -c 'pass-station_console ; bash'" },
  { "pasv-agrsv", "urxvt -e sh -c 'pasv-agrsv -h ; bash'" },
  { "pdfgrab", "urxvt -e sh -c 'pdfgrab -h ; bash'" },
  { "peepingtom", "urxvt -e sh -c 'peepingtom -h ; bash'" },
  { "pentestly", "urxvt -e sh -c 'pentestly -h ; bash'" },
  { "pepe", "urxvt -e sh -c 'pepe -h ; bash'" },
  { "photon", "urxvt -e sh -c 'photon -h ; bash'" },
  { "postenum", "urxvt -e sh -c 'postenum -h ; bash'" },
  { "pown", "urxvt -e sh -c 'pown ; bash'" },
  { "pret", "urxvt -e sh -c 'pret -h ; bash'" },
  { "proxmark", "urxvt -e sh -c 'proxmark ; bash'" },
  { "proxmark-fpga-compress", "urxvt -e sh -c 'proxmark-fpga-compress ; bash'" },
  { "ptf", "urxvt -e sh -c 'ptf ; bash'" },
  { "punter", "urxvt -e sh -c 'punter -h ; bash'" },
  { "pwned", "urxvt -e sh -c 'pwned -h ; bash'" },
  { "pwned-search", "urxvt -e sh -c 'pwned-search ; bash'" },
  { "pwnedornot", "urxvt -e sh -c 'pwnedornot -h ; bash'" },
  { "pymeta", "urxvt -e sh -c 'pymeta -h ; bash'" },
  { "pythem", "urxvt -e sh -c 'pythem ; bash'" },
  { "shodan", "urxvt -e sh -c 'shodan ; bash'" },
  { "witnessme", "urxvt -e sh -c 'witnessme -h ; bash'" },
  { "wmapi", "urxvt -e sh -c 'wmapi ; bash'" },
  { "shodan2", "urxvt -e sh -c 'shodan2 ; bash'" },
  { "webtech2", "urxvt -e sh -c 'webtech2 ; bash'" },
  { "quickrecon", "urxvt -e sh -c 'quickrecon -h ; bash'" },
  { "raccoon", "urxvt -e sh -c 'raccoon --help ; bash'" },
  { "ranger-scanner", "urxvt -e sh -c 'ranger-scanner ; bash'" },
  { "rapidscan", "urxvt -e sh -c 'rapidscan ; bash'" },
  { "raven", "urxvt -e sh -c 'raven -h ; bash'" },
  { "recon-cli", "urxvt -e sh -c 'recon-cli ; bash'" },
  { "recon-ng", "urxvt -e sh -c 'recon-ng cd /usr/share/recon-ng ; ./recon-ng -h ; bash'" },
  { "recon-web", "urxvt -e sh -c 'recon-web ; bash'" },
  { "reconnoitre", "urxvt -e sh -c 'reconnoitre -h ; bash'" },
  { "reconscan-recon", "urxvt -e sh -c 'reconscan-recon -h ; bash'" },
  { "reconscan-vulnscan", "urxvt -e sh -c 'reconscan-vulnscan -h ; bash'" },
  { "recsech", "urxvt -e sh -c 'recsech ; bash'" },
  { "red-hawk", "urxvt -e sh -c 'red-hawk ; bash'" },
  { "reverseip", "urxvt -e sh -c 'reverseip ; bash'" },
  { "revipd", "urxvt -e sh -c 'revipd ; bash'" },
  { "ridrelay", "urxvt -e sh -c 'ridrelay -h ; bash'" },
  { "rifiuti", "urxvt -e sh -c 'rifiuti --help-all ; bash'" },
  { "rifiuti-vista", "urxvt -e sh -c 'rifiuti-vista -h ; bash'" },
  { "ripdc", "urxvt -e sh -c 'ripdc -H ; bash'" },
  { "rita", "urxvt -e sh -c 'rita -h ; bash'" },
  { "sawef", "urxvt -e sh -c 'sawef -h ; bash'" },
  { "sb0x", "urxvt -e sh -c 'sb0x -h ; bash'" },
  { "sc_ally", "urxvt -e sh -c 'sc_ally -h ; bash'" },
  { "sc_analysis_dump", "urxvt -e sh -c 'sc_analysis_dump -h ; bash'" },
  { "sc_attach", "urxvt -e sh -c 'sc_attach -h ; bash'" },
  { "sc_bdrmap", "urxvt -e sh -c 'sc_bdrmap ; bash'" },
  { "sc_erosprober", "urxvt -e sh -c 'sc_erosprober ; bash'" },
  { "sc_filterpolicy", "urxvt -e sh -c 'sc_filterpolicy -h ; bash'" },
  { "sc_ipiddump", "urxvt -e sh -c 'sc_ipiddump -h ; bash'" },
  { "sc_pinger", "urxvt -e sh -c 'sc_pinger ; bash'" },
  { "sc_prefixscan", "urxvt -e sh -c 'sc_prefixscan ; bash'" },
  { "sc_radargun", "urxvt -e sh -c 'sc_radargun ; bash'" },
  { "sc_remoted", "urxvt -e sh -c 'sc_remoted ; bash'" },
  { "sc_speedtrap", "urxvt -e sh -c 'sc_speedtrap -h ; bash'" },
  { "sc_tbitblind", "urxvt -e sh -c 'sc_tbitblind -h ; bash'" },
  { "sc_tbitpmtud", "urxvt -e sh -c 'sc_tbitpmtud ; bash'" },
  { "sc_tracediff", "urxvt -e sh -c 'sc_tracediff -h ; bash'" },
  { "sc_ttlexp", "urxvt -e sh -c 'sc_ttlexp ; bash'" },
  { "sc_warts2csv", "urxvt -e sh -c 'sc_warts2csv -h ; bash'" },
  { "sc_warts2pcap", "urxvt -e sh -c 'sc_warts2pcap -h ; bash'" },
  { "sc_warts2text", "urxvt -e sh -c 'sc_warts2text -h ; bash'" },
  { "sc_wartscat", "urxvt -e sh -c 'sc_wartscat -h ; bash'" },
  { "sc_wartsdump", "urxvt -e sh -c 'sc_wartsdump -h ; bash'" },
  { "sc_wartsfilter", "urxvt -e sh -c 'sc_wartsfilter ; bash'" },
  { "sc_wartsfix", "urxvt -e sh -c 'sc_wartsfix -h ; bash'" },
  { "scamper", "urxvt -e sh -c 'scamper -h ; bash'" },
  { "scavenger", "urxvt -e sh -c 'scavenger -h ; bash'" },
  { "of-access", "urxvt -e sh -c 'of-access -h ; bash'" },
  { "of-check", "urxvt -e sh -c 'of-check -h ; bash'" },
  { "of-enum", "urxvt -e sh -c 'of-enum -h ; bash'" },
  { "of-flood", "urxvt -e sh -c 'of-flood -h ; bash'" },
  { "of-map", "urxvt -e sh -c 'of-map -h ; bash'" },
  { "of-scan", "urxvt -e sh -c 'of-scan ; bash'" },
  { "of-switch", "urxvt -e sh -c 'of-switch -h ; bash'" },
  { "seat", "urxvt -e sh -c 'seat -h ; bash'" },
  { "secretfinder", "urxvt -e sh -c 'secretfinder -h ; bash'" },
  { "seeker", "urxvt -e sh -c 'seeker -h ; bash'" },
  { "server-status-pwn", "urxvt -e sh -c 'server-status-pwn -h ; bash'" },
  { "shard", "urxvt -e sh -c 'shard --help ; bash'" },
  { "sherlock", "urxvt -e sh -c 'sherlock -h ; bash'" },
  { "shhgit", "urxvt -e sh -c 'shhgit -h ; bash'" },
  { "shodanhat", "urxvt -e sh -c 'shodanhat -h ; bash'" },
  { "sipi", "urxvt -e sh -c 'sipi -h ; bash'" },
  { "skiptracer", "urxvt -e sh -c 'skiptracer --help ; bash'" },
  { "slackpirate", "urxvt -e sh -c 'slackpirate --help ; bash'" },
  { "smbgrab", "urxvt -e sh -c 'smbgrab -h ; bash'" },
  { "smbhunt", "urxvt -e sh -c 'smbhunt -h ; bash'" },
  { "smblist", "urxvt -e sh -c 'smblist -h ; bash'" },
  { "smbmap", "urxvt -e sh -c 'smbmap -h ; bash'" },
  { "smod", "urxvt -e sh -c 'smod ; bash'" },
  { "smtp-user-enum", "urxvt -e sh -c 'smtp-user-enum -h ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "sn1per", "urxvt -e sh -c 'sn1per ; bash'" },
  { "http-default-accounts-fingerprints-nndefaccts.lua", "urxvt -e sh -c 'http-default-accounts-fingerprints-nndefaccts.lua ; bash'" },
  { "inurlbr.php", "urxvt -e sh -c 'inurlbr.php ; bash'" },
  { "nmap-bootstrap.xsl", "urxvt -e sh -c 'nmap-bootstrap.xsl ; bash'" },
  { "snmpcheck-nothink", "urxvt -e sh -c 'snmpcheck-nothink -h ; bash'" },
  { "snoopbrute", "urxvt -e sh -c 'snoopbrute ; bash'" },
  { "social-analyzer", "urxvt -e sh -c 'social-analyzer -h ; bash'" },
  { "social-vuln-scanner", "urxvt -e sh -c 'social-vuln-scanner -h ; bash'" },
  { "socialscan", "urxvt -e sh -c 'socialscan ; bash'" },
  { "sooty", "urxvt -e sh -c 'sooty ; bash'" },
  { "spfmap", "urxvt -e sh -c 'spfmap -h ; bash'" },
  { "spiderfoot", "urxvt -e sh -c 'spiderfoot ; bash'" },
  { "spiderfoot-cli", "urxvt -e sh -c 'spiderfoot-cli ; bash'" },
  { "spoofcheck", "urxvt -e sh -c 'spoofcheck ; bash'" },
  { "ssl-hostname-resolver", "urxvt -e sh -c 'ssl-hostname-resolver -h ; bash'" },
  { "stardox", "urxvt -e sh -c 'stardox ; bash'" },
  { "striker", "urxvt -e sh -c 'striker ; bash'" },
  { "subdomainer", "urxvt -e sh -c 'subdomainer ; bash'" },
  { "subfinder", "urxvt -e sh -c 'subfinder -h ; bash'" },
  { "sublert", "urxvt -e sh -c 'sublert -h ; bash'" },
  { "sublist3r", "urxvt -e sh -c 'sublist3r -h ; bash'" },
  { "subover", "urxvt -e sh -c 'subover ; bash'" },
  { "subscraper", "urxvt -e sh -c 'subscraper -h ; bash'" },
  { "svn-extractor", "urxvt -e sh -c 'svn-extractor -h ; bash'" },
  { "swamp", "urxvt -e sh -c 'swamp -h ; bash'" },
  { "swarm", "urxvt -e sh -c 'swarm -h ; bash'" },
  { "syborg", "urxvt -e sh -c 'syborg -h ; bash'" },
  { "csysdig", "urxvt -e sh -c 'csysdig ; bash'" },
  { "sysdig", "urxvt -e sh -c 'sysdig -h ; bash'" },
  { "sysdig-probe-loader", "urxvt -e sh -c 'sysdig-probe-loader ; bash'" },
  { "csysdig", "urxvt -e sh -c 'csysdig ; bash'" },
  { "sysdig", "urxvt -e sh -c 'sysdig -h ; bash'" },
  { "sysdig-probe-loader", "urxvt -e sh -c 'sysdig-probe-loader ; bash'" },
  { "easywin", "urxvt -e sh -c 'easywin -h ; bash'" },
  { "letmein", "urxvt -e sh -c 'letmein -h ; bash'" },
  { "netdork", "urxvt -e sh -c 'netdork -h ; bash'" },
  { "poriluk", "urxvt -e sh -c 'poriluk -h ; bash'" },
  { "seitan", "urxvt -e sh -c 'seitan -h ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "thcrut", "urxvt -e sh -c 'thcrut -h ; bash'" },
  { "thedorkbox", "urxvt -e sh -c 'thedorkbox ; bash'" },
  { "restfulHarvest", "urxvt -e sh -c 'restfulHarvest ; bash'" },
  { "theharvester", "urxvt -e sh -c 'theharvester ; bash'" },
  { "tinfoleak", "urxvt -e sh -c 'tinfoleak ; bash'" },
  { "tinfoleak2", "urxvt -e sh -c 'tinfoleak2 -h ; bash'" },
  { "traceroute", "urxvt -e sh -c 'traceroute --help ; bash'" },
  { "trape", "urxvt -e sh -c 'trape -h ; bash'" },
  { "treasure", "urxvt -e sh -c 'treasure ; bash'" },
  { "trufflehog", "urxvt -e sh -c 'trufflehog -h ; bash'" },
  { "trusttrees", "urxvt -e sh -c 'trusttrees -h ; bash'" },
  { "tweets-analyzer", "urxvt -e sh -c 'tweets-analyzer -h ; bash'" },
  { "twint", "urxvt -e sh -c 'twint -h ; bash'" },
  { "twofi", "urxvt -e sh -c 'twofi --help ; bash'" },
  { "udork", "urxvt -e sh -c 'udork -h ; bash'" },
  { "uhoh365", "urxvt -e sh -c 'uhoh365 -h ; bash'" },
  { "ufb-scraper", "urxvt -e sh -c 'ufb-scraper ; bash'" },
  { "urlextractor", "urxvt -e sh -c 'urlextractor ; bash'" },
  { "userrecon", "urxvt -e sh -c 'userrecon ; bash'" },
  { "v3n0m", "urxvt -e sh -c 'v3n0m -h ; bash'" },
  { "vault-scanner", "urxvt -e sh -c 'vault-scanner ; bash'" },
  { "vbrute", "urxvt -e sh -c 'vbrute -h ; bash'" },
  { "vlan-hopping", "urxvt -e sh -c 'vlan-hopping ; bash'" },
  { "pivotc", "urxvt -e sh -c 'pivotc -h ; bash'" },
  { "pivots", "urxvt -e sh -c 'pivots -h ; bash'" },
  { "vulmap", "urxvt -e sh -c 'vulmap -h ; bash'" },
  { "vulnx", "urxvt -e sh -c 'vulnx -h ; bash'" },
  { "vulnx.desktop", "urxvt -e sh -c 'vulnx.desktop ; bash'" },
  { "waldo", "urxvt -e sh -c 'waldo -h ; bash'" },
  { "waybackpack", "urxvt -e sh -c 'waybackpack -h ; bash'" },
  { "waybackurls", "urxvt -e sh -c 'waybackurls -h ; bash'" },
  { "webanalyze", "urxvt -e sh -c 'webanalyze ; bash'" },
  { "webkiller", "urxvt -e sh -c 'webkiller -h ; bash'" },
  { "websearch", "urxvt -e sh -c 'websearch -h ; bash'" },
  { "webtech", "urxvt -e sh -c 'webtech -h ; bash'" },
  { "weebdns", "urxvt -e sh -c 'weebdns -h ; bash'" },
  { "whatbreach", "urxvt -e sh -c 'whatbreach -h ; bash'" },
  { "whatsmyname", "urxvt -e sh -c 'whatsmyname -h ; bash'" },
  { "whatweb", "urxvt -e sh -c 'whatweb -h ; bash'" },
  { "whichcdn", "urxvt -e sh -c 'whichcdn -h ; bash'" },
  { "wig", "urxvt -e sh -c 'wig -h ; bash'" },
  { "xray", "urxvt -e sh -c 'xray ; bash'" },
  { "yasat", "urxvt -e sh -c 'yasat -h ; bash'" },
  { "yeti", "urxvt -e sh -c 'yeti -h ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "marked", "urxvt -e sh -c 'marked ; bash'" },
  { "zeus-scanner", "urxvt -e sh -c 'zeus-scanner -h ; bash'" },
  { "zgrab", "urxvt -e sh -c 'zgrab -h ; bash'" },
  { "zgrab2", "urxvt -e sh -c 'zgrab2 -h ; bash'" },
}

reversingmenu = {
  { "amoco", "urxvt -e sh -c 'amoco ; bash'" },
  { "apktool", "urxvt -e sh -c 'apktool ; bash'" },
  { "angr-management", "urxvt -e sh -c 'angr-management ; bash'" },
  { "apkstudio", "urxvt -e sh -c 'apkstudio ; bash'" },
  { "bagbak", "urxvt -e sh -c 'bagbak -h ; bash'" },
  { "balbuzard", "urxvt -e sh -c 'balbuzard ; bash'" },
  { "bbcrack", "urxvt -e sh -c 'bbcrack ; bash'" },
  { "bbharvest", "urxvt -e sh -c 'bbharvest ; bash'" },
  { "bbtrans", "urxvt -e sh -c 'bbtrans ; bash'" },
  { "BARFcfg", "urxvt -e sh -c 'BARFcfg -h ; bash'" },
  { "BARFcg", "urxvt -e sh -c 'BARFcg -h ; bash'" },
  { "BARFgadgets", "urxvt -e sh -c 'BARFgadgets -h ; bash'" },
  { "beebug", "urxvt -e sh -c 'beebug -h ; bash'" },
  { "binaryninja-demo", "urxvt -e sh -c 'binaryninja-demo ; bash'" },
  { "bindead", "urxvt -e sh -c 'bindead ; bash'" },
  { "bindiff", "urxvt -e sh -c 'bindiff ; bash'" },
  { "binexport2dump", "urxvt -e sh -c 'binexport2dump ; bash'" },
  { "binnavi", "urxvt -e sh -c 'binnavi ; bash'" },
  { "binwalk", "urxvt -e sh -c 'binwalk ; bash'" },
  { "bsdiff", "urxvt -e sh -c 'bsdiff ; bash'" },
  { "bspatch", "urxvt -e sh -c 'bspatch ; bash'" },
  { "bsdiff", "urxvt -e sh -c 'bsdiff ; bash'" },
  { "bspatch", "urxvt -e sh -c 'bspatch ; bash'" },
  { "bytecode-viewer", "urxvt -e sh -c 'bytecode-viewer ; bash'" },
  { "cafebabe", "urxvt -e sh -c 'cafebabe ; bash'" },
  { "cstool", "urxvt -e sh -c 'cstool ; bash'" },
  { "suture", "urxvt -e sh -c 'suture ; bash'" },
  { "damm", "urxvt -e sh -c 'damm -h ; bash'" },
  { "die", "urxvt -e sh -c 'die ; bash'" },
  { "diec", "urxvt -e sh -c 'diec ; bash'" },
  { "d2j-asm-verify", "urxvt -e sh -c 'd2j-asm-verify ; bash'" },
  { "d2j-baksmali", "urxvt -e sh -c 'd2j-baksmali ; bash'" },
  { "d2j-decrypt-string", "urxvt -e sh -c 'd2j-decrypt-string ; bash'" },
  { "d2j-smali", "urxvt -e sh -c 'd2j-smali ; bash'" },
  { "dutas", "urxvt -e sh -c 'dutas -h ; bash'" },
  { "dwarf", "urxvt -e sh -c 'dwarf --help ; bash'" },
  { "drinject", "urxvt -e sh -c 'drinject ; bash'" },
  { "drloader", "urxvt -e sh -c 'drloader ; bash'" },
  { "drrun", "urxvt -e sh -c 'drrun ; bash'" },
  { "nudgeunix", "urxvt -e sh -c 'nudgeunix ; bash'" },
  { "drltrace", "urxvt -e sh -c 'drltrace ; bash'" },
  { "drmemory", "urxvt -e sh -c 'drmemory ; bash'" },
  { "symquery", "urxvt -e sh -c 'symquery ; bash'" },
  { "edb", "urxvt -e sh -c 'edb ; bash'" },
  { "elidecode", "urxvt -e sh -c 'elidecode --help ; bash'" },
  { "e2dbg32", "urxvt -e sh -c 'e2dbg32 ; bash'" },
  { "e2dbg64", "urxvt -e sh -c 'e2dbg64 ; bash'" },
  { "etrace32", "urxvt -e sh -c 'etrace32 ; bash'" },
  { "etrace64", "urxvt -e sh -c 'etrace64 ; bash'" },
  { "evarista32", "urxvt -e sh -c 'evarista32 ; bash'" },
  { "evarista64", "urxvt -e sh -c 'evarista64 ; bash'" },
  { "kedbg32", "urxvt -e sh -c 'kedbg32 ; bash'" },
  { "kedbg64", "urxvt -e sh -c 'kedbg64 ; bash'" },
  { "expose", "urxvt -e sh -c 'expose ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "compress", "urxvt -e sh -c 'compress ; bash'" },
  { "lint", "urxvt -e sh -c 'lint ; bash'" },
  { "release", "urxvt -e sh -c 'release ; bash'" },
  { "source-highlight", "urxvt -e sh -c 'source-highlight ; bash'" },
  { ".coverrc", "urxvt -e sh -c '.coverrc ; bash'" },
  { "cover", "urxvt -e sh -c 'cover ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "compress", "urxvt -e sh -c 'compress ; bash'" },
  { "lint", "urxvt -e sh -c 'lint ; bash'" },
  { "release", "urxvt -e sh -c 'release ; bash'" },
  { "source-highlight", "urxvt -e sh -c 'source-highlight ; bash'" },
  { ".coverrc", "urxvt -e sh -c '.coverrc ; bash'" },
  { "cover", "urxvt -e sh -c 'cover ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "test262.whitelist", "urxvt -e sh -c 'test262.whitelist ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "ncp", "urxvt -e sh -c 'ncp ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "parser", "urxvt -e sh -c 'parser ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "flasm", "urxvt -e sh -c 'flasm -h ; bash'" },
  { "frida-extract", "urxvt -e sh -c 'frida-extract -h ; bash'" },
  { "frida-ios-dump", "urxvt -e sh -c 'frida-ios-dump -h ; bash'" },
  { "ghidra", "urxvt -e sh -c 'ghidra ; bash'" },
  { "ghidra-analyzeHeadless", "urxvt -e sh -c 'ghidra-analyzeHeadless ; bash'" },
  { "ghidra", "urxvt -e sh -c 'ghidra ; bash'" },
  { "ghidra-analyzeHeadless", "urxvt -e sh -c 'ghidra-analyzeHeadless ; bash'" },
  { "gostringsr2", "urxvt -e sh -c 'gostringsr2 -h ; bash'" },
  { "hopper", "urxvt -e sh -c 'hopper ; bash'" },
  { "iaito", "urxvt -e sh -c 'iaito ; bash'" },
  { "innounp", "urxvt -e sh -c 'innounp ; bash'" },
  { "jad", "urxvt -e sh -c 'jad -h ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "javasnoop", "urxvt -e sh -c 'javasnoop ; bash'" },
  { "jd-cli", "urxvt -e sh -c 'jd-cli -h ; bash'" },
  { "jd-gui", "urxvt -e sh -c 'jd-gui ; bash'" },
  { "jdeserialize", "urxvt -e sh -c 'jdeserialize ; bash'" },
  { "jeb-android", "urxvt -e sh -c 'jeb-android ; bash'" },
  { "jeb-arm", "urxvt -e sh -c 'jeb-arm ; bash'" },
  { "jeb-intel", "urxvt -e sh -c 'jeb-intel ; bash'" },
  { "jeb-webasm", "urxvt -e sh -c 'jeb-webasm ; bash'" },
  { "jsparser", "urxvt -e sh -c 'jsparser --help ; bash'" },
  { "jwscan", "urxvt -e sh -c 'jwscan -h ; bash'" },
  { "gen-bout", "urxvt -e sh -c 'gen-bout ; bash'" },
  { "gen-random-bout", "urxvt -e sh -c 'gen-random-bout ; bash'" },
  { "kleaver", "urxvt -e sh -c 'kleaver -h ; bash'" },
  { "klee", "urxvt -e sh -c 'klee -h ; bash'" },
  { "klee-stats", "urxvt -e sh -c 'klee-stats -h ; bash'" },
  { "ktest-tool", "urxvt -e sh -c 'ktest-tool -h ; bash'" },
  { "libc-add", "urxvt -e sh -c 'libc-add -h ; bash'" },
  { "libc-download", "urxvt -e sh -c 'libc-download -h ; bash'" },
  { "libc-dump", "urxvt -e sh -c 'libc-dump -h ; bash'" },
  { "libc-find", "urxvt -e sh -c 'libc-find -h ; bash'" },
  { "libc-get", "urxvt -e sh -c 'libc-get -h ; bash'" },
  { "libc-identify", "urxvt -e sh -c 'libc-identify -h ; bash'" },
  { "elf-reader", "urxvt -e sh -c 'elf-reader ; bash'" },
  { "macho-reader", "urxvt -e sh -c 'macho-reader ; bash'" },
  { "pe-reader", "urxvt -e sh -c 'pe-reader ; bash'" },
  { "malwasm", "urxvt -e sh -c 'malwasm ; bash'" },
  { "mara-framework", "urxvt -e sh -c 'mara-framework ; bash'" },
  { "jadx", "urxvt -e sh -c 'jadx -h ; bash'" },
  { "jadx-gui", "urxvt -e sh -c 'jadx-gui ; bash'" },
  { "fedora-dirk-ipv6.diff", "urxvt -e sh -c 'fedora-dirk-ipv6.diff ; bash'" },
  { "openssl.Darwin.x86_64", "urxvt -e sh -c 'openssl.Darwin.x86_64 ; bash'" },
  { "openssl.Linux.i686", "urxvt -e sh -c 'openssl.Linux.i686 ; bash'" },
  { "openssl.Linux.x86_64", "urxvt -e sh -c 'openssl.Linux.x86_64 ; bash'" },
  { "marc4dasm", "urxvt -e sh -c 'marc4dasm -h ; bash'" },
  { "createnpk", "urxvt -e sh -c 'createnpk ; bash'" },
  { "dumpnpk", "urxvt -e sh -c 'dumpnpk ; bash'" },
  { "unpacknpk", "urxvt -e sh -c 'unpacknpk ; bash'" },
  { "netzob", "urxvt -e sh -c 'netzob -h ; bash'" },
  { "nili", "urxvt -e sh -c 'nili ; bash'" },
  { "objection", "urxvt -e sh -c 'objection --help ; bash'" },
  { "packerid", "urxvt -e sh -c 'packerid -h ; bash'" },
  { "pcileech", "urxvt -e sh -c 'pcileech ; bash'" },
  { "peframe", "urxvt -e sh -c 'peframe ; bash'" },
  { "pepper", "urxvt -e sh -c 'pepper -h ; bash'" },
  { "pin", "urxvt -e sh -c 'pin ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "pindb.sig", "urxvt -e sh -c 'pindb.sig ; bash'" },
  { "pindb", "urxvt -e sh -c 'pindb ; bash'" },
  { "pindb.sig", "urxvt -e sh -c 'pindb.sig ; bash'" },
  { "pintool", "urxvt -e sh -c 'pintool -h ; bash'" },
  { "pintool2", "urxvt -e sh -c 'pintool2 -h ; bash'" },
  { "pwntools-asm", "urxvt -e sh -c 'pwntools-asm -h ; bash'" },
  { "pwntools-checksec", "urxvt -e sh -c 'pwntools-checksec -h ; bash'" },
  { "pwntools-common", "urxvt -e sh -c 'pwntools-common -h ; bash'" },
  { "pwntools-constgrep", "urxvt -e sh -c 'pwntools-constgrep -h ; bash'" },
  { "pwntools-cyclic", "urxvt -e sh -c 'pwntools-cyclic -h ; bash'" },
  { "pwntools-debug", "urxvt -e sh -c 'pwntools-debug ; bash'" },
  { "pwntools-disablenx", "urxvt -e sh -c 'pwntools-disablenx ; bash'" },
  { "pwntools-disasm", "urxvt -e sh -c 'pwntools-disasm -h ; bash'" },
  { "pwntools-elfdiff", "urxvt -e sh -c 'pwntools-elfdiff -h ; bash'" },
  { "pwntools-elfpatch", "urxvt -e sh -c 'pwntools-elfpatch -h ; bash'" },
  { "pwntools-errno", "urxvt -e sh -c 'pwntools-errno -h ; bash'" },
  { "pwntools-hex", "urxvt -e sh -c 'pwntools-hex -h ; bash'" },
  { "pwntools-main", "urxvt -e sh -c 'pwntools-main -h ; bash'" },
  { "pwntools-phd", "urxvt -e sh -c 'pwntools-phd -h ; bash'" },
  { "pwntools-pwn", "urxvt -e sh -c 'pwntools-pwn -h ; bash'" },
  { "pwntools-pwnstrip", "urxvt -e sh -c 'pwntools-pwnstrip -h ; bash'" },
  { "pwntools-scramble", "urxvt -e sh -c 'pwntools-scramble -h ; bash'" },
  { "pwntools-unhex", "urxvt -e sh -c 'pwntools-unhex -h ; bash'" },
  { "pwntools-update", "urxvt -e sh -c 'pwntools-update -h ; bash'" },
  { "version", "urxvt -e sh -c 'version ; bash'" },
  { "frida", "urxvt -e sh -c 'frida -h ; bash'" },
  { "frida-create", "urxvt -e sh -c 'frida-create ; bash'" },
  { "frida-discover", "urxvt -e sh -c 'frida-discover -h ; bash'" },
  { "frida-join", "urxvt -e sh -c 'frida-join ; bash'" },
  { "frida-kill", "urxvt -e sh -c 'frida-kill -h ; bash'" },
  { "frida-ls-devices", "urxvt -e sh -c 'frida-ls-devices -h ; bash'" },
  { "frida-trace", "urxvt -e sh -c 'frida-trace -h ; bash'" },
  { "js-beautify", "urxvt -e sh -c 'js-beautify -h ; bash'" },
  { "frida-create2", "urxvt -e sh -c 'frida-create2 ; bash'" },
  { "frida-discover2", "urxvt -e sh -c 'frida-discover2 ; bash'" },
  { "frida-join2", "urxvt -e sh -c 'frida-join2 ; bash'" },
  { "frida-kill2", "urxvt -e sh -c 'frida-kill2 ; bash'" },
  { "frida-ls-devices2", "urxvt -e sh -c 'frida-ls-devices2 ; bash'" },
  { "frida-trace2", "urxvt -e sh -c 'frida-trace2 ; bash'" },
  { "frida2", "urxvt -e sh -c 'frida2 ; bash'" },
  { "js-beautify2", "urxvt -e sh -c 'js-beautify2 -h ; bash'" },
  { "quickscope", "urxvt -e sh -c 'quickscope -h ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "r2", "urxvt -e sh -c 'r2 -h ; bash'" },
  { "r2agent", "urxvt -e sh -c 'r2agent -h ; bash'" },
  { "r2pm", "urxvt -e sh -c 'r2pm ; bash'" },
  { "r2r", "urxvt -e sh -c 'r2r ; bash'" },
  { "radare2", "urxvt -e sh -c 'radare2 -h ; bash'" },
  { "radiff2", "urxvt -e sh -c 'radiff2 -h ; bash'" },
  { "rafind2", "urxvt -e sh -c 'rafind2 -h ; bash'" },
  { "ragg2", "urxvt -e sh -c 'ragg2 -h ; bash'" },
  { "rarun2", "urxvt -e sh -c 'rarun2 -h ; bash'" },
  { "rasign2", "urxvt -e sh -c 'rasign2 ; bash'" },
  { "rasm2", "urxvt -e sh -c 'rasm2 -h ; bash'" },
  { "rax2", "urxvt -e sh -c 'rax2 ; bash'" },
  { "rvc2", "urxvt -e sh -c 'rvc2 ; bash'" },
  { "recaf", "urxvt -e sh -c 'recaf ; bash'" },
  { "recstudio", "urxvt -e sh -c 'recstudio ; bash'" },
  { "redasm", "urxvt -e sh -c 'redasm ; bash'" },
  { "redress", "urxvt -e sh -c 'redress -h ; bash'" },
  { "retdec-ar-extractor", "urxvt -e sh -c 'retdec-ar-extractor -h ; bash'" },
  { "retdec-archive-decompiler", "urxvt -e sh -c 'retdec-archive-decompiler -h ; bash'" },
  { "retdec-color-c", "urxvt -e sh -c 'retdec-color-c -h ; bash'" },
  { "retdec-decompiler", "urxvt -e sh -c 'retdec-decompiler -h ; bash'" },
  { "retdec-fileinfo", "urxvt -e sh -c 'retdec-fileinfo -h ; bash'" },
  { "retdec-getsig", "urxvt -e sh -c 'retdec-getsig -h ; bash'" },
  { "retdec-idr2pat", "urxvt -e sh -c 'retdec-idr2pat -h ; bash'" },
  { "retdec-macho-extractor", "urxvt -e sh -c 'retdec-macho-extractor -h ; bash'" },
  { "retdec-pat2yara", "urxvt -e sh -c 'retdec-pat2yara -h ; bash'" },
  { "retdec-signature-from-library-creator", "urxvt -e sh -c 'retdec-signature-from-library-creator -h ; bash'" },
  { "retdec-stacofin", "urxvt -e sh -c 'retdec-stacofin -h ; bash'" },
  { "retdec-unpacker", "urxvt -e sh -c 'retdec-unpacker -h ; bash'" },
  { "retdec-utils", "urxvt -e sh -c 'retdec-utils -h ; bash'" },
  { "retdec-yarac", "urxvt -e sh -c 'retdec-yarac ; bash'" },
  { "scanmem", "urxvt -e sh -c 'scanmem -h ; bash'" },
  { "serializationdumper", "urxvt -e sh -c 'serializationdumper ; bash'" },
  { "shed", "urxvt -e sh -c 'shed ; bash'" },
  { "as3compile", "urxvt -e sh -c 'as3compile ; bash'" },
  { "font2swf", "urxvt -e sh -c 'font2swf ; bash'" },
  { "gif2swf", "urxvt -e sh -c 'gif2swf ; bash'" },
  { "jpeg2swf", "urxvt -e sh -c 'jpeg2swf ; bash'" },
  { "pdf2swf", "urxvt -e sh -c 'pdf2swf ; bash'" },
  { "png2swf", "urxvt -e sh -c 'png2swf ; bash'" },
  { "swfbbox", "urxvt -e sh -c 'swfbbox ; bash'" },
  { "swfc", "urxvt -e sh -c 'swfc ; bash'" },
  { "swfdump", "urxvt -e sh -c 'swfdump ; bash'" },
  { "swfextract", "urxvt -e sh -c 'swfextract ; bash'" },
  { "swfrender", "urxvt -e sh -c 'swfrender ; bash'" },
  { "swfstrings", "urxvt -e sh -c 'swfstrings ; bash'" },
  { "wav2swf", "urxvt -e sh -c 'wav2swf ; bash'" },
  { "udcli", "urxvt -e sh -c 'udcli -h ; bash'" },
  { "uefi-firmware-parser", "urxvt -e sh -c 'uefi-firmware-parser ; bash'" },
  { "veles", "urxvt -e sh -c 'veles ; bash'" },
}

scannermenu = {
  { "0d1n", "urxvt -e sh -c '0d1n ; bash'" },
  { "0d1n_view", "urxvt -e sh -c '0d1n_view ; bash'" },
  { "0trace", "urxvt -e sh -c '0trace ; bash'" },
  { "a2sv", "urxvt -e sh -c 'a2sv -h ; bash'" },
  { "adminpagefinder", "urxvt -e sh -c 'adminpagefinder -h ; bash'" },
  { "admsnmp", "urxvt -e sh -c 'admsnmp ; bash'" },
  { "allthevhosts", "urxvt -e sh -c 'allthevhosts ; bash'" },
  { "amass", "urxvt -e sh -c 'amass -h ; bash'" },
  { "androidsniffer", "urxvt -e sh -c 'androidsniffer -h ; bash'" },
  { "anti-xss", "urxvt -e sh -c 'anti-xss -h ; bash'" },
  { "apache-users", "urxvt -e sh -c 'apache-users ; bash'" },
  { "apnbf", "urxvt -e sh -c 'apnbf -h ; bash'" },
  { "appmon", "urxvt -e sh -c 'appmon ; bash'" },
  { "arjun", "urxvt -e sh -c 'arjun -h ; bash'" },
  { "arp-fingerprint", "urxvt -e sh -c 'arp-fingerprint -h ; bash'" },
  { "arp-scan", "urxvt -e sh -c 'arp-scan -h ; bash'" },
  { "get-iab", "urxvt -e sh -c 'get-iab -h ; bash'" },
  { "get-oui", "urxvt -e sh -c 'get-oui -h ; bash'" },
  { "arp-fingerprint", "urxvt -e sh -c 'arp-fingerprint -h ; bash'" },
  { "arp-scan", "urxvt -e sh -c 'arp-scan -h ; bash'" },
  { "get-iab", "urxvt -e sh -c 'get-iab -h ; bash'" },
  { "get-oui", "urxvt -e sh -c 'get-oui -h ; bash'" },
  { "asp-audit", "urxvt -e sh -c 'asp-audit ; bash'" },
  { "assetfinder", "urxvt -e sh -c 'assetfinder -h ; bash'" },
  { "atear", "urxvt -e sh -c 'atear -h ; bash'" },
  { "athena-ssl-scanner", "urxvt -e sh -c 'athena-ssl-scanner -h ; bash'" },
  { "atscan", "urxvt -e sh -c 'atscan ; bash'" },
  { "attk-cli", "urxvt -e sh -c 'attk-cli -h ; bash'" },
  { "attk-tui", "urxvt -e sh -c 'attk-tui -h ; bash'" },
  { "autorecon", "urxvt -e sh -c 'autorecon -h ; bash'" },
  { "aws-extender-cli", "urxvt -e sh -c 'aws-extender-cli -h ; bash'" },
  { "awsbucketdump", "urxvt -e sh -c 'awsbucketdump -h ; bash'" },
  { "badkarma", "urxvt -e sh -c 'badkarma ; bash'" },
  { "badministration", "urxvt -e sh -c 'badministration --help ; bash'" },
  { "barmie", "urxvt -e sh -c 'barmie ; bash'" },
  { "basedomainname", "urxvt -e sh -c 'basedomainname -h ; bash'" },
  { "bbscan", "urxvt -e sh -c 'bbscan -h ; bash'" },
  { "belati", "urxvt -e sh -c 'belati -h ; bash'" },
  { "billcipher", "urxvt -e sh -c 'billcipher ; bash'" },
  { "bing-lfi-rfi", "urxvt -e sh -c 'bing-lfi-rfi -h ; bash'" },
  { "bingoo", "urxvt -e sh -c 'bingoo ; bash'" },
  { "birp", "urxvt -e sh -c 'birp -h ; bash'" },
  { "blackbox-scanner", "urxvt -e sh -c 'blackbox-scanner -h ; bash'" },
  { "bleah", "urxvt -e sh -c 'bleah -h ; bash'" },
  { "blindy", "urxvt -e sh -c 'blindy -h ; bash'" },
  { "blue-hydra", "urxvt -e sh -c 'blue-hydra -h ; bash'" },
  { "blue_hydra", "urxvt -e sh -c 'blue_hydra ; bash'" },
  { "rfkill-reset", "urxvt -e sh -c 'rfkill-reset ; bash'" },
  { "test-discovery", "urxvt -e sh -c 'test-discovery ; bash'" },
  { "bluebox-ng", "urxvt -e sh -c 'bluebox-ng -h ; bash'" },
  { "bluelog", "urxvt -e sh -c 'bluelog -h ; bash'" },
  { "bluescan", "urxvt -e sh -c 'bluescan ; bash'" },
  { "bluto", "urxvt -e sh -c 'bluto ; bash'" },
  { "botb", "urxvt -e sh -c 'botb -h ; bash'" },
  { "braa", "urxvt -e sh -c 'braa -h ; bash'" },
  { "brakeman", "urxvt -e sh -c 'brakeman ; bash'" },
  { "bss", "urxvt -e sh -c 'bss -h ; bash'" },
  { "btscanner", "urxvt -e sh -c 'btscanner --help ; bash'" },
  { "c5scan", "urxvt -e sh -c 'c5scan -h ; bash'" },
  { "cameradar", "urxvt -e sh -c 'cameradar -h ; bash'" },
  { "camscan", "urxvt -e sh -c 'camscan -h ; bash'" },
  { "canari", "urxvt -e sh -c 'canari -h ; bash'" },
  { "dispatcher", "urxvt -e sh -c 'dispatcher -h ; bash'" },
  { "pysudo", "urxvt -e sh -c 'pysudo -h ; bash'" },
  { "cangibrina", "urxvt -e sh -c 'cangibrina -h ; bash'" },
  { "cansina", "urxvt -e sh -c 'cansina -h ; bash'" },
  { "cantoolz", "urxvt -e sh -c 'cantoolz -h ; bash'" },
  { "casefile", "urxvt -e sh -c 'casefile --help ; bash'" },
  { "maltego", "urxvt -e sh -c 'maltego -h ; bash'" },
  { "maltego.ico", "urxvt -e sh -c 'maltego.ico ; bash'" },
  { "cecster", "urxvt -e sh -c 'cecster -h ; bash'" },
  { "changeme", "urxvt -e sh -c 'changeme -h ; bash'" },
  { "chaosmap", "urxvt -e sh -c 'chaosmap ; bash'" },
  { "checksec", "urxvt -e sh -c 'checksec --help ; bash'" },
  { "chiron-attacks", "urxvt -e sh -c 'chiron-attacks ; bash'" },
  { "chiron-local-link", "urxvt -e sh -c 'chiron-local-link ; bash'" },
  { "chiron-nd", "urxvt -e sh -c 'chiron-nd ; bash'" },
  { "chiron-proxy", "urxvt -e sh -c 'chiron-proxy ; bash'" },
  { "chiron-scanner", "urxvt -e sh -c 'chiron-scanner ; bash'" },
  { "cipherscan", "urxvt -e sh -c 'cipherscan ; bash'" },
  { "CAT", "urxvt -e sh -c 'CAT ; bash'" },
  { "cisco-auditing-tool", "urxvt -e sh -c 'cisco-auditing-tool ; bash'" },
  { "cisco-scanner", "urxvt -e sh -c 'cisco-scanner -h ; bash'" },
  { "cisco-torch", "urxvt -e sh -c 'cisco-torch -h ; bash'" },
  { "ciscos", "urxvt -e sh -c 'ciscos ; bash'" },
  { "clair", "urxvt -e sh -c 'clair -h ; bash'" },
  { "clairctl", "urxvt -e sh -c 'clairctl ; bash'" },
  { "climber", "urxvt -e sh -c 'climber -h ; bash'" },
  { "cloudflare-enum", "urxvt -e sh -c 'cloudflare-enum ; bash'" },
  { "cloudmare", "urxvt -e sh -c 'cloudmare -h ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "zuul-es5.yml", "urxvt -e sh -c 'zuul-es5.yml ; bash'" },
  { "zuul-es6.yml", "urxvt -e sh -c 'zuul-es6.yml ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "_mocha", "urxvt -e sh -c '_mocha ; bash'" },
  { "mocha", "urxvt -e sh -c 'mocha ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "cloudunflare", "urxvt -e sh -c 'cloudunflare ; bash'" },
  { "cms-few", "urxvt -e sh -c 'cms-few -h ; bash'" },
  { "cmsfuzz", "urxvt -e sh -c 'cmsfuzz ; bash'" },
  { "cmsmap", "urxvt -e sh -c 'cmsmap -h ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "cmsscanner", "urxvt -e sh -c 'cmsscanner -h ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "comission", "urxvt -e sh -c 'comission -h ; bash'" },
  { "letdown", "urxvt -e sh -c 'letdown ; bash'" },
  { "reverseraider", "urxvt -e sh -c 'reverseraider ; bash'" },
  { "conscan", "urxvt -e sh -c 'conscan -h ; bash'" },
  { "cookie-cadger", "urxvt -e sh -c 'cookie-cadger ; bash'" },
  { "corscanner", "urxvt -e sh -c 'corscanner -h ; bash'" },
  { "corstest", "urxvt -e sh -c 'corstest -h ; bash'" },
  { "corsy", "urxvt -e sh -c 'corsy -h ; bash'" },
  { "cpfinder", "urxvt -e sh -c 'cpfinder -h ; bash'" },
  { "cme", "urxvt -e sh -c 'cme ; bash'" },
  { "cmedb", "urxvt -e sh -c 'cmedb ; bash'" },
  { "crlfuzz", "urxvt -e sh -c 'crlfuzz -h ; bash'" },
  { "ct-exposer", "urxvt -e sh -c 'ct-exposer -h ; bash'" },
  { "cvechecker", "urxvt -e sh -c 'cvechecker -h ; bash'" },
  { "cvegenversdat", "urxvt -e sh -c 'cvegenversdat ; bash'" },
  { "cvereport", "urxvt -e sh -c 'cvereport ; bash'" },
  { "cverules", "urxvt -e sh -c 'cverules ; bash'" },
  { "pullcves", "urxvt -e sh -c 'pullcves ; bash'" },
  { "cybercrowl", "urxvt -e sh -c 'cybercrowl -h ; bash'" },
  { "cyberscan", "urxvt -e sh -c 'cyberscan -h ; bash'" },
  { "d-tect", "urxvt -e sh -c 'd-tect ; bash'" },
  { "darkdump", "urxvt -e sh -c 'darkdump -h ; bash'" },
  { "darkscrape", "urxvt -e sh -c 'darkscrape ; bash'" },
  { "davscan", "urxvt -e sh -c 'davscan -h ; bash'" },
  { "davtest", "urxvt -e sh -c 'davtest ; bash'" },
  { "dawnscanner", "urxvt -e sh -c 'dawnscanner ; bash'" },
  { "dawn", "urxvt -e sh -c 'dawn -h ; bash'" },
  { "dbusmap", "urxvt -e sh -c 'dbusmap ; bash'" },
  { "dcrawl", "urxvt -e sh -c 'dcrawl -h ; bash'" },
  { "deblaze", "urxvt -e sh -c 'deblaze ; bash'" },
  { "delldrac", "urxvt -e sh -c 'delldrac -h ; bash'" },
  { "dhcpig", "urxvt -e sh -c 'dhcpig -h ; bash'" },
  { "html2dic", "urxvt -e sh -c 'html2dic ; bash'" },
  { "dirhunt", "urxvt -e sh -c 'dirhunt --help ; bash'" },
  { "dirscanner", "urxvt -e sh -c 'dirscanner -h ; bash'" },
  { "dirscraper", "urxvt -e sh -c 'dirscraper -h ; bash'" },
  { "dirsearch", "urxvt -e sh -c 'dirsearch -h ; bash'" },
  { "dirstalk", "urxvt -e sh -c 'dirstalk -h ; bash'" },
  { "dmitry", "urxvt -e sh -c 'dmitry ; bash'" },
  { "dns2geoip", "urxvt -e sh -c 'dns2geoip -h ; bash'" },
  { "dnsa-ng", "urxvt -e sh -c 'dnsa-ng ; bash'" },
  { "dnsbf", "urxvt -e sh -c 'dnsbf ; bash'" },
  { "dnsbrute", "urxvt -e sh -c 'dnsbrute -h ; bash'" },
  { "dnsenum", "urxvt -e sh -c 'dnsenum ; bash'" },
  { "dnsgoblin", "urxvt -e sh -c 'dnsgoblin ; bash'" },
  { "dnspredict", "urxvt -e sh -c 'dnspredict --help ; bash'" },
  { "dnsspider", "urxvt -e sh -c 'dnsspider -h ; bash'" },
  { "dnstwist", "urxvt -e sh -c 'dnstwist -h ; bash'" },
  { "dnswalk", "urxvt -e sh -c 'dnswalk --help ; bash'" },
  { "dockerscan", "urxvt -e sh -c 'dockerscan -h ; bash'" },
  { "dorkbot", "urxvt -e sh -c 'dorkbot -h ; bash'" },
  { "dorkme", "urxvt -e sh -c 'dorkme -h ; bash'" },
  { "driftnet", "urxvt -e sh -c 'driftnet -h ; bash'" },
  { "dripper", "urxvt -e sh -c 'dripper -h ; bash'" },
  { "droopescan", "urxvt -e sh -c 'droopescan -h ; bash'" },
  { "drozer", "urxvt -e sh -c 'drozer ; bash'" },
  { "drozer-repository", "urxvt -e sh -c 'drozer-repository ; bash'" },
  { "drupal-module-enum", "urxvt -e sh -c 'drupal-module-enum ; bash'" },
  { "drupalscan", "urxvt -e sh -c 'drupalscan ; bash'" },
  { "drupwn", "urxvt -e sh -c 'drupwn -h ; bash'" },
  { "dsfs", "urxvt -e sh -c 'dsfs -h ; bash'" },
  { "dsss", "urxvt -e sh -c 'dsss -h ; bash'" },
  { "dsxs", "urxvt -e sh -c 'dsxs -h ; bash'" },
  { "hg-decode", "urxvt -e sh -c 'hg-decode ; bash'" },
  { "rip-bzr", "urxvt -e sh -c 'rip-bzr ; bash'" },
  { "rip-cvs", "urxvt -e sh -c 'rip-cvs -h ; bash'" },
  { "rip-git", "urxvt -e sh -c 'rip-git -h ; bash'" },
  { "rip-hg", "urxvt -e sh -c 'rip-hg ; bash'" },
  { "rip-svn", "urxvt -e sh -c 'rip-svn -h ; bash'" },
  { "easyda", "urxvt -e sh -c 'easyda ; bash'" },
  { "eazy", "urxvt -e sh -c 'eazy -h ; bash'" },
  { "eigrp", "urxvt -e sh -c 'eigrp -h ; bash'" },
  { "enteletaor", "urxvt -e sh -c 'enteletaor ; bash'" },
  { "enum4linux", "urxvt -e sh -c 'enum4linux ; bash'" },
  { "enum4linux-ng", "urxvt -e sh -c 'enum4linux-ng -h ; bash'" },
  { "enumerate-iam", "urxvt -e sh -c 'enumerate-iam -h ; bash'" },
  { "enumiax", "urxvt -e sh -c 'enumiax ; bash'" },
  { "eos", "urxvt -e sh -c 'eos -h ; bash'" },
  { "elog", "urxvt -e sh -c 'elog ; bash'" },
  { "escan", "urxvt -e sh -c 'escan -h ; bash'" },
  { "evine", "urxvt -e sh -c 'evine -h ; bash'" },
  { "ssrf-search", "urxvt -e sh -c 'ssrf-search -h ; bash'" },
  { "faraday-manage", "urxvt -e sh -c 'faraday-manage ; bash'" },
  { "faraday-searcher", "urxvt -e sh -c 'faraday-searcher ; bash'" },
  { "faraday-server", "urxvt -e sh -c 'faraday-server ; bash'" },
  { "fernmelder", "urxvt -e sh -c 'fernmelder -h ; bash'" },
  { "feroxbuster", "urxvt -e sh -c 'feroxbuster -h ; bash'" },
  { "fgscan", "urxvt -e sh -c 'fgscan --help ; bash'" },
  { "fhttp", "urxvt -e sh -c 'fhttp -h ; bash'" },
  { "fi6s", "urxvt -e sh -c 'fi6s -h ; bash'" },
  { "fierce", "urxvt -e sh -c 'fierce ; bash'" },
  { "find-dns", "urxvt -e sh -c 'find-dns -h ; bash'" },
  { "firewalk", "urxvt -e sh -c 'firewalk -h ; bash'" },
  { "flunym0us", "urxvt -e sh -c 'flunym0us ; bash'" },
  { "forkingportscanner", "urxvt -e sh -c 'forkingportscanner ; bash'" },
  { "fping", "urxvt -e sh -c 'fping -h ; bash'" },
  { "fs-nyarl", "urxvt -e sh -c 'fs-nyarl -h ; bash'" },
  { "chaosreader0.94", "urxvt -e sh -c 'chaosreader0.94 ; bash'" },
  { "fsnoop", "urxvt -e sh -c 'fsnoop -h ; bash'" },
  { "ftp-scanner", "urxvt -e sh -c 'ftp-scanner -h ; bash'" },
  { "ftp-spider", "urxvt -e sh -c 'ftp-spider -h ; bash'" },
  { "ftpmap", "urxvt -e sh -c 'ftpmap -h ; bash'" },
  { "scout_cidr", "urxvt -e sh -c 'scout_cidr ; bash'" },
  { "gcpbucketbrute", "urxvt -e sh -c 'gcpbucketbrute -h ; bash'" },
  { "gggooglescan", "urxvt -e sh -c 'gggooglescan -h ; bash'" },
  { "git-dump", "urxvt -e sh -c 'git-dump ; bash'" },
  { "git-dumper", "urxvt -e sh -c 'git-dumper -h ; bash'" },
  { "gitdorker", "urxvt -e sh -c 'gitdorker -h ; bash'" },
  { "gitrob", "urxvt -e sh -c 'gitrob -h ; bash'" },
  { "gittools-extractor", "urxvt -e sh -c 'gittools-extractor ; bash'" },
  { "gittools-gitdumper", "urxvt -e sh -c 'gittools-gitdumper ; bash'" },
  { "gittools-gitfinder", "urxvt -e sh -c 'gittools-gitfinder -h ; bash'" },
  { "gloom", "urxvt -e sh -c 'gloom ; bash'" },
  { "gobuster", "urxvt -e sh -c 'gobuster -h ; bash'" },
  { "goohak", "urxvt -e sh -c 'goohak ; bash'" },
  { "gospider", "urxvt -e sh -c 'gospider -h ; bash'" },
  { "gpredict", "urxvt -e sh -c 'gpredict -h ; bash'" },
  { "grabbb", "urxvt -e sh -c 'grabbb ; bash'" },
  { "gsad", "urxvt -e sh -c 'gsad -h ; bash'" },
  { "grepforrfi", "urxvt -e sh -c 'grepforrfi ; bash'" },
  { "grype", "urxvt -e sh -c 'grype -h ; bash'" },
  { "gtp-scan", "urxvt -e sh -c 'gtp-scan -h ; bash'" },
  { "database-statistics-sqlite", "urxvt -e sh -c 'database-statistics-sqlite ; bash'" },
  { "greenbone-certdata-sync", "urxvt -e sh -c 'greenbone-certdata-sync -h ; bash'" },
  { "greenbone-scapdata-sync", "urxvt -e sh -c 'greenbone-scapdata-sync -h ; bash'" },
  { "gvm-manage-certs", "urxvt -e sh -c 'gvm-manage-certs ; bash'" },
  { "gvm-migrate-to-postgres", "urxvt -e sh -c 'gvm-migrate-to-postgres ; bash'" },
  { "gvm-portnames-update", "urxvt -e sh -c 'gvm-portnames-update ; bash'" },
  { "gwcheck", "urxvt -e sh -c 'gwcheck -h ; bash'" },
  { "h2buster", "urxvt -e sh -c 'h2buster ; bash'" },
  { "h2t", "urxvt -e sh -c 'h2t -h ; bash'" },
  { "habu.arp.ping", "urxvt -e sh -c 'habu.arp.ping ; bash'" },
  { "habu.arp.poison", "urxvt -e sh -c 'habu.arp.poison ; bash'" },
  { "habu.arp.sniff", "urxvt -e sh -c 'habu.arp.sniff ; bash'" },
  { "habu.asydns", "urxvt -e sh -c 'habu.asydns ; bash'" },
  { "habu.b64", "urxvt -e sh -c 'habu.b64 ; bash'" },
  { "habu.cert.clone", "urxvt -e sh -c 'habu.cert.clone ; bash'" },
  { "habu.cert.names", "urxvt -e sh -c 'habu.cert.names ; bash'" },
  { "habu.crack.luhn", "urxvt -e sh -c 'habu.crack.luhn ; bash'" },
  { "habu.crack.snmp", "urxvt -e sh -c 'habu.crack.snmp ; bash'" },
  { "habu.crypto.fernet", "urxvt -e sh -c 'habu.crypto.fernet ; bash'" },
  { "habu.crypto.gppref", "urxvt -e sh -c 'habu.crypto.gppref ; bash'" },
  { "habu.crypto.xor", "urxvt -e sh -c 'habu.crypto.xor ; bash'" },
  { "habu.data.enrich", "urxvt -e sh -c 'habu.data.enrich ; bash'" },
  { "habu.data.extract.domain", "urxvt -e sh -c 'habu.data.extract.domain ; bash'" },
  { "habu.data.extract.email", "urxvt -e sh -c 'habu.data.extract.email ; bash'" },
  { "habu.data.extract.fqdn", "urxvt -e sh -c 'habu.data.extract.fqdn ; bash'" },
  { "habu.data.extract.ipv4", "urxvt -e sh -c 'habu.data.extract.ipv4 ; bash'" },
  { "habu.data.filter", "urxvt -e sh -c 'habu.data.filter ; bash'" },
  { "habu.data.select", "urxvt -e sh -c 'habu.data.select ; bash'" },
  { "habu.dhcp.discover", "urxvt -e sh -c 'habu.dhcp.discover ; bash'" },
  { "habu.dhcp.starvation", "urxvt -e sh -c 'habu.dhcp.starvation ; bash'" },
  { "habu.dns.lookup.forward", "urxvt -e sh -c 'habu.dns.lookup.forward ; bash'" },
  { "habu.dns.lookup.reverse", "urxvt -e sh -c 'habu.dns.lookup.reverse ; bash'" },
  { "habu.eicar", "urxvt -e sh -c 'habu.eicar ; bash'" },
  { "habu.forkbomb", "urxvt -e sh -c 'habu.forkbomb ; bash'" },
  { "habu.fqdn.finder", "urxvt -e sh -c 'habu.fqdn.finder ; bash'" },
  { "habu.gateway.find", "urxvt -e sh -c 'habu.gateway.find ; bash'" },
  { "habu.host", "urxvt -e sh -c 'habu.host ; bash'" },
  { "habu.http.headers", "urxvt -e sh -c 'habu.http.headers ; bash'" },
  { "habu.http.options", "urxvt -e sh -c 'habu.http.options ; bash'" },
  { "habu.http.tech", "urxvt -e sh -c 'habu.http.tech ; bash'" },
  { "habu.icmp.ping", "urxvt -e sh -c 'habu.icmp.ping ; bash'" },
  { "habu.ip.asn", "urxvt -e sh -c 'habu.ip.asn ; bash'" },
  { "habu.ip.geolocation", "urxvt -e sh -c 'habu.ip.geolocation ; bash'" },
  { "habu.ip.internal", "urxvt -e sh -c 'habu.ip.internal ; bash'" },
  { "habu.ip.public", "urxvt -e sh -c 'habu.ip.public ; bash'" },
  { "habu.karma", "urxvt -e sh -c 'habu.karma ; bash'" },
  { "habu.karma.bulk", "urxvt -e sh -c 'habu.karma.bulk ; bash'" },
  { "habu.land", "urxvt -e sh -c 'habu.land ; bash'" },
  { "habu.nc", "urxvt -e sh -c 'habu.nc ; bash'" },
  { "habu.net.contest", "urxvt -e sh -c 'habu.net.contest ; bash'" },
  { "habu.net.interfaces", "urxvt -e sh -c 'habu.net.interfaces ; bash'" },
  { "habu.nmap.excluded", "urxvt -e sh -c 'habu.nmap.excluded ; bash'" },
  { "habu.nmap.open", "urxvt -e sh -c 'habu.nmap.open ; bash'" },
  { "habu.nmap.ports", "urxvt -e sh -c 'habu.nmap.ports ; bash'" },
  { "habu.protoscan", "urxvt -e sh -c 'habu.protoscan ; bash'" },
  { "habu.server.ftp", "urxvt -e sh -c 'habu.server.ftp ; bash'" },
  { "habu.tcp.flags", "urxvt -e sh -c 'habu.tcp.flags ; bash'" },
  { "habu.tcp.isn", "urxvt -e sh -c 'habu.tcp.isn ; bash'" },
  { "habu.tcp.scan", "urxvt -e sh -c 'habu.tcp.scan ; bash'" },
  { "habu.tcp.synflood", "urxvt -e sh -c 'habu.tcp.synflood ; bash'" },
  { "habu.traceroute", "urxvt -e sh -c 'habu.traceroute ; bash'" },
  { "habu.upgrade", "urxvt -e sh -c 'habu.upgrade ; bash'" },
  { "habu.usercheck", "urxvt -e sh -c 'habu.usercheck ; bash'" },
  { "habu.version", "urxvt -e sh -c 'habu.version ; bash'" },
  { "habu.vhosts", "urxvt -e sh -c 'habu.vhosts ; bash'" },
  { "habu.virustotal", "urxvt -e sh -c 'habu.virustotal ; bash'" },
  { "habu.web.report", "urxvt -e sh -c 'habu.web.report ; bash'" },
  { "habu.whois.domain", "urxvt -e sh -c 'habu.whois.domain ; bash'" },
  { "habu.whois.ip", "urxvt -e sh -c 'habu.whois.ip ; bash'" },
  { "hackredis", "urxvt -e sh -c 'hackredis -h ; bash'" },
  { "hakku", "urxvt -e sh -c 'hakku ; bash'" },
  { "hakrawler", "urxvt -e sh -c 'hakrawler -h ; bash'" },
  { "halberd", "urxvt -e sh -c 'halberd -h ; bash'" },
  { "hasere", "urxvt -e sh -c 'hasere -h ; bash'" },
  { "hbad", "urxvt -e sh -c 'hbad -h ; bash'" },
  { "heartleech", "urxvt -e sh -c 'heartleech -h ; bash'" },
  { "hellraiser", "urxvt -e sh -c 'hellraiser -h ; bash'" },
  { "bundle", "urxvt -e sh -c 'bundle ; bash'" },
  { "rails", "urxvt -e sh -c 'rails ; bash'" },
  { "rake", "urxvt -e sh -c 'rake ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "spring", "urxvt -e sh -c 'spring ; bash'" },
  { "hikpwn", "urxvt -e sh -c 'hikpwn -h ; bash'" },
  { "homepwn", "urxvt -e sh -c 'homepwn -h ; bash'" },
  { "host-extract", "urxvt -e sh -c 'host-extract -h ; bash'" },
  { "hsecscan", "urxvt -e sh -c 'hsecscan -h ; bash'" },
  { "htcap", "urxvt -e sh -c 'htcap -h ; bash'" },
  { "http-enum", "urxvt -e sh -c 'http-enum -h ; bash'" },
  { "httpextract", "urxvt -e sh -c 'httpextract -h ; bash'" },
  { "httpforge", "urxvt -e sh -c 'httpforge -h ; bash'" },
  { "httpgrep", "urxvt -e sh -c 'httpgrep -H ; bash'" },
  { "httprobe", "urxvt -e sh -c 'httprobe -h ; bash'" },
  { "httpx", "urxvt -e sh -c 'httpx -h ; bash'" },
  { "hawk", "urxvt -e sh -c 'hawk --help ; bash'" },
  { "hwk-eagle", "urxvt -e sh -c 'hwk-eagle --help ; bash'" },
  { "iax-scan-hosts", "urxvt -e sh -c 'iax-scan-hosts -h ; bash'" },
  { "iax-scan-users", "urxvt -e sh -c 'iax-scan-users -h ; bash'" },
  { "icmpquery", "urxvt -e sh -c 'icmpquery ; bash'" },
  { "idswakeup", "urxvt -e sh -c 'idswakeup -h ; bash'" },
  { "ike-scan", "urxvt -e sh -c 'ike-scan -h ; bash'" },
  { "psk-crack", "urxvt -e sh -c 'psk-crack -h ; bash'" },
  { "iloscan", "urxvt -e sh -c 'iloscan ; bash'" },
  { "infip", "urxvt -e sh -c 'infip -h ; bash'" },
  { "inguma", "urxvt -e sh -c 'inguma -h ; bash'" },
  { "ingumagui", "urxvt -e sh -c 'ingumagui ; bash'" },
  { "injectus", "urxvt -e sh -c 'injectus ; bash'" },
  { "inurlbr", "urxvt -e sh -c 'inurlbr -h ; bash'" },
  { "iptv-cli", "urxvt -e sh -c 'iptv-cli ; bash'" },
  { "iptv-gui", "urxvt -e sh -c 'iptv-gui ; bash'" },
  { "addr6", "urxvt -e sh -c 'addr6 ; bash'" },
  { "blackhole6", "urxvt -e sh -c 'blackhole6 ; bash'" },
  { "flow6", "urxvt -e sh -c 'flow6 ; bash'" },
  { "frag6", "urxvt -e sh -c 'frag6 ; bash'" },
  { "icmp6", "urxvt -e sh -c 'icmp6 ; bash'" },
  { "jumbo6", "urxvt -e sh -c 'jumbo6 ; bash'" },
  { "messi", "urxvt -e sh -c 'messi ; bash'" },
  { "mldq6", "urxvt -e sh -c 'mldq6 ; bash'" },
  { "na6", "urxvt -e sh -c 'na6 ; bash'" },
  { "ni6", "urxvt -e sh -c 'ni6 ; bash'" },
  { "ns6", "urxvt -e sh -c 'ns6 ; bash'" },
  { "path6", "urxvt -e sh -c 'path6 -h ; bash'" },
  { "ra6", "urxvt -e sh -c 'ra6 ; bash'" },
  { "rd6", "urxvt -e sh -c 'rd6 ; bash'" },
  { "rs6", "urxvt -e sh -c 'rs6 ; bash'" },
  { "scan6", "urxvt -e sh -c 'scan6 ; bash'" },
  { "script6", "urxvt -e sh -c 'script6 ; bash'" },
  { "tcp6", "urxvt -e sh -c 'tcp6 ; bash'" },
  { "udp6", "urxvt -e sh -c 'udp6 ; bash'" },
  { "isme", "urxvt -e sh -c 'isme ; bash'" },
  { "jaadas", "urxvt -e sh -c 'jaadas -h ; bash'" },
  { "jaeles", "urxvt -e sh -c 'jaeles -h ; bash'" },
  { "jira-scan", "urxvt -e sh -c 'jira-scan ; bash'" },
  { "jok3r", "urxvt -e sh -c 'jok3r -h ; bash'" },
  { "joomlascan", "urxvt -e sh -c 'joomlascan -h ; bash'" },
  { "joomlavs", "urxvt -e sh -c 'joomlavs ; bash'" },
  { "kadimus", "urxvt -e sh -c 'kadimus -h ; bash'" },
  { "kal", "urxvt -e sh -c 'kal -h ; bash'" },
  { "katana-ktf.gui", "urxvt -e sh -c 'katana-ktf.gui ; bash'" },
  { "katana-ktfconsole", "urxvt -e sh -c 'katana-ktfconsole ; bash'" },
  { "katana-ktfktf", "urxvt -e sh -c 'katana-ktfktf ; bash'" },
  { "katana-ktflinker", "urxvt -e sh -c 'katana-ktflinker ; bash'" },
  { "katana-ktfrun", "urxvt -e sh -c 'katana-ktfrun ; bash'" },
  { "katana-ktfupdate", "urxvt -e sh -c 'katana-ktfupdate ; bash'" },
  { "kiterunner", "urxvt -e sh -c 'kiterunner -h ; bash'" },
  { "knock", "urxvt -e sh -c 'knock ; bash'" },
  { "knxmap", "urxvt -e sh -c 'knxmap -h ; bash'" },
  { "konan", "urxvt -e sh -c 'konan -h ; bash'" },
  { "kube-hunter", "urxvt -e sh -c 'kube-hunter -h ; bash'" },
  { "kubestriker", "urxvt -e sh -c 'kubestriker ; bash'" },
  { "kubolt", "urxvt -e sh -c 'kubolt -h ; bash'" },
  { "laf", "urxvt -e sh -c 'laf -h ; bash'" },
  { "ldapdomaindump", "urxvt -e sh -c 'ldapdomaindump -h ; bash'" },
  { "ldd2bloodhound", "urxvt -e sh -c 'ldd2bloodhound -h ; bash'" },
  { "ldd2pretty", "urxvt -e sh -c 'ldd2pretty ; bash'" },
  { "ldapenum", "urxvt -e sh -c 'ldapenum ; bash'" },
  { "leaklooker", "urxvt -e sh -c 'leaklooker -h ; bash'" },
  { "letmefuckit", "urxvt -e sh -c 'letmefuckit -h ; bash'" },
  { "leviathan", "urxvt -e sh -c 'leviathan ; bash'" },
  { "lfi-scanner", "urxvt -e sh -c 'lfi-scanner -h ; bash'" },
  { "lfisuite", "urxvt -e sh -c 'lfisuite ; bash'" },
  { "lightbulb", "urxvt -e sh -c 'lightbulb -h ; bash'" },
  { "linenum", "urxvt -e sh -c 'linenum -h ; bash'" },
  { "linikatz", "urxvt -e sh -c 'linikatz ; bash'" },
  { "linux-smart-enumeration", "urxvt -e sh -c 'linux-smart-enumeration -h ; bash'" },
  { "list-urls", "urxvt -e sh -c 'list-urls ; bash'" },
  { "lbb.db", "urxvt -e sh -c 'lbb.db ; bash'" },
  { "littleblackbox", "urxvt -e sh -c 'littleblackbox -h ; bash'" },
  { "loki-scanner", "urxvt -e sh -c 'loki-scanner -h ; bash'" },
  { "lotophagi", "urxvt -e sh -c 'lotophagi -h ; bash'" },
  { "lte-cell-scanner", "urxvt -e sh -c 'lte-cell-scanner --help ; bash'" },
  { "lulzbuster", "urxvt -e sh -c 'lulzbuster -H ; bash'" },
  { "lunar", "urxvt -e sh -c 'lunar -h ; bash'" },
  { "lynis", "urxvt -e sh -c 'lynis -h ; bash'" },
  { "magescan", "urxvt -e sh -c 'magescan ; bash'" },
  { "maligno-clientgen", "urxvt -e sh -c 'maligno-clientgen ; bash'" },
  { "maligno-srv", "urxvt -e sh -c 'maligno-srv ; bash'" },
  { "maltego", "urxvt -e sh -c 'maltego -h ; bash'" },
  { "maltego.ico", "urxvt -e sh -c 'maltego.ico ; bash'" },
  { "maryam", "urxvt -e sh -c 'maryam ; bash'" },
  { "massbleed", "urxvt -e sh -c 'massbleed ; bash'" },
  { "masscan", "urxvt -e sh -c 'masscan --help ; bash'" },
  { "meg", "urxvt -e sh -c 'meg -h ; bash'" },
  { "msf-ws.ru", "urxvt -e sh -c 'msf-ws.ru ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfdb", "urxvt -e sh -c 'msfdb ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "msfconsole", "urxvt -e sh -c 'msfconsole -h ; bash'" },
  { "msfd", "urxvt -e sh -c 'msfd -h ; bash'" },
  { "msfelfscan", "urxvt -e sh -c 'msfelfscan -h ; bash'" },
  { "msfmachscan", "urxvt -e sh -c 'msfmachscan -h ; bash'" },
  { "msfpescan", "urxvt -e sh -c 'msfpescan -h ; bash'" },
  { "msfrop", "urxvt -e sh -c 'msfrop -h ; bash'" },
  { "msfrpc", "urxvt -e sh -c 'msfrpc -h ; bash'" },
  { "msfrpcd", "urxvt -e sh -c 'msfrpcd -h ; bash'" },
  { "msfupdate", "urxvt -e sh -c 'msfupdate -h ; bash'" },
  { "msfvenom", "urxvt -e sh -c 'msfvenom -h ; bash'" },
  { "expressInstall.swf", "urxvt -e sh -c 'expressInstall.swf ; bash'" },
  { "stty", "urxvt -e sh -c 'stty ; bash'" },
  { "miranda", "urxvt -e sh -c 'miranda ; bash'" },
  { "mitm6", "urxvt -e sh -c 'mitm6 -h ; bash'" },
  { "modscan", "urxvt -e sh -c 'modscan -h ; bash'" },
  { "mongoaudit", "urxvt -e sh -c 'mongoaudit -h ; bash'" },
  { "mooscan", "urxvt -e sh -c 'mooscan -h ; bash'" },
  { "morxtraversal", "urxvt -e sh -c 'morxtraversal ; bash'" },
  { "mptcp-fragmenter", "urxvt -e sh -c 'mptcp-fragmenter ; bash'" },
  { "mptcp-scanner", "urxvt -e sh -c 'mptcp-scanner ; bash'" },
  { "mqtt-pwn", "urxvt -e sh -c 'mqtt-pwn -h ; bash'" },
  { "mssqlscan", "urxvt -e sh -c 'mssqlscan -h ; bash'" },
  { "multiscanner", "urxvt -e sh -c 'multiscanner -h ; bash'" },
  { "multiscanner-api", "urxvt -e sh -c 'multiscanner-api ; bash'" },
  { "multiscanner-web", "urxvt -e sh -c 'multiscanner-web ; bash'" },
  { "mwebfp", "urxvt -e sh -c 'mwebfp -h ; bash'" },
  { "naabu", "urxvt -e sh -c 'naabu -h ; bash'" },
  { "dnscat", "urxvt -e sh -c 'dnscat -h ; bash'" },
  { "dnslogger", "urxvt -e sh -c 'dnslogger -h ; bash'" },
  { "dnstest", "urxvt -e sh -c 'dnstest -h ; bash'" },
  { "dnsxss", "urxvt -e sh -c 'dnsxss -h ; bash'" },
  { "nbquery", "urxvt -e sh -c 'nbquery -h ; bash'" },
  { "nbsniff", "urxvt -e sh -c 'nbsniff -h ; bash'" },
  { "nbtscan", "urxvt -e sh -c 'nbtscan -h ; bash'" },
  { "netreconn", "urxvt -e sh -c 'netreconn -h ; bash'" },
  { "netscan", "urxvt -e sh -c 'netscan -h ; bash'" },
  { "netz", "urxvt -e sh -c 'netz -h ; bash'" },
  { "nextnet", "urxvt -e sh -c 'nextnet -h ; bash'" },
  { "nikto", "urxvt -e sh -c 'nikto -H ; bash'" },
  { "nili", "urxvt -e sh -c 'nili ; bash'" },
  { "ncat", "urxvt -e sh -c 'ncat -h ; bash'" },
  { "nmap", "urxvt -e sh -c 'nmap -h ; bash'" },
  { "nping", "urxvt -e sh -c 'nping -h ; bash'" },
  { "ncat", "urxvt -e sh -c 'ncat -h ; bash'" },
  { "nmap", "urxvt -e sh -c 'nmap -h ; bash'" },
  { "nping", "urxvt -e sh -c 'nping -h ; bash'" },
  { "nmbscan", "urxvt -e sh -c 'nmbscan ; bash'" },
  { "nosqlattack", "urxvt -e sh -c 'nosqlattack ; bash'" },
  { "nosqli", "urxvt -e sh -c 'nosqli -h ; bash'" },
  { "nray", "urxvt -e sh -c 'nray -h ; bash'" },
  { "nsdtool", "urxvt -e sh -c 'nsdtool ; bash'" },
  { "n3map", "urxvt -e sh -c 'n3map -h ; bash'" },
  { "n3map-johnify", "urxvt -e sh -c 'n3map-johnify ; bash'" },
  { "n3map-nsec3-lookup", "urxvt -e sh -c 'n3map-nsec3-lookup ; bash'" },
  { "nsia", "urxvt -e sh -c 'nsia -h ; bash'" },
  { "nsoq", "urxvt -e sh -c 'nsoq ; bash'" },
  { "ntlm-challenger", "urxvt -e sh -c 'ntlm-challenger -h ; bash'" },
  { "ntlm-scanner", "urxvt -e sh -c 'ntlm-scanner -h ; bash'" },
  { "ntlmrecon", "urxvt -e sh -c 'ntlmrecon -h ; bash'" },
  { "nuclei", "urxvt -e sh -c 'nuclei -h ; bash'" },
  { "nullinux", "urxvt -e sh -c 'nullinux ; bash'" },
  { "nullscan", "urxvt -e sh -c 'nullscan -H ; bash'" },
  { "o-saft", "urxvt -e sh -c 'o-saft -h ; bash'" },
  { "ocs-cisco", "urxvt -e sh -c 'ocs-cisco ; bash'" },
  { "okadminfinder", "urxvt -e sh -c 'okadminfinder -h ; bash'" },
  { "onesixtyone", "urxvt -e sh -c 'onesixtyone ; bash'" },
  { "onetwopunch", "urxvt -e sh -c 'onetwopunch -h ; bash'" },
  { "onionscan", "urxvt -e sh -c 'onionscan ; bash'" },
  { "onionsearch", "urxvt -e sh -c 'onionsearch -h ; bash'" },
  { "opendoor", "urxvt -e sh -c 'opendoor -h ; bash'" },
  { "autotailor", "urxvt -e sh -c 'autotailor ; bash'" },
  { "oscap", "urxvt -e sh -c 'oscap -h ; bash'" },
  { "oscap-chroot", "urxvt -e sh -c 'oscap-chroot -h ; bash'" },
  { "oscap-docker", "urxvt -e sh -c 'oscap-docker -h ; bash'" },
  { "oscap-podman", "urxvt -e sh -c 'oscap-podman -h ; bash'" },
  { "oscap-run-sce-script", "urxvt -e sh -c 'oscap-run-sce-script ; bash'" },
  { "oscap-vm", "urxvt -e sh -c 'oscap-vm -h ; bash'" },
  { "scap-as-rpm", "urxvt -e sh -c 'scap-as-rpm -h ; bash'" },
  { "greenbone-nvt-sync", "urxvt -e sh -c 'greenbone-nvt-sync -h ; bash'" },
  { "openvas-nasl", "urxvt -e sh -c 'openvas-nasl ; bash'" },
  { "openvas-nasl-lint", "urxvt -e sh -c 'openvas-nasl-lint ; bash'" },
  { "openvassd", "urxvt -e sh -c 'openvassd -h ; bash'" },
  { "owasp-bywaf", "urxvt -e sh -c 'owasp-bywaf -h ; bash'" },
  { "owtf", "urxvt -e sh -c 'owtf ; bash'" },
  { "pagodo", "urxvt -e sh -c 'pagodo -h ; bash'" },
  { "minewt", "urxvt -e sh -c 'minewt -h ; bash'" },
  { "paketto-lc", "urxvt -e sh -c 'paketto-lc -h ; bash'" },
  { "paratrace", "urxvt -e sh -c 'paratrace -h ; bash'" },
  { "scanrand", "urxvt -e sh -c 'scanrand -h ; bash'" },
  { "panhunt", "urxvt -e sh -c 'panhunt -h ; bash'" },
  { "parameth", "urxvt -e sh -c 'parameth -h ; bash'" },
  { "paranoic", "urxvt -e sh -c 'paranoic -h ; bash'" },
  { "pbscan", "urxvt -e sh -c 'pbscan -h ; bash'" },
  { "pcredz", "urxvt -e sh -c 'pcredz -h ; bash'" },
  { "linpeas", "urxvt -e sh -c 'linpeas ; bash'" },
  { "pentbox", "urxvt -e sh -c 'pentbox ; bash'" },
  { "pentestly", "urxvt -e sh -c 'pentestly -h ; bash'" },
  { "phonia", "urxvt -e sh -c 'phonia -h ; bash'" },
  { "plcscan", "urxvt -e sh -c 'plcscan -h ; bash'" },
  { "pnscan", "urxvt -e sh -c 'pnscan -h ; bash'" },
  { "t_listen", "urxvt -e sh -c 't_listen ; bash'" },
  { "poison", "urxvt -e sh -c 'poison ; bash'" },
  { "postenum", "urxvt -e sh -c 'postenum -h ; bash'" },
  { "pown", "urxvt -e sh -c 'pown ; bash'" },
  { "ppfuzz", "urxvt -e sh -c 'ppfuzz -h ; bash'" },
  { "prads", "urxvt -e sh -c 'prads -h ; bash'" },
  { "prads-asset-report", "urxvt -e sh -c 'prads-asset-report ; bash'" },
  { "prads2snort", "urxvt -e sh -c 'prads2snort ; bash'" },
  { "praeda", "urxvt -e sh -c 'praeda -h ; bash'" },
  { "pret", "urxvt -e sh -c 'pret -h ; bash'" },
  { "propecia", "urxvt -e sh -c 'propecia ; bash'" },
  { "prowler", "urxvt -e sh -c 'prowler -h ; bash'" },
  { "proxmark", "urxvt -e sh -c 'proxmark ; bash'" },
  { "proxmark-fpga-compress", "urxvt -e sh -c 'proxmark-fpga-compress ; bash'" },
  { "proxycheck", "urxvt -e sh -c 'proxycheck -h ; bash'" },
  { "proxyp", "urxvt -e sh -c 'proxyp -h ; bash'" },
  { "proxyscan", "urxvt -e sh -c 'proxyscan -h ; bash'" },
  { "ptf", "urxvt -e sh -c 'ptf ; bash'" },
  { "pureblood", "urxvt -e sh -c 'pureblood ; bash'" },
  { "pwncat", "urxvt -e sh -c 'pwncat cd /usr/share/windows/pwncat ; ls ; bash'" },
  { "pyersinia", "urxvt -e sh -c 'pyersinia -h ; bash'" },
  { "pyfiscan", "urxvt -e sh -c 'pyfiscan -h ; bash'" },
  { "pyssltest", "urxvt -e sh -c 'pyssltest -h ; bash'" },
  { "pytbull", "urxvt -e sh -c 'pytbull -h ; bash'" },
  { "pythem", "urxvt -e sh -c 'pythem ; bash'" },
  { "shodan", "urxvt -e sh -c 'shodan ; bash'" },
  { "ldapdomaindump2", "urxvt -e sh -c 'ldapdomaindump2 -h ; bash'" },
  { "ldd2bloodhound2", "urxvt -e sh -c 'ldd2bloodhound2 -h ; bash'" },
  { "ldd2pretty2", "urxvt -e sh -c 'ldd2pretty2 ; bash'" },
  { "shodan2", "urxvt -e sh -c 'shodan2 ; bash'" },
  { "webtech2", "urxvt -e sh -c 'webtech2 ; bash'" },
  { "qark", "urxvt -e sh -c 'qark ; bash'" },
  { "quickrecon", "urxvt -e sh -c 'quickrecon -h ; bash'" },
  { "raccoon", "urxvt -e sh -c 'raccoon --help ; bash'" },
  { "ranger-scanner", "urxvt -e sh -c 'ranger-scanner ; bash'" },
  { "rapidscan", "urxvt -e sh -c 'rapidscan ; bash'" },
  { "ratproxy", "urxvt -e sh -c 'ratproxy -h ; bash'" },
  { "rawr", "urxvt -e sh -c 'rawr -h ; bash'" },
  { "rdp-cipher-checker", "urxvt -e sh -c 'rdp-cipher-checker ; bash'" },
  { "rdp-sec-check", "urxvt -e sh -c 'rdp-sec-check -h ; bash'" },
  { "reconscan-recon", "urxvt -e sh -c 'reconscan-recon -h ; bash'" },
  { "reconscan-vulnscan", "urxvt -e sh -c 'reconscan-vulnscan -h ; bash'" },
  { "recsech", "urxvt -e sh -c 'recsech ; bash'" },
  { "red-hawk", "urxvt -e sh -c 'red-hawk ; bash'" },
  { "redfang", "urxvt -e sh -c 'redfang --help ; bash'" },
  { "relay-scanner", "urxvt -e sh -c 'relay-scanner -help ; bash'" },
  { "responder", "urxvt -e sh -c 'responder -h ; bash'" },
  { "responder-dhcp", "urxvt -e sh -c 'responder-dhcp ; bash'" },
  { "responder-dhcp-auto", "urxvt -e sh -c 'responder-dhcp-auto ; bash'" },
  { "responder-findsqlsrv", "urxvt -e sh -c 'responder-findsqlsrv ; bash'" },
  { "responder-icmp-redirect", "urxvt -e sh -c 'responder-icmp-redirect ; bash'" },
  { "responder-multirelay", "urxvt -e sh -c 'responder-multirelay ; bash'" },
  { "responder-report", "urxvt -e sh -c 'responder-report ; bash'" },
  { "responder-runfinger", "urxvt -e sh -c 'responder-runfinger ; bash'" },
  { "responder-secretsdump", "urxvt -e sh -c 'responder-secretsdump ; bash'" },
  { "Runas.c", "urxvt -e sh -c 'Runas.c ; bash'" },
  { "Syssvc.c", "urxvt -e sh -c 'Syssvc.c ; bash'" },
  { "retire", "urxvt -e sh -c 'retire -h ; bash'" },
  { "revipd", "urxvt -e sh -c 'revipd ; bash'" },
  { "rext", "urxvt -e sh -c 'rext ; bash'" },
  { "ripdc", "urxvt -e sh -c 'ripdc -H ; bash'" },
  { "rlogin-scanner", "urxvt -e sh -c 'rlogin-scanner -h ; bash'" },
  { "routerhunter", "urxvt -e sh -c 'routerhunter -h ; bash'" },
  { "rpdscan", "urxvt -e sh -c 'rpdscan -h ; bash'" },
  { "rtlizer", "urxvt -e sh -c 'rtlizer -h ; bash'" },
  { "rustbuster", "urxvt -e sh -c 'rustbuster --help ; bash'" },
  { "rustscan", "urxvt -e sh -c 'rustscan -h ; bash'" },
  { "s3scanner", "urxvt -e sh -c 's3scanner -h ; bash'" },
  { "sambascan", "urxvt -e sh -c 'sambascan -h ; bash'" },
  { "sandcastle", "urxvt -e sh -c 'sandcastle ; bash'" },
  { "sandmap", "urxvt -e sh -c 'sandmap --help ; bash'" },
  { "sandy", "urxvt -e sh -c 'sandy -h ; bash'" },
  { "sb0x", "urxvt -e sh -c 'sb0x -h ; bash'" },
  { "sc_ally", "urxvt -e sh -c 'sc_ally -h ; bash'" },
  { "sc_analysis_dump", "urxvt -e sh -c 'sc_analysis_dump -h ; bash'" },
  { "sc_attach", "urxvt -e sh -c 'sc_attach -h ; bash'" },
  { "sc_bdrmap", "urxvt -e sh -c 'sc_bdrmap ; bash'" },
  { "sc_erosprober", "urxvt -e sh -c 'sc_erosprober ; bash'" },
  { "sc_filterpolicy", "urxvt -e sh -c 'sc_filterpolicy -h ; bash'" },
  { "sc_ipiddump", "urxvt -e sh -c 'sc_ipiddump -h ; bash'" },
  { "sc_pinger", "urxvt -e sh -c 'sc_pinger ; bash'" },
  { "sc_prefixscan", "urxvt -e sh -c 'sc_prefixscan ; bash'" },
  { "sc_radargun", "urxvt -e sh -c 'sc_radargun ; bash'" },
  { "sc_remoted", "urxvt -e sh -c 'sc_remoted ; bash'" },
  { "sc_speedtrap", "urxvt -e sh -c 'sc_speedtrap -h ; bash'" },
  { "sc_tbitblind", "urxvt -e sh -c 'sc_tbitblind -h ; bash'" },
  { "sc_tbitpmtud", "urxvt -e sh -c 'sc_tbitpmtud ; bash'" },
  { "sc_tracediff", "urxvt -e sh -c 'sc_tracediff -h ; bash'" },
  { "sc_ttlexp", "urxvt -e sh -c 'sc_ttlexp ; bash'" },
  { "sc_warts2csv", "urxvt -e sh -c 'sc_warts2csv -h ; bash'" },
  { "sc_warts2pcap", "urxvt -e sh -c 'sc_warts2pcap -h ; bash'" },
  { "sc_warts2text", "urxvt -e sh -c 'sc_warts2text -h ; bash'" },
  { "sc_wartscat", "urxvt -e sh -c 'sc_wartscat -h ; bash'" },
  { "sc_wartsdump", "urxvt -e sh -c 'sc_wartsdump -h ; bash'" },
  { "sc_wartsfilter", "urxvt -e sh -c 'sc_wartsfilter ; bash'" },
  { "sc_wartsfix", "urxvt -e sh -c 'sc_wartsfix -h ; bash'" },
  { "scamper", "urxvt -e sh -c 'scamper -h ; bash'" },
  { "scanless", "urxvt -e sh -c 'scanless -h ; bash'" },
  { "scanqli", "urxvt -e sh -c 'scanqli -h ; bash'" },
  { "scap-workbench", "urxvt -e sh -c 'scap-workbench ; bash'" },
  { "scout2", "urxvt -e sh -c 'scout2 -h ; bash'" },
  { "scoutsuite", "urxvt -e sh -c 'scoutsuite ; bash'" },
  { "scrape-dns", "urxvt -e sh -c 'scrape-dns ; bash'" },
  { "of-access", "urxvt -e sh -c 'of-access -h ; bash'" },
  { "of-check", "urxvt -e sh -c 'of-check -h ; bash'" },
  { "of-enum", "urxvt -e sh -c 'of-enum -h ; bash'" },
  { "of-flood", "urxvt -e sh -c 'of-flood -h ; bash'" },
  { "of-map", "urxvt -e sh -c 'of-map -h ; bash'" },
  { "of-scan", "urxvt -e sh -c 'of-scan ; bash'" },
  { "of-switch", "urxvt -e sh -c 'of-switch -h ; bash'" },
  { "sdnpwn", "urxvt -e sh -c 'sdnpwn ; bash'" },
  { "seat", "urxvt -e sh -c 'seat -h ; bash'" },
  { "secscan", "urxvt -e sh -c 'secscan -h ; bash'" },
  { "see-surf", "urxvt -e sh -c 'see-surf -h ; bash'" },
  { "shareenum", "urxvt -e sh -c 'shareenum ; bash'" },
  { "sharesniffer", "urxvt -e sh -c 'sharesniffer -h ; bash'" },
  { "shocker", "urxvt -e sh -c 'shocker -h ; bash'" },
  { "shortfuzzy", "urxvt -e sh -c 'shortfuzzy -h ; bash'" },
  { "shuffledns", "urxvt -e sh -c 'shuffledns -h ; bash'" },
  { "flowcap", "urxvt -e sh -c 'flowcap ; bash'" },
  { "num2dot", "urxvt -e sh -c 'num2dot ; bash'" },
  { "rwaddrcount", "urxvt -e sh -c 'rwaddrcount ; bash'" },
  { "rwaggbag", "urxvt -e sh -c 'rwaggbag ; bash'" },
  { "rwaggbagbuild", "urxvt -e sh -c 'rwaggbagbuild ; bash'" },
  { "rwaggbagcat", "urxvt -e sh -c 'rwaggbagcat ; bash'" },
  { "rwaggbagtool", "urxvt -e sh -c 'rwaggbagtool ; bash'" },
  { "rwallformats", "urxvt -e sh -c 'rwallformats ; bash'" },
  { "rwbag", "urxvt -e sh -c 'rwbag ; bash'" },
  { "rwbagbuild", "urxvt -e sh -c 'rwbagbuild ; bash'" },
  { "rwbagcat", "urxvt -e sh -c 'rwbagcat ; bash'" },
  { "rwbagtool", "urxvt -e sh -c 'rwbagtool ; bash'" },
  { "rwcat", "urxvt -e sh -c 'rwcat ; bash'" },
  { "rwcompare", "urxvt -e sh -c 'rwcompare ; bash'" },
  { "rwcount", "urxvt -e sh -c 'rwcount ; bash'" },
  { "rwcut", "urxvt -e sh -c 'rwcut ; bash'" },
  { "rwdedupe", "urxvt -e sh -c 'rwdedupe ; bash'" },
  { "rwfglob", "urxvt -e sh -c 'rwfglob ; bash'" },
  { "rwfileinfo", "urxvt -e sh -c 'rwfileinfo ; bash'" },
  { "rwfilter", "urxvt -e sh -c 'rwfilter ; bash'" },
  { "rwflowpack", "urxvt -e sh -c 'rwflowpack ; bash'" },
  { "rwgeoip2ccmap", "urxvt -e sh -c 'rwgeoip2ccmap ; bash'" },
  { "rwgroup", "urxvt -e sh -c 'rwgroup ; bash'" },
  { "rwguess", "urxvt -e sh -c 'rwguess ; bash'" },
  { "rwidsquery", "urxvt -e sh -c 'rwidsquery ; bash'" },
  { "rwip2cc", "urxvt -e sh -c 'rwip2cc ; bash'" },
  { "rwipfix2silk", "urxvt -e sh -c 'rwipfix2silk ; bash'" },
  { "rwmatch", "urxvt -e sh -c 'rwmatch ; bash'" },
  { "rwnetmask", "urxvt -e sh -c 'rwnetmask ; bash'" },
  { "rwp2yaf2silk", "urxvt -e sh -c 'rwp2yaf2silk ; bash'" },
  { "rwpackchecker", "urxvt -e sh -c 'rwpackchecker ; bash'" },
  { "rwpcut", "urxvt -e sh -c 'rwpcut ; bash'" },
  { "rwpdedupe", "urxvt -e sh -c 'rwpdedupe ; bash'" },
  { "rwpdu2silk", "urxvt -e sh -c 'rwpdu2silk ; bash'" },
  { "rwpmapbuild", "urxvt -e sh -c 'rwpmapbuild ; bash'" },
  { "rwpmapcat", "urxvt -e sh -c 'rwpmapcat ; bash'" },
  { "rwpmatch", "urxvt -e sh -c 'rwpmatch ; bash'" },
  { "rwptoflow", "urxvt -e sh -c 'rwptoflow ; bash'" },
  { "rwrandomizeip", "urxvt -e sh -c 'rwrandomizeip ; bash'" },
  { "rwreceiver", "urxvt -e sh -c 'rwreceiver ; bash'" },
  { "rwrecgenerator", "urxvt -e sh -c 'rwrecgenerator ; bash'" },
  { "rwresolve", "urxvt -e sh -c 'rwresolve ; bash'" },
  { "rwscan", "urxvt -e sh -c 'rwscan ; bash'" },
  { "rwsender", "urxvt -e sh -c 'rwsender ; bash'" },
  { "rwset", "urxvt -e sh -c 'rwset ; bash'" },
  { "rwsetbuild", "urxvt -e sh -c 'rwsetbuild ; bash'" },
  { "rwsetcat", "urxvt -e sh -c 'rwsetcat ; bash'" },
  { "rwsetmember", "urxvt -e sh -c 'rwsetmember ; bash'" },
  { "rwsettool", "urxvt -e sh -c 'rwsettool ; bash'" },
  { "rwsilk2ipfix", "urxvt -e sh -c 'rwsilk2ipfix ; bash'" },
  { "rwsiteinfo", "urxvt -e sh -c 'rwsiteinfo ; bash'" },
  { "rwsort", "urxvt -e sh -c 'rwsort ; bash'" },
  { "rwstats", "urxvt -e sh -c 'rwstats ; bash'" },
  { "rwswapbytes", "urxvt -e sh -c 'rwswapbytes ; bash'" },
  { "rwtotal", "urxvt -e sh -c 'rwtotal ; bash'" },
  { "rwtuc", "urxvt -e sh -c 'rwtuc ; bash'" },
  { "rwuniq", "urxvt -e sh -c 'rwuniq ; bash'" },
  { "sitadel", "urxvt -e sh -c 'sitadel -h ; bash'" },
  { "sfscandiff", "urxvt -e sh -c 'sfscandiff -h ; bash'" },
  { "slurp-scanner", "urxvt -e sh -c 'slurp-scanner ; bash'" },
  { "smartphone-pentest-framework", "urxvt -e sh -c 'smartphone-pentest-framework -h ; bash'" },
  { "ar", "urxvt -e sh -c 'ar ; bash'" },
  { "as", "urxvt -e sh -c 'as --help ; bash'" },
  { "c++", "urxvt -e sh -c 'c++ ; bash'" },
  { "g++", "urxvt -e sh -c 'g++ ; bash'" },
  { "gcc", "urxvt -e sh -c 'gcc ; bash'" },
  { "ld", "urxvt -e sh -c 'ld ; bash'" },
  { "nm", "urxvt -e sh -c 'nm -h ; bash'" },
  { "objdump", "urxvt -e sh -c 'objdump ; bash'" },
  { "ranlib", "urxvt -e sh -c 'ranlib ; bash'" },
  { "strip", "urxvt -e sh -c 'strip ; bash'" },
  { "arm-linux-androideabi-addr2line", "urxvt -e sh -c 'arm-linux-androideabi-addr2line ; bash'" },
  { "arm-linux-androideabi-ar", "urxvt -e sh -c 'arm-linux-androideabi-ar ; bash'" },
  { "arm-linux-androideabi-as", "urxvt -e sh -c 'arm-linux-androideabi-as ; bash'" },
  { "arm-linux-androideabi-c++", "urxvt -e sh -c 'arm-linux-androideabi-c++ ; bash'" },
  { "arm-linux-androideabi-c++filt", "urxvt -e sh -c 'arm-linux-androideabi-c++filt ; bash'" },
  { "arm-linux-androideabi-cpp", "urxvt -e sh -c 'arm-linux-androideabi-cpp ; bash'" },
  { "arm-linux-androideabi-elfedit", "urxvt -e sh -c 'arm-linux-androideabi-elfedit ; bash'" },
  { "arm-linux-androideabi-g++", "urxvt -e sh -c 'arm-linux-androideabi-g++ ; bash'" },
  { "arm-linux-androideabi-gcc", "urxvt -e sh -c 'arm-linux-androideabi-gcc ; bash'" },
  { "arm-linux-androideabi-gcc-4.6", "urxvt -e sh -c 'arm-linux-androideabi-gcc-4.6 ; bash'" },
  { "arm-linux-androideabi-gcov", "urxvt -e sh -c 'arm-linux-androideabi-gcov ; bash'" },
  { "arm-linux-androideabi-gdb", "urxvt -e sh -c 'arm-linux-androideabi-gdb ; bash'" },
  { "arm-linux-androideabi-gdbtui", "urxvt -e sh -c 'arm-linux-androideabi-gdbtui ; bash'" },
  { "arm-linux-androideabi-gprof", "urxvt -e sh -c 'arm-linux-androideabi-gprof ; bash'" },
  { "arm-linux-androideabi-ld", "urxvt -e sh -c 'arm-linux-androideabi-ld ; bash'" },
  { "arm-linux-androideabi-nm", "urxvt -e sh -c 'arm-linux-androideabi-nm ; bash'" },
  { "arm-linux-androideabi-objdump", "urxvt -e sh -c 'arm-linux-androideabi-objdump ; bash'" },
  { "arm-linux-androideabi-ranlib", "urxvt -e sh -c 'arm-linux-androideabi-ranlib ; bash'" },
  { "arm-linux-androideabi-readelf", "urxvt -e sh -c 'arm-linux-androideabi-readelf ; bash'" },
  { "arm-linux-androideabi-run", "urxvt -e sh -c 'arm-linux-androideabi-run ; bash'" },
  { "arm-linux-androideabi-size", "urxvt -e sh -c 'arm-linux-androideabi-size ; bash'" },
  { "arm-linux-androideabi-strings", "urxvt -e sh -c 'arm-linux-androideabi-strings ; bash'" },
  { "arm-linux-androideabi-strip", "urxvt -e sh -c 'arm-linux-androideabi-strip ; bash'" },
  { "smbgrab", "urxvt -e sh -c 'smbgrab -h ; bash'" },
  { "smbhunt", "urxvt -e sh -c 'smbhunt -h ; bash'" },
  { "smblist", "urxvt -e sh -c 'smblist -h ; bash'" },
  { "smbmap", "urxvt -e sh -c 'smbmap -h ; bash'" },
  { "smbspider", "urxvt -e sh -c 'smbspider -h ; bash'" },
  { "smod", "urxvt -e sh -c 'smod ; bash'" },
  { "smtp-test", "urxvt -e sh -c 'smtp-test -h ; bash'" },
  { "smtp-user-enum", "urxvt -e sh -c 'smtp-user-enum -h ; bash'" },
  { "smtp-vrfy", "urxvt -e sh -c 'smtp-vrfy ; bash'" },
  { "smtptx", "urxvt -e sh -c 'smtptx -h ; bash'" },
  { "smuggler", "urxvt -e sh -c 'smuggler -h ; bash'" },
  { "sn00p", "urxvt -e sh -c 'sn00p ; bash'" },
  { "sn1per", "urxvt -e sh -c 'sn1per ; bash'" },
  { "http-default-accounts-fingerprints-nndefaccts.lua", "urxvt -e sh -c 'http-default-accounts-fingerprints-nndefaccts.lua ; bash'" },
  { "inurlbr.php", "urxvt -e sh -c 'inurlbr.php ; bash'" },
  { "nmap-bootstrap.xsl", "urxvt -e sh -c 'nmap-bootstrap.xsl ; bash'" },
  { "snallygaster", "urxvt -e sh -c 'snallygaster -h ; bash'" },
  { "snmpattack", "urxvt -e sh -c 'snmpattack -h ; bash'" },
  { "snmpenum", "urxvt -e sh -c 'snmpenum ; bash'" },
  { "snoopbrute", "urxvt -e sh -c 'snoopbrute ; bash'" },
  { "snyk", "urxvt -e sh -c 'snyk -h ; bash'" },
  { "sparta", "urxvt -e sh -c 'sparta ; bash'" },
  { "spiga", "urxvt -e sh -c 'spiga -h ; bash'" },
  { "qtmsfconsole", "urxvt -e sh -c 'qtmsfconsole ; bash'" },
  { "sprayingtoolkit-aerosol", "urxvt -e sh -c 'sprayingtoolkit-aerosol -h ; bash'" },
  { "sprayingtoolkit-atomizer", "urxvt -e sh -c 'sprayingtoolkit-atomizer -h ; bash'" },
  { "sprayingtoolkit-spindrift", "urxvt -e sh -c 'sprayingtoolkit-spindrift -h ; bash'" },
  { "sprayingtoolkit-vaporizer", "urxvt -e sh -c 'sprayingtoolkit-vaporizer -h ; bash'" },
  { "sqlivulscan", "urxvt -e sh -c 'sqlivulscan ; bash'" },
  { "ssdp-scanner", "urxvt -e sh -c 'ssdp-scanner ; bash'" },
  { "ssl-hostname-resolver", "urxvt -e sh -c 'ssl-hostname-resolver -h ; bash'" },
  { "sslcaudit", "urxvt -e sh -c 'sslcaudit -h ; bash'" },
  { "ssllabs-scan", "urxvt -e sh -c 'ssllabs-scan -h ; bash'" },
  { "sslmap", "urxvt -e sh -c 'sslmap -h ; bash'" },
  { "sslscan", "urxvt -e sh -c 'sslscan ; bash'" },
  { "sslscan2", "urxvt -e sh -c 'sslscan2 -h ; bash'" },
  { "sslyze", "urxvt -e sh -c 'sslyze -h ; bash'" },
  { "ssrfmap", "urxvt -e sh -c 'ssrfmap -h ; bash'" },
  { "stig-viewer", "urxvt -e sh -c 'stig-viewer ; bash'" },
  { "storm-ring", "urxvt -e sh -c 'storm-ring -h ; bash'" },
  { "striker", "urxvt -e sh -c 'striker ; bash'" },
  { "strutscan", "urxvt -e sh -c 'strutscan -h ; bash'" },
  { "subbrute", "urxvt -e sh -c 'subbrute -h ; bash'" },
  { "subdomainer", "urxvt -e sh -c 'subdomainer ; bash'" },
  { "subjack", "urxvt -e sh -c 'subjack -h ; bash'" },
  { "sublist3r", "urxvt -e sh -c 'sublist3r -h ; bash'" },
  { "subover", "urxvt -e sh -c 'subover ; bash'" },
  { "subscraper", "urxvt -e sh -c 'subscraper -h ; bash'" },
  { "svn-extractor", "urxvt -e sh -c 'svn-extractor -h ; bash'" },
  { "swarm", "urxvt -e sh -c 'swarm -h ; bash'" },
  { "sslog", "urxvt -e sh -c 'sslog -h ; bash'" },
  { "synscan", "urxvt -e sh -c 'synscan -h ; bash'" },
  { "tachyon", "urxvt -e sh -c 'tachyon ; bash'" },
  { "easywin", "urxvt -e sh -c 'easywin -h ; bash'" },
  { "letmein", "urxvt -e sh -c 'letmein -h ; bash'" },
  { "netdork", "urxvt -e sh -c 'netdork -h ; bash'" },
  { "poriluk", "urxvt -e sh -c 'poriluk -h ; bash'" },
  { "seitan", "urxvt -e sh -c 'seitan -h ; bash'" },
  { "taipan", "urxvt -e sh -c 'taipan ; bash'" },
  { "takeover", "urxvt -e sh -c 'takeover ; bash'" },
  { "testssl", "urxvt -e sh -c 'testssl ; bash'" },
  { "tfsec", "urxvt -e sh -c 'tfsec -h ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "thc-smartbrute", "urxvt -e sh -c 'thc-smartbrute -h ; bash'" },
  { "thcrut", "urxvt -e sh -c 'thcrut -h ; bash'" },
  { "tiger", "urxvt -e sh -c 'tiger -h ; bash'" },
  { "tlsenum", "urxvt -e sh -c 'tlsenum -h ; bash'" },
  { "tlspretense", "urxvt -e sh -c 'tlspretense ; bash'" },
  { "tlssled", "urxvt -e sh -c 'tlssled -h ; bash'" },
  { "topera", "urxvt -e sh -c 'topera -h ; bash'" },
  { "torcrawl", "urxvt -e sh -c 'torcrawl -h ; bash'" },
  { "traxss", "urxvt -e sh -c 'traxss -h ; bash'" },
  { "trivy", "urxvt -e sh -c 'trivy -h ; bash'" },
  { "typo-enumerator", "urxvt -e sh -c 'typo-enumerator ; bash'" },
  { "udork", "urxvt -e sh -c 'udork -h ; bash'" },
  { "udsim", "urxvt -e sh -c 'udsim -h ; bash'" },
  { "umap", "urxvt -e sh -c 'umap -h ; bash'" },
  { "fantaip", "urxvt -e sh -c 'fantaip ; bash'" },
  { "unibrow", "urxvt -e sh -c 'unibrow -h ; bash'" },
  { "unicfgtst", "urxvt -e sh -c 'unicfgtst ; bash'" },
  { "unicornscan", "urxvt -e sh -c 'unicornscan -h ; bash'" },
  { "us", "urxvt -e sh -c 'us -h ; bash'" },
  { "uniscan", "urxvt -e sh -c 'uniscan --help ; bash'" },
  { "unix-privsc-check", "urxvt -e sh -c 'unix-privsc-check ; bash'" },
  { "uptux", "urxvt -e sh -c 'uptux -h ; bash'" },
  { "urldigger", "urxvt -e sh -c 'urldigger -h ; bash'" },
  { "uw-loveimap", "urxvt -e sh -c 'uw-loveimap -h ; bash'" },
  { "uw-zone", "urxvt -e sh -c 'uw-zone -h ; bash'" },
  { "v3n0m", "urxvt -e sh -c 'v3n0m -h ; bash'" },
  { "vais", "urxvt -e sh -c 'vais -h ; bash'" },
  { "vane", "urxvt -e sh -c 'vane -h ; bash'" },
  { "vanguard", "urxvt -e sh -c 'vanguard -h ; bash'" },
  { "vault-scanner", "urxvt -e sh -c 'vault-scanner ; bash'" },
  { "vbrute", "urxvt -e sh -c 'vbrute -h ; bash'" },
  { "vbscan", "urxvt -e sh -c 'vbscan ; bash'" },
  { "vcsmap", "urxvt -e sh -c 'vcsmap ; bash'" },
  { "vhostscan", "urxvt -e sh -c 'vhostscan -h ; bash'" },
  { "videosnarf", "urxvt -e sh -c 'videosnarf ; bash'" },
  { "visql", "urxvt -e sh -c 'visql -h ; bash'" },
  { "vsaudit", "urxvt -e sh -c 'vsaudit ; bash'" },
  { "vscan", "urxvt -e sh -c 'vscan ; bash'" },
  { "vsvbp", "urxvt -e sh -c 'vsvbp ; bash'" },
  { "vulmap", "urxvt -e sh -c 'vulmap -h ; bash'" },
  { "vulnerabilities-spider", "urxvt -e sh -c 'vulnerabilities-spider ; bash'" },
  { "vulnx", "urxvt -e sh -c 'vulnx -h ; bash'" },
  { "vulnx.desktop", "urxvt -e sh -c 'vulnx.desktop ; bash'" },
  { "vuls", "urxvt -e sh -c 'vuls ; bash'" },
  { "w13scan", "urxvt -e sh -c 'w13scan -h ; bash'" },
  { "w3af", "urxvt -e sh -c 'w3af -h ; bash'" },
  { "w3af-gui", "urxvt -e sh -c 'w3af-gui ; bash'" },
  { "wafw00f", "urxvt -e sh -c 'wafw00f -h ; bash'" },
  { "waldo", "urxvt -e sh -c 'waldo -h ; bash'" },
  { "wapiti", "urxvt -e sh -c 'wapiti -h ; bash'" },
  { "wapiti-getcookie", "urxvt -e sh -c 'wapiti-getcookie -h ; bash'" },
  { "wascan", "urxvt -e sh -c 'wascan -h ; bash'" },
  { "webanalyze", "urxvt -e sh -c 'webanalyze ; bash'" },
  { "webborer", "urxvt -e sh -c 'webborer ; bash'" },
  { "webenum", "urxvt -e sh -c 'webenum -h ; bash'" },
  { "webhunter", "urxvt -e sh -c 'webhunter ; bash'" },
  { "webpwn3r", "urxvt -e sh -c 'webpwn3r -h ; bash'" },
  { "webrute", "urxvt -e sh -c 'webrute -help ; bash'" },
  { "webscarab", "urxvt -e sh -c 'webscarab ; bash'" },
  { "webtech", "urxvt -e sh -c 'webtech -h ; bash'" },
  { "weirdaal", "urxvt -e sh -c 'weirdaal -h ; bash'" },
  { "whatwaf", "urxvt -e sh -c 'whatwaf -h ; bash'" },
  { "whitewidow", "urxvt -e sh -c 'whitewidow -h ; bash'" },
  { "wifiscanmap", "urxvt -e sh -c 'wifiscanmap -h ; bash'" },
  { "wig", "urxvt -e sh -c 'wig -h ; bash'" },
  { "witchxtool", "urxvt -e sh -c 'witchxtool -h ; bash'" },
  { "wnmap", "urxvt -e sh -c 'wnmap -h ; bash'" },
  { "wolper-mcp", "urxvt -e sh -c 'wolper-mcp -h ; bash'" },
  { "wolperdrone", "urxvt -e sh -c 'wolperdrone -h ; bash'" },
  { "wolpertinger", "urxvt -e sh -c 'wolpertinger -h ; bash'" },
  { "wordpresscan", "urxvt -e sh -c 'wordpresscan -h ; bash'" },
  { "wpintel", "urxvt -e sh -c 'wpintel ; bash'" },
  { "xcname", "urxvt -e sh -c 'xcname -h ; bash'" },
  { "xpire-crossdomain-scanner", "urxvt -e sh -c 'xpire-crossdomain-scanner -h ; bash'" },
  { "xsrfprobe", "urxvt -e sh -c 'xsrfprobe -h ; bash'" },
  { "xss-freak", "urxvt -e sh -c 'xss-freak -h ; bash'" },
  { "xsscon", "urxvt -e sh -c 'xsscon -h ; bash'" },
  { "xsss", "urxvt -e sh -c 'xsss ; bash'" },
  { "xssscan", "urxvt -e sh -c 'xssscan -h ; bash'" },
  { "xsstracer", "urxvt -e sh -c 'xsstracer ; bash'" },
  { "xsstrike", "urxvt -e sh -c 'xsstrike ; bash'" },
  { "xssya", "urxvt -e sh -c 'xssya -h ; bash'" },
  { "xwaf", "urxvt -e sh -c 'xwaf -h ; bash'" },
  { "yaaf", "urxvt -e sh -c 'yaaf -h ; bash'" },
  { "yasat", "urxvt -e sh -c 'yasat -h ; bash'" },
  { "yasuo", "urxvt -e sh -c 'yasuo -h ; bash'" },
  { "yawast", "urxvt -e sh -c 'yawast -h ; bash'" },
  { "ycrawler", "urxvt -e sh -c 'ycrawler -h ; bash'" },
  { "yersinia", "urxvt -e sh -c 'yersinia --help ; bash'" },
  { "zackattack", "urxvt -e sh -c 'zackattack -h ; bash'" },
  { "zeus", "urxvt -e sh -c 'zeus -h ; bash'" },
  { "zblacklist", "urxvt -e sh -c 'zblacklist ; bash'" },
  { "zmap", "urxvt -e sh -c 'zmap -h ; bash'" },
  { "ztee", "urxvt -e sh -c 'ztee ; bash'" },
  { "zblacklist", "urxvt -e sh -c 'zblacklist ; bash'" },
  { "zmap", "urxvt -e sh -c 'zmap -h ; bash'" },
  { "ztee", "urxvt -e sh -c 'ztee ; bash'" },
}

scannersmenu = {
  { "nettacker", "urxvt -e sh -c 'nettacker -h ; bash'" },
}

sniffermenu = {
  { "androidsniffer", "urxvt -e sh -c 'androidsniffer -h ; bash'" },
  { "apacket", "urxvt -e sh -c 'apacket ; bash'" },
  { "sapacket", "urxvt -e sh -c 'sapacket ; bash'" },
  { "argus-extip", "urxvt -e sh -c 'argus-extip ; bash'" },
  { "argus-lsof", "urxvt -e sh -c 'argus-lsof ; bash'" },
  { "argus-snmp", "urxvt -e sh -c 'argus-snmp ; bash'" },
  { "argus-vmstat", "urxvt -e sh -c 'argus-vmstat ; bash'" },
  { "argusbug", "urxvt -e sh -c 'argusbug ; bash'" },
  { "argusclientbug", "urxvt -e sh -c 'argusclientbug ; bash'" },
  { "ra", "urxvt -e sh -c 'ra -h ; bash'" },
  { "racluster", "urxvt -e sh -c 'racluster -h ; bash'" },
  { "raconvert", "urxvt -e sh -c 'raconvert -h ; bash'" },
  { "racount", "urxvt -e sh -c 'racount -h ; bash'" },
  { "radark", "urxvt -e sh -c 'radark -h ; bash'" },
  { "radecode", "urxvt -e sh -c 'radecode ; bash'" },
  { "radium", "urxvt -e sh -c 'radium -h ; bash'" },
  { "radump", "urxvt -e sh -c 'radump ; bash'" },
  { "raevent", "urxvt -e sh -c 'raevent -h ; bash'" },
  { "rafilteraddr", "urxvt -e sh -c 'rafilteraddr ; bash'" },
  { "ragraph", "urxvt -e sh -c 'ragraph ; bash'" },
  { "ragrep", "urxvt -e sh -c 'ragrep ; bash'" },
  { "rahisto", "urxvt -e sh -c 'rahisto ; bash'" },
  { "rahosts", "urxvt -e sh -c 'rahosts ; bash'" },
  { "ralabel", "urxvt -e sh -c 'ralabel ; bash'" },
  { "ranonymize", "urxvt -e sh -c 'ranonymize ; bash'" },
  { "rapath", "urxvt -e sh -c 'rapath ; bash'" },
  { "rapolicy", "urxvt -e sh -c 'rapolicy ; bash'" },
  { "raports", "urxvt -e sh -c 'raports ; bash'" },
  { "rarpwatch", "urxvt -e sh -c 'rarpwatch ; bash'" },
  { "raservices", "urxvt -e sh -c 'raservices ; bash'" },
  { "rasort", "urxvt -e sh -c 'rasort -h ; bash'" },
  { "rastream", "urxvt -e sh -c 'rastream -h ; bash'" },
  { "rastrip", "urxvt -e sh -c 'rastrip -h ; bash'" },
  { "ratimerange", "urxvt -e sh -c 'ratimerange ; bash'" },
  { "ratop", "urxvt -e sh -c 'ratop ; bash'" },
  { "rauserdata", "urxvt -e sh -c 'rauserdata ; bash'" },
  { "bettercap", "urxvt -e sh -c 'bettercap -h ; bash'" },
  { "bittwist", "urxvt -e sh -c 'bittwist -h ; bash'" },
  { "bittwiste", "urxvt -e sh -c 'bittwiste -h ; bash'" },
  { "bmc-tools", "urxvt -e sh -c 'bmc-tools -h ; bash'" },
  { "boop", "urxvt -e sh -c 'boop -h ; bash'" },
  { "capfuzz", "urxvt -e sh -c 'capfuzz -h ; bash'" },
  { "captipper", "urxvt -e sh -c 'captipper ; bash'" },
  { "chaosreader", "urxvt -e sh -c 'chaosreader -h ; bash'" },
  { "cottontail", "urxvt -e sh -c 'cottontail -h ; bash'" },
  { "creak", "urxvt -e sh -c 'creak -h ; bash'" },
  { "darkstat", "urxvt -e sh -c 'darkstat -h ; bash'" },
  { "driftnet", "urxvt -e sh -c 'driftnet -h ; bash'" },
  { "dnsspoof", "urxvt -e sh -c 'dnsspoof -h ; bash'" },
  { "dsniff", "urxvt -e sh -c 'dsniff -h ; bash'" },
  { "filesnarf", "urxvt -e sh -c 'filesnarf -h ; bash'" },
  { "macof", "urxvt -e sh -c 'macof -h ; bash'" },
  { "mailsnarf", "urxvt -e sh -c 'mailsnarf -h ; bash'" },
  { "msgsnarf", "urxvt -e sh -c 'msgsnarf -h ; bash'" },
  { "tcpkill", "urxvt -e sh -c 'tcpkill -h ; bash'" },
  { "tcpnice", "urxvt -e sh -c 'tcpnice -h ; bash'" },
  { "urlsnarf", "urxvt -e sh -c 'urlsnarf -h ; bash'" },
  { "webmitm", "urxvt -e sh -c 'webmitm -h ; bash'" },
  { "dnsspoof", "urxvt -e sh -c 'dnsspoof -h ; bash'" },
  { "dsniff", "urxvt -e sh -c 'dsniff -h ; bash'" },
  { "filesnarf", "urxvt -e sh -c 'filesnarf -h ; bash'" },
  { "macof", "urxvt -e sh -c 'macof -h ; bash'" },
  { "mailsnarf", "urxvt -e sh -c 'mailsnarf -h ; bash'" },
  { "msgsnarf", "urxvt -e sh -c 'msgsnarf -h ; bash'" },
  { "tcpkill", "urxvt -e sh -c 'tcpkill -h ; bash'" },
  { "tcpnice", "urxvt -e sh -c 'tcpnice -h ; bash'" },
  { "urlsnarf", "urxvt -e sh -c 'urlsnarf -h ; bash'" },
  { "webmitm", "urxvt -e sh -c 'webmitm -h ; bash'" },
  { "eigrp", "urxvt -e sh -c 'eigrp -h ; bash'" },
  { "espionage", "urxvt -e sh -c 'espionage -h ; bash'" },
  { "etherape", "urxvt -e sh -c 'etherape ; bash'" },
  { "ettercap", "urxvt -e sh -c 'ettercap -h ; bash'" },
  { "etterfilter", "urxvt -e sh -c 'etterfilter -h ; bash'" },
  { "etterlog", "urxvt -e sh -c 'etterlog -h ; bash'" },
  { "ettercap", "urxvt -e sh -c 'ettercap -h ; bash'" },
  { "etterfilter", "urxvt -e sh -c 'etterfilter -h ; bash'" },
  { "etterlog", "urxvt -e sh -c 'etterlog -h ; bash'" },
  { "evil-ssdp", "urxvt -e sh -c 'evil-ssdp -h ; bash'" },
  { "fakenet", "urxvt -e sh -c 'fakenet -h ; bash'" },
  { "fastnetmon", "urxvt -e sh -c 'fastnetmon --help ; bash'" },
  { "fastnetmon-client", "urxvt -e sh -c 'fastnetmon-client ; bash'" },
  { "firstorder", "urxvt -e sh -c 'firstorder -h ; bash'" },
  { "fl0p", "urxvt -e sh -c 'fl0p -h ; bash'" },
  { "flowinspect", "urxvt -e sh -c 'flowinspect -h ; bash'" },
  { "fs-nyarl", "urxvt -e sh -c 'fs-nyarl -h ; bash'" },
  { "chaosreader0.94", "urxvt -e sh -c 'chaosreader0.94 ; bash'" },
  { "haka", "urxvt -e sh -c 'haka -h ; bash'" },
  { "hakabench", "urxvt -e sh -c 'hakabench -h ; bash'" },
  { "hakactl", "urxvt -e sh -c 'hakactl -h ; bash'" },
  { "hakapcap", "urxvt -e sh -c 'hakapcap -h ; bash'" },
  { "hcxdumptool", "urxvt -e sh -c 'hcxdumptool -h ; bash'" },
  { "hcxpioff", "urxvt -e sh -c 'hcxpioff -h ; bash'" },
  { "hcxdumptool", "urxvt -e sh -c 'hcxdumptool -h ; bash'" },
  { "hcxpioff", "urxvt -e sh -c 'hcxpioff -h ; bash'" },
  { "hdmi-sniff", "urxvt -e sh -c 'hdmi-sniff -h ; bash'" },
  { "hex2raw", "urxvt -e sh -c 'hex2raw -h ; bash'" },
  { "hexinject", "urxvt -e sh -c 'hexinject -h ; bash'" },
  { "prettypacket", "urxvt -e sh -c 'prettypacket -h ; bash'" },
  { "hoover", "urxvt -e sh -c 'hoover -h ; bash'" },
  { "httpry", "urxvt -e sh -c 'httpry -h ; bash'" },
  { "hubbit-sniffer", "urxvt -e sh -c 'hubbit-sniffer -h ; bash'" },
  { "hungry-interceptor", "urxvt -e sh -c 'hungry-interceptor ; bash'" },
  { "issniff", "urxvt -e sh -c 'issniff ; bash'" },
  { "juncli", "urxvt -e sh -c 'juncli ; bash'" },
  { "junkie", "urxvt -e sh -c 'junkie -h ; bash'" },
  { "katsnoop", "urxvt -e sh -c 'katsnoop -h ; bash'" },
  { "kismet", "urxvt -e sh -c 'kismet -h ; bash'" },
  { "kismet_discovery", "urxvt -e sh -c 'kismet_discovery ; bash'" },
  { "kismet_server", "urxvt -e sh -c 'kismet_server -h ; bash'" },
  { "kismetdb_clean", "urxvt -e sh -c 'kismetdb_clean ; bash'" },
  { "kismetdb_dump_devices", "urxvt -e sh -c 'kismetdb_dump_devices ; bash'" },
  { "kismetdb_statistics", "urxvt -e sh -c 'kismetdb_statistics ; bash'" },
  { "kismetdb_strip_packets", "urxvt -e sh -c 'kismetdb_strip_packets ; bash'" },
  { "kismetdb_to_gpx", "urxvt -e sh -c 'kismetdb_to_gpx ; bash'" },
  { "kismetdb_to_kml", "urxvt -e sh -c 'kismetdb_to_kml ; bash'" },
  { "kismetdb_to_pcap", "urxvt -e sh -c 'kismetdb_to_pcap ; bash'" },
  { "kismetdb_to_wiglecsv", "urxvt -e sh -c 'kismetdb_to_wiglecsv ; bash'" },
  { "kismet", "urxvt -e sh -c 'kismet -h ; bash'" },
  { "kismet_discovery", "urxvt -e sh -c 'kismet_discovery ; bash'" },
  { "kismet_server", "urxvt -e sh -c 'kismet_server -h ; bash'" },
  { "kismetdb_clean", "urxvt -e sh -c 'kismetdb_clean ; bash'" },
  { "kismetdb_dump_devices", "urxvt -e sh -c 'kismetdb_dump_devices ; bash'" },
  { "kismetdb_statistics", "urxvt -e sh -c 'kismetdb_statistics ; bash'" },
  { "kismetdb_strip_packets", "urxvt -e sh -c 'kismetdb_strip_packets ; bash'" },
  { "kismetdb_to_gpx", "urxvt -e sh -c 'kismetdb_to_gpx ; bash'" },
  { "kismetdb_to_kml", "urxvt -e sh -c 'kismetdb_to_kml ; bash'" },
  { "kismetdb_to_pcap", "urxvt -e sh -c 'kismetdb_to_pcap ; bash'" },
  { "kismetdb_to_wiglecsv", "urxvt -e sh -c 'kismetdb_to_wiglecsv ; bash'" },
  { "maltrail-sensor", "urxvt -e sh -c 'maltrail-sensor -h ; bash'" },
  { "maltrail-server", "urxvt -e sh -c 'maltrail-server -h ; bash'" },
  { "mfsniffer", "urxvt -e sh -c 'mfsniffer -h ; bash'" },
  { "mitm-relay", "urxvt -e sh -c 'mitm-relay -h ; bash'" },
  { "mitmap", "urxvt -e sh -c 'mitmap -h ; bash'" },
  { "mitmap-old", "urxvt -e sh -c 'mitmap-old -h ; bash'" },
  { "mitmer", "urxvt -e sh -c 'mitmer -h ; bash'" },
  { "quantuminject", "urxvt -e sh -c 'quantuminject -h ; bash'" },
  { "mylg", "urxvt -e sh -c 'mylg help ; bash'" },
  { "net-creds", "urxvt -e sh -c 'net-creds -h ; bash'" },
  { "astraceroute", "urxvt -e sh -c 'astraceroute ; bash'" },
  { "bpfc", "urxvt -e sh -c 'bpfc ; bash'" },
  { "curvetun", "urxvt -e sh -c 'curvetun ; bash'" },
  { "flowtop", "urxvt -e sh -c 'flowtop -h ; bash'" },
  { "mausezahn", "urxvt -e sh -c 'mausezahn ; bash'" },
  { "netsniff-ng", "urxvt -e sh -c 'netsniff-ng -h ; bash'" },
  { "trafgen", "urxvt -e sh -c 'trafgen ; bash'" },
  { "astraceroute", "urxvt -e sh -c 'astraceroute ; bash'" },
  { "bpfc", "urxvt -e sh -c 'bpfc ; bash'" },
  { "curvetun", "urxvt -e sh -c 'curvetun ; bash'" },
  { "flowtop", "urxvt -e sh -c 'flowtop -h ; bash'" },
  { "mausezahn", "urxvt -e sh -c 'mausezahn ; bash'" },
  { "netsniff-ng", "urxvt -e sh -c 'netsniff-ng -h ; bash'" },
  { "trafgen", "urxvt -e sh -c 'trafgen ; bash'" },
  { "networkminer", "urxvt -e sh -c 'networkminer ; bash'" },
  { "nsntrace", "urxvt -e sh -c 'nsntrace -h ; bash'" },
  { "ofp-sniffer", "urxvt -e sh -c 'ofp-sniffer -h ; bash'" },
  { "drone", "urxvt -e sh -c 'drone ; bash'" },
  { "ostinato", "urxvt -e sh -c 'ostinato -h ; bash'" },
  { "p0f", "urxvt -e sh -c 'p0f -h ; bash'" },
  { "p0f-client", "urxvt -e sh -c 'p0f-client -h ; bash'" },
  { "p0f-sendsyn", "urxvt -e sh -c 'p0f-sendsyn -h ; bash'" },
  { "p0f-sendsyn6", "urxvt -e sh -c 'p0f-sendsyn6 ; bash'" },
  { "p0f", "urxvt -e sh -c 'p0f -h ; bash'" },
  { "p0f-client", "urxvt -e sh -c 'p0f-client -h ; bash'" },
  { "p0f-sendsyn", "urxvt -e sh -c 'p0f-sendsyn -h ; bash'" },
  { "p0f-sendsyn6", "urxvt -e sh -c 'p0f-sendsyn6 ; bash'" },
  { "passivedns", "urxvt -e sh -c 'passivedns -h ; bash'" },
  { "pcapteller", "urxvt -e sh -c 'pcapteller ; bash'" },
  { "PHoss", "urxvt -e sh -c 'PHoss -h ; bash'" },
  { "nfacctd", "urxvt -e sh -c 'nfacctd -h ; bash'" },
  { "pmacct", "urxvt -e sh -c 'pmacct -h ; bash'" },
  { "pmacctd", "urxvt -e sh -c 'pmacctd -h ; bash'" },
  { "pmbgpd", "urxvt -e sh -c 'pmbgpd -h ; bash'" },
  { "pmbmpd", "urxvt -e sh -c 'pmbmpd -h ; bash'" },
  { "pmtelemetryd", "urxvt -e sh -c 'pmtelemetryd -h ; bash'" },
  { "sfacctd", "urxvt -e sh -c 'sfacctd -h ; bash'" },
  { "proxenet", "urxvt -e sh -c 'proxenet -h ; bash'" },
  { "proxenet-control-cli", "urxvt -e sh -c 'proxenet-control-cli ; bash'" },
  { "proxenet-control-web", "urxvt -e sh -c 'proxenet-control-web ; bash'" },
  { "pth-net", "urxvt -e sh -c 'pth-net -h ; bash'" },
  { "pth-rpcclient", "urxvt -e sh -c 'pth-rpcclient -h ; bash'" },
  { "pth-smbclient", "urxvt -e sh -c 'pth-smbclient -h ; bash'" },
  { "pth-smbget", "urxvt -e sh -c 'pth-smbget -h ; bash'" },
  { "pth-wmic", "urxvt -e sh -c 'pth-wmic -h ; bash'" },
  { "pth-wmis", "urxvt -e sh -c 'pth-wmis -h ; bash'" },
  { "net", "urxvt -e sh -c 'net ; bash'" },
  { "rpcclient", "urxvt -e sh -c 'rpcclient ; bash'" },
  { "smbclient", "urxvt -e sh -c 'smbclient ; bash'" },
  { "smbget", "urxvt -e sh -c 'smbget ; bash'" },
  { "wmic", "urxvt -e sh -c 'wmic ; bash'" },
  { "wmis", "urxvt -e sh -c 'wmis ; bash'" },
  { "pyrdp-clonecert", "urxvt -e sh -c 'pyrdp-clonecert -h ; bash'" },
  { "pyrdp-convert", "urxvt -e sh -c 'pyrdp-convert ; bash'" },
  { "pyrdp-mitm", "urxvt -e sh -c 'pyrdp-mitm -h ; bash'" },
  { "pytacle", "urxvt -e sh -c 'pytacle ; bash'" },
  { "pythem", "urxvt -e sh -c 'pythem ; bash'" },
  { "rvi-capture", "urxvt -e sh -c 'rvi-capture -h ; bash'" },
  { "sessionlist", "urxvt -e sh -c 'sessionlist ; bash'" },
  { "seth", "urxvt -e sh -c 'seth -h ; bash'" },
  { "seth-clone-cert", "urxvt -e sh -c 'seth-clone-cert ; bash'" },
  { "sipffer", "urxvt -e sh -c 'sipffer -h ; bash'" },
  { "snapception", "urxvt -e sh -c 'snapception --help ; bash'" },
  { "probequest", "urxvt -e sh -c 'probequest ; bash'" },
  { "sniffglue", "urxvt -e sh -c 'sniffglue -h ; bash'" },
  { "sj-commit-results", "urxvt -e sh -c 'sj-commit-results -h ; bash'" },
  { "sj-iptcpopt-probe", "urxvt -e sh -c 'sj-iptcpopt-probe -h ; bash'" },
  { "sniffjoke", "urxvt -e sh -c 'sniffjoke -h ; bash'" },
  { "sniffjoke-autotest", "urxvt -e sh -c 'sniffjoke-autotest -h ; bash'" },
  { "sniffjokectl", "urxvt -e sh -c 'sniffjokectl -h ; bash'" },
  { "ssl-phuck3r", "urxvt -e sh -c 'ssl-phuck3r -h ; bash'" },
  { "ssldump", "urxvt -e sh -c 'ssldump -h ; bash'" },
  { "sslsniff", "urxvt -e sh -c 'sslsniff ; bash'" },
  { "mitm_listener", "urxvt -e sh -c 'mitm_listener ; bash'" },
  { "stenographer", "urxvt -e sh -c 'stenographer -h ; bash'" },
  { "easywin", "urxvt -e sh -c 'easywin -h ; bash'" },
  { "letmein", "urxvt -e sh -c 'letmein -h ; bash'" },
  { "netdork", "urxvt -e sh -c 'netdork -h ; bash'" },
  { "poriluk", "urxvt -e sh -c 'poriluk -h ; bash'" },
  { "seitan", "urxvt -e sh -c 'seitan -h ; bash'" },
  { "tcpdump", "urxvt -e sh -c 'tcpdump -h ; bash'" },
  { "tcpflow", "urxvt -e sh -c 'tcpflow -h ; bash'" },
  { "tcpick", "urxvt -e sh -c 'tcpick --help ; bash'" },
  { "fingerprintls", "urxvt -e sh -c 'fingerprintls -h ; bash'" },
  { "fingerprintout", "urxvt -e sh -c 'fingerprintout -h ; bash'" },
  { "parselog", "urxvt -e sh -c 'parselog ; bash'" },
  { "wifi-monitor", "urxvt -e sh -c 'wifi-monitor -h ; bash'" },
  { "captiveflask", "urxvt -e sh -c 'captiveflask ; bash'" },
  { "sslstrip3", "urxvt -e sh -c 'sslstrip3 ; bash'" },
  { "wifi-pumpkin", "urxvt -e sh -c 'wifi-pumpkin ; bash'" },
  { "wireless-ids", "urxvt -e sh -c 'wireless-ids -h ; bash'" },
  { "capinfos", "urxvt -e sh -c 'capinfos -h ; bash'" },
  { "captype", "urxvt -e sh -c 'captype ; bash'" },
  { "dumpcap", "urxvt -e sh -c 'dumpcap ; bash'" },
  { "editcap", "urxvt -e sh -c 'editcap ; bash'" },
  { "idl2wrs", "urxvt -e sh -c 'idl2wrs ; bash'" },
  { "mergecap", "urxvt -e sh -c 'mergecap -h ; bash'" },
  { "randpkt", "urxvt -e sh -c 'randpkt ; bash'" },
  { "reordercap", "urxvt -e sh -c 'reordercap ; bash'" },
  { "sharkd", "urxvt -e sh -c 'sharkd ; bash'" },
  { "text2pcap", "urxvt -e sh -c 'text2pcap ; bash'" },
  { "capinfos", "urxvt -e sh -c 'capinfos -h ; bash'" },
  { "captype", "urxvt -e sh -c 'captype ; bash'" },
  { "dumpcap", "urxvt -e sh -c 'dumpcap ; bash'" },
  { "editcap", "urxvt -e sh -c 'editcap ; bash'" },
  { "idl2wrs", "urxvt -e sh -c 'idl2wrs ; bash'" },
  { "mergecap", "urxvt -e sh -c 'mergecap -h ; bash'" },
  { "randpkt", "urxvt -e sh -c 'randpkt ; bash'" },
  { "reordercap", "urxvt -e sh -c 'reordercap ; bash'" },
  { "sharkd", "urxvt -e sh -c 'sharkd ; bash'" },
  { "text2pcap", "urxvt -e sh -c 'text2pcap ; bash'" },
  { "xcavator", "urxvt -e sh -c 'xcavator -h ; bash'" },
  { "bifcl", "urxvt -e sh -c 'bifcl ; bash'" },
  { "binpac", "urxvt -e sh -c 'binpac ; bash'" },
  { "bro", "urxvt -e sh -c 'bro -h ; bash'" },
  { "bro-cut", "urxvt -e sh -c 'bro-cut ; bash'" },
  { "broctl", "urxvt -e sh -c 'broctl ; bash'" },
  { "broker-benchmark", "urxvt -e sh -c 'broker-benchmark ; bash'" },
  { "broker-cluster-benchmark", "urxvt -e sh -c 'broker-cluster-benchmark ; bash'" },
  { "btest", "urxvt -e sh -c 'btest ; bash'" },
  { "btest-ask-update", "urxvt -e sh -c 'btest-ask-update ; bash'" },
  { "btest-bg-run", "urxvt -e sh -c 'btest-bg-run ; bash'" },
  { "btest-bg-run-helper", "urxvt -e sh -c 'btest-bg-run-helper ; bash'" },
  { "btest-bg-wait", "urxvt -e sh -c 'btest-bg-wait ; bash'" },
  { "btest-diff", "urxvt -e sh -c 'btest-diff ; bash'" },
  { "btest-diff-rst", "urxvt -e sh -c 'btest-diff-rst ; bash'" },
  { "btest-progress", "urxvt -e sh -c 'btest-progress ; bash'" },
  { "btest-rst-include", "urxvt -e sh -c 'btest-rst-include ; bash'" },
  { "btest-rst-pipe", "urxvt -e sh -c 'btest-rst-pipe ; bash'" },
  { "btest-setsid", "urxvt -e sh -c 'btest-setsid ; bash'" },
  { "paraglob-test", "urxvt -e sh -c 'paraglob-test ; bash'" },
  { "trace-summary", "urxvt -e sh -c 'trace-summary ; bash'" },
  { "zeek", "urxvt -e sh -c 'zeek ; bash'" },
  { "zeek-archiver", "urxvt -e sh -c 'zeek-archiver ; bash'" },
  { "zeek-cut", "urxvt -e sh -c 'zeek-cut ; bash'" },
  { "zeekctl", "urxvt -e sh -c 'zeekctl ; bash'" },
  { "zkg", "urxvt -e sh -c 'zkg ; bash'" },
  { "adtrace", "urxvt -e sh -c 'adtrace ; bash'" },
  { "rst", "urxvt -e sh -c 'rst ; bash'" },
  { "zizzania", "urxvt -e sh -c 'zizzania ; bash'" },
}

socialmenu = {
  { "anontwi", "urxvt -e sh -c 'anontwi -h ; bash'" },
  { "brute-force", "urxvt -e sh -c 'brute-force -h ; bash'" },
  { "buster", "urxvt -e sh -c 'buster -h ; bash'" },
  { "cardpwn", "urxvt -e sh -c 'cardpwn ; bash'" },
  { "chamlog", "urxvt -e sh -c 'chamlog -h ; bash'" },
  { "chamtool", "urxvt -e sh -c 'chamtool -h ; bash'" },
  { "citadel", "urxvt -e sh -c 'citadel -h ; bash'" },
  { "cr3dov3r", "urxvt -e sh -c 'cr3dov3r -h ; bash'" },
  { "credsniper", "urxvt -e sh -c 'credsniper -h ; bash'" },
  { "crosslinked", "urxvt -e sh -c 'crosslinked -h ; bash'" },
  { "crosslinked-pwd-gen", "urxvt -e sh -c 'crosslinked-pwd-gen ; bash'" },
  { "crosslinked-user-gen", "urxvt -e sh -c 'crosslinked-user-gen -h ; bash'" },
  { "domainhunter", "urxvt -e sh -c 'domainhunter -h ; bash'" },
  { "email2phonenumber", "urxvt -e sh -c 'email2phonenumber -h ; bash'" },
  { "evilginx", "urxvt -e sh -c 'evilginx -h ; bash'" },
  { "facebookosint", "urxvt -e sh -c 'facebookosint ; bash'" },
  { "fbi", "urxvt -e sh -c 'fbi -h ; bash'" },
  { "fbid", "urxvt -e sh -c 'fbid ; bash'" },
  { "fluxion", "urxvt -e sh -c 'fluxion ; bash'" },
  { "genisys-manager", "urxvt -e sh -c 'genisys-manager -h ; bash'" },
  { "genisys-scraper", "urxvt -e sh -c 'genisys-scraper -h ; bash'" },
  { "genisys-tsadder", "urxvt -e sh -c 'genisys-tsadder -h ; bash'" },
  { "gg-images", "urxvt -e sh -c 'gg-images ; bash'" },
  { "git-hound", "urxvt -e sh -c 'git-hound -h ; bash'" },
  { "github-dorks", "urxvt -e sh -c 'github-dorks -h ; bash'" },
  { "gitmails", "urxvt -e sh -c 'gitmails -h ; bash'" },
  { "gitrecon", "urxvt -e sh -c 'gitrecon -h ; bash'" },
  { "gloom", "urxvt -e sh -c 'gloom ; bash'" },
  { "h8mail", "urxvt -e sh -c 'h8mail -h ; bash'" },
  { "hemingway", "urxvt -e sh -c 'hemingway ; bash'" },
  { "hiddeneye", "urxvt -e sh -c 'hiddeneye ; bash'" },
  { "activate", "urxvt -e sh -c 'activate ; bash'" },
  { "chardetect", "urxvt -e sh -c 'chardetect ; bash'" },
  { "easy_install", "urxvt -e sh -c 'easy_install ; bash'" },
  { "easy_install-3.8", "urxvt -e sh -c 'easy_install-3.8 ; bash'" },
  { "futurize", "urxvt -e sh -c 'futurize ; bash'" },
  { "ngrok", "urxvt -e sh -c 'ngrok ; bash'" },
  { "pasteurize", "urxvt -e sh -c 'pasteurize ; bash'" },
  { "pip", "urxvt -e sh -c 'pip ; bash'" },
  { "pip3", "urxvt -e sh -c 'pip3 ; bash'" },
  { "pip3.8", "urxvt -e sh -c 'pip3.8 ; bash'" },
  { "pyngrok", "urxvt -e sh -c 'pyngrok ; bash'" },
  { "python", "urxvt -e sh -c 'python ; bash'" },
  { "python3", "urxvt -e sh -c 'python3 ; bash'" },
  { "ngrok", "urxvt -e sh -c 'ngrok ; bash'" },
  { "hiddeneye-legacy", "urxvt -e sh -c 'hiddeneye-legacy ; bash'" },
  { "activate", "urxvt -e sh -c 'activate ; bash'" },
  { "chardetect", "urxvt -e sh -c 'chardetect ; bash'" },
  { "easy_install", "urxvt -e sh -c 'easy_install ; bash'" },
  { "easy_install-3.8", "urxvt -e sh -c 'easy_install-3.8 ; bash'" },
  { "futurize", "urxvt -e sh -c 'futurize ; bash'" },
  { "ngrok", "urxvt -e sh -c 'ngrok ; bash'" },
  { "pasteurize", "urxvt -e sh -c 'pasteurize ; bash'" },
  { "pip", "urxvt -e sh -c 'pip ; bash'" },
  { "pip3", "urxvt -e sh -c 'pip3 ; bash'" },
  { "pip3.8", "urxvt -e sh -c 'pip3.8 ; bash'" },
  { "pyngrok", "urxvt -e sh -c 'pyngrok ; bash'" },
  { "python", "urxvt -e sh -c 'python ; bash'" },
  { "python3", "urxvt -e sh -c 'python3 ; bash'" },
  { "ngrok", "urxvt -e sh -c 'ngrok ; bash'" },
  { "inquisitor", "urxvt -e sh -c 'inquisitor -h ; bash'" },
  { "instagramosint", "urxvt -e sh -c 'instagramosint -h ; bash'" },
  { "jeopardize", "urxvt -e sh -c 'jeopardize -h ; bash'" },
  { "lazagne", "urxvt -e sh -c 'lazagne -h ; bash'" },
  { "linkedin2username", "urxvt -e sh -c 'linkedin2username -h ; bash'" },
  { "littlebrother", "urxvt -e sh -c 'littlebrother ; bash'" },
  { "muraena", "urxvt -e sh -c 'muraena -h ; bash'" },
  { "nexfil", "urxvt -e sh -c 'nexfil -h ; bash'" },
  { "omnibus", "urxvt -e sh -c 'omnibus ; bash'" },
  { "osi.ig", "urxvt -e sh -c 'osi.ig -h ; bash'" },
  { "osr-alias_generator", "urxvt -e sh -c 'osr-alias_generator -h ; bash'" },
  { "osr-checkfy", "urxvt -e sh -c 'osr-checkfy ; bash'" },
  { "osr-domainfy", "urxvt -e sh -c 'osr-domainfy -h ; bash'" },
  { "osr-mailfy", "urxvt -e sh -c 'osr-mailfy -h ; bash'" },
  { "osr-osrf", "urxvt -e sh -c 'osr-osrf ; bash'" },
  { "osr-osrframework-cli", "urxvt -e sh -c 'osr-osrframework-cli ; bash'" },
  { "osr-phonefy", "urxvt -e sh -c 'osr-phonefy -h ; bash'" },
  { "osr-searchfy", "urxvt -e sh -c 'osr-searchfy -h ; bash'" },
  { "osr-usufy", "urxvt -e sh -c 'osr-usufy -h ; bash'" },
  { "pepe", "urxvt -e sh -c 'pepe -h ; bash'" },
  { "phemail", "urxvt -e sh -c 'phemail -h ; bash'" },
  { "phoneinfoga", "urxvt -e sh -c 'phoneinfoga -h ; bash'" },
  { "phonia", "urxvt -e sh -c 'phonia -h ; bash'" },
  { "pown", "urxvt -e sh -c 'pown ; bash'" },
  { "pwned-search", "urxvt -e sh -c 'pwned-search ; bash'" },
  { "pwnedornot", "urxvt -e sh -c 'pwnedornot -h ; bash'" },
  { "qrljacker", "urxvt -e sh -c 'qrljacker -h ; bash'" },
  { "raven", "urxvt -e sh -c 'raven -h ; bash'" },
  { "scavenger", "urxvt -e sh -c 'scavenger -h ; bash'" },
  { "seeker", "urxvt -e sh -c 'seeker -h ; bash'" },
  { "sees", "urxvt -e sh -c 'sees -h ; bash'" },
  { "setoolkit", "urxvt -e sh -c 'setoolkit ; bash'" },
  { "sherlock", "urxvt -e sh -c 'sherlock -h ; bash'" },
  { "skiptracer", "urxvt -e sh -c 'skiptracer --help ; bash'" },
  { "slackpirate", "urxvt -e sh -c 'slackpirate --help ; bash'" },
  { "social-analyzer", "urxvt -e sh -c 'social-analyzer -h ; bash'" },
  { "social-vuln-scanner", "urxvt -e sh -c 'social-vuln-scanner -h ; bash'" },
  { "sooty", "urxvt -e sh -c 'sooty ; bash'" },
  { "spf", "urxvt -e sh -c 'spf -h ; bash'" },
  { "spf-report", "urxvt -e sh -c 'spf-report ; bash'" },
  { "spf-web", "urxvt -e sh -c 'spf-web ; bash'" },
  { "spoofcheck", "urxvt -e sh -c 'spoofcheck ; bash'" },
  { "tinfoleak", "urxvt -e sh -c 'tinfoleak ; bash'" },
  { "tinfoleak2", "urxvt -e sh -c 'tinfoleak2 -h ; bash'" },
  { "trape", "urxvt -e sh -c 'trape -h ; bash'" },
  { "tweets-analyzer", "urxvt -e sh -c 'tweets-analyzer -h ; bash'" },
  { "twint", "urxvt -e sh -c 'twint -h ; bash'" },
  { "ufb-scraper", "urxvt -e sh -c 'ufb-scraper ; bash'" },
  { "userrecon", "urxvt -e sh -c 'userrecon ; bash'" },
  { "weeman", "urxvt -e sh -c 'weeman ; bash'" },
  { "whatbreach", "urxvt -e sh -c 'whatbreach -h ; bash'" },
  { "whatsmyname", "urxvt -e sh -c 'whatsmyname -h ; bash'" },
  { "captiveflask", "urxvt -e sh -c 'captiveflask ; bash'" },
  { "sslstrip3", "urxvt -e sh -c 'sslstrip3 ; bash'" },
  { "wifi-pumpkin", "urxvt -e sh -c 'wifi-pumpkin ; bash'" },
}

spoofmenu = {
  { "ADMdnsfuckr", "urxvt -e sh -c 'ADMdnsfuckr ; bash'" },
  { "ADMkillDNS", "urxvt -e sh -c 'ADMkillDNS ; bash'" },
  { "ADMnOg00d", "urxvt -e sh -c 'ADMnOg00d ; bash'" },
  { "ADMsnOOfID", "urxvt -e sh -c 'ADMsnOOfID ; bash'" },
  { "ADMsniffID", "urxvt -e sh -c 'ADMsniffID ; bash'" },
  { "aranea", "urxvt -e sh -c 'aranea -h ; bash'" },
  { "arpoison", "urxvt -e sh -c 'arpoison -h ; bash'" },
  { "cisco-snmp-slap", "urxvt -e sh -c 'cisco-snmp-slap -h ; bash'" },
  { "dns-spoof", "urxvt -e sh -c 'dns-spoof -h ; bash'" },
  { "evil-ssdp", "urxvt -e sh -c 'evil-ssdp -h ; bash'" },
  { "fakedns", "urxvt -e sh -c 'fakedns ; bash'" },
  { "fakenetbiosdgm", "urxvt -e sh -c 'fakenetbiosdgm -h ; bash'" },
  { "fakenetbiosns", "urxvt -e sh -c 'fakenetbiosns -h ; bash'" },
  { "fs-nyarl", "urxvt -e sh -c 'fs-nyarl -h ; bash'" },
  { "chaosreader0.94", "urxvt -e sh -c 'chaosreader0.94 ; bash'" },
  { "habu.arp.ping", "urxvt -e sh -c 'habu.arp.ping ; bash'" },
  { "habu.arp.poison", "urxvt -e sh -c 'habu.arp.poison ; bash'" },
  { "habu.arp.sniff", "urxvt -e sh -c 'habu.arp.sniff ; bash'" },
  { "habu.asydns", "urxvt -e sh -c 'habu.asydns ; bash'" },
  { "habu.b64", "urxvt -e sh -c 'habu.b64 ; bash'" },
  { "habu.cert.clone", "urxvt -e sh -c 'habu.cert.clone ; bash'" },
  { "habu.cert.names", "urxvt -e sh -c 'habu.cert.names ; bash'" },
  { "habu.crack.luhn", "urxvt -e sh -c 'habu.crack.luhn ; bash'" },
  { "habu.crack.snmp", "urxvt -e sh -c 'habu.crack.snmp ; bash'" },
  { "habu.crypto.fernet", "urxvt -e sh -c 'habu.crypto.fernet ; bash'" },
  { "habu.crypto.gppref", "urxvt -e sh -c 'habu.crypto.gppref ; bash'" },
  { "habu.crypto.xor", "urxvt -e sh -c 'habu.crypto.xor ; bash'" },
  { "habu.data.enrich", "urxvt -e sh -c 'habu.data.enrich ; bash'" },
  { "habu.data.extract.domain", "urxvt -e sh -c 'habu.data.extract.domain ; bash'" },
  { "habu.data.extract.email", "urxvt -e sh -c 'habu.data.extract.email ; bash'" },
  { "habu.data.extract.fqdn", "urxvt -e sh -c 'habu.data.extract.fqdn ; bash'" },
  { "habu.data.extract.ipv4", "urxvt -e sh -c 'habu.data.extract.ipv4 ; bash'" },
  { "habu.data.filter", "urxvt -e sh -c 'habu.data.filter ; bash'" },
  { "habu.data.select", "urxvt -e sh -c 'habu.data.select ; bash'" },
  { "habu.dhcp.discover", "urxvt -e sh -c 'habu.dhcp.discover ; bash'" },
  { "habu.dhcp.starvation", "urxvt -e sh -c 'habu.dhcp.starvation ; bash'" },
  { "habu.dns.lookup.forward", "urxvt -e sh -c 'habu.dns.lookup.forward ; bash'" },
  { "habu.dns.lookup.reverse", "urxvt -e sh -c 'habu.dns.lookup.reverse ; bash'" },
  { "habu.eicar", "urxvt -e sh -c 'habu.eicar ; bash'" },
  { "habu.forkbomb", "urxvt -e sh -c 'habu.forkbomb ; bash'" },
  { "habu.fqdn.finder", "urxvt -e sh -c 'habu.fqdn.finder ; bash'" },
  { "habu.gateway.find", "urxvt -e sh -c 'habu.gateway.find ; bash'" },
  { "habu.host", "urxvt -e sh -c 'habu.host ; bash'" },
  { "habu.http.headers", "urxvt -e sh -c 'habu.http.headers ; bash'" },
  { "habu.http.options", "urxvt -e sh -c 'habu.http.options ; bash'" },
  { "habu.http.tech", "urxvt -e sh -c 'habu.http.tech ; bash'" },
  { "habu.icmp.ping", "urxvt -e sh -c 'habu.icmp.ping ; bash'" },
  { "habu.ip.asn", "urxvt -e sh -c 'habu.ip.asn ; bash'" },
  { "habu.ip.geolocation", "urxvt -e sh -c 'habu.ip.geolocation ; bash'" },
  { "habu.ip.internal", "urxvt -e sh -c 'habu.ip.internal ; bash'" },
  { "habu.ip.public", "urxvt -e sh -c 'habu.ip.public ; bash'" },
  { "habu.karma", "urxvt -e sh -c 'habu.karma ; bash'" },
  { "habu.karma.bulk", "urxvt -e sh -c 'habu.karma.bulk ; bash'" },
  { "habu.land", "urxvt -e sh -c 'habu.land ; bash'" },
  { "habu.nc", "urxvt -e sh -c 'habu.nc ; bash'" },
  { "habu.net.contest", "urxvt -e sh -c 'habu.net.contest ; bash'" },
  { "habu.net.interfaces", "urxvt -e sh -c 'habu.net.interfaces ; bash'" },
  { "habu.nmap.excluded", "urxvt -e sh -c 'habu.nmap.excluded ; bash'" },
  { "habu.nmap.open", "urxvt -e sh -c 'habu.nmap.open ; bash'" },
  { "habu.nmap.ports", "urxvt -e sh -c 'habu.nmap.ports ; bash'" },
  { "habu.protoscan", "urxvt -e sh -c 'habu.protoscan ; bash'" },
  { "habu.server.ftp", "urxvt -e sh -c 'habu.server.ftp ; bash'" },
  { "habu.tcp.flags", "urxvt -e sh -c 'habu.tcp.flags ; bash'" },
  { "habu.tcp.isn", "urxvt -e sh -c 'habu.tcp.isn ; bash'" },
  { "habu.tcp.scan", "urxvt -e sh -c 'habu.tcp.scan ; bash'" },
  { "habu.tcp.synflood", "urxvt -e sh -c 'habu.tcp.synflood ; bash'" },
  { "habu.traceroute", "urxvt -e sh -c 'habu.traceroute ; bash'" },
  { "habu.upgrade", "urxvt -e sh -c 'habu.upgrade ; bash'" },
  { "habu.usercheck", "urxvt -e sh -c 'habu.usercheck ; bash'" },
  { "habu.version", "urxvt -e sh -c 'habu.version ; bash'" },
  { "habu.vhosts", "urxvt -e sh -c 'habu.vhosts ; bash'" },
  { "habu.virustotal", "urxvt -e sh -c 'habu.virustotal ; bash'" },
  { "habu.web.report", "urxvt -e sh -c 'habu.web.report ; bash'" },
  { "habu.whois.domain", "urxvt -e sh -c 'habu.whois.domain ; bash'" },
  { "habu.whois.ip", "urxvt -e sh -c 'habu.whois.ip ; bash'" },
  { "hharp", "urxvt -e sh -c 'hharp -h ; bash'" },
  { "impulse", "urxvt -e sh -c 'impulse -h ; bash'" },
  { "inundator", "urxvt -e sh -c 'inundator ; bash'" },
  { "lans", "urxvt -e sh -c 'lans -h ; bash'" },
  { "lsrtunnel", "urxvt -e sh -c 'lsrtunnel ; bash'" },
  { "mitm", "urxvt -e sh -c 'mitm -h ; bash'" },
  { "mitm6", "urxvt -e sh -c 'mitm6 -h ; bash'" },
  { "mitmf", "urxvt -e sh -c 'mitmf -h ; bash'" },
  { "quantuminject", "urxvt -e sh -c 'quantuminject -h ; bash'" },
  { "motsa-dnsdetect", "urxvt -e sh -c 'motsa-dnsdetect -h ; bash'" },
  { "motsa-dnsinject", "urxvt -e sh -c 'motsa-dnsinject -h ; bash'" },
  { "multimac", "urxvt -e sh -c 'multimac -h ; bash'" },
  { "nbnspoof", "urxvt -e sh -c 'nbnspoof -h ; bash'" },
  { "netcommander", "urxvt -e sh -c 'netcommander ; bash'" },
  { "portspoof", "urxvt -e sh -c 'portspoof -h ; bash'" },
  { "pyminifakedns", "urxvt -e sh -c 'pyminifakedns ; bash'" },
  { "rbndr", "urxvt -e sh -c 'rbndr ; bash'" },
  { "responder", "urxvt -e sh -c 'responder -h ; bash'" },
  { "responder-dhcp", "urxvt -e sh -c 'responder-dhcp ; bash'" },
  { "responder-dhcp-auto", "urxvt -e sh -c 'responder-dhcp-auto ; bash'" },
  { "responder-findsqlsrv", "urxvt -e sh -c 'responder-findsqlsrv ; bash'" },
  { "responder-icmp-redirect", "urxvt -e sh -c 'responder-icmp-redirect ; bash'" },
  { "responder-multirelay", "urxvt -e sh -c 'responder-multirelay ; bash'" },
  { "responder-report", "urxvt -e sh -c 'responder-report ; bash'" },
  { "responder-runfinger", "urxvt -e sh -c 'responder-runfinger ; bash'" },
  { "responder-secretsdump", "urxvt -e sh -c 'responder-secretsdump ; bash'" },
  { "Runas.c", "urxvt -e sh -c 'Runas.c ; bash'" },
  { "Syssvc.c", "urxvt -e sh -c 'Syssvc.c ; bash'" },
  { "ridrelay", "urxvt -e sh -c 'ridrelay -h ; bash'" },
  { "sergio-proxy", "urxvt -e sh -c 'sergio-proxy -h ; bash'" },
  { "smikims-cage", "urxvt -e sh -c 'smikims-cage ; bash'" },
  { "smikims-sweep", "urxvt -e sh -c 'smikims-sweep ; bash'" },
  { "sylkie", "urxvt -e sh -c 'sylkie -h ; bash'" },
  { "synner", "urxvt -e sh -c 'synner -h ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "address6", "urxvt -e sh -c 'address6 ; bash'" },
  { "alive6", "urxvt -e sh -c 'alive6 ; bash'" },
  { "connect6", "urxvt -e sh -c 'connect6 ; bash'" },
  { "covert_send6", "urxvt -e sh -c 'covert_send6 ; bash'" },
  { "covert_send6d", "urxvt -e sh -c 'covert_send6d ; bash'" },
  { "denial6", "urxvt -e sh -c 'denial6 ; bash'" },
  { "detect-new-ip6", "urxvt -e sh -c 'detect-new-ip6 ; bash'" },
  { "detect_sniffer6", "urxvt -e sh -c 'detect_sniffer6 ; bash'" },
  { "dnsdict6", "urxvt -e sh -c 'dnsdict6 ; bash'" },
  { "dnsrevenum6", "urxvt -e sh -c 'dnsrevenum6 ; bash'" },
  { "dnssecwalk", "urxvt -e sh -c 'dnssecwalk ; bash'" },
  { "dos-new-ip6", "urxvt -e sh -c 'dos-new-ip6 ; bash'" },
  { "dump_dhcp6", "urxvt -e sh -c 'dump_dhcp6 -h ; bash'" },
  { "dump_router6", "urxvt -e sh -c 'dump_router6 ; bash'" },
  { "fake_advertise6", "urxvt -e sh -c 'fake_advertise6 ; bash'" },
  { "fake_dns6d", "urxvt -e sh -c 'fake_dns6d ; bash'" },
  { "fake_dnsupdate6", "urxvt -e sh -c 'fake_dnsupdate6 ; bash'" },
  { "fake_mipv6", "urxvt -e sh -c 'fake_mipv6 ; bash'" },
  { "fake_mld26", "urxvt -e sh -c 'fake_mld26 ; bash'" },
  { "fake_mld6", "urxvt -e sh -c 'fake_mld6 ; bash'" },
  { "fake_mldrouter6", "urxvt -e sh -c 'fake_mldrouter6 ; bash'" },
  { "fake_pim6", "urxvt -e sh -c 'fake_pim6 ; bash'" },
  { "fake_router26", "urxvt -e sh -c 'fake_router26 ; bash'" },
  { "fake_router6", "urxvt -e sh -c 'fake_router6 ; bash'" },
  { "fake_solicitate6", "urxvt -e sh -c 'fake_solicitate6 ; bash'" },
  { "firewall6", "urxvt -e sh -c 'firewall6 ; bash'" },
  { "flood_advertise6", "urxvt -e sh -c 'flood_advertise6 ; bash'" },
  { "flood_dhcpc6", "urxvt -e sh -c 'flood_dhcpc6 ; bash'" },
  { "flood_mld26", "urxvt -e sh -c 'flood_mld26 ; bash'" },
  { "flood_mld6", "urxvt -e sh -c 'flood_mld6 ; bash'" },
  { "flood_mldrouter6", "urxvt -e sh -c 'flood_mldrouter6 ; bash'" },
  { "flood_redir6", "urxvt -e sh -c 'flood_redir6 ; bash'" },
  { "flood_router26", "urxvt -e sh -c 'flood_router26 ; bash'" },
  { "flood_router6", "urxvt -e sh -c 'flood_router6 ; bash'" },
  { "flood_rs6", "urxvt -e sh -c 'flood_rs6 ; bash'" },
  { "flood_solicitate6", "urxvt -e sh -c 'flood_solicitate6 ; bash'" },
  { "flood_unreach6", "urxvt -e sh -c 'flood_unreach6 ; bash'" },
  { "four2six", "urxvt -e sh -c 'four2six ; bash'" },
  { "fragmentation6", "urxvt -e sh -c 'fragmentation6 ; bash'" },
  { "fragrouter6", "urxvt -e sh -c 'fragrouter6 ; bash'" },
  { "fuzz_dhcpc6", "urxvt -e sh -c 'fuzz_dhcpc6 ; bash'" },
  { "fuzz_ip6", "urxvt -e sh -c 'fuzz_ip6 ; bash'" },
  { "inject_alive6", "urxvt -e sh -c 'inject_alive6 ; bash'" },
  { "inverse_lookup6", "urxvt -e sh -c 'inverse_lookup6 ; bash'" },
  { "kill_router6", "urxvt -e sh -c 'kill_router6 ; bash'" },
  { "ndpexhaust26", "urxvt -e sh -c 'ndpexhaust26 ; bash'" },
  { "ndpexhaust6", "urxvt -e sh -c 'ndpexhaust6 ; bash'" },
  { "node_query6", "urxvt -e sh -c 'node_query6 ; bash'" },
  { "parasite6", "urxvt -e sh -c 'parasite6 ; bash'" },
  { "passive_discovery6", "urxvt -e sh -c 'passive_discovery6 ; bash'" },
  { "randicmp6", "urxvt -e sh -c 'randicmp6 ; bash'" },
  { "redir6", "urxvt -e sh -c 'redir6 ; bash'" },
  { "redirsniff6", "urxvt -e sh -c 'redirsniff6 ; bash'" },
  { "rsmurf6", "urxvt -e sh -c 'rsmurf6 ; bash'" },
  { "sendpees6", "urxvt -e sh -c 'sendpees6 ; bash'" },
  { "sendpeesmp6", "urxvt -e sh -c 'sendpeesmp6 ; bash'" },
  { "smurf6", "urxvt -e sh -c 'smurf6 ; bash'" },
  { "thcping6", "urxvt -e sh -c 'thcping6 ; bash'" },
  { "thcsyn6", "urxvt -e sh -c 'thcsyn6 ; bash'" },
  { "toobig6", "urxvt -e sh -c 'toobig6 ; bash'" },
  { "toobigsniff6", "urxvt -e sh -c 'toobigsniff6 ; bash'" },
  { "trace6", "urxvt -e sh -c 'trace6 ; bash'" },
  { "captiveflask", "urxvt -e sh -c 'captiveflask ; bash'" },
  { "sslstrip3", "urxvt -e sh -c 'sslstrip3 ; bash'" },
  { "wifi-pumpkin", "urxvt -e sh -c 'wifi-pumpkin ; bash'" },
  { "xcavator", "urxvt -e sh -c 'xcavator -h ; bash'" },
}

stegomenu = {
  { "matroschka", "urxvt -e sh -c 'matroschka -h ; bash'" },
  { "openpuff", "urxvt -e sh -c 'openpuff ; bash'" },
  { "openstego", "urxvt -e sh -c 'openstego -h ; bash'" },
  { "png-fix-IDAT-windowsize", "urxvt -e sh -c 'png-fix-IDAT-windowsize -h ; bash'" },
  { "pngcheck", "urxvt -e sh -c 'pngcheck -h ; bash'" },
  { "silenteye", "urxvt -e sh -c 'silenteye ; bash'" },
  { "stegcracker", "urxvt -e sh -c 'stegcracker -h ; bash'" },
  { "stegbreak", "urxvt -e sh -c 'stegbreak --help ; bash'" },
  { "stegcompare", "urxvt -e sh -c 'stegcompare --help ; bash'" },
  { "stegdeimage", "urxvt -e sh -c 'stegdeimage --help ; bash'" },
  { "stegdetect", "urxvt -e sh -c 'stegdetect --help ; bash'" },
  { "steghide", "urxvt -e sh -c 'steghide --help ; bash'" },
  { "stegolego", "urxvt -e sh -c 'stegolego ; bash'" },
  { "stegosip", "urxvt -e sh -c 'stegosip ; bash'" },
  { "stegoveritas", "urxvt -e sh -c 'stegoveritas -h ; bash'" },
  { "stegoveritas_hide_lsb", "urxvt -e sh -c 'stegoveritas_hide_lsb ; bash'" },
  { "stegsolve", "urxvt -e sh -c 'stegsolve ; bash'" },
  { "stepic", "urxvt -e sh -c 'stepic -h ; bash'" },
}

tunnelmenu = {
  { "chisel", "urxvt -e sh -c 'chisel ; bash'" },
  { "chownat", "urxvt -e sh -c 'chownat -h ; bash'" },
  { "corkscrew", "urxvt -e sh -c 'corkscrew ; bash'" },
  { "ctunnel", "urxvt -e sh -c 'ctunnel -h ; bash'" },
  { "dns2tcpc", "urxvt -e sh -c 'dns2tcpc ; bash'" },
  { "dns2tcpd", "urxvt -e sh -c 'dns2tcpd ; bash'" },
  { "firecat", "urxvt -e sh -c 'firecat ; bash'" },
  { "fraud-bridge", "urxvt -e sh -c 'fraud-bridge -h ; bash'" },
  { "htc", "urxvt -e sh -c 'htc --help ; bash'" },
  { "hts", "urxvt -e sh -c 'hts --help ; bash'" },
  { "htc", "urxvt -e sh -c 'htc --help ; bash'" },
  { "hts", "urxvt -e sh -c 'hts --help ; bash'" },
  { "icmptx", "urxvt -e sh -c 'icmptx ; bash'" },
  { "iodine", "urxvt -e sh -c 'iodine ; bash'" },
  { "iodined", "urxvt -e sh -c 'iodined ; bash'" },
  { "iodine", "urxvt -e sh -c 'iodine ; bash'" },
  { "iodined", "urxvt -e sh -c 'iodined ; bash'" },
  { "kcptun-client", "urxvt -e sh -c 'kcptun-client -h ; bash'" },
  { "kcptun-server", "urxvt -e sh -c 'kcptun-server -h ; bash'" },
  { "kcptun-client", "urxvt -e sh -c 'kcptun-client -h ; bash'" },
  { "kcptun-server", "urxvt -e sh -c 'kcptun-server -h ; bash'" },
  { "matahari", "urxvt -e sh -c 'matahari ; bash'" },
  { "morxtunel", "urxvt -e sh -c 'morxtunel ; bash'" },
  { "multitun", "urxvt -e sh -c 'multitun ; bash'" },
  { "neo-regeorg", "urxvt -e sh -c 'neo-regeorg ; bash'" },
  { "ngrok", "urxvt -e sh -c 'ngrok ; bash'" },
  { "packet-o-matic", "urxvt -e sh -c 'packet-o-matic -h ; bash'" },
  { "pr0cks", "urxvt -e sh -c 'pr0cks -h ; bash'" },
  { "proxytunnel", "urxvt -e sh -c 'proxytunnel -h ; bash'" },
  { "ptunnel", "urxvt -e sh -c 'ptunnel -h ; bash'" },
  { "regeorg", "urxvt -e sh -c 'regeorg -h ; bash'" },
  { "shootback-master", "urxvt -e sh -c 'shootback-master -h ; bash'" },
  { "shootback-slaver", "urxvt -e sh -c 'shootback-slaver -h ; bash'" },
  { "ssrf-proxy", "urxvt -e sh -c 'ssrf-proxy -h ; bash'" },
  { "console", "urxvt -e sh -c 'console ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "ssrf-proxy", "urxvt -e sh -c 'ssrf-proxy -h ; bash'" },
  { "stegosip", "urxvt -e sh -c 'stegosip ; bash'" },
  { "stunnel", "urxvt -e sh -c 'stunnel ; bash'" },
  { "stunnel3", "urxvt -e sh -c 'stunnel3 ; bash'" },
  { "stunnel", "urxvt -e sh -c 'stunnel ; bash'" },
  { "stunnel3", "urxvt -e sh -c 'stunnel3 ; bash'" },
  { "tor", "urxvt -e sh -c 'tor -h ; bash'" },
  { "tor-gencert", "urxvt -e sh -c 'tor-gencert ; bash'" },
  { "tor-print-ed-signing-cert", "urxvt -e sh -c 'tor-print-ed-signing-cert ; bash'" },
  { "tor-resolve", "urxvt -e sh -c 'tor-resolve ; bash'" },
  { "torify", "urxvt -e sh -c 'torify -h ; bash'" },
  { "tor", "urxvt -e sh -c 'tor -h ; bash'" },
  { "tor-gencert", "urxvt -e sh -c 'tor-gencert ; bash'" },
  { "tor-print-ed-signing-cert", "urxvt -e sh -c 'tor-print-ed-signing-cert ; bash'" },
  { "tor-resolve", "urxvt -e sh -c 'tor-resolve ; bash'" },
  { "torify", "urxvt -e sh -c 'torify -h ; bash'" },
  { "tunna-proxy", "urxvt -e sh -c 'tunna-proxy ; bash'" },
  { "tunna-webserver", "urxvt -e sh -c 'tunna-webserver ; bash'" },
  { "udp2raw", "urxvt -e sh -c 'udp2raw ; bash'" },
  { "udptunnel", "urxvt -e sh -c 'udptunnel -h ; bash'" },
  { "vstt", "urxvt -e sh -c 'vstt -h ; bash'" },
  { "vstt-reader", "urxvt -e sh -c 'vstt-reader ; bash'" },
  { "vstt-s2f", "urxvt -e sh -c 'vstt-s2f ; bash'" },
  { "xfltreat", "urxvt -e sh -c 'xfltreat -h ; bash'" },
}

unpackermenu = {
  { "createnpk", "urxvt -e sh -c 'createnpk ; bash'" },
  { "dumpnpk", "urxvt -e sh -c 'dumpnpk ; bash'" },
  { "unpacknpk", "urxvt -e sh -c 'unpacknpk ; bash'" },
}

voipmenu = {
  { "ace", "urxvt -e sh -c 'ace -h ; bash'" },
  { "bluebox-ng", "urxvt -e sh -c 'bluebox-ng -h ; bash'" },
  { "erase-registrations", "urxvt -e sh -c 'erase-registrations ; bash'" },
  { "iaxflood", "urxvt -e sh -c 'iaxflood ; bash'" },
  { "ilty", "urxvt -e sh -c 'ilty -h ; bash'" },
  { "isip", "urxvt -e sh -c 'isip ; bash'" },
  { "isme", "urxvt -e sh -c 'isme ; bash'" },
  { "mrsip", "urxvt -e sh -c 'mrsip -h ; bash'" },
  { "protos-sip", "urxvt -e sh -c 'protos-sip ; bash'" },
  { "pyersinia", "urxvt -e sh -c 'pyersinia -h ; bash'" },
  { "redirectpoison", "urxvt -e sh -c 'redirectpoison ; bash'" },
  { "rtpflood", "urxvt -e sh -c 'rtpflood -h ; bash'" },
  { "siparmyknife", "urxvt -e sh -c 'siparmyknife ; bash'" },
  { "sipbrute", "urxvt -e sh -c 'sipbrute -h ; bash'" },
  { "sipcrack", "urxvt -e sh -c 'sipcrack -h ; bash'" },
  { "sipdump", "urxvt -e sh -c 'sipdump -h ; bash'" },
  { "sipffer", "urxvt -e sh -c 'sipffer -h ; bash'" },
  { "sipp", "urxvt -e sh -c 'sipp ; bash'" },
  { "sipcracker", "urxvt -e sh -c 'sipcracker ; bash'" },
  { "sipdigestleak", "urxvt -e sh -c 'sipdigestleak ; bash'" },
  { "sipexten", "urxvt -e sh -c 'sipexten -h ; bash'" },
  { "sipinvite", "urxvt -e sh -c 'sipinvite -h ; bash'" },
  { "sipreport", "urxvt -e sh -c 'sipreport -h ; bash'" },
  { "storm-ring", "urxvt -e sh -c 'storm-ring -h ; bash'" },
  { "teardown", "urxvt -e sh -c 'teardown ; bash'" },
  { "vnak", "urxvt -e sh -c 'vnak ; bash'" },
  { "voiper-fuzzer", "urxvt -e sh -c 'voiper-fuzzer ; bash'" },
  { "voiper-torturer", "urxvt -e sh -c 'voiper-torturer ; bash'" },
  { "voiphopper", "urxvt -e sh -c 'voiphopper -h ; bash'" },
  { "voipctl", "urxvt -e sh -c 'voipctl -h ; bash'" },
  { "voipong", "urxvt -e sh -c 'voipong -h ; bash'" },
  { "vsaudit", "urxvt -e sh -c 'vsaudit ; bash'" },
}

webappmenu = {
  { "0d1n", "urxvt -e sh -c '0d1n ; bash'" },
  { "0d1n_view", "urxvt -e sh -c '0d1n_view ; bash'" },
  { "abuse-ssl-bypass-waf", "urxvt -e sh -c 'abuse-ssl-bypass-waf -h ; bash'" },
  { "adfind", "urxvt -e sh -c 'adfind -h ; bash'" },
  { "adminpagefinder", "urxvt -e sh -c 'adminpagefinder -h ; bash'" },
  { "allthevhosts", "urxvt -e sh -c 'allthevhosts ; bash'" },
  { "anti-xss", "urxvt -e sh -c 'anti-xss -h ; bash'" },
  { "arachni", "urxvt -e sh -c 'arachni -h ; bash'" },
  { "arachni-console", "urxvt -e sh -c 'arachni-console ; bash'" },
  { "arachni-multi", "urxvt -e sh -c 'arachni-multi ; bash'" },
  { "arachni-reporter", "urxvt -e sh -c 'arachni-reporter ; bash'" },
  { "arachni-rest-server", "urxvt -e sh -c 'arachni-rest-server ; bash'" },
  { "arachni-restore", "urxvt -e sh -c 'arachni-restore ; bash'" },
  { "arachni-rpc", "urxvt -e sh -c 'arachni-rpc ; bash'" },
  { "arachni-rpcd", "urxvt -e sh -c 'arachni-rpcd ; bash'" },
  { "arachni-rpcd-monitor", "urxvt -e sh -c 'arachni-rpcd-monitor ; bash'" },
  { "arachni-script", "urxvt -e sh -c 'arachni-script ; bash'" },
  { "arachni", "urxvt -e sh -c 'arachni -h ; bash'" },
  { "arachni_console", "urxvt -e sh -c 'arachni_console -h ; bash'" },
  { "arachni_multi", "urxvt -e sh -c 'arachni_multi -h ; bash'" },
  { "arachni_reporter", "urxvt -e sh -c 'arachni_reporter ; bash'" },
  { "arachni_reproduce", "urxvt -e sh -c 'arachni_reproduce ; bash'" },
  { "arachni_rest_server", "urxvt -e sh -c 'arachni_rest_server ; bash'" },
  { "arachni_restore", "urxvt -e sh -c 'arachni_restore ; bash'" },
  { "arachni_rpc", "urxvt -e sh -c 'arachni_rpc -h ; bash'" },
  { "arachni_rpcd", "urxvt -e sh -c 'arachni_rpcd -h ; bash'" },
  { "arachni_rpcd_monitor", "urxvt -e sh -c 'arachni_rpcd_monitor -h ; bash'" },
  { "arachni_script", "urxvt -e sh -c 'arachni_script -h ; bash'" },
  { "archivebox", "urxvt -e sh -c 'archivebox -h ; bash'" },
  { "archive", "urxvt -e sh -c 'archive ; bash'" },
  { "arjun", "urxvt -e sh -c 'arjun -h ; bash'" },
  { "asp-audit", "urxvt -e sh -c 'asp-audit ; bash'" },
  { "astra", "urxvt -e sh -c 'astra ; bash'" },
  { "atlas", "urxvt -e sh -c 'atlas -h ; bash'" },
  { "atscan", "urxvt -e sh -c 'atscan ; bash'" },
  { "aws-extender-cli", "urxvt -e sh -c 'aws-extender-cli -h ; bash'" },
  { "backcookie", "urxvt -e sh -c 'backcookie -h ; bash'" },
  { "badministration", "urxvt -e sh -c 'badministration --help ; bash'" },
  { "bbqsql", "urxvt -e sh -c 'bbqsql -h ; bash'" },
  { "bbscan", "urxvt -e sh -c 'bbscan -h ; bash'" },
  { "belati", "urxvt -e sh -c 'belati -h ; bash'" },
  { "bfac", "urxvt -e sh -c 'bfac -h ; bash'" },
  { "bing-lfi-rfi", "urxvt -e sh -c 'bing-lfi-rfi -h ; bash'" },
  { "bitdump", "urxvt -e sh -c 'bitdump -h ; bash'" },
  { "blindelephant", "urxvt -e sh -c 'blindelephant -h ; bash'" },
  { "brakeman", "urxvt -e sh -c 'brakeman ; bash'" },
  { "brute-force", "urxvt -e sh -c 'brute-force -h ; bash'" },
  { "brutemap", "urxvt -e sh -c 'brutemap -h ; bash'" },
  { "brutexss", "urxvt -e sh -c 'brutexss ; bash'" },
  { "bsqlbf", "urxvt -e sh -c 'bsqlbf ; bash'" },
  { "bsqlinjector", "urxvt -e sh -c 'bsqlinjector -h ; bash'" },
  { "c5scan", "urxvt -e sh -c 'c5scan -h ; bash'" },
  { "cangibrina", "urxvt -e sh -c 'cangibrina -h ; bash'" },
  { "cansina", "urxvt -e sh -c 'cansina -h ; bash'" },
  { "chankro", "urxvt -e sh -c 'chankro -h ; bash'" },
  { "cintruder", "urxvt -e sh -c 'cintruder -h ; bash'" },
  { "cloudget", "urxvt -e sh -c 'cloudget -h ; bash'" },
  { "cms-few", "urxvt -e sh -c 'cms-few -h ; bash'" },
  { "cmseek", "urxvt -e sh -c 'cmseek ; bash'" },
  { "cmsfuzz", "urxvt -e sh -c 'cmsfuzz ; bash'" },
  { "cmsmap", "urxvt -e sh -c 'cmsmap -h ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "cmsscanner", "urxvt -e sh -c 'cmsscanner -h ; bash'" },
  { "cmsscan", "urxvt -e sh -c 'cmsscan -h ; bash'" },
  { "comission", "urxvt -e sh -c 'comission -h ; bash'" },
  { "commix", "urxvt -e sh -c 'commix ; bash'" },
  { "conscan", "urxvt -e sh -c 'conscan -h ; bash'" },
  { "corscanner", "urxvt -e sh -c 'corscanner -h ; bash'" },
  { "corstest", "urxvt -e sh -c 'corstest -h ; bash'" },
  { "corsy", "urxvt -e sh -c 'corsy -h ; bash'" },
  { "cpfinder", "urxvt -e sh -c 'cpfinder -h ; bash'" },
  { "crabstick", "urxvt -e sh -c 'crabstick -h ; bash'" },
  { "crawlic", "urxvt -e sh -c 'crawlic -h ; bash'" },
  { "crlf-injector", "urxvt -e sh -c 'crlf-injector ; bash'" },
  { "crlfuzz", "urxvt -e sh -c 'crlfuzz -h ; bash'" },
  { "csrftester", "urxvt -e sh -c 'csrftester ; bash'" },
  { "cybercrowl", "urxvt -e sh -c 'cybercrowl -h ; bash'" },
  { "d-tect", "urxvt -e sh -c 'd-tect ; bash'" },
  { "dalfox", "urxvt -e sh -c 'dalfox -h ; bash'" },
  { "darkd0rk3r", "urxvt -e sh -c 'darkd0rk3r ; rm -rf darkd0rk3r-*.txt ; bash'" },
  { "darkdump", "urxvt -e sh -c 'darkdump -h ; bash'" },
  { "darkmysqli", "urxvt -e sh -c 'darkmysqli -h ; bash'" },
  { "darkscrape", "urxvt -e sh -c 'darkscrape ; bash'" },
  { "davscan", "urxvt -e sh -c 'davscan -h ; bash'" },
  { "dawnscanner", "urxvt -e sh -c 'dawnscanner ; bash'" },
  { "dawn", "urxvt -e sh -c 'dawn -h ; bash'" },
  { "dcrawl", "urxvt -e sh -c 'dcrawl -h ; bash'" },
  { "detectem", "urxvt -e sh -c 'detectem --help ; bash'" },
  { "html2dic", "urxvt -e sh -c 'html2dic ; bash'" },
  { "dirhunt", "urxvt -e sh -c 'dirhunt --help ; bash'" },
  { "dirscanner", "urxvt -e sh -c 'dirscanner -h ; bash'" },
  { "dirscraper", "urxvt -e sh -c 'dirscraper -h ; bash'" },
  { "dirsearch", "urxvt -e sh -c 'dirsearch -h ; bash'" },
  { "dirstalk", "urxvt -e sh -c 'dirstalk -h ; bash'" },
  { "docem", "urxvt -e sh -c 'docem -h ; bash'" },
  { "domi-owned", "urxvt -e sh -c 'domi-owned -h ; bash'" },
  { "doork", "urxvt -e sh -c 'doork -h ; bash'" },
  { "dorknet", "urxvt -e sh -c 'dorknet -h ; bash'" },
  { "droopescan", "urxvt -e sh -c 'droopescan -h ; bash'" },
  { "drupal-module-enum", "urxvt -e sh -c 'drupal-module-enum ; bash'" },
  { "drupalscan", "urxvt -e sh -c 'drupalscan ; bash'" },
  { "drupwn", "urxvt -e sh -c 'drupwn -h ; bash'" },
  { "dsfs", "urxvt -e sh -c 'dsfs -h ; bash'" },
  { "dsss", "urxvt -e sh -c 'dsss -h ; bash'" },
  { "dsstore-crawler", "urxvt -e sh -c 'dsstore-crawler -h ; bash'" },
  { "dsxs", "urxvt -e sh -c 'dsxs -h ; bash'" },
  { "dumb0", "urxvt -e sh -c 'dumb0 -h ; bash'" },
  { "easyfuzzer", "urxvt -e sh -c 'easyfuzzer ; bash'" },
  { "easyfuzzer-proxy", "urxvt -e sh -c 'easyfuzzer-proxy ; bash'" },
  { "prepare4easyfuzzer", "urxvt -e sh -c 'prepare4easyfuzzer ; bash'" },
  { "wsdl2request", "urxvt -e sh -c 'wsdl2request ; bash'" },
  { "eazy", "urxvt -e sh -c 'eazy -h ; bash'" },
  { "eos", "urxvt -e sh -c 'eos -h ; bash'" },
  { "evine", "urxvt -e sh -c 'evine -h ; bash'" },
  { "ssrf-search", "urxvt -e sh -c 'ssrf-search -h ; bash'" },
  { "eyewitness", "urxvt -e sh -c 'eyewitness -h ; bash'" },
  { "dismissauth.xpi", "urxvt -e sh -c 'dismissauth.xpi ; bash'" },
  { "facebot", "urxvt -e sh -c 'facebot -h ; bash'" },
  { "facebrute", "urxvt -e sh -c 'facebrute -h ; bash'" },
  { "fbht", "urxvt -e sh -c 'fbht ; bash'" },
  { "feroxbuster", "urxvt -e sh -c 'feroxbuster -h ; bash'" },
  { "ffuf", "urxvt -e sh -c 'ffuf ; bash'" },
  { "fhttp", "urxvt -e sh -c 'fhttp -h ; bash'" },
  { "filebuster", "urxvt -e sh -c 'filebuster --help ; bash'" },
  { "fingerprinter", "urxvt -e sh -c 'fingerprinter -h ; bash'" },
  { "flask-session-cookie-manager2", "urxvt -e sh -c 'flask-session-cookie-manager2 -h ; bash'" },
  { "flask-session-cookie-manager3", "urxvt -e sh -c 'flask-session-cookie-manager3 -h ; bash'" },
  { "flunym0us", "urxvt -e sh -c 'flunym0us ; bash'" },
  { "gau", "urxvt -e sh -c 'gau -h ; bash'" },
  { "git-dumper", "urxvt -e sh -c 'git-dumper -h ; bash'" },
  { "gitdump", "urxvt -e sh -c 'gitdump ; bash'" },
  { "gittools-extractor", "urxvt -e sh -c 'gittools-extractor ; bash'" },
  { "gittools-gitdumper", "urxvt -e sh -c 'gittools-gitdumper ; bash'" },
  { "gittools-gitfinder", "urxvt -e sh -c 'gittools-gitfinder -h ; bash'" },
  { "gobuster", "urxvt -e sh -c 'gobuster -h ; bash'" },
  { "golismero", "urxvt -e sh -c 'golismero -h ; bash'" },
  { "gopherus", "urxvt -e sh -c 'gopherus ; bash'" },
  { "gospider", "urxvt -e sh -c 'gospider -h ; bash'" },
  { "gowitness", "urxvt -e sh -c 'gowitness -h ; bash'" },
  { "grabber-scanner", "urxvt -e sh -c 'grabber-scanner -h ; bash'" },
  { "graphql-path-enum", "urxvt -e sh -c 'graphql-path-enum -h ; bash'" },
  { "graphqlmap", "urxvt -e sh -c 'graphqlmap -h ; bash'" },
  { "gwtenum", "urxvt -e sh -c 'gwtenum -h ; bash'" },
  { "gwtfuzzer", "urxvt -e sh -c 'gwtfuzzer -h ; bash'" },
  { "gwtparse", "urxvt -e sh -c 'gwtparse -h ; bash'" },
  { "h2buster", "urxvt -e sh -c 'h2buster ; bash'" },
  { "h2csmuggler", "urxvt -e sh -c 'h2csmuggler -h ; bash'" },
  { "h2t", "urxvt -e sh -c 'h2t -h ; bash'" },
  { "hakku", "urxvt -e sh -c 'hakku ; bash'" },
  { "hakrawler", "urxvt -e sh -c 'hakrawler -h ; bash'" },
  { "halberd", "urxvt -e sh -c 'halberd -h ; bash'" },
  { "hetty", "urxvt -e sh -c 'hetty -h ; bash'" },
  { "host-extract", "urxvt -e sh -c 'host-extract -h ; bash'" },
  { "htcap", "urxvt -e sh -c 'htcap -h ; bash'" },
  { "httpextract", "urxvt -e sh -c 'httpextract -h ; bash'" },
  { "httpforge", "urxvt -e sh -c 'httpforge -h ; bash'" },
  { "httpgrep", "urxvt -e sh -c 'httpgrep -H ; bash'" },
  { "httppwnly", "urxvt -e sh -c 'httppwnly ; bash'" },
  { "httpx", "urxvt -e sh -c 'httpx -h ; bash'" },
  { "hyperfox", "urxvt -e sh -c 'hyperfox -h ; bash'" },
  { "identywaf", "urxvt -e sh -c 'identywaf -h ; bash'" },
  { "injectus", "urxvt -e sh -c 'injectus ; bash'" },
  { "inurlbr", "urxvt -e sh -c 'inurlbr -h ; bash'" },
  { "isr-form", "urxvt -e sh -c 'isr-form -h ; bash'" },
  { "jaeles", "urxvt -e sh -c 'jaeles -h ; bash'" },
  { "jaidam", "urxvt -e sh -c 'jaidam ; bash'" },
  { "jast", "urxvt -e sh -c 'jast -h ; bash'" },
  { "unix-jboss-autopwn", "urxvt -e sh -c 'unix-jboss-autopwn ; bash'" },
  { "win-jboss-autopwn", "urxvt -e sh -c 'win-jboss-autopwn ; bash'" },
  { "jdeserialize", "urxvt -e sh -c 'jdeserialize ; bash'" },
  { "jexboss", "urxvt -e sh -c 'jexboss -h ; bash'" },
  { "jira-scan", "urxvt -e sh -c 'jira-scan ; bash'" },
  { "jok3r", "urxvt -e sh -c 'jok3r -h ; bash'" },
  { "jooforce", "urxvt -e sh -c 'jooforce ; bash'" },
  { "joomlascan", "urxvt -e sh -c 'joomlascan -h ; bash'" },
  { "joomlavs", "urxvt -e sh -c 'joomlavs ; bash'" },
  { "joomscan", "urxvt -e sh -c 'joomscan -h ; bash'" },
  { "jsearch", "urxvt -e sh -c 'jsearch -h ; bash'" },
  { "jsonbee", "urxvt -e sh -c 'jsonbee -h ; bash'" },
  { "jsparser", "urxvt -e sh -c 'jsparser --help ; bash'" },
  { "jsql-injection", "urxvt -e sh -c 'jsql-injection ; bash'" },
  { "jstillery", "urxvt -e sh -c 'jstillery -h ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "kadimus", "urxvt -e sh -c 'kadimus -h ; bash'" },
  { "keye", "urxvt -e sh -c 'keye -h ; bash'" },
  { "kiterunner", "urxvt -e sh -c 'kiterunner -h ; bash'" },
  { "kolkata", "urxvt -e sh -c 'kolkata ; bash'" },
  { "konan", "urxvt -e sh -c 'konan -h ; bash'" },
  { "kubolt", "urxvt -e sh -c 'kubolt -h ; bash'" },
  { "laf", "urxvt -e sh -c 'laf -h ; bash'" },
  { "aprof", "urxvt -e sh -c 'aprof ; bash'" },
  { "lbmap", "urxvt -e sh -c 'lbmap -h ; bash'" },
  { "letmefuckit", "urxvt -e sh -c 'letmefuckit -h ; bash'" },
  { "leviathan", "urxvt -e sh -c 'leviathan ; bash'" },
  { "lfi-image-helper", "urxvt -e sh -c 'lfi-image-helper ; bash'" },
  { "lfi-scanner", "urxvt -e sh -c 'lfi-scanner -h ; bash'" },
  { "lfifreak", "urxvt -e sh -c 'lfifreak ; bash'" },
  { "lfimap", "urxvt -e sh -c 'lfimap -h ; bash'" },
  { "lfisuite", "urxvt -e sh -c 'lfisuite ; bash'" },
  { "liffy", "urxvt -e sh -c 'liffy -h ; bash'" },
  { "lightbulb", "urxvt -e sh -c 'lightbulb -h ; bash'" },
  { "linkfinder", "urxvt -e sh -c 'linkfinder -h ; bash'" },
  { "list-urls", "urxvt -e sh -c 'list-urls ; bash'" },
  { "lulzbuster", "urxvt -e sh -c 'lulzbuster -H ; bash'" },
  { "magescan", "urxvt -e sh -c 'magescan ; bash'" },
  { "mando.me", "urxvt -e sh -c 'mando.me -h ; bash'" },
  { "maryam", "urxvt -e sh -c 'maryam ; bash'" },
  { "meg", "urxvt -e sh -c 'meg -h ; bash'" },
  { "metoscan", "urxvt -e sh -c 'metoscan ; bash'" },
  { "monsoon", "urxvt -e sh -c 'monsoon -h ; bash'" },
  { "mooscan", "urxvt -e sh -c 'mooscan -h ; bash'" },
  { "morxtraversal", "urxvt -e sh -c 'morxtraversal ; bash'" },
  { "mosquito", "urxvt -e sh -c 'mosquito ; bash'" },
  { "multiinjector", "urxvt -e sh -c 'multiinjector -h ; bash'" },
  { "mwebfp", "urxvt -e sh -c 'mwebfp -h ; bash'" },
  { "nikto", "urxvt -e sh -c 'nikto -H ; bash'" },
  { "nosqli", "urxvt -e sh -c 'nosqli -h ; bash'" },
  { "nosqli-user-pass-enum", "urxvt -e sh -c 'nosqli-user-pass-enum -h ; bash'" },
  { "nosqlmap", "urxvt -e sh -c 'nosqlmap ; bash'" },
  { "novahot", "urxvt -e sh -c 'novahot -h ; bash'" },
  { "nsia", "urxvt -e sh -c 'nsia -h ; bash'" },
  { "nuclei", "urxvt -e sh -c 'nuclei -h ; bash'" },
  { "okadminfinder", "urxvt -e sh -c 'okadminfinder -h ; bash'" },
  { "onionsearch", "urxvt -e sh -c 'onionsearch -h ; bash'" },
  { "opendoor", "urxvt -e sh -c 'opendoor -h ; bash'" },
  { "otori", "urxvt -e sh -c 'otori -h ; bash'" },
  { "owasp-bywaf", "urxvt -e sh -c 'owasp-bywaf -h ; bash'" },
  { "owtf", "urxvt -e sh -c 'owtf ; bash'" },
  { "parameth", "urxvt -e sh -c 'parameth -h ; bash'" },
  { "parampampam", "urxvt -e sh -c 'parampampam -h ; bash'" },
  { "paranoic", "urxvt -e sh -c 'paranoic -h ; bash'" },
  { "paros", "urxvt -e sh -c 'paros ; bash'" },
  { "payloadmask", "urxvt -e sh -c 'payloadmask ; bash'" },
  { "pblind", "urxvt -e sh -c 'pblind ; bash'" },
  { "peepingtom", "urxvt -e sh -c 'peepingtom -h ; bash'" },
  { "photon", "urxvt -e sh -c 'photon -h ; bash'" },
  { "phpggc", "urxvt -e sh -c 'phpggc -h ; bash'" },
  { "pixload-bmp", "urxvt -e sh -c 'pixload-bmp ; bash'" },
  { "pixload-gif", "urxvt -e sh -c 'pixload-gif ; bash'" },
  { "pixload-jpg", "urxvt -e sh -c 'pixload-jpg ; bash'" },
  { "plecost", "urxvt -e sh -c 'plecost -h ; bash'" },
  { "plown", "urxvt -e sh -c 'plown -h ; bash'" },
  { "pown", "urxvt -e sh -c 'pown ; bash'" },
  { "ppfuzz", "urxvt -e sh -c 'ppfuzz -h ; bash'" },
  { "proxenet", "urxvt -e sh -c 'proxenet -h ; bash'" },
  { "proxenet-control-cli", "urxvt -e sh -c 'proxenet-control-cli ; bash'" },
  { "proxenet-control-web", "urxvt -e sh -c 'proxenet-control-web ; bash'" },
  { "pureblood", "urxvt -e sh -c 'pureblood ; bash'" },
  { "pwndrop", "urxvt -e sh -c 'pwndrop -h ; bash'" },
  { "pyfiscan", "urxvt -e sh -c 'pyfiscan -h ; bash'" },
  { "pythem", "urxvt -e sh -c 'pythem ; bash'" },
  { "arsenic-check-ie11", "urxvt -e sh -c 'arsenic-check-ie11 ; bash'" },
  { "js-beautify", "urxvt -e sh -c 'js-beautify -h ; bash'" },
  { "witnessme", "urxvt -e sh -c 'witnessme -h ; bash'" },
  { "wmapi", "urxvt -e sh -c 'wmapi ; bash'" },
  { "js-beautify2", "urxvt -e sh -c 'js-beautify2 -h ; bash'" },
  { "webtech2", "urxvt -e sh -c 'webtech2 ; bash'" },
  { "rabid", "urxvt -e sh -c 'rabid -h ; bash'" },
  { "rabid_console", "urxvt -e sh -c 'rabid_console ; bash'" },
  { "rapidscan", "urxvt -e sh -c 'rapidscan ; bash'" },
  { "ratproxy", "urxvt -e sh -c 'ratproxy -h ; bash'" },
  { "rawr", "urxvt -e sh -c 'rawr -h ; bash'" },
  { "recsech", "urxvt -e sh -c 'recsech ; bash'" },
  { "red-hawk", "urxvt -e sh -c 'red-hawk ; bash'" },
  { "remot3d", "urxvt -e sh -c 'remot3d ; bash'" },
  { "restler-fuzzer", "urxvt -e sh -c 'restler-fuzzer -h ; bash'" },
  { "ruler", "urxvt -e sh -c 'ruler -h ; bash'" },
  { "rustbuster", "urxvt -e sh -c 'rustbuster --help ; bash'" },
  { "rww-attack", "urxvt -e sh -c 'rww-attack ; bash'" },
  { "sawef", "urxvt -e sh -c 'sawef -h ; bash'" },
  { "scanqli", "urxvt -e sh -c 'scanqli -h ; bash'" },
  { "secretfinder", "urxvt -e sh -c 'secretfinder -h ; bash'" },
  { "secscan", "urxvt -e sh -c 'secscan -h ; bash'" },
  { "see-surf", "urxvt -e sh -c 'see-surf -h ; bash'" },
  { "serializationdumper", "urxvt -e sh -c 'serializationdumper ; bash'" },
  { "shellinaboxd", "urxvt -e sh -c 'shellinaboxd -h ; bash'" },
  { "shortfuzzy", "urxvt -e sh -c 'shortfuzzy -h ; bash'" },
  { "shuffledns", "urxvt -e sh -c 'shuffledns -h ; bash'" },
  { "sitadel", "urxvt -e sh -c 'sitadel -h ; bash'" },
  { "sitediff", "urxvt -e sh -c 'sitediff -h ; bash'" },
  { "sjet", "urxvt -e sh -c 'sjet -h ; bash'" },
  { "sfscandiff", "urxvt -e sh -c 'sfscandiff -h ; bash'" },
  { "smuggler", "urxvt -e sh -c 'smuggler -h ; bash'" },
  { "snallygaster", "urxvt -e sh -c 'snallygaster -h ; bash'" },
  { "clone", "urxvt -e sh -c 'clone ; bash'" },
  { "snare", "urxvt -e sh -c 'snare -h ; bash'" },
  { "snuck", "urxvt -e sh -c 'snuck ; bash'" },
  { "spaf", "urxvt -e sh -c 'spaf -h ; bash'" },
  { "sparty", "urxvt -e sh -c 'sparty -h ; bash'" },
  { "spiga", "urxvt -e sh -c 'spiga -h ; bash'" },
  { "spike-proxy", "urxvt -e sh -c 'spike-proxy -h ; bash'" },
  { "sprayingtoolkit-aerosol", "urxvt -e sh -c 'sprayingtoolkit-aerosol -h ; bash'" },
  { "sprayingtoolkit-atomizer", "urxvt -e sh -c 'sprayingtoolkit-atomizer -h ; bash'" },
  { "sprayingtoolkit-spindrift", "urxvt -e sh -c 'sprayingtoolkit-spindrift -h ; bash'" },
  { "sprayingtoolkit-vaporizer", "urxvt -e sh -c 'sprayingtoolkit-vaporizer -h ; bash'" },
  { "sqid", "urxvt -e sh -c 'sqid -h ; bash'" },
  { "sqlbrute", "urxvt -e sh -c 'sqlbrute -h ; bash'" },
  { "sqlivulscan", "urxvt -e sh -c 'sqlivulscan ; bash'" },
  { "sqlmap", "urxvt -e sh -c 'sqlmap -hh ; bash'" },
  { "sqlmapapi", "urxvt -e sh -c 'sqlmapapi ; bash'" },
  { "sqlmap", "urxvt -e sh -c 'sqlmap -hh ; bash'" },
  { "sqlmapapi", "urxvt -e sh -c 'sqlmapapi ; bash'" },
  { "sqlninja", "urxvt -e sh -c 'sqlninja -h ; bash'" },
  { "sqlsus", "urxvt -e sh -c 'sqlsus -h ; bash'" },
  { "ssrfmap", "urxvt -e sh -c 'ssrfmap -h ; bash'" },
  { "striker", "urxvt -e sh -c 'striker ; bash'" },
  { "swarm", "urxvt -e sh -c 'swarm -h ; bash'" },
  { "as3compile", "urxvt -e sh -c 'as3compile ; bash'" },
  { "font2swf", "urxvt -e sh -c 'font2swf ; bash'" },
  { "gif2swf", "urxvt -e sh -c 'gif2swf ; bash'" },
  { "jpeg2swf", "urxvt -e sh -c 'jpeg2swf ; bash'" },
  { "pdf2swf", "urxvt -e sh -c 'pdf2swf ; bash'" },
  { "png2swf", "urxvt -e sh -c 'png2swf ; bash'" },
  { "swfbbox", "urxvt -e sh -c 'swfbbox ; bash'" },
  { "swfc", "urxvt -e sh -c 'swfc ; bash'" },
  { "swfdump", "urxvt -e sh -c 'swfdump ; bash'" },
  { "swfextract", "urxvt -e sh -c 'swfextract ; bash'" },
  { "swfrender", "urxvt -e sh -c 'swfrender ; bash'" },
  { "swfstrings", "urxvt -e sh -c 'swfstrings ; bash'" },
  { "wav2swf", "urxvt -e sh -c 'wav2swf ; bash'" },
  { "taipan", "urxvt -e sh -c 'taipan ; bash'" },
  { "themole", "urxvt -e sh -c 'themole -h ; bash'" },
  { "tidconsole", "urxvt -e sh -c 'tidconsole -h ; bash'" },
  { "tidv2", "urxvt -e sh -c 'tidv2 ; bash'" },
  { "tinfoleak", "urxvt -e sh -c 'tinfoleak ; bash'" },
  { "tinfoleak2", "urxvt -e sh -c 'tinfoleak2 -h ; bash'" },
  { "torcrawl", "urxvt -e sh -c 'torcrawl -h ; bash'" },
  { "typo-enumerator", "urxvt -e sh -c 'typo-enumerator ; bash'" },
  { "ua-tester", "urxvt -e sh -c 'ua-tester ; bash'" },
  { "ufonet", "urxvt -e sh -c 'ufonet -h ; bash'" },
  { "uncaptcha2", "urxvt -e sh -c 'uncaptcha2 ; bash'" },
  { "uniscan", "urxvt -e sh -c 'uniscan --help ; bash'" },
  { "uppwn", "urxvt -e sh -c 'uppwn -h ; bash'" },
  { "urlcrazy", "urxvt -e sh -c 'urlcrazy -h ; bash'" },
  { "urldigger", "urxvt -e sh -c 'urldigger -h ; bash'" },
  { "urlextractor", "urxvt -e sh -c 'urlextractor ; bash'" },
  { "v3n0m", "urxvt -e sh -c 'v3n0m -h ; bash'" },
  { "vane", "urxvt -e sh -c 'vane -h ; bash'" },
  { "vanguard", "urxvt -e sh -c 'vanguard -h ; bash'" },
  { "vbscan", "urxvt -e sh -c 'vbscan ; bash'" },
  { "vega", "urxvt -e sh -c 'vega ; bash'" },
  { "visql", "urxvt -e sh -c 'visql -h ; bash'" },
  { "vsvbp", "urxvt -e sh -c 'vsvbp ; bash'" },
  { "vulnerabilities-spider", "urxvt -e sh -c 'vulnerabilities-spider ; bash'" },
  { "vulnx", "urxvt -e sh -c 'vulnx -h ; bash'" },
  { "vulnx.desktop", "urxvt -e sh -c 'vulnx.desktop ; bash'" },
  { "w13scan", "urxvt -e sh -c 'w13scan -h ; bash'" },
  { "w3af", "urxvt -e sh -c 'w3af -h ; bash'" },
  { "w3af-gui", "urxvt -e sh -c 'w3af-gui ; bash'" },
  { "wafninja", "urxvt -e sh -c 'wafninja -h ; bash'" },
  { "wafp", "urxvt -e sh -c 'wafp -h ; bash'" },
  { "wafpass", "urxvt -e sh -c 'wafpass -h ; bash'" },
  { "wafw00f", "urxvt -e sh -c 'wafw00f -h ; bash'" },
  { "wapiti", "urxvt -e sh -c 'wapiti -h ; bash'" },
  { "wapiti-getcookie", "urxvt -e sh -c 'wapiti-getcookie -h ; bash'" },
  { "wascan", "urxvt -e sh -c 'wascan -h ; bash'" },
  { "waybackpack", "urxvt -e sh -c 'waybackpack -h ; bash'" },
  { "web-soul", "urxvt -e sh -c 'web-soul -h ; bash'" },
  { "webacoo", "urxvt -e sh -c 'webacoo -h ; bash'" },
  { "webanalyze", "urxvt -e sh -c 'webanalyze ; bash'" },
  { "webborer", "urxvt -e sh -c 'webborer ; bash'" },
  { "webenum", "urxvt -e sh -c 'webenum -h ; bash'" },
  { "webhandler", "urxvt -e sh -c 'webhandler ; bash'" },
  { "webhunter", "urxvt -e sh -c 'webhunter ; bash'" },
  { "webkiller", "urxvt -e sh -c 'webkiller -h ; bash'" },
  { "webpwn3r", "urxvt -e sh -c 'webpwn3r -h ; bash'" },
  { "webrute", "urxvt -e sh -c 'webrute -help ; bash'" },
  { "webscarab", "urxvt -e sh -c 'webscarab ; bash'" },
  { "webslayer", "urxvt -e sh -c 'webslayer ; bash'" },
  { "webspa", "urxvt -e sh -c 'webspa -help ; bash'" },
  { "webtech", "urxvt -e sh -c 'webtech -h ; bash'" },
  { "weevely", "urxvt -e sh -c 'weevely -h ; bash'" },
  { "weirdaal", "urxvt -e sh -c 'weirdaal -h ; bash'" },
  { "wfencode", "urxvt -e sh -c 'wfencode ; bash'" },
  { "wfpayload", "urxvt -e sh -c 'wfpayload ; bash'" },
  { "wfuzz", "urxvt -e sh -c 'wfuzz ; bash'" },
  { "wxfuzz", "urxvt -e sh -c 'wxfuzz ; bash'" },
  { "whatwaf", "urxvt -e sh -c 'whatwaf -h ; bash'" },
  { "whatweb", "urxvt -e sh -c 'whatweb -h ; bash'" },
  { "whichcdn", "urxvt -e sh -c 'whichcdn -h ; bash'" },
  { "whitewidow", "urxvt -e sh -c 'whitewidow -h ; bash'" },
  { "wig", "urxvt -e sh -c 'wig -h ; bash'" },
  { "witchxtool", "urxvt -e sh -c 'witchxtool -h ; bash'" },
  { "wmat", "urxvt -e sh -c 'wmat ; bash'" },
  { "wordbrutepress", "urxvt -e sh -c 'wordbrutepress ; bash'" },
  { "wpxf", "urxvt -e sh -c 'wpxf ; bash'" },
  { "wordpresscan", "urxvt -e sh -c 'wordpresscan -h ; bash'" },
  { "wpbf", "urxvt -e sh -c 'wpbf -h ; bash'" },
  { "wpbrute-rpc", "urxvt -e sh -c 'wpbrute-rpc ; bash'" },
  { "wpbullet", "urxvt -e sh -c 'wpbullet -h ; bash'" },
  { "wpforce", "urxvt -e sh -c 'wpforce -h ; bash'" },
  { "wpforce-yertle", "urxvt -e sh -c 'wpforce-yertle -h ; bash'" },
  { "wpintel", "urxvt -e sh -c 'wpintel ; bash'" },
  { "ws-attacker", "urxvt -e sh -c 'ws-attacker ; bash'" },
  { "wsfuzzer", "urxvt -e sh -c 'wsfuzzer ; bash'" },
  { "electron-1.7", "urxvt -e sh -c 'electron-1.7 ; bash'" },
  { "wssip", "urxvt -e sh -c 'wssip help ; bash'" },
  { "wuzz", "urxvt -e sh -c 'wuzz -h ; bash'" },
  { "xmlrpc-bruteforcer", "urxvt -e sh -c 'xmlrpc-bruteforcer -h ; bash'" },
  { "xspear", "urxvt -e sh -c 'xspear -h ; bash'" },
  { "console", "urxvt -e sh -c 'console ; bash'" },
  { "setup", "urxvt -e sh -c 'setup ; bash'" },
  { "xsrfprobe", "urxvt -e sh -c 'xsrfprobe -h ; bash'" },
  { "xss-freak", "urxvt -e sh -c 'xss-freak -h ; bash'" },
  { "xsscon", "urxvt -e sh -c 'xsscon -h ; bash'" },
  { "xsser", "urxvt -e sh -c 'xsser -h ; bash'" },
  { "xssless", "urxvt -e sh -c 'xssless ; bash'" },
  { "xsss", "urxvt -e sh -c 'xsss ; bash'" },
  { "xssscan", "urxvt -e sh -c 'xssscan -h ; bash'" },
  { "xsssniper", "urxvt -e sh -c 'xsssniper -h ; bash'" },
  { "xsstrike", "urxvt -e sh -c 'xsstrike ; bash'" },
  { "xssya", "urxvt -e sh -c 'xssya -h ; bash'" },
  { "xwaf", "urxvt -e sh -c 'xwaf -h ; bash'" },
  { "xxeinjector", "urxvt -e sh -c 'xxeinjector -h ; bash'" },
  { "acorn", "urxvt -e sh -c 'acorn ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "jsesc", "urxvt -e sh -c 'jsesc ; bash'" },
  { "_mocha", "urxvt -e sh -c '_mocha ; bash'" },
  { "mocha", "urxvt -e sh -c 'mocha ; bash'" },
  { "semver", "urxvt -e sh -c 'semver ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "tsc", "urxvt -e sh -c 'tsc ; bash'" },
  { "tsserver", "urxvt -e sh -c 'tsserver ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "which", "urxvt -e sh -c 'which ; bash'" },
  { "xxxpwn", "urxvt -e sh -c 'xxxpwn -h ; bash'" },
  { "xxxpwn-smart", "urxvt -e sh -c 'xxxpwn-smart -h ; bash'" },
  { "yaaf", "urxvt -e sh -c 'yaaf -h ; bash'" },
  { "yasuo", "urxvt -e sh -c 'yasuo -h ; bash'" },
  { "yawast", "urxvt -e sh -c 'yawast -h ; bash'" },
  { "ycrawler", "urxvt -e sh -c 'ycrawler -h ; bash'" },
  { "yinjector", "urxvt -e sh -c 'yinjector -h ; bash'" },
  { "ysoserial", "urxvt -e sh -c 'ysoserial ; bash'" },
  { "zaproxy", "urxvt -e sh -c 'zaproxy ; bash'" },
}

windowsmenu = {
  { "amber", "urxvt -e sh -c 'amber ; bash'" },
  { "bloodhound", "urxvt -e sh -c 'bloodhound -h ; bash'" },
  { "handlebars", "urxvt -e sh -c 'handlebars ; bash'" },
  { "he", "urxvt -e sh -c 'he ; bash'" },
  { "mustache", "urxvt -e sh -c 'mustache ; bash'" },
  { "node-which", "urxvt -e sh -c 'node-which ; bash'" },
  { "uuid", "urxvt -e sh -c 'uuid ; bash'" },
  { "cminer", "urxvt -e sh -c 'cminer ; bash'" },
  { "cme", "urxvt -e sh -c 'cme ; bash'" },
  { "cmedb", "urxvt -e sh -c 'cmedb ; bash'" },
  { "cachedump", "urxvt -e sh -c 'cachedump cd /usr/share/windows/cachedump ; ls ; bash'" },
  { "lsadump", "urxvt -e sh -c 'lsadump ; bash'" },
  { "pwdump", "urxvt -e sh -c 'pwdump cd /usr/share/windows/pwdump ; ls ; bash'" },
  { "darkarmour", "urxvt -e sh -c 'darkarmour ; bash'" },
  { "demiguise", "urxvt -e sh -c 'demiguise -h ; bash'" },
  { "evtkit", "urxvt -e sh -c 'evtkit -h ; bash'" },
  { "extractusnjrnl", "urxvt -e sh -c 'extractusnjrnl -h ; bash'" },
  { "fred", "urxvt -e sh -c 'fred ; bash'" },
  { "gene", "urxvt -e sh -c 'gene -h ; bash'" },
  { "ghostdelivery", "urxvt -e sh -c 'ghostdelivery ; bash'" },
  { "goddi", "urxvt -e sh -c 'goddi -h ; bash'" },
  { "harness", "urxvt -e sh -c 'harness ; bash'" },
  { "hercules-payload", "urxvt -e sh -c 'hercules-payload ; bash'" },
  { "hxd", "urxvt -e sh -c 'hxd -h ; bash'" },
  { "indx2csv", "urxvt -e sh -c 'indx2csv -h ; bash'" },
  { "indxcarver", "urxvt -e sh -c 'indxcarver -h ; bash'" },
  { "jackdaw", "urxvt -e sh -c 'jackdaw -h ; bash'" },
  { "lethalhta", "urxvt -e sh -c 'lethalhta -h ; bash'" },
  { "limelighter", "urxvt -e sh -c 'limelighter -h ; bash'" },
  { "log-file-parser", "urxvt -e sh -c 'log-file-parser -h ; bash'" },
  { "mft2csv", "urxvt -e sh -c 'mft2csv -h ; bash'" },
  { "mftcarver", "urxvt -e sh -c 'mftcarver -h ; bash'" },
  { "mftrcrd", "urxvt -e sh -c 'mftrcrd -h ; bash'" },
  { "mftref2name", "urxvt -e sh -c 'mftref2name -h ; bash'" },
  { "missidentify", "urxvt -e sh -c 'missidentify -h ; bash'" },
  { "msvpwn", "urxvt -e sh -c 'msvpwn -h ; bash'" },
  { "nbtscan", "urxvt -e sh -c 'nbtscan -h ; bash'" },
  { "ntfs-file-extractor", "urxvt -e sh -c 'ntfs-file-extractor -h ; bash'" },
  { "ntfs-log-tracker", "urxvt -e sh -c 'ntfs-log-tracker -h ; bash'" },
  { "o365spray", "urxvt -e sh -c 'o365spray -h ; bash'" },
  { "ollydbg", "urxvt -e sh -c 'ollydbg ; bash'" },
  { "openpuff", "urxvt -e sh -c 'openpuff ; bash'" },
  { "osslsigncode", "urxvt -e sh -c 'osslsigncode -h ; bash'" },
  { "powermft", "urxvt -e sh -c 'powermft -h ; bash'" },
  { "minidump", "urxvt -e sh -c 'minidump ; bash'" },
  { "minidump2", "urxvt -e sh -c 'minidump2 ; bash'" },
  { "rcrdcarver", "urxvt -e sh -c 'rcrdcarver -h ; bash'" },
  { "rdp-cipher-checker", "urxvt -e sh -c 'rdp-cipher-checker ; bash'" },
  { "rdp-sec-check", "urxvt -e sh -c 'rdp-sec-check -h ; bash'" },
  { "secure2csv", "urxvt -e sh -c 'secure2csv -h ; bash'" },
  { "shad0w", "urxvt -e sh -c 'shad0w -h ; bash'" },
  { "donut.elf", "urxvt -e sh -c 'donut.elf ; bash'" },
  { "shed", "urxvt -e sh -c 'shed ; bash'" },
  { "shellter", "urxvt -e sh -c 'shellter ; bash'" },
  { "sigthief", "urxvt -e sh -c 'sigthief -h ; bash'" },
  { "sireprat", "urxvt -e sh -c 'sireprat -h ; bash'" },
  { "tunna-proxy", "urxvt -e sh -c 'tunna-proxy ; bash'" },
  { "tunna-webserver", "urxvt -e sh -c 'tunna-webserver ; bash'" },
  { "Akatsuki64.cd", "urxvt -e sh -c 'Akatsuki64.cd ; bash'" },
  { "Fubuki32.cd", "urxvt -e sh -c 'Fubuki32.cd ; bash'" },
  { "Fubuki64.cd", "urxvt -e sh -c 'Fubuki64.cd ; bash'" },
  { "Kamikaze.cd", "urxvt -e sh -c 'Kamikaze.cd ; bash'" },
  { "usnjrnl2csv", "urxvt -e sh -c 'usnjrnl2csv -h ; bash'" },
  { "usn", "urxvt -e sh -c 'usn ; bash'" },
  { "wesng", "urxvt -e sh -c 'wesng -h ; bash'" },
  { "fsck.winregfs", "urxvt -e sh -c 'fsck.winregfs ; bash'" },
  { "mount.winregfs", "urxvt -e sh -c 'mount.winregfs ; bash'" },
}

wirelessmenu = {
  { "aircrack-ng", "urxvt -e sh -c 'aircrack-ng --help ; bash'" },
  { "airdecap-ng", "urxvt -e sh -c 'airdecap-ng --help ; bash'" },
  { "airdecloak-ng", "urxvt -e sh -c 'airdecloak-ng --help ; bash'" },
  { "airdrop-ng", "urxvt -e sh -c 'airdrop-ng ; bash'" },
  { "airgraph-ng", "urxvt -e sh -c 'airgraph-ng -h ; bash'" },
  { "airmon-ng", "urxvt -e sh -c 'airmon-ng --help ; bash'" },
  { "airodump-join", "urxvt -e sh -c 'airodump-join ; bash'" },
  { "airodump-ng", "urxvt -e sh -c 'airodump-ng --help ; bash'" },
  { "airodump-ng-oui-update", "urxvt -e sh -c 'airodump-ng-oui-update ; bash'" },
  { "airolib-ng", "urxvt -e sh -c 'airolib-ng --help ; bash'" },
  { "airserv-ng", "urxvt -e sh -c 'airserv-ng --help ; bash'" },
  { "airtun-ng", "urxvt -e sh -c 'airtun-ng --help ; bash'" },
  { "airventriloquist-ng", "urxvt -e sh -c 'airventriloquist-ng ; bash'" },
  { "besside-ng", "urxvt -e sh -c 'besside-ng --help ; bash'" },
  { "besside-ng-crawler", "urxvt -e sh -c 'besside-ng-crawler ; bash'" },
  { "buddy-ng", "urxvt -e sh -c 'buddy-ng --help ; bash'" },
  { "easside-ng", "urxvt -e sh -c 'easside-ng --help ; bash'" },
  { "ivstools", "urxvt -e sh -c 'ivstools ; bash'" },
  { "kstats", "urxvt -e sh -c 'kstats ; bash'" },
  { "makeivs-ng", "urxvt -e sh -c 'makeivs-ng -h ; bash'" },
  { "packetforge-ng", "urxvt -e sh -c 'packetforge-ng --help ; bash'" },
  { "tkiptun-ng", "urxvt -e sh -c 'tkiptun-ng --help ; bash'" },
  { "versuck-ng", "urxvt -e sh -c 'versuck-ng ; bash'" },
  { "wesside-ng", "urxvt -e sh -c 'wesside-ng --help ; bash'" },
  { "wpaclean", "urxvt -e sh -c 'wpaclean ; bash'" },
  { "aircrack-ng", "urxvt -e sh -c 'aircrack-ng --help ; bash'" },
  { "airdecap-ng", "urxvt -e sh -c 'airdecap-ng --help ; bash'" },
  { "airdecloak-ng", "urxvt -e sh -c 'airdecloak-ng --help ; bash'" },
  { "airdrop-ng", "urxvt -e sh -c 'airdrop-ng ; bash'" },
  { "airgraph-ng", "urxvt -e sh -c 'airgraph-ng -h ; bash'" },
  { "airmon-ng", "urxvt -e sh -c 'airmon-ng --help ; bash'" },
  { "airodump-join", "urxvt -e sh -c 'airodump-join ; bash'" },
  { "airodump-ng", "urxvt -e sh -c 'airodump-ng --help ; bash'" },
  { "airodump-ng-oui-update", "urxvt -e sh -c 'airodump-ng-oui-update ; bash'" },
  { "airolib-ng", "urxvt -e sh -c 'airolib-ng --help ; bash'" },
  { "airserv-ng", "urxvt -e sh -c 'airserv-ng --help ; bash'" },
  { "airtun-ng", "urxvt -e sh -c 'airtun-ng --help ; bash'" },
  { "airventriloquist-ng", "urxvt -e sh -c 'airventriloquist-ng ; bash'" },
  { "besside-ng", "urxvt -e sh -c 'besside-ng --help ; bash'" },
  { "besside-ng-crawler", "urxvt -e sh -c 'besside-ng-crawler ; bash'" },
  { "buddy-ng", "urxvt -e sh -c 'buddy-ng --help ; bash'" },
  { "easside-ng", "urxvt -e sh -c 'easside-ng --help ; bash'" },
  { "ivstools", "urxvt -e sh -c 'ivstools ; bash'" },
  { "kstats", "urxvt -e sh -c 'kstats ; bash'" },
  { "makeivs-ng", "urxvt -e sh -c 'makeivs-ng -h ; bash'" },
  { "packetforge-ng", "urxvt -e sh -c 'packetforge-ng --help ; bash'" },
  { "tkiptun-ng", "urxvt -e sh -c 'tkiptun-ng --help ; bash'" },
  { "versuck-ng", "urxvt -e sh -c 'versuck-ng ; bash'" },
  { "wesside-ng", "urxvt -e sh -c 'wesside-ng --help ; bash'" },
  { "wpaclean", "urxvt -e sh -c 'wpaclean ; bash'" },
  { "airflood", "urxvt -e sh -c 'airflood -h ; bash'" },
  { "airgeddon", "urxvt -e sh -c 'airgeddon ; bash'" },
  { "airopdate", "urxvt -e sh -c 'airopdate ; bash'" },
  { "airoscript-ng", "urxvt -e sh -c 'airoscript-ng ; bash'" },
  { "airoscwordlist", "urxvt -e sh -c 'airoscwordlist ; bash'" },
  { "airpwn", "urxvt -e sh -c 'airpwn -h ; bash'" },
  { "aphopper", "urxvt -e sh -c 'aphopper ; bash'" },
  { "apnbf", "urxvt -e sh -c 'apnbf -h ; bash'" },
  { "atear", "urxvt -e sh -c 'atear -h ; bash'" },
  { "auto-eap", "urxvt -e sh -c 'auto-eap -h ; bash'" },
  { "batctl", "urxvt -e sh -c 'batctl ; bash'" },
  { "alfred", "urxvt -e sh -c 'alfred -h ; bash'" },
  { "batadv-vis", "urxvt -e sh -c 'batadv-vis ; bash'" },
  { "beholder", "urxvt -e sh -c 'beholder -h ; bash'" },
  { "bleah", "urxvt -e sh -c 'bleah -h ; bash'" },
  { "boop", "urxvt -e sh -c 'boop -h ; bash'" },
  { "bully", "urxvt -e sh -c 'bully -h ; bash'" },
  { "cowpatty", "urxvt -e sh -c 'cowpatty -h ; bash'" },
  { "genpmk", "urxvt -e sh -c 'genpmk -h ; bash'" },
  { "cowpatty", "urxvt -e sh -c 'cowpatty -h ; bash'" },
  { "genpmk", "urxvt -e sh -c 'genpmk -h ; bash'" },
  { "create_ap", "urxvt -e sh -c 'create_ap ; bash'" },
  { "crozono", "urxvt -e sh -c 'crozono -h ; bash'" },
  { "eapeak", "urxvt -e sh -c 'eapeak -h ; bash'" },
  { "eaphammer", "urxvt -e sh -c 'eaphammer -h ; bash'" },
  { "eyepwn", "urxvt -e sh -c 'eyepwn ; bash'" },
  { "fern-wifi-cracker", "urxvt -e sh -c 'fern-wifi-cracker ; bash'" },
  { "fluxion", "urxvt -e sh -c 'fluxion ; bash'" },
  { "checkrad", "urxvt -e sh -c 'checkrad -h ; bash'" },
  { "dhcpclient", "urxvt -e sh -c 'dhcpclient -h ; bash'" },
  { "rad_counter", "urxvt -e sh -c 'rad_counter ; bash'" },
  { "radattr", "urxvt -e sh -c 'radattr -h ; bash'" },
  { "radclient", "urxvt -e sh -c 'radclient -h ; bash'" },
  { "radcrypt", "urxvt -e sh -c 'radcrypt -h ; bash'" },
  { "raddebug", "urxvt -e sh -c 'raddebug -h ; bash'" },
  { "radeapclient", "urxvt -e sh -c 'radeapclient ; bash'" },
  { "radiusd", "urxvt -e sh -c 'radiusd -h ; bash'" },
  { "radlast", "urxvt -e sh -c 'radlast -h ; bash'" },
  { "radmin", "urxvt -e sh -c 'radmin -h ; bash'" },
  { "radsniff", "urxvt -e sh -c 'radsniff -h ; bash'" },
  { "radsqlrelay", "urxvt -e sh -c 'radsqlrelay ; bash'" },
  { "radtest", "urxvt -e sh -c 'radtest ; bash'" },
  { "radwho", "urxvt -e sh -c 'radwho -h ; bash'" },
  { "radzap", "urxvt -e sh -c 'radzap -h ; bash'" },
  { "rc.radiusd", "urxvt -e sh -c 'rc.radiusd ; bash'" },
  { "rlm_ippool_tool", "urxvt -e sh -c 'rlm_ippool_tool ; bash'" },
  { "rlm_sqlippool_tool", "urxvt -e sh -c 'rlm_sqlippool_tool ; bash'" },
  { "smbencrypt", "urxvt -e sh -c 'smbencrypt ; bash'" },
  { "checkrad", "urxvt -e sh -c 'checkrad -h ; bash'" },
  { "dhcpclient", "urxvt -e sh -c 'dhcpclient -h ; bash'" },
  { "rad_counter", "urxvt -e sh -c 'rad_counter ; bash'" },
  { "radattr", "urxvt -e sh -c 'radattr -h ; bash'" },
  { "radclient", "urxvt -e sh -c 'radclient -h ; bash'" },
  { "radcrypt", "urxvt -e sh -c 'radcrypt -h ; bash'" },
  { "raddebug", "urxvt -e sh -c 'raddebug -h ; bash'" },
  { "radeapclient", "urxvt -e sh -c 'radeapclient ; bash'" },
  { "radiusd", "urxvt -e sh -c 'radiusd -h ; bash'" },
  { "radlast", "urxvt -e sh -c 'radlast -h ; bash'" },
  { "radmin", "urxvt -e sh -c 'radmin -h ; bash'" },
  { "radsniff", "urxvt -e sh -c 'radsniff -h ; bash'" },
  { "radsqlrelay", "urxvt -e sh -c 'radsqlrelay ; bash'" },
  { "radtest", "urxvt -e sh -c 'radtest ; bash'" },
  { "radwho", "urxvt -e sh -c 'radwho -h ; bash'" },
  { "radzap", "urxvt -e sh -c 'radzap -h ; bash'" },
  { "rc.radiusd", "urxvt -e sh -c 'rc.radiusd ; bash'" },
  { "rlm_ippool_tool", "urxvt -e sh -c 'rlm_ippool_tool ; bash'" },
  { "rlm_sqlippool_tool", "urxvt -e sh -c 'rlm_sqlippool_tool ; bash'" },
  { "smbencrypt", "urxvt -e sh -c 'smbencrypt ; bash'" },
  { "freewifi", "urxvt -e sh -c 'freewifi -h ; bash'" },
  { "fuzzap", "urxvt -e sh -c 'fuzzap -h ; bash'" },
  { "decode-g72x", "urxvt -e sh -c 'decode-g72x -h ; bash'" },
  { "gerix-wifi-cracker", "urxvt -e sh -c 'gerix-wifi-cracker ; bash'" },
  { "giskismet", "urxvt -e sh -c 'giskismet ; bash'" },
  { "gnuradio-companion", "urxvt -e sh -c 'gnuradio-companion -h ; bash'" },
  { "gr-ctrlport-monitor", "urxvt -e sh -c 'gr-ctrlport-monitor ; bash'" },
  { "gr-perf-monitorx", "urxvt -e sh -c 'gr-perf-monitorx ; bash'" },
  { "gr_filter_design", "urxvt -e sh -c 'gr_filter_design ; bash'" },
  { "gr_modtool", "urxvt -e sh -c 'gr_modtool ; bash'" },
  { "gr_read_file_metadata", "urxvt -e sh -c 'gr_read_file_metadata ; bash'" },
  { "grc_setup_freedesktop", "urxvt -e sh -c 'grc_setup_freedesktop ; bash'" },
  { "grcc", "urxvt -e sh -c 'grcc ; bash'" },
  { "polar_channel_construction", "urxvt -e sh -c 'polar_channel_construction ; bash'" },
  { "uhd_fft", "urxvt -e sh -c 'uhd_fft ; bash'" },
  { "uhd_rx_cfile", "urxvt -e sh -c 'uhd_rx_cfile ; bash'" },
  { "uhd_rx_nogui", "urxvt -e sh -c 'uhd_rx_nogui ; bash'" },
  { "uhd_siggen", "urxvt -e sh -c 'uhd_siggen ; bash'" },
  { "uhd_siggen_gui", "urxvt -e sh -c 'uhd_siggen_gui ; bash'" },
  { "gnuradio-companion", "urxvt -e sh -c 'gnuradio-companion -h ; bash'" },
  { "gr-ctrlport-monitor", "urxvt -e sh -c 'gr-ctrlport-monitor ; bash'" },
  { "gr-perf-monitorx", "urxvt -e sh -c 'gr-perf-monitorx ; bash'" },
  { "gr_filter_design", "urxvt -e sh -c 'gr_filter_design ; bash'" },
  { "gr_modtool", "urxvt -e sh -c 'gr_modtool ; bash'" },
  { "gr_read_file_metadata", "urxvt -e sh -c 'gr_read_file_metadata ; bash'" },
  { "grc_setup_freedesktop", "urxvt -e sh -c 'grc_setup_freedesktop ; bash'" },
  { "grcc", "urxvt -e sh -c 'grcc ; bash'" },
  { "polar_channel_construction", "urxvt -e sh -c 'polar_channel_construction ; bash'" },
  { "uhd_fft", "urxvt -e sh -c 'uhd_fft ; bash'" },
  { "uhd_rx_cfile", "urxvt -e sh -c 'uhd_rx_cfile ; bash'" },
  { "uhd_rx_nogui", "urxvt -e sh -c 'uhd_rx_nogui ; bash'" },
  { "uhd_siggen", "urxvt -e sh -c 'uhd_siggen ; bash'" },
  { "uhd_siggen_gui", "urxvt -e sh -c 'uhd_siggen_gui ; bash'" },
  { "gqrx", "urxvt -e sh -c 'gqrx ; bash'" },
  { "gqrx-alsa", "urxvt -e sh -c 'gqrx-alsa ; bash'" },
  { "gqrx", "urxvt -e sh -c 'gqrx ; bash'" },
  { "gqrx-alsa", "urxvt -e sh -c 'gqrx-alsa ; bash'" },
  { "hcxdumptool", "urxvt -e sh -c 'hcxdumptool -h ; bash'" },
  { "hcxpioff", "urxvt -e sh -c 'hcxpioff -h ; bash'" },
  { "hcxdumptool", "urxvt -e sh -c 'hcxdumptool -h ; bash'" },
  { "hcxpioff", "urxvt -e sh -c 'hcxpioff -h ; bash'" },
  { "hcxeiutool", "urxvt -e sh -c 'hcxeiutool ; bash'" },
  { "hcxessidtool", "urxvt -e sh -c 'hcxessidtool ; bash'" },
  { "hcxmactool", "urxvt -e sh -c 'hcxmactool ; bash'" },
  { "hcxpmkidtool", "urxvt -e sh -c 'hcxpmkidtool ; bash'" },
  { "hcxpmktool", "urxvt -e sh -c 'hcxpmktool ; bash'" },
  { "hcxwltool", "urxvt -e sh -c 'hcxwltool ; bash'" },
  { "whoismac", "urxvt -e sh -c 'whoismac -h ; bash'" },
  { "wlancap2wpasec", "urxvt -e sh -c 'wlancap2wpasec ; bash'" },
  { "hcxeiutool", "urxvt -e sh -c 'hcxeiutool ; bash'" },
  { "hcxessidtool", "urxvt -e sh -c 'hcxessidtool ; bash'" },
  { "hcxmactool", "urxvt -e sh -c 'hcxmactool ; bash'" },
  { "hcxpmkidtool", "urxvt -e sh -c 'hcxpmkidtool ; bash'" },
  { "hcxpmktool", "urxvt -e sh -c 'hcxpmktool ; bash'" },
  { "hcxwltool", "urxvt -e sh -c 'hcxwltool ; bash'" },
  { "whoismac", "urxvt -e sh -c 'whoismac -h ; bash'" },
  { "wlancap2wpasec", "urxvt -e sh -c 'wlancap2wpasec ; bash'" },
  { "hoover", "urxvt -e sh -c 'hoover -h ; bash'" },
  { "hostapd-wpe", "urxvt -e sh -c 'hostapd-wpe ; bash'" },
  { "hostapd-wpe_cli", "urxvt -e sh -c 'hostapd-wpe_cli ; bash'" },
  { "hotspotter", "urxvt -e sh -c 'hotspotter ; bash'" },
  { "hubbit-sniffer", "urxvt -e sh -c 'hubbit-sniffer -h ; bash'" },
  { "hawk", "urxvt -e sh -c 'hawk --help ; bash'" },
  { "hwk-eagle", "urxvt -e sh -c 'hwk-eagle --help ; bash'" },
  { "jcrack", "urxvt -e sh -c 'jcrack ; bash'" },
  { "kbbootloader", "urxvt -e sh -c 'kbbootloader -h ; bash'" },
  { "zbassocflood", "urxvt -e sh -c 'zbassocflood -h ; bash'" },
  { "zbcat", "urxvt -e sh -c 'zbcat -h ; bash'" },
  { "zbconvert", "urxvt -e sh -c 'zbconvert -h ; bash'" },
  { "zbdsniff", "urxvt -e sh -c 'zbdsniff -h ; bash'" },
  { "zbdump", "urxvt -e sh -c 'zbdump -h ; bash'" },
  { "zbfakebeacon", "urxvt -e sh -c 'zbfakebeacon -h ; bash'" },
  { "zbgoodfind", "urxvt -e sh -c 'zbgoodfind -h ; bash'" },
  { "zbid", "urxvt -e sh -c 'zbid -h ; bash'" },
  { "zbjammer", "urxvt -e sh -c 'zbjammer -h ; bash'" },
  { "zbopenear", "urxvt -e sh -c 'zbopenear -h ; bash'" },
  { "zborphannotify", "urxvt -e sh -c 'zborphannotify -h ; bash'" },
  { "zbrealign", "urxvt -e sh -c 'zbrealign -h ; bash'" },
  { "zbstumbler", "urxvt -e sh -c 'zbstumbler -h ; bash'" },
  { "zbwardrive", "urxvt -e sh -c 'zbwardrive -h ; bash'" },
  { "kismet", "urxvt -e sh -c 'kismet -h ; bash'" },
  { "kismet_discovery", "urxvt -e sh -c 'kismet_discovery ; bash'" },
  { "kismet_server", "urxvt -e sh -c 'kismet_server -h ; bash'" },
  { "kismetdb_clean", "urxvt -e sh -c 'kismetdb_clean ; bash'" },
  { "kismetdb_dump_devices", "urxvt -e sh -c 'kismetdb_dump_devices ; bash'" },
  { "kismetdb_statistics", "urxvt -e sh -c 'kismetdb_statistics ; bash'" },
  { "kismetdb_strip_packets", "urxvt -e sh -c 'kismetdb_strip_packets ; bash'" },
  { "kismetdb_to_gpx", "urxvt -e sh -c 'kismetdb_to_gpx ; bash'" },
  { "kismetdb_to_kml", "urxvt -e sh -c 'kismetdb_to_kml ; bash'" },
  { "kismetdb_to_pcap", "urxvt -e sh -c 'kismetdb_to_pcap ; bash'" },
  { "kismetdb_to_wiglecsv", "urxvt -e sh -c 'kismetdb_to_wiglecsv ; bash'" },
  { "kismet", "urxvt -e sh -c 'kismet -h ; bash'" },
  { "kismet_discovery", "urxvt -e sh -c 'kismet_discovery ; bash'" },
  { "kismet_server", "urxvt -e sh -c 'kismet_server -h ; bash'" },
  { "kismetdb_clean", "urxvt -e sh -c 'kismetdb_clean ; bash'" },
  { "kismetdb_dump_devices", "urxvt -e sh -c 'kismetdb_dump_devices ; bash'" },
  { "kismetdb_statistics", "urxvt -e sh -c 'kismetdb_statistics ; bash'" },
  { "kismetdb_strip_packets", "urxvt -e sh -c 'kismetdb_strip_packets ; bash'" },
  { "kismetdb_to_gpx", "urxvt -e sh -c 'kismetdb_to_gpx ; bash'" },
  { "kismetdb_to_kml", "urxvt -e sh -c 'kismetdb_to_kml ; bash'" },
  { "kismetdb_to_pcap", "urxvt -e sh -c 'kismetdb_to_pcap ; bash'" },
  { "kismetdb_to_wiglecsv", "urxvt -e sh -c 'kismetdb_to_wiglecsv ; bash'" },
  { "db2ge", "urxvt -e sh -c 'db2ge -h ; bash'" },
  { "k2db", "urxvt -e sh -c 'k2db -h ; bash'" },
  { "kismon", "urxvt -e sh -c 'kismon ; bash'" },
  { "linset", "urxvt -e sh -c 'linset ; bash'" },
  { "mana-firelamb-view", "urxvt -e sh -c 'mana-firelamb-view ; bash'" },
  { "mana-nat-full", "urxvt -e sh -c 'mana-nat-full ; bash'" },
  { "mdk3", "urxvt -e sh -c 'mdk3 --help ; bash'" },
  { "mdk4", "urxvt -e sh -c 'mdk4 --help ; bash'" },
  { "mfcuk", "urxvt -e sh -c 'mfcuk ; bash'" },
  { "mfoc", "urxvt -e sh -c 'mfoc -h ; bash'" },
  { "mitmap", "urxvt -e sh -c 'mitmap -h ; bash'" },
  { "mousejack-nrf24-scanner", "urxvt -e sh -c 'mousejack-nrf24-scanner -h ; bash'" },
  { "mousejack-nrf24-sniffer", "urxvt -e sh -c 'mousejack-nrf24-sniffer -h ; bash'" },
  { "mtscan", "urxvt -e sh -c 'mtscan ; bash'" },
  { "netattack", "urxvt -e sh -c 'netattack -h ; bash'" },
  { "netdiscover", "urxvt -e sh -c 'netdiscover -h ; bash'" },
  { "nzyme", "urxvt -e sh -c 'nzyme ; bash'" },
  { "pidense", "urxvt -e sh -c 'pidense -h ; bash'" },
  { "pyrit", "urxvt -e sh -c 'pyrit -h ; bash'" },
  { "trackerjacker", "urxvt -e sh -c 'trackerjacker ; bash'" },
  { "reaver", "urxvt -e sh -c 'reaver ; bash'" },
  { "rfdump", "urxvt -e sh -c 'rfdump ; bash'" },
  { "rfidiot-ChAP", "urxvt -e sh -c 'rfidiot-ChAP -h ; bash'" },
  { "rfidiot-cardselect", "urxvt -e sh -c 'rfidiot-cardselect -h ; bash'" },
  { "rfidiot-demotag", "urxvt -e sh -c 'rfidiot-demotag -h ; bash'" },
  { "rfidiot-eeprom", "urxvt -e sh -c 'rfidiot-eeprom -h ; bash'" },
  { "rfidiot-fdxbnum", "urxvt -e sh -c 'rfidiot-fdxbnum -h ; bash'" },
  { "rfidiot-formatmifare1kvalue", "urxvt -e sh -c 'rfidiot-formatmifare1kvalue -h ; bash'" },
  { "rfidiot-froschtest", "urxvt -e sh -c 'rfidiot-froschtest -h ; bash'" },
  { "rfidiot-hidprox", "urxvt -e sh -c 'rfidiot-hidprox -h ; bash'" },
  { "rfidiot-hitag2brute", "urxvt -e sh -c 'rfidiot-hitag2brute -h ; bash'" },
  { "rfidiot-hitag2reset", "urxvt -e sh -c 'rfidiot-hitag2reset -h ; bash'" },
  { "rfidiot-isotype", "urxvt -e sh -c 'rfidiot-isotype -h ; bash'" },
  { "rfidiot-jcopmifare", "urxvt -e sh -c 'rfidiot-jcopmifare -h ; bash'" },
  { "rfidiot-jcoptool", "urxvt -e sh -c 'rfidiot-jcoptool -h ; bash'" },
  { "rfidiot-lfxtype", "urxvt -e sh -c 'rfidiot-lfxtype -h ; bash'" },
  { "rfidiot-loginall", "urxvt -e sh -c 'rfidiot-loginall -h ; bash'" },
  { "rfidiot-multiselect", "urxvt -e sh -c 'rfidiot-multiselect -h ; bash'" },
  { "rfidiot-pn532emulate", "urxvt -e sh -c 'rfidiot-pn532emulate -h ; bash'" },
  { "rfidiot-pn532mitm", "urxvt -e sh -c 'rfidiot-pn532mitm -h ; bash'" },
  { "rfidiot-q5reset", "urxvt -e sh -c 'rfidiot-q5reset -h ; bash'" },
  { "rfidiot-readlfx", "urxvt -e sh -c 'rfidiot-readlfx -h ; bash'" },
  { "rfidiot-readmifare1k", "urxvt -e sh -c 'rfidiot-readmifare1k -h ; bash'" },
  { "rfidiot-readmifareultra", "urxvt -e sh -c 'rfidiot-readmifareultra -h ; bash'" },
  { "rfidiot-readtag", "urxvt -e sh -c 'rfidiot-readtag -h ; bash'" },
  { "rfidiot-rfidiot-cli", "urxvt -e sh -c 'rfidiot-rfidiot-cli -h ; bash'" },
  { "rfidiot-send-apdu", "urxvt -e sh -c 'rfidiot-send-apdu -h ; bash'" },
  { "rfidiot-sod", "urxvt -e sh -c 'rfidiot-sod ; bash'" },
  { "rfidiot-transit", "urxvt -e sh -c 'rfidiot-transit -h ; bash'" },
  { "rfidiot-unique", "urxvt -e sh -c 'rfidiot-unique -h ; bash'" },
  { "rfidiot-writelfx", "urxvt -e sh -c 'rfidiot-writelfx -h ; bash'" },
  { "rfidiot-writemifare1k", "urxvt -e sh -c 'rfidiot-writemifare1k -h ; bash'" },
  { "rfidtool", "urxvt -e sh -c 'rfidtool ; bash'" },
  { "roguehostapd", "urxvt -e sh -c 'roguehostapd -h ; bash'" },
  { "probequest", "urxvt -e sh -c 'probequest ; bash'" },
  { "spectool_curses", "urxvt -e sh -c 'spectool_curses -h ; bash'" },
  { "spectool_gtk", "urxvt -e sh -c 'spectool_gtk ; bash'" },
  { "spectool_net", "urxvt -e sh -c 'spectool_net -h ; bash'" },
  { "spectool_raw", "urxvt -e sh -c 'spectool_raw -h ; bash'" },
  { "speedport-arcadyan", "urxvt -e sh -c 'speedport-arcadyan ; bash'" },
  { "speedpwn", "urxvt -e sh -c 'speedpwn -h ; bash'" },
  { "timegen", "urxvt -e sh -c 'timegen -h ; bash'" },
  { "ubitack", "urxvt -e sh -c 'ubitack -h ; bash'" },
  { "ufo-wardriving", "urxvt -e sh -c 'ufo-wardriving ; bash'" },
  { "wavemon", "urxvt -e sh -c 'wavemon -h ; bash'" },
  { "wepbuster", "urxvt -e sh -c 'wepbuster --help ; bash'" },
  { "wi-feye", "urxvt -e sh -c 'wi-feye -h ; bash'" },
  { "wifi-autopwner", "urxvt -e sh -c 'wifi-autopwner -h ; bash'" },
  { "wifi-honey", "urxvt -e sh -c 'wifi-honey -h ; bash'" },
  { "captiveflask", "urxvt -e sh -c 'captiveflask ; bash'" },
  { "sslstrip3", "urxvt -e sh -c 'sslstrip3 ; bash'" },
  { "wifi-pumpkin", "urxvt -e sh -c 'wifi-pumpkin ; bash'" },
  { "wifibroot", "urxvt -e sh -c 'wifibroot -h ; bash'" },
  { "wificurse", "urxvt -e sh -c 'wificurse -h ; bash'" },
  { "wifijammer", "urxvt -e sh -c 'wifijammer -h ; bash'" },
  { "wifiscanmap", "urxvt -e sh -c 'wifiscanmap -h ; bash'" },
  { "wifiarp", "urxvt -e sh -c 'wifiarp -h ; bash'" },
  { "wifidns", "urxvt -e sh -c 'wifidns ; bash'" },
  { "wifiping", "urxvt -e sh -c 'wifiping ; bash'" },
  { "wifitap", "urxvt -e sh -c 'wifitap ; bash'" },
  { "wifite", "urxvt -e sh -c 'wifite ; bash'" },
  { "wireless-ids", "urxvt -e sh -c 'wireless-ids -h ; bash'" },
  { "wlan2eth", "urxvt -e sh -c 'wlan2eth -h ; bash'" },
  { "wpa-bruteforcer", "urxvt -e sh -c 'wpa-bruteforcer ; bash'" },
  { "zizzania", "urxvt -e sh -c 'zizzania ; bash'" },
  { "zulu", "urxvt -e sh -c 'zulu ; bash'" },
}

blackarchmenu = {
  { "anti-forensic", antiforensicmenu },
  { "automation", automationmenu },
  { "automobile", automobilemenu },
  { "backdoor", backdoormenu },
  { "binary", binarymenu },
  { "bluetooth", bluetoothmenu },
  { "code-audit", codeauditmenu },
  { "config", configmenu },
  { "cracker", crackermenu },
  { "crypto", cryptomenu },
  { "database", databasemenu },
  { "debugger", debuggermenu },
  { "decompiler", decompilermenu },
  { "defensive", defensivemenu },
  { "disassembler", disassemblermenu },
  { "dos", dosmenu },
  { "drone", dronemenu },
  { "exploitation", exploitationmenu },
  { "fingerprint", fingerprintmenu },
  { "firmware", firmwaremenu },
  { "forensic", forensicmenu },
  { "fuzzer", fuzzermenu },
  { "hardware", hardwaremenu },
  { "honeypot", honeypotmenu },
  { "ids", idsmenu },
  { "keylogger", keyloggermenu },
  { "malware", malwaremenu },
  { "misc", miscmenu },
  { "mobile", mobilemenu },
  { "networking", networkingmenu },
  { "nfc", nfcmenu },
  { "packer", packermenu },
  { "proxy", proxymenu },
  { "radio", radiomenu },
  { "recon", reconmenu },
  { "reversing", reversingmenu },
  { "scanner", scannermenu },
  { "scanners", scannersmenu },
  { "sniffer", sniffermenu },
  { "social", socialmenu },
  { "spoof", spoofmenu },
  { "stego", stegomenu },
  { "tunnel", tunnelmenu },
  { "unpacker", unpackermenu },
  { "voip", voipmenu },
  { "webapp", webappmenu },
  { "windows", windowsmenu },
  { "wireless", wirelessmenu },
}

mymainmenu = awful.menu({
items = {
		{ "awesome", myawesomemenu, beautiful.awesome_icon },
		{ "terminals", termmenu },
		{ "browsers", browsermenu },
    { "network", networkmenu },
    { "blackarch", blackarchmenu }
	}
})

mylauncher = awful.widget.launcher({ image = beautiful.awesome_icon,
                                     menu = mymainmenu })

-- Menubar configuration
menubar.utils.terminal = terminal -- Set the terminal for applications that require it
-- }}}

-- {{{ Wibox
-- Create a textclock widget
mytextclock = awful.widget.textclock()

-- Create a wibox for each screen and add it
mywibox = {}
mypromptbox = {}
mylayoutbox = {}
mytaglist = {}
mytaglist.buttons = awful.util.table.join(
                    awful.button({ }, 1, awful.tag.viewonly),
                    awful.button({ modkey }, 1, awful.client.movetotag),
                    awful.button({ }, 3, awful.tag.viewtoggle),
                    awful.button({ modkey }, 3, awful.client.toggletag),
                    awful.button({ }, 4, function(t) awful.tag.viewnext(awful.tag.getscreen(t)) end),
                    awful.button({ }, 5, function(t) awful.tag.viewprev(awful.tag.getscreen(t)) end)
                    )
mytasklist = {}
mytasklist.buttons = awful.util.table.join(
                     awful.button({ }, 1, function (c)
                                              if c == client.focus then
                                                  c.minimized = true
                                              else
                                                  -- Without this, the following
                                                  -- :isvisible() makes no sense
                                                  c.minimized = false
                                                  if not c:isvisible() then
                                                      awful.tag.viewonly(c:tags()[1])
                                                  end
                                                  -- This will also un-minimize
                                                  -- the client, if needed
                                                  client.focus = c
                                                  c:raise()
                                              end
                                          end),
                     awful.button({ }, 3, function ()
                                              if instance then
                                                  instance:hide()
                                                  instance = nil
                                              else
                                                  instance = awful.menu.clients({ width=250 })
                                              end
                                          end),
                     awful.button({ }, 4, function ()
                                              awful.client.focus.byidx(1)
                                              if client.focus then client.focus:raise() end
                                          end),
                     awful.button({ }, 5, function ()
                                              awful.client.focus.byidx(-1)
                                              if client.focus then client.focus:raise() end
                                          end))

for s = 1, screen.count() do
    -- Create a promptbox for each screen
    mypromptbox[s] = awful.widget.prompt()
    -- Create an imagebox widget which will contains an icon indicating which layout we're using.
    -- We need one layoutbox per screen.
    mylayoutbox[s] = awful.widget.layoutbox(s)
    mylayoutbox[s]:buttons(awful.util.table.join(
                           awful.button({ }, 1, function () awful.layout.inc(layouts, 1) end),
                           awful.button({ }, 3, function () awful.layout.inc(layouts, -1) end),
                           awful.button({ }, 4, function () awful.layout.inc(layouts, 1) end),
                           awful.button({ }, 5, function () awful.layout.inc(layouts, -1) end)))
    -- Create a taglist widget
    mytaglist[s] = awful.widget.taglist(s, awful.widget.taglist.filter.all, mytaglist.buttons)

    -- Create a tasklist widget
    mytasklist[s] = awful.widget.tasklist(s, awful.widget.tasklist.filter.currenttags, mytasklist.buttons)

    -- Create the wibox
    mywibox[s] = awful.wibox({ position = "top", screen = s })

    -- Widgets that are aligned to the left
    local left_layout = wibox.layout.fixed.horizontal()
    left_layout:add(mylauncher)
    left_layout:add(mytaglist[s])
    left_layout:add(mypromptbox[s])

    -- Widgets that are aligned to the right
    local right_layout = wibox.layout.fixed.horizontal()
    if s == 1 then right_layout:add(wibox.widget.systray()) end
    right_layout:add(mytextclock)
    right_layout:add(mylayoutbox[s])

    -- Now bring it all together (with the tasklist in the middle)
    local layout = wibox.layout.align.horizontal()
    layout:set_left(left_layout)
    layout:set_middle(mytasklist[s])
    layout:set_right(right_layout)

    mywibox[s]:set_widget(layout)
end
-- }}}

-- {{{ Mouse bindings
root.buttons(awful.util.table.join(
    awful.button({ }, 3, function () mymainmenu:toggle() end),
    awful.button({ }, 4, awful.tag.viewnext),
    awful.button({ }, 5, awful.tag.viewprev)
))
-- }}}

-- {{{ Key bindings
globalkeys = awful.util.table.join(
    awful.key({ modkey,           }, "Left",   awful.tag.viewprev       ),
    awful.key({ modkey,           }, "Right",  awful.tag.viewnext       ),
    awful.key({ modkey,           }, "Escape", awful.tag.history.restore),

    awful.key({ modkey,           }, "j",
        function ()
            awful.client.focus.byidx( 1)
            if client.focus then client.focus:raise() end
        end),
    awful.key({ modkey,           }, "k",
        function ()
            awful.client.focus.byidx(-1)
            if client.focus then client.focus:raise() end
        end),
    awful.key({ modkey,           }, "w", function () mymainmenu:show() end),

    -- Layout manipulation
    awful.key({ modkey, "Shift"   }, "j", function () awful.client.swap.byidx(  1)    end),
    awful.key({ modkey, "Shift"   }, "k", function () awful.client.swap.byidx( -1)    end),
    awful.key({ modkey, "Control" }, "j", function () awful.screen.focus_relative( 1) end),
    awful.key({ modkey, "Control" }, "k", function () awful.screen.focus_relative(-1) end),
    awful.key({ modkey,           }, "u", awful.client.urgent.jumpto),
    awful.key({ modkey,           }, "Tab",
        function ()
            awful.client.focus.history.previous()
            if client.focus then
                client.focus:raise()
            end
        end),

    -- Standard program
    awful.key({ modkey,           }, "Return", function () awful.util.spawn(terminal) end),
    awful.key({ modkey, "Control" }, "r", awesome.restart),
    awful.key({ modkey, "Shift"   }, "q", awesome.quit),

    awful.key({ modkey,           }, "l",     function () awful.tag.incmwfact( 0.05)    end),
    awful.key({ modkey,           }, "h",     function () awful.tag.incmwfact(-0.05)    end),
    awful.key({ modkey, "Shift"   }, "h",     function () awful.tag.incnmaster( 1)      end),
    awful.key({ modkey, "Shift"   }, "l",     function () awful.tag.incnmaster(-1)      end),
    awful.key({ modkey, "Control" }, "h",     function () awful.tag.incncol( 1)         end),
    awful.key({ modkey, "Control" }, "l",     function () awful.tag.incncol(-1)         end),
    awful.key({ modkey,           }, "space", function () awful.layout.inc(layouts,  1) end),
    awful.key({ modkey, "Shift"   }, "space", function () awful.layout.inc(layouts, -1) end),

    awful.key({ modkey, "Control" }, "n", awful.client.restore),

    -- Prompt
    awful.key({ modkey },            "r",     function () mypromptbox[mouse.screen.index]:run() end),

    awful.key({ modkey }, "x",
              function ()
                  awful.prompt.run({ prompt = "Run Lua code: " },
                  mypromptbox[mouse.screen].widget,
                  awful.util.eval, nil,
                  awful.util.getdir("cache") .. "/history_eval")
              end),
    -- Menubar
    awful.key({ modkey }, "p", function() menubar.show() end)
)

clientkeys = awful.util.table.join(
    awful.key({ modkey,           }, "f",      function (c) c.fullscreen = not c.fullscreen  end),
    awful.key({ modkey, "Shift"   }, "c",      function (c) c:kill()                         end),
    awful.key({ modkey, "Control" }, "space",  awful.client.floating.toggle                     ),
    awful.key({ modkey, "Control" }, "Return", function (c) c:swap(awful.client.getmaster()) end),
    awful.key({ modkey,           }, "o",      awful.client.movetoscreen                        ),
    awful.key({ modkey,           }, "t",      function (c) c.ontop = not c.ontop            end),
    awful.key({ modkey,           }, "n",
        function (c)
            -- The client currently has the input focus, so it cannot be
            -- minimized, since minimized clients can't have the focus.
            c.minimized = true
        end),
    awful.key({ modkey,           }, "m",
        function (c)
            c.maximized_horizontal = not c.maximized_horizontal
            c.maximized_vertical   = not c.maximized_vertical
        end)
)

-- Bind all key numbers to tags.
-- Be careful: we use keycodes to make it works on any keyboard layout.
-- This should map on the top row of your keyboard, usually 1 to 9.
for i = 1, 9 do
    globalkeys = awful.util.table.join(globalkeys,
        awful.key({ modkey }, "#" .. i + 9,
                  function ()
                        local screen = mouse.screen
                        local tag = awful.tag.gettags(screen)[i]
                        if tag then
                           awful.tag.viewonly(tag)
                        end
                  end),
        awful.key({ modkey, "Control" }, "#" .. i + 9,
                  function ()
                      local screen = mouse.screen
                      local tag = awful.tag.gettags(screen)[i]
                      if tag then
                         awful.tag.viewtoggle(tag)
                      end
                  end),
        awful.key({ modkey, "Shift" }, "#" .. i + 9,
                  function ()
                      if client.focus then
                          local tag = awful.tag.gettags(client.focus.screen)[i]
                          if tag then
                              awful.client.movetotag(tag)
                          end
                     end
                  end),
        awful.key({ modkey, "Control", "Shift" }, "#" .. i + 9,
                  function ()
                      if client.focus then
                          local tag = awful.tag.gettags(client.focus.screen)[i]
                          if tag then
                              awful.client.toggletag(tag)
                          end
                      end
                  end))
end

clientbuttons = awful.util.table.join(
    awful.button({ }, 1, function (c) client.focus = c; c:raise() end),
    awful.button({ modkey }, 1, awful.mouse.client.move),
    awful.button({ modkey }, 3, awful.mouse.client.resize))

-- Set keys
root.keys(globalkeys)
-- }}}

-- {{{ Rules
awful.rules.rules = {
    -- All clients will match this rule.
    { rule = { },
      properties = { border_width = beautiful.border_width,
                     border_color = beautiful.border_normal,
                     focus = awful.client.focus.filter,
                     keys = clientkeys,
                     buttons = clientbuttons } },
    { rule = { class = "MPlayer" },
      properties = { floating = true } },
    { rule = { class = "pinentry" },
      properties = { floating = true } },
    { rule = { class = "gimp" },
      properties = { floating = true } },
    -- Set Firefox to always map on tags number 2 of screen 1.
    -- { rule = { class = "Firefox" },
    --   properties = { tag = tags[1][2] } },
}
-- }}}

-- {{{ Signals
-- Signal function to execute when a new client appears.
client.connect_signal("manage", function (c, startup)
    -- Enable sloppy focus
    c:connect_signal("mouse::enter", function(c)
        if awful.layout.get(c.screen) ~= awful.layout.suit.magnifier
            and awful.client.focus.filter(c) then
            client.focus = c
        end
    end)

    if not startup then
        -- Set the windows at the slave,
        -- i.e. put it at the end of others instead of setting it master.
        -- awful.client.setslave(c)

        -- Put windows in a smart way, only if they does not set an initial position.
        if not c.size_hints.user_position and not c.size_hints.program_position then
            awful.placement.no_overlap(c)
            awful.placement.no_offscreen(c)
        end
    end

    local titlebars_enabled = false
    if titlebars_enabled and (c.type == "normal" or c.type == "dialog") then
        -- buttons for the titlebar
        local buttons = awful.util.table.join(
                awful.button({ }, 1, function()
                    client.focus = c
                    c:raise()
                    awful.mouse.client.move(c)
                end),
                awful.button({ }, 3, function()
                    client.focus = c
                    c:raise()
                    awful.mouse.client.resize(c)
                end)
                )

        -- Widgets that are aligned to the left
        local left_layout = wibox.layout.fixed.horizontal()
        left_layout:add(awful.titlebar.widget.iconwidget(c))
        left_layout:buttons(buttons)

        -- Widgets that are aligned to the right
        local right_layout = wibox.layout.fixed.horizontal()
        right_layout:add(awful.titlebar.widget.floatingbutton(c))
        right_layout:add(awful.titlebar.widget.maximizedbutton(c))
        right_layout:add(awful.titlebar.widget.stickybutton(c))
        right_layout:add(awful.titlebar.widget.ontopbutton(c))
        right_layout:add(awful.titlebar.widget.closebutton(c))

        -- The title goes in the middle
        local middle_layout = wibox.layout.flex.horizontal()
        local title = awful.titlebar.widget.titlewidget(c)
        title:set_align("center")
        middle_layout:add(title)
        middle_layout:buttons(buttons)

        -- Now bring it all together
        local layout = wibox.layout.align.horizontal()
        layout:set_left(left_layout)
        layout:set_right(right_layout)
        layout:set_middle(middle_layout)

        awful.titlebar(c):set_widget(layout)
    end
end)

client.connect_signal("focus", function(c) c.border_color = beautiful.border_focus end)
client.connect_signal("unfocus", function(c) c.border_color = beautiful.border_normal end)
-- }}}
