/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.enumeration;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import nb.barmie.modes.attack.RMIAttackFactory;
import nb.barmie.modes.enumeration.EnumerationTask;
import nb.barmie.modes.enumeration.RMIEnumerator;
import nb.barmie.net.TCPEndpoint;
import nb.barmie.util.ProgramOptions;

public class EnumerationMode {
    private ProgramOptions _opts;

    public EnumerationMode(ProgramOptions options) {
        this._opts = options;
    }

    public void run() {
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)Executors.newFixedThreadPool(this._opts.getThreadCount());
        ArrayList<TCPEndpoint> targets = this._opts.getTargets();
        RMIEnumerator rmie = new RMIEnumerator(this._opts);
        RMIAttackFactory.setProgramOptions(this._opts);
        System.out.println("Scanning " + targets.size() + " target(s) for objects exposed via an RMI registry...");
        System.out.println("");
        for (TCPEndpoint t : targets) {
            tpe.execute(new EnumerationTask(t, rmie, this._opts));
        }
        tpe.shutdown();
        while (!tpe.isTerminated()) {
        }
        System.out.println("Successfully scanned " + targets.size() + " target(s) for objects exposed via RMI.");
        RMIAttackFactory.cleanUp();
    }
}

