
<p align="center">
  <img src="./.github/img/banner.png">
  <br/>
  <a href="https://github.com/EgeBalci/amber">
    <img src="https://img.shields.io/badge/version-3.2.0-green.svg?style=flat-square">
  </a>
  <a href="https://goreportcard.com/report/github.com/egebalci/amber">
    <img src="https://goreportcard.com/badge/github.com/egebalci/amber?style=flat-square">
  </a>
  <a href="https://github.com/EgeBalci/amber/issues">
    <img src="https://img.shields.io/github/issues/egebalci/amber?style=flat-square&color=red">
  </a>
  <a href="https://raw.githubusercontent.com/EgeBalci/sgn/master/LICENSE">
    <img src="https://img.shields.io/github/license/egebalci/amber.svg?style=flat-square">
  </a>
  <a href="https://twitter.com/egeblc">
    <img src="https://img.shields.io/badge/twitter-@egeblc-55acee.svg?style=flat-square">
  </a>
</p>

# Inroduction

Amber is a position-independent(reflective) PE loader that enables in-memory execution of native PE files(EXE, DLL, SYS...). It enables stealthy in-memory payload deployment that can be used to bypass anti-virus, firewall, IDS, IPS products, and application white-listing mitigations. Reflective payloads generated by Amber can either be staged from a remote server or executed directly in memory much like a generic shellcode. By default, every generated payload is encoded using the new generation [SGN encoder](https://github.com/EgeBalci/sgn). Amber uses [CRC32_API](https://github.com/EgeBalci/crc32_api) and [IAT_API](https://github.com/EgeBalci/iat_api) for inconspicuously resolving the Windows API function addresses. After the PE file is loaded and executed in memory, the reflective payload is erased for evading memory scanners. 

# Installation
Pre-compiled binaries can be found under [releases](https://github.com/EgeBalci/amber/releases).

***Building From Source***

The only dependency for building the source is the [keystone engine](https://github.com/keystone-engine/keystone), follow [these](https://github.com/keystone-engine/keystone/blob/master/docs/COMPILE.md) instructions for installing the library. Once libkeystone is installed on the system, simply just go get it ツ

```
go install github.com/EgeBalci/amber@latest
```

***Docker Install***

[![Docker](http://dockeri.co/image/egee/amber)](https://hub.docker.com/r/egee/amber/)

```
docker pull egee/amber
docker run -it egee/amber
```

# Usage

<p align="center">
  <img src="./.github/img/usage.gif">
</p>

The following table lists switches supported by the amber.

<table border="1">
  <tr>
    <th>Switch</th>
    <th>Type</th>
    <th>Description</th>
  </tr>

  <tr>
    <td><strong>-f,--file</strong></td>
    <td><var>string</var></td>
    <td>Input PE file.</td>
  </tr>

  <tr>
    <td><strong>-o,--out</strong></td>
    <td><var>string</var></td>
    <td>Output binary payload file name.</td>
  </tr>

  <tr>
    <td><strong>-e</strong></td>
    <td><var>int</var></td>
    <td>Number of times to encode the generated reflective payload</td>
  </tr> 
  
  <tr>
    <td><strong>--iat</strong></td>
    <td><var>bool</var></td>
    <td>Use IAT API resolver block instead of CRC API resolver block</td>
  </tr>
  
  <tr>
    <td><strong>-l</strong></td>
    <td><var>int</var></td>
    <td>Maximum number of bytes for obfuscation (default 5)</td>
  </tr>  

  <tr>
    <td><strong>--sys</strong></td>
    <td><var>bool</var></td>
    <td>Perform raw syscalls. (only x64)</td>
  </tr>  

  <tr>
    <td><strong>--scrape</strong></td>
    <td><var>bool</var></td>
    <td>Scrape magic byte and DOS stub from PE.</td>
  </tr>  
  
</table>


**Example Usage**

- Generate reflective payload.
```
amber -f test.exe
```
- Generate reflective payload with IAT API resolver and encode the final payload 10 times.
```
amber -e 10 --iat -f test.exe
``` 

***Docker Usage***
```
docker run -it -v /tmp/:/tmp/ amber -f /tmp/file.exe
```

# Demo

- [NOPcon 2018 DEMO](https://www.youtube.com/watch?v=lCPdKSH6RMc)
- [Pentest.blog - Deploying Reflective PE Files With Metasploit](https://www.youtube.com/watch?v=3en0ftnjEpE)
- [Pentest.blog - Deploying Reflective Ransomware POC](https://www.youtube.com/watch?v=JVv_spX6D4U)