/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.SoapUITreeNodeRenderer;
import com.eviware.soapui.model.tree.nodes.ProjectTreeNode;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIMultiAction;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.NavigatorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Navigator
extends JPanel {
    private Workspace workspace;
    private JTree mainTree;
    private SoapUITreeModel treeModel;
    private Set<NavigatorListener> listeners = new HashSet<NavigatorListener>();

    public Navigator(Workspace workspace) {
        super(new BorderLayout());
        this.workspace = workspace;
        this.buildUI();
    }

    private void buildUI() {
        this.treeModel = new SoapUITreeModel(this.workspace);
        this.mainTree = new NavigatorTree(this.treeModel);
        this.mainTree.setRootVisible(true);
        this.mainTree.setExpandsSelectedPaths(true);
        this.mainTree.setScrollsOnExpand(true);
        this.mainTree.setToggleClickCount(0);
        this.mainTree.addMouseListener(new TreeMouseListener());
        this.mainTree.addTreeSelectionListener(new InternalTreeSelectionListener());
        this.mainTree.setCellRenderer(new SoapUITreeNodeRenderer());
        this.mainTree.setBorder(null);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.addKeyListener(new TreeKeyListener());
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        this.add((Component)new JScrollPane(this.mainTree), "Center");
        this.add(this.buildToolbar(), "North");
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        JToggleButton toggleButton = new JToggleButton(new TogglePropertiesAction());
        toggleButton.setToolTipText("Toggles displaying of Test Properties in tree");
        toggleButton.setSize(10, 12);
        toolbar.addFixed(toggleButton);
        toolbar.addGlue();
        return toolbar;
    }

    public Project getCurrentProject() {
        TreePath path = this.mainTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        while (node != null && !(node instanceof ProjectTreeNode)) {
            node = (path = path.getParentPath()) == null ? null : path.getLastPathComponent();
        }
        if (node == null) {
            return null;
        }
        return ((ProjectTreeNode)node).getProject();
    }

    public void addNavigatorListener(NavigatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeNavigatorListener(NavigatorListener listener) {
        this.listeners.remove(listener);
    }

    public void selectModelItem(ModelItem modelItem) {
        TreePath path = this.treeModel.getPath(modelItem);
        this.mainTree.setSelectionPath(path);
        this.mainTree.expandPath(path);
        this.mainTree.scrollPathToVisible(path);
    }

    public TreePath getTreePath(ModelItem modelItem) {
        return this.treeModel.getPath(modelItem);
    }

    public JTree getMainTree() {
        return this.mainTree;
    }

    public ModelItem getSelectedItem() {
        TreePath path = this.mainTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return ((SoapUITreeNode)path.getLastPathComponent()).getModelItem();
    }

    public boolean isVisible(TreePath path) {
        return this.mainTree.isVisible(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.mainTree.isExpanded(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MultiActionInvoker
    extends AbstractAction {
        private final SoapUIMultiAction action;
        private final List<ModelItem> targets;

        public MultiActionInvoker(SoapUIMultiAction action, List<ModelItem> targets) {
            super(action.getName());
            this.action = action;
            this.targets = targets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.perform(this.targets.toArray(new ModelItem[this.targets.size()]), (Object)null);
        }
    }

    private class TogglePropertiesAction
    extends AbstractAction {
        public TogglePropertiesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_properties.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            Enumeration<TreePath> expandedDescendants = Navigator.this.mainTree.getExpandedDescendants(Navigator.this.getTreePath(Navigator.this.workspace));
            TreePath selectionPath = Navigator.this.mainTree.getSelectionPath();
            Navigator.this.treeModel.setShowProperties(!Navigator.this.treeModel.isShowProperties());
            while (expandedDescendants != null && expandedDescendants.hasMoreElements()) {
                Navigator.this.mainTree.expandPath(expandedDescendants.nextElement());
            }
            if (selectionPath != null) {
                Navigator.this.mainTree.setSelectionPath(selectionPath);
            }
        }
    }

    public class TreeMouseListener
    extends MouseAdapter {
        private ActionList actions;

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else if (e.getClickCount() < 2) {
                return;
            }
            if (Navigator.this.mainTree.getSelectionCount() == 1) {
                int row = Navigator.this.mainTree.getRowForLocation(e.getX(), e.getY());
                TreePath path = Navigator.this.mainTree.getSelectionPath();
                if (path == null && row == -1) {
                    return;
                }
                if (path == null || Navigator.this.mainTree.getRowForPath(path) != row) {
                    Navigator.this.mainTree.setSelectionRow(row);
                }
                SoapUITreeNode node = (SoapUITreeNode)path.getLastPathComponent();
                this.actions = node.getActions();
                if (this.actions != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (TreeMouseListener.this.actions != null) {
                                TreeMouseListener.this.actions.performDefaultAction(new ActionEvent(Navigator.this.mainTree, 0, null));
                                TreeMouseListener.this.actions = null;
                            }
                        }
                    });
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            if (Navigator.this.mainTree.getSelectionCount() < 2) {
                TreePath path = Navigator.this.mainTree.getPathForLocation((int)e.getPoint().getX(), (int)e.getPoint().getY());
                if (path == null) {
                    int row = (int)e.getPoint().getY() / Navigator.this.mainTree.getRowHeight();
                    if (row != -1) {
                        JPopupMenu collapsePopup = new JPopupMenu();
                        collapsePopup.add("Collapse").addActionListener(new CollapseRowAction(row));
                        collapsePopup.add("Expand").addActionListener(new ExpandRowAction(row));
                        collapsePopup.show(Navigator.this.mainTree, e.getX(), e.getY());
                    }
                    return;
                }
                SoapUITreeNode node = (SoapUITreeNode)path.getLastPathComponent();
                JPopupMenu popupMenu = node.getPopup();
                if (popupMenu == null) {
                    return;
                }
                Navigator.this.mainTree.setSelectionPath(path);
                popupMenu.show(Navigator.this.mainTree, e.getX(), e.getY());
            } else {
                ActionList actions;
                TreePath[] selectionPaths = Navigator.this.mainTree.getSelectionPaths();
                ArrayList<ModelItem> targets = new ArrayList<ModelItem>();
                for (TreePath treePath : selectionPaths) {
                    SoapUITreeNode node = (SoapUITreeNode)treePath.getLastPathComponent();
                    targets.add(node.getModelItem());
                }
                if (targets.size() > 0 && (actions = ActionListBuilder.buildMultiActions(targets.toArray(new ModelItem[targets.size()]))).getActionCount() > 0) {
                    JPopupMenu popup = new JPopupMenu();
                    ActionSupport.addActions(actions, popup);
                    popup.show(Navigator.this.mainTree, e.getX(), e.getY());
                }
            }
        }

        private final class ExpandRowAction
        extends AbstractAction {
            private final int row;

            public ExpandRowAction(int row) {
                this.row = row;
            }

            public void actionPerformed(ActionEvent e) {
                Navigator.this.mainTree.expandRow(this.row);
                this.expandAll(Navigator.this.mainTree.getPathForRow(this.row));
            }

            private void expandAll(TreePath tp) {
                if (tp == null) {
                    return;
                }
                Object node = tp.getLastPathComponent();
                TreeModel model = Navigator.this.mainTree.getModel();
                if (!model.isLeaf(node)) {
                    Navigator.this.mainTree.expandPath(tp);
                    for (int i = 0; i < model.getChildCount(node); ++i) {
                        this.expandAll(tp.pathByAddingChild(model.getChild(node, i)));
                    }
                }
            }
        }

        private final class CollapseRowAction
        extends AbstractAction {
            private final int row;

            public CollapseRowAction(int row) {
                this.row = row;
            }

            public void actionPerformed(ActionEvent e) {
                this.collapseAll(Navigator.this.mainTree.getPathForRow(this.row));
                Navigator.this.mainTree.collapseRow(this.row);
            }

            private void collapseAll(TreePath tp) {
                if (tp == null) {
                    return;
                }
                Object node = tp.getLastPathComponent();
                TreeModel model = Navigator.this.mainTree.getModel();
                if (!model.isLeaf(node)) {
                    Navigator.this.mainTree.collapsePath(tp);
                    for (int i = 0; i < model.getChildCount(node); ++i) {
                        this.collapseAll(tp.pathByAddingChild(model.getChild(node, i)));
                    }
                    Navigator.this.mainTree.collapsePath(tp);
                }
            }
        }
    }

    public class InternalTreeSelectionListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            Object obj = e.getPath().getLastPathComponent();
            if (obj instanceof SoapUITreeNode) {
                SoapUITreeNode treeNode = (SoapUITreeNode)obj;
                if (!Navigator.this.listeners.isEmpty()) {
                    NavigatorListener[] array;
                    TreePath newPath = e.getNewLeadSelectionPath();
                    for (NavigatorListener listener : array = Navigator.this.listeners.toArray(new NavigatorListener[Navigator.this.listeners.size()])) {
                        listener.nodeSelected(newPath == null ? null : treeNode);
                    }
                }
            }
        }
    }

    private final class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            TreePath selectionPath = Navigator.this.mainTree.getSelectionPath();
            if (selectionPath == null || Navigator.this.mainTree.getSelectionCount() == 0) {
                return;
            }
            if (Navigator.this.mainTree.getSelectionCount() == 1) {
                SoapUITreeNode lastPathComponent = (SoapUITreeNode)selectionPath.getLastPathComponent();
                ActionList actions = lastPathComponent.getActions();
                if (actions != null) {
                    actions.dispatchKeyEvent(e);
                }
                if (!e.isConsumed()) {
                    KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                    if (ks.equals(UISupport.getKeyStroke("alt C"))) {
                        Navigator.this.mainTree.collapsePath(selectionPath);
                        e.consume();
                    } else if (ks.equals(UISupport.getKeyStroke("alt E"))) {
                        Navigator.this.mainTree.collapsePath(selectionPath);
                        int row = Navigator.this.mainTree.getSelectionRows()[0];
                        TreePath nextPath = Navigator.this.mainTree.getPathForRow(row + 1);
                        TreePath path = Navigator.this.mainTree.getPathForRow(row);
                        while (path != null && !path.equals(nextPath)) {
                            Navigator.this.mainTree.expandRow(row);
                            path = Navigator.this.mainTree.getPathForRow(++row);
                        }
                        e.consume();
                    }
                }
            } else {
                ActionList actions;
                TreePath[] selectionPaths = Navigator.this.mainTree.getSelectionPaths();
                ArrayList<ModelItem> targets = new ArrayList<ModelItem>();
                for (TreePath treePath : selectionPaths) {
                    SoapUITreeNode node = (SoapUITreeNode)treePath.getLastPathComponent();
                    targets.add(node.getModelItem());
                }
                if (targets.size() > 0 && (actions = ActionListBuilder.buildMultiActions(targets.toArray(new ModelItem[targets.size()]))).getActionCount() > 0) {
                    actions.dispatchKeyEvent(e);
                }
            }
        }
    }

    private static class NavigatorTree
    extends JTree
    implements Autoscroll {
        private static final int AUTOSCROLL_MARGIN = 12;

        public NavigatorTree(SoapUITreeModel treeModel) {
            super(treeModel);
        }

        public void autoscroll(Point pt) {
            int nRow = this.getRowForLocation(pt.x, pt.y);
            if (nRow < 0) {
                return;
            }
            Rectangle raOuter = this.getBounds();
            nRow = pt.y + raOuter.y <= 12 ? (nRow <= 0 ? 0 : nRow - 1) : (nRow < this.getRowCount() - 1 ? nRow + 1 : nRow);
            this.scrollRowToVisible(nRow);
        }

        public Insets getAutoscrollInsets() {
            Rectangle raOuter = this.getBounds();
            Rectangle raInner = this.getParent().getBounds();
            return new Insets(raInner.y - raOuter.y + 12, raInner.x - raOuter.x + 12, raOuter.height - raInner.height - raInner.y + raOuter.y + 12, raOuter.width - raInner.width - raInner.x + raOuter.x + 12);
        }
    }
}

