/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui;

import com.eviware.soapui.ui.desktop.DesktopListener;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDesktopPanelsList
extends JPanel {
    private DefaultListModel desktopPanels;
    private JList desktopPanelsList;
    private SoapUIDesktop desktop;
    private DesktopPanelPropertyChangeListener desktopPanelPropertyListener = new DesktopPanelPropertyChangeListener();
    private InternalDesktopListener desktopListener = new InternalDesktopListener();

    public JDesktopPanelsList(SoapUIDesktop desktop) {
        super(new BorderLayout());
        this.setDesktop(desktop);
        this.desktopPanels = new DefaultListModel();
        this.desktopPanelsList = new JList(this.desktopPanels);
        this.desktopPanelsList.setCellRenderer(new DesktopItemsCellRenderer());
        this.desktopPanelsList.setToolTipText("Open windows");
        this.desktopPanelsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                JDesktopPanelsList.this.desktop.showDesktopPanel((DesktopPanel)JDesktopPanelsList.this.desktopPanelsList.getSelectedValue());
            }
        });
        this.add((Component)new JScrollPane(this.desktopPanelsList), "Center");
    }

    public List<DesktopPanel> getDesktopPanels() {
        ArrayList<DesktopPanel> result = new ArrayList<DesktopPanel>();
        for (int c = 0; c < this.desktopPanels.getSize(); ++c) {
            result.add((DesktopPanel)this.desktopPanels.get(c));
        }
        return result;
    }

    public void setDesktop(SoapUIDesktop newDesktop) {
        if (this.desktop != null) {
            this.desktop.removeDesktopListener(this.desktopListener);
            while (this.desktopPanels.size() > 0) {
                DesktopPanel desktopPanel = (DesktopPanel)this.desktopPanels.getElementAt(0);
                desktopPanel.removePropertyChangeListener(this.desktopPanelPropertyListener);
                this.desktopPanels.remove(0);
            }
        }
        this.desktop = newDesktop;
        this.desktop.addDesktopListener(this.desktopListener);
        for (DesktopPanel desktopPanel : this.desktop.getDesktopPanels()) {
            desktopPanel.addPropertyChangeListener(this.desktopPanelPropertyListener);
            this.desktopPanels.addElement(desktopPanel);
        }
    }

    public JList getDesktopPanelsList() {
        return this.desktopPanelsList;
    }

    public int getItemsCount() {
        return this.desktopPanels.size();
    }

    private class InternalDesktopListener
    implements DesktopListener {
        private InternalDesktopListener() {
        }

        public void desktopPanelSelected(DesktopPanel desktopPanel) {
            JDesktopPanelsList.this.desktopPanelsList.setSelectedValue(desktopPanel, false);
        }

        public void desktopPanelCreated(DesktopPanel desktopPanel) {
            JDesktopPanelsList.this.desktopPanels.addElement(desktopPanel);
            JDesktopPanelsList.this.desktopPanelsList.setSelectedValue(desktopPanel, false);
            desktopPanel.addPropertyChangeListener(JDesktopPanelsList.this.desktopPanelPropertyListener);
        }

        public void desktopPanelClosed(DesktopPanel desktopPanel) {
            JDesktopPanelsList.this.desktopPanels.removeElement(desktopPanel);
            desktopPanel.removePropertyChangeListener(JDesktopPanelsList.this.desktopPanelPropertyListener);
        }
    }

    private static class DesktopItemsCellRenderer
    extends DefaultListCellRenderer {
        private DesktopItemsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DesktopPanel desktopPanel = (DesktopPanel)value;
            String title = desktopPanel.getTitle();
            this.setText(title);
            this.setToolTipText(desktopPanel.getDescription());
            this.setIcon(desktopPanel.getIcon());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.getBorder()));
            return this;
        }
    }

    private class DesktopPanelPropertyChangeListener
    implements PropertyChangeListener {
        private DesktopPanelPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DesktopPanel desktopPanel = (DesktopPanel)evt.getSource();
            int ix = JDesktopPanelsList.this.desktopPanels.indexOf(desktopPanel);
            if (ix >= 0) {
                JDesktopPanelsList.this.desktopPanels.set(ix, desktopPanel);
            }
        }
    }
}

