/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DIAGONAL_LEFT = 2;
    public static final int DIAGONAL_RIGHT = 3;
    private int direction = 0;
    private boolean cyclic;
    private int maxLength;

    public GradientPanel() {
        this(0);
    }

    public GradientPanel(int direction) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.direction = direction;
    }

    public GradientPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.setOpaque(false);
        this.direction = 0;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            super.paintComponent(g);
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        GradientPaint paint = null;
        Color sc = this.getForeground();
        Color ec = this.getBackground();
        switch (this.direction) {
            case 0: {
                paint = new GradientPaint(0.0f, height / 2, sc, width, height / 2, ec, this.cyclic);
                break;
            }
            case 1: {
                paint = new GradientPaint(width / 2, 0.0f, sc, width / 2, this.maxLength > 0 ? (float)this.maxLength : (float)height, ec, this.cyclic);
                break;
            }
            case 2: {
                paint = new GradientPaint(0.0f, 0.0f, sc, width, height, ec, this.cyclic);
                break;
            }
            case 3: {
                paint = new GradientPaint(width, 0.0f, sc, 0.0f, height, ec, this.cyclic);
            }
        }
        if (paint == null) {
            throw new RuntimeException("Invalid direction specified in GradientPanel");
        }
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, width, height);
        g2d.setPaint(oldPaint);
        super.paintComponent(g);
    }
}

