/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.actions.project.SimpleDialog;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveDialog {
    private JDialog dialog;
    private ResolveContextTableModel resolveContextTableModel;
    private boolean showOkMessage;
    private String title;
    private String description;
    private String helpUrl;
    private JXTable table;

    public ResolveDialog(String title, String description, String helpUrl) {
        this.title = title;
        this.description = description;
        this.helpUrl = helpUrl;
    }

    private void buildDialog() {
        this.dialog = new SimpleDialog(this.title, this.description, this.helpUrl, true){

            protected Component buildContent() {
                JPanel panel = new JPanel(new BorderLayout());
                ResolveDialog.this.table = new JXTable((TableModel)ResolveDialog.this.resolveContextTableModel);
                ResolveDialog.this.table.setHorizontalScrollEnabled(true);
                ResolveDialog.this.table.setDefaultRenderer(JComboBox.class, (TableCellRenderer)new ResolverRenderer());
                ResolveDialog.this.table.setDefaultEditor(JComboBox.class, (TableCellEditor)new ResolverEditor());
                ResolveDialog.this.table.getColumn(2).setCellRenderer(new PathCellRenderer());
                ResolveDialog.this.table.getColumn(3).setWidth(100);
                ResolveDialog.this.table.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        ResolveContext.PathToResolve pathToResolve;
                        int ix;
                        if (e.getClickCount() > 1 && (ix = ResolveDialog.this.table.getSelectedRow()) != -1 && (pathToResolve = ResolveDialog.this.resolveContextTableModel.getContext().getPathsToResolve().get(ix)) != null) {
                            UISupport.selectAndShow(pathToResolve.getOwner());
                        }
                    }
                });
                panel.add((Component)new JScrollPane((Component)ResolveDialog.this.table), "Center");
                panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                return panel;
            }

            protected void modifyButtons() {
                Component[] components;
                super.modifyButtons();
                for (Component component : components = this.buttons.getComponents()) {
                    JButton button;
                    if (!(component instanceof JButton) || !(button = (JButton)component).getText().equals("Cancel")) continue;
                    button.setText("Update");
                }
            }

            protected boolean handleCancel() {
                return this.handleUpdate();
            }

            private boolean handleUpdate() {
                for (ResolveContext.PathToResolve otherPath : ResolveDialog.this.resolveContextTableModel.getContext().getPathsToResolve()) {
                    if (otherPath.isResolved()) continue;
                    otherPath.getOwner().afterLoad();
                    otherPath.getOwner().resolve(ResolveDialog.this.resolveContextTableModel.getContext());
                }
                ResolveDialog.this.dialog = null;
                this.setVisible(false);
                ResolveDialog.this.resolve((AbstractWsdlModelItem<?>)ResolveDialog.this.resolveContextTableModel.getContext().getModelItem());
                return true;
            }

            protected boolean handleOk() {
                for (ResolveContext.PathToResolve path : ResolveDialog.this.resolveContextTableModel.getContext().getPathsToResolve()) {
                    if (path.isResolved()) continue;
                    return UISupport.confirm("There are unresolved paths, continue?", "Unresolved paths - Warning");
                }
                return true;
            }
        };
        this.dialog.setSize(550, 300);
        this.dialog.setModal(false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                for (ResolveContext.PathToResolve path : ResolveDialog.this.resolveContextTableModel.getContext().getPathsToResolve()) {
                    if (path.isResolved()) continue;
                    if (!UISupport.confirm("There are unresolved paths, continue?", "Unresolved paths - Warning")) break;
                    ResolveDialog.this.dialog.setVisible(false);
                    break;
                }
            }
        });
    }

    public boolean isShowOkMessage() {
        return this.showOkMessage;
    }

    public void setShowOkMessage(boolean showOkMessage) {
        this.showOkMessage = showOkMessage;
    }

    public ResolveContext<?> resolve(AbstractWsdlModelItem<?> modelItem) {
        ResolveContext context = new ResolveContext(modelItem);
        modelItem.resolve(context);
        if (context.isEmpty()) {
            if (this.isShowOkMessage()) {
                UISupport.showInfoMessage("No resolve problems found", this.title);
            }
        } else {
            this.resolveContextTableModel = new ResolveContextTableModel(context);
            if (this.dialog == null) {
                this.buildDialog();
            } else {
                this.table.setModel((TableModel)this.resolveContextTableModel);
            }
            UISupport.centerDialog(this.dialog);
            this.dialog.setVisible(true);
        }
        return context;
    }

    private class PathCellRenderer
    extends DefaultTableCellRenderer {
        private Color greenColor = Color.GREEN.darker().darker();
        private Color redColor = Color.RED.darker().darker();

        private PathCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            ResolveContext.PathToResolve ptr;
            Component comp = super.getTableCellRendererComponent(arg0, arg1, arg2, arg3, arg4, arg5);
            List<ResolveContext.PathToResolve> paths = ResolveDialog.this.resolveContextTableModel.getContext().getPathsToResolve();
            ResolveContext.PathToResolve pathToResolve = ptr = arg4 >= paths.size() ? null : paths.get(arg4);
            if (ptr != null && ptr.isResolved()) {
                comp.setForeground(this.greenColor);
                this.setText(ptr.getPath());
            } else {
                comp.setForeground(this.redColor);
            }
            return comp;
        }
    }

    private class ResolverEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox jbc = new JComboBox();

        private ResolverEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.jbc = ((ResolveContextTableModel)table.getModel()).getResolversAndActions(row);
            final ResolveContext.PathToResolve path = ResolveDialog.this.resolveContextTableModel.getContext().getPathsToResolve().get(row);
            this.jbc.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object key = ResolverEditor.this.jbc.getSelectedItem();
                    if (key instanceof ResolveContext.Resolver) {
                        path.setResolver(key);
                    }
                    if (path.resolve()) {
                        path.setSolved(true);
                        ResolverEditor.this.jbc.addItem("Resolved");
                        ResolverEditor.this.jbc.setSelectedIndex(ResolverEditor.this.jbc.getItemCount() - 1);
                    }
                }
            });
            return this.jbc;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    private class ResolverRenderer
    implements TableCellRenderer {
        private ResolverRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return ((ResolveContextTableModel)table.getModel()).getResolversAndActions(row);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveContextTableModel
    extends AbstractTableModel {
        private ResolveContext<?> context;
        private ArrayList<JComboBox> jbcList = new ArrayList();

        public ResolveContextTableModel(ResolveContext<?> context2) {
            this.context = context2;
            for (ResolveContext.PathToResolve path : this.context.getPathsToResolve()) {
                ArrayList<Object> resolversAndDefaultAction = new ArrayList<Object>();
                resolversAndDefaultAction.add("Choose one...");
                for (ResolveContext.Resolver resolver : path.getResolvers()) {
                    resolversAndDefaultAction.add(resolver);
                }
                JComboBox<Object> jbc = new JComboBox<Object>(resolversAndDefaultAction.toArray());
                this.jbcList.add(jbc);
            }
        }

        public JComboBox getResolversAndActions(int row) {
            return this.jbcList.get(row);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        public void setContext(ResolveContext<?> context) {
            this.context = context;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Item";
                }
                case 1: {
                    return "Description";
                }
                case 2: {
                    return "Value";
                }
                case 3: {
                    return "Action";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int arg0) {
            if (arg0 == 3) {
                return JComboBox.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.context.getPathsToResolve().size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            ResolveContext.PathToResolve ptr = this.context.getPathsToResolve().get(arg0);
            switch (arg1) {
                case 0: {
                    return this.createItemName(ptr);
                }
                case 1: {
                    return ptr.getDescription();
                }
                case 2: {
                    return ptr.getPath();
                }
            }
            return null;
        }

        private String createItemName(ResolveContext.PathToResolve ptr) {
            String name = "";
            ModelItem modelItem = ptr.getOwner();
            try {
                name = modelItem.getName();
            }
            catch (Exception e) {
                e.getStackTrace();
            }
            while (modelItem.getParent() != null && !(modelItem.getParent() instanceof Project)) {
                modelItem = modelItem.getParent();
                name = modelItem.getName() + " - " + name;
            }
            return name;
        }

        public ResolveContext<?> getContext() {
            return this.context;
        }

        public void setResolver(int pathIndex, Object resolveOrDefaultAction) {
            ResolveContext.PathToResolve path = this.context.getPathsToResolve().get(pathIndex);
            if (resolveOrDefaultAction instanceof ResolveContext.Resolver) {
                path.setResolver(resolveOrDefaultAction);
            }
        }
    }
}

