/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfer;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfersTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;

public class ChooseAnotherPropertyTargetResolver
implements ResolveContext.Resolver {
    private boolean resolved;
    private PropertyTransfer badTransfer = null;
    private PropertyTransfersTestStep parent = null;
    private ArrayList<Object> sources = new ArrayList();
    private ArrayList<String[]> properties = new ArrayList();

    public ChooseAnotherPropertyTargetResolver(PropertyTransfer propertyTransfer, PropertyTransfersTestStep parent) {
        this.badTransfer = propertyTransfer;
        this.parent = parent;
        this.sources.add(PropertyExpansionUtils.getGlobalProperties());
        this.properties.add(PropertyExpansionUtils.getGlobalProperties().getPropertyNames());
        this.sources.add(parent.getTestCase().getTestSuite().getProject());
        this.properties.add(parent.getTestCase().getTestSuite().getProject().getPropertyNames());
        this.sources.add(parent.getTestCase().getTestSuite());
        this.properties.add(parent.getTestCase().getTestSuite().getPropertyNames());
        this.sources.add(parent.getTestCase());
        this.properties.add(parent.getTestCase().getPropertyNames());
        for (int c = 0; c < parent.getTestCase().getTestStepCount(); ++c) {
            WsdlTestStep testStep = parent.getTestCase().getTestStepAt(c);
            if (testStep == parent) continue;
            this.sources.add(testStep);
            this.properties.add(testStep.getPropertyNames());
        }
    }

    public String getDescription() {
        return "Choose new target property";
    }

    public String toString() {
        return this.getDescription();
    }

    public String getResolvedPath() {
        return null;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve() {
        PropertyChangeDialog propertyChangeDialog = new PropertyChangeDialog("Choose another property");
        propertyChangeDialog.showAndChoose();
        return this.resolved;
    }

    private class StepComboRenderer
    extends DefaultListCellRenderer {
        private StepComboRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            try {
                block5: {
                    try {
                        if (value instanceof TestModelItem) {
                            TestModelItem item = (TestModelItem)value;
                            this.setIcon(item.getIcon());
                            this.setText(item.getName());
                            break block5;
                        }
                        if (value != PropertyExpansionUtils.getGlobalProperties()) break block5;
                        this.setText("Global");
                    }
                    catch (Exception e) {
                        this.setText("Removed element");
                        Object var9_10 = null;
                        return result;
                    }
                }
                Object var9_9 = null;
                return result;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                return result;
            }
        }
    }

    private class PropertyChangeDialog
    extends JDialog {
        private JComboBox sourceStepCombo;
        private JComboBox propertiesCombo;
        private JButton okBtn;
        private JButton cancelBtn;

        public PropertyChangeDialog(String title) {
            super(UISupport.getMainFrame(), title, true);
            this.okBtn = new JButton(" Ok ");
            this.cancelBtn = new JButton(" Cancel ");
            this.init();
        }

        private void init() {
            FormLayout layout = new FormLayout("min,right:pref, 4dlu, 40dlu, 5dlu, 40dlu, min ", "min, pref, 4dlu, pref, 4dlu, pref, min");
            CellConstraints cc = new CellConstraints();
            PanelBuilder panel = new PanelBuilder(layout);
            panel.addLabel("Source:", cc.xy(2, 2));
            DefaultComboBoxModel sourceStepComboModel = new DefaultComboBoxModel();
            this.sourceStepCombo = new JComboBox(sourceStepComboModel);
            this.sourceStepCombo.setRenderer(new StepComboRenderer());
            for (Object element : ChooseAnotherPropertyTargetResolver.this.sources) {
                sourceStepComboModel.addElement(element);
            }
            this.sourceStepCombo.setSelectedIndex(0);
            panel.add((Component)this.sourceStepCombo, cc.xyw(4, 2, 3));
            int index = this.sourceStepCombo.getSelectedIndex();
            this.propertiesCombo = new JComboBox<Object>((Object[])ChooseAnotherPropertyTargetResolver.this.properties.get(index));
            panel.addLabel("Property:", cc.xy(2, 4));
            panel.add((Component)this.propertiesCombo, cc.xyw(4, 4, 3));
            panel.add((Component)this.okBtn, cc.xy(4, 6));
            panel.add((Component)this.cancelBtn, cc.xy(6, 6));
            this.sourceStepCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = PropertyChangeDialog.this.sourceStepCombo.getSelectedIndex();
                    PropertyChangeDialog.this.propertiesCombo.removeAllItems();
                    if (((String[])ChooseAnotherPropertyTargetResolver.this.properties.get(index)).length > 0) {
                        PropertyChangeDialog.this.propertiesCombo.setEnabled(true);
                        for (String str : (String[])ChooseAnotherPropertyTargetResolver.this.properties.get(index)) {
                            PropertyChangeDialog.this.propertiesCombo.addItem(str);
                        }
                    } else {
                        PropertyChangeDialog.this.propertiesCombo.setEnabled(false);
                    }
                }
            });
            this.okBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestPropertyHolder sourceStep = (TestPropertyHolder)PropertyChangeDialog.this.sourceStepCombo.getSelectedItem();
                    String name = sourceStep == PropertyExpansionUtils.getGlobalProperties() ? "#Global#" : (sourceStep == ChooseAnotherPropertyTargetResolver.this.parent.getTestCase().getTestSuite().getProject() ? "#Project#" : (sourceStep == ChooseAnotherPropertyTargetResolver.this.parent.getTestCase().getTestSuite() ? "#TestSuite#" : (sourceStep == ChooseAnotherPropertyTargetResolver.this.parent.getTestCase() ? "#TestCase#" : sourceStep.getModelItem().getName())));
                    ChooseAnotherPropertyTargetResolver.this.badTransfer.setTargetStepName(name);
                    ChooseAnotherPropertyTargetResolver.this.badTransfer.setTargetPropertyName((String)PropertyChangeDialog.this.propertiesCombo.getSelectedItem());
                    ChooseAnotherPropertyTargetResolver.this.resolved = true;
                    PropertyChangeDialog.this.setVisible(false);
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChooseAnotherPropertyTargetResolver.this.resolved = false;
                    PropertyChangeDialog.this.setVisible(false);
                }
            });
            this.setLocationRelativeTo(UISupport.getParentFrame(this));
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add(panel.getPanel());
        }

        public void showAndChoose() {
            this.pack();
            this.setVisible(true);
        }
    }
}

