/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionImpl;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.tree.nodes.PropertyTreeNode;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionTarget;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.syntax.jedit.JEditTextArea;

public final class PropertyExpansionDropTarget
implements DropTargetListener {
    private final PropertyExpansionTarget target;

    public PropertyExpansionDropTarget(PropertyExpansionTarget target) {
        this.target = target;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable())) {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dtde) {
        if (dtde.getDropTargetContext().getComponent() instanceof JTextComponent) {
            ((JTextComponent)dtde.getDropTargetContext().getComponent()).getCaret().setVisible(false);
        } else if (dtde.getDropTargetContext().getComponent() instanceof JXEditTextArea) {
            ((JXEditTextArea)dtde.getDropTargetContext().getComponent()).setCaretVisible(false);
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        JComponent textField;
        int pos;
        if (!this.isAcceptable(dtde.getTransferable())) {
            dtde.rejectDrag();
        }
        if (dtde.getDropTargetContext().getComponent() instanceof JTextComponent && (pos = ((JTextComponent)(textField = (JTextComponent)dtde.getDropTargetContext().getComponent())).viewToModel(dtde.getLocation())) != -1) {
            ((JTextComponent)textField).setCaretPosition(pos);
            ((JTextComponent)textField).getCaret().setVisible(true);
        }
        if (dtde.getDropTargetContext().getComponent() instanceof JXEditTextArea && (pos = ((JEditTextArea)(textField = (JXEditTextArea)dtde.getDropTargetContext().getComponent())).pointToOffset(dtde.getLocation())) != -1) {
            ((JEditTextArea)textField).setCaretPosition(pos);
            ((JEditTextArea)textField).setCaretVisible(true);
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void drop(DropTargetDropEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable())) {
            dtde.rejectDrop();
        } else {
            try {
                Transferable transferable = dtde.getTransferable();
                Object transferData = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                if (transferData instanceof PropertyTreeNode.PropertyModelItem) {
                    dtde.acceptDrop(dtde.getDropAction());
                    PropertyTreeNode.PropertyModelItem modelItem = (PropertyTreeNode.PropertyModelItem)transferData;
                    String xpath = modelItem.getXPath();
                    if (xpath == null && XmlUtils.seemsToBeXml(modelItem.getProperty().getValue()) && (xpath = UISupport.selectXPath("Create PropertyExpansion", "Select XPath below", modelItem.getProperty().getValue(), null)) != null) {
                        xpath = PropertyExpansionUtils.shortenXPathForPropertyExpansion(xpath, modelItem.getProperty().getValue());
                    }
                    this.target.insertPropertyExpansion(new PropertyExpansionImpl(modelItem.getProperty(), xpath), dtde.getLocation());
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            if (dtde.getDropTargetContext().getComponent() instanceof JTextComponent) {
                ((JTextComponent)dtde.getDropTargetContext().getComponent()).getCaret().setVisible(false);
            } else if (dtde.getDropTargetContext().getComponent() instanceof JXEditTextArea) {
                ((JXEditTextArea)dtde.getDropTargetContext().getComponent()).setCaretVisible(false);
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public boolean isAcceptable(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
            try {
                Object modelItem = transferable.getTransferData(flavor);
                if (!(modelItem instanceof PropertyTreeNode.PropertyModelItem)) continue;
                return PropertyExpansionUtils.canExpandProperty(this.target.getContextModelItem(), ((PropertyTreeNode.PropertyModelItem)modelItem).getProperty());
            }
            catch (Exception ex) {
                SoapUI.logError(ex);
            }
        }
        return false;
    }
}

