/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.support.propertyexpansion.AbstractPropertyExpansionTarget;
import java.awt.Point;
import javax.swing.text.JTextComponent;

public class JTextComponentPropertyExpansionTarget
extends AbstractPropertyExpansionTarget {
    private final JTextComponent textField;

    public JTextComponentPropertyExpansionTarget(JTextComponent textField, ModelItem modelItem) {
        super(modelItem);
        this.textField = textField;
    }

    public void insertPropertyExpansion(PropertyExpansion expansion, Point pt) {
        int pos;
        int n = pos = pt == null ? -1 : this.textField.viewToModel(pt);
        if (pos == -1) {
            pos = this.textField.getCaretPosition();
        }
        if (pos == -1 || this.textField.getSelectionStart() == this.textField.getSelectionEnd()) {
            this.textField.setText(((Object)expansion).toString());
            this.textField.requestFocusInWindow();
        } else {
            String text = this.textField.getText();
            if (this.textField.getSelectionStart() < this.textField.getSelectionEnd()) {
                this.textField.setText(text.substring(0, this.textField.getSelectionStart()) + expansion + text.substring(this.textField.getSelectionEnd()));
                this.textField.setCaretPosition(this.textField.getSelectionStart());
            } else {
                this.textField.setText(text.substring(0, pos) + expansion + text.substring(pos));
                this.textField.setCaretPosition(pos);
            }
            this.textField.requestFocusInWindow();
        }
    }

    public String getValueForCreation() {
        return this.textField.getSelectedText() == null ? this.textField.getText() : this.textField.getSelectedText();
    }

    public String getNameForCreation() {
        return this.textField.getName();
    }
}

