/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionImpl;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.tree.nodes.PropertyTreeNode;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTable;

public class JTableTestPropertyDropTarget
implements DropTargetListener {
    private final JTable table;
    private final ModelItem modelItem;

    public JTableTestPropertyDropTarget(ModelItem modelItem, JTable table) {
        this.modelItem = modelItem;
        this.table = table;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(dtde.getDropAction());
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
            dtde.rejectDrop();
        } else {
            try {
                Transferable transferable = dtde.getTransferable();
                Object transferData = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                if (transferData instanceof PropertyTreeNode.PropertyModelItem) {
                    dtde.acceptDrop(dtde.getDropAction());
                    PropertyTreeNode.PropertyModelItem modelItem = (PropertyTreeNode.PropertyModelItem)transferData;
                    String xpath = modelItem.getXPath();
                    if (xpath == null && XmlUtils.seemsToBeXml(modelItem.getProperty().getValue()) && (xpath = UISupport.selectXPath("Create PropertyExpansion", "Select XPath below", modelItem.getProperty().getValue(), null)) != null) {
                        xpath = PropertyExpansionUtils.shortenXPathForPropertyExpansion(xpath, modelItem.getProperty().getValue());
                    }
                    PropertyExpansionImpl propertyExpansion = new PropertyExpansionImpl(modelItem.getProperty(), xpath);
                    Point point = dtde.getLocation();
                    int column = this.table.columnAtPoint(point);
                    int row = this.table.rowAtPoint(point);
                    this.table.setValueAt(((Object)propertyExpansion).toString(), row, column);
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public boolean isAcceptable(Transferable transferable, Point point) {
        int column = this.table.columnAtPoint(point);
        int row = this.table.rowAtPoint(point);
        if (!this.table.isCellEditable(row, column)) {
            return false;
        }
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
            try {
                Object modelItem = transferable.getTransferData(flavor);
                if (!(modelItem instanceof PropertyTreeNode.PropertyModelItem)) continue;
                return PropertyExpansionUtils.canExpandProperty(this.modelItem, ((PropertyTreeNode.PropertyModelItem)modelItem).getProperty());
            }
            catch (Exception ex) {
                SoapUI.logError(ex);
            }
        }
        return false;
    }
}

