/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JListDragAndDropable<T extends JList>
implements SoapUIDragAndDropable<ModelItem> {
    private T list;
    private ModelItem parent;

    public JListDragAndDropable(T list, ModelItem parent) {
        this.list = list;
        this.parent = parent;
    }

    public T getList() {
        return this.list;
    }

    public abstract ModelItem getModelItemAtRow(int var1);

    @Override
    public JComponent getComponent() {
        return this.list;
    }

    @Override
    public Rectangle getModelItemBounds(ModelItem modelItem) {
        if (modelItem == this.parent) {
            return ((Component)this.list).getBounds();
        }
        int ix = this.getModelItemRow(modelItem);
        return ((JList)this.list).getCellBounds(ix, ix);
    }

    public abstract int getModelItemRow(ModelItem var1);

    @Override
    public void selectModelItem(ModelItem modelItem) {
        ((JList)this.list).setSelectedIndex(this.getModelItemRow(modelItem));
    }

    @Override
    public void setDragInfo(String dropInfo) {
        ((JComponent)this.list).setToolTipText(dropInfo);
    }

    @Override
    public ModelItem getModelItemForLocation(int x, int y) {
        int index = ((JList)this.list).locationToIndex(new Point(x, y));
        return index == -1 ? this.parent : this.getModelItemAtRow(index);
    }

    @Override
    public void toggleExpansion(ModelItem last) {
    }
}

