/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.components.JFormComponent;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.swing.JTextComponentPopupMenu;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleForm {
    private JPanel panel;
    private CellConstraints cc = new CellConstraints();
    private FormLayout layout;
    private RowSpec rowSpec;
    private int rowSpacing = 5;
    private Map<String, JComponent> components = new HashMap<String, JComponent>();
    private Map<JComboBox, Object[]> comboBoxMaps = new HashMap<JComboBox, Object[]>();
    private String rowAlignment = "top";
    private Map<String, String> hiddenValues;
    private boolean appended;
    private Font labelFont;
    private int defaultTextAreaColumns = 30;
    private int defaultTextAreaRows = 3;
    private int defaultTextFieldColumns = 30;

    public SimpleForm() {
        this(5);
    }

    public SimpleForm(String layout) {
        this(new FormLayout(layout));
    }

    public SimpleForm(FormLayout layout) {
        this.layout = layout;
        this.panel = new JPanel((LayoutManager)layout);
        this.rowSpec = new RowSpec(this.rowAlignment + ":pref");
    }

    public SimpleForm(int indent) {
        this(indent + "px:none,left:pref,10px,left:default,5px:grow(1.0)");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getRowAlignment() {
        return this.rowAlignment;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public void setRowAlignment(String rowAlignment) {
        this.rowAlignment = rowAlignment;
        this.rowSpec = new RowSpec(rowAlignment + ":pref");
    }

    public int getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(int rowSpacing) {
        this.rowSpacing = rowSpacing;
    }

    public void addHiddenValue(String name, String value) {
        if (this.hiddenValues == null) {
            this.hiddenValues = new HashMap<String, String>();
        }
        this.hiddenValues.put(name, value);
    }

    public JButton addRightButton(Action action) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        JButton button = new JButton(action);
        this.panel.add((Component)button, this.cc.xy(4, row, "right,bottom"));
        return button;
    }

    public void addSpace() {
        this.addSpace(this.rowSpacing);
    }

    public void addSpace(int size) {
        if (size > 0) {
            this.layout.appendRow(new RowSpec(size + "px"));
        }
    }

    public void addRightComponent(JComponent component) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xy(4, row, "right,bottom"));
    }

    public JCheckBox appendCheckBox(String caption, String label, boolean selected) {
        JCheckBox checkBox = new JCheckBox(label, selected);
        checkBox.getAccessibleContext().setAccessibleDescription(caption);
        this.components.put(caption, checkBox);
        this.append(caption, checkBox);
        return checkBox;
    }

    public void append(String label, JComponent component) {
        this.append(label, component, null);
    }

    public JComboBox appendComboBox(String label, Map<?, ?> values) {
        Object[] valueArray = new Object[values.size()];
        Object[] keyArray = new Object[values.size()];
        int ix = 0;
        Iterator<?> i = values.keySet().iterator();
        while (i.hasNext()) {
            keyArray[ix] = i.next();
            valueArray[ix] = values.get(keyArray[ix]);
            ++ix;
        }
        JComboBox<Object> comboBox = new JComboBox<Object>(valueArray);
        this.comboBoxMaps.put(comboBox, keyArray);
        this.append(label, comboBox);
        return comboBox;
    }

    public JComboBox appendComboBox(String label, Object[] values, String tooltip) {
        JComboBox<Object> comboBox = new JComboBox<Object>(values);
        comboBox.setToolTipText(tooltip);
        comboBox.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, comboBox);
        return comboBox;
    }

    public JComboBox appendComboBox(String label, ComboBoxModel model, String tooltip) {
        JComboBox comboBox = new JComboBox(model);
        comboBox.setToolTipText(tooltip);
        comboBox.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, comboBox);
        return comboBox;
    }

    public JButton appendButton(String label, String tooltip) {
        JButton button = new JButton();
        button.setToolTipText(tooltip);
        button.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, button);
        return button;
    }

    public void appendFixed(String label, JComponent component) {
        this.append(label, component, "left:pref");
    }

    public <T extends JComponent> T append(String label, T component, String alignments) {
        JLabel jlabel = null;
        if (label != null) {
            jlabel = new JLabel(label.endsWith(":") ? label : label + ":");
            jlabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            if (this.labelFont != null) {
                jlabel.setFont(this.labelFont);
            }
        }
        return this.append(label, jlabel, component, alignments);
    }

    public <T extends JComponent> T append(String name, JComponent label, T component, String alignments) {
        int spaceRowIndex = -1;
        if (this.rowSpacing > 0 && this.appended) {
            this.addSpace(this.rowSpacing);
            spaceRowIndex = this.layout.getRowCount();
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        if (label != null) {
            this.panel.add((Component)label, this.cc.xy(2, row));
            component.addComponentListener(new LabelHider(label, spaceRowIndex));
            if (label instanceof JLabel) {
                JLabel jl = (JLabel)label;
                jl.setLabelFor(component);
                String text = jl.getText();
                int ix = text.indexOf(38);
                if (ix >= 0) {
                    jl.setText(text.substring(0, ix) + text.substring(ix + 1));
                    jl.setDisplayedMnemonicIndex(ix);
                    jl.setDisplayedMnemonic(text.charAt(ix + 1));
                }
                if (component.getAccessibleContext() != null) {
                    component.getAccessibleContext().setAccessibleName(text);
                }
            }
        } else {
            component.addComponentListener(new LabelHider(null, spaceRowIndex));
        }
        if (alignments == null) {
            this.panel.add(component, this.cc.xy(4, row));
        } else {
            this.panel.add(component, this.cc.xy(4, row, alignments));
        }
        this.components.put(name, component);
        this.appended = true;
        return component;
    }

    public boolean hasComponents() {
        return !this.components.isEmpty();
    }

    public void appendSeparator() {
        if (this.appended && this.rowSpacing > 0) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)new JSeparator(), this.cc.xywh(2, row, 3, 1));
        this.appended = true;
    }

    public JTextField appendTextField(String label, String tooltip) {
        JUndoableTextField textField = new JUndoableTextField();
        textField.setColumns(this.defaultTextFieldColumns);
        textField.setToolTipText(tooltip);
        textField.getAccessibleContext().setAccessibleDescription(tooltip);
        JTextComponentPopupMenu.add(textField);
        this.append(label, textField);
        return textField;
    }

    public JTextArea appendTextArea(String label, String tooltip) {
        JUndoableTextArea textArea = new JUndoableTextArea();
        textArea.setColumns(this.defaultTextAreaColumns);
        textArea.setRows(this.defaultTextAreaRows);
        textArea.setAutoscrolls(true);
        textArea.add(new JScrollPane());
        textArea.setToolTipText(tooltip);
        textArea.getAccessibleContext().setAccessibleDescription(tooltip);
        JTextComponentPopupMenu.add(textArea);
        this.append(label, new JScrollPane(textArea));
        return textArea;
    }

    public int getDefaultTextAreaColumns() {
        return this.defaultTextAreaColumns;
    }

    public void setDefaultTextAreaColumns(int defaultTextAreaColumns) {
        this.defaultTextAreaColumns = defaultTextAreaColumns;
    }

    public int getDefaultTextAreaRows() {
        return this.defaultTextAreaRows;
    }

    public void setDefaultTextAreaRows(int defaultTextAreaRows) {
        this.defaultTextAreaRows = defaultTextAreaRows;
    }

    public JPasswordField appendPasswordField(String label, String tooltip) {
        JPasswordField textField = new JPasswordField();
        textField.setColumns(this.defaultTextFieldColumns);
        textField.setToolTipText(tooltip);
        textField.getAccessibleContext().setAccessibleDescription(tooltip);
        this.append(label, textField);
        return textField;
    }

    public void setComponentValue(String label, String value) {
        JComponent component = this.getComponent(label);
        if (component instanceof JScrollPane) {
            component = (JComponent)((JScrollPane)component).getViewport().getComponent(0);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(value);
        } else if (component instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)component;
            comboBox.setSelectedItem(value);
        } else if (component instanceof JList) {
            ((JList)component).setSelectedValue(value, true);
        } else if (component instanceof JCheckBox) {
            ((JCheckBox)component).setSelected(Boolean.valueOf(value));
        } else if (component instanceof JFormComponent) {
            ((JFormComponent)((Object)component)).setValue(value);
        } else if (component instanceof JXEditTextArea) {
            ((JXEditTextArea)component).setText(value);
        }
    }

    public String getComponentValue(String label) {
        JComboBox comboBox;
        int selectedIndex;
        JComponent component = this.getComponent(label);
        if (component == null) {
            return this.hiddenValues == null ? null : this.hiddenValues.get(label);
        }
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof JComboBox && (selectedIndex = (comboBox = (JComboBox)component).getSelectedIndex()) != -1) {
            if (this.comboBoxMaps.containsKey(component)) {
                Object[] keys = this.comboBoxMaps.get(comboBox);
                Object value = keys[selectedIndex];
                return (String)value == null ? null : value.toString();
            }
            Object value = comboBox.getSelectedItem();
            return (String)value == null ? null : value.toString();
        }
        if (component instanceof JList) {
            return (String)((JList)component).getSelectedValue();
        }
        if (component instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)component).isSelected());
        }
        if (component instanceof JFormComponent) {
            return ((JFormComponent)((Object)component)).getValue();
        }
        return null;
    }

    public JComponent getComponent(String label) {
        return this.components.get(label);
    }

    public void setBorder(Border border) {
        this.panel.setBorder(border);
    }

    public int getRowCount() {
        return this.layout.getRowCount();
    }

    public void addComponent(JComponent component) {
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xyw(2, row, 4));
    }

    public void setValues(Map<String, String> values) {
        for (String key : values.keySet()) {
            this.setComponentValue(key, values.get(key));
        }
    }

    public void getValues(Map<String, String> values) {
        for (String key : this.components.keySet()) {
            values.put(key, this.getComponentValue(key));
        }
    }

    public void append(JComponent component) {
        int spaceRowIndex = -1;
        if (this.rowSpacing > 0 && this.appended) {
            this.addSpace(this.rowSpacing);
            spaceRowIndex = this.layout.getRowCount();
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add((Component)component, this.cc.xyw(2, row, 4));
        component.addComponentListener(new LabelHider(null, spaceRowIndex));
        this.appended = true;
    }

    public void setDefaultTextFieldColumns(int defaultTextFieldColumns) {
        this.defaultTextFieldColumns = defaultTextFieldColumns;
    }

    public <T extends JComponent> T append(String name, JLabel label, T field) {
        return this.append(name, label, field, null);
    }

    public void setEnabled(boolean b) {
        for (JComponent component : this.components.values()) {
            if (component instanceof JScrollPane) {
                ((JScrollPane)component).getViewport().getView().setEnabled(b);
            }
            component.setEnabled(b);
        }
    }

    public <T extends JComponent> T addLeftComponent(T component) {
        if (this.rowSpacing > 0 && !this.components.isEmpty()) {
            this.addSpace(this.rowSpacing);
        }
        this.layout.appendRow(this.rowSpec);
        int row = this.layout.getRowCount();
        this.panel.add(component, this.cc.xy(4, row));
        return component;
    }

    private final class LabelHider
    extends ComponentAdapter {
        private final JComponent jlabel;
        private final int rowIndex;

        public LabelHider(JComponent label, int i) {
            this.jlabel = label;
            this.rowIndex = i;
        }

        public void componentHidden(ComponentEvent e) {
            if (this.jlabel != null) {
                this.jlabel.setVisible(false);
            }
            if (this.rowIndex >= 0 && this.rowIndex < SimpleForm.this.layout.getRowCount()) {
                SimpleForm.this.layout.setRowSpec(this.rowIndex, new RowSpec("0px"));
            }
        }

        public void componentShown(ComponentEvent e) {
            if (this.jlabel != null) {
                this.jlabel.setVisible(true);
            }
            if (this.rowIndex >= 0 && this.rowIndex < SimpleForm.this.layout.getRowCount()) {
                SimpleForm.this.layout.setRowSpec(this.rowIndex, new RowSpec(SimpleForm.this.rowSpacing + "px"));
            }
        }
    }
}

