/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.support.EmptyModelItem;
import com.eviware.soapui.support.ListDataListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanelImpl;
import com.eviware.soapui.support.swing.ModelItemListMouseListener;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ModelItemListDesktopPanel
extends DefaultDesktopPanel {
    private final ModelItem[] modelItems;
    private JList list;
    private ItemsListModel listModel;
    private InternalTreeModelListener treeModelListener;
    private Map<ModelItem, StringList> detailInfo = new HashMap<ModelItem, StringList>();
    private JList detailList;
    private DetailsListModel detailListModel;

    public ModelItemListDesktopPanel(String title, String description, ModelItem[] modelItems) {
        super(title, description, new JPanel(new BorderLayout()));
        this.modelItems = modelItems;
        this.buildUI();
        this.treeModelListener = new InternalTreeModelListener();
        SoapUI.getNavigator().getMainTree().getModel().addTreeModelListener(this.treeModelListener);
    }

    public void addDetails(ModelItem modelItem, String details) {
        if (!this.detailInfo.containsKey(modelItem)) {
            this.detailInfo.put(modelItem, new StringList());
        }
        this.detailInfo.get(modelItem).add(details);
    }

    private void buildUI() {
        JPanel p = (JPanel)this.getComponent();
        p.add((Component)UISupport.buildDescription(this.getTitle(), this.getDescription(), null), "North");
        p.add(this.buildModelItemList(), "Center");
    }

    public boolean onClose(boolean canCancel) {
        SoapUI.getNavigator().getMainTree().getModel().removeTreeModelListener(this.treeModelListener);
        return super.onClose(canCancel);
    }

    private Component buildModelItemList() {
        this.listModel = new ItemsListModel(this.modelItems);
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new ItemListCellRenderer());
        ModelItemListMouseListener modelItemListMouseListener = new ModelItemListMouseListener();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new RemoveAction());
        popupMenu.add(new HighlightAction());
        modelItemListMouseListener.setPopupMenu(popupMenu);
        this.list.addMouseListener(modelItemListMouseListener);
        this.listModel.addListDataListener(new ListDataListenerAdapter(){

            public void intervalRemoved(ListDataEvent e) {
                if (ModelItemListDesktopPanel.this.listModel.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SoapUI.getDesktop().closeDesktopPanel(ModelItemListDesktopPanel.this);
                        }
                    });
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ModelItemListDesktopPanel.this.detailListModel.refresh();
            }
        });
        JInspectorPanelImpl inspectorPanel = new JInspectorPanelImpl(new JScrollPane(this.list));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildDetails(), "Details", "Shows detailed information for the selected item", true));
        return inspectorPanel;
    }

    private JComponent buildDetails() {
        this.detailListModel = new DetailsListModel();
        this.detailList = new JList(this.detailListModel);
        return new JScrollPane(this.detailList);
    }

    private class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private ItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ModelItem) {
                ModelItem item = (ModelItem)value;
                TreePath treePath = SoapUI.getNavigator().getTreePath(item);
                if (treePath == null) {
                    if (!(item instanceof EmptyModelItem)) {
                        // empty if block
                    }
                    label.setText("<removed>");
                    label.setToolTipText(null);
                } else {
                    String str = item.getName() + " [";
                    for (int c = 1; c < treePath.getPathCount(); ++c) {
                        SoapUITreeNode comp = (SoapUITreeNode)treePath.getPathComponent(c);
                        if (comp.getModelItem() instanceof EmptyModelItem) continue;
                        if (c > 1) {
                            str = str + " - ";
                        }
                        str = str + comp.toString();
                    }
                    str = str + "]";
                    label.setText(str);
                    label.setToolTipText(item.getDescription());
                }
                label.setIcon(item.getIcon());
                label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
            return label;
        }
    }

    private final class InternalTreeModelListener
    implements TreeModelListener {
        private InternalTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            ModelItemListDesktopPanel.this.listModel.nodesChanged();
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int c = 0; c < ModelItemListDesktopPanel.this.listModel.getSize(); ++c) {
                        if (SoapUI.getNavigator().getTreePath((ModelItem)ModelItemListDesktopPanel.this.listModel.elementAt(c)) != null) continue;
                        ModelItemListDesktopPanel.this.listModel.remove(c);
                        --c;
                    }
                }
            });
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    private class HighlightAction
    extends AbstractAction {
        public HighlightAction() {
            super("Select in Tree");
            this.putValue("ShortDescription", "Selects this node in the Navigator Tree");
        }

        public void actionPerformed(ActionEvent e) {
            int ix = ModelItemListDesktopPanel.this.list.getSelectedIndex();
            if (ix != -1) {
                UISupport.select((ModelItem)ModelItemListDesktopPanel.this.listModel.getElementAt(ix));
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super("Remove");
            this.putValue("ShortDescription", "Removes this item from the list");
        }

        public void actionPerformed(ActionEvent e) {
            int ix = ModelItemListDesktopPanel.this.list.getSelectedIndex();
            if (ix != -1 && UISupport.confirm("Remove selected item from list?", "Remove Item")) {
                ModelItemListDesktopPanel.this.listModel.remove(ix);
            }
        }
    }

    private class ItemsListModel
    extends DefaultListModel {
        public ItemsListModel(ModelItem[] modelItems) {
            for (ModelItem item : modelItems) {
                this.addElement(item);
            }
        }

        public void nodesChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    private class DetailsListModel
    extends AbstractListModel {
        private DetailsListModel() {
        }

        public Object getElementAt(int index) {
            ModelItem modelItem = (ModelItem)ModelItemListDesktopPanel.this.list.getSelectedValue();
            if (modelItem == null || !ModelItemListDesktopPanel.this.detailInfo.containsKey(modelItem)) {
                return null;
            }
            return ((StringList)ModelItemListDesktopPanel.this.detailInfo.get(modelItem)).get(index);
        }

        public void refresh() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public int getSize() {
            ModelItem modelItem = (ModelItem)ModelItemListDesktopPanel.this.list.getSelectedValue();
            if (modelItem == null || !ModelItemListDesktopPanel.this.detailInfo.containsKey(modelItem)) {
                return 0;
            }
            return ((StringList)ModelItemListDesktopPanel.this.detailInfo.get(modelItem)).size();
        }
    }
}

