/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes.support;

import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.model.tree.nodes.support.EmptyModelItem;
import com.eviware.soapui.support.UISupport;

public class WsdlLoadTestsModelItem
extends EmptyModelItem {
    private TestCase testCase;
    private TestSuiteListener listener = new InternalTestSuiteListener();

    public WsdlLoadTestsModelItem(TestCase testCase) {
        super(WsdlLoadTestsModelItem.createLabel(testCase), UISupport.createImageIcon("/loadtests.gif"));
        this.testCase = testCase;
        testCase.getTestSuite().addTestSuiteListener(this.listener);
    }

    private static String createLabel(TestCase testCase) {
        return "Load Tests (" + testCase.getLoadTestCount() + ")";
    }

    public Settings getSettings() {
        return this.testCase.getSettings();
    }

    public void release() {
        super.release();
        this.testCase.getTestSuite().removeTestSuiteListener(this.listener);
    }

    public String getName() {
        return WsdlLoadTestsModelItem.createLabel(this.testCase);
    }

    public void updateLabel() {
        this.setName(WsdlLoadTestsModelItem.createLabel(this.testCase));
    }

    public class InternalTestSuiteListener
    extends TestSuiteListenerAdapter
    implements TestSuiteListener {
        public void loadTestAdded(LoadTest loadTest) {
            if (loadTest.getTestCase() == WsdlLoadTestsModelItem.this.testCase) {
                WsdlLoadTestsModelItem.this.updateLabel();
            }
        }

        public void loadTestRemoved(LoadTest loadTest) {
            if (loadTest.getTestCase() == WsdlLoadTestsModelItem.this.testCase) {
                WsdlLoadTestsModelItem.this.updateLabel();
            }
        }

        public void testCaseRemoved(TestCase testCase) {
            if (testCase == WsdlLoadTestsModelItem.this.testCase) {
                testCase.getTestSuite().removeTestSuiteListener(WsdlLoadTestsModelItem.this.listener);
            }
        }
    }
}

