/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.TreeNodeFactory;
import com.eviware.soapui.model.tree.nodes.RestMethodTreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestResourceTreeNode
extends AbstractModelItemTreeNode<RestResource>
implements PropertyChangeListener {
    private List<RestResourceTreeNode> resourceNodes = new ArrayList<RestResourceTreeNode>();
    private List<RestMethodTreeNode> methodNodes = new ArrayList<RestMethodTreeNode>();
    private final RestResource restResource;
    private AbstractModelItemTreeNode.ReorderPropertyChangeListener propertyChangeListener = new AbstractModelItemTreeNode.ReorderPropertyChangeListener();

    public RestResourceTreeNode(RestResource restResource, SoapUITreeModel treeModel) {
        super(restResource, restResource.getParent(), treeModel);
        int c;
        this.restResource = restResource;
        treeModel.mapModelItem(this);
        for (c = 0; c < restResource.getChildResourceCount(); ++c) {
            this.resourceNodes.add(new RestResourceTreeNode(restResource.getChildResourceAt(c), this.getTreeModel()));
        }
        treeModel.mapModelItems(this.resourceNodes);
        for (c = 0; c < restResource.getRestMethodCount(); ++c) {
            this.methodAdded(restResource.getRestMethodAt(c));
        }
    }

    @Override
    public SoapUITreeNode getParentTreeNode() {
        return this.restResource.getParentResource() == null ? super.getParentTreeNode() : this.getTreeModel().getTreeNode(this.restResource.getParentResource());
    }

    @Override
    public String toString() {
        return this.restResource.getName() + " [" + this.restResource.getFullPath() + "]";
    }

    @Override
    public int getChildCount() {
        return this.restResource.getRestMethodCount() + this.restResource.getChildResourceCount();
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        int childCount = this.methodNodes.size();
        if (index < childCount) {
            return this.methodNodes.get(index);
        }
        return this.resourceNodes.get(index - childCount);
    }

    @Override
    public int getIndexOfChild(Object child) {
        int result = this.methodNodes.indexOf(child);
        if (result == -1 && (result = this.resourceNodes.indexOf(child)) >= 0) {
            result += this.methodNodes.size();
        }
        return result;
    }

    @Override
    public void release() {
        super.release();
        for (RestMethodTreeNode treeNode : this.methodNodes) {
            ((RestMethod)treeNode.getModelItem()).removePropertyChangeListener(Request.NAME_PROPERTY, this.propertyChangeListener);
            treeNode.release();
        }
        for (RestResourceTreeNode resource : this.resourceNodes) {
            resource.release();
        }
    }

    public void addChildResource(RestResource restResource) {
        RestResourceTreeNode operationTreeNode = (RestResourceTreeNode)TreeNodeFactory.createTreeNode(restResource, this.getTreeModel());
        this.resourceNodes.add(operationTreeNode);
        this.getTreeModel().notifyNodeInserted(operationTreeNode);
    }

    public void removeChildResource(RestResourceTreeNode childResource) {
        if (this.resourceNodes.contains(childResource)) {
            this.getTreeModel().notifyNodeRemoved(childResource);
            this.resourceNodes.remove(childResource);
        }
    }

    public void methodAdded(RestMethod method) {
        RestMethodTreeNode methodTreeNode = new RestMethodTreeNode(method, this.getTreeModel());
        this.methodNodes.add(methodTreeNode);
        this.reorder(false);
        method.addPropertyChangeListener(Request.NAME_PROPERTY, this.propertyChangeListener);
        this.getTreeModel().notifyNodeInserted(methodTreeNode);
    }

    public void methodRemoved(RestMethod method) {
        SoapUITreeNode methodTreeNode = this.getTreeModel().getTreeNode(method);
        if (!this.methodNodes.contains(methodTreeNode)) {
            throw new RuntimeException("Removing unknown method");
        }
        this.getTreeModel().notifyNodeRemoved(methodTreeNode);
        this.methodNodes.remove(methodTreeNode);
        method.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("childMethods")) {
            if (evt.getNewValue() != null) {
                this.methodAdded((RestMethod)evt.getNewValue());
            } else {
                this.methodRemoved((RestMethod)evt.getOldValue());
            }
        }
    }
}

