/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.soap;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.WsaAssertionConfiguration;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaValidator;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class WSARequestAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "WS-A Request Assertion";
    public static final String LABEL = "WS-Addressing Request";
    private WsaAssertionConfiguration wsaAssertionConfiguration;
    private boolean assertWsaAction;
    private boolean assertWsaTo;
    private boolean assertWsaReplyTo;
    private boolean assertWsaMessageId;
    private XFormDialog dialog;
    private static final String ASSERT_ACTION = "wsa:Action";
    private static final String ASSERT_TO = "wsa:To";
    private static final String ASSERT_REPLY_TO = "wsa:ReplyTo";
    private static final String ASSERT_MESSAGE_ID = "wsa:MessageId";

    public WSARequestAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, false, true, false, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.assertWsaAction = reader.readBoolean("asertWsaAction", true);
        this.assertWsaTo = reader.readBoolean("asertWsaTo", false);
        this.assertWsaReplyTo = reader.readBoolean("assertWsaReplyTo", false);
        this.assertWsaMessageId = reader.readBoolean("assertWsaMessageId", false);
        this.wsaAssertionConfiguration = new WsaAssertionConfiguration(this.assertWsaAction, this.assertWsaTo, this.assertWsaReplyTo, this.assertWsaMessageId, false, false, false);
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        try {
            new WsaValidator((WsdlMessageExchange)messageExchange, this.wsaAssertionConfiguration).validateWsAddressingRequest();
        }
        catch (AssertionException e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        catch (XmlException e) {
            SoapUI.logError(e);
            throw new AssertionException(new AssertionError("There has been some XmlException, ws-a couldn't be validated properly."));
        }
        return "Request WS-Addressing is valid";
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(ASSERT_ACTION, this.assertWsaAction);
        values.put(ASSERT_TO, this.assertWsaTo);
        values.put(ASSERT_REPLY_TO, this.assertWsaReplyTo);
        values.put(ASSERT_MESSAGE_ID, this.assertWsaMessageId);
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            this.assertWsaAction = values.getBoolean(ASSERT_ACTION);
            this.assertWsaTo = values.getBoolean(ASSERT_TO);
            this.assertWsaReplyTo = values.getBoolean(ASSERT_REPLY_TO);
            this.assertWsaMessageId = values.getBoolean(ASSERT_MESSAGE_ID);
        }
        this.wsaAssertionConfiguration = new WsaAssertionConfiguration(this.assertWsaAction, this.assertWsaTo, this.assertWsaReplyTo, this.assertWsaMessageId, false, false, false);
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Ws-a properties to assert");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addCheckBox(ASSERT_ACTION, "Check if 'wsa:Action' exists");
        mainForm.addCheckBox(ASSERT_TO, "Check if 'wsa:To' exists");
        mainForm.addCheckBox(ASSERT_REPLY_TO, "Check if 'wsa:ReplyTo' exists");
        mainForm.addCheckBox(ASSERT_MESSAGE_ID, "Check if 'wsa:MessageId' exists");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/userguide/functional/response-assertions.html#Simple_Contains"), "Specify options", UISupport.OPTIONS_ICON);
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("asertWsaAction", this.assertWsaAction);
        builder.add("asertWsaTo", this.assertWsaTo);
        builder.add("assertWsaReplyTo", this.assertWsaReplyTo);
        builder.add("assertWsaMessageId", this.assertWsaMessageId);
        return builder.finish();
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(WSARequestAssertion.ID, WSARequestAssertion.LABEL, WSARequestAssertion.class, WsdlMockResponseTestStep.class);
        }
    }
}

