/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.soap;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;

public class SoapFaultAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "Not SOAP Fault Assertion";
    public static final String LABEL = "SOAP Fault";

    public SoapFaultAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, false, false, true);
    }

    public String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        String responseContent = messageExchange.getResponseContent();
        try {
            SoapVersion soapVersion = ((WsdlMessageExchange)messageExchange).getOperation().getInterface().getSoapVersion();
            if (!SoapUtils.isSoapFault(responseContent, soapVersion)) {
                throw new AssertionException(new AssertionError("Response is not a SOAP Fault"));
            }
        }
        catch (Exception e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        return "Response is a SOAP Fault";
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(SoapFaultAssertion.ID, SoapFaultAssertion.LABEL, SoapFaultAssertion.class, WsdlRequest.class);
        }
    }
}

