/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.binding.PresentationModel;
import javax.swing.JComponent;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.w3c.dom.Document;

public class AddTimestampEntry
extends WssEntryBase {
    public static final String TYPE = "Timestamp";
    private int timeToLive;
    private boolean strictTimestamp;

    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    protected JComponent buildUI() {
        SimpleBindingForm form = new SimpleBindingForm(new PresentationModel((Object)this));
        form.addSpace(5);
        form.appendTextField("timeToLive", "Time To Live", "Sets the TimeToLive value for the Timestamp Token");
        form.appendCheckBox("strictTimestamp", "Millisecond Precision", "Sets precision of timestamp to milliseconds");
        return form.getPanel();
    }

    protected void load(XmlObjectConfigurationReader reader) {
        this.timeToLive = reader.readInt("timeToLive", 0);
        this.strictTimestamp = reader.readBoolean("strictTimestamp", true);
    }

    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("timeToLive", this.timeToLive);
        builder.add("strictTimestamp", this.strictTimestamp);
    }

    public void process(WSSecHeader secHeader, Document doc, PropertyExpansionContext context) {
        if (this.timeToLive <= 0) {
            return;
        }
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(this.timeToLive);
        if (!this.strictTimestamp) {
            WSSConfig wsc = WSSConfig.getNewInstance();
            wsc.setPrecisionInMilliSeconds(false);
            wsc.setTimeStampStrict(false);
            timestamp.setWsConfig(wsc);
        }
        timestamp.build(doc, secHeader);
    }

    public String getTimeToLive() {
        return String.valueOf(this.timeToLive);
    }

    public boolean isStrictTimestamp() {
        return this.strictTimestamp;
    }

    public void setStrictTimestamp(boolean strictTimestamp) {
        this.strictTimestamp = strictTimestamp;
        this.saveConfig();
    }

    public void setTimeToLive(String timeToLive) {
        try {
            this.timeToLive = Integer.valueOf(timeToLive);
            this.saveConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

