/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.crypto;

import com.eviware.soapui.config.WSSCryptoConfig;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public abstract class WssCryptoBase
implements WssCrypto,
PropertyExpansionContainer {
    private WSSCryptoConfig config;
    private WssContainer container;
    private JComponent configComponent;
    private String label;

    public void init(WSSCryptoConfig config, WssContainer container, String label) {
        this.config = config;
        this.container = container;
        this.label = label;
        if (config.getConfiguration() == null) {
            config.addNewConfiguration();
        }
        this.load(new XmlObjectConfigurationReader(config.getConfiguration()));
    }

    public JComponent getConfigurationPanel() {
        if (this.configComponent == null) {
            this.configComponent = this.buildUI();
        }
        return this.configComponent;
    }

    public String getLabel() {
        return this.label;
    }

    protected abstract JComponent buildUI();

    protected abstract void load(XmlObjectConfigurationReader var1);

    public void setConfig(WSSCryptoConfig config) {
        this.config = config;
    }

    public void saveConfig() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        this.save(builder);
        this.config.getConfiguration().set(builder.finish());
    }

    protected abstract void save(XmlObjectConfigurationBuilder var1);

    public WssContainer getContainer() {
        return this.container;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.getContainer().getModelItem(), this);
        this.addPropertyExpansions(result);
        return result.toArray();
    }

    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        result.extractAndAddAll("username");
        result.extractAndAddAll("password");
    }

    public String toString() {
        return this.getLabel();
    }

    public void udpateConfig(WSSCryptoConfig config) {
        this.config = config;
    }
}

