/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.crypto;

import com.eviware.soapui.config.WSSCryptoConfig;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.WssCryptoBase;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.binding.PresentationModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;

public abstract class MerlinCrypto
extends WssCryptoBase {
    public static final String TYPE = "Merlin";
    private String keystore;
    private String password;
    private String type;
    private JButton validateButton;

    protected JComponent buildUI() {
        SimpleBindingForm form = new SimpleBindingForm(new PresentationModel((Object)this));
        form.appendTextField("keystore", "Keystore", "The keystore file");
        form.appendTextField("password", "Password", "The keystore password");
        form.appendComboBox("type", "Type", new String[]{"JKS", "PKCS12"}, "The keystore type");
        this.validateButton = new JButton("Validate");
        form.addRightComponent(this.validateButton);
        this.validateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNullOrEmpty(MerlinCrypto.this.getPassword())) {
                    UISupport.showErrorMessage("Missing password");
                    return;
                }
                try {
                    Crypto crypto = MerlinCrypto.this.getCrypto();
                    UISupport.showInfoMessage("Loaded keystore of type: " + crypto.getKeyStore().getType());
                }
                catch (Throwable t) {
                    UISupport.showErrorMessage(t);
                }
            }
        });
        return form.getPanel();
    }

    public String getSource() {
        return this.getKeystore();
    }

    protected void load(XmlObjectConfigurationReader reader) {
        this.keystore = reader.readString("keystore", null);
        this.password = reader.readString("password", null);
        this.type = reader.readString("type", "jks");
    }

    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("keystore", this.keystore);
        builder.add("password", this.password);
        builder.add("type", this.type);
    }

    public Crypto getCrypto() {
        Properties properties = new Properties();
        properties.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        properties.put("org.apache.ws.security.crypto.merlin.keystore.type", this.type.toLowerCase());
        properties.put("org.apache.ws.security.crypto.merlin.keystore.password", this.getPassword());
        properties.put("org.apache.ws.security.crypto.merlin.file", this.getKeystore());
        Crypto crypto = CryptoFactory.getInstance((Properties)properties);
        return crypto;
    }

    public void init(WSSCryptoConfig config, WssContainer container) {
        super.init(config, container, TYPE);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
        this.saveConfig();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.saveConfig();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.saveConfig();
    }

    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        super.addPropertyExpansions(result);
        result.extractAndAddAll("keystore");
    }

    public String getLabel() {
        if (StringUtils.isNullOrEmpty(this.keystore)) {
            return super.getLabel();
        }
        int ix = this.keystore.lastIndexOf(File.separatorChar);
        return ix == -1 ? this.keystore : this.keystore.substring(ix + 1);
    }

    public WssContainer getWssContainer() {
        return null;
    }
}

