/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss;

import com.eviware.soapui.config.IncomingWssConfig;
import com.eviware.soapui.config.KeyMaterialCryptoConfig;
import com.eviware.soapui.config.OutgoingWssConfig;
import com.eviware.soapui.config.WssContainerConfig;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainerListener;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.KeyMaterialWssCrypto;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringList;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWssContainer
implements WssContainer {
    private final ModelItem modelItem;
    private List<WssCrypto> cryptos = new ArrayList<WssCrypto>();
    private List<IncomingWss> incomingWssConfigs = new ArrayList<IncomingWss>();
    private List<OutgoingWss> outgoingWssConfigs = new ArrayList<OutgoingWss>();
    private final WssContainerConfig config;
    private Set<WssContainerListener> listeners = new HashSet<WssContainerListener>();

    public DefaultWssContainer(ModelItem modelItem, WssContainerConfig config) {
        this.modelItem = modelItem;
        this.config = config;
        for (KeyMaterialCryptoConfig cryptoConfig : config.getCryptoList()) {
            this.cryptos.add(new KeyMaterialWssCrypto(cryptoConfig, this));
        }
        for (IncomingWssConfig wssConfig : config.getIncomingList()) {
            this.incomingWssConfigs.add(new IncomingWss(wssConfig, this));
        }
        for (IncomingWssConfig wssConfig : config.getOutgoingList()) {
            this.outgoingWssConfigs.add(new OutgoingWss((OutgoingWssConfig)wssConfig, this));
        }
    }

    @Override
    public ModelItem getModelItem() {
        return this.modelItem;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.getModelItem(), this);
        for (OutgoingWss entry : this.outgoingWssConfigs) {
            result.addAll(entry.getPropertyExpansions());
        }
        return result.toArray();
    }

    @Override
    public List<WssCrypto> getCryptoList() {
        return new ArrayList<WssCrypto>(this.cryptos);
    }

    @Override
    public WssCrypto addCrypto(String source, String password) {
        KeyMaterialWssCrypto result = new KeyMaterialWssCrypto(this.getConfig().addNewCrypto(), this, source, password);
        this.cryptos.add(result);
        this.fireCryptoAdded(result);
        return result;
    }

    protected void fireCryptoAdded(WssCrypto crypto) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.cryptoAdded(crypto);
        }
    }

    protected void fireCryptoRemoved(WssCrypto crypto) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.cryptoRemoved(crypto);
        }
    }

    public WssContainerConfig getConfig() {
        return this.config;
    }

    @Override
    public int getCryptoCount() {
        return this.cryptos.size();
    }

    @Override
    public WssCrypto getCryptoAt(int index) {
        return this.cryptos.get(index);
    }

    @Override
    public void removeCryptoAt(int row) {
        WssCrypto crypto = this.cryptos.remove(row);
        this.fireCryptoRemoved(crypto);
        this.getConfig().removeCrypto(row);
    }

    @Override
    public List<IncomingWss> getIncomingWssList() {
        return new ArrayList<IncomingWss>(this.incomingWssConfigs);
    }

    @Override
    public IncomingWss addIncomingWss(String label) {
        IncomingWss incomingWss = new IncomingWss(this.getConfig().addNewIncoming(), this);
        incomingWss.setName(label);
        this.incomingWssConfigs.add(incomingWss);
        this.fireIncomingWssAdded(incomingWss);
        return incomingWss;
    }

    @Override
    public int getIncomingWssCount() {
        return this.incomingWssConfigs.size();
    }

    @Override
    public IncomingWss getIncomingWssAt(int index) {
        return this.incomingWssConfigs.get(index);
    }

    @Override
    public void removeIncomingWssAt(int row) {
        IncomingWss incomingWss = this.incomingWssConfigs.remove(row);
        this.fireIncomingWssRemoved(incomingWss);
        this.getConfig().removeIncoming(row);
    }

    protected void fireIncomingWssAdded(IncomingWss incomingWss) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.incomingWssAdded(incomingWss);
        }
    }

    protected void fireIncomingWssRemoved(IncomingWss incomingWss) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.incomingWssRemoved(incomingWss);
        }
    }

    @Override
    public List<OutgoingWss> getOutgoingWssList() {
        return new ArrayList<OutgoingWss>(this.outgoingWssConfigs);
    }

    @Override
    public OutgoingWss addOutgoingWss(String label) {
        OutgoingWss result = new OutgoingWss(this.getConfig().addNewOutgoing(), this);
        result.setName(label);
        this.outgoingWssConfigs.add(result);
        this.fireOutgoingWssAdded(result);
        return result;
    }

    protected void fireOutgoingWssAdded(OutgoingWss result) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.outgoingWssAdded(result);
        }
    }

    protected void fireOutgoingWssRemoved(OutgoingWss result) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.outgoingWssRemoved(result);
        }
    }

    @Override
    public int getOutgoingWssCount() {
        return this.outgoingWssConfigs.size();
    }

    @Override
    public OutgoingWss getOutgoingWssAt(int index) {
        return this.outgoingWssConfigs.get(index);
    }

    @Override
    public void removeOutgoingWssAt(int row) {
        OutgoingWss outgoingWss = this.outgoingWssConfigs.remove(row);
        this.fireOutgoingWssRemoved(outgoingWss);
        outgoingWss.release();
        this.getConfig().removeOutgoing(row);
    }

    @Override
    public WssCrypto getCryptoByName(String cryptoName) {
        for (WssCrypto crypto : this.cryptos) {
            if (!crypto.getLabel().equals(cryptoName)) continue;
            return crypto;
        }
        return null;
    }

    @Override
    public IncomingWss getIncomingWssByName(String incomingName) {
        for (IncomingWss incomingWss : this.incomingWssConfigs) {
            if (!incomingWss.getName().equals(incomingName)) continue;
            return incomingWss;
        }
        return null;
    }

    @Override
    public OutgoingWss getOutgoingWssByName(String outgoingName) {
        for (OutgoingWss crypto : this.outgoingWssConfigs) {
            if (!crypto.getName().equals(outgoingName)) continue;
            return crypto;
        }
        return null;
    }

    @Override
    public void addWssContainerListener(WssContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeWssContainerListener(WssContainerListener listener) {
        this.listeners.remove(listener);
    }

    public void fireWssEntryAdded(WssEntry newEntry) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.outgoingWssEntryAdded(newEntry);
        }
    }

    public void fireWssEntryRemoved(WssEntry entry) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.outgoingWssEntryRemoved(entry);
        }
    }

    @Override
    public String[] getCryptoNames() {
        StringList result = new StringList();
        for (WssCrypto crypto : this.getCryptoList()) {
            result.add(crypto.getLabel());
        }
        return result.toStringArray();
    }

    @Override
    public String[] getIncomingWssNames() {
        StringList result = new StringList();
        for (IncomingWss crypto : this.getIncomingWssList()) {
            result.add(crypto.getName());
        }
        return result.toStringArray();
    }

    @Override
    public String[] getOutgoingWssNames() {
        StringList result = new StringList();
        for (OutgoingWss crypto : this.getOutgoingWssList()) {
            result.add(crypto.getName());
        }
        return result.toStringArray();
    }

    @Override
    public void importConfig(WssContainer wssContainer) {
    }

    public void resetConfig(WssContainerConfig config) {
        int c;
        this.getConfig().set((XmlObject)config);
        for (c = 0; c < this.cryptos.size(); ++c) {
            ((KeyMaterialWssCrypto)this.cryptos.get(c)).udpateConfig(this.getConfig().getCryptoArray(c));
        }
        for (c = 0; c < this.incomingWssConfigs.size(); ++c) {
            this.incomingWssConfigs.get(c).updateConfig(this.getConfig().getIncomingArray(c));
        }
        for (c = 0; c < this.outgoingWssConfigs.size(); ++c) {
            this.outgoingWssConfigs.get(c).updateConfig(this.getConfig().getOutgoingArray(c));
        }
    }

    public void fireCryptoUpdated(KeyMaterialWssCrypto crypto) {
        for (WssContainerListener listener : this.listeners.toArray(new WssContainerListener[this.listeners.size()])) {
            listener.cryptoUpdated(crypto);
        }
    }

    public void resolve(ResolveContext<?> context) {
        int c;
        for (c = 0; c < this.cryptos.size(); ++c) {
            ((KeyMaterialWssCrypto)this.cryptos.get(c)).resolve(context);
        }
        for (c = 0; c < this.incomingWssConfigs.size(); ++c) {
            this.incomingWssConfigs.get(c).resolve(context);
        }
        for (c = 0; c < this.outgoingWssConfigs.size(); ++c) {
            this.outgoingWssConfigs.get(c).resolve(context);
        }
    }

    public void release() {
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

