/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsrm;

import com.eviware.soapui.config.WsrmVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsmc.WsmcInjection;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmSequence;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import java.util.HashMap;

public class WsrmTestRunListener
implements TestRunListener {
    private HashMap<String, WsrmSequence> wsrmMap;

    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        if (this.wsrmMap != null) {
            for (String endpoint : this.wsrmMap.keySet()) {
                WsrmSequence sequence = this.wsrmMap.get(endpoint);
                WsrmUtils utils = new WsrmUtils(sequence.getSoapVersion());
                utils.closeSequence(endpoint, sequence.getSoapVersion(), sequence.getWsrmNameSpace(), sequence.getUuid(), sequence.getIdentifier(), sequence.getLastMsgNumber(), sequence.getOperation());
            }
        }
        this.wsrmMap = null;
    }

    public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
    }

    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
        TestStep currentStep = testStep;
        WsdlTestCase testCase = (WsdlTestCase)runContext.getTestCase();
        if (currentStep instanceof WsdlTestRequestStep && testCase.getWsrmEnabled()) {
            if (this.wsrmMap == null) {
                this.wsrmMap = new HashMap();
            }
            WsdlTestRequestStep requestStep = (WsdlTestRequestStep)currentStep;
            String endpoint = requestStep.getHttpRequest().getEndpoint();
            SoapVersion soapVersion = requestStep.getOperation().getInterface().getSoapVersion();
            if (!this.wsrmMap.containsKey(endpoint)) {
                WsrmUtils utils = new WsrmUtils(soapVersion);
                WsrmSequence sequence = utils.createSequence(endpoint, soapVersion, testCase.getWsrmVersionNamespace(), testCase.getWsrmAckTo(), testCase.getWsrmExpires(), requestStep.getOperation(), null);
                this.wsrmMap.put(endpoint, sequence);
            }
            WsrmSequence sequence = this.wsrmMap.get(endpoint);
            WsdlTestRequest wsdlRequest = requestStep.getHttpRequest();
            wsdlRequest.getWsrmConfig().setVersion(testCase.getWsrmVersion());
            wsdlRequest.getWsrmConfig().setSequenceIdentifier(sequence.getIdentifier());
            wsdlRequest.getWsrmConfig().setLastMessageId(sequence.incrementLastMsgNumber());
            wsdlRequest.getWsrmConfig().setUuid(sequence.getUuid());
            wsdlRequest.getWsrmConfig().setWsrmEnabled(true);
            if (testCase.getWsrmVersion() != WsrmVersionTypeConfig.X_1_0.toString()) {
                WsmcInjection injection = new WsmcInjection(wsdlRequest.getEndpoint(), wsdlRequest.getOperation(), soapVersion, wsdlRequest.getWsrmConfig().getUuid());
                wsdlRequest.setAfterRequestInjection(injection);
            }
        }
    }
}

