/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlValidator {
    private final WsdlContext wsdlContext;
    private static final Logger log = Logger.getLogger(WsdlValidator.class);

    public WsdlValidator(WsdlContext wsdlContext) {
        this.wsdlContext = wsdlContext;
    }

    public AssertionError[] assertRequest(WsdlMessageExchange messageExchange, boolean envelopeOnly) {
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        try {
            String requestContent = messageExchange.getRequestContent();
            this.wsdlContext.getSoapVersion().validateSoapEnvelope(requestContent, errors);
            if (errors.isEmpty() && !envelopeOnly) {
                this.wsdlContext.getSoapVersion().validateSoapEnvelope(requestContent, errors);
                WsdlOperation operation = messageExchange.getOperation();
                BindingOperation bindingOperation = operation.getBindingOperation();
                if (bindingOperation == null) {
                    errors.add(XmlError.forMessage((String)("Missing operation [" + operation.getBindingOperationName() + "] in wsdl definition")));
                } else {
                    Part[] inputParts = WsdlUtils.getInputParts(bindingOperation);
                    this.validateMessage(messageExchange, requestContent, bindingOperation, inputParts, errors, false);
                }
            }
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        return this.convertErrors(errors);
    }

    private void validateInputAttachments(WsdlMessageExchange messageExchange, List<XmlError> errors, BindingOperation bindingOperation, Part[] inputParts) {
        for (Part part : inputParts) {
            MIMEContent[] contents = WsdlUtils.getInputMultipartContent(part, bindingOperation);
            if (contents.length == 0) continue;
            Attachment[] attachments = messageExchange.getRequestAttachmentsForPart(part.getName());
            if (attachments.length == 0) {
                errors.add(XmlError.forMessage((String)("Missing attachment for part [" + part.getName() + "]")));
            } else if (attachments.length == 1) {
                Attachment attachment = attachments[0];
                String types = "";
                for (MIMEContent content : contents) {
                    String type = content.getType();
                    if (type.equals(attachment.getContentType()) || type.toUpperCase().startsWith("MULTIPART")) {
                        types = null;
                        break;
                    }
                    if (types.length() > 0) {
                        types = types + ",";
                    }
                    types = types + type;
                }
                if (types != null) {
                    String msg = "Missing attachment for part [" + part.getName() + "] with content-type [" + types + "]," + " content type is [" + attachment.getContentType() + "]";
                    if (SoapUI.getSettings().getBoolean(WsdlSettings.ALLOW_INCORRECT_CONTENTTYPE)) {
                        log.warn((Object)msg);
                    } else {
                        errors.add(XmlError.forMessage((String)msg));
                    }
                }
            } else {
                String types = "";
                for (MIMEContent content : contents) {
                    String type = content.getType();
                    if (type.toUpperCase().startsWith("MULTIPART")) {
                        types = null;
                        break;
                    }
                    if (types.length() > 0) {
                        types = types + ",";
                    }
                    types = types + type;
                }
                if (types == null) {
                    String msg = "Too many attachments for part [" + part.getName() + "] with content-type [" + types + "]";
                    if (SoapUI.getSettings().getBoolean(WsdlSettings.ALLOW_INCORRECT_CONTENTTYPE)) {
                        log.warn((Object)msg);
                    } else {
                        errors.add(XmlError.forMessage((String)msg));
                    }
                }
            }
            if (attachments.length <= 0) continue;
            this.validateAttachmentsReadability(errors, attachments);
        }
    }

    private void validateOutputAttachments(WsdlMessageExchange messageExchange, XmlObject xml, List<XmlError> errors, BindingOperation bindingOperation, Part[] outputParts) throws Exception {
        for (Part part : outputParts) {
            String href;
            XmlObject[] children;
            XmlObject[] rpcBodyPart;
            MIMEContent[] contents = WsdlUtils.getOutputMultipartContent(part, bindingOperation);
            if (contents.length == 0) continue;
            Attachment[] attachments = messageExchange.getResponseAttachmentsForPart(part.getName());
            if (attachments.length == 0 && WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation) && (rpcBodyPart = this.getRpcBodyPart(bindingOperation, xml, true)).length == 1 && (children = rpcBodyPart[0].selectChildren(new QName(part.getName()))).length == 1 && (href = ((Element)children[0].getDomNode()).getAttribute("href")) != null) {
                if (href.startsWith("cid:")) {
                    href = href.substring(4);
                }
                attachments = messageExchange.getResponseAttachmentsForPart(href);
            }
            if (attachments.length == 0) {
                errors.add(XmlError.forMessage((String)("Missing attachment for part [" + part.getName() + "]")));
            } else if (attachments.length == 1) {
                Attachment attachment = attachments[0];
                String types = "";
                for (MIMEContent content : contents) {
                    String type = content.getType();
                    if (type.equals(attachment.getContentType()) || type.toUpperCase().startsWith("MULTIPART")) {
                        types = null;
                        break;
                    }
                    if (types.length() > 0) {
                        types = types + ",";
                    }
                    types = types + type;
                }
                if (types != null) {
                    String msg = "Missing attachment for part [" + part.getName() + "] with content-type [" + types + "], content type is [" + attachment.getContentType() + "]";
                    if (SoapUI.getSettings().getBoolean(WsdlSettings.ALLOW_INCORRECT_CONTENTTYPE)) {
                        log.warn((Object)msg);
                    } else {
                        errors.add(XmlError.forMessage((String)msg));
                    }
                }
            } else {
                String types = "";
                for (MIMEContent content : contents) {
                    String type = content.getType();
                    if (type.toUpperCase().startsWith("MULTIPART")) {
                        types = null;
                        break;
                    }
                    if (types.length() > 0) {
                        types = types + ",";
                    }
                    types = types + type;
                }
                if (types != null) {
                    String msg = "Too many attachments for part [" + part.getName() + "] with content-type [" + types + "]";
                    if (SoapUI.getSettings().getBoolean(WsdlSettings.ALLOW_INCORRECT_CONTENTTYPE)) {
                        log.warn((Object)msg);
                    } else {
                        errors.add(XmlError.forMessage((String)msg));
                    }
                }
            }
            if (attachments.length <= 0) continue;
            this.validateAttachmentsReadability(errors, attachments);
        }
    }

    private void validateAttachmentsReadability(List<XmlError> errors, Attachment[] attachments) {
        for (Attachment attachment : attachments) {
            try {
                attachment.getInputStream();
            }
            catch (Exception e) {
                errors.add(XmlError.forMessage((String)e.toString()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XmlObject[] getMessageParts(String messageContent, String operationName, boolean isResponse) throws Exception {
        Part[] parts;
        BindingOperation bindingOperation = this.findBindingOperation(operationName);
        if (bindingOperation == null) {
            throw new Exception("Missing operation [" + operationName + "] in wsdl definition");
        }
        if (!this.wsdlContext.hasSchemaTypes()) {
            throw new Exception("Missing schema types for message");
        }
        XmlObject msgXml = XmlObject.Factory.parse((String)messageContent);
        Part[] partArray = parts = isResponse ? WsdlUtils.getOutputParts(bindingOperation) : WsdlUtils.getInputParts(bindingOperation);
        if (parts == null || parts.length == 0) {
            throw new Exception("Missing parts for operation [" + operationName + "]");
        }
        ArrayList<XmlObject> result = new ArrayList<XmlObject>();
        if (WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation)) {
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "declare namespace ns='" + WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition()) + "';" + "$this/env:Envelope/env:Body/ns:" + bindingOperation.getName() + (isResponse ? "Response" : ""));
            if (paths.length != 1) {
                throw new Exception("Missing message wrapper element [" + WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition()) + "@" + bindingOperation.getName() + (isResponse ? "Response]" : "]"));
            }
            XmlObject wrapper = paths[0];
            for (int i = 0; i < parts.length; ++i) {
                SchemaType type;
                XmlObject[] children;
                Part part = parts[i];
                if (isResponse && WsdlUtils.isAttachmentOutputPart(part, bindingOperation) || !isResponse && WsdlUtils.isAttachmentInputPart(part, bindingOperation)) continue;
                QName partName = part.getElementName();
                if (partName == null) {
                    partName = new QName(part.getName());
                }
                if ((children = wrapper.selectChildren(partName)).length != 1) {
                    log.error((Object)("Missing message part [" + part.getName() + "]"));
                    continue;
                }
                QName typeName = part.getTypeName();
                if (typeName == null) {
                    typeName = partName;
                    type = this.wsdlContext.getSchemaTypeLoader().findElement(typeName);
                    if (type != null) {
                        result.add(children[0].copy().changeType(type.getType()));
                        continue;
                    }
                    log.error((Object)("Missing element [" + typeName + "] in associated schema for part [" + part.getName() + "]"));
                    continue;
                }
                type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    result.add(children[0].copy().changeType(type));
                    continue;
                }
                log.error((Object)("Missing type [" + typeName + "] in associated schema for part [" + part.getName() + "]"));
            }
            return result.toArray(new XmlObject[result.size()]);
        } else {
            Part part = parts[0];
            QName elementName = part.getElementName();
            if (elementName == null) return result.toArray(new XmlObject[result.size()]);
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "declare namespace ns='" + elementName.getNamespaceURI() + "';" + "$this/env:Envelope/env:Body/ns:" + elementName.getLocalPart());
            if (paths.length != 1) throw new Exception("Missing message part with name [" + elementName + "]");
            SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
            if (elm == null) throw new Exception("Missing part type in associated schema");
            result.add(paths[0].copy().changeType(elm.getType()));
        }
        return result.toArray(new XmlObject[result.size()]);
    }

    public void validateXml(String request, List<XmlError> errors) {
        try {
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setLoadLineNumbers();
            xmlOptions.setErrorListener(errors);
            xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
            XmlObject.Factory.parse((String)request, (XmlOptions)xmlOptions);
        }
        catch (XmlException e) {
            if (e.getErrors() != null) {
                errors.addAll(e.getErrors());
            }
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
    }

    private AssertionError[] convertErrors(List<XmlError> errors) {
        if (errors.size() > 0) {
            ArrayList<AssertionError> response = new ArrayList<AssertionError>();
            for (XmlError error : errors) {
                AssertionError assertionError;
                XmlValidationError e;
                QName offendingQName;
                if (error instanceof XmlValidationError && (offendingQName = (e = (XmlValidationError)error).getOffendingQName()) != null) {
                    if (offendingQName.equals(new QName(this.wsdlContext.getSoapVersion().getEnvelopeNamespace(), "encodingStyle"))) {
                        log.debug((Object)"ignoring encodingStyle validation..");
                        continue;
                    }
                    if (offendingQName.equals(new QName(this.wsdlContext.getSoapVersion().getEnvelopeNamespace(), "mustUnderstand"))) {
                        log.debug((Object)"ignoring mustUnderstand validation..");
                        continue;
                    }
                }
                if (response.contains(assertionError = new AssertionError(error))) continue;
                response.add(assertionError);
            }
            return response.toArray(new AssertionError[response.size()]);
        }
        return new AssertionError[0];
    }

    public void validateMessage(WsdlMessageExchange messageExchange, String message, BindingOperation bindingOperation, Part[] parts, List<XmlError> errors, boolean isResponse) {
        try {
            if (!this.wsdlContext.hasSchemaTypes()) {
                errors.add(XmlError.forMessage((String)"Missing schema types for message"));
            } else if (!WsdlUtils.isOutputSoapEncoded(bindingOperation)) {
                XmlOptions xmlOptions = new XmlOptions();
                xmlOptions.setLoadLineNumbers();
                xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
                XmlObject xml = XmlObject.Factory.parse((String)message, (XmlOptions)xmlOptions);
                XmlObject[] paths = xml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "$this/env:Envelope/env:Body/env:Fault");
                if (paths.length > 0) {
                    this.validateSoapFault(bindingOperation, paths[0], errors);
                } else if (WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation)) {
                    this.validateRpcLiteral(bindingOperation, parts, xml, errors, isResponse);
                } else {
                    this.validateDocLiteral(bindingOperation, parts, xml, errors, isResponse);
                }
                if (isResponse) {
                    this.validateOutputAttachments(messageExchange, xml, errors, bindingOperation, parts);
                } else {
                    this.validateInputAttachments(messageExchange, errors, bindingOperation, parts);
                }
            } else {
                errors.add(XmlError.forMessage((String)"Validation of SOAP-Encoded messages not supported"));
            }
        }
        catch (XmlException e) {
            if (e.getErrors() != null) {
                errors.addAll(e.getErrors());
            }
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        catch (Exception e) {
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
    }

    private BindingOperation findBindingOperation(String operationName) throws Exception {
        Map services = this.wsdlContext.getDefinition().getAllServices();
        Iterator i = services.keySet().iterator();
        while (i.hasNext()) {
            Service service = this.wsdlContext.getDefinition().getService((QName)i.next());
            Map ports = service.getPorts();
            Iterator iterator = ports.keySet().iterator();
            while (iterator.hasNext()) {
                BindingOperation bindingOperation;
                Port port = service.getPort((String)iterator.next());
                Binding binding = port.getBinding();
                if (!binding.getQName().equals(((WsdlInterface)this.wsdlContext.getInterface()).getBindingName()) || (bindingOperation = binding.getBindingOperation(operationName, null, null)) == null) continue;
                return bindingOperation;
            }
        }
        Map bindings = this.wsdlContext.getDefinition().getAllBindings();
        i = bindings.keySet().iterator();
        while (i.hasNext()) {
            BindingOperation bindingOperation;
            Binding binding = (Binding)bindings.get(i.next());
            if (!binding.getQName().equals(((WsdlInterface)this.wsdlContext.getInterface()).getBindingName()) || (bindingOperation = binding.getBindingOperation(operationName, null, null)) == null) continue;
            return bindingOperation;
        }
        return null;
    }

    public AssertionError[] assertResponse(WsdlMessageExchange messageExchange, boolean envelopeOnly) {
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        try {
            String response = messageExchange.getResponseContent();
            if (StringUtils.isNullOrEmpty(response)) {
                if (!messageExchange.getOperation().isOneWay()) {
                    errors.add(XmlError.forMessage((String)"Response is missing or empty"));
                }
            } else {
                this.wsdlContext.getSoapVersion().validateSoapEnvelope(response, errors);
                if (errors.isEmpty() && !envelopeOnly) {
                    WsdlOperation operation = messageExchange.getOperation();
                    BindingOperation bindingOperation = operation.getBindingOperation();
                    if (bindingOperation == null) {
                        errors.add(XmlError.forMessage((String)("Missing operation [" + operation.getBindingOperationName() + "] in wsdl definition")));
                    } else {
                        Part[] outputParts = WsdlUtils.getOutputParts(bindingOperation);
                        this.validateMessage(messageExchange, response, bindingOperation, outputParts, errors, true);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add(XmlError.forMessage((String)e.getMessage()));
        }
        return this.convertErrors(errors);
    }

    private void validateDocLiteral(BindingOperation bindingOperation, Part[] parts, XmlObject msgXml, List<XmlError> errors, boolean isResponse) throws Exception {
        Part part = null;
        for (int c = 0; c < parts.length; ++c) {
            if ((!isResponse || WsdlUtils.isAttachmentOutputPart(parts[c], bindingOperation)) && (isResponse || WsdlUtils.isAttachmentInputPart(parts[c], bindingOperation))) continue;
            if (part != null) {
                errors.add(XmlError.forMessage((String)"DocLiteral message must contain 1 body part definition"));
                return;
            }
            part = parts[c];
        }
        QName elementName = part.getElementName();
        if (elementName != null) {
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "declare namespace ns='" + elementName.getNamespaceURI() + "';" + "$this/env:Envelope/env:Body/ns:" + elementName.getLocalPart());
            if (paths.length == 1) {
                SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                if (elm != null) {
                    this.validateMessageBody(errors, elm.getType(), paths[0]);
                    NodeList children = XmlUtils.getChildElements((Element)paths[0].getDomNode().getParentNode());
                    for (int c = 0; c < children.getLength(); ++c) {
                        QName childName = XmlUtils.getQName(children.item(c));
                        if (elementName.equals(childName)) continue;
                        XmlCursor cur = paths[0].newCursor();
                        cur.toParent();
                        cur.toChild(childName);
                        errors.add(XmlError.forCursor((String)("Invalid element [" + childName + "] in SOAP Body"), (XmlCursor)cur));
                        cur.dispose();
                    }
                } else {
                    errors.add(XmlError.forMessage((String)("Missing part type [" + elementName + "] in associated schema")));
                }
            } else {
                errors.add(XmlError.forMessage((String)("Missing message part with name [" + elementName + "]")));
            }
        } else if (part.getTypeName() != null) {
            QName typeName = part.getTypeName();
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "declare namespace ns='" + typeName.getNamespaceURI() + "';" + "$this/env:Envelope/env:Body/ns:" + part.getName());
            if (paths.length == 1) {
                SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    this.validateMessageBody(errors, type, paths[0]);
                } else {
                    errors.add(XmlError.forMessage((String)"Missing part type in associated schema"));
                }
            } else {
                errors.add(XmlError.forMessage((String)("Missing message part with name:type [" + part.getName() + ":" + typeName + "]")));
            }
        }
    }

    private void validateMessageBody(List<XmlError> errors, SchemaType type, XmlObject msg) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        xmlOptions.setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
        XmlCursor cur = msg.newCursor();
        HashMap<String, String> map = new HashMap<String, String>();
        while (cur.hasNextToken()) {
            if (!cur.toNextToken().isNamespace()) continue;
            map.put(cur.getName().getLocalPart(), cur.getTextValue());
        }
        xmlOptions.setUseDefaultNamespace();
        xmlOptions.setSaveOuter();
        String xmlText = msg.copy().changeType(type).xmlText(xmlOptions);
        xmlOptions.setLoadAdditionalNamespaces(map);
        XmlObject obj = type.getTypeSystem().parse(xmlText, type, xmlOptions);
        obj = obj.changeType(type);
        ArrayList list = new ArrayList();
        xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(list);
        xmlOptions.setValidateTreatLaxAsSkip();
        obj.validate(xmlOptions);
        for (int c = 0; c < list.size(); ++c) {
            XmlError error = (XmlError)list.get(c);
            if (error instanceof XmlValidationError) {
                String text;
                XmlCursor cursor;
                XmlValidationError validationError = (XmlValidationError)error;
                if (this.wsdlContext.getSoapVersion().shouldIgnore(validationError) || (validationError.getErrorCode().equals("base64Binary") || validationError.getErrorCode().equals("hexBinary")) && (cursor = validationError.getCursorLocation()).toParent() && ((text = cursor.getTextValue()).startsWith("cid:") || text.startsWith("file:"))) continue;
            }
            int line = error.getLine() == -1 ? 0 : error.getLine() - 1;
            errors.add(XmlError.forLocation((String)error.getMessage(), (String)error.getSourceName(), (int)(this.getLine(msg) + line), (int)error.getColumn(), (int)error.getOffset()));
        }
    }

    private int getLine(XmlObject object) {
        ArrayList list = new ArrayList();
        object.newCursor().getAllBookmarkRefs(list);
        for (int c = 0; c < list.size(); ++c) {
            if (!(list.get(c) instanceof XmlLineNumber)) continue;
            return ((XmlLineNumber)list.get(c)).getLine();
        }
        return -1;
    }

    private void validateRpcLiteral(BindingOperation bindingOperation, Part[] parts, XmlObject msgXml, List<XmlError> errors, boolean isResponse) throws Exception {
        if (parts.length == 0) {
            return;
        }
        XmlObject[] bodyParts = this.getRpcBodyPart(bindingOperation, msgXml, isResponse);
        if (bodyParts.length != 1) {
            errors.add(XmlError.forMessage((String)("Missing message wrapper element [" + WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition()) + "@" + bindingOperation.getName() + (isResponse ? "Response" : ""))));
        } else {
            XmlObject wrapper = bodyParts[0];
            for (int i = 0; i < parts.length; ++i) {
                Part part = parts[i];
                if (!isResponse ? WsdlUtils.isAttachmentInputPart(part, bindingOperation) : WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) continue;
                XmlObject[] children = wrapper.selectChildren(new QName(part.getName()));
                if (children.length != 1) {
                    QName elementName = part.getElementName();
                    if (elementName != null) {
                        bodyParts = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "declare namespace ns='" + this.wsdlContext.getDefinition().getTargetNamespace() + "';" + "declare namespace ns2='" + elementName.getNamespaceURI() + "';" + "$this/env:Envelope/env:Body/ns:" + bindingOperation.getName() + (isResponse ? "Response" : "") + "/ns2:" + elementName.getLocalPart());
                        if (bodyParts.length == 1) {
                            SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                            if (elm != null) {
                                this.validateMessageBody(errors, elm.getType(), bodyParts[0]);
                                continue;
                            }
                            errors.add(XmlError.forMessage((String)("Missing part type in associated schema for [" + elementName + "]")));
                            continue;
                        }
                        errors.add(XmlError.forMessage((String)("Missing message part with name [" + elementName + "]")));
                        continue;
                    }
                    errors.add(XmlError.forMessage((String)("Missing message part [" + part.getName() + "]")));
                    continue;
                }
                QName typeName = part.getTypeName();
                SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    this.validateMessageBody(errors, type, children[0]);
                    continue;
                }
                errors.add(XmlError.forMessage((String)("Missing type in associated schema for part [" + part.getName() + "]")));
            }
        }
    }

    private XmlObject[] getRpcBodyPart(BindingOperation bindingOperation, XmlObject msgXml, boolean isResponse) throws Exception {
        String ns = WsdlUtils.getSoapBodyNamespace(isResponse ? bindingOperation.getBindingOutput().getExtensibilityElements() : bindingOperation.getBindingInput().getExtensibilityElements());
        if (ns == null || ns.trim().length() == 0) {
            ns = WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition());
        }
        XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';" + "declare namespace ns='" + ns + "';" + "$this/env:Envelope/env:Body/ns:" + bindingOperation.getName() + (isResponse ? "Response" : ""));
        return paths;
    }

    private void validateSoapFault(BindingOperation bindingOperation, XmlObject msgXml, List<XmlError> errors) throws Exception {
        Map faults = bindingOperation.getBindingFaults();
        Iterator i = faults.values().iterator();
        ArrayList list = new ArrayList();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(list);
        xmlOptions.setValidateTreatLaxAsSkip();
        msgXml.validate(xmlOptions);
        for (Object o : list) {
            if (o instanceof XmlError) {
                errors.add((XmlError)o);
                continue;
            }
            errors.add(XmlError.forMessage((String)o.toString()));
        }
        while (i.hasNext()) {
            BindingFault bindingFault = (BindingFault)i.next();
            String faultName = bindingFault.getName();
            Part[] faultParts = WsdlUtils.getFaultParts(bindingOperation, faultName);
            if (faultParts.length == 0) {
                log.warn((Object)("Missing fault parts in wsdl for fault [" + faultName + "] in bindingOperation [" + bindingOperation.getName() + "]"));
                continue;
            }
            if (faultParts.length != 1) {
                log.info((Object)("Too many fault parts in wsdl for fault [" + faultName + "] in bindingOperation [" + bindingOperation.getName() + "]"));
                continue;
            }
            Part part = faultParts[0];
            QName elementName = part.getElementName();
            if (elementName != null) {
                XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "'; declare namespace flt='" + this.wsdlContext.getSoapVersion().getFaultDetailNamespace() + "';" + "declare namespace ns='" + elementName.getNamespaceURI() + "';" + "//env:Fault/flt:detail/ns:" + elementName.getLocalPart());
                if (paths.length != 1) continue;
                SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                if (elm != null) {
                    this.validateMessageBody(errors, elm.getType(), paths[0]);
                } else {
                    errors.add(XmlError.forMessage((String)("Missing fault part element [" + elementName + "] for fault [" + part.getName() + "] in associated schema")));
                }
                return;
            }
            if (part.getTypeName() == null) continue;
            QName typeName = part.getTypeName();
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "'; declare namespace flt='" + this.wsdlContext.getSoapVersion().getFaultDetailNamespace() + "';" + "declare namespace ns='" + typeName.getNamespaceURI() + "';" + "//env:Fault/flt:detail/ns:" + part.getName());
            if (paths.length != 1) continue;
            SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
            if (type != null) {
                this.validateMessageBody(errors, type, paths[0]);
            } else {
                errors.add(XmlError.forMessage((String)("Missing fault part type [" + typeName + "] for fault [" + part.getName() + "] in associated schema")));
            }
            return;
        }
        XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "'; declare namespace flt='" + this.wsdlContext.getSoapVersion().getFaultDetailNamespace() + "';//env:Fault/flt:detail");
        if (paths.length == 0) {
            log.warn((Object)("Missing matching Fault in wsdl for bindingOperation [" + bindingOperation.getName() + "]"));
        } else {
            String xmlText = paths[0].xmlText(new XmlOptions().setSaveOuter());
            log.warn((Object)("Missing matching Fault in wsdl for Fault Detail element [" + XmlUtils.removeUnneccessaryNamespaces(xmlText) + "] in bindingOperation [" + bindingOperation.getName() + "]"));
        }
    }
}

