/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.DefinitionCacheTypeConfig;
import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedWsdlLoader
extends WsdlLoader {
    private final DefinitionCacheConfig config;
    private String rootInConfig = "";

    public CachedWsdlLoader(DefinitionCacheConfig config) {
        super(config.getRootPart());
        this.config = config;
    }

    public CachedWsdlLoader(AbstractInterface<?> iface) throws Exception {
        this(WsdlUtils.cacheWsdl(new UrlWsdlLoader(PathUtils.expandPath(iface.getDefinition(), iface), iface)));
    }

    @Override
    public InputStream load(String url) throws Exception {
        XmlObject xmlObject = this.loadXmlObject(url, null);
        return xmlObject == null ? null : xmlObject.newInputStream();
    }

    @Override
    public XmlObject loadXmlObject(String url, XmlOptions options) throws Exception {
        block5: {
            List partList;
            block4: {
                if (url.endsWith(this.config.getRootPart())) {
                    this.rootInConfig = url.substring(0, url.length() - this.config.getRootPart().length());
                }
                partList = this.config.getPartList();
                for (DefintionPartConfig part : partList) {
                    if (!(this.rootInConfig + part.getUrl()).equalsIgnoreCase(url)) continue;
                    return CachedWsdlLoader.getPartContent(this.config, part);
                }
                if (File.separatorChar != '/') break block4;
                url = url.replace('/', '\\');
                for (DefintionPartConfig part : partList) {
                    if (!(this.rootInConfig + part.getUrl()).equalsIgnoreCase(url)) continue;
                    return CachedWsdlLoader.getPartContent(this.config, part);
                }
                break block5;
            }
            if (File.separatorChar != '\\') break block5;
            url = url.replace('\\', '/');
            for (DefintionPartConfig part : partList) {
                if (!(this.rootInConfig + part.getUrl()).equalsIgnoreCase(url)) continue;
                return CachedWsdlLoader.getPartContent(this.config, part);
            }
        }
        return null;
    }

    public static XmlObject getPartContent(DefinitionCacheConfig config, DefintionPartConfig part) throws XmlException {
        if (config.getType() == DefinitionCacheTypeConfig.TEXT) {
            Node domNode = part.getContent().getDomNode();
            String nodeValue = XmlUtils.getNodeValue(domNode);
            return XmlObject.Factory.parse((String)nodeValue, (XmlOptions)new XmlOptions().setLoadLineNumbers());
        }
        return XmlObject.Factory.parse((String)part.getContent().toString(), (XmlOptions)new XmlOptions().setLoadLineNumbers());
    }

    public String saveDefinition(String folderName) throws Exception {
        File outFolder = new File(folderName);
        if (!outFolder.exists() && !outFolder.mkdirs()) {
            throw new Exception("Failed to create directory [" + folderName + "]");
        }
        HashMap<String, String> urlToFileMap = new HashMap<String, String>();
        this.setFilenameForUrl(this.config.getRootPart(), "http://schemas.xmlsoap.org/wsdl/", urlToFileMap, null);
        List partList = this.config.getPartList();
        for (DefintionPartConfig part : partList) {
            this.setFilenameForUrl(part.getUrl(), part.getType(), urlToFileMap, null);
        }
        for (DefintionPartConfig part : partList) {
            XmlObject obj = null;
            obj = this.config.getType() == DefinitionCacheTypeConfig.TEXT ? XmlObject.Factory.parse((String)XmlUtils.getNodeValue(part.getContent().getDomNode())) : XmlObject.Factory.parse((String)part.getContent().toString());
            this.replaceImportsAndIncludes(obj, urlToFileMap, part.getUrl());
            obj.save(new File(outFolder, (String)urlToFileMap.get(part.getUrl())));
        }
        return folderName + File.separatorChar + (String)urlToFileMap.get(this.config.getRootPart());
    }

    public StringToStringMap createFilesForExport(String urlPrefix) throws Exception {
        StringToStringMap result = new StringToStringMap();
        HashMap<String, String> urlToFileMap = new HashMap<String, String>();
        if (urlPrefix == null) {
            urlPrefix = "";
        }
        this.setFilenameForUrl(this.config.getRootPart(), "http://schemas.xmlsoap.org/wsdl/", urlToFileMap, urlPrefix);
        List partList = this.config.getPartList();
        for (DefintionPartConfig part : partList) {
            if (part.getUrl().equals(this.config.getRootPart())) continue;
            this.setFilenameForUrl(part.getUrl(), part.getType(), urlToFileMap, urlPrefix);
        }
        for (DefintionPartConfig part : partList) {
            XmlObject obj = CachedWsdlLoader.getPartContent(this.config, part);
            this.replaceImportsAndIncludes(obj, urlToFileMap, part.getUrl());
            String urlString = (String)urlToFileMap.get(part.getUrl());
            if (urlString.startsWith(urlPrefix)) {
                urlString = urlString.substring(urlPrefix.length());
            }
            result.put(urlString, obj.xmlText());
            if (!part.getUrl().equals(this.config.getRootPart())) continue;
            result.put("#root#", obj.xmlText());
        }
        return result;
    }

    private void setFilenameForUrl(String fileUrl, String type, Map<String, String> urlToFileMap, String urlPrefix) throws MalformedURLException {
        String path = fileUrl;
        try {
            URL url = new URL(fileUrl);
            path = url.getPath();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        int ix = path.lastIndexOf(47);
        String fileName = ix == -1 ? path : path.substring(ix + 1);
        ix = fileName.lastIndexOf(46);
        if (ix != -1) {
            fileName = fileName.substring(0, ix);
        }
        fileName = type.equals("http://schemas.xmlsoap.org/wsdl/") ? fileName + ".wsdl" : (type.equals("http://www.w3.org/2001/XMLSchema") ? fileName + ".xsd" : fileName + ".xml");
        if (urlPrefix != null) {
            fileName = urlPrefix + fileName;
        }
        int cnt = 1;
        while (urlToFileMap.containsValue(fileName)) {
            ix = fileName.lastIndexOf(46);
            fileName = fileName.substring(0, ix) + "_" + cnt + fileName.substring(ix);
            ++cnt;
        }
        urlToFileMap.put(fileUrl, fileName);
    }

    private void replaceImportsAndIncludes(XmlObject xmlObject, Map<String, String> urlToFileMap, String baseUrl) throws Exception {
        SimpleValue wadlImport;
        int i;
        XmlObject[] wsdlImports = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
        for (int i2 = 0; i2 < wsdlImports.length; ++i2) {
            SimpleValue wsdlImport = (SimpleValue)wsdlImports[i2];
            this.replaceLocation(urlToFileMap, baseUrl, wsdlImport);
        }
        XmlObject[] schemaImports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
        for (int i3 = 0; i3 < schemaImports.length; ++i3) {
            SimpleValue schemaImport = (SimpleValue)schemaImports[i3];
            this.replaceLocation(urlToFileMap, baseUrl, schemaImport);
        }
        XmlObject[] schemaIncludes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
        for (int i4 = 0; i4 < schemaIncludes.length; ++i4) {
            SimpleValue schemaInclude = (SimpleValue)schemaIncludes[i4];
            this.replaceLocation(urlToFileMap, baseUrl, schemaInclude);
        }
        XmlObject[] wadlImports = xmlObject.selectPath("declare namespace s='http://research.sun.com/wadl/2006/10' .//s:grammars/s:include/@href");
        for (i = 0; i < wadlImports.length; ++i) {
            wadlImport = (SimpleValue)wadlImports[i];
            this.replaceLocation(urlToFileMap, baseUrl, wadlImport);
        }
        wadlImports = xmlObject.selectPath("declare namespace s='http://wadl.dev.java.net/2009/02' .//s:grammars/s:include/@href");
        for (i = 0; i < wadlImports.length; ++i) {
            wadlImport = (SimpleValue)wadlImports[i];
            this.replaceLocation(urlToFileMap, baseUrl, wadlImport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceLocation(Map<String, String> urlToFileMap, String baseUrl, SimpleValue wsdlImport) throws Exception {
        String location = wsdlImport.getStringValue();
        if (location == null) return;
        if (location.startsWith("file:") || location.indexOf("://") > 0) {
            String newLocation = urlToFileMap.get(location);
            if (newLocation == null) throw new Exception("Missing local file for [" + newLocation + "]");
            wsdlImport.setStringValue(newLocation);
            return;
        } else {
            String loc = Tools.joinRelativeUrl(baseUrl, location);
            String newLocation = urlToFileMap.get(loc);
            if (newLocation == null) throw new Exception("Missing local file for [" + loc + "]");
            wsdlImport.setStringValue(newLocation);
        }
    }

    public void close() {
    }
}

