/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.support.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlHexBinary;

public final class XOPPartDataSource
implements DataSource {
    private String content;
    private final String contentType;
    private final SchemaType schemaType;
    private File source;

    public XOPPartDataSource(String content, String contentType, SchemaType schemaType) {
        this.content = content;
        this.contentType = contentType;
        this.schemaType = schemaType;
    }

    public XOPPartDataSource(File source, String contentType, SchemaType schemaType) {
        this.source = source;
        this.contentType = contentType;
        this.schemaType = schemaType;
    }

    public String getContentType() {
        return StringUtils.isNullOrEmpty(this.contentType) ? "application/octet-stream" : this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        try {
            if (this.source != null) {
                return new FileInputStream(this.source);
            }
            if (SchemaUtils.isInstanceOf(this.schemaType, XmlHexBinary.type)) {
                return new ByteArrayInputStream(Hex.decodeHex((char[])this.content.toCharArray()));
            }
            if (SchemaUtils.isInstanceOf(this.schemaType, XmlBase64Binary.type)) {
                return new ByteArrayInputStream(Base64.decodeBase64((byte[])this.content.getBytes()));
            }
            if (SchemaUtils.isAnyType(this.schemaType)) {
                return new ByteArrayInputStream(this.content.getBytes());
            }
            throw new IOException("Invalid type for XOPPartDataSource; " + this.schemaType.getName());
        }
        catch (Exception e) {
            SoapUI.logError(e);
            throw new IOException(e.toString());
        }
    }

    public String getName() {
        return String.valueOf(this.schemaType.getName());
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

