/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestRequestMimeMessageRequestEntity
implements RequestEntity {
    private final MimeMessage message;
    private byte[] buffer;
    private final HttpRequestInterface<?> restRequest;

    public RestRequestMimeMessageRequestEntity(MimeMessage message, HttpRequestInterface<?> restRequest) {
        this.message = message;
        this.restRequest = restRequest;
    }

    public long getContentLength() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeRequest(out);
            this.buffer = out.toByteArray();
            return this.buffer.length;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1L;
        }
    }

    public String getContentType() {
        try {
            String header = this.message.getHeader("Content-Type")[0];
            int ix = header.indexOf("boundary");
            return this.restRequest.getMediaType() + "; " + header.substring(ix);
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return this.restRequest.getMediaType();
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream arg0) throws IOException {
        try {
            if (this.buffer == null) {
                arg0.write("\r\n".getBytes());
                ((MimeMultipart)this.message.getContent()).writeTo(arg0);
            } else {
                arg0.write(this.buffer);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }
}

