/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.support.MediaTypeHandler;
import com.eviware.soapui.impl.rest.support.MediaTypeHandlerRegistry;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import org.apache.commons.httpclient.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHttpResponse
implements HttpResponse {
    private StringToStringMap requestHeaders;
    private StringToStringMap responseHeaders;
    private long timeTaken;
    private long timestamp;
    private String contentType;
    private int statusCode;
    private SSLInfo sslInfo;
    private URL url;
    private WeakReference<AbstractHttpRequestInterface<?>> httpRequest;
    private RestRequestInterface.RequestMethod method;
    private String version;
    private StringToStringMap properties;
    private byte[] rawRequestData;
    private byte[] rawResponseData;
    private int requestContentPos = -1;
    private String xmlContent;

    public BaseHttpResponse(ExtendedHttpMethod httpMethod, AbstractHttpRequestInterface<?> httpRequest) {
        TestCase tc;
        this.httpRequest = new WeakReference(httpRequest);
        this.timeTaken = httpMethod.getTimeTaken();
        this.method = httpMethod.getMethod();
        this.version = httpMethod.getParams().getVersion().toString();
        try {
            this.url = new URL(httpMethod.getURI().toString());
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        if (!httpMethod.isFailed()) {
            Settings settings = httpRequest.getSettings();
            if (settings.getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN)) {
                try {
                    httpMethod.getResponseBody();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.timeTaken += httpMethod.getResponseReadTime();
            }
            try {
                this.timestamp = System.currentTimeMillis();
                this.contentType = httpMethod.getResponseContentType();
                if (httpMethod.hasResponse()) {
                    this.statusCode = httpMethod.getStatusCode();
                    this.sslInfo = httpMethod.getSSLInfo();
                }
                this.url = new URL(httpMethod.getURI().toString());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (httpRequest instanceof TestRequest && (tc = ((TestRequest)((Object)httpRequest)).getTestStep().getTestCase()) instanceof WsdlTestCase && ((WsdlTestCase)tc).isForLoadTest()) {
            this.initHeadersForLoadTest(httpMethod);
            return;
        }
        this.initHeaders(httpMethod);
    }

    protected void initHeaders(ExtendedHttpMethod httpMethod) {
        try {
            Header[] headers;
            ByteArrayOutputStream rawResponse = new ByteArrayOutputStream();
            ByteArrayOutputStream rawRequest = new ByteArrayOutputStream();
            if (!httpMethod.isFailed()) {
                rawResponse.write(String.valueOf(httpMethod.getStatusLine()).getBytes());
                rawResponse.write("\r\n".getBytes());
            }
            rawRequest.write(((Object)((Object)this.method) + " " + String.valueOf(this.url) + " " + this.version + "\r\n").getBytes());
            this.requestHeaders = new StringToStringMap();
            for (Header header : headers = httpMethod.getRequestHeaders()) {
                this.requestHeaders.put(header.getName(), header.getValue());
                rawRequest.write(header.toExternalForm().getBytes());
            }
            if (!httpMethod.isFailed()) {
                this.responseHeaders = new StringToStringMap();
                for (Header header : headers = httpMethod.getResponseHeaders()) {
                    this.responseHeaders.put(header.getName(), header.getValue());
                    rawResponse.write(header.toExternalForm().getBytes());
                }
                this.responseHeaders.put("#status#", String.valueOf(httpMethod.getStatusLine()));
            }
            if (httpMethod.getRequestEntity() != null) {
                rawRequest.write("\r\n".getBytes());
                if (httpMethod.getRequestEntity().isRepeatable()) {
                    this.requestContentPos = rawRequest.size();
                    httpMethod.getRequestEntity().writeRequest((OutputStream)rawRequest);
                } else {
                    rawResponse.write("<request data not available>".getBytes());
                }
            }
            if (!httpMethod.isFailed()) {
                rawResponse.write("\r\n".getBytes());
                rawResponse.write(httpMethod.getResponseBody());
            }
            this.rawResponseData = rawResponse.toByteArray();
            this.rawRequestData = rawRequest.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void initHeadersForLoadTest(ExtendedHttpMethod httpMethod) {
        try {
            Header[] headers;
            this.requestHeaders = new StringToStringMap();
            for (Header header : headers = httpMethod.getRequestHeaders()) {
                this.requestHeaders.put(header.getName(), header.getValue());
            }
            if (!httpMethod.isFailed()) {
                this.responseHeaders = new StringToStringMap();
                for (Header header : headers = httpMethod.getResponseHeaders()) {
                    this.responseHeaders.put(header.getName(), header.getValue());
                }
                this.responseHeaders.put("#status#", String.valueOf(httpMethod.getStatusLine()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public StringToStringMap getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public StringToStringMap getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public AbstractHttpRequestInterface<?> getRequest() {
        return (AbstractHttpRequestInterface)this.httpRequest.get();
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Attachment[] getAttachments() {
        return new Attachment[0];
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        return new Attachment[0];
    }

    @Override
    public byte[] getRawRequestData() {
        return this.rawRequestData;
    }

    @Override
    public byte[] getRawResponseData() {
        return this.rawResponseData;
    }

    @Override
    public RestRequestInterface.RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public String getHttpVersion() {
        return this.version;
    }

    @Override
    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.properties == null ? null : (String)this.properties.get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties == null ? new String[]{} : this.properties.getKeys();
    }

    @Override
    public String getRequestContent() {
        return this.requestContentPos == -1 || this.rawRequestData == null ? null : new String(this.rawRequestData, this.requestContentPos, this.rawRequestData.length - this.requestContentPos);
    }

    @Override
    public String getContentAsXml() {
        if (this.xmlContent == null) {
            MediaTypeHandler typeHandler = MediaTypeHandlerRegistry.getTypeHandler(this.getContentType());
            this.xmlContent = typeHandler == null ? "<xml/>" : typeHandler.createXmlRepresentation(this);
        }
        return this.xmlContent;
    }
}

