/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.log4j.Logger;

public final class WsdlRequestCredentialsProvider
implements CredentialsProvider {
    private boolean checkedCredentials;
    private final WsdlRequest wsdlRequest;
    private static final Logger logger = Logger.getLogger(WsdlRequestCredentialsProvider.class);

    public WsdlRequestCredentialsProvider(WsdlRequest wsdlRequest) {
        this.wsdlRequest = wsdlRequest;
    }

    public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        block10: {
            String password;
            block9: {
                if (this.checkedCredentials) {
                    throw new CredentialsNotAvailableException("Missing valid credentials");
                }
                if (authscheme == null) {
                    return null;
                }
                password = this.wsdlRequest.getPassword();
                if (password == null) {
                    password = "";
                }
                if (!(authscheme instanceof NTLMScheme)) break block9;
                logger.info((Object)(host + ":" + port + " requires Windows authentication"));
                NTCredentials nTCredentials = new NTCredentials(this.wsdlRequest.getUsername(), password, host, this.wsdlRequest.getDomain());
                Object var8_9 = null;
                this.checkedCredentials = true;
                return nTCredentials;
            }
            if (!(authscheme instanceof RFC2617Scheme)) break block10;
            logger.info((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'"));
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.wsdlRequest.getUsername(), password);
            Object var8_10 = null;
            this.checkedCredentials = true;
            return usernamePasswordCredentials;
        }
        try {
            try {
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.checkedCredentials = true;
            throw throwable;
        }
    }
}

