/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsdlRequestCredentialsProvider;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAuthenticationRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        String username = PropertyExpander.expandProperties(context, wsdlRequest.getUsername());
        if (username == null || username.length() == 0) {
            return;
        }
        XmlBeansSettingsImpl settings = wsdlRequest.getSettings();
        String password = PropertyExpander.expandProperties(context, wsdlRequest.getPassword());
        String domain = PropertyExpander.expandProperties(context, wsdlRequest.getDomain());
        String wssPasswordType = null;
        if (wsdlRequest instanceof WsdlRequest) {
            wssPasswordType = PropertyExpander.expandProperties(context, ((WsdlRequest)wsdlRequest).getWssPasswordType());
        }
        if (StringUtils.isNullOrEmpty(wssPasswordType)) {
            HttpAuthenticationRequestFilter.initRequestCredentials(context, username, settings, password, domain);
        }
    }

    public static void initRequestCredentials(SubmitContext context, String username, Settings settings, String password, String domain) {
        HttpClient httpClient = (HttpClient)context.getProperty("httpClient");
        HttpMethod httpMethod = (HttpMethod)context.getProperty("httpMethod");
        if (StringUtils.isNullOrEmpty(username) && StringUtils.isNullOrEmpty(password)) {
            httpClient.getParams().setAuthenticationPreemptive(false);
            httpMethod.setDoAuthentication(false);
        } else {
            if (settings.getBoolean(HttpSettings.AUTHENTICATE_PREEMPTIVELY)) {
                httpClient.getParams().setAuthenticationPreemptive(true);
                HttpState state = (HttpState)context.getProperty("#HTTP_STATE");
                if (state != null) {
                    UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password == null ? "" : password);
                    state.setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
                }
            } else {
                httpClient.getParams().setAuthenticationPreemptive(false);
            }
            httpMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new UPDCredentialsProvider(username, password, domain));
            httpMethod.setDoAuthentication(true);
        }
    }

    public static class UPDCredentialsProvider
    implements CredentialsProvider {
        private boolean checkedCredentials;
        private static final Logger logger = Logger.getLogger(WsdlRequestCredentialsProvider.class);
        private final String username;
        private final String password;
        private final String domain;

        public UPDCredentialsProvider(String username, String password, String domain) {
            this.username = username;
            this.password = password == null ? "" : password;
            this.domain = domain;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            block9: {
                block8: {
                    if (this.checkedCredentials) {
                        throw new CredentialsNotAvailableException("Missing valid credentials");
                    }
                    if (authscheme == null) {
                        return null;
                    }
                    if (!(authscheme instanceof NTLMScheme)) break block8;
                    logger.info((Object)(host + ":" + port + " requires Windows authentication"));
                    NTCredentials nTCredentials = new NTCredentials(this.username, this.password, host, this.domain);
                    Object var7_8 = null;
                    this.checkedCredentials = true;
                    return nTCredentials;
                }
                if (!(authscheme instanceof RFC2617Scheme)) break block9;
                logger.info((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'"));
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.username, this.password);
                Object var7_9 = null;
                this.checkedCredentials = true;
                return usernamePasswordCredentials;
            }
            try {
                try {
                    throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
                }
                catch (IOException e) {
                    throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.checkedCredentials = true;
                throw throwable;
            }
        }
    }
}

