/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.RequestTransport;
import com.eviware.soapui.impl.wsdl.submit.filters.EndpointRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.EndpointStrategyRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpCompressionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpPackagingResponseFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpProxyRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpSettingsRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PostPackagingRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.RemoveEmptyContentRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.RestRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.SoapHeadersRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.StripWhitespacesRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsaRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsdlPackagingRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsrmRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WssAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WssRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpClientRequestTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestTransport;
import com.eviware.soapui.model.iface.SubmitContext;
import java.util.HashMap;
import java.util.Map;

public class RequestTransportRegistry {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String JMS = "jms";
    private static Map<String, RequestTransport> transports = new HashMap<String, RequestTransport>();

    public static RequestTransport getTransport(String endpoint, SubmitContext submitContext) throws MissingTransportException, CannotResolveJmsTypeException {
        int ix = endpoint.indexOf("://");
        if (ix == -1) {
            throw new MissingTransportException("Missing protocol in endpoint [" + endpoint + "]");
        }
        String protocol = endpoint.substring(0, ix).toLowerCase();
        RequestTransport transport = transports.get(protocol);
        if (transport == null) {
            throw new MissingTransportException("Missing transport for protocol [" + protocol + "]");
        }
        return transport;
    }

    public static void addTransport(String key, RequestTransport rt) {
        transports.put(key, rt);
    }

    static {
        HttpClientRequestTransport httpTransport = new HttpClientRequestTransport();
        HermesJmsRequestTransport jmsTransport = new HermesJmsRequestTransport();
        httpTransport.addRequestFilter(new EndpointRequestFilter());
        httpTransport.addRequestFilter(new HttpSettingsRequestFilter());
        httpTransport.addRequestFilter(new HttpRequestFilter());
        httpTransport.addRequestFilter(new RestRequestFilter());
        httpTransport.addRequestFilter(new SoapHeadersRequestFilter());
        httpTransport.addRequestFilter(new HttpProxyRequestFilter());
        httpTransport.addRequestFilter(new HttpAuthenticationRequestFilter());
        httpTransport.addRequestFilter(new WssAuthenticationRequestFilter());
        httpTransport.addRequestFilter(new PropertyExpansionRequestFilter());
        httpTransport.addRequestFilter(new RemoveEmptyContentRequestFilter());
        httpTransport.addRequestFilter(new StripWhitespacesRequestFilter());
        httpTransport.addRequestFilter(new EndpointStrategyRequestFilter());
        httpTransport.addRequestFilter(new WsaRequestFilter());
        httpTransport.addRequestFilter(new WsrmRequestFilter());
        httpTransport.addRequestFilter(new WssRequestFilter());
        for (RequestFilter filter : SoapUI.getListenerRegistry().getListeners(RequestFilter.class)) {
            httpTransport.addRequestFilter(filter);
        }
        httpTransport.addRequestFilter(new WsdlPackagingRequestFilter());
        httpTransport.addRequestFilter(new HttpCompressionRequestFilter());
        httpTransport.addRequestFilter(new HttpPackagingResponseFilter());
        httpTransport.addRequestFilter(new PostPackagingRequestFilter());
        transports.put(HTTP, httpTransport);
        transports.put(HTTPS, httpTransport);
        jmsTransport.addRequestFilter(new WssAuthenticationRequestFilter());
        jmsTransport.addRequestFilter(new PropertyExpansionRequestFilter());
        jmsTransport.addRequestFilter(new RemoveEmptyContentRequestFilter());
        jmsTransport.addRequestFilter(new StripWhitespacesRequestFilter());
        jmsTransport.addRequestFilter(new WsaRequestFilter());
        jmsTransport.addRequestFilter(new WssRequestFilter());
        for (RequestFilter filter : SoapUI.getListenerRegistry().getListeners(RequestFilter.class)) {
            jmsTransport.addRequestFilter(filter);
        }
        transports.put(JMS, jmsTransport);
    }

    public static class CannotResolveJmsTypeException
    extends Exception {
        public CannotResolveJmsTypeException(String msg) {
            super(msg);
        }
    }

    public static class MissingTransportException
    extends Exception {
        public MissingTransportException(String msg) {
            super(msg);
        }
    }
}

