/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceDialog;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.swing.RSyntaxAreaPopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class GroovyEditor
extends JPanel
implements JEditorStatusBar.JEditorStatusBarTarget,
PropertyChangeListener {
    private RSyntaxTextArea editArea;
    private GroovyEditorModel model;
    private InternalSettingsListener settingsListener;
    private GroovyDocumentListener groovyDocumentListener;
    private RTextScrollPane scrollPane;
    private JCheckBoxMenuItem toggleLineNumbersMenuItem;
    private boolean updating;

    public GroovyEditor(GroovyEditorModel model) {
        super(new BorderLayout());
        this.model = model;
        model.addPropertyChangeListener(this);
        Settings settings = model.getSettings();
        Font editorFont = UISupport.getEditorFont(settings);
        this.editArea = new RSyntaxTextArea();
        this.editArea.restoreDefaultSyntaxScheme();
        String defaultScriptLanguage = ((WsdlProject)ModelSupport.getModelItemProject(model.getModelItem())).getDefaultScriptLanguage();
        if (defaultScriptLanguage.equals("Groovy")) {
            this.editArea.setSyntaxEditingStyle("text/groovy");
        } else if (defaultScriptLanguage.equals("Javascript")) {
            this.editArea.setSyntaxEditingStyle("text/javascript");
        }
        this.editArea.setBorder((Border)BorderFactory.createMatteBorder(0, 2, 0, 0, Color.WHITE));
        this.editArea.setText(model.getScript());
        this.editArea.setCaretPosition(0);
        this.editArea.setHighlightCurrentLine(false);
        Action runAction = model.getRunAction();
        if (runAction != null) {
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("alt ENTER"), "run-action");
            this.editArea.getActionMap().put("run-action", runAction);
        }
        this.editArea.getInputMap().put(KeyStroke.getKeyStroke("F3"), "find-action");
        this.editArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl F"), "find-action");
        RSyntaxTextAreaFindAndReplaceable findAndReplaceable = new RSyntaxTextAreaFindAndReplaceable();
        this.editArea.getActionMap().put("find-action", new FindAndReplaceDialog(findAndReplaceable));
        this.groovyDocumentListener = new GroovyDocumentListener();
        this.editArea.getDocument().addDocumentListener(this.groovyDocumentListener);
        this.settingsListener = new InternalSettingsListener();
        settings.addSettingsListener(this.settingsListener);
        this.scrollPane = new RTextScrollPane((RTextArea)this.editArea, true);
        this.scrollPane.setPreferredSize(new Dimension(500, 300));
        this.add((Component)this.scrollPane);
        UISupport.addPreviewCorner((JScrollPane)this.scrollPane, true);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                GroovyEditor.this.editArea.requestFocusInWindow();
            }
        });
        RSyntaxAreaPopupMenu popup = RSyntaxAreaPopupMenu.add(this.editArea);
        popup.add(new FindAndReplaceDialog(findAndReplaceable));
        popup.addSeparator();
        popup.add(new GoToLineAction());
        this.toggleLineNumbersMenuItem = new JCheckBoxMenuItem("Show Line Numbers", this.scrollPane.getLineNumbersEnabled());
        this.toggleLineNumbersMenuItem.setAccelerator(UISupport.getKeyStroke("alt L"));
        this.toggleLineNumbersMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GroovyEditor.this.enableLineNumbers(GroovyEditor.this.toggleLineNumbersMenuItem.isSelected());
            }
        });
        this.editArea.getInputMap().put(KeyStroke.getKeyStroke("alt L"), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GroovyEditor.this.enableLineNumbers(!GroovyEditor.this.scrollPane.getLineNumbersEnabled());
            }
        });
        popup.add(this.toggleLineNumbersMenuItem);
        this.editArea.setPopupMenu((JPopupMenu)popup);
        this.enableLineNumbers(settings.getBoolean(UISettings.SHOW_GROOVY_LINE_NUMBERS));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editArea.setEnabled(enabled);
    }

    public void enableLineNumbers(boolean enable) {
        this.scrollPane.setLineNumbersEnabled(enable);
        this.toggleLineNumbersMenuItem.setSelected(enable);
    }

    public RSyntaxTextArea getEditArea() {
        return this.editArea;
    }

    public void release() {
        if (this.model != null) {
            this.model.getSettings().removeSettingsListener(this.settingsListener);
            this.model.removePropertyChangeListener(this);
        }
        this.model = null;
        this.editArea.getDocument().removeDocumentListener(this.groovyDocumentListener);
    }

    public void selectError(String message) {
        int ix;
        int n = ix = message == null ? -1 : message.indexOf("@ line ");
        if (ix >= 0) {
            try {
                int ix2 = message.indexOf(44, ix);
                int line = ix2 == -1 ? Integer.parseInt(message.substring(ix + 6).trim()) : Integer.parseInt(message.substring(ix + 6, ix2).trim());
                int column = 0;
                if (ix2 != -1 && (ix = message.indexOf("column ", ix2)) >= 0) {
                    ix2 = message.indexOf(46, ix);
                    column = ix2 == -1 ? Integer.parseInt(message.substring(ix + 7).trim()) : Integer.parseInt(message.substring(ix + 7, ix2).trim());
                }
                this.editArea.setCaretPosition(this.editArea.getLineStartOffset(line - 1) + column - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.editArea.requestFocus();
        }
    }

    public void setEditorFont(Font newFont) {
        this.editArea.setFont(newFont);
    }

    public void addCaretListener(CaretListener listener) {
        this.editArea.addCaretListener(listener);
    }

    public int getCaretPosition() {
        return this.editArea.getCaretPosition();
    }

    public int getLineOfOffset(int offset) throws Exception {
        return this.editArea.getLineOfOffset(offset);
    }

    public int getLineStartOffset(int line) throws Exception {
        return this.editArea.getLineStartOffset(line);
    }

    public void removeCaretListener(CaretListener listener) {
        this.editArea.removeCaretListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("script")) {
            this.updating = true;
            this.editArea.setText(String.valueOf(evt.getNewValue()));
            this.updating = false;
        }
    }

    private class RSyntaxTextAreaFindAndReplaceable
    implements FindAndReplaceable {
        private RSyntaxTextAreaFindAndReplaceable() {
        }

        public boolean isEditable() {
            return GroovyEditor.this.editArea.isEditable();
        }

        public int getCaretPosition() {
            return GroovyEditor.this.editArea.getCaretPosition();
        }

        public String getText() {
            return GroovyEditor.this.editArea.getText();
        }

        public void select(int start, int end2) {
            GroovyEditor.this.editArea.select(start, end2);
        }

        public int getSelectionStart() {
            return GroovyEditor.this.editArea.getSelectionStart();
        }

        public int getSelectionEnd() {
            return GroovyEditor.this.editArea.getSelectionEnd();
        }

        public void setSelectedText(String txt) {
            GroovyEditor.this.editArea.replaceSelection(txt);
        }

        public String getSelectedText() {
            return GroovyEditor.this.editArea.getSelectedText();
        }
    }

    private final class GoToLineAction
    extends AbstractAction {
        public GoToLineAction() {
            super("Go To Line");
            this.putValue("ShortDescription", "Moves the caret to the specified line");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt L"));
        }

        public void actionPerformed(ActionEvent e) {
            String line = UISupport.prompt("Enter line-number to (1.." + GroovyEditor.this.editArea.getLineCount() + ")", "Go To Line", String.valueOf(GroovyEditor.this.editArea.getCaretLineNumber() + 1));
            if (line != null) {
                try {
                    int ln = Integer.parseInt(line) - 1;
                    if (ln >= 0 && ln < GroovyEditor.this.editArea.getLineCount()) {
                        GroovyEditor.this.editArea.scrollRectToVisible(GroovyEditor.this.editArea.modelToView(GroovyEditor.this.editArea.getLineStartOffset(ln)));
                        GroovyEditor.this.editArea.setCaretPosition(GroovyEditor.this.getLineStartOffset(ln));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private InternalSettingsListener() {
        }

        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(UISettings.EDITOR_FONT)) {
                Font newFont = Font.decode(newValue);
                GroovyEditor.this.setEditorFont(newFont);
                GroovyEditor.this.invalidate();
            }
        }
    }

    private final class GroovyDocumentListener
    extends DocumentListenerAdapter {
        private GroovyDocumentListener() {
        }

        public void update(Document document) {
            if (!GroovyEditor.this.updating) {
                GroovyEditor.this.model.setScript(GroovyEditor.this.editArea.getText());
            }
        }
    }
}

