/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcRequest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.NamedParameterStatement;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.concurrent.Future;

public class JdbcSubmit
implements Submit,
Runnable {
    public static final String JDBC_ERROR = "JDBC_ERROR";
    public static final String JDBC_TIMEOUT = "JDBC_TIMEOUT";
    private volatile Future<?> future;
    private SubmitContext context;
    private Submit.Status status;
    private SubmitListener[] listeners;
    private Exception error;
    private long timestamp;
    protected ResultSet resultSet;
    protected PreparedStatement statement;
    private Connection connection;
    private long timeTaken;
    private final JdbcRequest request;
    private JdbcResponse response;

    public JdbcSubmit(JdbcRequest request, SubmitContext submitContext, boolean async) {
        int c;
        this.request = request;
        this.context = submitContext;
        List<SubmitListener> regListeners = SoapUI.getListenerRegistry().getListeners(SubmitListener.class);
        SubmitListener[] submitListeners = request.getSubmitListeners();
        this.listeners = new SubmitListener[submitListeners.length + regListeners.size()];
        for (c = 0; c < submitListeners.length; ++c) {
            this.listeners[c] = submitListeners[c];
        }
        for (c = 0; c < regListeners.size(); ++c) {
            this.listeners[submitListeners.length + c] = regListeners.get(c);
        }
        this.error = null;
        this.status = Submit.Status.INITIALIZED;
        if (async) {
            this.future = SoapUI.getThreadPool().submit(this);
        } else {
            this.run();
        }
    }

    public void cancel() {
        if (this.status == Submit.Status.CANCELED) {
            return;
        }
        JdbcRequest.logger.info((Object)"Canceling request..");
        if (this.status == Submit.Status.RUNNING) {
            this.cancelQuery();
        }
        this.status = Submit.Status.CANCELED;
        for (int i = 0; i < this.listeners.length; ++i) {
            try {
                this.listeners[i].afterSubmit(this, this.context);
                continue;
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    public Exception getError() {
        return this.error;
    }

    public Request getRequest() {
        return this.request;
    }

    public JdbcResponse getResponse() {
        return this.response;
    }

    public Submit.Status getStatus() {
        return this.status;
    }

    public Submit.Status waitUntilFinished() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        } else {
            throw new RuntimeException("cannot wait on null future");
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block18: {
            block17: {
                try {
                    try {
                        for (i = 0; i < this.listeners.length; ++i) {
                            if (this.listeners[i].beforeSubmit(this, this.context)) continue;
                            this.status = Submit.Status.CANCELED;
                            System.err.println("listener cancelled submit..");
                            var3_3 = null;
                            if (this.status == Submit.Status.CANCELED) return;
                            break block17;
                        }
                        this.status = Submit.Status.RUNNING;
                        this.runQuery();
                        if (this.status != Submit.Status.CANCELED) {
                            this.status = Submit.Status.FINISHED;
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        UISupport.showErrorMessage(e.getMessage());
                        SoapUI.logError(e);
                        this.error = e;
                        var3_5 = null;
                        if (this.status == Submit.Status.CANCELED) return;
                        for (i = 0; i < this.listeners.length; ++i) {
                            try {
                                this.listeners[i].afterSubmit(this, this.context);
                                continue;
                            }
                            catch (Throwable e) {
                                SoapUI.logError(e);
                            }
                        }
                        return;
                    }
                }
                catch (Throwable var2_15) {
                    var3_6 = null;
                    if (this.status == Submit.Status.CANCELED) throw var2_15;
                    for (i = 0; i < this.listeners.length; ++i) {
                        ** try [egrp 2[TRYBLOCK] [6 : 142->162)] { 
lbl37:
                        // 1 sources

                        this.listeners[i].afterSubmit(this, this.context);
                        continue;
lbl39:
                        // 1 sources

                        catch (Throwable e) {
                            SoapUI.logError(e);
                        }
                    }
                    throw var2_15;
                }
            }
            for (i = 0; i < this.listeners.length; ++i) {
                ** try [egrp 2[TRYBLOCK] [6 : 142->162)] { 
lbl46:
                // 1 sources

                this.listeners[i].afterSubmit(this, this.context);
                continue;
lbl48:
                // 1 sources

                catch (Throwable e) {
                    SoapUI.logError(e);
                }
            }
            return;
        }
        var3_4 = null;
        if (this.status == Submit.Status.CANCELED) return;
        for (i = 0; i < this.listeners.length; ++i) {
            ** try [egrp 2[TRYBLOCK] [6 : 142->162)] { 
lbl57:
            // 1 sources

            this.listeners[i].afterSubmit(this, this.context);
            continue;
lbl59:
            // 1 sources

            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    protected void runQuery() throws Exception {
        this.prepare();
        this.load();
        this.createResponse();
    }

    public void cancelQuery() {
        try {
            if (this.statement != null) {
                this.statement.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            UISupport.showErrorMessage(e);
        }
        catch (SQLException ex) {
            UISupport.showErrorMessage(ex);
        }
    }

    protected void getDatabaseConnection() throws Exception, SQLException {
        JdbcRequestTestStep testStep = this.request.getTestStep();
        try {
            this.connection = JdbcUtils.initConnection(this.context, testStep.getDriver(), testStep.getConnectionString(), testStep.getPassword());
        }
        catch (SQLException e) {
            UISupport.showErrorMessage(e);
            throw e;
        }
    }

    protected void load() throws SQLException {
        try {
            block6: {
                try {
                    JdbcRequestTestStep testStep = this.request.getTestStep();
                    if (testStep.isStoredProcedure()) {
                        this.timestamp = System.currentTimeMillis();
                        this.statement.execute();
                    } else {
                        this.timestamp = System.currentTimeMillis();
                        this.statement.execute();
                    }
                    this.timeTaken = System.currentTimeMillis() - this.timestamp;
                    if (StringUtils.isNullOrEmpty(this.request.getTimeout()) || this.timeTaken <= Long.parseLong(this.request.getTimeout())) break block6;
                    this.context.setProperty(JDBC_TIMEOUT, PropertyExpander.expandProperties(this.context, this.request.getTimeout()));
                }
                catch (SQLException e) {
                    this.context.setProperty(JDBC_ERROR, e);
                    throw e;
                }
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.timeTaken = System.currentTimeMillis() - this.timestamp;
            throw throwable;
        }
        this.timeTaken = System.currentTimeMillis() - this.timestamp;
    }

    protected void prepare() throws Exception {
        String sql;
        JdbcRequestTestStep testStep = this.request.getTestStep();
        this.getDatabaseConnection();
        List<TestProperty> props = testStep.getPropertyList();
        if (testStep.isStoredProcedure()) {
            sql = PropertyExpander.expandProperties(this.context, testStep.getQuery());
            if (!sql.startsWith("{call ") && !sql.endsWith("}")) {
                sql = "{call " + sql + "}";
            }
        } else {
            sql = PropertyExpander.expandProperties(this.context, testStep.getQuery());
        }
        NamedParameterStatement p = new NamedParameterStatement(this.connection, sql);
        for (TestProperty testProperty : props) {
            String value = PropertyExpander.expandProperties(this.context, testProperty.getValue());
            if (testProperty.getName().equals(WsdlTestStepWithProperties.RESPONSE_AS_XML)) continue;
            p.setString(testProperty.getName(), value);
        }
        this.statement = p.getStatement();
        try {
            if (!StringUtils.isNullOrEmpty(testStep.getQueryTimeout())) {
                String queryTimeout = PropertyExpander.expandProperties(testStep, testStep.getQueryTimeout());
                this.statement.setQueryTimeout(Integer.parseInt(queryTimeout));
            }
        }
        catch (NumberFormatException e) {
            UISupport.showErrorMessage("Problem setting timeout: " + e.getMessage());
        }
        try {
            if (!StringUtils.isNullOrEmpty(testStep.getMaxRows())) {
                String maxRows = PropertyExpander.expandProperties(testStep, testStep.getMaxRows());
                this.statement.setMaxRows(Integer.parseInt(maxRows));
            }
        }
        catch (NumberFormatException e) {
            UISupport.showErrorMessage("Problem setting maxRows: " + e.getMessage());
        }
        try {
            if (!StringUtils.isNullOrEmpty(testStep.getFetchSize())) {
                String fetchSize = PropertyExpander.expandProperties(testStep, testStep.getFetchSize());
                this.statement.setFetchSize(Integer.parseInt(fetchSize));
            }
        }
        catch (NumberFormatException e) {
            UISupport.showErrorMessage("Problem setting fetchSize: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String createResponse() {
        block17: {
            this.response = new JdbcResponse(this.request, this.statement);
            this.response.setTimestamp(this.timestamp);
            this.response.setTimeTaken(this.timeTaken);
            Object var3_1 = null;
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                break block17;
            }
            catch (Exception e2) {}
            break block17;
            {
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var3_2 = null;
                    try {
                        if (this.connection != null) {
                            this.connection.close();
                        }
                        if (this.statement != null) {
                            this.statement.close();
                        }
                        if (this.resultSet != null) {
                            this.resultSet.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }
}

