/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.actions.teststep.RunFromTestStepAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.swing.AutoscrollSupport;
import com.eviware.soapui.support.swing.ModelItemListKeyListener;
import com.eviware.soapui.support.swing.ModelItemListMouseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JTestStepList
extends JPanel {
    private TestStepListModel testStepListModel;
    private JList testStepList;
    private JPopupMenu testListPopup;
    private JMenu appendStepMenu;
    private final WsdlTestCase testCase;

    public JTestStepList(WsdlTestCase testCase) {
        super(new BorderLayout());
        this.setDoubleBuffered(true);
        this.testCase = testCase;
        this.buildUI();
    }

    public JList getTestStepList() {
        return this.testStepList;
    }

    private void buildUI() {
        this.testStepListModel = new TestStepListModel();
        this.testStepList = new TestStepJList(this.testStepListModel);
        this.testStepList.setCellRenderer(new TestStepCellRenderer());
        this.testStepList.setFixedCellHeight(22);
        this.testStepList.setSelectionMode(2);
        this.testStepList.addKeyListener(new TestStepListKeyHandler());
        this.testStepList.addMouseListener(new ModelItemListMouseListener(){

            public void mouseClicked(MouseEvent e) {
                ModelItem item;
                int row = JTestStepList.this.testStepList.locationToIndex(e.getPoint());
                if (row != -1 && (item = (ModelItem)JTestStepList.this.testStepList.getModel().getElementAt(row)) != null) {
                    UISupport.select(item);
                }
                super.mouseClicked(e);
            }
        });
        this.testListPopup = new JPopupMenu();
        this.testListPopup.addSeparator();
        this.appendStepMenu = new JMenu("Append Step");
        WsdlTestStepRegistry registry = WsdlTestStepRegistry.getInstance();
        WsdlTestStepFactory[] factories = registry.getFactories();
        for (int c = 0; c < factories.length; ++c) {
            if (!factories[c].canCreate()) continue;
            this.appendStepMenu.add(new InsertTestStepAction(factories[c]));
        }
        this.testListPopup.add(this.appendStepMenu);
        this.testListPopup.addPopupMenuListener(new StepListPopupMenuListener(this.testCase));
        this.testStepList.setComponentPopupMenu(this.testListPopup);
        this.add((Component)this.testStepList, "Center");
    }

    public void setEnabled(boolean enabled) {
        this.testStepList.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setSelectedIndex(int i) {
        this.testStepList.setSelectedIndex(i);
    }

    public void setSelectedValue(TestStep testStep, boolean b) {
        try {
            this.testStepList.setSelectedValue(testStep, true);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void release() {
        this.testStepListModel.release();
    }

    private static class TestStepJList
    extends JList
    implements Autoscroll {
        private AutoscrollSupport autoscrollSupport = new AutoscrollSupport(this, new Insets(10, 10, 10, 10));

        public TestStepJList(TestStepListModel testStepListModel) {
            super(testStepListModel);
        }

        public void autoscroll(Point cursorLoc) {
            this.autoscrollSupport.autoscroll(cursorLoc);
        }

        public Insets getAutoscrollInsets() {
            return this.autoscrollSupport.getAutoscrollInsets();
        }
    }

    public class InsertTestStepAction
    extends AbstractAction {
        private final WsdlTestStepFactory factory;

        public InsertTestStepAction(WsdlTestStepFactory factory) {
            super(factory.getTestStepName());
            this.putValue("ShortDescription", factory.getTestStepDescription());
            this.putValue("SmallIcon", UISupport.createImageIcon(factory.getTestStepIconPath()));
            this.factory = factory;
        }

        public void actionPerformed(ActionEvent e) {
            TestStepConfig newTestStepConfig;
            String name = UISupport.prompt("Specify name for new step", "Insert Step", this.factory.getTestStepName());
            if (name != null && (newTestStepConfig = this.factory.createNewTestStep(JTestStepList.this.testCase, name)) != null) {
                WsdlTestStep testStep = JTestStepList.this.testCase.addTestStep(newTestStepConfig);
                UISupport.selectAndShow(testStep);
            }
        }
    }

    private class TestStepListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private TestStepListTestSuiteListener testStepListTestSuiteListener = new TestStepListTestSuiteListener();

        public TestStepListModel() {
            for (int c = 0; c < this.getSize(); ++c) {
                JTestStepList.this.testCase.getTestStepAt(c).addPropertyChangeListener(this);
            }
            JTestStepList.this.testCase.getTestSuite().addTestSuiteListener(this.testStepListTestSuiteListener);
        }

        public int getSize() {
            return JTestStepList.this.testCase.getTestStepCount();
        }

        public Object getElementAt(int index) {
            return JTestStepList.this.testCase.getTestStepAt(index);
        }

        public synchronized void propertyChange(PropertyChangeEvent arg0) {
            final int ix = JTestStepList.this.testCase.getIndexOfTestStep((TestStep)arg0.getSource());
            if (ix == -1) {
                return;
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TestStepListModel.this.fireContentsChanged(this, ix, ix);
                    }
                });
            } else {
                this.fireContentsChanged(this, ix, ix);
            }
        }

        public void release() {
            JTestStepList.this.testCase.getTestSuite().removeTestSuiteListener(this.testStepListTestSuiteListener);
            for (int c = 0; c < this.getSize(); ++c) {
                JTestStepList.this.testCase.getTestStepAt(c).removePropertyChangeListener(this);
            }
        }

        private class TestStepListTestSuiteListener
        extends TestSuiteListenerAdapter {
            private TestStepListTestSuiteListener() {
            }

            public void testStepAdded(TestStep testStep, int ix) {
                if (testStep.getTestCase() == JTestStepList.this.testCase) {
                    testStep.addPropertyChangeListener(TestStepListModel.this);
                    TestStepListModel.this.fireIntervalAdded(TestStepListModel.this, ix, ix);
                }
            }

            public void testStepRemoved(TestStep testStep, int ix) {
                if (testStep.getTestCase() == JTestStepList.this.testCase) {
                    testStep.removePropertyChangeListener(TestStepListModel.this);
                    TestStepListModel.this.fireIntervalRemoved(TestStepListModel.this, ix, ix);
                }
            }

            public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
                if (testStep.getTestCase() == JTestStepList.this.testCase) {
                    TestStepListModel.this.fireContentsChanged(TestStepListModel.this, fromIndex, fromIndex + offset);
                    int selectedIndex = JTestStepList.this.testStepList.getSelectedIndex();
                    if (selectedIndex == fromIndex) {
                        JTestStepList.this.testStepList.setSelectedIndex(fromIndex + offset);
                    } else if (selectedIndex < fromIndex && selectedIndex >= fromIndex + offset) {
                        JTestStepList.this.testStepList.setSelectedIndex(selectedIndex + 1);
                    } else if (selectedIndex > fromIndex && selectedIndex <= fromIndex + offset) {
                        JTestStepList.this.testStepList.setSelectedIndex(selectedIndex - 1);
                    }
                }
            }
        }
    }

    private static final class TestStepCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public TestStepCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            WsdlTestStep testStep = (WsdlTestStep)value;
            this.setText(testStep.getLabel());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled() && !testStep.isDisabled());
            String toolTipText = list.getToolTipText();
            if (toolTipText == null) {
                this.setToolTipText(testStep.getDescription());
            } else {
                this.setToolTipText(toolTipText.length() == 0 ? null : toolTipText);
            }
            return this;
        }
    }

    private final class StepListPopupMenuListener
    implements PopupMenuListener {
        private StepListPopupMenuListener(WsdlTestCase case1) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JTestStepList.this.testListPopup.removeAll();
            if (SoapUI.getTestMonitor().hasRunningLoadTest(JTestStepList.this.testCase)) {
                JTestStepList.this.testListPopup.add("<disabled during LoadTest>").setEnabled(false);
                return;
            }
            Point location = JTestStepList.this.testStepList.getMousePosition();
            int ix = -1;
            if (location != null) {
                int index = JTestStepList.this.testStepList.locationToIndex(location);
                if (index != -1 && !JTestStepList.this.testStepList.isSelectedIndex(index) && JTestStepList.this.testStepList.getCellBounds(index, index).contains(location)) {
                    JTestStepList.this.testStepList.addSelectionInterval(index, index);
                    ix = index;
                } else if (index != -1 && JTestStepList.this.testStepList.isSelectedIndex(index) && JTestStepList.this.testStepList.getCellBounds(index, index).contains(location)) {
                    ix = index;
                }
            }
            if (ix >= 0) {
                int[] indices = JTestStepList.this.testStepList.getSelectedIndices();
                if (indices.length == 1) {
                    WsdlTestStep testStep = JTestStepList.this.testCase.getTestStepAt(ix);
                    ActionSupport.addActions(ActionListBuilder.buildActions(testStep), JTestStepList.this.testListPopup);
                    JTestStepList.this.testListPopup.insert(SwingActionDelegate.createDelegate(new RunFromTestStepAction(), testStep), 0);
                    JTestStepList.this.testListPopup.insert(new JSeparator(), 1);
                } else {
                    ModelItem[] modelItems = new ModelItem[indices.length];
                    for (int c = 0; c < indices.length; ++c) {
                        modelItems[c] = JTestStepList.this.testCase.getTestStepAt(indices[c]).getModelItem();
                    }
                    ActionSupport.addActions(ActionListBuilder.buildMultiActions(modelItems), JTestStepList.this.testListPopup);
                }
            } else {
                JTestStepList.this.testStepList.clearSelection();
                JTestStepList.this.testListPopup.add(JTestStepList.this.appendStepMenu);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private final class TestStepListKeyHandler
    extends ModelItemListKeyListener {
        private TestStepListKeyHandler() {
        }

        public ModelItem getModelItemAt(int ix) {
            return JTestStepList.this.testCase.getTestStepAt(ix);
        }
    }
}

