/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor.jettyproxy;

import com.eviware.soapui.SoapUI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.util.IO;

public class Server
extends org.mortbay.jetty.Server {
    private Logger log = Logger.getLogger(Server.class);

    public Server() {
        if (SoapUI.getLogMonitor() == null || SoapUI.getLogMonitor().getLogArea("jetty log") == null) {
            return;
        }
        SoapUI.getLogMonitor().getLogArea("jetty log").addLogger(this.log.getName(), true);
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        Request request = connection.getRequest();
        if (request.getMethod().equals("CONNECT")) {
            String uri = request.getUri().toString();
            int c = uri.indexOf(58);
            String port = uri.substring(c + 1);
            String host = uri.substring(0, c);
            InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
            Socket clientSocket = connection.getEndPoint().getTransport() instanceof Socket ? (Socket)connection.getEndPoint().getTransport() : ((SocketChannel)connection.getEndPoint().getTransport()).socket();
            InputStream in = clientSocket.getInputStream();
            OutputStream out = clientSocket.getOutputStream();
            SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(inetAddress.getAddress(), inetAddress.getPort());
            Response response = connection.getResponse();
            response.setStatus(200);
            response.flushBuffer();
            IO.copyThread((InputStream)socket.getInputStream(), (OutputStream)out);
            IO.copyThread((InputStream)in, (OutputStream)socket.getOutputStream());
        } else if (request.getMethod().equals("POST") || request.getMethod().equals("GET")) {
            super.handle(connection);
        } else {
            String uri = request.getUri().toString();
            int c = uri.indexOf(58);
            String port = uri.substring(c + 1);
            String host = uri.substring(0, c);
            InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
            Socket clientSocket = connection.getEndPoint().getTransport() instanceof Socket ? (Socket)connection.getEndPoint().getTransport() : ((SocketChannel)connection.getEndPoint().getTransport()).socket();
            InputStream in = clientSocket.getInputStream();
            OutputStream out = clientSocket.getOutputStream();
            Socket socket = SocketFactory.getDefault().createSocket(inetAddress.getAddress(), inetAddress.getPort());
            Response response = connection.getResponse();
            response.setStatus(200);
            response.flushBuffer();
            IO.copyThread((InputStream)socket.getInputStream(), (OutputStream)out);
            IO.copyThread((InputStream)in, (OutputStream)socket.getOutputStream());
        }
    }
}

