/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.monitor.MonitorMessageExchangeDataSource;
import com.eviware.soapui.impl.wsdl.monitor.WsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProxyServletWsdlMonitorMessageExchange
extends WsdlMonitorMessageExchange {
    private WsdlOperation operation;
    private WsdlProject project;
    private String requestContent;
    private StringToStringMap requestHeaders;
    private String responseContent;
    private StringToStringMap responseHeaders = new StringToStringMap();
    private MultipartMessageSupport requestMmSupport;
    private boolean discarded;
    private long timestampStart;
    private byte[] request;
    private byte[] response;
    private String requestHost;
    private URL targetURL;
    private String requestContentType;
    private Vector<Object> requestWssResult;
    private SoapVersion soapVersion;
    private String responseContentType;
    private MultipartMessageSupport responseMmSupport;
    private Vector<Object> responseWssResult;
    private long timestampEnd;
    private boolean capture;
    private byte[] requestRaw = null;
    private byte[] responseRaw = null;

    public JProxyServletWsdlMonitorMessageExchange(WsdlProject project) {
        super(null);
        this.requestHeaders = new StringToStringMap();
        this.timestampStart = System.currentTimeMillis();
        this.project = project;
        this.capture = true;
    }

    @Override
    public String getEndpoint() {
        return this.targetURL == null ? null : this.targetURL.toString();
    }

    @Override
    public void discard() {
        this.operation = null;
        this.project = null;
        this.requestContent = null;
        this.requestHeaders = null;
        this.responseContent = null;
        this.responseHeaders = null;
        this.requestMmSupport = null;
        this.response = null;
        this.request = null;
        this.capture = false;
        this.discarded = true;
    }

    @Override
    public long getRequestContentLength() {
        return this.request == null ? -1L : (long)this.request.length;
    }

    @Override
    public String getRequestHost() {
        return this.requestHost;
    }

    @Override
    public long getResponseContentLength() {
        return this.response == null ? -1L : (long)this.response.length;
    }

    @Override
    public URL getTargetUrl() {
        return this.targetURL;
    }

    @Override
    public void prepare(IncomingWss incomingRequestWss, IncomingWss incomingResponseWss) {
        this.parseRequestData(incomingRequestWss);
        this.parseReponseData(incomingResponseWss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseReponseData(IncomingWss incomingResponseWss) {
        block10: {
            ByteArrayInputStream in = new ByteArrayInputStream(this.response == null ? new byte[]{} : this.response);
            this.responseContentType = (String)this.responseHeaders.get("Content-Type");
            if (this.responseContentType != null && this.responseContentType.toUpperCase().startsWith("MULTIPART")) {
                StringToStringMap values = StringToStringMap.fromHttpHeader(this.responseContentType);
                this.responseMmSupport = new MultipartMessageSupport(new MonitorMessageExchangeDataSource("monitor response", in, this.responseContentType), (String)values.get("start"), null, true, false);
                this.responseContentType = this.responseMmSupport.getRootPart().getContentType();
            } else {
                String charset = JProxyServletWsdlMonitorMessageExchange.getCharset(this.responseHeaders);
                this.responseContent = charset == null ? Tools.readAll(in, 0L).toString() : Tools.readAll(in, 0L).toString(charset);
            }
            this.processResponseWss(incomingResponseWss);
            Object var5_6 = null;
            try {
                in.close();
            }
            catch (IOException e1) {
                SoapUI.logError(e1);
            }
            break block10;
            {
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var5_7 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e1) {
                        SoapUI.logError(e1);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    in.close();
                }
                catch (IOException e1) {
                    SoapUI.logError(e1);
                }
                throw throwable;
            }
        }
    }

    @Override
    public Operation getModelItem() {
        return this.operation;
    }

    private void processResponseWss(IncomingWss incomingResponseWss) throws IOException {
        if (incomingResponseWss != null) {
            Document dom = XmlUtils.parseXml(this.responseContent);
            try {
                this.responseWssResult = incomingResponseWss.processIncoming(dom, new DefaultPropertyExpansionContext(this.project));
                if (this.responseWssResult != null && this.responseWssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serialize(dom, (Writer)writer);
                    this.responseContent = writer.toString();
                }
            }
            catch (Exception e) {
                if (this.responseWssResult == null) {
                    this.responseWssResult = new Vector();
                }
                this.responseWssResult.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseRequestData(IncomingWss incomingRequestWss) {
        block10: {
            ByteArrayInputStream in = this.request == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(this.request);
            this.requestContentType = (String)this.requestHeaders.get("Content-Type");
            if (this.requestContentType != null && this.requestContentType.toUpperCase().startsWith("MULTIPART")) {
                StringToStringMap values = StringToStringMap.fromHttpHeader(this.requestContentType);
                this.requestMmSupport = new MultipartMessageSupport(new MonitorMessageExchangeDataSource("monitor request", in, this.requestContentType), (String)values.get("start"), null, true, false);
                this.requestContentType = this.requestMmSupport.getRootPart().getContentType();
            } else {
                String charset = JProxyServletWsdlMonitorMessageExchange.getCharset(this.requestHeaders);
                this.requestContent = charset == null ? Tools.readAll(in, 0L).toString() : Tools.readAll(in, 0L).toString(charset);
            }
            this.processRequestWss(incomingRequestWss);
            this.operation = this.findOperation();
            Object var5_6 = null;
            try {
                in.close();
            }
            catch (IOException e1) {
                SoapUI.logError(e1);
            }
            break block10;
            {
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var5_7 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e1) {
                        SoapUI.logError(e1);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    in.close();
                }
                catch (IOException e1) {
                    SoapUI.logError(e1);
                }
                throw throwable;
            }
        }
    }

    private static String getCharset(StringToStringMap headers) {
        StringToStringMap values;
        String requestContentType = (String)headers.get("Content-Type");
        if (requestContentType != null && (values = StringToStringMap.fromHttpHeader(requestContentType)).containsKey("charset")) {
            return (String)values.get("charset");
        }
        String contentEncodingHeader = (String)headers.get("Content-Encoding");
        if (contentEncodingHeader != null) {
            try {
                if (CompressionSupport.getAvailableAlgorithm(contentEncodingHeader) == null) {
                    new String("").getBytes(contentEncodingHeader);
                    return contentEncodingHeader;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private WsdlOperation findOperation() throws Exception {
        this.soapVersion = SoapUtils.deduceSoapVersion(this.requestContentType, XmlObject.Factory.parse((String)this.getRequestContent()));
        if (this.soapVersion == null) {
            throw new Exception("Unrecognized SOAP Version");
        }
        String soapAction = SoapUtils.getSoapAction(this.soapVersion, this.requestHeaders);
        ArrayList<WsdlOperation> operations = new ArrayList<WsdlOperation>();
        for (WsdlInterface iface : ModelSupport.getChildren(this.project, WsdlInterface.class)) {
            for (Operation operation : iface.getOperationList()) {
                operations.add((WsdlOperation)operation);
            }
        }
        return SoapUtils.findOperationForRequest(this.soapVersion, soapAction, XmlObject.Factory.parse((String)this.getRequestContent()), operations, true, false, this.getRequestAttachments());
    }

    private void processRequestWss(IncomingWss incomingRequestWss) throws IOException {
        if (incomingRequestWss != null) {
            Document dom = XmlUtils.parseXml(this.requestContent);
            try {
                this.requestWssResult = incomingRequestWss.processIncoming(dom, new DefaultPropertyExpansionContext(this.project));
                if (this.requestWssResult != null && this.requestWssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serialize(dom, (Writer)writer);
                    this.requestContent = writer.toString();
                }
            }
            catch (Exception e) {
                if (this.requestWssResult == null) {
                    this.requestWssResult = new Vector();
                }
                this.requestWssResult.add(e);
            }
        }
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public Vector<?> getRequestWssResult() {
        return this.requestWssResult;
    }

    @Override
    public Vector<?> getResponseWssResult() {
        return this.responseWssResult;
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return this.requestMmSupport == null ? new Attachment[]{} : this.requestMmSupport.getAttachments();
    }

    @Override
    public String getRequestContent() {
        return this.requestMmSupport == null ? this.requestContent : this.requestMmSupport.getContentAsString();
    }

    @Override
    public byte[] getRawRequestData() {
        if (this.requestRaw != null) {
            return this.requestRaw;
        }
        return this.request;
    }

    public void setRawRequestData(byte[] data) {
        this.requestRaw = data;
    }

    @Override
    public byte[] getRawResponseData() {
        if (this.responseRaw == null) {
            return this.response;
        }
        return this.responseRaw;
    }

    public void setRawResponseData(byte[] data) {
        this.responseRaw = data;
    }

    @Override
    public StringToStringMap getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Attachment[] getResponseAttachments() {
        return this.requestMmSupport == null ? new Attachment[]{} : this.requestMmSupport.getAttachments();
    }

    @Override
    public String getResponseContent() {
        return this.responseContent;
    }

    @Override
    public StringToStringMap getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public long getTimeTaken() {
        return this.timestampEnd - this.timestampStart;
    }

    @Override
    public long getTimestamp() {
        return this.timestampStart;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded;
    }

    public void stopCapture() {
        this.timestampEnd = System.currentTimeMillis();
        this.capture = false;
    }

    public boolean isStopCapture() {
        return this.capture;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public byte[] getRawResponseBody() {
        return this.response;
    }

    public void setRawResponseBody(byte[] response) {
        this.response = response;
    }

    public void setResponseHeader(String name, String value) {
        this.responseHeaders.put(name, value);
    }

    public void setRequestHost(String serverName) {
        this.requestHost = serverName;
    }

    public void setTargetHost(String remoteHost) {
    }

    public void setRequestHeader(HttpServletRequest httpRequest) {
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration header = httpRequest.getHeaders(name);
            while (header.hasMoreElements()) {
                String value = (String)header.nextElement();
                if (value == null) continue;
                this.requestHeaders.put(name, value);
            }
        }
    }

    public void setTargetURL(String url) {
        try {
            this.targetURL = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getResponseStatusCode() {
        return 0;
    }

    @Override
    public String getResponseContentType() {
        return null;
    }

    public void setResponseHeader(HttpMethodBase method) {
        Header[] headers;
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (value == null) continue;
            this.responseHeaders.put(name, value);
        }
    }
}

